/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless;

import java.io.OutputStream;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.key.certification.CertifyCertificate;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeyRingTemplates;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.ArmorUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/PGPainless;", "", "()V", "Companion", "pgpainless-core"})
public final class PGPainless {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private PGPainless() {
    }

    @JvmStatic
    @NotNull
    public static final KeyRingTemplates generateKeyRing() {
        return Companion.generateKeyRing();
    }

    @JvmStatic
    @NotNull
    public static final KeyRingBuilder buildKeyRing() {
        return Companion.buildKeyRing();
    }

    @JvmStatic
    @NotNull
    public static final KeyRingReader readKeyRing() {
        return Companion.readKeyRing();
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKeyRing extractCertificate(@NotNull PGPSecretKeyRing secretKey) {
        return Companion.extractCertificate(secretKey);
    }

    @JvmStatic
    public static final PGPPublicKeyRing mergeCertificate(@NotNull PGPPublicKeyRing originalCopy, @NotNull PGPPublicKeyRing updatedCopy) {
        return Companion.mergeCertificate(originalCopy, updatedCopy);
    }

    @JvmStatic
    @NotNull
    public static final String asciiArmor(@NotNull PGPKeyRing key) {
        return Companion.asciiArmor(key);
    }

    @JvmStatic
    public static final void asciiArmor(@NotNull PGPKeyRing key, @NotNull OutputStream outputStream) {
        Companion.asciiArmor(key, outputStream);
    }

    @JvmStatic
    @NotNull
    public static final String asciiArmor(@NotNull PGPSignature signature) {
        return Companion.asciiArmor(signature);
    }

    @JvmStatic
    @NotNull
    public static final EncryptionBuilder encryptAndOrSign() {
        return Companion.encryptAndOrSign();
    }

    @JvmStatic
    @NotNull
    public static final DecryptionBuilder decryptAndOrVerify() {
        return Companion.decryptAndOrVerify();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey, @NotNull Date referenceTime) {
        return Companion.modifyKeyRing(secretKey, referenceTime);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key, @NotNull Date referenceTime) {
        return Companion.inspectKeyRing(key, referenceTime);
    }

    @JvmStatic
    @NotNull
    public static final Policy getPolicy() {
        return Companion.getPolicy();
    }

    @JvmStatic
    @NotNull
    public static final CertifyCertificate certify() {
        return Companion.certify();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey) {
        return Companion.modifyKeyRing(secretKey);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key) {
        return Companion.inspectKeyRing(key);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J \u0010 \u001a\n !*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0007J\u001a\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010&\u001a\u00020'H\u0007\u00a8\u0006("}, d2={"Lorg/pgpainless/PGPainless$Companion;", "", "()V", "asciiArmor", "", "key", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "", "outputStream", "Ljava/io/OutputStream;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "buildKeyRing", "Lorg/pgpainless/key/generation/KeyRingBuilder;", "certify", "Lorg/pgpainless/key/certification/CertifyCertificate;", "decryptAndOrVerify", "Lorg/pgpainless/decryption_verification/DecryptionBuilder;", "encryptAndOrSign", "Lorg/pgpainless/encryption_signing/EncryptionBuilder;", "extractCertificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "generateKeyRing", "Lorg/pgpainless/key/generation/KeyRingTemplates;", "getPolicy", "Lorg/pgpainless/policy/Policy;", "inspectKeyRing", "Lorg/pgpainless/key/info/KeyRingInfo;", "referenceTime", "Ljava/util/Date;", "mergeCertificate", "kotlin.jvm.PlatformType", "originalCopy", "updatedCopy", "modifyKeyRing", "Lorg/pgpainless/key/modification/secretkeyring/SecretKeyRingEditor;", "readKeyRing", "Lorg/pgpainless/key/parsing/KeyRingReader;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KeyRingTemplates generateKeyRing() {
            return new KeyRingTemplates();
        }

        @JvmStatic
        @NotNull
        public final KeyRingBuilder buildKeyRing() {
            return new KeyRingBuilder();
        }

        @JvmStatic
        @NotNull
        public final KeyRingReader readKeyRing() {
            return new KeyRingReader();
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKeyRing extractCertificate(@NotNull PGPSecretKeyRing secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return KeyRingUtils.Companion.publicKeyRingFrom(secretKey);
        }

        @JvmStatic
        public final PGPPublicKeyRing mergeCertificate(@NotNull PGPPublicKeyRing originalCopy, @NotNull PGPPublicKeyRing updatedCopy) {
            Intrinsics.checkNotNullParameter((Object)originalCopy, (String)"originalCopy");
            Intrinsics.checkNotNullParameter((Object)updatedCopy, (String)"updatedCopy");
            return PGPPublicKeyRing.join((PGPPublicKeyRing)originalCopy, (PGPPublicKeyRing)updatedCopy);
        }

        @JvmStatic
        @NotNull
        public final String asciiArmor(@NotNull PGPKeyRing key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return key instanceof PGPSecretKeyRing ? ArmorUtils.Companion.toAsciiArmoredString((PGPSecretKeyRing)key) : ArmorUtils.Companion.toAsciiArmoredString((PGPPublicKeyRing)key);
        }

        @JvmStatic
        public final void asciiArmor(@NotNull PGPKeyRing key, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            ArmoredOutputStream armorOut = ArmorUtils.Companion.toAsciiArmoredStream(key, outputStream);
            key.encode((OutputStream)armorOut);
            armorOut.close();
        }

        @JvmStatic
        @NotNull
        public final String asciiArmor(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            return ArmorUtils.Companion.toAsciiArmoredString$default(ArmorUtils.Companion, signature, false, 2, null);
        }

        @JvmStatic
        @NotNull
        public final EncryptionBuilder encryptAndOrSign() {
            return new EncryptionBuilder();
        }

        @JvmStatic
        @NotNull
        public final DecryptionBuilder decryptAndOrVerify() {
            return new DecryptionBuilder();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return new SecretKeyRingEditor(secretKey, referenceTime);
        }

        public static /* synthetic */ SecretKeyRingEditor modifyKeyRing$default(Companion companion, PGPSecretKeyRing pGPSecretKeyRing, Date date, int n, Object object) {
            if ((n & 2) != 0) {
                date = new Date();
            }
            return companion.modifyKeyRing(pGPSecretKeyRing, date);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return new KeyRingInfo(key, referenceTime);
        }

        public static /* synthetic */ KeyRingInfo inspectKeyRing$default(Companion companion, PGPKeyRing pGPKeyRing, Date date, int n, Object object) {
            if ((n & 2) != 0) {
                date = new Date();
            }
            return companion.inspectKeyRing(pGPKeyRing, date);
        }

        @JvmStatic
        @NotNull
        public final Policy getPolicy() {
            return Policy.Companion.getInstance();
        }

        @JvmStatic
        @NotNull
        public final CertifyCertificate certify() {
            return new CertifyCertificate();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return org.pgpainless.PGPainless$Companion.modifyKeyRing$default(this, secretKey, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return org.pgpainless.PGPainless$Companion.inspectKeyRing$default(this, key, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

