/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/algorithm/AlgorithmSuite;", "", "symmetricKeyAlgorithms", "", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "hashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "compressionAlgorithms", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "", "getCompressionAlgorithms", "()Ljava/util/Set;", "getHashAlgorithms", "getSymmetricKeyAlgorithms", "Companion", "pgpainless-core"})
public final class AlgorithmSuite {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<SymmetricKeyAlgorithm> symmetricKeyAlgorithms;
    @NotNull
    private final Set<HashAlgorithm> hashAlgorithms;
    @NotNull
    private final Set<CompressionAlgorithm> compressionAlgorithms;
    @NotNull
    private static final List<SymmetricKeyAlgorithm> defaultSymmetricKeyAlgorithms;
    @NotNull
    private static final List<HashAlgorithm> defaultHashAlgorithms;
    @NotNull
    private static final List<CompressionAlgorithm> defaultCompressionAlgorithms;
    @NotNull
    private static final AlgorithmSuite defaultAlgorithmSuite;

    public AlgorithmSuite(@NotNull List<? extends SymmetricKeyAlgorithm> symmetricKeyAlgorithms, @NotNull List<? extends HashAlgorithm> hashAlgorithms, @NotNull List<? extends CompressionAlgorithm> compressionAlgorithms2) {
        Intrinsics.checkNotNullParameter(symmetricKeyAlgorithms, (String)"symmetricKeyAlgorithms");
        Intrinsics.checkNotNullParameter(hashAlgorithms, (String)"hashAlgorithms");
        Intrinsics.checkNotNullParameter(compressionAlgorithms2, (String)"compressionAlgorithms");
        this.symmetricKeyAlgorithms = CollectionsKt.toSet((Iterable)symmetricKeyAlgorithms);
        this.hashAlgorithms = CollectionsKt.toSet((Iterable)hashAlgorithms);
        this.compressionAlgorithms = CollectionsKt.toSet((Iterable)compressionAlgorithms2);
    }

    @NotNull
    public final Set<SymmetricKeyAlgorithm> getSymmetricKeyAlgorithms() {
        return this.symmetricKeyAlgorithms;
    }

    @NotNull
    public final Set<HashAlgorithm> getHashAlgorithms() {
        return this.hashAlgorithms;
    }

    @NotNull
    public final Set<CompressionAlgorithm> getCompressionAlgorithms() {
        return this.compressionAlgorithms;
    }

    @NotNull
    public static final List<SymmetricKeyAlgorithm> getDefaultSymmetricKeyAlgorithms() {
        return Companion.getDefaultSymmetricKeyAlgorithms();
    }

    @NotNull
    public static final List<HashAlgorithm> getDefaultHashAlgorithms() {
        return Companion.getDefaultHashAlgorithms();
    }

    @NotNull
    public static final List<CompressionAlgorithm> getDefaultCompressionAlgorithms() {
        return Companion.getDefaultCompressionAlgorithms();
    }

    @NotNull
    public static final AlgorithmSuite getDefaultAlgorithmSuite() {
        return Companion.getDefaultAlgorithmSuite();
    }

    static {
        Enum[] enumArray = new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128};
        defaultSymmetricKeyAlgorithms = CollectionsKt.listOf((Object[])enumArray);
        enumArray = new HashAlgorithm[]{HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224};
        defaultHashAlgorithms = CollectionsKt.listOf((Object[])enumArray);
        enumArray = new CompressionAlgorithm[]{CompressionAlgorithm.ZLIB, CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZIP, CompressionAlgorithm.UNCOMPRESSED};
        defaultCompressionAlgorithms = CollectionsKt.listOf((Object[])enumArray);
        defaultAlgorithmSuite = new AlgorithmSuite(defaultSymmetricKeyAlgorithms, defaultHashAlgorithms, defaultCompressionAlgorithms);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\rR\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/algorithm/AlgorithmSuite$Companion;", "", "()V", "defaultAlgorithmSuite", "Lorg/pgpainless/algorithm/AlgorithmSuite;", "getDefaultAlgorithmSuite$annotations", "getDefaultAlgorithmSuite", "()Lorg/pgpainless/algorithm/AlgorithmSuite;", "defaultCompressionAlgorithms", "", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "getDefaultCompressionAlgorithms$annotations", "getDefaultCompressionAlgorithms", "()Ljava/util/List;", "defaultHashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "getDefaultHashAlgorithms$annotations", "getDefaultHashAlgorithms", "defaultSymmetricKeyAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getDefaultSymmetricKeyAlgorithms$annotations", "getDefaultSymmetricKeyAlgorithms", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<SymmetricKeyAlgorithm> getDefaultSymmetricKeyAlgorithms() {
            return defaultSymmetricKeyAlgorithms;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultSymmetricKeyAlgorithms$annotations() {
        }

        @NotNull
        public final List<HashAlgorithm> getDefaultHashAlgorithms() {
            return defaultHashAlgorithms;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultHashAlgorithms$annotations() {
        }

        @NotNull
        public final List<CompressionAlgorithm> getDefaultCompressionAlgorithms() {
            return defaultCompressionAlgorithms;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultCompressionAlgorithms$annotations() {
        }

        @NotNull
        public final AlgorithmSuite getDefaultAlgorithmSuite() {
            return defaultAlgorithmSuite;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultAlgorithmSuite$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

