/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.OutputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.encryption_signing.PGPHashContextContentSignerBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/pgpainless/encryption_signing/BcPGPHashContextContentSignerBuilder;", "Lorg/pgpainless/encryption_signing/PGPHashContextContentSignerBuilder;", "messageDigest", "Ljava/security/MessageDigest;", "(Ljava/security/MessageDigest;)V", "_hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "keyConverter", "Lorg/bouncycastle/openpgp/operator/bc/BcPGPKeyConverter;", "build", "Lorg/bouncycastle/openpgp/operator/PGPContentSigner;", "signatureType", "", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "Companion", "EdDsaSigner", "pgpainless-core"})
public final class BcPGPHashContextContentSignerBuilder
extends PGPHashContextContentSignerBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageDigest messageDigest;
    @NotNull
    private final BcPGPKeyConverter keyConverter;
    @NotNull
    private final HashAlgorithm _hashAlgorithm;

    public BcPGPHashContextContentSignerBuilder(@NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        this.messageDigest = messageDigest;
        this.keyConverter = new BcPGPKeyConverter();
        String string = this.messageDigest.getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageDigest.algorithm");
        this._hashAlgorithm = BcPGPHashContextContentSignerBuilder.Companion.requireFromName(string);
    }

    @NotNull
    public PGPContentSigner build(int signatureType, @NotNull PGPPrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        PublicKeyAlgorithm keyAlgorithm = PublicKeyAlgorithm.Companion.requireFromId(privateKey.getPublicKeyPacket().getAlgorithm());
        AsymmetricKeyParameter privKeyParam = this.keyConverter.getPrivateKey(privateKey);
        Intrinsics.checkNotNullExpressionValue((Object)privKeyParam, (String)"privKeyParam");
        Signer signer = BcPGPHashContextContentSignerBuilder.Companion.createSigner(keyAlgorithm, this.messageDigest, (CipherParameters)privKeyParam);
        signer.init(true, (CipherParameters)privKeyParam);
        return new PGPContentSigner(signer, this, signatureType, keyAlgorithm, privateKey){
            final /* synthetic */ Signer $signer;
            final /* synthetic */ BcPGPHashContextContentSignerBuilder this$0;
            final /* synthetic */ int $signatureType;
            final /* synthetic */ PublicKeyAlgorithm $keyAlgorithm;
            final /* synthetic */ PGPPrivateKey $privateKey;
            {
                this.$signer = $signer;
                this.this$0 = $receiver;
                this.$signatureType = $signatureType;
                this.$keyAlgorithm = $keyAlgorithm;
                this.$privateKey = $privateKey;
            }

            @NotNull
            public OutputStream getOutputStream() {
                return new PGPHashContextContentSignerBuilder.SignerOutputStream(this.$signer);
            }

            @NotNull
            public byte[] getSignature() {
                byte[] byArray;
                try {
                    byte[] byArray2 = this.$signer.generateSignature();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n                    si\u2026ature()\n                }");
                    byArray = byArray2;
                }
                catch (CryptoException e) {
                    throw new IllegalStateException("unable to create signature.", e);
                }
                return byArray;
            }

            @NotNull
            public byte[] getDigest() {
                byte[] byArray = BcPGPHashContextContentSignerBuilder.access$getMessageDigest$p(this.this$0).digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest()");
                return byArray;
            }

            public int getType() {
                return this.$signatureType;
            }

            public int getHashAlgorithm() {
                return BcPGPHashContextContentSignerBuilder.access$get_hashAlgorithm$p(this.this$0).getAlgorithmId();
            }

            public int getKeyAlgorithm() {
                return this.$keyAlgorithm.getAlgorithmId();
            }

            public long getKeyID() {
                return this.$privateKey.getKeyID();
            }
        };
    }

    @JvmStatic
    private static final HashAlgorithm requireFromName(String digestName) {
        return BcPGPHashContextContentSignerBuilder.Companion.requireFromName(digestName);
    }

    @JvmStatic
    private static final Signer createSigner(PublicKeyAlgorithm keyAlgorithm, MessageDigest messageDigest, CipherParameters keyParam) {
        return BcPGPHashContextContentSignerBuilder.Companion.createSigner(keyAlgorithm, messageDigest, keyParam);
    }

    public static final /* synthetic */ MessageDigest access$getMessageDigest$p(BcPGPHashContextContentSignerBuilder $this) {
        return $this.messageDigest;
    }

    public static final /* synthetic */ HashAlgorithm access$get_hashAlgorithm$p(BcPGPHashContextContentSignerBuilder $this) {
        return $this._hashAlgorithm;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/encryption_signing/BcPGPHashContextContentSignerBuilder$Companion;", "", "()V", "createSigner", "Lorg/bouncycastle/crypto/Signer;", "keyAlgorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "messageDigest", "Ljava/security/MessageDigest;", "keyParam", "Lorg/bouncycastle/crypto/CipherParameters;", "requireFromName", "Lorg/pgpainless/algorithm/HashAlgorithm;", "digestName", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nBcPGPHashContextContentSignerBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BcPGPHashContextContentSignerBuilder.kt\norg/pgpainless/encryption_signing/BcPGPHashContextContentSignerBuilder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final HashAlgorithm requireFromName(String digestName) {
            HashAlgorithm algorithm = HashAlgorithm.Companion.fromName(digestName);
            if (!(algorithm != null)) {
                boolean bl = false;
                String string = "Cannot recognize OpenPGP Hash Algorithm: " + digestName;
                throw new IllegalArgumentException(string.toString());
            }
            return algorithm;
        }

        @JvmStatic
        private final Signer createSigner(PublicKeyAlgorithm keyAlgorithm, MessageDigest messageDigest, CipherParameters keyParam) {
            Signer signer;
            PGPHashContextContentSignerBuilder.ExistingMessageDigest staticDigest = new PGPHashContextContentSignerBuilder.ExistingMessageDigest(messageDigest);
            switch (keyAlgorithm.getAlgorithmId()) {
                case 1: 
                case 3: {
                    signer = (Signer)new RSADigestSigner((Digest)staticDigest);
                    break;
                }
                case 17: {
                    signer = (Signer)new DSADigestSigner((DSA)new DSASigner(), (Digest)staticDigest);
                    break;
                }
                case 19: {
                    signer = (Signer)new DSADigestSigner((DSA)new ECDSASigner(), (Digest)staticDigest);
                    break;
                }
                case 22: {
                    signer = keyParam instanceof Ed25519PrivateKeyParameters || keyParam instanceof Ed25519PublicKeyParameters ? new EdDsaSigner((Signer)new Ed25519Signer(), staticDigest) : new EdDsaSigner((Signer)new Ed448Signer(new byte[0]), staticDigest);
                    break;
                }
                default: {
                    throw new PGPException("cannot recognize keyAlgorithm: " + (Object)((Object)keyAlgorithm));
                }
            }
            return signer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/encryption_signing/BcPGPHashContextContentSignerBuilder$EdDsaSigner;", "Lorg/bouncycastle/crypto/Signer;", "signer", "digest", "Lorg/bouncycastle/crypto/Digest;", "(Lorg/bouncycastle/crypto/Signer;Lorg/bouncycastle/crypto/Digest;)V", "digBuf", "", "generateSignature", "init", "", "forSigning", "", "param", "Lorg/bouncycastle/crypto/CipherParameters;", "reset", "update", "b", "", "off", "", "len", "verifySignature", "signature", "pgpainless-core"})
    public static final class EdDsaSigner
    implements Signer {
        @NotNull
        private final Signer signer;
        @NotNull
        private final Digest digest;
        @NotNull
        private final byte[] digBuf;

        public EdDsaSigner(@NotNull Signer signer, @NotNull Digest digest) {
            Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            this.signer = signer;
            this.digest = digest;
            this.digBuf = new byte[this.digest.getDigestSize()];
        }

        public void init(boolean forSigning, @NotNull CipherParameters param) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.signer.init(forSigning, param);
            this.digest.reset();
        }

        public void update(byte b) {
            this.digest.update(b);
        }

        public void update(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.digest.update(b, off, len);
        }

        @NotNull
        public byte[] generateSignature() {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            byte[] byArray = this.signer.generateSignature();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"signer.generateSignature()");
            return byArray;
        }

        public boolean verifySignature(@NotNull byte[] signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.verifySignature(signature);
        }

        public void reset() {
            ArraysKt.fill$default((byte[])this.digBuf, (byte)0, (int)0, (int)0, (int)6, null);
            this.signer.reset();
            this.digest.reset();
        }
    }
}

