/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.authentication.CertificateAuthenticity;
import org.pgpainless.authentication.CertificateAuthority;
import org.pgpainless.exception.KeyException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyAccessor;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\b\u0018\u0000 I2\u00020\u0001:\u0002IJB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u0013H\u0002J*\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u000203H\u0007J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\fJ\u001a\u00106\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u001cH\u0007J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u00020\u00002\u0006\u00108\u001a\u000209H\u0007J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0016\u0010;\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020<J\u001e\u0010;\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020<2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010;\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020)2\u0006\u0010(\u001a\u00020@2\u0006\u0010+\u001a\u00020\u0013H\u0002J\u0014\u0010A\u001a\u00020\u00002\f\u0010B\u001a\b\u0012\u0004\u0012\u00020)0CJ\u001c\u0010A\u001a\u00020\u00002\f\u0010B\u001a\b\u0012\u0004\u0012\u00020)0C2\u0006\u0010*\u001a\u00020\u001cJ\u0006\u0010D\u001a\u00020\u0013J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0007J\u0006\u0010G\u001a\u00020\u0000J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionOptions;", "", "()V", "purpose", "Lorg/pgpainless/algorithm/EncryptionPurpose;", "(Lorg/pgpainless/algorithm/EncryptionPurpose;)V", "_encryptionAlgorithmOverride", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "_encryptionKeyIdentifiers", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "_encryptionMethods", "Lorg/bouncycastle/openpgp/operator/PGPKeyEncryptionMethodGenerator;", "_keyRingInfo", "", "Lorg/pgpainless/key/info/KeyRingInfo;", "_keyViews", "Lorg/pgpainless/key/info/KeyAccessor;", "allowEncryptionWithMissingKeyFlags", "", "encryptionAlgorithmOverride", "getEncryptionAlgorithmOverride", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "encryptionKeyIdentifiers", "", "getEncryptionKeyIdentifiers", "()Ljava/util/Set;", "encryptionKeySelector", "Lorg/pgpainless/encryption_signing/EncryptionOptions$EncryptionKeySelector;", "encryptionMethods", "getEncryptionMethods", "evaluationDate", "Ljava/util/Date;", "keyRingInfo", "", "getKeyRingInfo", "()Ljava/util/Map;", "keyViews", "getKeyViews", "addAsRecipient", "key", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "selector", "wildcardKeyId", "addAuthenticatableRecipients", "userId", "", "email", "authority", "Lorg/pgpainless/authentication/CertificateAuthority;", "targetAmount", "", "addEncryptionMethod", "encryptionMethod", "addHiddenRecipient", "addMessagePassphrase", "passphrase", "Lorg/pgpainless/util/Passphrase;", "addPassphrase", "addRecipient", "", "addRecipientKey", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "addRecipients", "keys", "", "hasEncryptionMethod", "overrideEncryptionAlgorithm", "encryptionAlgorithm", "setAllowEncryptionWithMissingKeyFlags", "setEvaluationDate", "Companion", "EncryptionKeySelector", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nEncryptionOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionOptions.kt\norg/pgpainless/encryption_signing/EncryptionOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1#2:327\n766#3:328\n857#3,2:329\n1855#3,2:331\n1855#3,2:333\n1855#3,2:335\n766#3:337\n857#3,2:338\n766#3:340\n857#3,2:341\n*S KotlinDebug\n*F\n+ 1 EncryptionOptions.kt\norg/pgpainless/encryption_signing/EncryptionOptions\n*L\n83#1:328\n83#1:329,2\n84#1:331,2\n100#1:333,2\n116#1:335,2\n196#1:337\n196#1:338,2\n197#1:340\n197#1:341,2\n*E\n"})
public final class EncryptionOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncryptionPurpose purpose;
    @NotNull
    private final Set<PGPKeyEncryptionMethodGenerator> _encryptionMethods;
    @NotNull
    private final Set<SubkeyIdentifier> _encryptionKeyIdentifiers;
    @NotNull
    private final Map<SubkeyIdentifier, KeyRingInfo> _keyRingInfo;
    @NotNull
    private final Map<SubkeyIdentifier, KeyAccessor> _keyViews;
    @NotNull
    private final EncryptionKeySelector encryptionKeySelector;
    private boolean allowEncryptionWithMissingKeyFlags;
    @NotNull
    private Date evaluationDate;
    @Nullable
    private SymmetricKeyAlgorithm _encryptionAlgorithmOverride;

    public EncryptionOptions(@NotNull EncryptionPurpose purpose) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
        this.purpose = purpose;
        this._encryptionMethods = new LinkedHashSet();
        this._encryptionKeyIdentifiers = new LinkedHashSet();
        this._keyRingInfo = new LinkedHashMap();
        this._keyViews = new LinkedHashMap();
        this.encryptionKeySelector = Companion.encryptToAllCapableSubkeys();
        this.evaluationDate = new Date();
    }

    @NotNull
    public final Set<PGPKeyEncryptionMethodGenerator> getEncryptionMethods() {
        return CollectionsKt.toSet((Iterable)this._encryptionMethods);
    }

    @NotNull
    public final Set<SubkeyIdentifier> getEncryptionKeyIdentifiers() {
        return CollectionsKt.toSet((Iterable)this._encryptionKeyIdentifiers);
    }

    @NotNull
    public final Map<SubkeyIdentifier, KeyRingInfo> getKeyRingInfo() {
        return MapsKt.toMap(this._keyRingInfo);
    }

    @NotNull
    public final Map<SubkeyIdentifier, KeyAccessor> getKeyViews() {
        return MapsKt.toMap(this._keyViews);
    }

    @Nullable
    public final SymmetricKeyAlgorithm getEncryptionAlgorithmOverride() {
        return this._encryptionAlgorithmOverride;
    }

    public EncryptionOptions() {
        this(EncryptionPurpose.ANY);
    }

    @NotNull
    public final EncryptionOptions setEvaluationDate(@NotNull Date evaluationDate) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)evaluationDate, (String)"evaluationDate");
        EncryptionOptions $this$setEvaluationDate_u24lambda_u240 = encryptionOptions = this;
        boolean bl = false;
        $this$setEvaluationDate_u24lambda_u240.evaluationDate = evaluationDate;
        return encryptionOptions;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final EncryptionOptions addAuthenticatableRecipients(@NotNull String userId, boolean email, @NotNull CertificateAuthority authority, int targetAmount) {
        void $this$forEach$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        EncryptionOptions $this$addAuthenticatableRecipients_u24lambda_u245 = encryptionOptions = this;
        boolean bl = false;
        boolean foundAcceptable = false;
        Iterable iterable = authority.lookupByUserId(userId, email, $this$addAuthenticatableRecipients_u24lambda_u245.evaluationDate, targetAmount);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CertificateAuthenticity)element$iv$iv;
            boolean bl2 = false;
            if (!((CertificateAuthenticity)it).isAuthenticated()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CertificateAuthenticity it2 = (CertificateAuthenticity)element$iv;
            boolean bl3 = false;
            EncryptionOptions encryptionOptions2 = $this$addAuthenticatableRecipients_u24lambda_u245.addRecipient(it2.getCertificate());
            it = encryptionOptions2;
            boolean bl4 = false;
            foundAcceptable = true;
        }
        if (!foundAcceptable) {
            boolean bl5 = false;
            String string = "Could not identify any trust-worthy certificates for '" + userId + "' and target trust amount " + targetAmount + '.';
            throw new IllegalArgumentException(string.toString());
        }
        return encryptionOptions;
    }

    public static /* synthetic */ EncryptionOptions addAuthenticatableRecipients$default(EncryptionOptions encryptionOptions, String string, boolean bl, CertificateAuthority certificateAuthority, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 120;
        }
        return encryptionOptions.addAuthenticatableRecipients(string, bl, certificateAuthority, n);
    }

    @NotNull
    public final EncryptionOptions addRecipients(@NotNull Iterable<? extends PGPPublicKeyRing> keys) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        EncryptionOptions $this$addRecipients_u24lambda_u249 = encryptionOptions = this;
        boolean bl = false;
        List it = CollectionsKt.toList(keys);
        boolean bl2 = false;
        if (!(!((Collection)it).isEmpty())) {
            boolean $i$a$-require-EncryptionOptions$addRecipients$1$1$22 = false;
            String $i$a$-require-EncryptionOptions$addRecipients$1$1$22 = "Set of recipient keys cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-EncryptionOptions$addRecipients$1$1$22.toString());
        }
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPPublicKeyRing key = (PGPPublicKeyRing)element$iv;
            boolean bl3 = false;
            $this$addRecipients_u24lambda_u249.addRecipient(key);
        }
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions addRecipients(@NotNull Iterable<? extends PGPPublicKeyRing> keys, @NotNull EncryptionKeySelector selector) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        EncryptionOptions $this$addRecipients_u24lambda_u2413 = encryptionOptions = this;
        boolean bl = false;
        List it = CollectionsKt.toList(keys);
        boolean bl2 = false;
        if (!(!((Collection)it).isEmpty())) {
            boolean $i$a$-require-EncryptionOptions$addRecipients$2$1$22 = false;
            String $i$a$-require-EncryptionOptions$addRecipients$2$1$22 = "Set of recipient keys cannot be empty.";
            throw new IllegalArgumentException($i$a$-require-EncryptionOptions$addRecipients$2$1$22.toString());
        }
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPPublicKeyRing key = (PGPPublicKeyRing)element$iv;
            boolean bl3 = false;
            $this$addRecipients_u24lambda_u2413.addRecipient(key, selector);
        }
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addRecipient(key, this.encryptionKeySelector);
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key, @NotNull CharSequence userId) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.addRecipient(key, userId, this.encryptionKeySelector);
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key, @NotNull CharSequence userId, @NotNull EncryptionKeySelector encryptionKeySelector) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)encryptionKeySelector, (String)"encryptionKeySelector");
        EncryptionOptions $this$addRecipient_u24lambda_u2414 = encryptionOptions = this;
        boolean bl = false;
        KeyRingInfo info = new KeyRingInfo((PGPKeyRing)key, $this$addRecipient_u24lambda_u2414.evaluationDate);
        List<PGPPublicKey> subkeys = encryptionKeySelector.selectEncryptionSubkeys(info.getEncryptionSubkeys(userId, $this$addRecipient_u24lambda_u2414.purpose));
        if (subkeys.isEmpty()) {
            throw new KeyException.UnacceptableEncryptionKeyException(OpenPgpFingerprint.Companion.of((PGPKeyRing)key));
        }
        for (PGPPublicKey subkey : subkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier((PGPKeyRing)key, subkey.getKeyID());
            $this$addRecipient_u24lambda_u2414._keyRingInfo.put(keyId, info);
            $this$addRecipient_u24lambda_u2414._keyViews.put(keyId, new KeyAccessor.ViaUserId(info, keyId, ((Object)userId).toString()));
            $this$addRecipient_u24lambda_u2414.addRecipientKey(key, subkey, false);
        }
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions addRecipient(@NotNull PGPPublicKeyRing key, @NotNull EncryptionKeySelector encryptionKeySelector) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)encryptionKeySelector, (String)"encryptionKeySelector");
        EncryptionOptions $this$addRecipient_u24lambda_u2415 = encryptionOptions = this;
        boolean bl = false;
        $this$addRecipient_u24lambda_u2415.addAsRecipient(key, encryptionKeySelector, false);
        return encryptionOptions;
    }

    @JvmOverloads
    @NotNull
    public final EncryptionOptions addHiddenRecipient(@NotNull PGPPublicKeyRing key, @NotNull EncryptionKeySelector selector) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        EncryptionOptions $this$addHiddenRecipient_u24lambda_u2416 = encryptionOptions = this;
        boolean bl = false;
        $this$addHiddenRecipient_u24lambda_u2416.addAsRecipient(key, selector, true);
        return encryptionOptions;
    }

    public static /* synthetic */ EncryptionOptions addHiddenRecipient$default(EncryptionOptions encryptionOptions, PGPPublicKeyRing pGPPublicKeyRing, EncryptionKeySelector encryptionKeySelector, int n, Object object) {
        if ((n & 2) != 0) {
            encryptionKeySelector = encryptionOptions.encryptionKeySelector;
        }
        return encryptionOptions.addHiddenRecipient(pGPPublicKeyRing, encryptionKeySelector);
    }

    private final EncryptionOptions addAsRecipient(PGPPublicKeyRing key, EncryptionKeySelector selector, boolean wildcardKeyId) {
        Date date;
        EncryptionOptions encryptionOptions;
        EncryptionOptions $this$addAsRecipient_u24lambda_u2419 = encryptionOptions = this;
        boolean bl = false;
        KeyRingInfo info = new KeyRingInfo((PGPKeyRing)key, $this$addAsRecipient_u24lambda_u2419.evaluationDate);
        try {
            date = info.getPrimaryKeyExpirationDate();
        }
        catch (NoSuchElementException e) {
            throw new KeyException.UnacceptableSelfSignatureException(OpenPgpFingerprint.Companion.of((PGPKeyRing)key));
        }
        Date primaryKeyExpiration = date;
        if (primaryKeyExpiration != null && primaryKeyExpiration.compareTo($this$addAsRecipient_u24lambda_u2419.evaluationDate) < 0) {
            throw new KeyException.ExpiredKeyException(OpenPgpFingerprint.Companion.of((PGPKeyRing)key), primaryKeyExpiration);
        }
        List encryptionSubkeys = selector.selectEncryptionSubkeys(info.getEncryptionSubkeys($this$addAsRecipient_u24lambda_u2419.purpose));
        if (encryptionSubkeys.isEmpty() && $this$addAsRecipient_u24lambda_u2419.allowEncryptionWithMissingKeyFlags) {
            PGPPublicKey it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable e = info.getValidSubkeys();
            boolean $i$f$filter = false;
            void var12_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PGPPublicKey)element$iv$iv;
                boolean bl2 = false;
                if (!it.isEncryptionKey()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PGPPublicKey)element$iv$iv;
                boolean bl3 = false;
                if (!info.getKeyFlagsOf(it.getKeyID()).isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            encryptionSubkeys = (List)destination$iv$iv;
        }
        if (encryptionSubkeys.isEmpty()) {
            throw new KeyException.UnacceptableEncryptionKeyException(OpenPgpFingerprint.Companion.of((PGPKeyRing)key));
        }
        for (PGPPublicKey subkey : encryptionSubkeys) {
            SubkeyIdentifier keyId = new SubkeyIdentifier((PGPKeyRing)key, subkey.getKeyID());
            $this$addAsRecipient_u24lambda_u2419._keyRingInfo.put(keyId, info);
            $this$addAsRecipient_u24lambda_u2419._keyViews.put(keyId, new KeyAccessor.ViaKeyId(info, keyId));
            $this$addAsRecipient_u24lambda_u2419.addRecipientKey(key, subkey, wildcardKeyId);
        }
        return encryptionOptions;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRecipientKey(PGPPublicKeyRing certificate, PGPPublicKey key, boolean wildcardKeyId) {
        void it;
        PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator;
        this._encryptionKeyIdentifiers.add(new SubkeyIdentifier((PGPKeyRing)certificate, key.getKeyID()));
        PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator2 = publicKeyKeyEncryptionMethodGenerator = ImplementationFactory.Companion.getInstance().getPublicKeyKeyEncryptionMethodGenerator(key);
        EncryptionOptions encryptionOptions = this;
        boolean bl = false;
        it.setUseWildcardKeyID(wildcardKeyId);
        encryptionOptions.addEncryptionMethod((PGPKeyEncryptionMethodGenerator)publicKeyKeyEncryptionMethodGenerator);
    }

    @Deprecated(message="Deprecated in favor of addMessagePassphrase", replaceWith=@ReplaceWith(expression="addMessagePassphrase(passphrase)", imports={}))
    @NotNull
    public final EncryptionOptions addPassphrase(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return this.addMessagePassphrase(passphrase);
    }

    @NotNull
    public final EncryptionOptions addMessagePassphrase(@NotNull Passphrase passphrase) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        EncryptionOptions $this$addMessagePassphrase_u24lambda_u2422 = encryptionOptions = this;
        boolean bl = false;
        if (!(!passphrase.isEmpty())) {
            boolean bl2 = false;
            String string = "Passphrase MUST NOT be empty.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$addMessagePassphrase_u24lambda_u2422.addEncryptionMethod((PGPKeyEncryptionMethodGenerator)ImplementationFactory.Companion.getInstance().getPBEKeyEncryptionMethodGenerator(passphrase));
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions addEncryptionMethod(@NotNull PGPKeyEncryptionMethodGenerator encryptionMethod) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        EncryptionOptions $this$addEncryptionMethod_u24lambda_u2423 = encryptionOptions = this;
        boolean bl = false;
        $this$addEncryptionMethod_u24lambda_u2423._encryptionMethods.add(encryptionMethod);
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions overrideEncryptionAlgorithm(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm) {
        EncryptionOptions encryptionOptions;
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionAlgorithm), (String)"encryptionAlgorithm");
        EncryptionOptions $this$overrideEncryptionAlgorithm_u24lambda_u2425 = encryptionOptions = this;
        boolean bl = false;
        if (!(encryptionAlgorithm != SymmetricKeyAlgorithm.NULL)) {
            boolean bl2 = false;
            String string = "Encryption algorithm override cannot be NULL.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$overrideEncryptionAlgorithm_u24lambda_u2425._encryptionAlgorithmOverride = encryptionAlgorithm;
        return encryptionOptions;
    }

    @NotNull
    public final EncryptionOptions setAllowEncryptionWithMissingKeyFlags() {
        EncryptionOptions encryptionOptions;
        EncryptionOptions $this$setAllowEncryptionWithMissingKeyFlags_u24lambda_u2426 = encryptionOptions = this;
        boolean bl = false;
        $this$setAllowEncryptionWithMissingKeyFlags_u24lambda_u2426.allowEncryptionWithMissingKeyFlags = true;
        return encryptionOptions;
    }

    public final boolean hasEncryptionMethod() {
        return !((Collection)this._encryptionMethods).isEmpty();
    }

    @JvmOverloads
    @NotNull
    public final EncryptionOptions addAuthenticatableRecipients(@NotNull String userId, boolean email, @NotNull CertificateAuthority authority) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return EncryptionOptions.addAuthenticatableRecipients$default(this, userId, email, authority, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final EncryptionOptions addHiddenRecipient(@NotNull PGPPublicKeyRing key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return EncryptionOptions.addHiddenRecipient$default(this, key, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final EncryptionOptions get() {
        return Companion.get();
    }

    @JvmStatic
    @NotNull
    public static final EncryptionOptions encryptCommunications() {
        return Companion.encryptCommunications();
    }

    @JvmStatic
    @NotNull
    public static final EncryptionOptions encryptDataAtRest() {
        return Companion.encryptDataAtRest();
    }

    @JvmStatic
    @NotNull
    public static final EncryptionKeySelector encryptToFirstSubkey() {
        return Companion.encryptToFirstSubkey();
    }

    @JvmStatic
    @NotNull
    public static final EncryptionKeySelector encryptToAllCapableSubkeys() {
        return Companion.encryptToAllCapableSubkeys();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionOptions$Companion;", "", "()V", "encryptCommunications", "Lorg/pgpainless/encryption_signing/EncryptionOptions;", "encryptDataAtRest", "encryptToAllCapableSubkeys", "Lorg/pgpainless/encryption_signing/EncryptionOptions$EncryptionKeySelector;", "encryptToFirstSubkey", "get", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nEncryptionOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionOptions.kt\norg/pgpainless/encryption_signing/EncryptionOptions$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EncryptionOptions get() {
            return new EncryptionOptions();
        }

        @JvmStatic
        @NotNull
        public final EncryptionOptions encryptCommunications() {
            return new EncryptionOptions(EncryptionPurpose.COMMUNICATIONS);
        }

        @JvmStatic
        @NotNull
        public final EncryptionOptions encryptDataAtRest() {
            return new EncryptionOptions(EncryptionPurpose.STORAGE);
        }

        @JvmStatic
        @NotNull
        public final EncryptionKeySelector encryptToFirstSubkey() {
            return Companion::encryptToFirstSubkey$lambda$1;
        }

        @JvmStatic
        @NotNull
        public final EncryptionKeySelector encryptToAllCapableSubkeys() {
            return Companion::encryptToAllCapableSubkeys$lambda$2;
        }

        private static final List encryptToFirstSubkey$lambda$1(List encryptionCapableKeys) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)encryptionCapableKeys, (String)"encryptionCapableKeys");
                    object = (PGPPublicKey)CollectionsKt.firstOrNull((List)encryptionCapableKeys);
                    if (object == null) break block2;
                    PGPPublicKey it = object;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)it);
                    object = list;
                    if (list != null) break block3;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        private static final List encryptToAllCapableSubkeys$lambda$2(List encryptionCapableKeys) {
            Intrinsics.checkNotNullParameter((Object)encryptionCapableKeys, (String)"encryptionCapableKeys");
            return encryptionCapableKeys;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionOptions$EncryptionKeySelector;", "", "selectEncryptionSubkeys", "", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "encryptionCapableKeys", "pgpainless-core"})
    public static interface EncryptionKeySelector {
        @NotNull
        public List<PGPPublicKey> selectEncryptionSubkeys(@NotNull List<? extends PGPPublicKey> var1);
    }
}

