/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.util.Arrays;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpecBuilder;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/pgpainless/key/generation/KeySpec;", "", "keyType", "Lorg/pgpainless/key/generation/type/KeyType;", "subpacketGenerator", "Lorg/pgpainless/signature/subpackets/SignatureSubpackets;", "isInheritedSubPackets", "", "keyCreationDate", "Ljava/util/Date;", "(Lorg/pgpainless/key/generation/type/KeyType;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;ZLjava/util/Date;)V", "()Z", "getKeyCreationDate", "()Ljava/util/Date;", "getKeyType", "()Lorg/pgpainless/key/generation/type/KeyType;", "getSubpacketGenerator", "()Lorg/pgpainless/signature/subpackets/SignatureSubpackets;", "subpackets", "Lorg/bouncycastle/openpgp/PGPSignatureSubpacketVector;", "getSubpackets", "()Lorg/bouncycastle/openpgp/PGPSignatureSubpacketVector;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "pgpainless-core"})
public final class KeySpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyType keyType;
    @NotNull
    private final SignatureSubpackets subpacketGenerator;
    private final boolean isInheritedSubPackets;
    @Nullable
    private final Date keyCreationDate;

    public KeySpec(@NotNull KeyType keyType, @NotNull SignatureSubpackets subpacketGenerator, boolean isInheritedSubPackets, @Nullable Date keyCreationDate) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)subpacketGenerator, (String)"subpacketGenerator");
        this.keyType = keyType;
        this.subpacketGenerator = subpacketGenerator;
        this.isInheritedSubPackets = isInheritedSubPackets;
        this.keyCreationDate = keyCreationDate;
    }

    @NotNull
    public final KeyType getKeyType() {
        return this.keyType;
    }

    @NotNull
    public final SignatureSubpackets getSubpacketGenerator() {
        return this.subpacketGenerator;
    }

    public final boolean isInheritedSubPackets() {
        return this.isInheritedSubPackets;
    }

    @Nullable
    public final Date getKeyCreationDate() {
        return this.keyCreationDate;
    }

    @NotNull
    public final PGPSignatureSubpacketVector getSubpackets() {
        return SignatureSubpacketsHelper.Companion.toVector(this.subpacketGenerator);
    }

    @NotNull
    public final KeyType component1() {
        return this.keyType;
    }

    @NotNull
    public final SignatureSubpackets component2() {
        return this.subpacketGenerator;
    }

    public final boolean component3() {
        return this.isInheritedSubPackets;
    }

    @Nullable
    public final Date component4() {
        return this.keyCreationDate;
    }

    @NotNull
    public final KeySpec copy(@NotNull KeyType keyType, @NotNull SignatureSubpackets subpacketGenerator, boolean isInheritedSubPackets, @Nullable Date keyCreationDate) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)subpacketGenerator, (String)"subpacketGenerator");
        return new KeySpec(keyType, subpacketGenerator, isInheritedSubPackets, keyCreationDate);
    }

    public static /* synthetic */ KeySpec copy$default(KeySpec keySpec, KeyType keyType, SignatureSubpackets signatureSubpackets, boolean bl, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            keyType = keySpec.keyType;
        }
        if ((n & 2) != 0) {
            signatureSubpackets = keySpec.subpacketGenerator;
        }
        if ((n & 4) != 0) {
            bl = keySpec.isInheritedSubPackets;
        }
        if ((n & 8) != 0) {
            date = keySpec.keyCreationDate;
        }
        return keySpec.copy(keyType, signatureSubpackets, bl, date);
    }

    @NotNull
    public String toString() {
        return "KeySpec(keyType=" + this.keyType + ", subpacketGenerator=" + this.subpacketGenerator + ", isInheritedSubPackets=" + this.isInheritedSubPackets + ", keyCreationDate=" + this.keyCreationDate + ')';
    }

    public int hashCode() {
        int result = this.keyType.hashCode();
        result = result * 31 + this.subpacketGenerator.hashCode();
        int n = this.isInheritedSubPackets ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + (this.keyCreationDate == null ? 0 : this.keyCreationDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeySpec)) {
            return false;
        }
        KeySpec keySpec = (KeySpec)other;
        if (!Intrinsics.areEqual((Object)this.keyType, (Object)keySpec.keyType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subpacketGenerator, (Object)keySpec.subpacketGenerator)) {
            return false;
        }
        if (this.isInheritedSubPackets != keySpec.isInheritedSubPackets) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyCreationDate, (Object)keySpec.keyCreationDate);
    }

    @JvmStatic
    @NotNull
    public static final KeySpecBuilder getBuilder(@NotNull KeyType type, KeyFlag ... flags) {
        return Companion.getBuilder(type, flags);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0007\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/key/generation/KeySpec$Companion;", "", "()V", "getBuilder", "Lorg/pgpainless/key/generation/KeySpecBuilder;", "type", "Lorg/pgpainless/key/generation/type/KeyType;", "flags", "", "Lorg/pgpainless/algorithm/KeyFlag;", "(Lorg/pgpainless/key/generation/type/KeyType;[Lorg/pgpainless/algorithm/KeyFlag;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KeySpecBuilder getBuilder(@NotNull KeyType type, KeyFlag ... flags) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
            return new KeySpecBuilder(type, Arrays.copyOf(flags, flags.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

