/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import openpgp.LongExtensionsKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.exception.KeyIntegrityException;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.PublicKeyParameterValidationUtil;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/key/protection/UnlockSecretKey;", "", "()V", "Companion", "pgpainless-core"})
public final class UnlockSecretKey {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector) throws PGPException, KeyIntegrityException {
        return Companion.unlockSecretKey(secretKey, protector);
    }

    @JvmStatic
    @NotNull
    public static final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable PBESecretKeyDecryptor decryptor) throws PGPException {
        return Companion.unlockSecretKey(secretKey, decryptor);
    }

    @JvmStatic
    @NotNull
    public static final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable Passphrase passphrase) {
        return Companion.unlockSecretKey(secretKey, passphrase);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\r"}, d2={"Lorg/pgpainless/key/protection/UnlockSecretKey$Companion;", "", "()V", "unlockSecretKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "decryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @NotNull SecretKeyRingProtector protector) throws PGPException, KeyIntegrityException {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            return PGPSecretKeyExtensionsKt.isEncrypted(secretKey) ? this.unlockSecretKey(secretKey, protector.getDecryptor(secretKey.getKeyID())) : this.unlockSecretKey(secretKey, (PBESecretKeyDecryptor)null);
        }

        @JvmStatic
        @NotNull
        public final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable PBESecretKeyDecryptor decryptor) throws PGPException {
            PGPPrivateKey pGPPrivateKey;
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            try {
                pGPPrivateKey = secretKey.extractPrivateKey(decryptor);
            }
            catch (PGPException e) {
                throw new WrongPassphraseException(secretKey.getKeyID(), e);
            }
            PGPPrivateKey privateKey = pGPPrivateKey;
            if (privateKey == null) {
                int n = secretKey.getS2K().getType();
                boolean bl = 100 <= n ? n < 111 : false;
                if (bl) {
                    throw new PGPException("Cannot decrypt secret key " + LongExtensionsKt.openPgpKeyId(secretKey.getKeyID()) + ": \nUnsupported private S2K type " + secretKey.getS2K().getType());
                }
                throw new PGPException("Cannot decrypt secret key.");
            }
            if (PGPainless.Companion.getPolicy().isEnableKeyParameterValidation()) {
                PGPPublicKey pGPPublicKey = secretKey.getPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"secretKey.publicKey");
                PublicKeyParameterValidationUtil.Companion.verifyPublicKeyParameterIntegrity(privateKey, pGPPublicKey);
            }
            return privateKey;
        }

        @JvmStatic
        @NotNull
        public final PGPPrivateKey unlockSecretKey(@NotNull PGPSecretKey secretKey, @Nullable Passphrase passphrase) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return passphrase == null ? this.unlockSecretKey(secretKey, SecretKeyRingProtector.Companion.unprotectedKeys()) : this.unlockSecretKey(secretKey, SecretKeyRingProtector.Companion.unlockSingleKeyWith(passphrase, secretKey));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

