/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 \u000b2\u00020\u0001:\u0005\u000b\f\r\u000e\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/key/util/RevocationAttributes;", "", "reason", "Lorg/pgpainless/key/util/RevocationAttributes$Reason;", "description", "", "(Lorg/pgpainless/key/util/RevocationAttributes$Reason;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getReason", "()Lorg/pgpainless/key/util/RevocationAttributes$Reason;", "Companion", "Reason", "RevocationType", "WithDescription", "WithReason", "pgpainless-core"})
public final class RevocationAttributes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Reason reason;
    @NotNull
    private final String description;

    public RevocationAttributes(@NotNull Reason reason, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.reason = reason;
        this.description = description;
    }

    @NotNull
    public final Reason getReason() {
        return this.reason;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @JvmStatic
    @NotNull
    public static final WithReason createKeyRevocation() {
        return Companion.createKeyRevocation();
    }

    @JvmStatic
    @NotNull
    public static final WithReason createCertificateRevocation() {
        return Companion.createCertificateRevocation();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/pgpainless/key/util/RevocationAttributes$Companion;", "", "()V", "createCertificateRevocation", "Lorg/pgpainless/key/util/RevocationAttributes$WithReason;", "createKeyRevocation", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WithReason createKeyRevocation() {
            return new WithReason(RevocationType.KEY_REVOCATION);
        }

        @JvmStatic
        @NotNull
        public final WithReason createCertificateRevocation() {
            return new WithReason(RevocationType.CERT_REVOCATION);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/key/util/RevocationAttributes$Reason;", "", "code", "", "(Ljava/lang/String;IB)V", "getCode", "()B", "toString", "", "NO_REASON", "KEY_SUPERSEDED", "KEY_COMPROMISED", "KEY_RETIRED", "USER_ID_NO_LONGER_VALID", "Companion", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nRevocationAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevocationAttributes.kt\norg/pgpainless/key/util/RevocationAttributes$Reason\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,155:1\n8811#2,2:156\n9071#2,4:158\n*S KotlinDebug\n*F\n+ 1 RevocationAttributes.kt\norg/pgpainless/key/util/RevocationAttributes$Reason\n*L\n55#1:156,2\n55#1:158,4\n*E\n"})
    public static final class Reason
    extends Enum<Reason> {
        @NotNull
        public static final Companion Companion;
        private final byte code;
        @NotNull
        private static final Map<Byte, Reason> MAP;
        public static final /* enum */ Reason NO_REASON;
        public static final /* enum */ Reason KEY_SUPERSEDED;
        public static final /* enum */ Reason KEY_COMPROMISED;
        public static final /* enum */ Reason KEY_RETIRED;
        public static final /* enum */ Reason USER_ID_NO_LONGER_VALID;
        private static final /* synthetic */ Reason[] $VALUES;

        private Reason(byte code) {
            this.code = code;
        }

        public final byte getCode() {
            return this.code;
        }

        public final byte code() {
            return this.code;
        }

        @NotNull
        public String toString() {
            return this.code + " - " + this.name();
        }

        public static Reason[] values() {
            return (Reason[])$VALUES.clone();
        }

        public static Reason valueOf(String value) {
            return Enum.valueOf(Reason.class, value);
        }

        @JvmStatic
        @NotNull
        public static final Reason fromCode(byte code) {
            return Companion.fromCode(code);
        }

        @JvmStatic
        public static final boolean isHardRevocation(byte code) {
            return Companion.isHardRevocation(code);
        }

        @JvmStatic
        public static final boolean isHardRevocation(@NotNull Reason reason) {
            return Companion.isHardRevocation(reason);
        }

        @JvmStatic
        public static final boolean isKeyRevocation(byte code) {
            return Companion.isKeyRevocation(code);
        }

        @JvmStatic
        public static final boolean isKeyRevocation(@NotNull Reason reason) {
            return Companion.isKeyRevocation(reason);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            NO_REASON = new Reason(0);
            KEY_SUPERSEDED = new Reason(1);
            KEY_COMPROMISED = new Reason(2);
            KEY_RETIRED = new Reason(3);
            USER_ID_NO_LONGER_VALID = new Reason(32);
            $VALUES = reasonArray = new Reason[]{Reason.NO_REASON, Reason.KEY_SUPERSEDED, Reason.KEY_COMPROMISED, Reason.KEY_RETIRED, Reason.USER_ID_NO_LONGER_VALID};
            Companion = new Companion(null);
            Reason[] $this$associateBy$iv = Reason.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Reason[] reasonArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.code, element$iv$iv);
            }
            MAP = destination$iv$iv;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007R\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/key/util/RevocationAttributes$Reason$Companion;", "", "()V", "MAP", "", "", "Lorg/pgpainless/key/util/RevocationAttributes$Reason;", "getMAP$annotations", "fromCode", "code", "isHardRevocation", "", "reason", "isKeyRevocation", "pgpainless-core"})
        @SourceDebugExtension(value={"SMAP\nRevocationAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevocationAttributes.kt\norg/pgpainless/key/util/RevocationAttributes$Reason$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            private static /* synthetic */ void getMAP$annotations() {
            }

            @JvmStatic
            @NotNull
            public final Reason fromCode(byte code) {
                Reason reason = (Reason)((Object)MAP.get(code));
                if (reason == null) {
                    throw new IllegalArgumentException("Invalid revocation reason: " + code);
                }
                return reason;
            }

            @JvmStatic
            public final boolean isHardRevocation(byte code) {
                boolean bl;
                Reason reason = (Reason)((Object)MAP.get(code));
                if (reason != null) {
                    Reason it = reason;
                    boolean bl2 = false;
                    bl = Companion.isHardRevocation(it);
                } else {
                    bl = true;
                }
                return bl;
            }

            @JvmStatic
            public final boolean isHardRevocation(@NotNull Reason reason) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
                switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                return bl;
            }

            @JvmStatic
            public final boolean isKeyRevocation(byte code) {
                boolean bl;
                Reason reason = (Reason)((Object)MAP.get(code));
                if (reason != null) {
                    Reason it = reason;
                    boolean bl2 = false;
                    bl = Companion.isKeyRevocation(it);
                } else {
                    bl = false;
                }
                return bl;
            }

            @JvmStatic
            public final boolean isKeyRevocation(@NotNull Reason reason) {
                Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
                return WhenMappings.$EnumSwitchMapping$0[reason.ordinal()] != 3;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Reason.values().length];
                    try {
                        nArray[Reason.KEY_SUPERSEDED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Reason.KEY_RETIRED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Reason.USER_ID_NO_LONGER_VALID.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/key/util/RevocationAttributes$RevocationType;", "", "(Ljava/lang/String;I)V", "KEY_REVOCATION", "CERT_REVOCATION", "pgpainless-core"})
    public static final class RevocationType
    extends Enum<RevocationType> {
        public static final /* enum */ RevocationType KEY_REVOCATION = new RevocationType();
        public static final /* enum */ RevocationType CERT_REVOCATION = new RevocationType();
        private static final /* synthetic */ RevocationType[] $VALUES;

        public static RevocationType[] values() {
            return (RevocationType[])$VALUES.clone();
        }

        public static RevocationType valueOf(String value) {
            return Enum.valueOf(RevocationType.class, value);
        }

        static {
            $VALUES = revocationTypeArray = new RevocationType[]{RevocationType.KEY_REVOCATION, RevocationType.CERT_REVOCATION};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/pgpainless/key/util/RevocationAttributes$WithDescription;", "", "reason", "Lorg/pgpainless/key/util/RevocationAttributes$Reason;", "(Lorg/pgpainless/key/util/RevocationAttributes$Reason;)V", "getReason", "()Lorg/pgpainless/key/util/RevocationAttributes$Reason;", "withDescription", "Lorg/pgpainless/key/util/RevocationAttributes;", "description", "", "withoutDescription", "pgpainless-core"})
    public static final class WithDescription {
        @NotNull
        private final Reason reason;

        public WithDescription(@NotNull Reason reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            this.reason = reason;
        }

        @NotNull
        public final Reason getReason() {
            return this.reason;
        }

        @NotNull
        public final RevocationAttributes withDescription(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new RevocationAttributes(this.reason, description);
        }

        @NotNull
        public final RevocationAttributes withoutDescription() {
            return new RevocationAttributes(this.reason, "");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/pgpainless/key/util/RevocationAttributes$WithReason;", "", "type", "Lorg/pgpainless/key/util/RevocationAttributes$RevocationType;", "(Lorg/pgpainless/key/util/RevocationAttributes$RevocationType;)V", "getType", "()Lorg/pgpainless/key/util/RevocationAttributes$RevocationType;", "reasonTypeMatches", "", "reason", "Lorg/pgpainless/key/util/RevocationAttributes$Reason;", "withReason", "Lorg/pgpainless/key/util/RevocationAttributes$WithDescription;", "pgpainless-core"})
    public static final class WithReason {
        @NotNull
        private final RevocationType type;

        public WithReason(@NotNull RevocationType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
        }

        @NotNull
        public final RevocationType getType() {
            return this.type;
        }

        @NotNull
        public final WithDescription withReason(@NotNull Reason reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            if (!this.reasonTypeMatches(reason, this.type)) {
                boolean bl = false;
                String string = "Reason " + (Object)((Object)reason) + " can only be used for " + (this.type == RevocationType.KEY_REVOCATION ? "certificate" : "key") + " revocations.";
                throw new IllegalArgumentException(string.toString());
            }
            return new WithDescription(reason);
        }

        private final boolean reasonTypeMatches(Reason reason, RevocationType type) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (reason != Reason.USER_ID_NO_LONGER_VALID) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (reason == Reason.USER_ID_NO_LONGER_VALID || reason == Reason.NO_REASON) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RevocationType.values().length];
                try {
                    nArray[RevocationType.KEY_REVOCATION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RevocationType.CERT_REVOCATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

