/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 7*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u00017B7\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fB\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012B5\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\n\u0012\u0006\u0010\u0018\u001a\u00020\u0004\u0012\u0006\u0010\u0019\u001a\u00020\f\u0012\u0006\u0010\u001a\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001bJ\b\u00100\u001a\u000201H\u0004J\u0013\u00102\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u00103J\u0013\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u00020\u0004\u00a2\u0006\u0002\u00106R\u001a\u0010\u0017\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0019\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\u0018\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010\u001a\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001dR\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "B", "", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SignatureSubpackets;", "unhashedSubpackets", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/algorithm/HashAlgorithm;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;)V", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "archetypeSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;)V", "privateSigningKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "publicSigningKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "_hashAlgorithm", "_signatureType", "_hashedSubpackets", "_unhashedSubpackets", "(Lorg/bouncycastle/openpgp/PGPPrivateKey;Lorg/bouncycastle/openpgp/PGPPublicKey;Lorg/pgpainless/algorithm/HashAlgorithm;Lorg/pgpainless/algorithm/SignatureType;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;Lorg/pgpainless/signature/subpackets/SignatureSubpackets;)V", "get_hashAlgorithm", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "set_hashAlgorithm", "(Lorg/pgpainless/algorithm/HashAlgorithm;)V", "get_hashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SignatureSubpackets;", "get_signatureType", "()Lorg/pgpainless/algorithm/SignatureType;", "set_signatureType", "(Lorg/pgpainless/algorithm/SignatureType;)V", "get_unhashedSubpackets", "getHashAlgorithm", "getPrivateSigningKey", "()Lorg/bouncycastle/openpgp/PGPPrivateKey;", "getPublicSigningKey", "()Lorg/bouncycastle/openpgp/PGPPublicKey;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "buildAndInitSignatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "overrideHashAlgorithm", "(Lorg/pgpainless/algorithm/HashAlgorithm;)Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "setSignatureType", "type", "(Lorg/pgpainless/algorithm/SignatureType;)Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nAbstractSignatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSignatureBuilder.kt\norg/pgpainless/signature/builder/AbstractSignatureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public abstract class AbstractSignatureBuilder<B extends AbstractSignatureBuilder<B>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPPrivateKey privateSigningKey;
    @NotNull
    private final PGPPublicKey publicSigningKey;
    @NotNull
    private HashAlgorithm _hashAlgorithm;
    @NotNull
    private SignatureType _signatureType;
    @NotNull
    private final SignatureSubpackets _hashedSubpackets;
    @NotNull
    private final SignatureSubpackets _unhashedSubpackets;
    @NotNull
    private final HashAlgorithm hashAlgorithm;

    public AbstractSignatureBuilder(@NotNull PGPPrivateKey privateSigningKey, @NotNull PGPPublicKey publicSigningKey, @NotNull HashAlgorithm _hashAlgorithm, @NotNull SignatureType _signatureType, @NotNull SignatureSubpackets _hashedSubpackets, @NotNull SignatureSubpackets _unhashedSubpackets) {
        Intrinsics.checkNotNullParameter((Object)privateSigningKey, (String)"privateSigningKey");
        Intrinsics.checkNotNullParameter((Object)publicSigningKey, (String)"publicSigningKey");
        Intrinsics.checkNotNullParameter((Object)((Object)_hashAlgorithm), (String)"_hashAlgorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)_signatureType), (String)"_signatureType");
        Intrinsics.checkNotNullParameter((Object)_hashedSubpackets, (String)"_hashedSubpackets");
        Intrinsics.checkNotNullParameter((Object)_unhashedSubpackets, (String)"_unhashedSubpackets");
        this.privateSigningKey = privateSigningKey;
        this.publicSigningKey = publicSigningKey;
        this._hashAlgorithm = _hashAlgorithm;
        this._signatureType = _signatureType;
        this._hashedSubpackets = _hashedSubpackets;
        this._unhashedSubpackets = _unhashedSubpackets;
        if (!this.getSignatureTypePredicate().test(this._signatureType)) {
            boolean bl = false;
            String string = "Invalid signature type.";
            throw new IllegalArgumentException(string.toString());
        }
        this.hashAlgorithm = this._hashAlgorithm;
    }

    @NotNull
    protected final PGPPrivateKey getPrivateSigningKey() {
        return this.privateSigningKey;
    }

    @NotNull
    protected final PGPPublicKey getPublicSigningKey() {
        return this.publicSigningKey;
    }

    @NotNull
    protected final HashAlgorithm get_hashAlgorithm() {
        return this._hashAlgorithm;
    }

    protected final void set_hashAlgorithm(@NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"<set-?>");
        this._hashAlgorithm = hashAlgorithm;
    }

    @NotNull
    protected final SignatureType get_signatureType() {
        return this._signatureType;
    }

    protected final void set_signatureType(@NotNull SignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"<set-?>");
        this._signatureType = signatureType;
    }

    @NotNull
    protected final SignatureSubpackets get_hashedSubpackets() {
        return this._hashedSubpackets;
    }

    @NotNull
    protected final SignatureSubpackets get_unhashedSubpackets() {
        return this._unhashedSubpackets;
    }

    @NotNull
    protected abstract Predicate<SignatureType> getSignatureTypePredicate();

    protected AbstractSignatureBuilder(@NotNull SignatureType signatureType, @NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull HashAlgorithm hashAlgorithm, @NotNull SignatureSubpackets hashedSubpackets, @NotNull SignatureSubpackets unhashedSubpackets) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkNotNullParameter((Object)hashedSubpackets, (String)"hashedSubpackets");
        Intrinsics.checkNotNullParameter((Object)unhashedSubpackets, (String)"unhashedSubpackets");
        PGPPrivateKey pGPPrivateKey = UnlockSecretKey.Companion.unlockSecretKey(signingKey, protector);
        PGPPublicKey pGPPublicKey = signingKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"signingKey.publicKey");
        this(pGPPrivateKey, pGPPublicKey, hashAlgorithm, signatureType, hashedSubpackets, unhashedSubpackets);
    }

    public AbstractSignatureBuilder(@NotNull SignatureType signatureType, @NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        PGPPublicKey pGPPublicKey = signingKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"signingKey.publicKey");
        HashAlgorithm hashAlgorithm = Companion.negotiateHashAlgorithm(pGPPublicKey);
        PGPPublicKey pGPPublicKey2 = signingKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey2, (String)"signingKey.publicKey");
        this(signatureType, signingKey, protector, hashAlgorithm, SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey2), SignatureSubpackets.Companion.createEmptySubpackets());
    }

    public AbstractSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPSignature archetypeSignature) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)archetypeSignature, (String)"archetypeSignature");
        SignatureType signatureType = SignatureType.Companion.requireFromCode(archetypeSignature.getSignatureType());
        PGPPublicKey pGPPublicKey = signingKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"signingKey.publicKey");
        HashAlgorithm hashAlgorithm = Companion.negotiateHashAlgorithm(pGPPublicKey);
        PGPPublicKey pGPPublicKey2 = signingKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey2, (String)"signingKey.publicKey");
        this(signatureType, signingKey, protector, hashAlgorithm, SignatureSubpackets.Companion.refreshHashedSubpackets(pGPPublicKey2, archetypeSignature), SignatureSubpackets.Companion.refreshUnhashedSubpackets(archetypeSignature));
    }

    @NotNull
    public final HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @NotNull
    public final B overrideHashAlgorithm(@NotNull HashAlgorithm hashAlgorithm) {
        AbstractSignatureBuilder abstractSignatureBuilder;
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        AbstractSignatureBuilder $this$overrideHashAlgorithm_u24lambda_u241 = abstractSignatureBuilder = this;
        boolean bl = false;
        $this$overrideHashAlgorithm_u24lambda_u241._hashAlgorithm = hashAlgorithm;
        AbstractSignatureBuilder abstractSignatureBuilder2 = abstractSignatureBuilder;
        Intrinsics.checkNotNull((Object)abstractSignatureBuilder2, (String)"null cannot be cast to non-null type B of org.pgpainless.signature.builder.AbstractSignatureBuilder");
        return (B)abstractSignatureBuilder2;
    }

    @NotNull
    public final B setSignatureType(@NotNull SignatureType type) {
        AbstractSignatureBuilder abstractSignatureBuilder;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        AbstractSignatureBuilder $this$setSignatureType_u24lambda_u243 = abstractSignatureBuilder = this;
        boolean bl = false;
        if (!$this$setSignatureType_u24lambda_u243.getSignatureTypePredicate().test(type)) {
            boolean bl2 = false;
            String string = "Invalid signature type: " + (Object)((Object)type);
            throw new IllegalArgumentException(string.toString());
        }
        $this$setSignatureType_u24lambda_u243._signatureType = type;
        AbstractSignatureBuilder abstractSignatureBuilder2 = abstractSignatureBuilder;
        Intrinsics.checkNotNull((Object)abstractSignatureBuilder2, (String)"null cannot be cast to non-null type B of org.pgpainless.signature.builder.AbstractSignatureBuilder");
        return (B)abstractSignatureBuilder2;
    }

    @NotNull
    protected final PGPSignatureGenerator buildAndInitSignatureGenerator() throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        PGPSignatureGenerator $this$buildAndInitSignatureGenerator_u24lambda_u244 = pGPSignatureGenerator = new PGPSignatureGenerator(ImplementationFactory.Companion.getInstance().getPGPContentSignerBuilder(this.publicSigningKey.getAlgorithm(), this.hashAlgorithm.getAlgorithmId()));
        boolean bl = false;
        $this$buildAndInitSignatureGenerator_u24lambda_u244.setUnhashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(this._unhashedSubpackets));
        $this$buildAndInitSignatureGenerator_u24lambda_u244.setHashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(this._hashedSubpackets));
        $this$buildAndInitSignatureGenerator_u24lambda_u244.init(this._signatureType.getCode(), this.privateSigningKey);
        return pGPSignatureGenerator;
    }

    @JvmStatic
    @NotNull
    public static final HashAlgorithm negotiateHashAlgorithm(@NotNull PGPPublicKey publicKey) {
        return Companion.negotiateHashAlgorithm(publicKey);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/signature/builder/AbstractSignatureBuilder$Companion;", "", "()V", "negotiateHashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HashAlgorithm negotiateHashAlgorithm(@NotNull PGPPublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            HashAlgorithmNegotiator hashAlgorithmNegotiator = HashAlgorithmNegotiator.Companion.negotiateSignatureHashAlgorithm(PGPainless.Companion.getPolicy());
            Set<HashAlgorithm> set = OpenPgpKeyAttributeUtil.getOrGuessPreferredHashAlgorithms(publicKey);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getOrGuessPreferredHashAlgorithms(publicKey)");
            return hashAlgorithmNegotiator.negotiateHashAlgorithm(set);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

