/*
 * Decompiled with CFR 0.152.
 */
package monix.catnap;

import cats.FlatMap;
import cats.effect.Async;
import cats.effect.Clock;
import cats.effect.Concurrent;
import cats.effect.ExitCase;
import cats.effect.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import java.io.Serializable;
import monix.catnap.CircuitBreaker$;
import monix.catnap.CircuitBreaker$Builders$;
import monix.catnap.CircuitBreaker$Closed$;
import monix.catnap.CircuitBreaker$HalfOpen$;
import monix.catnap.CircuitBreaker$Open$;
import monix.catnap.CircuitBreakerDocs;
import monix.catnap.FutureLift$;
import monix.catnap.OrElse;
import monix.execution.CancelablePromise;
import monix.execution.CancelablePromise$;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.exceptions.ExecutionRejectedException$;
import monix.execution.internal.Constants$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CircuitBreaker<F> {
    private final F onRejected;
    private final F onClosed;
    private final F onHalfOpen;
    private final F onOpen;
    private final Sync<F> F;
    private final Clock<F> clock;
    private final AtomicAny<State> stateRef;
    private final int maxFailures;
    private final FiniteDuration resetTimeout;
    private final double exponentialBackoffFactor;
    private final Duration maxResetTimeout;
    private final Object state;
    private final Function1<Either<Throwable, Object>, F> maybeMarkOrResetFailures;

    public static <F> Sync apply(Sync<F> sync) {
        return CircuitBreaker$.MODULE$.apply(sync);
    }

    public static <F> Object of(int n, FiniteDuration finiteDuration, double d, Duration duration, PaddingStrategy paddingStrategy, Sync<F> sync, Clock<F> clock) {
        return CircuitBreaker$.MODULE$.of(n, finiteDuration, d, duration, paddingStrategy, sync, clock);
    }

    public static <F> CircuitBreaker<F> unsafe(int n, FiniteDuration finiteDuration, double d, Duration duration, PaddingStrategy paddingStrategy, Sync<F> sync, Clock<F> clock) {
        return CircuitBreaker$.MODULE$.unsafe(n, finiteDuration, d, duration, paddingStrategy, sync, clock);
    }

    public static <F> double of$default$3() {
        return CircuitBreaker$.MODULE$.of$default$3();
    }

    public static <F> double unsafe$default$3() {
        return CircuitBreaker$.MODULE$.unsafe$default$3();
    }

    public static <F> Duration of$default$4() {
        return CircuitBreaker$.MODULE$.of$default$4();
    }

    public static <F> Duration unsafe$default$4() {
        return CircuitBreaker$.MODULE$.unsafe$default$4();
    }

    public static <F> PaddingStrategy of$default$5() {
        return CircuitBreaker$.MODULE$.of$default$5();
    }

    public static <F> PaddingStrategy unsafe$default$5() {
        return CircuitBreaker$.MODULE$.unsafe$default$5();
    }

    public CircuitBreaker(AtomicAny<State> _stateRef, int _maxFailures, FiniteDuration _resetTimeout, double _exponentialBackoffFactor, Duration _maxResetTimeout, Object onRejected, Object onClosed, Object onHalfOpen, Object onOpen, Sync<F> F, Clock<F> clock) {
        this.onRejected = onRejected;
        this.onClosed = onClosed;
        this.onHalfOpen = onHalfOpen;
        this.onOpen = onOpen;
        this.F = F;
        this.clock = clock;
        Predef$.MODULE$.require(_maxFailures >= 0, CircuitBreaker::$init$$$anonfun$1);
        Predef$.MODULE$.require(_exponentialBackoffFactor >= 1.0, CircuitBreaker::$init$$$anonfun$2);
        Predef$.MODULE$.require(_resetTimeout.$greater((Object)Duration$.MODULE$.Zero()), CircuitBreaker::$init$$$anonfun$3);
        Predef$.MODULE$.require(_maxResetTimeout.$greater((Object)Duration$.MODULE$.Zero()), CircuitBreaker::$init$$$anonfun$4);
        this.stateRef = _stateRef;
        this.maxFailures = _maxFailures;
        this.resetTimeout = _resetTimeout;
        this.exponentialBackoffFactor = _exponentialBackoffFactor;
        this.maxResetTimeout = _maxResetTimeout;
        this.state = F.delay(this::$init$$$anonfun$5);
        this.maybeMarkOrResetFailures = (Function1 & Serializable)result -> this.markFailure$1(onOpen, (Sync)F, (Clock)clock, (Either)result);
    }

    public int maxFailures() {
        return this.maxFailures;
    }

    public FiniteDuration resetTimeout() {
        return this.resetTimeout;
    }

    public double exponentialBackoffFactor() {
        return this.exponentialBackoffFactor;
    }

    public Duration maxResetTimeout() {
        return this.maxResetTimeout;
    }

    public F state() {
        return (F)this.state;
    }

    public <A> F protect(F task) {
        return (F)this.F.defer(() -> this.protect$$anonfun$1(task));
    }

    public F awaitClose(OrElse<Concurrent<F>, Async<F>> F) {
        Async F0 = (Async)F.unify($less$colon$less$.MODULE$.refl());
        return (F)F0.defer(() -> this.awaitClose$$anonfun$1(F, F0));
    }

    private <A> F attemptReset(F task, FiniteDuration resetTimeout, CancelablePromise<BoxedUnit> await, long lastStartedAt) {
        return (F)this.F.bracketCase(this.onHalfOpen, (Function1 & Serializable)_$3 -> task, (Function2 & Serializable)(_$4, exit) -> {
            Object object;
            ExitCase exitCase = exit;
            if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                this.stateRef.set((Object)CircuitBreaker$Open$.MODULE$.apply(lastStartedAt, resetTimeout, await));
                object = this.onOpen;
            } else if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                this.stateRef.set((Object)CircuitBreaker$Closed$.MODULE$.apply(0));
                await.complete(Constants$.MODULE$.successOfUnit());
                object = this.onClosed;
            } else if (exitCase instanceof ExitCase.Error) {
                ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                Throwable throwable = (Throwable)error._1();
                FiniteDuration value = new package.DurationDouble(scala.concurrent.duration.package$.MODULE$.DurationDouble((double)resetTimeout.toMillis() * this.exponentialBackoffFactor())).millis();
                FiniteDuration nextTimeout = this.maxResetTimeout().isFinite() && value.$greater((Object)this.maxResetTimeout()) ? (FiniteDuration)this.maxResetTimeout() : value;
                object = implicits$.MODULE$.toFlatMapOps(this.clock.monotonic(scala.concurrent.duration.package$.MODULE$.MILLISECONDS()), this.F).flatMap((Function1 & Serializable)ts -> this.attemptReset$$anonfun$2$$anonfun$1(await, nextTimeout, BoxesRunTime.unboxToLong((Object)ts)));
            } else {
                throw new MatchError((Object)exitCase);
            }
            return object;
        });
    }

    private <A> F unsafeProtect(F task) {
        Object object;
        State state = (State)this.stateRef.get();
        if (state instanceof Closed) {
            Closed closed = CircuitBreaker$Closed$.MODULE$.unapply((Closed)state);
            int n = closed._1();
            Function1<Either<Throwable, Object>, F> bind = this.maybeMarkOrResetFailures;
            Object object2 = implicits$.MODULE$.catsSyntaxApplicativeError(task, this.F);
            object = implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.F), this.F).flatMap(bind);
        } else if (state instanceof Open) {
            Open current = (Open)state;
            object = implicits$.MODULE$.toFlatMapOps(this.clock.monotonic(scala.concurrent.duration.package$.MODULE$.MILLISECONDS()), this.F).flatMap((Function1 & Serializable)now -> this.unsafeProtect$$anonfun$1(task, current, BoxesRunTime.unboxToLong((Object)now)));
        } else {
            object = implicits$.MODULE$.toFlatMapOps(this.onRejected, this.F).flatMap((Function1 & Serializable)_$6 -> this.F.raiseError((Object)ExecutionRejectedException$.MODULE$.apply("Rejected because the CircuitBreaker is in the HalfOpen state")));
        }
        return (F)object;
    }

    public CircuitBreaker<F> doOnRejectedTask(F callback) {
        Object onRejected = implicits$.MODULE$.toFlatMapOps(this.onRejected, this.F).flatMap((Function1 & Serializable)_$7 -> callback);
        return new CircuitBreaker<F>(this.stateRef, this.maxFailures(), this.resetTimeout(), this.exponentialBackoffFactor(), this.maxResetTimeout(), onRejected, this.onClosed, this.onHalfOpen, this.onOpen, this.F, this.clock);
    }

    public CircuitBreaker<F> doOnClosed(F callback) {
        Object onClosed = implicits$.MODULE$.toFlatMapOps(this.onClosed, this.F).flatMap((Function1 & Serializable)_$8 -> callback);
        return new CircuitBreaker<F>(this.stateRef, this.maxFailures(), this.resetTimeout(), this.exponentialBackoffFactor(), this.maxResetTimeout(), this.onRejected, onClosed, this.onHalfOpen, this.onOpen, this.F, this.clock);
    }

    public CircuitBreaker<F> doOnHalfOpen(F callback) {
        Object onHalfOpen = implicits$.MODULE$.toFlatMapOps(this.onHalfOpen, this.F).flatMap((Function1 & Serializable)_$9 -> callback);
        return new CircuitBreaker<F>(this.stateRef, this.maxFailures(), this.resetTimeout(), this.exponentialBackoffFactor(), this.maxResetTimeout(), this.onRejected, this.onClosed, onHalfOpen, this.onOpen, this.F, this.clock);
    }

    public CircuitBreaker<F> doOnOpen(F callback) {
        Object onOpen = implicits$.MODULE$.toFlatMapOps(this.onOpen, this.F).flatMap((Function1 & Serializable)_$10 -> callback);
        return new CircuitBreaker<F>(this.stateRef, this.maxFailures(), this.resetTimeout(), this.exponentialBackoffFactor(), this.maxResetTimeout(), this.onRejected, this.onClosed, this.onHalfOpen, onOpen, this.F, this.clock);
    }

    private static final String $init$$$anonfun$1() {
        return "maxFailures >= 0";
    }

    private static final String $init$$$anonfun$2() {
        return "exponentialBackoffFactor >= 1";
    }

    private static final String $init$$$anonfun$3() {
        return "resetTimeout > 0";
    }

    private static final String $init$$$anonfun$4() {
        return "maxResetTimeout > 0";
    }

    private final State $init$$$anonfun$5() {
        return (State)this.stateRef.get();
    }

    private final Object reschedule$1(Object onOpen$4, Sync F$5, Clock clock$4, Either exit) {
        return this.markFailure$1(onOpen$4, F$5, clock$4, exit);
    }

    private final /* synthetic */ Object markFailure$1$$anonfun$1(Object onOpen$2, Sync F$2, Clock clock$2, Either result$1, Closed current$1, Throwable error$1, long now) {
        Open update = CircuitBreaker$Open$.MODULE$.apply(now, this.resetTimeout(), (CancelablePromise<BoxedUnit>)CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1()));
        return !this.stateRef.compareAndSet((Object)current$1, (Object)update) ? this.reschedule$1(onOpen$2, F$2, clock$2, result$1) : implicits$.MODULE$.toFlatMapOps(onOpen$2, (FlatMap)F$2).flatMap((Function1 & Serializable)_$2 -> F$2.raiseError((Object)error$1));
    }

    private final Object markFailure$1(Object onOpen$1, Sync F$1, Clock clock$1, Either result) {
        Object object;
        block7: {
            State state;
            while ((state = (State)this.stateRef.get()) instanceof Closed) {
                int n;
                Closed closed = (Closed)state;
                Closed closed2 = CircuitBreaker$Closed$.MODULE$.unapply(closed);
                int failures = n = closed2._1();
                Closed current = closed;
                Either either = result;
                if (either instanceof Right) {
                    Object a = ((Right)either).value();
                    if (failures == 0) {
                        object = F$1.pure(a);
                    } else {
                        Closed update = CircuitBreaker$Closed$.MODULE$.apply(0);
                        if (!this.stateRef.compareAndSet((Object)current, (Object)update)) continue;
                        object = F$1.pure(a);
                    }
                    break block7;
                }
                if (either instanceof Left) {
                    Throwable error = (Throwable)((Left)either).value();
                    if (failures + 1 < this.maxFailures()) {
                        Closed update = CircuitBreaker$Closed$.MODULE$.apply(failures + 1);
                        if (!this.stateRef.compareAndSet((Object)current, (Object)update)) continue;
                        object = F$1.raiseError((Object)error);
                    } else {
                        object = implicits$.MODULE$.toFlatMapOps(clock$1.monotonic(scala.concurrent.duration.package$.MODULE$.MILLISECONDS()), (FlatMap)F$1).flatMap((Function1 & Serializable)now -> this.markFailure$1$$anonfun$1(onOpen$1, F$1, clock$1, result, current, error, BoxesRunTime.unboxToLong((Object)now)));
                    }
                    break block7;
                }
                throw new MatchError((Object)either);
            }
            object = F$1.fromEither(result);
        }
        return object;
    }

    private final Object protect$$anonfun$1(Object task$1) {
        return this.unsafeProtect(task$1);
    }

    private final Object awaitClose$$anonfun$1(OrElse F$4, Async F0$1) {
        Object object;
        State state = (State)this.stateRef.get();
        if (state instanceof Open) {
            Open ref = (Open)state;
            object = FutureLift$.MODULE$.scalaToConcurrentOrAsync(F0$1.pure((Object)ref.awaitClose().future()), F$4);
        } else if (state instanceof HalfOpen) {
            HalfOpen ref = (HalfOpen)state;
            object = FutureLift$.MODULE$.scalaToConcurrentOrAsync(F0$1.pure((Object)ref.awaitClose().future()), F$4);
        } else {
            object = F0$1.unit();
        }
        return object;
    }

    private final /* synthetic */ Object attemptReset$$anonfun$2$$anonfun$1(CancelablePromise await$2, FiniteDuration nextTimeout$1, long ts) {
        this.stateRef.set((Object)CircuitBreaker$Open$.MODULE$.apply(ts, nextTimeout$1, (CancelablePromise<BoxedUnit>)await$2));
        return this.onOpen;
    }

    private final /* synthetic */ Object unsafeProtect$$anonfun$1(Object task$3, Open current$2, long now) {
        Object object;
        long expiresAt = current$2.expiresAt();
        FiniteDuration timeout = current$2.resetTimeout();
        CancelablePromise<BoxedUnit> await = current$2.awaitClose();
        if (now >= expiresAt) {
            object = !this.stateRef.compareAndSet((Object)current$2, (Object)CircuitBreaker$HalfOpen$.MODULE$.apply(timeout, await)) ? this.unsafeProtect(task$3) : this.attemptReset(task$3, timeout, await, current$2.startedAt());
        } else {
            long expiresInMillis = expiresAt - now;
            object = implicits$.MODULE$.toFlatMapOps(this.onRejected, this.F).flatMap((Function1 & Serializable)_$5 -> this.F.raiseError((Object)ExecutionRejectedException$.MODULE$.apply(new StringBuilder(58).append("Rejected because the CircuitBreaker is in the Open state, ").append(new StringBuilder(30).append("attempting to close in ").append(expiresInMillis).append(" millis").toString()).toString())));
        }
        return object;
    }

    public static final class Builders<F>
    implements CircuitBreakerDocs {
        private final Sync F;

        public static <F> boolean equals$extension(Sync sync, Object object) {
            return CircuitBreaker$Builders$.MODULE$.equals$extension(sync, object);
        }

        public static <F> int hashCode$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.hashCode$extension(sync);
        }

        public static <F> Object of$extension(Sync sync, int n, FiniteDuration finiteDuration, double d, Duration duration, Object object, Object object2, Object object3, Object object4, PaddingStrategy paddingStrategy, Clock<F> clock) {
            return CircuitBreaker$Builders$.MODULE$.of$extension(sync, n, finiteDuration, d, duration, object, object2, object3, object4, paddingStrategy, clock);
        }

        public static <F> CircuitBreaker<F> unsafe$extension(Sync sync, int n, FiniteDuration finiteDuration, double d, Duration duration, Object object, Object object2, Object object3, Object object4, PaddingStrategy paddingStrategy, Clock<F> clock) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$extension(sync, n, finiteDuration, d, duration, object, object2, object3, object4, paddingStrategy, clock);
        }

        public static <F> double of$default$3$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.of$default$3$extension(sync);
        }

        public static <F> double unsafe$default$3$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$3$extension(sync);
        }

        public static <F> Duration of$default$4$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.of$default$4$extension(sync);
        }

        public static <F> Duration unsafe$default$4$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$4$extension(sync);
        }

        public static <F> Object of$default$5$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.of$default$5$extension(sync);
        }

        public static <F> Object unsafe$default$5$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$5$extension(sync);
        }

        public static <F> Object of$default$6$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.of$default$6$extension(sync);
        }

        public static <F> Object unsafe$default$6$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$6$extension(sync);
        }

        public static <F> Object of$default$7$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.of$default$7$extension(sync);
        }

        public static <F> Object unsafe$default$7$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$7$extension(sync);
        }

        public static <F> Object of$default$8$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.of$default$8$extension(sync);
        }

        public static <F> Object unsafe$default$8$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$8$extension(sync);
        }

        public static <F> PaddingStrategy of$default$9$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.of$default$9$extension(sync);
        }

        public static <F> PaddingStrategy unsafe$default$9$extension(Sync sync) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$9$extension(sync);
        }

        public Builders(Sync<F> F) {
            this.F = F;
        }

        public int hashCode() {
            return CircuitBreaker$Builders$.MODULE$.hashCode$extension(this.F());
        }

        public boolean equals(Object x$0) {
            return CircuitBreaker$Builders$.MODULE$.equals$extension(this.F(), x$0);
        }

        public Sync<F> F() {
            return this.F;
        }

        public F of(int maxFailures, FiniteDuration resetTimeout, double exponentialBackoffFactor, Duration maxResetTimeout, F onRejected, F onClosed, F onHalfOpen, F onOpen, PaddingStrategy padding, Clock<F> clock) {
            return (F)CircuitBreaker$Builders$.MODULE$.of$extension(this.F(), maxFailures, resetTimeout, exponentialBackoffFactor, maxResetTimeout, onRejected, onClosed, onHalfOpen, onOpen, padding, clock);
        }

        public double of$default$3() {
            return CircuitBreaker$Builders$.MODULE$.of$default$3$extension(this.F());
        }

        public Duration of$default$4() {
            return CircuitBreaker$Builders$.MODULE$.of$default$4$extension(this.F());
        }

        public F of$default$5() {
            return (F)CircuitBreaker$Builders$.MODULE$.of$default$5$extension(this.F());
        }

        public F of$default$6() {
            return (F)CircuitBreaker$Builders$.MODULE$.of$default$6$extension(this.F());
        }

        public F of$default$7() {
            return (F)CircuitBreaker$Builders$.MODULE$.of$default$7$extension(this.F());
        }

        public F of$default$8() {
            return (F)CircuitBreaker$Builders$.MODULE$.of$default$8$extension(this.F());
        }

        public PaddingStrategy of$default$9() {
            return CircuitBreaker$Builders$.MODULE$.of$default$9$extension(this.F());
        }

        public CircuitBreaker<F> unsafe(int maxFailures, FiniteDuration resetTimeout, double exponentialBackoffFactor, Duration maxResetTimeout, F onRejected, F onClosed, F onHalfOpen, F onOpen, PaddingStrategy padding, Clock<F> clock) {
            return CircuitBreaker$Builders$.MODULE$.unsafe$extension(this.F(), maxFailures, resetTimeout, exponentialBackoffFactor, maxResetTimeout, onRejected, onClosed, onHalfOpen, onOpen, padding, clock);
        }

        public double unsafe$default$3() {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$3$extension(this.F());
        }

        public Duration unsafe$default$4() {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$4$extension(this.F());
        }

        public F unsafe$default$5() {
            return (F)CircuitBreaker$Builders$.MODULE$.unsafe$default$5$extension(this.F());
        }

        public F unsafe$default$6() {
            return (F)CircuitBreaker$Builders$.MODULE$.unsafe$default$6$extension(this.F());
        }

        public F unsafe$default$7() {
            return (F)CircuitBreaker$Builders$.MODULE$.unsafe$default$7$extension(this.F());
        }

        public F unsafe$default$8() {
            return (F)CircuitBreaker$Builders$.MODULE$.unsafe$default$8$extension(this.F());
        }

        public PaddingStrategy unsafe$default$9() {
            return CircuitBreaker$Builders$.MODULE$.unsafe$default$9$extension(this.F());
        }
    }

    public static final class Closed
    extends State
    implements Product,
    Serializable {
        private final int failures;

        public static Closed apply(int n) {
            return CircuitBreaker$Closed$.MODULE$.apply(n);
        }

        public static Closed fromProduct(Product product) {
            return CircuitBreaker$Closed$.MODULE$.fromProduct(product);
        }

        public static Closed unapply(Closed closed) {
            return CircuitBreaker$Closed$.MODULE$.unapply(closed);
        }

        public Closed(int failures) {
            this.failures = failures;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.failures());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Closed)) return false;
            Closed closed = (Closed)object;
            if (this.failures() != closed.failures()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Closed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Closed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "failures";
        }

        public int failures() {
            return this.failures;
        }

        public Closed copy(int failures) {
            return new Closed(failures);
        }

        public int copy$default$1() {
            return this.failures();
        }

        public int _1() {
            return this.failures();
        }
    }

    public static final class HalfOpen
    extends State {
        private final FiniteDuration resetTimeout;
        private final CancelablePromise awaitClose;

        public static HalfOpen apply(FiniteDuration finiteDuration, CancelablePromise<BoxedUnit> cancelablePromise) {
            return CircuitBreaker$HalfOpen$.MODULE$.apply(finiteDuration, cancelablePromise);
        }

        public static Option<FiniteDuration> unapply(HalfOpen halfOpen) {
            return CircuitBreaker$HalfOpen$.MODULE$.unapply(halfOpen);
        }

        public HalfOpen(FiniteDuration resetTimeout, CancelablePromise<BoxedUnit> awaitClose) {
            this.resetTimeout = resetTimeout;
            this.awaitClose = awaitClose;
        }

        public FiniteDuration resetTimeout() {
            return this.resetTimeout;
        }

        public CancelablePromise<BoxedUnit> awaitClose() {
            return this.awaitClose;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof HalfOpen)) return false;
            HalfOpen that = (HalfOpen)object;
            FiniteDuration finiteDuration = this.resetTimeout();
            FiniteDuration finiteDuration2 = that.resetTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            CancelablePromise<BoxedUnit> cancelablePromise = this.awaitClose();
            CancelablePromise<BoxedUnit> cancelablePromise2 = that.awaitClose();
            if (cancelablePromise == null) {
                if (cancelablePromise2 == null) return true;
                return false;
            } else {
                if (!cancelablePromise.equals(cancelablePromise2)) return false;
                return true;
            }
        }

        public int hashCode() {
            Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.resetTimeout(), this.awaitClose()}));
            return BoxesRunTime.unboxToInt((Object)state.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(a, b) -> this.hashCode$$anonfun$2(BoxesRunTime.unboxToInt((Object)a), b)));
        }

        private final /* synthetic */ int hashCode$$anonfun$2(int a, Object b) {
            return 31 * a + b.hashCode();
        }
    }

    public static final class Open
    extends State {
        private final long startedAt;
        private final FiniteDuration resetTimeout;
        private final CancelablePromise awaitClose;
        private final long expiresAt;

        public static Open apply(long l, FiniteDuration finiteDuration, CancelablePromise<BoxedUnit> cancelablePromise) {
            return CircuitBreaker$Open$.MODULE$.apply(l, finiteDuration, cancelablePromise);
        }

        public static Option<Tuple2<Object, FiniteDuration>> unapply(Open open) {
            return CircuitBreaker$Open$.MODULE$.unapply(open);
        }

        public Open(long startedAt, FiniteDuration resetTimeout, CancelablePromise<BoxedUnit> awaitClose) {
            this.startedAt = startedAt;
            this.resetTimeout = resetTimeout;
            this.awaitClose = awaitClose;
            this.expiresAt = startedAt + resetTimeout.toMillis();
        }

        public long startedAt() {
            return this.startedAt;
        }

        public FiniteDuration resetTimeout() {
            return this.resetTimeout;
        }

        public CancelablePromise<BoxedUnit> awaitClose() {
            return this.awaitClose;
        }

        public long expiresAt() {
            return this.expiresAt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof Open)) return false;
            Open that = (Open)object;
            if (this.startedAt() != that.startedAt()) return false;
            FiniteDuration finiteDuration = this.resetTimeout();
            FiniteDuration finiteDuration2 = that.resetTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            CancelablePromise<BoxedUnit> cancelablePromise = this.awaitClose();
            CancelablePromise<BoxedUnit> cancelablePromise2 = that.awaitClose();
            if (cancelablePromise == null) {
                if (cancelablePromise2 == null) return true;
                return false;
            } else {
                if (!cancelablePromise.equals(cancelablePromise2)) return false;
                return true;
            }
        }

        public int hashCode() {
            Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startedAt()), this.resetTimeout(), this.awaitClose()}));
            return BoxesRunTime.unboxToInt((Object)state.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(a, b) -> this.hashCode$$anonfun$1(BoxesRunTime.unboxToInt((Object)a), b)));
        }

        private final /* synthetic */ int hashCode$$anonfun$1(int a, Object b) {
            return 31 * a + b.hashCode();
        }
    }

    public static abstract class State {
    }
}

