/*
 * Decompiled with CFR 0.152.
 */
package ambience.i18n.editor;

import ambience.arch.EitherTELM$;
import ambience.framework.URFilter2$;
import ambience.gravity.GravityHelper$;
import ambience.i18n.common.AddLanguage;
import ambience.i18n.common.AddLanguage$;
import ambience.i18n.common.AddProperty;
import ambience.i18n.common.AddProperty$;
import ambience.i18n.common.DeleteLanguages;
import ambience.i18n.common.DeleteLanguages$;
import ambience.i18n.common.DeleteProperties;
import ambience.i18n.common.DeleteProperties$;
import ambience.i18n.common.ExportInfo;
import ambience.i18n.common.ExportInfo$;
import ambience.i18n.common.Language;
import ambience.i18n.common.Language$;
import ambience.i18n.common.MasterInfo;
import ambience.i18n.common.MasterInfo$;
import ambience.i18n.common.RenameProperty;
import ambience.i18n.common.RenameProperty$;
import ambience.i18n.common.TranslationInfo;
import ambience.i18n.common.TranslationInfo$;
import ambience.i18n.editor.ActionHandler$;
import ambience.i18n.editor.DocLoader$;
import ambience.i18n.editor.EditHandler$;
import ambience.i18n.editor.I18NLanguages$;
import ambience.i18n.editor.ImportHandler$;
import ambience.i18n.editor.ResourceBundleHandler$;
import ambience.i18n.editor.UploadHandler;
import ambience.module.Module;
import ambience.module.NoModPrivilege;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.webserver.CodeLoader;
import com.elixirtech.webserver.DynamicCodeLoader;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.KeyEncoder$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.Tuple5$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class I18nEditorModule
implements Module,
NoModPrivilege,
LoggingHelper2 {
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(I18nEditorModule.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(I18nEditorModule.class.getDeclaredField("routes$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(I18nEditorModule.class.getDeclaredField("route$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(I18nEditorModule.class.getDeclaredField("codeLoader$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(I18nEditorModule.class.getDeclaredField("uploadHandler$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(I18nEditorModule.class.getDeclaredField("codeLoaderOptions$lzy1"));
    private volatile Object log$lzy1;
    public final ProjectConfig ambience$i18n$editor$I18nEditorModule$$projectConfig;
    private final String id;
    private final String name;
    private final String url;
    private final String modId;
    private final Scheduler scheduler;
    private volatile Object codeLoaderOptions$lzy1;
    private volatile Object uploadHandler$lzy1;
    private volatile Object codeLoader$lzy1;
    private volatile Object route$lzy1;
    private volatile Object routes$lzy1;

    public I18nEditorModule(ProjectConfig projectConfig) {
        this.ambience$i18n$editor$I18nEditorModule$$projectConfig = projectConfig;
        this.id = "i18n-editor";
        this.name = "Internationalisation Editor";
        this.url = "";
        this.modId = "i18n";
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public String modId() {
        return this.modId;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public CodeLoader.Options codeLoaderOptions() {
        Object object = this.codeLoaderOptions$lzy1;
        if (object instanceof CodeLoader.Options) {
            return (CodeLoader.Options)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodeLoader.Options)this.codeLoaderOptions$lzyINIT1();
    }

    private Object codeLoaderOptions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoaderOptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodeLoader.Options options = null;
                    try {
                        options = new CodeLoader.Options(this){
                            private final /* synthetic */ I18nEditorModule $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public String WebScript() {
                                return "js/elx-i18n-client-fastopt.js";
                            }

                            public File WebRootDir() {
                                return this.$outer.ambience$i18n$editor$I18nEditorModule$$projectConfig.WebRootDir();
                            }
                        };
                        object2 = options == null ? LazyVals.NullValue$.MODULE$ : options;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoaderOptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return options;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UploadHandler uploadHandler() {
        Object object = this.uploadHandler$lzy1;
        if (object instanceof UploadHandler) {
            return (UploadHandler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UploadHandler)this.uploadHandler$lzyINIT1();
    }

    private Object uploadHandler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.uploadHandler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UploadHandler uploadHandler = null;
                    try {
                        uploadHandler = new UploadHandler(this);
                        object2 = uploadHandler == null ? LazyVals.NullValue$.MODULE$ : uploadHandler;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uploadHandler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uploadHandler;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DynamicCodeLoader codeLoader() {
        Object object = this.codeLoader$lzy1;
        if (object instanceof DynamicCodeLoader) {
            return (DynamicCodeLoader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DynamicCodeLoader)this.codeLoader$lzyINIT1();
    }

    private Object codeLoader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DynamicCodeLoader dynamicCodeLoader = null;
                    try {
                        dynamicCodeLoader = new DynamicCodeLoader(this.codeLoaderOptions());
                        object2 = dynamicCodeLoader == null ? LazyVals.NullValue$.MODULE$ : dynamicCodeLoader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoader$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return dynamicCodeLoader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        Object object = this.route$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.route$lzyINIT1();
    }

    private Object route$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.route$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = GravitySystem$.MODULE$.fromRoutes(this.routes(), GravitySystem$.MODULE$.fromRoutes$default$2());
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<GravityRoute> routes() {
        Object object = this.routes$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.routes$lzyINIT1();
    }

    private Object routes$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.routes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "*/index.html", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.buildIndexHtml((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "master/*", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.getMaster((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "translation/*/*", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.getTranslation((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "available/*", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.getAvailable((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "languages", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.getLanguageList((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "add-property", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.addProperty((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "rename-property", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.renameProperty((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "delete-properties", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.deleteProperties((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "add-language", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.addLanguage((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "delete-languages", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.deleteLanguages((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "export-translations", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.exportData((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "import-translations", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> this.importTranslations((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "proceed-import", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> ImportHandler$.MODULE$.postImportSetting((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "edits", RouteHelper$.MODULE$.withModUser(this.modId(), (Function1 & Serializable)user -> EditHandler$.MODULE$.postEdits((UserDB.User)user))), this.codeLoader().route()}));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> buildIndexHtml(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)i18nId -> (Function1 & Serializable)request -> {
            String safe = this.safeId(i18nId.value());
            return ActionHandler$.MODULE$.isValidMaster(safe).flatMap((Function1 & Serializable)isValid -> this.buildIndexHtml$$anonfun$1$$anonfun$1$$anonfun$1(safe, user, (GravityRequest)request, BoxesRunTime.unboxToBoolean((Object)isValid)));
        });
    }

    private String safeId(String s) {
        return StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> I18nEditorModule.safeId$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getLanguageList(UserDB.User user) {
        return (Function1 & Serializable)_$1 -> Task$.MODULE$.now((Object)GravityResponse$.MODULE$.json(I18NLanguages$.MODULE$.availableLanguages()));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getMaster(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)i18nId -> (Function1 & Serializable)_$2 -> ActionHandler$.MODULE$.loadMaster(user, i18nId.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                MasterInfo mi = (MasterInfo)((Right)either).value();
                MasterInfo masterInfo = (MasterInfo)package$.MODULE$.EncoderOps((Object)mi);
                MasterInfo$ mirror$proxy1 = MasterInfo$.MODULE$;
                String string = "_id";
                String string2 = "owner";
                String string3 = "name";
                String string4 = "master";
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)masterInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(I18nEditorModule::getMaster$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy1)))));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(84), FullName$.MODULE$.apply("ambience.i18n.editor.I18nEditorModule.getMaster"));
                return Gravity$.MODULE$.NotFoundResponse(msg.msg());
            }
            throw new MatchError((Object)either);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getTranslation(UserDB.User user) {
        return GravityHelper$.MODULE$.seg2((Function2 & Serializable)(i18nId, languageCode) -> (Function1 & Serializable)_$3 -> ActionHandler$.MODULE$.loadTranslation(user, i18nId.value(), languageCode.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                TranslationInfo ti = (TranslationInfo)((Right)either).value();
                TranslationInfo translationInfo = (TranslationInfo)package$.MODULE$.EncoderOps((Object)ti);
                TranslationInfo$ mirror$proxy2 = TranslationInfo$.MODULE$;
                String string = "_id";
                String string2 = "masterId";
                String string3 = "languageCode";
                String string4 = "languageName";
                String string5 = "translation";
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)translationInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(I18nEditorModule::getTranslation$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy2)))));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(93), FullName$.MODULE$.apply("ambience.i18n.editor.I18nEditorModule.getTranslation"));
                return Gravity$.MODULE$.NotFoundResponse(msg.msg());
            }
            throw new MatchError((Object)either);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getAvailable(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)i18nId -> (Function1 & Serializable)_$4 -> {
            Bson filter = Filters$.MODULE$.eq("masterId", (Object)BsonString$.MODULE$.apply(i18nId.value()));
            FindOptions options = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"languageCode", "languageName"})));
            return ActionHandler$.MODULE$.i18nTranslationCltn().findO(filter, options).toListL().map((Function1 & Serializable)docs -> {
                List list = (List)package$.MODULE$.EncoderOps((Object)docs.flatMap((Function1 & Serializable)doc -> DocLoader$.MODULE$.buildLanguage((Document)doc)));
                Language$ mirror$proxy3 = Language$.MODULE$;
                String string = "languageCode";
                String string2 = "languageName";
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)list, (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(I18nEditorModule::getAvailable$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy3))))));
            });
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> addProperty(UserDB.User user) {
        return (Function1 & Serializable)req -> {
            AddProperty$ mirror$proxy4 = AddProperty$.MODULE$;
            String string = "id";
            String string2 = "name";
            String string3 = "master";
            int size = 3;
            return ActionHandler$.MODULE$.decode("AddProperty", (GravityRequest)req, (Function1 & Serializable)ap -> this.doAddProperty(user, (AddProperty)ap), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("AddProperty", I18nEditorModule::addProperty$$anonfun$1$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy4, Default$.MODULE$.inline$of(I18nEditorModule::addProperty$$anonfun$1$$anonfun$3)))));
        };
    }

    public Task<GravityResponse> doAddProperty(UserDB.User user, AddProperty ap) {
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)userFilter -> {
            Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{userFilter, Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(ap.id()))}));
            Option optUpdates = Some$.MODULE$.apply((Object)Updates$.MODULE$.currentDate("lastModified")).flatMap((Function1 & Serializable)lastModified -> {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(ap.name())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
                objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(ap.master())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return Some$.MODULE$.apply((Object)Updates$.MODULE$.push("master", (Object)org.mongodb.scala.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).map((Function1 & Serializable)property -> Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{lastModified, property})));
            });
            Option option = optUpdates;
            if (option instanceof Some) {
                Bson updates = (Bson)((Some)option).value();
                return ActionHandler$.MODULE$.i18nCltn().updateOneT(filter, updates).map((Function1 & Serializable)result -> {
                    if (result.getModifiedCount() == 1L) {
                        return Gravity$.MODULE$.OkResponse();
                    }
                    return Gravity$.MODULE$.BadRequestResponse("Master update failed");
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.apply(I18nEditorModule::doAddProperty$$anonfun$1$$anonfun$2);
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> renameProperty(UserDB.User user) {
        return (Function1 & Serializable)req -> {
            RenameProperty$ mirror$proxy5 = RenameProperty$.MODULE$;
            String string = "id";
            String string2 = "propertyName";
            String string3 = "newName";
            int size = 3;
            return ActionHandler$.MODULE$.decode("RenameProperty", (GravityRequest)req, (Function1 & Serializable)dp -> this.doRenameProperty(user, (RenameProperty)dp), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("RenameProperty", I18nEditorModule::renameProperty$$anonfun$1$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy5, Default$.MODULE$.inline$of(I18nEditorModule::renameProperty$$anonfun$1$$anonfun$3)))));
        };
    }

    public Task<GravityResponse> doRenameProperty(UserDB.User user, RenameProperty rp) {
        return EitherTELM$.MODULE$.apply(this.doRenameMaster(user, rp)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherTELM$.MODULE$.apply(this.doRenameTranslations(user, rp)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).value().map((Function1 & Serializable)r -> ActionHandler$.MODULE$.asResponse((Either<LogMessage, BoxedUnit>)r));
    }

    public Task<Either<LogMessage, BoxedUnit>> doRenameMaster(UserDB.User user, RenameProperty rp) {
        return ActionHandler$.MODULE$.updateMaster(user, rp.id(), (Function1<MasterInfo, MasterInfo>)(Function1 & Serializable)_$5 -> _$5.renameProperty(rp.propertyName(), rp.newName()));
    }

    public Task<Either<LogMessage, BoxedUnit>> doRenameTranslations(UserDB.User user, RenameProperty rp) {
        return ActionHandler$.MODULE$.updateTranslations(user, rp.id(), (Function1<TranslationInfo, TranslationInfo>)(Function1 & Serializable)_$6 -> _$6.renameProperty(rp.propertyName(), rp.newName()));
    }

    public Function1<GravityRequest, Task<GravityResponse>> deleteProperties(UserDB.User user) {
        return (Function1 & Serializable)req -> {
            DeleteProperties$ mirror$proxy6 = DeleteProperties$.MODULE$;
            String string = "id";
            String string2 = "propertyNames";
            int size = 2;
            return ActionHandler$.MODULE$.decode("DeleteProperties", (GravityRequest)req, (Function1 & Serializable)dp -> this.doDeleteProperties(user, (DeleteProperties)dp), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("DeleteProperties", I18nEditorModule::deleteProperties$$anonfun$1$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy6, Default$.MODULE$.inline$of(I18nEditorModule::deleteProperties$$anonfun$1$$anonfun$3)))));
        };
    }

    public Task<GravityResponse> doDeleteProperties(UserDB.User user, DeleteProperties dp) {
        return EitherTELM$.MODULE$.apply(this.doDeleteMasterProperties(user, dp)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherTELM$.MODULE$.apply(this.doDeletePropertiesTranslation(user, dp)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).value().map((Function1 & Serializable)r -> ActionHandler$.MODULE$.asResponse((Either<LogMessage, BoxedUnit>)r));
    }

    public Task<Either<LogMessage, BoxedUnit>> doDeleteMasterProperties(UserDB.User user, DeleteProperties dp) {
        return ActionHandler$.MODULE$.updateMaster(user, dp.id(), (Function1<MasterInfo, MasterInfo>)(Function1 & Serializable)_$7 -> _$7.removeProperties(dp.propertyNames()));
    }

    public Task<Either<LogMessage, BoxedUnit>> doDeletePropertiesTranslation(UserDB.User user, DeleteProperties dp) {
        return ActionHandler$.MODULE$.updateTranslations(user, dp.id(), (Function1<TranslationInfo, TranslationInfo>)(Function1 & Serializable)_$8 -> _$8.removeProperties(dp.propertyNames()));
    }

    public Function1<GravityRequest, Task<GravityResponse>> addLanguage(UserDB.User user) {
        return (Function1 & Serializable)req -> {
            AddLanguage$ mirror$proxy7 = AddLanguage$.MODULE$;
            String string = "id";
            String string2 = "languageCode";
            String string3 = "copyFrom";
            int size = 3;
            return ActionHandler$.MODULE$.decode("AddLanguage", (GravityRequest)req, (Function1 & Serializable)al -> this.doAddLanguage(user, (AddLanguage)al), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("AddLanguage", I18nEditorModule::addLanguage$$anonfun$1$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy7, Default$.MODULE$.inline$of(I18nEditorModule::addLanguage$$anonfun$1$$anonfun$3)))));
        };
    }

    public Task<GravityResponse> doAddLanguage(UserDB.User user, AddLanguage al) {
        return EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> this.doAddLanguage$$anonfun$1(al))).flatMap((Function1 & Serializable)languageName -> EitherTELM$.MODULE$.apply(ActionHandler$.MODULE$.loadTranslation(user, al.id(), al.languageCode()).map((Function1 & Serializable)_$9 -> _$9.map((Function1 & Serializable)_$10 -> LogMessage.Error$.MODULE$.apply("Translation already exists")).swap())).flatMap((Function1 & Serializable)x$1 -> {
            LogMessage logMessage = x$1;
            return EitherTELM$.MODULE$.apply(this.loadCopyFrom(user, al)).flatMap((Function1 & Serializable)copyFrom -> EitherTELM$.MODULE$.apply(this.addLanguageRecord(al.id(), Language$.MODULE$.apply(al.languageCode(), languageName), (Map<String, String>)copyFrom.translation())).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherTELM$.MODULE$.apply(ActionHandler$.MODULE$.updateMasterLastModified(user, al.id())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            }));
        })).value().map((Function1 & Serializable)r -> ActionHandler$.MODULE$.asResponse((Either<LogMessage, BoxedUnit>)r));
    }

    public Task<Either<LogMessage, TranslationInfo>> loadCopyFrom(UserDB.User user, AddLanguage al) {
        if (al.copyFrom().isEmpty()) {
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Right().apply((Object)TranslationInfo$.MODULE$.apply(TranslationInfo$.MODULE$.$lessinit$greater$default$1(), TranslationInfo$.MODULE$.$lessinit$greater$default$2(), TranslationInfo$.MODULE$.$lessinit$greater$default$3(), TranslationInfo$.MODULE$.$lessinit$greater$default$4(), TranslationInfo$.MODULE$.$lessinit$greater$default$5())));
        }
        return ActionHandler$.MODULE$.loadTranslation(user, al.id(), al.copyFrom());
    }

    public Either<LogMessage, String> lookupLanguageName(String code) {
        return I18NLanguages$.MODULE$.localeMap().get((Object)code).toRight(() -> I18nEditorModule.lookupLanguageName$$anonfun$1(code));
    }

    public Task<Either<LogMessage, BoxedUnit>> addLanguageRecord(String masterId, Language language, Map<String, String> initialTranslation) {
        String uuid = UUID.randomUUID().toString();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)uuid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"masterId");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)masterId), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"languageCode");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)language.languageCode()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"languageName");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)language.languageName()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"translation");
        objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonArray$.MODULE$.fromIterable((Iterable)initialTranslation.map((Function1 & Serializable)t -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, t._1()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, t._2()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            return BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document doc = org.mongodb.scala.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return ActionHandler$.MODULE$.i18nTranslationCltn().insertOneT(doc).as((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Function1<GravityRequest, Task<GravityResponse>> deleteLanguages(UserDB.User user) {
        return (Function1 & Serializable)req -> {
            DeleteLanguages$ mirror$proxy8 = DeleteLanguages$.MODULE$;
            String string = "id";
            String string2 = "languageCodes";
            int size = 2;
            return ActionHandler$.MODULE$.decode("DeleteLanguages", (GravityRequest)req, (Function1 & Serializable)t -> this.doDeleteLanguages(user, (DeleteLanguages)t), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("DeleteLanguages", I18nEditorModule::deleteLanguages$$anonfun$1$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy8, Default$.MODULE$.inline$of(I18nEditorModule::deleteLanguages$$anonfun$1$$anonfun$3)))));
        };
    }

    public Task<GravityResponse> doDeleteLanguages(UserDB.User user, DeleteLanguages dl) {
        return EitherTELM$.MODULE$.apply(this.doDeleteLanguageRecord(user, dl)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherTELM$.MODULE$.apply(ActionHandler$.MODULE$.updateMasterLastModified(user, dl.id())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).value().map((Function1 & Serializable)r -> ActionHandler$.MODULE$.asResponse((Either<LogMessage, BoxedUnit>)r));
    }

    public Task<Either<LogMessage, BoxedUnit>> doDeleteLanguageRecord(UserDB.User user, DeleteLanguages dl) {
        List codes = dl.languageCodes().toList().map((Function1 & Serializable)_$11 -> BsonString$.MODULE$.apply(_$11));
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("masterId", (Object)BsonString$.MODULE$.apply(dl.id())), Filters$.MODULE$.in("languageCode", (Seq)codes)}));
        return ActionHandler$.MODULE$.i18nTranslationCltn().deleteManyT(filter).as((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Function1<GravityRequest, Task<GravityResponse>> exportData(UserDB.User user) {
        return (Function1 & Serializable)req -> {
            ExportInfo$ mirror$proxy9 = ExportInfo$.MODULE$;
            String string = "id";
            String string2 = "name";
            String string3 = "format";
            String string4 = "isMaster";
            String string5 = "languageCodes";
            int size = 5;
            return ActionHandler$.MODULE$.decode("ExportInfo", (GravityRequest)req, (Function1 & Serializable)t -> {
                if (t.isMaster()) {
                    return this.doExportMaster(user, (ExportInfo)t);
                }
                return this.doExportTranslations(user, (ExportInfo)t);
            }, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("ExportInfo", I18nEditorModule::exportData$$anonfun$1$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy9, Default$.MODULE$.inline$of(I18nEditorModule::exportData$$anonfun$1$$anonfun$3)))));
        };
    }

    public Task<GravityResponse> doExportMaster(UserDB.User user, ExportInfo el) {
        return ActionHandler$.MODULE$.getMaster(user, el.id()).map((Function1 & Serializable)mi -> {
            Tuple2 tuple2;
            String string = el.format();
            if ("json".equals(string)) {
                MasterInfo masterInfo = (MasterInfo)package$.MODULE$.EncoderOps(mi);
                MasterInfo$ mirror$proxy10 = MasterInfo$.MODULE$;
                String string2 = "_id";
                String string3 = "owner";
                String string4 = "name";
                String string5 = "master";
                String jsonStr = package.EncoderOps$.MODULE$.asJson$extension((Object)masterInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(I18nEditorModule::$anonfun$4, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2), Configuration$.MODULE$.default(), (Mirror)mirror$proxy10)))).mapObject((Function1 & Serializable)obj -> obj.remove("_id")).mapObject((Function1 & Serializable)obj -> obj.remove("owner")).noSpaces();
                MasterInfo masterInfo2 = (MasterInfo)package$.MODULE$.EncoderOps(mi);
                MasterInfo$ mirror$proxy11 = MasterInfo$.MODULE$;
                String string6 = "_id";
                String string7 = "owner";
                String string8 = "name";
                String string9 = "master";
                tuple2 = Tuple2$.MODULE$.apply((Object)(el.name() + "_master.json"), (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)masterInfo2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(I18nEditorModule::$anonfun$7, scala.package$.MODULE$.Nil().$colon$colon((Object)string9).$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6), Configuration$.MODULE$.default(), (Mirror)mirror$proxy11)))).noSpaces());
            } else {
                tuple2 = Tuple2$.MODULE$.apply((Object)(el.name() + "_master.properties"), (Object)ResourceBundleHandler$.MODULE$.builderMaster((MasterInfo)mi));
            }
            Tuple2 tuple22 = tuple2;
            String filename = (String)tuple22._1();
            String file = (String)tuple22._2();
            Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Html(), GravityResponse.ContentDisposition$.MODULE$.attachment(filename)}));
            DataBytes dataBytes = DataBytes$.MODULE$.apply(file);
            int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
            return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
        });
    }

    public Task<GravityResponse> doExportTranslations(UserDB.User user, ExportInfo el) {
        return ActionHandler$.MODULE$.getTranslation(user, el).map((Function1 & Serializable)ts -> {
            Tuple2 tuple2;
            String code = (String)el.languageCodes().headOption().getOrElse(I18nEditorModule::$anonfun$8);
            String string = el.format();
            if ("json".equals(string)) {
                Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                String jsonStr = json.mapObject((Function1 & Serializable)obj -> obj.add("translations", Json$.MODULE$.fromValues((Iterable)ts.map((Function1 & Serializable)x -> {
                    TranslationInfo translationInfo = (TranslationInfo)package$.MODULE$.EncoderOps(x);
                    TranslationInfo$ mirror$proxy12 = TranslationInfo$.MODULE$;
                    String string = "_id";
                    String string2 = "masterId";
                    String string3 = "languageCode";
                    String string4 = "languageName";
                    String string5 = "translation";
                    return package.EncoderOps$.MODULE$.asJson$extension((Object)translationInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(I18nEditorModule::$anonfun$9$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy12))));
                })))).noSpaces();
                tuple2 = Tuple2$.MODULE$.apply((Object)(el.name() + "_translation.json"), (Object)jsonStr);
            } else {
                TranslationInfo ti = (TranslationInfo)ts.find((Function1 & Serializable)x -> x.languageCode().equals(code)).getOrElse(I18nEditorModule::$anonfun$11);
                tuple2 = Tuple2$.MODULE$.apply((Object)(el.name() + "_" + code.replaceAll("-", "_") + ".properties"), (Object)ResourceBundleHandler$.MODULE$.builderTranslation(ti));
            }
            Tuple2 tuple22 = tuple2;
            String filename = (String)tuple22._1();
            String file = (String)tuple22._2();
            Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Html(), GravityResponse.ContentDisposition$.MODULE$.attachment(filename)}));
            DataBytes dataBytes = DataBytes$.MODULE$.apply(file);
            int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
            return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> importTranslations(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.formParameter("masterId").map((Function1 & Serializable)masterId -> {
            Gravity.FormItem formItem;
            String format = (String)request.formParameter("format").getOrElse(I18nEditorModule::$anonfun$12);
            boolean isMaster = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)request.formParameter("isMaster").getOrElse(I18nEditorModule::$anonfun$13)));
            this.log().info(() -> this.importTranslations$$anonfun$1$$anonfun$1$$anonfun$1(user, format, isMaster), Line$.MODULE$.apply(266), FullName$.MODULE$.apply("ambience.i18n.editor.I18nEditorModule.importTranslations"));
            Option option = request.formItems().get("file");
            if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                Gravity.FileUploadItem file = (Gravity.FileUploadItem)formItem;
                return DataBytes$.MODULE$.toFullT((DataBytes)file.data()).flatMap((Function1 & Serializable)full -> this.doImportTranslations(user, full.bytes(), file.filename(), format, (String)masterId, isMaster));
            }
            return Gravity$.MODULE$.BadRequestResponseT("Can't read file");
        }).getOrElse(I18nEditorModule::importTranslations$$anonfun$1$$anonfun$2);
    }

    public Task<GravityResponse> doImportTranslations(UserDB.User user, byte[] bytes, String filename, String format, String masterId, boolean isMaster) {
        return this.uploadHandler().handleUpload(user, format, bytes, filename, isMaster).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return GravityResponse$.MODULE$.json(json);
            }
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            throw new MatchError((Object)either);
        });
    }

    private final /* synthetic */ Task buildIndexHtml$$anonfun$1$$anonfun$1$$anonfun$1(String safe$1, UserDB.User user$2, GravityRequest request$1, boolean isValid) {
        if (isValid) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"i18nId");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)safe$1);
            return (Task)RouteHelper$.MODULE$.buildIndexHtml((CodeLoader)this.codeLoader(), this.id(), (PartialFunction)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), user$2).apply((Object)request$1);
        }
        return Gravity$.MODULE$.NotFoundResponseT();
    }

    private static final /* synthetic */ boolean safeId$$anonfun$1(char ch) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(ch)) || ch == '-';
    }

    /*
     * WARNING - void declaration
     */
    private static final List getMaster$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        Encoder.AsObject encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder.AsObject asObject = encodeA = Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getTranslation$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        Encoder.AsObject encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var3_2;
        void var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder.AsObject asObject = encodeA = Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAvailable$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List addProperty$$anonfun$1$$anonfun$2() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product addProperty$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final GravityResponse doAddProperty$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponse("Master update failed");
    }

    /*
     * WARNING - void declaration
     */
    private static final List renameProperty$$anonfun$1$$anonfun$2() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product renameProperty$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List deleteProperties$$anonfun$1$$anonfun$2() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product deleteProperties$$anonfun$1$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List addLanguage$$anonfun$1$$anonfun$2() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product addLanguage$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private final Either doAddLanguage$$anonfun$1(AddLanguage al$1) {
        return this.lookupLanguageName(al$1.languageCode());
    }

    private static final LogMessage.Error lookupLanguageName$$anonfun$1(String code$1) {
        return LogMessage.Error$.MODULE$.apply("Unknown language code: " + code$1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List deleteLanguages$$anonfun$1$$anonfun$2() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product deleteLanguages$$anonfun$1$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List exportData$$anonfun$1$$anonfun$2() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var3_2;
        void var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeBoolean();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product exportData$$anonfun$1$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)Some$.MODULE$.apply((Object)ExportInfo$.MODULE$.$lessinit$greater$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$4() {
        Encoder.AsObject encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder.AsObject asObject = encodeA = Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$7() {
        Encoder.AsObject encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder.AsObject asObject = encodeA = Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final String $anonfun$8() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$9$$anonfun$1$$anonfun$1() {
        Encoder.AsObject encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var3_2;
        void var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder.AsObject asObject = encodeA = Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asObject).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final TranslationInfo $anonfun$11() {
        return TranslationInfo$.MODULE$.apply(TranslationInfo$.MODULE$.$lessinit$greater$default$1(), TranslationInfo$.MODULE$.$lessinit$greater$default$2(), TranslationInfo$.MODULE$.$lessinit$greater$default$3(), TranslationInfo$.MODULE$.$lessinit$greater$default$4(), TranslationInfo$.MODULE$.$lessinit$greater$default$5());
    }

    private static final String $anonfun$12() {
        return "";
    }

    private static final String $anonfun$13() {
        return "false";
    }

    private final Object importTranslations$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$29, String format$1, boolean isMaster$1) {
        return "upload by " + user$29.name() + " parameters: name=" + this.name() + ", format=" + format$1 + ", isMaster=" + isMaster$1;
    }

    private static final Task importTranslations$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing form item 'masterId'");
    }
}

