/*
 * Decompiled with CFR 0.152.
 */
package ambience.i18n.management;

import ambience.framework.AuditedUUIDDocumentManager2;
import ambience.framework.DocumentManager2$;
import ambience.framework.URAugment2$;
import ambience.framework.UserRoleInfo2;
import ambience.framework.UserRoleInfo2$;
import ambience.i18n.editor.ActionHandler$;
import ambience.i18n.management.I18nManagementModule;
import ambience.module.UserDB;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Sorts$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class I18nManager
extends AuditedUUIDDocumentManager2
implements LoggingHelper2 {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(I18nManager.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(I18nManager.class.getDeclaredField("extension$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(I18nManager.class.getDeclaredField("uniqueKey$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(I18nManager.class.getDeclaredField("cltn$lzy1"));
    private volatile Object log$lzy1;
    private final I18nManagementModule module;
    private final Scheduler exeCxt;
    private volatile Object cltn$lzy1;
    private volatile Object uniqueKey$lzy1;
    private volatile Object extension$lzy1;
    private final AuditAPI.AuditAppender auditAppender;
    private final AuditAPI.Component auditComponent;
    private final Function1 UnAugmenter;

    public I18nManager(I18nManagementModule module) {
        this.module = module;
        this.exeCxt = Scheduler$.MODULE$.global();
        this.auditAppender = module.auditAppender();
        this.auditComponent = module.AuditComponent();
        List list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonProcessor.Remove[]{JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("ownerName")), JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("access.roleNames"))}));
        this.UnAugmenter = (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)list, json);
        this.init().runToFuture(this.exeCxt());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    public RichMongoCollection cltn() {
        Object object = this.cltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.cltn$lzyINIT1();
    }

    private Object cltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.module.mongoDB().database().getCollection("I18N", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String uniqueKey() {
        Object object = this.uniqueKey$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.uniqueKey$lzyINIT1();
    }

    private Object uniqueKey$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.uniqueKey$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = "name";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uniqueKey$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String extension() {
        Object object = this.extension$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.extension$lzyINIT1();
    }

    private Object extension$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.extension$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ".i18n.json";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.extension$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    public Function1<Json, Json> UnAugmenter() {
        return this.UnAugmenter;
    }

    public Task<Json> get(UserDB.User user) {
        return UserRoleInfo2$.MODULE$.load().flatMap((Function1 & Serializable)info -> this.cltn().findO(DocumentManager2$.MODULE$.exists(this.uniqueKey()), FindOptions$.MODULE$.sorts(Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.uniqueKey()})))).toListL().map((Function1 & Serializable)reply -> {
            Either either = io.circe.parser.package$.MODULE$.parse(reply.map((Function1 & Serializable)_$1 -> I18nManager.augment$1(info, _$1).toJson()).mkString("[", ",\n", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> I18nManager.get$$anonfun$1$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(41), FullName$.MODULE$.apply("ambience.i18n.management.I18nManager.get"));
                return Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        }));
    }

    public Task<Option<Json>> get(UserDB.User user, String uuid) {
        return this.cltn().findO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(uuid))).firstOptionL().map((Function1 & Serializable)optDoc -> optDoc.flatMap((Function1 & Serializable)doc -> io.circe.parser.package$.MODULE$.parse(doc.toJson()).toOption()));
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        return super.save(user, (Json)this.UnAugmenter().apply((Object)json));
    }

    public Task<GravityResponse> download(UserDB.User user, String uuid) {
        return this.get(user, uuid).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                String filename = this.filenameExtractor(json);
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Html(), GravityResponse.ContentDisposition$.MODULE$.attachment(filename)}));
                return this.getTranslations(user, uuid).map((Function1 & Serializable)ts -> {
                    Json fullJson = json.mapObject((Function1 & Serializable)obj -> obj.add("translations", Json$.MODULE$.fromValues((Iterable)ts)));
                    DataBytes dataBytes = DataBytes$.MODULE$.apply(fullJson.spaces2());
                    int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
                    return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponseT();
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<List<Json>> getTranslations(UserDB.User user, String uuid) {
        return ActionHandler$.MODULE$.i18nTranslationCltn().findO(Filters$.MODULE$.eq("masterId", (Object)uuid)).flatMap((Function1 & Serializable)tdoc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(io.circe.parser.package$.MODULE$.parse(tdoc.toJson()).toOption())).map((Function1 & Serializable)tinfo -> tinfo)).toListL();
    }

    private static final Document augment$1(UserRoleInfo2.Info info$1, Document doc) {
        return URAugment2$.MODULE$.apply(info$1, doc);
    }

    private static final Object get$$anonfun$1$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }
}

