/*
 * Decompiled with CFR 0.152.
 */
package laika.render;

import java.io.Serializable;
import laika.ast.Element;
import laika.ast.MessageFilter;
import laika.ast.RuntimeMessage;
import laika.render.Indentation;
import laika.render.Indentation$;
import scala.Function1;
import scala.Function2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public abstract class BaseFormatter<Rep extends BaseFormatter<Rep>> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BaseFormatter.class.getDeclaredField("nextLevel$lzy1"));
    private final Function2<Rep, Element, String> renderChild;
    private final Element currentElement;
    private final Indentation indentation;
    private final MessageFilter messageFilter;
    private final String newLine;
    private volatile Object nextLevel$lzy1;

    public BaseFormatter(Function2<Rep, Element, String> renderChild, Element currentElement, List<Element> parents, Indentation indentation, MessageFilter messageFilter) {
        this.renderChild = renderChild;
        this.currentElement = currentElement;
        this.indentation = indentation;
        this.messageFilter = messageFilter;
        this.newLine = indentation.newLine();
    }

    public String newLine() {
        return this.newLine;
    }

    public String renderCurrentElement() {
        return (String)this.renderChild.apply((Object)this, (Object)this.currentElement);
    }

    private Rep nextLevel() {
        Object object = this.nextLevel$lzy1;
        if (object instanceof BaseFormatter) {
            return (Rep)((BaseFormatter)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Rep)((BaseFormatter)this.nextLevel$lzyINIT1());
    }

    private Object nextLevel$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.nextLevel$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BaseFormatter baseFormatter = null;
                    try {
                        Indentation indentation = this.indentation;
                        Indentation indentation2 = Indentation$.MODULE$.none();
                        BaseFormatter<Rep> baseFormatter2 = !(indentation != null ? !((Object)indentation).equals(indentation2) : indentation2 != null) ? this : (baseFormatter = this.withIndentation(this.indentation.nextLevel()));
                        object2 = baseFormatter == null ? LazyVals.NullValue$.MODULE$ : baseFormatter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.nextLevel$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return baseFormatter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract Rep withChild(Element var1);

    public abstract Rep withIndentation(Indentation var1);

    public String indented(Function1<Rep, String> f) {
        return (String)f.apply(this.nextLevel());
    }

    public String withoutIndentation(Function1<Rep, String> f) {
        return (String)f.apply(this.withIndentation(Indentation$.MODULE$.none()));
    }

    public String withMinIndentation(int minIndent, Function1<Rep, String> f) {
        Indentation indentation = this.indentation;
        Indentation indentation2 = Indentation$.MODULE$.none();
        BaseFormatter newIndentation = !(indentation == null ? indentation2 != null : !((Object)indentation).equals(indentation2)) || this.indentation.currentLevel() >= minIndent ? this : this.withIndentation(this.indentation.copy(minIndent, this.indentation.copy$default$2(), this.indentation.copy$default$3()));
        return (String)f.apply((Object)newIndentation);
    }

    public String forMessage(RuntimeMessage message, String whenEnabled) {
        if (this.messageFilter.apply(message)) {
            return whenEnabled;
        }
        return "";
    }

    public String children(Seq<Element> elements) {
        return ((IterableOnceOps)elements.map((Function1 & Serializable)element -> this.child((Element)element))).mkString();
    }

    public String child(Element element) {
        return ((BaseFormatter)this.withChild(element)).renderCurrentElement();
    }

    public String childPerLine(Seq<Element> elements) {
        return ((IterableOnceOps)elements.map((Function1 & Serializable)element -> this.child((Element)element))).mkString(this.newLine());
    }

    public String indentedChildren(Seq<Element> elements) {
        if (elements.isEmpty()) {
            return "";
        }
        return this.indented((Function1 & Serializable)fmt -> new StringBuilder(0).append(fmt.newLine()).append(fmt.childPerLine(elements)).toString());
    }
}

