/*
 * Decompiled with CFR 0.152.
 */
package laika.time;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import laika.time.PlatformDateTime;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;

public final class PlatformDateTimeImpl$
implements PlatformDateTime,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(PlatformDateTimeImpl$.class.getDeclaredField("formatterConstants$lzy1"));
    private static final DateTimeFormatter offsetDateTime;
    private volatile Object formatterConstants$lzy1;
    public static final PlatformDateTimeImpl$ MODULE$;

    private PlatformDateTimeImpl$() {
    }

    static {
        MODULE$ = new PlatformDateTimeImpl$();
        offsetDateTime = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendPattern("[XXX][X]").toFormatter();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlatformDateTimeImpl$.class);
    }

    @Override
    public OffsetDateTime now() {
        return OffsetDateTime.now();
    }

    public Either<String, OffsetDateTime> parse(String dateString) {
        if (dateString.matches(".*(Z|[+-]\\d\\d[:]?\\d\\d)")) {
            return this.parseOffsetDateTime$1(dateString);
        }
        if (dateString.contains("T")) {
            return this.parseLocalDateTime$1(dateString);
        }
        return this.parseLocalDateTime$1(new StringBuilder(9).append(dateString).append("T00:00:00").toString());
    }

    public Either<String, String> format(OffsetDateTime date, String pattern, Option<String> locale) {
        return this.getLocale(locale).flatMap((Function1 & Serializable)loc -> Try$.MODULE$.apply(() -> this.format$$anonfun$1$$anonfun$1(date, pattern, loc)).toEither().left().map((Function1 & Serializable)_$3 -> _$3.getMessage()));
    }

    @Override
    public Option<String> format$default$3() {
        return None$.MODULE$;
    }

    private Map<String, DateTimeFormatter> formatterConstants() {
        Object object = this.formatterConstants$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.formatterConstants$lzyINIT1();
    }

    private Object formatterConstants$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.formatterConstants$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        Object[] objectArray = new Tuple2[17];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"BASIC_ISO_DATE");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)DateTimeFormatter.BASIC_ISO_DATE);
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_LOCAL_DATE");
                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)DateTimeFormatter.ISO_LOCAL_DATE);
                        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_OFFSET_DATE");
                        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)DateTimeFormatter.ISO_OFFSET_DATE);
                        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_DATE");
                        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)DateTimeFormatter.ISO_DATE);
                        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_LOCAL_TIME");
                        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)DateTimeFormatter.ISO_LOCAL_TIME);
                        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_OFFSET_TIME");
                        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)DateTimeFormatter.ISO_OFFSET_TIME);
                        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_TIME");
                        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)DateTimeFormatter.ISO_TIME);
                        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_LOCAL_DATE_TIME");
                        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_OFFSET_DATE_TIME");
                        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_ZONED_DATE_TIME");
                        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)DateTimeFormatter.ISO_ZONED_DATE_TIME);
                        String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_DATE_TIME");
                        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (Object)DateTimeFormatter.ISO_DATE_TIME);
                        String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_ORDINAL_DATE");
                        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, (Object)DateTimeFormatter.ISO_ORDINAL_DATE);
                        String string13 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_WEEK_DATE");
                        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string13, (Object)DateTimeFormatter.ISO_WEEK_DATE);
                        String string14 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ISO_INSTANT");
                        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string14, (Object)DateTimeFormatter.ISO_INSTANT);
                        String string15 = (String)Predef$.MODULE$.ArrowAssoc((Object)"RFC_1123_DATE_TIME");
                        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string15, (Object)DateTimeFormatter.RFC_1123_DATE_TIME);
                        String string16 = (String)Predef$.MODULE$.ArrowAssoc((Object)"MEDIUM");
                        objectArray[15] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string16, (Object)DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
                        String string17 = (String)Predef$.MODULE$.ArrowAssoc((Object)"SHORT");
                        objectArray[16] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string17, (Object)DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT));
                        map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.formatterConstants$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.formatterConstants$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Either<String, Locale> getLocale(Option<String> languageTag) {
        return (Either)languageTag.fold(this::getLocale$$anonfun$1, (Function1 & Serializable)lang -> {
            Either either = package.all$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply(() -> this.getLocale$$anonfun$2$$anonfun$1(lang)).toEither());
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$4 -> _$4.getMessage());
        });
    }

    public Option<Either<String, String>> formatConstant(OffsetDateTime date, String constant, Option<String> locale) {
        return this.formatterConstants().get((Object)constant.trim().toUpperCase()).map((Function1 & Serializable)formatter -> this.getLocale(locale).flatMap((Function1 & Serializable)loc -> {
            Either either = package.all$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply(() -> this.formatConstant$$anonfun$1$$anonfun$1$$anonfun$1(date, formatter, loc)).toEither());
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$5 -> _$5.getMessage());
        }));
    }

    @Override
    public Option<String> formatConstant$default$3() {
        return None$.MODULE$;
    }

    private final OffsetDateTime parseOffsetDateTime$1$$anonfun$1(String input$1) {
        return OffsetDateTime.from(offsetDateTime.parse(input$1));
    }

    private final Either parseOffsetDateTime$1(String input) {
        return Try$.MODULE$.apply(() -> this.parseOffsetDateTime$1$$anonfun$1(input)).toEither().left().map((Function1 & Serializable)_$1 -> _$1.getMessage());
    }

    private final OffsetDateTime parseLocalDateTime$1$$anonfun$1(String input$2) {
        return OffsetDateTime.from(LocalDateTime.parse(input$2).atZone(ZoneId.systemDefault()));
    }

    private final Either parseLocalDateTime$1(String input) {
        return Try$.MODULE$.apply(() -> this.parseLocalDateTime$1$$anonfun$1(input)).toEither().left().map((Function1 & Serializable)_$2 -> _$2.getMessage());
    }

    private final String format$$anonfun$1$$anonfun$1(OffsetDateTime date$2, String pattern$2, Locale loc$1) {
        return new DateTimeFormatterBuilder().appendPattern(pattern$2).toFormatter().withLocale(loc$1).format(date$2);
    }

    private final Either getLocale$$anonfun$1() {
        return package$.MODULE$.Right().apply((Object)Locale.getDefault());
    }

    private final Locale getLocale$$anonfun$2$$anonfun$1(String lang$1) {
        return new Locale.Builder().setLanguageTag(lang$1).build();
    }

    private final String formatConstant$$anonfun$1$$anonfun$1$$anonfun$1(OffsetDateTime date$5, DateTimeFormatter formatter$2, Locale loc$2) {
        return formatter$2.withLocale(loc$2).format(date$5);
    }
}

