/*
 * Decompiled with CFR 0.152.
 */
package ambience.datablend.proc;

import ambience.datablend.proc.Calculation;
import ambience.datablend.proc.Calculation$;
import ambience.datablend.proc.Certainty$;
import ambience.datablend.proc.Certainty$Mean$;
import ambience.datablend.proc.Certainty$Median$;
import ambience.datablend.proc.Certainty$PosNeg$;
import ambience.datablend.proc.Certainty$Score$;
import ambience.datablend.proc.Certainty$Serialized$;
import ambience.datablend.proc.Certainty$Weighted$;
import ambience.datablend.proc.Certainty$WeightedMean$;
import ambience.datablend.proc.Description;
import ambience.datablend.proc.Description$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$Double$TotalOrdering$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface Certainty
extends Product,
Serializable {
    public static int ordinal(Certainty certainty) {
        return Certainty$.MODULE$.ordinal(certainty);
    }

    public double value();

    public String origin();

    public Calculation calculation();

    public Description description();

    public static Serialized serialize$(Certainty $this) {
        return $this.serialize();
    }

    default public Serialized serialize() {
        return Certainty$Serialized$.MODULE$.apply(this.value(), this.origin(), this.calculation(), this.description());
    }

    public static class Mean
    implements Product,
    Certainty {
        private final Seq values;
        private final String origin;
        private final double value;

        public static Mean apply(Seq<Certainty> seq, String string) {
            return Certainty$Mean$.MODULE$.apply(seq, string);
        }

        public static Mean fromProduct(Product product) {
            return Certainty$Mean$.MODULE$.fromProduct(product);
        }

        public static Mean unapply(Mean mean) {
            return Certainty$Mean$.MODULE$.unapply(mean);
        }

        public Mean(Seq<Certainty> values, String origin) {
            this.values = values;
            this.origin = origin;
            Predef$.MODULE$.require(values.nonEmpty());
            this.value = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)values.map((Function1 & Serializable)_$1 -> _$1.value())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)values.size();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Mean)) return false;
            Mean mean = (Mean)object;
            Seq<Certainty> seq = this.values();
            Seq<Certainty> seq2 = mean.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            String string = this.origin();
            String string2 = mean.origin();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!mean.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Mean;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Mean";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "values";
            }
            if (1 == n2) {
                return "origin";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<Certainty> values() {
            return this.values;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public Calculation calculation() {
            return Calculation$.MODULE$.apply("Mean", (Seq<Calculation>)((Seq)this.values().map((Function1 & Serializable)_$2 -> _$2.calculation())));
        }

        @Override
        public Description description() {
            return Description$.MODULE$.apply(StringOps$.MODULE$.format$extension("Mean(%s) %03f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.origin(), BoxesRunTime.boxToDouble((double)this.value())})), (Seq<Description>)((Seq)this.values().map((Function1 & Serializable)_$3 -> _$3.description())));
        }

        public Mean copy(Seq<Certainty> values, String origin) {
            return new Mean(values, origin);
        }

        public Seq<Certainty> copy$default$1() {
            return this.values();
        }

        public String copy$default$2() {
            return this.origin();
        }

        public Seq<Certainty> _1() {
            return this.values();
        }

        public String _2() {
            return this.origin();
        }
    }

    public static class Median
    implements Product,
    Certainty {
        private final Seq values;
        private final String origin;
        private final Ordering$Double$TotalOrdering$ ordering;
        private final double value;

        public static Median apply(Seq<Certainty> seq, String string) {
            return Certainty$Median$.MODULE$.apply(seq, string);
        }

        public static Median fromProduct(Product product) {
            return Certainty$Median$.MODULE$.fromProduct(product);
        }

        public static Median unapply(Median median) {
            return Certainty$Median$.MODULE$.unapply(median);
        }

        public Median(Seq<Certainty> values, String origin) {
            this.values = values;
            this.origin = origin;
            Predef$.MODULE$.require(values.nonEmpty());
            scala.package$.MODULE$.Ordering();
            this.ordering = Ordering$Double$TotalOrdering$.MODULE$;
            Seq sorted = (Seq)((SeqOps)values.map((Function1 & Serializable)_$6 -> _$6.value())).sorted((Ordering)this.ordering());
            this.value = values.size() % 2 == 0 ? (BoxesRunTime.unboxToDouble((Object)sorted.apply(values.size() / 2)) + BoxesRunTime.unboxToDouble((Object)sorted.apply(values.size() / 2 - 1))) / 2.0 : BoxesRunTime.unboxToDouble((Object)sorted.apply(values.size() / 2));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Median)) return false;
            Median median = (Median)object;
            Seq<Certainty> seq = this.values();
            Seq<Certainty> seq2 = median.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            String string = this.origin();
            String string2 = median.origin();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!median.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Median;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Median";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "values";
            }
            if (1 == n2) {
                return "origin";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<Certainty> values() {
            return this.values;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        public Ordering$Double$TotalOrdering$ ordering() {
            return this.ordering;
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public Calculation calculation() {
            return Calculation$.MODULE$.apply("Median", (Seq<Calculation>)((Seq)this.values().map((Function1 & Serializable)_$7 -> _$7.calculation())));
        }

        @Override
        public Description description() {
            return Description$.MODULE$.apply("Median(" + this.origin() + ")", (Seq<Description>)((Seq)this.values().map((Function1 & Serializable)_$8 -> _$8.description())));
        }

        public Median copy(Seq<Certainty> values, String origin) {
            return new Median(values, origin);
        }

        public Seq<Certainty> copy$default$1() {
            return this.values();
        }

        public String copy$default$2() {
            return this.origin();
        }

        public Seq<Certainty> _1() {
            return this.values();
        }

        public String _2() {
            return this.origin();
        }
    }

    public static class PosNeg
    implements Product,
    Certainty {
        private final Certainty positive;
        private final Certainty negative;
        private final String origin;
        private final double value;

        public static PosNeg apply(Certainty certainty, Certainty certainty2, String string) {
            return Certainty$PosNeg$.MODULE$.apply(certainty, certainty2, string);
        }

        public static PosNeg fromProduct(Product product) {
            return Certainty$PosNeg$.MODULE$.fromProduct(product);
        }

        public static PosNeg unapply(PosNeg posNeg) {
            return Certainty$PosNeg$.MODULE$.unapply(posNeg);
        }

        public PosNeg(Certainty positive, Certainty negative, String origin) {
            this.positive = positive;
            this.negative = negative;
            this.origin = origin;
            this.value = Math.max(0.0, positive.value() - negative.value());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PosNeg)) return false;
            PosNeg posNeg = (PosNeg)object;
            Certainty certainty = this.positive();
            Certainty certainty2 = posNeg.positive();
            if (certainty == null) {
                if (certainty2 != null) {
                    return false;
                }
            } else if (!certainty.equals(certainty2)) return false;
            Certainty certainty3 = this.negative();
            Certainty certainty4 = posNeg.negative();
            if (certainty3 == null) {
                if (certainty4 != null) {
                    return false;
                }
            } else if (!certainty3.equals(certainty4)) return false;
            String string = this.origin();
            String string2 = posNeg.origin();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!posNeg.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PosNeg;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PosNeg";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "positive";
                }
                case 1: {
                    return "negative";
                }
                case 2: {
                    return "origin";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Certainty positive() {
            return this.positive;
        }

        public Certainty negative() {
            return this.negative;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public Calculation calculation() {
            return Calculation$.MODULE$.apply(StringOps$.MODULE$.format$extension("%03f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.value())})), (Seq<Calculation>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Calculation[]{this.positive().calculation(), Certainty$.MODULE$.ambience$datablend$proc$Certainty$$$prefixCalc(" - ", this.negative().calculation(), (Option<String>)Some$.MODULE$.apply((Object)")"))}))));
        }

        @Override
        public Description description() {
            return Description$.MODULE$.apply(StringOps$.MODULE$.format$extension("PosNeg(%s) %03f (%03f-%03f)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.origin(), BoxesRunTime.boxToDouble((double)this.value()), BoxesRunTime.boxToDouble((double)this.positive().value()), BoxesRunTime.boxToDouble((double)this.negative().value())})), (Seq<Description>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Description[]{this.positive().description(), Certainty$.MODULE$.ambience$datablend$proc$Certainty$$$prefixDesc(" - ", this.negative().description(), (Option<String>)Some$.MODULE$.apply((Object)")"))}))));
        }

        public PosNeg copy(Certainty positive, Certainty negative, String origin) {
            return new PosNeg(positive, negative, origin);
        }

        public Certainty copy$default$1() {
            return this.positive();
        }

        public Certainty copy$default$2() {
            return this.negative();
        }

        public String copy$default$3() {
            return this.origin();
        }

        public Certainty _1() {
            return this.positive();
        }

        public Certainty _2() {
            return this.negative();
        }

        public String _3() {
            return this.origin();
        }
    }

    public static class Score
    implements Product,
    Certainty {
        private final double value;
        private final String origin;

        public static Score apply(double d, String string) {
            return Certainty$Score$.MODULE$.apply(d, string);
        }

        public static Score fromProduct(Product product) {
            return Certainty$Score$.MODULE$.fromProduct(product);
        }

        public static Score unapply(Score score) {
            return Certainty$Score$.MODULE$.unapply(score);
        }

        public Score(double value, String origin) {
            this.value = value;
            this.origin = origin;
            Predef$.MODULE$.require(value >= 0.0 && value <= 1.0, () -> this.$init$$$anonfun$1(value));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.origin()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Score)) return false;
            Score score = (Score)object;
            if (this.value() != score.value()) return false;
            String string = this.origin();
            String string2 = score.origin();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!score.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Score;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Score";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToDouble((double)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "origin";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        @Override
        public Calculation calculation() {
            return Calculation$.MODULE$.apply(StringOps$.MODULE$.format$extension("%03f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.value())})), (Seq<Calculation>)scala.package$.MODULE$.Nil());
        }

        @Override
        public Description description() {
            return Description$.MODULE$.apply(Certainty$Score$.MODULE$ + "(" + this.origin() + ")", (Seq<Description>)scala.package$.MODULE$.Nil());
        }

        public Score copy(double value, String origin) {
            return new Score(value, origin);
        }

        public double copy$default$1() {
            return this.value();
        }

        public String copy$default$2() {
            return this.origin();
        }

        public double _1() {
            return this.value();
        }

        public String _2() {
            return this.origin();
        }

        private final Object $init$$$anonfun$1(double value$1) {
            return "Unexpected value: " + value$1;
        }
    }

    public static class Serialized
    implements Product,
    Serializable {
        private final double value;
        private final String origin;
        private final Calculation calculation;
        private final Description description;

        public static Serialized apply(double d, String string, Calculation calculation, Description description) {
            return Certainty$Serialized$.MODULE$.apply(d, string, calculation, description);
        }

        public static Serialized fromProduct(Product product) {
            return Certainty$Serialized$.MODULE$.fromProduct(product);
        }

        public static Serialized unapply(Serialized serialized) {
            return Certainty$Serialized$.MODULE$.unapply(serialized);
        }

        public Serialized(double value, String origin, Calculation calculation, Description description) {
            this.value = value;
            this.origin = origin;
            this.calculation = calculation;
            this.description = description;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.origin()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.calculation()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.description()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Serialized)) return false;
            Serialized serialized = (Serialized)object;
            if (this.value() != serialized.value()) return false;
            String string = this.origin();
            String string2 = serialized.origin();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Calculation calculation = this.calculation();
            Calculation calculation2 = serialized.calculation();
            if (calculation == null) {
                if (calculation2 != null) {
                    return false;
                }
            } else if (!((Object)calculation).equals(calculation2)) return false;
            Description description = this.description();
            Description description2 = serialized.description();
            if (description == null) {
                if (description2 != null) {
                    return false;
                }
            } else if (!((Object)description).equals(description2)) return false;
            if (!serialized.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Serialized;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Serialized";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "value";
                }
                case 1: {
                    return "origin";
                }
                case 2: {
                    return "calculation";
                }
                case 3: {
                    return "description";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double value() {
            return this.value;
        }

        public String origin() {
            return this.origin;
        }

        public Calculation calculation() {
            return this.calculation;
        }

        public Description description() {
            return this.description;
        }

        public Serialized copy(double value, String origin, Calculation calculation, Description description) {
            return new Serialized(value, origin, calculation, description);
        }

        public double copy$default$1() {
            return this.value();
        }

        public String copy$default$2() {
            return this.origin();
        }

        public Calculation copy$default$3() {
            return this.calculation();
        }

        public Description copy$default$4() {
            return this.description();
        }

        public double _1() {
            return this.value();
        }

        public String _2() {
            return this.origin();
        }

        public Calculation _3() {
            return this.calculation();
        }

        public Description _4() {
            return this.description();
        }
    }

    public static class Weighted
    implements Product,
    Certainty {
        private final double factor;
        private final Certainty certainty;
        private final String origin;
        private final double value;

        public static Weighted apply(double d, Certainty certainty, String string) {
            return Certainty$Weighted$.MODULE$.apply(d, certainty, string);
        }

        public static Weighted fromProduct(Product product) {
            return Certainty$Weighted$.MODULE$.fromProduct(product);
        }

        public static Weighted unapply(Weighted weighted) {
            return Certainty$Weighted$.MODULE$.unapply(weighted);
        }

        public Weighted(double factor, Certainty certainty, String origin) {
            this.factor = factor;
            this.certainty = certainty;
            this.origin = origin;
            Predef$.MODULE$.require(factor >= 0.0);
            this.value = Math.min(certainty.value() * factor, 1.0);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.factor()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.certainty()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.origin()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Weighted)) return false;
            Weighted weighted = (Weighted)object;
            if (this.factor() != weighted.factor()) return false;
            Certainty certainty = this.certainty();
            Certainty certainty2 = weighted.certainty();
            if (certainty == null) {
                if (certainty2 != null) {
                    return false;
                }
            } else if (!certainty.equals(certainty2)) return false;
            String string = this.origin();
            String string2 = weighted.origin();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!weighted.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Weighted;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Weighted";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "factor";
                }
                case 1: {
                    return "certainty";
                }
                case 2: {
                    return "origin";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double factor() {
            return this.factor;
        }

        public Certainty certainty() {
            return this.certainty;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public Calculation calculation() {
            return Calculation$.MODULE$.apply("", (Seq<Calculation>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Calculation[]{Certainty$.MODULE$.ambience$datablend$proc$Certainty$$$prefixCalc(this.factor() + " * ", this.certainty().calculation(), (Option<String>)None$.MODULE$)}))));
        }

        @Override
        public Description description() {
            return Description$.MODULE$.apply(StringOps$.MODULE$.format$extension("Weighted(%s) %03f (%03f*%03f)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.origin(), BoxesRunTime.boxToDouble((double)this.value()), BoxesRunTime.boxToDouble((double)this.certainty().value()), BoxesRunTime.boxToDouble((double)this.factor())})), (Seq<Description>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Description[]{this.certainty().description()}))));
        }

        public Weighted copy(double factor, Certainty certainty, String origin) {
            return new Weighted(factor, certainty, origin);
        }

        public double copy$default$1() {
            return this.factor();
        }

        public Certainty copy$default$2() {
            return this.certainty();
        }

        public String copy$default$3() {
            return this.origin();
        }

        public double _1() {
            return this.factor();
        }

        public Certainty _2() {
            return this.certainty();
        }

        public String _3() {
            return this.origin();
        }
    }

    public static class WeightedMean
    implements Product,
    Certainty {
        private final Seq values;
        private final Seq factors;
        private final String origin;
        private final double value;

        public static WeightedMean apply(Seq<Certainty> seq, Seq<Object> seq2, String string) {
            return Certainty$WeightedMean$.MODULE$.apply(seq, seq2, string);
        }

        public static WeightedMean fromProduct(Product product) {
            return Certainty$WeightedMean$.MODULE$.fromProduct(product);
        }

        public static WeightedMean unapply(WeightedMean weightedMean) {
            return Certainty$WeightedMean$.MODULE$.unapply(weightedMean);
        }

        public WeightedMean(Seq<Certainty> values, Seq<Object> factors, String origin) {
            this.values = values;
            this.factors = factors;
            this.origin = origin;
            Predef$.MODULE$.require(values.nonEmpty(), this::$init$$$anonfun$3);
            Predef$.MODULE$.require(values.size() == factors.size(), () -> this.$init$$$anonfun$4(values, factors));
            Predef$.MODULE$.require(package$.MODULE$.abs(BoxesRunTime.unboxToDouble((Object)factors.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)factors.size() - 1.0) < 1.0E-6, () -> this.$init$$$anonfun$5(factors));
            this.value = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)values.zip(factors)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Certainty v = (Certainty)tuple2._1();
                    double f = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                    return v.value() * f;
                }
                throw new MatchError((Object)tuple2);
            })).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)values.size();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WeightedMean)) return false;
            WeightedMean weightedMean = (WeightedMean)object;
            Seq<Certainty> seq = this.values();
            Seq<Certainty> seq2 = weightedMean.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<Object> seq3 = this.factors();
            Seq<Object> seq4 = weightedMean.factors();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            String string = this.origin();
            String string2 = weightedMean.origin();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!weightedMean.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WeightedMean;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WeightedMean";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "values";
                }
                case 1: {
                    return "factors";
                }
                case 2: {
                    return "origin";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<Certainty> values() {
            return this.values;
        }

        public Seq<Object> factors() {
            return this.factors;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public Calculation calculation() {
            return Calculation$.MODULE$.apply("WeightedMean", (Seq<Calculation>)((Seq)this.values().map((Function1 & Serializable)_$4 -> _$4.calculation())));
        }

        @Override
        public Description description() {
            return Description$.MODULE$.apply(StringOps$.MODULE$.format$extension("WeightedMean(%s) %03f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.origin(), BoxesRunTime.boxToDouble((double)this.value())})), (Seq<Description>)((Seq)this.values().map((Function1 & Serializable)_$5 -> _$5.description())));
        }

        public WeightedMean copy(Seq<Certainty> values, Seq<Object> factors, String origin) {
            return new WeightedMean(values, factors, origin);
        }

        public Seq<Certainty> copy$default$1() {
            return this.values();
        }

        public Seq<Object> copy$default$2() {
            return this.factors();
        }

        public String copy$default$3() {
            return this.origin();
        }

        public Seq<Certainty> _1() {
            return this.values();
        }

        public Seq<Object> _2() {
            return this.factors();
        }

        public String _3() {
            return this.origin();
        }

        private final Object $init$$$anonfun$3() {
            return "values is empty";
        }

        private final Object $init$$$anonfun$4(Seq values$1, Seq factors$1) {
            return "values size " + values$1.size() + " != factors size " + factors$1.size();
        }

        private final Object $init$$$anonfun$5(Seq factors$2) {
            return BoxesRunTime.unboxToDouble((Object)factors$2.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)factors$2.size() + " !=1.0";
        }
    }
}

