/*
 * Decompiled with CFR 0.152.
 */
package ambience.datablend.proc;

import ambience.datablend.parser.Alias;
import ambience.datablend.parser.Instruction;
import ambience.datablend.parser.Instructions;
import ambience.datablend.parser.Pattern;
import ambience.datablend.parser.Pattern$;
import ambience.datablend.parser.PostProcess;
import ambience.datablend.parser.PreProcess;
import ambience.datablend.proc.Token;
import ambience.datablend.proc.Token$Number$;
import ambience.datablend.proc.Token$Pattern$;
import ambience.datablend.proc.Token$Word$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import scala.util.matching.Regex;

public class Tokenizer2 {
    private final List preprocess;
    private final List patterns;
    private final List aliases;
    private final List postprocess;
    private final Map aliasMap;
    private final int cycleThreshold;

    public Tokenizer2(Instructions instructions) {
        this.preprocess = instructions.items().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Instruction x) {
                Instruction instruction = x;
                if (instruction instanceof PreProcess) {
                    PreProcess pp = (PreProcess)instruction;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Instruction x, Function1 function1) {
                Instruction instruction = x;
                if (instruction instanceof PreProcess) {
                    PreProcess pp = (PreProcess)instruction;
                    return pp;
                }
                return function1.apply((Object)x);
            }
        });
        this.patterns = instructions.items().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Instruction x) {
                Instruction instruction = x;
                if (instruction instanceof Pattern) {
                    Pattern p = (Pattern)instruction;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Instruction x, Function1 function1) {
                Instruction instruction = x;
                if (instruction instanceof Pattern) {
                    Pattern p = (Pattern)instruction;
                    return p;
                }
                return function1.apply((Object)x);
            }
        });
        this.aliases = instructions.items().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Instruction x) {
                Instruction instruction = x;
                if (instruction instanceof Alias) {
                    Alias a = (Alias)instruction;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Instruction x, Function1 function1) {
                Instruction instruction = x;
                if (instruction instanceof Alias) {
                    Alias a = (Alias)instruction;
                    return a;
                }
                return function1.apply((Object)x);
            }
        });
        this.postprocess = instructions.items().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Instruction x) {
                Instruction instruction = x;
                if (instruction instanceof PostProcess) {
                    PostProcess pp = (PostProcess)instruction;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Instruction x, Function1 function1) {
                Instruction instruction = x;
                if (instruction instanceof PostProcess) {
                    PostProcess pp = (PostProcess)instruction;
                    return pp;
                }
                return function1.apply((Object)x);
            }
        });
        this.aliasMap = this.aliases().map((Function1 & Serializable)a -> {
            Token token = (Token)Predef$.MODULE$.ArrowAssoc((Object)a.from());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)token, (Object)a.to());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.cycleThreshold = 5;
    }

    public List<PreProcess> preprocess() {
        return this.preprocess;
    }

    public List<Pattern> patterns() {
        return this.patterns;
    }

    public List<Alias> aliases() {
        return this.aliases;
    }

    public List<PostProcess> postprocess() {
        return this.postprocess;
    }

    public Map<Token, Token> aliasMap() {
        return this.aliasMap;
    }

    public int cycleThreshold() {
        return this.cycleThreshold;
    }

    public List<Token> run(String s) {
        String stage1 = s.trim().toUpperCase();
        String stage2 = (String)this.preprocess().foldLeft((Object)stage1, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                String s = (String)tuple2._1();
                PreProcess c = (PreProcess)tuple2._2();
                return s.replace(c.from(), c.to());
            }
            throw new MatchError((Object)tuple2);
        });
        List<Token> tokens = this._run(stage2, this._run$default$2());
        return this.post((List<Token>)tokens.map((Function1 & Serializable)x$1 -> {
            Token.Word word;
            String string;
            String s;
            Token token;
            Token w = token = x$1;
            if (this.aliasMap().contains((Object)w)) {
                return (Token)this.aliasMap().apply((Object)w);
            }
            if (token instanceof Token.Word && Try$.MODULE$.apply(() -> Tokenizer2.run$$anonfun$1$$anonfun$1(s = (string = (word = Token$Word$.MODULE$.unapply((Token.Word)token))._1()))).toOption().isDefined()) {
                return Token$Number$.MODULE$.apply(s);
            }
            Token token2 = token;
            return token2;
        }));
    }

    private List<Token> post(List<Token> tokens) {
        List<Token> list = tokens;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Token> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return tokens;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Token head = (Token)colon2.head();
            List tail = list3;
            Option optPP = this.postprocess().find((Function1 & Serializable)pp -> tokens.startsWith(pp.from(), tokens.startsWith$default$2()));
            Option option = optPP;
            if (option instanceof Some) {
                PostProcess pp2 = (PostProcess)((Some)option).value();
                return this.post((List<Token>)((List)tokens.drop(pp2.from().length()))).$colon$colon$colon(pp2.to());
            }
            if (None$.MODULE$.equals(option)) {
                return this.post((List<Token>)tail).$colon$colon((Object)head);
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError(list);
    }

    private String fill(Regex.Match m, String s) {
        IntRef i = IntRef.create((int)1);
        ObjectRef ret = ObjectRef.create((Object)s);
        while (i.elem <= m.groupCount()) {
            int n;
            Option$.MODULE$.apply((Object)m.group(i.elem)).foreach((Function1)(JProcedure1 & Serializable)g -> {
                String string = ((String)ret$1.elem).replace("$" + i$1.elem, (CharSequence)g);
                ret$1.elem = string;
                string = null;
            });
            i.elem = n = i.elem + 1;
        }
        return (String)ret.elem;
    }

    private List<Token> _run(String s2, List<Token> results) {
        Option option;
        while (true) {
            Pattern pattern;
            Tuple2 tuple2;
            if (s2.isEmpty()) {
                return results.reverse();
            }
            LazyList matches = package$.MODULE$.LazyList().concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{this.patterns()})).flatMap((Function1 & Serializable)pat -> pat.regex().findPrefixMatchOf((CharSequence)s2).map((Function1 & Serializable)pref -> Tuple2$.MODULE$.apply(pat, pref)));
            option = matches.headOption();
            if (None$.MODULE$.equals(option)) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])s2.split(" "));
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.trim(), ClassTag$.MODULE$.apply(String.class)));
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))));
                List looseWords = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)s -> Token$Word$.MODULE$.apply((String)s), ClassTag$.MODULE$.apply(Token.Word.class))).toList();
                String string = "";
                List list = results.$colon$colon$colon(looseWords);
                s2 = string;
                results = list;
                continue;
            }
            if (!(option instanceof Some) || (tuple2 = (Tuple2)((Some)option).value()) == null || (pattern = (Pattern)tuple2._1()) == null) break;
            Pattern pattern2 = Pattern$.MODULE$.unapply(pattern);
            Regex regex = pattern2._1();
            String string = pattern2._2();
            String string2 = pattern2._3();
            String name = string;
            String value = string2;
            Regex.Match m = (Regex.Match)tuple2._2();
            String string3 = s2.substring(m.end());
            Token.Pattern pattern3 = Token$Pattern$.MODULE$.apply(name, this.fill(m, value));
            List list = results.$colon$colon((Object)pattern3);
            s2 = string3;
            results = list;
        }
        throw new MatchError((Object)option);
    }

    private List<Token> _run$default$2() {
        return package$.MODULE$.Nil();
    }

    private static final int run$$anonfun$1$$anonfun$1(String s$1) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s$1));
    }
}

