/*
 * Decompiled with CFR 0.152.
 */
package ambience.datablend.proc;

import ambience.datablend.proc.Certainty;
import ambience.datablend.proc.Certainty$Mean$;
import ambience.datablend.proc.Certainty$PosNeg$;
import ambience.datablend.proc.Certainty$Score$;
import ambience.datablend.proc.Certainty$Weighted$;
import ambience.datablend.proc.Certainty$WeightedMean$;
import ambience.datablend.proc.Model;
import ambience.datablend.proc.Model$Pair$;
import ambience.datablend.proc.Model$PairData$;
import ambience.datablend.proc.Token;
import ambience.datablend.proc.WordFrequency;
import ambience.datablend.proc.WordFrequencyBlend$;
import ambience.datablend.proc.WordFrequencyBlend$BlendData$;
import ambience.datablend.proc.WordFrequencyBlend$Column$;
import ambience.datablend.proc.WordFrequencyBlend$Intersection$;
import ambience.datablend.proc.WordFrequencyBlend$Match$;
import ambience.datablend.proc.WordFrequencyBlend$Weighting$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class WordFrequencyBlend {
    private final Model.Desc[] target;
    private final Column[] columns;

    public static Intersection intersect(Set<Token> set, Set<Token> set2) {
        return WordFrequencyBlend$.MODULE$.intersect(set, set2);
    }

    public static Set<Token> plurals(Set<Token.Word> set, Set<Token.Word> set2) {
        return WordFrequencyBlend$.MODULE$.plurals(set, set2);
    }

    public static Set<Token.Word> singularAndPlural(Token.Word word) {
        return WordFrequencyBlend$.MODULE$.singularAndPlural(word);
    }

    public WordFrequencyBlend(Model.Desc[] target, Column[] columns) {
        this.target = target;
        this.columns = columns;
    }

    public Model.Desc[] target() {
        return this.target;
    }

    public BlendData getData() {
        return WordFrequencyBlend$BlendData$.MODULE$.apply(this.target(), this.columns);
    }

    public Match run(Model.Desc src) {
        Model.Desc bestDesc = null;
        Certainty bestCert = null;
        double bestValue = -1.0;
        for (int i = 0; i < this.target().length; ++i) {
            Certainty result = this.matches(src, this.target()[i]);
            double resultValue = result.value();
            if (!(resultValue > bestValue)) continue;
            bestDesc = this.target()[i];
            bestCert = result;
            bestValue = resultValue;
        }
        return WordFrequencyBlend$Match$.MODULE$.apply(bestDesc, bestCert);
    }

    private Certainty matches(Model.Desc a, Model.Desc b) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.columns);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        List useful = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$1 -> ((Column)_$1._1()).weighting().overall() > 0.0)).toList();
        List certainties = useful.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Column col = (Column)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Column column = (Column)Predef$.MODULE$.ArrowAssoc((Object)col);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)column, (Object)this.matches(col, (Set<Token>)((Set)a.words().apply(idx)), (Set<Token>)((Set)b.words().apply(idx))));
            }
            throw new MatchError((Object)tuple2);
        });
        if (certainties.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Column col = (Column)tuple2._1();
                Certainty cert = (Certainty)tuple2._2();
                return col.weighting().essential() && cert.value() == 0.0;
            }
            throw new MatchError((Object)tuple2);
        })) {
            return Certainty$Score$.MODULE$.apply(0.0, "Essential missing");
        }
        return Certainty$WeightedMean$.MODULE$.apply((Seq<Certainty>)certainties.map((Function1 & Serializable)_$2 -> (Certainty)_$2._2()), (Seq<Object>)useful.map((Function1 & Serializable)_$3 -> ((Column)_$3._1()).weighting().overall()), "Across all fields");
    }

    private Certainty matches(Column col, Set<Token> a, Set<Token> b) {
        Set<Token> set = a;
        Set<Token> set2 = b;
        if (!(set != null ? !set.equals(set2) : set2 != null)) {
            return Certainty$Weighted$.MODULE$.apply(col.weighting().plus(), Certainty$Score$.MODULE$.apply(1.0, "Exact match"), "Balance");
        }
        Intersection intersection = WordFrequencyBlend$.MODULE$.intersect(a, b);
        if (intersection.matching().nonEmpty()) {
            double weightingMinus = intersection.matching().size() + 2 < intersection.different().size() ? 1.0 : col.weighting().minus();
            Certainty.Mean plus = Certainty$Mean$.MODULE$.apply((Seq<Certainty>)((IterableOnceOps)intersection.matching().map((Function1 & Serializable)t -> this.ranking(col.wf(), (Token)t))).toSeq(), "Tokens in field");
            Certainty.Weighted plusScore = Certainty$Weighted$.MODULE$.apply(col.weighting().plus(), plus, "Positive");
            Certainty.Score minus = intersection.different().nonEmpty() ? Certainty$Mean$.MODULE$.apply((Seq<Certainty>)((IterableOnceOps)intersection.different().map((Function1 & Serializable)t -> this.ranking(col.wf(), (Token)t))).toSeq(), "Tokens missing") : Certainty$Score$.MODULE$.apply(0.0, "All present");
            Certainty.Weighted minusScore = Certainty$Weighted$.MODULE$.apply(weightingMinus, minus, "Negative");
            return Certainty$PosNeg$.MODULE$.apply(plusScore, minusScore, "Overall");
        }
        return Certainty$Score$.MODULE$.apply(0.0, "No similarity " + a.mkString("[", ",", "] ") + b.mkString("[", ",", "]"));
    }

    public Certainty ranking(WordFrequency wf, Token token) {
        Token token2 = token;
        if (token2 instanceof Token.Pattern) {
            Token.Pattern b = (Token.Pattern)token2;
            return Certainty$Score$.MODULE$.apply(1.0, b.name() + "(" + b.value() + ")");
        }
        if (token2 instanceof Token.Number) {
            Token.Number b = (Token.Number)token2;
            return Certainty$Score$.MODULE$.apply(1.0, "Exact number " + b.toString());
        }
        if (token2 instanceof Token.Word) {
            Token.Word b = (Token.Word)token2;
            return Certainty$Weighted$.MODULE$.apply(wf.ranking(b.s()), Certainty$Score$.MODULE$.apply(1.0, StringOps$.MODULE$.format$extension("Exact word %s (%03f)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{b.s(), BoxesRunTime.boxToDouble((double)wf.ranking(b.s()))}))), "Word ranking");
        }
        throw new MatchError((Object)token2);
    }

    public static final /* synthetic */ IterableOnce ambience$datablend$proc$WordFrequencyBlend$Results$$_$certainty$$anonfun$1(double min$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Model.Desc desc = (Model.Desc)tuple2._1();
            Object[] ms = (Match[])tuple2._2();
            Object object = Predef$.MODULE$.refArrayOps(ms);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)m -> m.certainty().value() >= min$1));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)m -> Model$Pair$.MODULE$.apply(desc.original().idx(), m.desc().original().idx(), m.certainty().value()), ClassTag$.MODULE$.apply(Model.Pair.class)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ IterableOnce ambience$datablend$proc$WordFrequencyBlend$Results$$_$certaintyData$$anonfun$1(double min$3, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Model.Desc desc = (Model.Desc)tuple2._1();
            Object[] ms = (Match[])tuple2._2();
            Object object = Predef$.MODULE$.refArrayOps(ms);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)m -> m.certainty().value() >= min$3));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)m -> Model$PairData$.MODULE$.apply(desc.original(), m.desc().original(), m.certainty().serialize()), ClassTag$.MODULE$.apply(Model.PairData.class)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static class BlendData
    implements Product,
    Serializable {
        private final Model.Desc[] target;
        private final Column[] columns;

        public static BlendData apply(Model.Desc[] descArray, Column[] columnArray) {
            return WordFrequencyBlend$BlendData$.MODULE$.apply(descArray, columnArray);
        }

        public static BlendData fromProduct(Product product) {
            return WordFrequencyBlend$BlendData$.MODULE$.fromProduct(product);
        }

        public static BlendData unapply(BlendData blendData) {
            return WordFrequencyBlend$BlendData$.MODULE$.unapply(blendData);
        }

        public BlendData(Model.Desc[] target, Column[] columns) {
            this.target = target;
            this.columns = columns;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BlendData)) return false;
            BlendData blendData = (BlendData)object;
            if (this.target() != blendData.target()) return false;
            if (this.columns() != blendData.columns()) return false;
            if (!blendData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BlendData;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BlendData";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "target";
            }
            if (1 == n2) {
                return "columns";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Model.Desc[] target() {
            return this.target;
        }

        public Column[] columns() {
            return this.columns;
        }

        public WordFrequencyBlend toBlend() {
            return new WordFrequencyBlend(this.target(), this.columns());
        }

        public BlendData copy(Model.Desc[] target, Column[] columns) {
            return new BlendData(target, columns);
        }

        public Model.Desc[] copy$default$1() {
            return this.target();
        }

        public Column[] copy$default$2() {
            return this.columns();
        }

        public Model.Desc[] _1() {
            return this.target();
        }

        public Column[] _2() {
            return this.columns();
        }
    }

    public static class Column
    implements Product,
    Serializable {
        private final WordFrequency wf;
        private final Weighting weighting;

        public static Column apply(WordFrequency wordFrequency, Weighting weighting) {
            return WordFrequencyBlend$Column$.MODULE$.apply(wordFrequency, weighting);
        }

        public static Column fromProduct(Product product) {
            return WordFrequencyBlend$Column$.MODULE$.fromProduct(product);
        }

        public static Column unapply(Column column) {
            return WordFrequencyBlend$Column$.MODULE$.unapply(column);
        }

        public Column(WordFrequency wf, Weighting weighting) {
            this.wf = wf;
            this.weighting = weighting;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Column)) return false;
            Column column = (Column)object;
            WordFrequency wordFrequency = this.wf();
            WordFrequency wordFrequency2 = column.wf();
            if (wordFrequency == null) {
                if (wordFrequency2 != null) {
                    return false;
                }
            } else if (!((Object)wordFrequency).equals(wordFrequency2)) return false;
            Weighting weighting = this.weighting();
            Weighting weighting2 = column.weighting();
            if (weighting == null) {
                if (weighting2 != null) {
                    return false;
                }
            } else if (!((Object)weighting).equals(weighting2)) return false;
            if (!column.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Column;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Column";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "wf";
            }
            if (1 == n2) {
                return "weighting";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public WordFrequency wf() {
            return this.wf;
        }

        public Weighting weighting() {
            return this.weighting;
        }

        public Column copy(WordFrequency wf, Weighting weighting) {
            return new Column(wf, weighting);
        }

        public WordFrequency copy$default$1() {
            return this.wf();
        }

        public Weighting copy$default$2() {
            return this.weighting();
        }

        public WordFrequency _1() {
            return this.wf();
        }

        public Weighting _2() {
            return this.weighting();
        }
    }

    public static class Intersection
    implements Product,
    Serializable {
        private final Set matching;
        private final Set different;

        public static Intersection apply(Set<Token> set, Set<Token> set2) {
            return WordFrequencyBlend$Intersection$.MODULE$.apply(set, set2);
        }

        public static Intersection fromProduct(Product product) {
            return WordFrequencyBlend$Intersection$.MODULE$.fromProduct(product);
        }

        public static Intersection unapply(Intersection intersection) {
            return WordFrequencyBlend$Intersection$.MODULE$.unapply(intersection);
        }

        public Intersection(Set<Token> matching, Set<Token> different) {
            this.matching = matching;
            this.different = different;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Intersection)) return false;
            Intersection intersection = (Intersection)object;
            Set<Token> set = this.matching();
            Set<Token> set2 = intersection.matching();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<Token> set3 = this.different();
            Set<Token> set4 = intersection.different();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            if (!intersection.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Intersection;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Intersection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "matching";
            }
            if (1 == n2) {
                return "different";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Token> matching() {
            return this.matching;
        }

        public Set<Token> different() {
            return this.different;
        }

        public Intersection copy(Set<Token> matching, Set<Token> different) {
            return new Intersection(matching, different);
        }

        public Set<Token> copy$default$1() {
            return this.matching();
        }

        public Set<Token> copy$default$2() {
            return this.different();
        }

        public Set<Token> _1() {
            return this.matching();
        }

        public Set<Token> _2() {
            return this.different();
        }
    }

    public static class Match
    implements Product,
    Serializable {
        private final Model.Desc desc;
        private final Certainty certainty;

        public static Match apply(Model.Desc desc, Certainty certainty) {
            return WordFrequencyBlend$Match$.MODULE$.apply(desc, certainty);
        }

        public static Match fromProduct(Product product) {
            return WordFrequencyBlend$Match$.MODULE$.fromProduct(product);
        }

        public static Match unapply(Match match) {
            return WordFrequencyBlend$Match$.MODULE$.unapply(match);
        }

        public Match(Model.Desc desc, Certainty certainty) {
            this.desc = desc;
            this.certainty = certainty;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Match)) return false;
            Match match = (Match)object;
            Model.Desc desc = this.desc();
            Model.Desc desc2 = match.desc();
            if (desc == null) {
                if (desc2 != null) {
                    return false;
                }
            } else if (!((Object)desc).equals(desc2)) return false;
            Certainty certainty = this.certainty();
            Certainty certainty2 = match.certainty();
            if (certainty == null) {
                if (certainty2 != null) {
                    return false;
                }
            } else if (!certainty.equals(certainty2)) return false;
            if (!match.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Match;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Match";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "desc";
            }
            if (1 == n2) {
                return "certainty";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Model.Desc desc() {
            return this.desc;
        }

        public Certainty certainty() {
            return this.certainty;
        }

        public Match copy(Model.Desc desc, Certainty certainty) {
            return new Match(desc, certainty);
        }

        public Model.Desc copy$default$1() {
            return this.desc();
        }

        public Certainty copy$default$2() {
            return this.certainty();
        }

        public Model.Desc _1() {
            return this.desc();
        }

        public Certainty _2() {
            return this.certainty();
        }
    }

    public class Results {
        private final Map<Model.Desc, Match[]> combined;
        private final /* synthetic */ WordFrequencyBlend $outer;

        public Results(WordFrequencyBlend $outer, Map<Model.Desc, Match[]> combined) {
            this.combined = combined;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Vector<Model.Pair> certainty(double min) {
            return (Vector)this.combined.toVector().flatMap(arg_0 -> WordFrequencyBlend.ambience$datablend$proc$WordFrequencyBlend$Results$$_$certainty$$anonfun$1(min, arg_0));
        }

        public Vector<Model.PairData> certaintyData(double min) {
            return (Vector)this.combined.toVector().flatMap(arg_0 -> WordFrequencyBlend.ambience$datablend$proc$WordFrequencyBlend$Results$$_$certaintyData$$anonfun$1(min, arg_0));
        }

        public final /* synthetic */ WordFrequencyBlend ambience$datablend$proc$WordFrequencyBlend$Results$$$outer() {
            return this.$outer;
        }
    }

    public static class Weighting
    implements Product,
    Serializable {
        private final boolean essential;
        private final double overall;
        private final double plus;
        private final double minus;

        public static Weighting apply(boolean bl, double d, double d2, double d3) {
            return WordFrequencyBlend$Weighting$.MODULE$.apply(bl, d, d2, d3);
        }

        public static Weighting fromProduct(Product product) {
            return WordFrequencyBlend$Weighting$.MODULE$.fromProduct(product);
        }

        public static Weighting unapply(Weighting weighting) {
            return WordFrequencyBlend$Weighting$.MODULE$.unapply(weighting);
        }

        public static double $lessinit$greater$default$2() {
            return WordFrequencyBlend$Weighting$.MODULE$.$lessinit$greater$default$2();
        }

        public static double $lessinit$greater$default$3() {
            return WordFrequencyBlend$Weighting$.MODULE$.$lessinit$greater$default$3();
        }

        public static double $lessinit$greater$default$4() {
            return WordFrequencyBlend$Weighting$.MODULE$.$lessinit$greater$default$4();
        }

        public Weighting(boolean essential, double overall, double plus, double minus) {
            this.essential = essential;
            this.overall = overall;
            this.plus = plus;
            this.minus = minus;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.essential() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.overall()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.plus()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minus()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Weighting)) return false;
            Weighting weighting = (Weighting)object;
            if (this.essential() != weighting.essential()) return false;
            if (this.overall() != weighting.overall()) return false;
            if (this.plus() != weighting.plus()) return false;
            if (this.minus() != weighting.minus()) return false;
            if (!weighting.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Weighting;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Weighting";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "essential";
                }
                case 1: {
                    return "overall";
                }
                case 2: {
                    return "plus";
                }
                case 3: {
                    return "minus";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean essential() {
            return this.essential;
        }

        public double overall() {
            return this.overall;
        }

        public double plus() {
            return this.plus;
        }

        public double minus() {
            return this.minus;
        }

        public Weighting copy(boolean essential, double overall, double plus, double minus) {
            return new Weighting(essential, overall, plus, minus);
        }

        public boolean copy$default$1() {
            return this.essential();
        }

        public double copy$default$2() {
            return this.overall();
        }

        public double copy$default$3() {
            return this.plus();
        }

        public double copy$default$4() {
            return this.minus();
        }

        public boolean _1() {
            return this.essential();
        }

        public double _2() {
            return this.overall();
        }

        public double _3() {
            return this.plus();
        }

        public double _4() {
            return this.minus();
        }
    }
}

