/*
 * Decompiled with CFR 0.152.
 */
package ambience.usersettings;

import ambience.usersettings.IdentityConfig;
import ambience.usersettings.IdentityConfig$;
import ambience.usersettings.IdentityModel$ErrorCodes$;
import ambience.usersettings.PasswordValidator;
import ambience.usersettings.PasswordValidator$UserInfo$;
import com.elixirtech.identity.HashedString;
import com.elixirtech.identity.UserManagement$;
import java.io.Serializable;
import scala.Char$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class PasswordValidator$
implements Serializable {
    public static final PasswordValidator$UserInfo$ UserInfo;
    public static final PasswordValidator$ MODULE$;

    private PasswordValidator$() {
    }

    static {
        MODULE$ = new PasswordValidator$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PasswordValidator$.class);
    }

    public Either<Object, String> check(Option<PasswordValidator.UserInfo> optUser, String name, String s) {
        IdentityConfig.PasswordPolicy policy = IdentityConfig$.MODULE$.passwordPolicy();
        String password = s.trim();
        return this.checkLength(policy, password).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.hasNecessarySpecialCharacters(policy, password).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.checkRegEx(policy, password).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.alreadyUsed(policy, optUser, password).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return package$.MODULE$.Right().apply((Object)new HashedString(UserManagement$.MODULE$.encrypt(name, password))).map((Function1 & Serializable)v1 -> new HashedString(this.check$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(v1 == null ? null : ((HashedString)v1).value())));
                    });
                });
            });
        });
    }

    private Either<Object, BoxedUnit> checkLength(IdentityConfig.PasswordPolicy policy, String password) {
        int len = password.length();
        if (len == 0) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordBlank()));
        }
        if (len < policy.minLength()) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyMinLength()));
        }
        if (policy.maxLength() > 0 && len > policy.maxLength()) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyMaxLength()));
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private Either<Object, BoxedUnit> alreadyUsed(IdentityConfig.PasswordPolicy policy, Option<PasswordValidator.UserInfo> optUser, String password) {
        return (Either)optUser.map((Function1 & Serializable)user -> {
            List previousPasswords;
            if (policy.notSameAsLogon()) {
                String string = user.name();
                String string2 = password;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicySameAsName()));
                }
            }
            if ((previousPasswords = user.previousPasswords().take(policy.differentPasswordCount())).exists((Function1 & Serializable)hash -> this.alreadyUsed$$anonfun$1$$anonfun$1((PasswordValidator.UserInfo)user, password, hash == null ? null : ((HashedString)hash).value()))) {
                return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyAlreadyUsed()));
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }).getOrElse(this::alreadyUsed$$anonfun$2);
    }

    private Either<Object, BoxedUnit> hasNecessarySpecialCharacters(IdentityConfig.PasswordPolicy policy, String password) {
        BooleanRef hasDigit = BooleanRef.create((boolean)false);
        BooleanRef hasLower = BooleanRef.create((boolean)false);
        BooleanRef hasUpper = BooleanRef.create((boolean)false);
        BooleanRef hasSymbol = BooleanRef.create((boolean)false);
        BooleanRef hasNotSymbol = BooleanRef.create((boolean)false);
        String symbols = policy.mustHaveSymbolSet();
        String notSymbols = policy.mustNotHaveSymbolSet();
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(password), (Function1 & Serializable)v1 -> {
            this.hasNecessarySpecialCharacters$$anonfun$1(hasDigit, hasLower, hasUpper, hasSymbol, symbols, hasNotSymbol, notSymbols, BoxesRunTime.unboxToChar((Object)v1));
            return BoxedUnit.UNIT;
        });
        if (hasNotSymbol.elem) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyDisallowedSymbol()));
        }
        if (!hasDigit.elem && policy.mustHaveDigit()) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyNoDigit()));
        }
        if (!hasUpper.elem && policy.mustHaveUpperCase()) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyNoUpperCase()));
        }
        if (!hasLower.elem && policy.mustHaveLowerCase()) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyNoLowerCase()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(symbols)) && !hasSymbol.elem) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyNoSymbol()));
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private Either<Object, BoxedUnit> checkRegEx(IdentityConfig.PasswordPolicy policy, String password) {
        if (policy.disallowedRegex().exists((Function1 & Serializable)re -> re.matches((CharSequence)password))) {
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)IdentityModel$ErrorCodes$.MODULE$.PasswordPolicyFailsRegEx()));
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final /* synthetic */ String check$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String encrypted) {
        return encrypted;
    }

    private final /* synthetic */ boolean alreadyUsed$$anonfun$1$$anonfun$1(PasswordValidator.UserInfo user$1, String password$6, String hash) {
        return UserManagement$.MODULE$.validate(user$1.name(), password$6, hash);
    }

    private final Either alreadyUsed$$anonfun$2() {
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final /* synthetic */ void hasNecessarySpecialCharacters$$anonfun$1(BooleanRef hasDigit$1, BooleanRef hasLower$1, BooleanRef hasUpper$1, BooleanRef hasSymbol$1, String symbols$1, BooleanRef hasNotSymbol$1, String notSymbols$1, char ch) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        hasDigit$1.elem = bl5 = hasDigit$1.elem | Character.isDigit(ch);
        hasLower$1.elem = bl4 = hasLower$1.elem | Character.isLowerCase(ch);
        hasUpper$1.elem = bl3 = hasUpper$1.elem | Character.isUpperCase(ch);
        hasSymbol$1.elem = bl2 = hasSymbol$1.elem | symbols$1.indexOf(Char$.MODULE$.char2int(ch)) >= 0;
        hasNotSymbol$1.elem = bl = hasNotSymbol$1.elem | notSymbols$1.indexOf(Char$.MODULE$.char2int(ch)) >= 0;
    }
}

