/*
 * Decompiled with CFR 0.152.
 */
package ambience.identity;

import ambience.identity.IdentityConfig$;
import ambience.identity.IdentityModel;
import ambience.identity.IdentityModel$ResetUserPasswordFailed$;
import ambience.identity.IdentityModel$ResetUserPasswordOk$;
import ambience.identity.IdentityModel$User$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.identity.UserManagement$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonBoolean;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ResetPasswordUtil$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ResetPasswordUtil$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final ResetPasswordUtil$ MODULE$ = new ResetPasswordUtil$();

    private ResetPasswordUtil$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResetPasswordUtil$.class);
    }

    public Task<IdentityModel.ResetUserPasswordResponse> run(CodexCollection identities, BsonObjectId oid, boolean forceChangePassword) {
        return this.getById(identities, oid).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                IdentityModel.User user = (IdentityModel.User)((Some)option).value();
                return this.resetUserPassword(identities, user, forceChangePassword);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)IdentityModel$ResetUserPasswordFailed$.MODULE$.apply(oid.getValue().toHexString(), "Reset password id not found"));
            }
            throw new MatchError((Object)option);
        });
    }

    private Task<Option<IdentityModel.User>> getById(CodexCollection identities, BsonObjectId oid) {
        return identities.findO(this.whereId(oid)).map((Function1 & Serializable)doc -> this.toUser((Document)doc)).firstOptionL();
    }

    private IdentityModel.User toUser(Document doc) {
        String id = doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asObjectId().getValue().toHexString();
        String name = doc.apply("name", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue();
        boolean enabled = BoxesRunTime.unboxToBoolean((Object)doc.get("enabled", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$1 -> _$1.asBoolean().getValue()).getOrElse(this::$anonfun$2));
        boolean changePassword = BoxesRunTime.unboxToBoolean((Object)doc.get("changePassword", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$2 -> _$2.asBoolean().getValue()).getOrElse(this::$anonfun$4));
        String email = (String)doc.get("email", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$3 -> _$3.asString().getValue()).getOrElse(this::$anonfun$6);
        long lastPasswordChange = BoxesRunTime.unboxToLong((Object)doc.get("lastPasswordChange", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$4 -> _$4.asDateTime().getValue()).getOrElse(this::$anonfun$8));
        return IdentityModel$User$.MODULE$.apply(id, name, enabled, changePassword, email, lastPasswordChange);
    }

    private Task<IdentityModel.ResetUserPasswordResponse> resetUserPassword(CodexCollection identities, IdentityModel.User user, boolean forceChangePassword) {
        if (user.email().trim().isEmpty()) {
            return Task$.MODULE$.now((Object)IdentityModel$ResetUserPasswordFailed$.MODULE$.apply(user.name(), "Reset password email not found"));
        }
        String newpass = UserManagement$.MODULE$.buildRandomPassword();
        String encrypted = UserManagement$.MODULE$.encrypt(user.id(), newpass);
        return this.setPassword(identities, BsonObjectId$.MODULE$.apply(user.id()), encrypted, forceChangePassword).map((Function1 & Serializable)_$5 -> IdentityModel$ResetUserPasswordOk$.MODULE$.apply(user.name(), user.email(), newpass));
    }

    private Task<BoxedUnit> setPassword(CodexCollection identities, BsonObjectId oid, String pass, boolean forceChangePassword) {
        CodexFilter id = this.whereId(oid);
        CodexFindOptions options = CodexFindOptions$.MODULE$.projections((CodexFindOptions.Projection)CodexFindOptions.Retain$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"password"})));
        return identities.findO(id, options).firstOptionL().flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                BsonString currentPassword = (BsonString)doc.get("password", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).getOrElse(this::$anonfun$9);
                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)IdentityConfig$.MODULE$.passwordPolicy().differentPasswordCount()));
                Some some2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
                CodexUpdate.PushOptions options = CodexUpdate.PushOptions$.MODULE$.apply((Option)some2, (Option)some);
                List updatesList = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)CodexUpdate.PushEach$.MODULE$.apply("oldPasswords", options, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonValue[]{currentPassword}))), Some$.MODULE$.apply((Object)CodexUpdate.CurrentTimestamp$.MODULE$.apply("lastPasswordChange")), Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("password", (BsonValue)new BsonString(pass))), Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("failedLogins", (BsonValue)new BsonInt32(0))), forceChangePassword ? Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("changePassword", (BsonValue)new BsonBoolean(true))) : None$.MODULE$}));
                CodexUpdate.Combine updates = CodexUpdate.Combine$.MODULE$.apply((Seq)updatesList.flatten(Predef$.MODULE$.$conforms()));
                return identities.updateOneT(id, (CodexUpdate)updates).map((Function1)(JProcedure1 & Serializable)_$6 -> {});
            }
            if (None$.MODULE$.equals(option)) {
                this.log().error(() -> this.setPassword$$anonfun$1$$anonfun$2(oid), Line$.MODULE$.apply(83), FullName$.MODULE$.apply("ambience.identity.ResetPasswordUtil.setPassword"));
                return Task$.MODULE$.unit();
            }
            throw new MatchError((Object)option);
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            this.log().error(() -> this.setPassword$$anonfun$2$$anonfun$1(ex), ex, Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.identity.ResetPasswordUtil.setPassword"));
        });
    }

    private CodexFilter whereId(BsonObjectId oid) {
        return CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)oid);
    }

    private final boolean $anonfun$2() {
        return false;
    }

    private final boolean $anonfun$4() {
        return false;
    }

    private final String $anonfun$6() {
        return "";
    }

    private final long $anonfun$8() {
        return 0L;
    }

    private final BsonString $anonfun$9() {
        return BsonString$.MODULE$.apply("<missing>");
    }

    private final Object setPassword$$anonfun$1$$anonfun$2(BsonObjectId oid$3) {
        return "Can't set password of " + oid$3.getValue().toHexString() + " - user not found";
    }

    private final Object setPassword$$anonfun$2$$anonfun$1(Throwable ex$1) {
        return "Error in setPassword: " + ex$1;
    }
}

