/*
 * Decompiled with CFR 0.152.
 */
package ambience.workflow.designer;

import ambience.etl.ChainSetId$;
import ambience.etl.ChainSetIdentifier;
import ambience.etl.ChainSetLookup;
import ambience.etl.ETLStepType$;
import ambience.gravity.GravityHelper$;
import ambience.module.CustomOAuth2Client;
import ambience.module.Module;
import ambience.module.PrivilegeSupplier;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import ambience.workflow.WorkflowAPI;
import ambience.workflow.designer.db.WorkflowDB;
import ambience.workflow.designer.db.WorkflowMongoDB;
import ambience.workflow.engine.ChainExecutor;
import ambience.workflow.engine.WorkflowEngine$;
import ambience.workflow.engine.WorkflowExecutor;
import ambience.workflow.engine.db.DefaultWorkflowInstanceErrorDB;
import ambience.workflow.engine.db.WorkflowInstanceDB;
import ambience.workflow.engine.db.WorkflowInstanceErrorDB;
import ambience.workflow.engine.db.WorkflowInstanceMongoDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.webserver.CodeLoader;
import com.elixirtech.webserver.DefaultCodeLoader;
import com.elixirtech.webserver.WebReply;
import elxgraph.Graph$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Error;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3$;
import scala.Tuple4$;
import scala.Tuple7$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;
import workflow.model.ETLChain;
import workflow.model.ETLChain$;
import workflow.model.ETLChainSet;
import workflow.model.ETLChainSet$;
import workflow.model.State$;
import workflow.model.StateMachine$;
import workflow.model.StateMachineId$;
import workflow.model.StateMachineName$;
import workflow.model.Transition$;
import workflow.model.Workflow;
import workflow.model.Workflow$;
import workflow.model.WorkflowChainsetId;
import workflow.model.WorkflowChainsetId$;
import workflow.model.WorkflowId$;
import workflow.model.WorkflowInstanceCollection$;
import workflow.model.WorkflowInstanceDB$;
import workflow.model.WorkflowName$;
import workflow.model.Zoom$;

public class WFModule
implements Module,
LoggingHelper2,
PrivilegeSupplier {
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(WFModule.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(WFModule.class.getDeclaredField("routes$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(WFModule.class.getDeclaredField("route$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(WFModule.class.getDeclaredField("codeLoader$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WFModule.class.getDeclaredField("codeLoaderOptions$lzy1"));
    private volatile Object log$lzy1;
    public final ProjectConfig ambience$workflow$designer$WFModule$$projectConfig;
    private final CustomOAuth2Client oAuth2Client;
    private final String id;
    private final String name;
    private final String url;
    private final Encoder encode;
    private final WorkflowDB workflowDB;
    private volatile Object codeLoaderOptions$lzy1;
    private volatile Object codeLoader$lzy1;
    private volatile Object route$lzy1;
    private volatile Object routes$lzy1;

    public WFModule(ProjectConfig projectConfig, CustomOAuth2Client oAuth2Client, WebReply webReply) {
        this.ambience$workflow$designer$WFModule$$projectConfig = projectConfig;
        this.oAuth2Client = oAuth2Client;
        this.id = "workflow";
        this.name = "Workflow";
        this.url = "";
        Elixir$.MODULE$.register(ClassTag$.MODULE$.apply(WorkflowDB.class), ClassTag$.MODULE$.apply(WorkflowMongoDB.class));
        Elixir$.MODULE$.register(ClassTag$.MODULE$.apply(WorkflowInstanceDB.class), ClassTag$.MODULE$.apply(WorkflowInstanceMongoDB.class));
        Elixir$.MODULE$.register(ClassTag$.MODULE$.apply(WorkflowExecutor.class), ClassTag$.MODULE$.apply(ChainExecutor.class));
        Elixir$.MODULE$.register(ClassTag$.MODULE$.apply(WorkflowInstanceErrorDB.class), ClassTag$.MODULE$.apply(DefaultWorkflowInstanceErrorDB.class));
        Elixir$.MODULE$.registerInstance((Object)new WorkflowAPI(), ClassTag$.MODULE$.apply(ambience.api.Workflow.class));
        Workflow$ mirror$proxy1 = Workflow$.MODULE$;
        String string = "_id";
        String string2 = "name";
        String string3 = "owner";
        String string4 = "database";
        String string5 = "collection";
        String string6 = "chainsetId";
        String string7 = "stateMachines";
        this.encode = ConfiguredEncoder$.MODULE$.inline$of(WFModule::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy1);
        this.workflowDB = (WorkflowDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(WorkflowDB.class));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public Encoder<Workflow> encode() {
        return this.encode;
    }

    public WorkflowDB workflowDB() {
        return this.workflowDB;
    }

    public Workflow toWorkflow(String json) {
        Workflow$ mirror$proxy4 = Workflow$.MODULE$;
        String string = "_id";
        String string2 = "name";
        String string3 = "owner";
        String string4 = "database";
        String string5 = "collection";
        String string6 = "chainsetId";
        String string7 = "stateMachines";
        int size = 7;
        Either either = package$.MODULE$.decode(json, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Workflow", WFModule::toWorkflow$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy4, Default$.MODULE$.inline$of(WFModule::toWorkflow$$anonfun$2)))));
        if (either instanceof Right) {
            Workflow fm = (Workflow)((Right)either).value();
            return fm;
        }
        if (either instanceof Left) {
            Error err = (Error)((Left)either).value();
            throw new RuntimeException("Invalid filter: " + err);
        }
        throw new MatchError((Object)either);
    }

    public CodeLoader.Options codeLoaderOptions() {
        Object object = this.codeLoaderOptions$lzy1;
        if (object instanceof CodeLoader.Options) {
            return (CodeLoader.Options)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodeLoader.Options)this.codeLoaderOptions$lzyINIT1();
    }

    private Object codeLoaderOptions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoaderOptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodeLoader.Options options = null;
                    try {
                        options = new CodeLoader.Options(this){
                            private final /* synthetic */ WFModule $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public String WebScript() {
                                return "js/elx-" + this.$outer.id() + "-client-fastopt.js";
                            }

                            public File WebRootDir() {
                                return this.$outer.ambience$workflow$designer$WFModule$$projectConfig.WebRootDir();
                            }
                        };
                        object2 = options == null ? LazyVals.NullValue$.MODULE$ : options;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoaderOptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return options;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DefaultCodeLoader codeLoader() {
        Object object = this.codeLoader$lzy1;
        if (object instanceof DefaultCodeLoader) {
            return (DefaultCodeLoader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DefaultCodeLoader)this.codeLoader$lzyINIT1();
    }

    private Object codeLoader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultCodeLoader defaultCodeLoader = null;
                    try {
                        defaultCodeLoader = new DefaultCodeLoader(this.codeLoaderOptions());
                        object2 = defaultCodeLoader == null ? LazyVals.NullValue$.MODULE$ : defaultCodeLoader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoader$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return defaultCodeLoader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<PrivilegeSupplier.Privilege> requiredPrivileges() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrivilegeSupplier.Privilege[]{PrivilegeSupplier.Privilege$.MODULE$.apply("mod-workflow-edit", "Allowed to edit workflows")}));
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        Object object = this.route$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.route$lzyINIT1();
    }

    private Object route$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.route$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = GravitySystem$.MODULE$.fromRoutes(this.routes(), GravitySystem$.MODULE$.fromRoutes$default$2());
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<GravityRoute> routes() {
        Object object = this.routes$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.routes$lzyINIT1();
    }

    private Object routes$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.routes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "wf", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.getWf((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "wf", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.postWf((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "wf/chains", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.getChains((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "engine", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> WorkflowEngine$.MODULE$.getEngine((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "event", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> WorkflowEngine$.MODULE$.postEvent((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "getWFId", this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> WorkflowEngine$.MODULE$.getWFId((UserDB.User)user))), this.codeLoader().route(), GravityRoute$.MODULE$.all(this.withModUser((Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.segHandler((UserDB.User)user)))}));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> segHandler(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)workflowId -> GravitySystem$.MODULE$.fromRoutes(this.segRoutes(user, workflowId.value()), GravitySystem$.MODULE$.fromRoutes$default$2()));
    }

    public List<GravityRoute> segRoutes(UserDB.User user, String workflowId) {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "index.html", this.buildIndexHtml(user, workflowId))}));
    }

    public Function1<GravityRequest, Task<GravityResponse>> buildIndexHtml(UserDB.User user, String workflowId) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"workflowId");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)workflowId);
        return RouteHelper$.MODULE$.buildIndexHtml((CodeLoader)this.codeLoader(), this.id(), (PartialFunction)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), user);
    }

    public Function1<GravityRequest, Task<GravityResponse>> withModUser(Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> fn) {
        return this.oAuth2Client.approveWithUser((Function1 & Serializable)user -> {
            if (this.isValidGroup((UserDB.User)user)) {
                return (Function1)fn.apply(user);
            }
            this.log().info(() -> WFModule.withModUser$$anonfun$1$$anonfun$1(user), Line$.MODULE$.apply(89), FullName$.MODULE$.apply("ambience.workflow.designer.WFModule.withModUser"));
            return Gravity$.MODULE$.ForbiddenHandler();
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> getChains(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.parameter("id").map((Function1 & Serializable)id -> this.getChainSet(user, WorkflowId$.MODULE$.apply(id))).getOrElse(WFModule::getChains$$anonfun$1$$anonfun$2);
    }

    public Function1<GravityRequest, Task<GravityResponse>> getWf(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.parameter("id").map((Function1 & Serializable)id -> this.getWorkflow(user, (String)id)).getOrElse(WFModule::getWf$$anonfun$1$$anonfun$2);
    }

    public Function1<GravityRequest, Task<GravityResponse>> postWf(UserDB.User user) {
        if (user.privileges().contains((Object)"mod-workflow-edit")) {
            return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)wf -> (Function1 & Serializable)_$1 -> this.workflowDB().save(user, (Json)wf).as((Object)GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.apply(201), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3())));
        }
        this.log().info(() -> WFModule.postWf$$anonfun$2(user), Line$.MODULE$.apply(114), FullName$.MODULE$.apply("ambience.workflow.designer.WFModule.postWf"));
        return Gravity$.MODULE$.ForbiddenHandler();
    }

    public Task<GravityResponse> getWorkflow(UserDB.User user, String id) {
        return this.workflowDB().loadForDesigner(user, WorkflowId$.MODULE$.apply(id)).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Workflow json = (Workflow)((Right)either).value();
                Workflow workflow = (Workflow)io.circe.syntax.package$.MODULE$.EncoderOps((Object)json);
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)workflow, this.encode()));
            }
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<GravityResponse> getChainSet(UserDB.User user, String workflowId) {
        EitherT res = EitherT$.MODULE$.apply(this.workflowDB().load(user, workflowId)).flatMap((Function1 & Serializable)wf -> EitherT$.MODULE$.apply((Object)((ChainSetLookup)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ChainSetLookup.class))).getChainSet(user, (ChainSetIdentifier)ChainSetId$.MODULE$.apply(wf.chainsetId())).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ambience.etl.ETLChainSet chainSet = (ambience.etl.ETLChainSet)((Some)option).value();
                if (chainSet.enabled()) {
                    return scala.package$.MODULE$.Right().apply((Object)ETLChainSet$.MODULE$.apply(wf.chainsetId(), chainSet.name(), ((IterableOnceOps)chainSet.chains().values().map((Function1 & Serializable)chain -> this.toChain((ambience.etl.ETLChain)chain))).toList()));
                }
                return scala.package$.MODULE$.Left().apply((Object)(chainSet.name() + " disabled"));
            }
            if (None$.MODULE$.equals(option)) {
                return scala.package$.MODULE$.Left().apply((Object)("ChainSet not found " + new WorkflowChainsetId(wf.chainsetId())));
            }
            throw new MatchError((Object)option);
        })).map((Function1 & Serializable)list -> list, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)res.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                ETLChainSet list = (ETLChainSet)((Right)either).value();
                ETLChainSet eTLChainSet = (ETLChainSet)io.circe.syntax.package$.MODULE$.EncoderOps((Object)list);
                ETLChainSet$ mirror$proxy7 = ETLChainSet$.MODULE$;
                String string = "id";
                String string2 = "name";
                String string3 = "chains";
                return GravityResponse$.MODULE$.json(package.EncoderOps$.MODULE$.asJson$extension((Object)eTLChainSet, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(WFModule::getChainSet$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy7)))));
            }
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            throw new MatchError((Object)either);
        });
    }

    private ETLChain toChain(ambience.etl.ETLChain chain) {
        ETLChain.GuardChain$ guardChain$;
        Option option = chain.steps().find((Function1 & Serializable)_$2 -> {
            String string = _$2.stepType();
            String string2 = ETLStepType$.MODULE$.apply("workflow.GuardEndPoint");
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            guardChain$ = ETLChain.GuardChain$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            guardChain$ = ETLChain.Chain$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        ETLChain.ChainType ctype = (ETLChain.ChainType)guardChain$;
        return ETLChain$.MODULE$.apply(chain.name(), ctype);
    }

    private boolean isValidGroup(UserDB.User user) {
        return user.privileges().contains((Object)"mod-workflow") || user.privileges().contains((Object)"mod-workflow-edit");
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        Encoder.AsArray encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeInt();
        void var0_1 = var1;
        Encoder.AsArray encodeA3 = Encoder$.MODULE$.encodeVector(State$.MODULE$.encode());
        void var2_3 = var3_2;
        Encoder.AsArray asArray = encodeA = Encoder$.MODULE$.encodeVector(Transition$.MODULE$.encode());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asArray).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final List $anonfun$1() {
        Encoder encodeA;
        Decoder encodeA2 = StateMachineId$.MODULE$.codec();
        Encoder encoder = (Encoder)encodeA2;
        Decoder encodeA3 = StateMachineName$.MODULE$.codec();
        Encoder encoder2 = (Encoder)encodeA3;
        Decoder encodeA4 = Zoom$.MODULE$.codec();
        Encoder encoder3 = (Encoder)encodeA4;
        Graph$ mirror$proxy3 = Graph$.MODULE$;
        String string = "serialId";
        String string2 = "nodes";
        String string3 = "edges";
        Encoder encoder4 = encodeA = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(WFModule::$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy3)));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final List $init$$$anonfun$1() {
        Encoder.AsArray encodeA;
        Encoder encodeA2;
        Decoder encodeA3 = WorkflowId$.MODULE$.codec();
        Encoder encoder = (Encoder)encodeA3;
        Decoder encodeA4 = WorkflowName$.MODULE$.codec();
        Encoder encoder2 = (Encoder)encodeA4;
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Decoder encodeA5 = WorkflowInstanceDB$.MODULE$.codec();
        Encoder encoder4 = (Encoder)encodeA5;
        Decoder encodeA6 = WorkflowInstanceCollection$.MODULE$.codec();
        Encoder encoder5 = (Encoder)encodeA6;
        Decoder encodeA7 = WorkflowChainsetId$.MODULE$.codec();
        Encoder encoder6 = (Encoder)encodeA7;
        StateMachine$ mirror$proxy2 = StateMachine$.MODULE$;
        String string = "id";
        String string2 = "name";
        String string3 = "initZoom";
        String string4 = "graph";
        Encoder.AsArray asArray = encodeA = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(WFModule::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy2))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asArray).$colon$colon((Object)encoder6).$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$4() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeInt();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeVector(State$.MODULE$.decode());
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeVector(Transition$.MODULE$.decode());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product $anonfun$5() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Graph$.MODULE$.$lessinit$greater$default$1())), (Object)Some$.MODULE$.apply((Object)Graph$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)Graph$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$3() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = StateMachineId$.MODULE$.codec();
        void var0_1 = var1;
        Decoder decodeA4 = StateMachineName$.MODULE$.codec();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Zoom$.MODULE$.codec();
        Graph$ mirror$proxy6 = Graph$.MODULE$;
        String string = "serialId";
        String string2 = "nodes";
        String string3 = "edges";
        int size = 3;
        Decoder decoder2 = decodeA = Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Graph", WFModule::$anonfun$4, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy6, Default$.MODULE$.inline$of(WFModule::$anonfun$5))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product $anonfun$6() {
        return Tuple4$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List toWorkflow$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        void var3_2;
        void var1;
        Decoder decodeA6 = WorkflowId$.MODULE$.codec();
        void var0_1 = var1;
        Decoder decodeA7 = WorkflowName$.MODULE$.codec();
        void var2_3 = var3_2;
        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA4 = WorkflowInstanceDB$.MODULE$.codec();
        Decoder decoder3 = decodeA3 = WorkflowInstanceCollection$.MODULE$.codec();
        Decoder decoder4 = decodeA2 = WorkflowChainsetId$.MODULE$.codec();
        StateMachine$ mirror$proxy5 = StateMachine$.MODULE$;
        String string = "id";
        String string2 = "name";
        String string3 = "initZoom";
        String string4 = "graph";
        int size = 4;
        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("StateMachine", WFModule::$anonfun$3, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy5, Default$.MODULE$.inline$of(WFModule::$anonfun$6)))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product toWorkflow$$anonfun$2() {
        return Tuple7$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object withModUser$$anonfun$1$$anonfun$1(UserDB.User user$2) {
        return "User " + user$2.name() + " does not have workflow privileges";
    }

    private static final Task getChains$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing parameter 'id'");
    }

    private static final Task getWf$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing parameter 'id'");
    }

    private static final Object postWf$$anonfun$2(UserDB.User user$9) {
        return "User " + user$9.name() + " does not have permission to edit Workflow module";
    }

    private static final List $anonfun$10() {
        return scala.package$.MODULE$.Nil();
    }

    private static final List $anonfun$11() {
        return scala.package$.MODULE$.Nil();
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$9() {
        Encoder encodeA;
        void var1_1;
        ETLChain.Chain$ mirror$proxy10 = ETLChain.Chain$.MODULE$;
        Encoder encodeA2 = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(WFModule::$anonfun$10, (List)scala.package$.MODULE$.Nil(), Configuration$.MODULE$.default(), (Mirror)mirror$proxy10)));
        void var0_2 = var1_1;
        ETLChain.GuardChain$ mirror$proxy11 = ETLChain.GuardChain$.MODULE$;
        Encoder encoder = encodeA = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(WFModule::$anonfun$11, (List)scala.package$.MODULE$.Nil(), Configuration$.MODULE$.default(), (Mirror)mirror$proxy11)));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var0_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$8() {
        void var3_5;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Mirror.Sum mirror$proxy9 = (Mirror.Sum)new Serializable(){

            public int ordinal(ETLChain.ChainType x$0) {
                ETLChain.ChainType chainType = x$0;
                if (chainType == ETLChain.Chain$.MODULE$) {
                    return 0;
                }
                if (chainType == ETLChain.GuardChain$.MODULE$) {
                    return 1;
                }
                throw new MatchError((Object)chainType);
            }
        };
        String string = "Chain";
        String string2 = "GuardChain";
        Encoder encodeA2 = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(WFModule::$anonfun$9, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy9)));
        void var2_6 = var3_5;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_6).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getChainSet$$anonfun$1$$anonfun$1() {
        Encoder.AsArray encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        ETLChain$ mirror$proxy8 = ETLChain$.MODULE$;
        String string = "name";
        String string2 = "chainType";
        Encoder.AsArray asArray = encodeA = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(WFModule::$anonfun$8, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy8))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asArray).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }
}

