/*
 * Decompiled with CFR 0.152.
 */
package ambience.workflow.engine;

import ambience.api.Workflow;
import ambience.module.UserDB;
import ambience.workflow.engine.JsonDelta$;
import ambience.workflow.engine.JsonLenses$;
import ambience.workflow.engine.WorkflowExecutor;
import ambience.workflow.engine.WorkflowInstance$;
import ambience.workflow.engine.WorkflowInstance$ErrorMessage$;
import ambience.workflow.engine.WorkflowInstance$ResultFailure$;
import ambience.workflow.engine.WorkflowInstance$ResultSuccess$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import elxgraph.NodeId;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;
import workflow.model.Action;
import workflow.model.Condition;
import workflow.model.EventName;
import workflow.model.EventName$;
import workflow.model.History$;
import workflow.model.State;
import workflow.model.Transition;
import workflow.model.Workflow;
import workflow.model.WorkflowInstanceId;
import workflow.model.engine.DeferredEvent;

public class WorkflowInstance
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstance.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String id;
    private final String stateMachineId;
    private final int nodeId;
    private final String shortId;
    private final WorkflowExecutor executor;
    private final Vector states;
    private final Vector transitions;
    private final List superStates;
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstance$.class.getDeclaredField("auditComponent$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstance$.class.getDeclaredField("auditAPI$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstance$.class.getDeclaredField("AuditEnabled$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstance$.class.getDeclaredField("AuditPrivateEnabled$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInstance$.class.getDeclaredField("AuditPublicEnabled$lzy1"));

    public static boolean AuditEnabled() {
        return WorkflowInstance$.MODULE$.AuditEnabled();
    }

    public static boolean AuditPrivateEnabled() {
        return WorkflowInstance$.MODULE$.AuditPrivateEnabled();
    }

    public static boolean AuditPublicEnabled() {
        return WorkflowInstance$.MODULE$.AuditPublicEnabled();
    }

    public static AuditAPI.AuditAppender auditAPI() {
        return WorkflowInstance$.MODULE$.auditAPI();
    }

    public static AuditAPI.Component auditComponent() {
        return WorkflowInstance$.MODULE$.auditComponent();
    }

    public WorkflowInstance(String id, Workflow workflow, String stateMachineId, int nodeId) {
        this.id = id;
        this.stateMachineId = stateMachineId;
        this.nodeId = nodeId;
        this.shortId = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(id), 8);
        this.executor = (WorkflowExecutor)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(WorkflowExecutor.class));
        this.states = (Vector)workflow.stateMachines().find((Function1 & Serializable)_$1 -> {
            String string = _$1.id();
            String string2 = stateMachineId;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$2 -> _$2.graph().nodes()).getOrElse(WorkflowInstance::$init$$$anonfun$3);
        this.transitions = (Vector)workflow.stateMachines().find((Function1 & Serializable)_$3 -> {
            String string = _$3.id();
            String string2 = stateMachineId;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$4 -> _$4.graph().edges()).getOrElse(WorkflowInstance::$init$$$anonfun$6);
        this.superStates = (List)this.getCurrentState().toOption().map((Function1 & Serializable)state -> this.findSuperStates((State)state)).getOrElse(WorkflowInstance::$init$$$anonfun$8);
        this.log().info(this::$init$$$anonfun$9, Line$.MODULE$.apply(51), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance"));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    public String shortId() {
        return this.shortId;
    }

    public WorkflowExecutor executor() {
        return this.executor;
    }

    public Vector<State> states() {
        return this.states;
    }

    public Vector<Transition> transitions() {
        return this.transitions;
    }

    public List<State> superStates() {
        return this.superStates;
    }

    public Task<Result> event(WorkflowExecutor.Context cxt, String evt) {
        this.log().info(() -> this.event$$anonfun$1(evt, cxt), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.event"));
        this.log().debug(() -> this.event$$anonfun$2(evt, cxt), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.event"));
        EitherT transitionTask = EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(this::$anonfun$1)).flatMap((Function1 & Serializable)cs -> EitherT$.MODULE$.apply(this.getTransition(cxt, (State)cs, evt)).map((Function1 & Serializable)t -> Tuple2$.MODULE$.apply(cs, t), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)transitionTask.value()).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2;
            Either either = x$12;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.event"));
                return Task$.MODULE$.apply(() -> WorkflowInstance.event$$anonfun$3$$anonfun$1(cxt));
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                State cs = (State)tuple2._1();
                Transition t = (Transition)tuple2._2();
                EitherT stateTask = EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.$anonfun$3(cxt, cs, t, evt))).flatMap((Function1 & Serializable)toState -> EitherT$.MODULE$.apply(this.onExit(cxt, cs)).flatMap((Function1 & Serializable)cxt1 -> EitherT$.MODULE$.apply(this.onTransition((WorkflowExecutor.Context)cxt1, t, cs)).flatMap((Function1 & Serializable)cxt2 -> {
                    boolean bl = EitherT$.MODULE$.right();
                    return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.apply(() -> this.$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(toState, cxt2)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)cxtWithUpdatedNodeId -> EitherT$.MODULE$.apply(this.onEntry((WorkflowExecutor.Context)cxtWithUpdatedNodeId, (State)toState)).map((Function1 & Serializable)cxt4 -> Tuple2$.MODULE$.apply((Object)cxt4.wfiState(), this.onAfter((State)toState)), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                return ((Task)stateTask.value()).map((Function1 & Serializable)x$1 -> {
                    Result result;
                    Tuple2 tuple2;
                    Either either = x$1;
                    if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                        Json state = (Json)tuple2._1();
                        Option onAfter = (Option)tuple2._2();
                        result = WorkflowInstance$ResultSuccess$.MODULE$.apply(state, (List<DeferredEvent>)onAfter.toList());
                    } else if (either instanceof Left) {
                        String msg = (String)((Left)either).value();
                        result = WorkflowInstance$ResultFailure$.MODULE$.apply(cxt.wfiState(), msg);
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return result;
                });
            }
            throw new MatchError((Object)either);
        });
    }

    public Json copyElxFields(WorkflowExecutor.Context cxt, String mode, Json in, Json out) {
        if (WorkflowInstance$.MODULE$.AuditEnabled()) {
            this.logChanges(cxt, mode, in, out);
        }
        Json j1 = (Json)JsonLenses$.MODULE$.PublicLens().getOption((Object)out).map((Function1 & Serializable)p -> (Json)JsonLenses$.MODULE$.PublicLens().replace(p).apply((Object)in)).getOrElse(() -> this.$anonfun$6(in));
        Json j2 = (Json)JsonLenses$.MODULE$.PrivateLens().getOption((Object)out).map((Function1 & Serializable)p -> (Json)JsonLenses$.MODULE$.PrivateLens().replace(p).apply((Object)j1)).getOrElse(() -> this.$anonfun$8(j1));
        Json j3 = (Json)JsonLenses$.MODULE$.RedirectLens().getOption((Object)out).map((Function1 & Serializable)p -> (Json)JsonLenses$.MODULE$.RedirectLens().replace(p).apply((Object)j2)).getOrElse(() -> WorkflowInstance.$anonfun$10(j2));
        return j3;
    }

    public void logChanges(WorkflowExecutor.Context cxt, String mode, Json in, Json out) {
        Json diff = JsonDelta$.MODULE$.diff(this.extract(in), this.extract(out));
        String location = cxt.workflow().collection() + ": " + cxt.id();
        WorkflowInstance$.MODULE$.auditAPI().append(AuditAPI.AuditMessage$.MODULE$.apply(cxt.user().name(), WorkflowInstance$.MODULE$.auditComponent(), AuditAPI.Success$.MODULE$.apply(location, "ETL " + mode, (Option)Some$.MODULE$.apply((Object)diff.noSpaces()), AuditAPI.Success$.MODULE$.apply$default$4())));
    }

    public Json extract(Json json) {
        Json empty = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        Json elxPublic = WorkflowInstance$.MODULE$.AuditPublicEnabled() ? (Json)JsonLenses$.MODULE$.PublicLens().getOption((Object)json).getOrElse(() -> WorkflowInstance.$anonfun$11(empty)) : empty;
        Json elxPrivate = WorkflowInstance$.MODULE$.AuditPrivateEnabled() ? (Json)JsonLenses$.MODULE$.PrivateLens().getOption((Object)json).getOrElse(() -> WorkflowInstance.$anonfun$12(empty)) : empty;
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"elxPublic");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)elxPublic);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elxPrivate");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)elxPrivate);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Task<Either<LogMessage, Transition>> getTransition(WorkflowExecutor.Context cxt, State currentState, String evt) {
        Tuple2 tuple2 = this.buildTransitionList(currentState, evt).partition((Function1 & Serializable)_$6 -> _$6.guard().isDefined());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List withGuard = (List)tuple2._1();
        List noGuard = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)withGuard, (Object)noGuard);
        List withGuard2 = (List)tuple22._1();
        List noGuard2 = (List)tuple22._2();
        List guardTasks = withGuard2.map((Function1 & Serializable)t -> this.runGuard(cxt, currentState, (Transition)t));
        return Task$.MODULE$.tailRecM((Object)guardTasks, (Function1 & Serializable)nums -> this.findGuard((List<Task<Either<LogMessage, Option<Transition>>>>)nums)).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)msg);
            }
            if (either instanceof Right) {
                Option option = (Option)((Right)either).value();
                if (option instanceof Some) {
                    Transition t = (Transition)((Some)option).value();
                    this.log().info(() -> this.getTransition$$anonfun$2$$anonfun$1(t, evt), Line$.MODULE$.apply(115), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.getTransition"));
                    return package$.MODULE$.Right().apply((Object)t);
                }
                if (None$.MODULE$.equals(option)) {
                    Option option2 = noGuard2.headOption();
                    if (option2 instanceof Some) {
                        Transition t = (Transition)((Some)option2).value();
                        this.log().info(() -> this.getTransition$$anonfun$2$$anonfun$2(t, evt), Line$.MODULE$.apply(120), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.getTransition"));
                        return package$.MODULE$.Right().apply((Object)t);
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return package$.MODULE$.Left().apply((Object)LogMessage.Warn$.MODULE$.apply("No Transition found for event " + evt + " from current state " + currentState.label()));
                    }
                    throw new MatchError((Object)option2);
                }
            }
            throw new MatchError((Object)either);
        });
    }

    public List<Transition> buildTransitionList(State currentState, String evt) {
        List states = this.findSuperStates(currentState).$colon$colon((Object)currentState);
        return states.flatMap((Function1 & Serializable)s -> this.transitions().toList().filter((Function1 & Serializable)t -> t.from() == s.id() && this.eventMatch(evt, (Transition)t)));
    }

    public boolean eventMatch(String evt, Transition t) {
        String string = evt;
        String string2 = EventName$.MODULE$.wildCard();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return true;
        }
        Object object = t.event().getOrElse((Function0 & Serializable)() -> new EventName(WorkflowInstance.eventMatch$$anonfun$1(t)));
        EventName eventName = new EventName(evt);
        return !(object != null ? !object.equals(eventName) : eventName != null);
    }

    public Task<Either<List<Task<Either<LogMessage, Option<Transition>>>>, Either<LogMessage, Option<Transition>>>> findGuard(List<Task<Either<LogMessage, Option<Transition>>>> nums) {
        List<Task<Either<LogMessage, Option<Transition>>>> list = nums;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Task<Either<LogMessage, Option<Transition>>>> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$)));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Task h = (Task)colon2.head();
            List tail = list3;
            return h.map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    LogMessage msg = (LogMessage)((Left)either).value();
                    return package$.MODULE$.Right().apply((Object)package$.MODULE$.Left().apply((Object)msg));
                }
                if (either instanceof Right) {
                    Option n = (Option)((Right)either).value();
                    if (n.isDefined()) {
                        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Right().apply((Object)n));
                    }
                    return package$.MODULE$.Left().apply((Object)tail);
                }
                throw new MatchError((Object)either);
            });
        }
        throw new MatchError(list);
    }

    public Task<Either<String, WorkflowExecutor.Context>> onExit(WorkflowExecutor.Context cxt, State state) {
        this.log().info(() -> this.onExit$$anonfun$1(state), Line$.MODULE$.apply(153), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.onExit"));
        Option option = this.superStates().$colon$colon((Object)state).find((Function1 & Serializable)_$8 -> _$8.onExit().isDefined());
        if (option instanceof Some) {
            State ss = (State)((Some)option).value();
            this.log().info(() -> this.onExit$$anonfun$3(ss), Line$.MODULE$.apply(156), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.onExit"));
            return (Task)ss.onExit().map((Function1 & Serializable)_$9 -> this.executor().runOnExit((Action)_$9, cxt).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)("StateAction onExit Failed\n" + msg + "\nCurrent State:" + ss.label() + "\n"));
                }
                if (either instanceof Right) {
                    Json json = (Json)((Right)either).value();
                    Json json2 = this.copyElxFields(cxt, "onExit", cxt.wfiState(), json);
                    String string = cxt.copy$default$1();
                    String string2 = cxt.copy$default$2();
                    Workflow workflow = cxt.copy$default$3();
                    UserDB.User user = cxt.copy$default$4();
                    return package$.MODULE$.Right().apply((Object)cxt.copy(string, string2, workflow, user, json2));
                }
                throw new MatchError((Object)either);
            })).getOrElse(() -> this.onExit$$anonfun$5(cxt));
        }
        if (None$.MODULE$.equals(option)) {
            return this.rightCxt(cxt);
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<String, WorkflowExecutor.Context>> onTransition(WorkflowExecutor.Context cxt, Transition transition, State state) {
        this.log().info(() -> this.onTransition$$anonfun$1(state, transition), Line$.MODULE$.apply(170), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.onTransition"));
        return (Task)transition.onTransition().map((Function1 & Serializable)_$10 -> this.executor().runOnTransition((Action)_$10, cxt).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)("StateAction onTransition Failed\n" + msg + "\nTransition" + transition.label() + "\nCurrent State:" + state.label() + "\n"));
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                Json json2 = this.copyElxFields(cxt, "onTransition", cxt.wfiState(), json);
                String string = cxt.copy$default$1();
                String string2 = cxt.copy$default$2();
                Workflow workflow = cxt.copy$default$3();
                UserDB.User user = cxt.copy$default$4();
                return package$.MODULE$.Right().apply((Object)cxt.copy(string, string2, workflow, user, json2));
            }
            throw new MatchError((Object)either);
        })).getOrElse(() -> this.onTransition$$anonfun$3(cxt));
    }

    public Task<Either<String, WorkflowExecutor.Context>> onEntry(WorkflowExecutor.Context cxt, State state) {
        Option option = this.superStates().$colon$colon((Object)state).find((Function1 & Serializable)_$11 -> _$11.onEntry().isDefined());
        if (option instanceof Some) {
            State ss = (State)((Some)option).value();
            this.log().info(() -> this.onEntry$$anonfun$2(ss), Line$.MODULE$.apply(184), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.onEntry"));
            return (Task)ss.onEntry().map((Function1 & Serializable)_$12 -> this.executor().runOnEntry((Action)_$12, cxt).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)("StateAction onEntry Failed\n" + msg + "\nCurrent State:" + ss.label() + "\n"));
                }
                if (either instanceof Right) {
                    Json json = (Json)((Right)either).value();
                    Json json2 = this.copyElxFields(cxt, "onEntry", cxt.wfiState(), json);
                    String string = cxt.copy$default$1();
                    String string2 = cxt.copy$default$2();
                    Workflow workflow = cxt.copy$default$3();
                    UserDB.User user = cxt.copy$default$4();
                    return package$.MODULE$.Right().apply((Object)cxt.copy(string, string2, workflow, user, json2));
                }
                throw new MatchError((Object)either);
            })).getOrElse(() -> this.onEntry$$anonfun$4(cxt));
        }
        if (None$.MODULE$.equals(option)) {
            return this.rightCxt(cxt);
        }
        throw new MatchError((Object)option);
    }

    public Option<DeferredEvent> onAfter(State toState) {
        Option option = this.findSuperStates(toState).$colon$colon((Object)toState).find((Function1 & Serializable)_$13 -> _$13.onAfter().isDefined());
        if (option instanceof Some) {
            State s = (State)((Some)option).value();
            this.log().info(() -> this.onAfter$$anonfun$2(s), Line$.MODULE$.apply(200), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.onAfter"));
            return s.onAfter();
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public List<State> findSuperStates(State state) {
        return this.find$1(state, (List)package$.MODULE$.Nil());
    }

    public List<State> findSubStates(State state) {
        Set allSuperNodeIds = ((IterableOnceOps)this.states().flatMap((Function1 & Serializable)_$15 -> _$15.superState())).toSet();
        Set allSuperStates = (Set)allSuperNodeIds.flatMap((Function1 & Serializable)nodeId -> this.$anonfun$16(nodeId == null ? BoxesRunTime.unboxToInt(null) : ((NodeId)nodeId).value()));
        return ((IterableOnceOps)((StrictOptimizedIterableOps)this.states().filterNot((Function1 & Serializable)elem -> allSuperStates.contains(elem))).filter((Function1 & Serializable)_$17 -> this.findSuperStates((State)_$17).contains((Object)state))).toList();
    }

    public Either<LogMessage, State> getCurrentState() {
        return this.states().find((Function1 & Serializable)_$18 -> _$18.id() == this.nodeId).toRight(this::getCurrentState$$anonfun$2);
    }

    public Either<String, State> getToState(WorkflowExecutor.Context cxt, State currentState, Transition transition, String evt) {
        return this.states().find((Function1 & Serializable)_$19 -> _$19.id() == transition.to()).flatMap((Function1 & Serializable)target -> {
            if (target.stateType().contains((Object)History$.MODULE$)) {
                Set nodeIds;
                List history = this.extractHistory(cxt.wfiState()).reverse();
                Option option = history.flatMap(arg_0 -> this.getToState$$anonfun$2$$anonfun$1(cxt, nodeIds = this.findSubStates((State)target).map((Function1 & Serializable)_$20 -> _$20.id()).toSet(), arg_0)).headOption();
                if (option instanceof Some) {
                    int nodeId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                    Option ret = this.states().find((Function1 & Serializable)_$21 -> _$21.id() == nodeId);
                    this.log().info(() -> WorkflowInstance.getToState$$anonfun$2$$anonfun$2(ret), Line$.MODULE$.apply(241), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.getToState"));
                    return ret;
                }
                if (None$.MODULE$.equals(option)) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option);
            }
            return Some$.MODULE$.apply(target);
        }).toRight(() -> WorkflowInstance.getToState$$anonfun$3(transition, evt, currentState));
    }

    public Option<Object> endsWithOneOf(String stateMachineId, Set<Object> nodeIds, Workflow.History h) {
        Option option = h.endState().find((Function1 & Serializable)_$22 -> {
            String string = _$22.stateMachineId();
            String string2 = stateMachineId;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            Workflow.StateHolder.ConcurrentState endState = (Workflow.StateHolder.ConcurrentState)((Some)option).value();
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)endState.nodeId())).filter((Function1)(JFunction1.mcZI.sp & Serializable)elem -> nodeIds.contains((Object)BoxesRunTime.boxToInteger((int)elem)));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<String, Json>> runStateAction(State state, String name, Function1<WorkflowExecutor.Context, Task<Either<String, Json>>> fn, WorkflowExecutor.Context cxt) {
        return ((Task)fn.apply((Object)cxt)).map((Function1 & Serializable)_$23 -> _$23.left().map((Function1 & Serializable)msg -> "StateAction " + name + "() Failed\n" + msg + "\nCurrent State:" + state.label() + "\n"));
    }

    public Task<Either<String, Json>> runTransitionAction(State state, Transition transition, String name, Function1<Json, Task<Either<String, Json>>> fn, Json json) {
        return ((Task)fn.apply((Object)json)).map((Function1 & Serializable)_$24 -> _$24.left().map((Function1 & Serializable)msg -> "TransitionAction " + name + "() Failed\n" + msg + "\nCurrent State:" + state.label() + "\nTransition:" + transition.label()));
    }

    public Task<Either<LogMessage, Option<Transition>>> runGuard(WorkflowExecutor.Context cxt, State state, Transition transition) {
        Option option = transition.guard();
        if (option instanceof Some) {
            Condition guard = (Condition)((Some)option).value();
            return this.executor().isTrue(guard, cxt).map((Function1 & Serializable)_$25 -> _$25.left().map((Function1 & Serializable)msg -> LogMessage.Info$.MODULE$.apply("guard() Failed\n" + msg + "\nCurrent State:" + state.label() + "\nTransition:" + transition.label())).map((Function1 & Serializable)isTrue -> WorkflowInstance.runGuard$$anonfun$1$$anonfun$2(transition, BoxesRunTime.unboxToBoolean((Object)isTrue))));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply(() -> WorkflowInstance.runGuard$$anonfun$2(transition));
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<String, WorkflowExecutor.Context>> rightCxt(WorkflowExecutor.Context cxt) {
        return Task$.MODULE$.apply(() -> WorkflowInstance.rightCxt$$anonfun$1(cxt));
    }

    public WorkflowExecutor.Context updateNodeId(State s, WorkflowExecutor.Context cxt) {
        Json json = (Json)JsonLenses$.MODULE$.StatesLens().arr().modify((Function1 & Serializable)states -> (Vector)states.map((Function1 & Serializable)node -> {
            if (JsonLenses$.MODULE$.isSmId(cxt.stateMachineId(), (Json)node)) {
                return node.mapObject((Function1 & Serializable)jsonObject -> jsonObject.add("nodeId", Json$.MODULE$.fromInt(s.id())));
            }
            return node;
        })).apply((Object)cxt.wfiState());
        return cxt.copy(cxt.copy$default$1(), cxt.copy$default$2(), cxt.copy$default$3(), cxt.copy$default$4(), json);
    }

    public List<Workflow.History> extractHistory(Json json) {
        return (List)Workflow.StateHolder$.MODULE$.apply(json).elxHistory().getOrElse(WorkflowInstance::extractHistory$$anonfun$1);
    }

    private static final Vector $init$$$anonfun$3() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static final Vector $init$$$anonfun$6() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static final List $init$$$anonfun$8() {
        return package$.MODULE$.Nil();
    }

    private final Object $init$$$anonfun$9() {
        return "super states hierachy: " + this.superStates().map((Function1 & Serializable)_$5 -> _$5.label()).mkString("->");
    }

    private final Object event$$anonfun$1(String evt$1, WorkflowExecutor.Context cxt$1) {
        return this.shortId() + " Instance Event (" + new EventName(evt$1) + ") received for id: " + new WorkflowInstanceId(cxt$1.id());
    }

    private final Object event$$anonfun$2(String evt$2, WorkflowExecutor.Context cxt$2) {
        return this.shortId() + " Instance Event (" + new EventName(evt$2) + ") received for state: " + cxt$2.wfiState().noSpaces();
    }

    private final Either $anonfun$1() {
        return this.getCurrentState();
    }

    private static final ResultSuccess event$$anonfun$3$$anonfun$1(WorkflowExecutor.Context cxt$5) {
        return WorkflowInstance$ResultSuccess$.MODULE$.apply(cxt$5.wfiState(), (List<DeferredEvent>)package$.MODULE$.Nil());
    }

    private final Either $anonfun$3(WorkflowExecutor.Context cxt$6, State cs$2, Transition t$1, String evt$5) {
        return this.getToState(cxt$6, cs$2, t$1, evt$5);
    }

    private final WorkflowExecutor.Context $anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(State toState$3, WorkflowExecutor.Context cxt2$1) {
        return this.updateNodeId(toState$3, cxt2$1);
    }

    private final Object $anonfun$6$$anonfun$1() {
        return this.shortId() + " elxPublic not found";
    }

    private final Json $anonfun$6(Json in$2) {
        this.log().info(this::$anonfun$6$$anonfun$1, Line$.MODULE$.apply(84), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.j1"));
        return in$2;
    }

    private final Object $anonfun$8$$anonfun$1() {
        return this.shortId() + " elxPrivate not found";
    }

    private final Json $anonfun$8(Json j1$2) {
        this.log().info(this::$anonfun$8$$anonfun$1, Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.workflow.engine.WorkflowInstance.j2"));
        return j1$2;
    }

    private static final Json $anonfun$10(Json j2$2) {
        return j2$2;
    }

    private static final Json $anonfun$11(Json empty$1) {
        return empty$1;
    }

    private static final Json $anonfun$12(Json empty$2) {
        return empty$2;
    }

    private final Object getTransition$$anonfun$2$$anonfun$1(Transition t$4, String evt$6) {
        return this.shortId() + " Transition with Guard found from state:" + new NodeId(t$4.from()) + " to state:" + new NodeId(t$4.to()) + " for event " + new EventName(evt$6);
    }

    private final Object getTransition$$anonfun$2$$anonfun$2(Transition t$5, String evt$8) {
        return this.shortId() + " Transition with No Guard found from state :" + new NodeId(t$5.from()) + " to state:" + new NodeId(t$5.to()) + " for event " + new EventName(evt$8);
    }

    private static final /* synthetic */ boolean eventMatch$$anonfun$1$$anonfun$1(char _$7) {
        return _$7 != '(';
    }

    private static final String eventMatch$$anonfun$1(Transition t$6) {
        return EventName$.MODULE$.apply(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(t$6.label()), (Function1 & Serializable)_$7 -> WorkflowInstance.eventMatch$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$7))));
    }

    private final Object onExit$$anonfun$1(State state$1) {
        return this.shortId() + " onExit called for state " + state$1.label();
    }

    private final Object onExit$$anonfun$3(State ss$1) {
        return this.shortId() + " onExit executing from state " + ss$1.label();
    }

    private final Task onExit$$anonfun$5(WorkflowExecutor.Context cxt$12) {
        return this.rightCxt(cxt$12);
    }

    private final Object onTransition$$anonfun$1(State state$2, Transition transition$1) {
        return this.shortId() + " onTransition called for state " + state$2.label() + ", " + transition$1.label();
    }

    private final Task onTransition$$anonfun$3(WorkflowExecutor.Context cxt$15) {
        return this.rightCxt(cxt$15);
    }

    private final Object onEntry$$anonfun$2(State ss$4) {
        return this.shortId() + " onEntry executing from state " + ss$4.label();
    }

    private final Task onEntry$$anonfun$4(WorkflowExecutor.Context cxt$18) {
        return this.rightCxt(cxt$18);
    }

    private final Object onAfter$$anonfun$2(State s$2) {
        return this.shortId() + " onAfter executing from state " + s$2.label();
    }

    private final List find$1(State s, List superStates) {
        Option option;
        while ((option = s.superState()) instanceof Some) {
            Object object = ((Some)option).value();
            int ssId = object == null ? BoxesRunTime.unboxToInt(null) : ((NodeId)object).value();
            Option option2 = this.states().find((Function1 & Serializable)_$14 -> _$14.id() == ssId);
            if (option2 instanceof Some) {
                State s2;
                State state = s2 = (State)((Some)option2).value();
                List list = (List)superStates.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new State[]{s2})));
                s = state;
                superStates = list;
                continue;
            }
            if (None$.MODULE$.equals(option2)) {
                return package$.MODULE$.Nil();
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            return superStates;
        }
        throw new MatchError((Object)option);
    }

    private final /* synthetic */ IterableOnce $anonfun$16(int nodeId) {
        return this.states().find((Function1 & Serializable)_$16 -> _$16.id() == nodeId);
    }

    private final LogMessage.Warn getCurrentState$$anonfun$2() {
        return LogMessage.Warn$.MODULE$.apply("Current State not found with nodeId:" + new NodeId(this.nodeId) + " for WorkflowInstance:" + new WorkflowInstanceId(this.id()));
    }

    private final /* synthetic */ IterableOnce getToState$$anonfun$2$$anonfun$1(WorkflowExecutor.Context cxt$20, Set nodeIds$1, Workflow.History h) {
        return this.endsWithOneOf(cxt$20.stateMachineId(), (Set<Object>)nodeIds$1, h);
    }

    private static final Object getToState$$anonfun$2$$anonfun$2(Option ret$1) {
        return "getToState history resolution gives: " + ret$1;
    }

    private static final String getToState$$anonfun$3(Transition transition$5, String evt$11, State currentState$3) {
        return "To State not found from Transition " + transition$5.label() + " for event (" + evt$11 + ") from current state " + currentState$3.label();
    }

    private static final /* synthetic */ Option runGuard$$anonfun$1$$anonfun$2(Transition transition$10, boolean isTrue) {
        if (isTrue) {
            return Some$.MODULE$.apply((Object)transition$10);
        }
        return None$.MODULE$;
    }

    private static final Right runGuard$$anonfun$2(Transition transition$11) {
        return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)transition$11));
    }

    private static final Right rightCxt$$anonfun$1(WorkflowExecutor.Context cxt$21) {
        return package$.MODULE$.Right().apply((Object)cxt$21);
    }

    private static final List extractHistory$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    public static final class ErrorMessage
    implements Product,
    Serializable {
        private final String value;

        public static String apply(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$.apply(string);
        }

        public static String unapply(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$.unapply(string);
        }

        public static String _1$extension(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$._1$extension(string);
        }

        public static boolean canEqual$extension(String string, Object object) {
            return WorkflowInstance$ErrorMessage$.MODULE$.canEqual$extension(string, object);
        }

        public static String copy$extension(String string, String string2) {
            return WorkflowInstance$ErrorMessage$.MODULE$.copy$extension(string, string2);
        }

        public static boolean equals$extension(String string, Object object) {
            return WorkflowInstance$ErrorMessage$.MODULE$.equals$extension(string, object);
        }

        public static int hashCode$extension(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$.hashCode$extension(string);
        }

        public static int productArity$extension(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$.productArity$extension(string);
        }

        public static Object productElement$extension(String string, int n) {
            return WorkflowInstance$ErrorMessage$.MODULE$.productElement$extension(string, n);
        }

        public static String productElementName$extension(String string, int n) {
            return WorkflowInstance$ErrorMessage$.MODULE$.productElementName$extension(string, n);
        }

        public static String productPrefix$extension(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$.productPrefix$extension(string);
        }

        public static String toString$extension(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$.toString$extension(string);
        }

        public static String copy$default$1$extension(String string) {
            return WorkflowInstance$ErrorMessage$.MODULE$.copy$default$1$extension(string);
        }

        public ErrorMessage(String value) {
            this.value = value;
        }

        public int hashCode() {
            return WorkflowInstance$ErrorMessage$.MODULE$.hashCode$extension(this.value());
        }

        public boolean equals(Object x$0) {
            return WorkflowInstance$ErrorMessage$.MODULE$.equals$extension(this.value(), x$0);
        }

        public String toString() {
            return WorkflowInstance$ErrorMessage$.MODULE$.toString$extension(this.value());
        }

        public boolean canEqual(Object that) {
            return WorkflowInstance$ErrorMessage$.MODULE$.canEqual$extension(this.value(), that);
        }

        public int productArity() {
            return WorkflowInstance$ErrorMessage$.MODULE$.productArity$extension(this.value());
        }

        public String productPrefix() {
            return WorkflowInstance$ErrorMessage$.MODULE$.productPrefix$extension(this.value());
        }

        public Object productElement(int n) {
            return WorkflowInstance$ErrorMessage$.MODULE$.productElement$extension(this.value(), n);
        }

        public String productElementName(int n) {
            return WorkflowInstance$ErrorMessage$.MODULE$.productElementName$extension(this.value(), n);
        }

        public String value() {
            return this.value;
        }

        public String copy(String value) {
            return WorkflowInstance$ErrorMessage$.MODULE$.copy$extension(this.value(), value);
        }

        public String copy$default$1() {
            return WorkflowInstance$ErrorMessage$.MODULE$.copy$default$1$extension(this.value());
        }

        public String _1() {
            return WorkflowInstance$ErrorMessage$.MODULE$._1$extension(this.value());
        }
    }

    public static interface Result {
        public Json state();
    }

    public static final class ResultFailure
    implements Result,
    Product,
    Serializable {
        private final Json state;
        private final String msg;

        public static ResultFailure apply(Json json, String string) {
            return WorkflowInstance$ResultFailure$.MODULE$.apply(json, string);
        }

        public static ResultFailure fromProduct(Product product) {
            return WorkflowInstance$ResultFailure$.MODULE$.fromProduct(product);
        }

        public static ResultFailure unapply(ResultFailure resultFailure) {
            return WorkflowInstance$ResultFailure$.MODULE$.unapply(resultFailure);
        }

        public ResultFailure(Json state, String msg) {
            this.state = state;
            this.msg = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResultFailure)) return false;
            ResultFailure resultFailure = (ResultFailure)object;
            Json json = this.state();
            Json json2 = resultFailure.state();
            if (json == null) {
                if (json2 != null) {
                    return false;
                }
            } else if (!json.equals(json2)) return false;
            String string = this.msg();
            String string2 = resultFailure.msg();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResultFailure;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResultFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            if (1 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Json state() {
            return this.state;
        }

        public String msg() {
            return this.msg;
        }

        public ResultFailure copy(Json state, String msg) {
            return new ResultFailure(state, msg);
        }

        public Json copy$default$1() {
            return this.state();
        }

        public String copy$default$2() {
            return this.msg();
        }

        public Json _1() {
            return this.state();
        }

        public String _2() {
            return this.msg();
        }
    }

    public static final class ResultSuccess
    implements Result,
    Product,
    Serializable {
        private final Json state;
        private final List deferedEvents;

        public static ResultSuccess apply(Json json, List<DeferredEvent> list) {
            return WorkflowInstance$ResultSuccess$.MODULE$.apply(json, list);
        }

        public static ResultSuccess fromProduct(Product product) {
            return WorkflowInstance$ResultSuccess$.MODULE$.fromProduct(product);
        }

        public static ResultSuccess unapply(ResultSuccess resultSuccess) {
            return WorkflowInstance$ResultSuccess$.MODULE$.unapply(resultSuccess);
        }

        public ResultSuccess(Json state, List<DeferredEvent> deferedEvents) {
            this.state = state;
            this.deferedEvents = deferedEvents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResultSuccess)) return false;
            ResultSuccess resultSuccess = (ResultSuccess)object;
            Json json = this.state();
            Json json2 = resultSuccess.state();
            if (json == null) {
                if (json2 != null) {
                    return false;
                }
            } else if (!json.equals(json2)) return false;
            List<DeferredEvent> list = this.deferedEvents();
            List<DeferredEvent> list2 = resultSuccess.deferedEvents();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResultSuccess;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResultSuccess";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            if (1 == n2) {
                return "deferedEvents";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Json state() {
            return this.state;
        }

        public List<DeferredEvent> deferedEvents() {
            return this.deferedEvents;
        }

        public ResultSuccess copy(Json state, List<DeferredEvent> deferedEvents) {
            return new ResultSuccess(state, deferedEvents);
        }

        public Json copy$default$1() {
            return this.state();
        }

        public List<DeferredEvent> copy$default$2() {
            return this.deferedEvents();
        }

        public Json _1() {
            return this.state();
        }

        public List<DeferredEvent> _2() {
            return this.deferedEvents();
        }
    }
}

