/*
 * Decompiled with CFR 0.152.
 */
package ambience.fedsso;

import ambience.fedsso.FederatedServerHandler;
import ambience.fedsso.FederatedUserDB;
import ambience.module.ProjectConfig;
import ambience.simplesso.MongoDBSSOServerState;
import ambience.simplesso.SimpleSSOModule;
import ambience.simplesso.server.ClientDB;
import ambience.simplesso.server.DefaultSSOServerState$;
import ambience.simplesso.server.LocalInfoRequest;
import ambience.simplesso.server.ResetHandler;
import ambience.simplesso.server.SSOServerState;
import ambience.simplesso.server.SSOStandardRoute;
import ambience.simplesso.server.ServerHandler;
import ambience.simplesso.server.ServerModel;
import ambience.simplesso.server.UserDB;
import ambience.sso.client.ClientModel;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.webserver.WebReply;
import com.typesafe.config.Config;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class FederatedSSOModule
extends SimpleSSOModule {
    private final String name;
    private final String url;

    public FederatedSSOModule(ProjectConfig projectConfig, WebReply webReply) {
        super(projectConfig, webReply);
        this.name = "Federated SSO";
        this.url = "";
    }

    private ProjectConfig projectConfig$accessor() {
        return super.projectConfig();
    }

    private WebReply webReply$accessor() {
        return super.webReply();
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public Function1<GravityRequest, Task<GravityResponse>> buildStandardRoute() {
        DefaultSSOServerState$ defaultSSOServerState$;
        Elixir$.MODULE$.register(ClassTag$.MODULE$.apply(UserDB.class), ClassTag$.MODULE$.apply(FederatedUserDB.class));
        Config config = this.projectConfig$accessor().config();
        boolean isHttps = config.getBoolean("ambience.https.enabled");
        Config ssoConfig = config.getConfig("elixir.sso.server");
        String cookieName = ssoConfig.getString("cookie-name");
        long SessionLength = ssoConfig.getDuration("session-length", package$.MODULE$.MILLISECONDS());
        long MaxLoginDelay = ssoConfig.getDuration("max-login-delay", package$.MODULE$.MILLISECONDS());
        String ClientdbName = ssoConfig.getString("client-database");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clientDBcls = Class.forName(ClientdbName, true, classLoader);
        Elixir$.MODULE$.register(clientDBcls);
        ClientDB clientdb = (ClientDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ClientDB.class));
        FederatedUserDB userdb = (FederatedUserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(UserDB.class));
        Try try_ = Try$.MODULE$.apply(FederatedSSOModule::$anonfun$1);
        if (try_ instanceof Success) {
            MongoDB mongoDB = (MongoDB)((Success)try_).value();
            defaultSSOServerState$ = new MongoDBSSOServerState(mongoDB);
        } else if (try_ instanceof Failure) {
            defaultSSOServerState$ = DefaultSSOServerState$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        DefaultSSOServerState$ serverState = defaultSSOServerState$;
        ServerModel.ServerConfig serverConfig = ServerModel.ServerConfig$.MODULE$.apply(isHttps, cookieName, SessionLength, MaxLoginDelay);
        FederatedServerHandler serverHandler = new FederatedServerHandler(this, serverConfig, userdb, clientdb, (SSOServerState)serverState);
        ResetHandler resetHandler = new ResetHandler((SimpleSSOModule)this, (SSOServerState)serverState, (ServerHandler)serverHandler);
        SSOStandardRoute ssoStandardRoute = new SSOStandardRoute(this.projectConfig$accessor(), cookieName, (ServerHandler)serverHandler, resetHandler);
        LocalInfoRequest localInfoRequest = new LocalInfoRequest((ServerHandler)serverHandler, (SSOServerState)serverState);
        Elixir$.MODULE$.registerInstance((Object)localInfoRequest, ClassTag$.MODULE$.apply(ClientModel.LocalInfoSupplier.class));
        return ssoStandardRoute.apply();
    }

    private static final MongoDB $anonfun$1() {
        return (MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class));
    }
}

