/*
 * Decompiled with CFR 0.152.
 */
package ambience.ldapsso;

import ambience.ldapsso.ControlBuilder$;
import ambience.ldapsso.LDAP;
import ambience.ldapsso.LDAP$Id$;
import ambience.ldapsso.LDAP$IdPart$;
import ambience.ldapsso.LDAPLookup;
import ambience.ldapsso.LDAPUserDB;
import ambience.simplesso.server.ServerModel;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class LDAPDirectLookup
implements LDAPLookup,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LDAPDirectLookup.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final LDAPUserDB.LDAPConfig ldapConfig;

    public LDAPDirectLookup(LDAPUserDB.LDAPConfig ldapConfig) {
        this.ldapConfig = ldapConfig;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public InitialLdapContext buildContext(String dn, String password) {
        Object[] objectArray = new Tuple2[8];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"java.naming.factory.initial");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.ldapConfig.cxtFactory());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"com.sun.jndi.ldap.connect.timeout");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)this.ldapConfig.connectTimeout().toMillis()).toString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"com.sun.jndi.ldap.read.timeout");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToLong((long)this.ldapConfig.readTimeout().toMillis()).toString());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"java.naming.provider.url");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)this.ldapConfig.url());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.protocol");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)this.ldapConfig.protocol());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.authentication");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)this.ldapConfig.method());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.principal");
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)dn);
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.credentials");
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)password);
        scala.collection.immutable.Map envParameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return new InitialLdapContext(new Hashtable(CollectionConverters$.MODULE$.MapHasAsJava((Map)envParameters).asJava()), ControlBuilder$.MODULE$.controls());
    }

    @Override
    public Task<Option<ServerModel.UserRecord>> matches(String name, String password) {
        Option<String> option = this.isValid(name, password);
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            String email = object == null ? null : ((ServerModel.Email)object).value();
            String sub = ServerModel.Sub$.MODULE$.apply(name);
            String json = ServerModel.Json$.MODULE$.apply("{}");
            return Task$.MODULE$.now((Object)Some$.MODULE$.apply((Object)ServerModel.UserRecord$.MODULE$.apply(sub, name, email, false, json)));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Option<String> isValid(String user, String password) {
        if (password.trim().isEmpty()) {
            return None$.MODULE$;
        }
        Option option = this.ldapConfig.users().headOption();
        if (option instanceof Some) {
            None$ none$;
            String usersOU = (String)((Some)option).value();
            if (this.ldapConfig.users().length() > 1) {
                this.log().warn(() -> LDAPDirectLookup.isValid$$anonfun$1(usersOU), Line$.MODULE$.apply(46), FullName$.MODULE$.apply("ambience.ldapsso.LDAPDirectLookup.isValid"));
            }
            LDAP.IdPart idPart = LDAP$IdPart$.MODULE$.apply(this.ldapConfig.uidAttribute(), user);
            String dn = LDAP$Id$.MODULE$.apply((List<LDAP.IdPart>)LDAP$Id$.MODULE$.parse(usersOU).parts().reverse().$colon$colon((Object)idPart)).toString();
            try {
                InitialLdapContext userContext = this.buildContext(dn, password);
                BasicAttributes attrs = new BasicAttributes(this.ldapConfig.uidAttribute(), user);
                List result = CollectionConverters$.MODULE$.EnumerationHasAsScala(userContext.search(usersOU, (Attributes)attrs, new String[]{this.ldapConfig.mailAttribute()})).asScala().toList();
                none$ = result.headOption().flatMap((Function1 & Serializable)f -> Option$.MODULE$.apply((Object)f.getAttributes().get(this.ldapConfig.mailAttribute())).flatMap((Function1 & Serializable)att -> Option$.MODULE$.apply(att.get()).map((Function1 & Serializable)email -> new ServerModel.Email(ServerModel.Email$.MODULE$.apply(email.toString())))));
            }
            catch (Exception ex) {
                this.log().info(() -> LDAPDirectLookup.isValid$$anonfun$3(ex), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.ldapsso.LDAPDirectLookup.isValid"));
                ex.printStackTrace();
                none$ = None$.MODULE$;
            }
            return none$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private static final Object isValid$$anonfun$1(String usersOU$1) {
        return "Only using first users entry (" + usersOU$1 + ") in direct mode";
    }

    private static final Object isValid$$anonfun$3(Exception ex$1) {
        return "isValid fails with: " + ex$1;
    }
}

