/*
 * Decompiled with CFR 0.152.
 */
package ambience.recordeditor.audit;

import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.util.Map;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;

public final class BsonExtractJson$
implements Serializable {
    public static final BsonExtractJson$ MODULE$ = new BsonExtractJson$();

    private BsonExtractJson$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BsonExtractJson$.class);
    }

    public Json toJson(Document doc) {
        return this.toJson((BsonValue)doc.toBsonDocument());
    }

    public Json toJson(BsonValue bv2) {
        BsonValue bsonValue = bv2;
        if (bsonValue instanceof BsonNull) {
            return Json$.MODULE$.Null();
        }
        if (bsonValue instanceof BsonString) {
            BsonString v = (BsonString)bsonValue;
            return Json$.MODULE$.fromString(v.getValue());
        }
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean v = (BsonBoolean)bsonValue;
            return Json$.MODULE$.fromBoolean(v.getValue());
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 v = (BsonInt32)bsonValue;
            return Json$.MODULE$.fromInt(v.getValue());
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 v = (BsonInt64)bsonValue;
            return Json$.MODULE$.fromLong(v.getValue());
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble v = (BsonDouble)bsonValue;
            return Json$.MODULE$.fromDoubleOrNull(v.getValue());
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 v = (BsonDecimal128)bsonValue;
            return Json$.MODULE$.fromString(v.getValue().bigDecimalValue().toPlainString());
        }
        if (bsonValue instanceof BsonObjectId) {
            BsonObjectId v = (BsonObjectId)bsonValue;
            return Json$.MODULE$.fromString(v.getValue().toHexString());
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime v = (BsonDateTime)bsonValue;
            return Json$.MODULE$.fromLong(v.getValue());
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray v = (BsonArray)bsonValue;
            return Json$.MODULE$.fromValues((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(v.getValues()).asScala().map((Function1 & Serializable)bv -> this.toJson((BsonValue)bv)));
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument v = (BsonDocument)bsonValue;
            return Json$.MODULE$.fromFields((Iterable)CollectionConverters$.MODULE$.MapHasAsScala((Map)v).asScala().view().mapValues((Function1 & Serializable)bv -> this.toJson((BsonValue)bv)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        return Json$.MODULE$.Null();
    }
}

