/*
 * Decompiled with CFR 0.152.
 */
package ambience.recordeditor.editor;

import ambience.api.WebStore;
import ambience.framework.WebStoreAPI$;
import ambience.module.UserDB;
import ambience.recordeditor.Model;
import ambience.recordeditor.audit.Audit$Deleted$;
import ambience.recordeditor.audit.DiffPair$;
import ambience.recordeditor.editor.ActionContext;
import ambience.recordeditor.editor.ActionContext$;
import ambience.recordeditor.editor.DatasetIntegration$;
import ambience.recordeditor.editor.ETLUtil$;
import ambience.recordeditor.editor.IDUtil$;
import ambience.recordeditor.editor.REUtil$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.RichMongoCollection;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonDateTime;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RecordDelete$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(RecordDelete$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RecordDelete$.class.getDeclaredField("clock$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object clock$lzy1;
    public static final RecordDelete$ MODULE$ = new RecordDelete$();

    private RecordDelete$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RecordDelete$.class);
    }

    public Clock clock() {
        Object object = this.clock$lzy1;
        if (object instanceof Clock) {
            return (Clock)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Clock)this.clock$lzyINIT1();
    }

    private Object clock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Clock clock = null;
                    try {
                        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
                        object2 = clock == null ? LazyVals.NullValue$.MODULE$ : clock;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clock;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<String, BoxedUnit>> apply(UserDB.User user, Model.EditRecord editRecord) {
        String idString = REUtil$.MODULE$.extractString(editRecord.recordId().id());
        EitherT result = EitherT$.MODULE$.apply(ActionContext$.MODULE$.apply(user, editRecord.recordEditorId())).flatMap((Function1 & Serializable)cxt -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.$anonfun$1$$anonfun$1(cxt))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(DatasetIntegration$.MODULE$.getDatabaseName(cxt.recordEditor().dataset())).flatMap((Function1 & Serializable)dbName -> EitherT$.MODULE$.apply(this.getRecord(cxt.cltn(), editRecord.recordId())).flatMap((Function1 & Serializable)record -> EitherT$.MODULE$.apply(this.validate((ActionContext)cxt, (Document)record)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherT$.MODULE$.apply(this.doRecycle((String)dbName, cxt.recordEditor().dataset(), (Document)record)).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(this.deletePermanent(cxt.cltn(), editRecord.recordId())).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return EitherT$.MODULE$.apply(REUtil$.MODULE$.buildAuditT((ActionContext)cxt, idString, DiffPair$.MODULE$.apply((Option<Document>)None$.MODULE$, (Option<Document>)None$.MODULE$), Audit$Deleted$.MODULE$)).flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return EitherT$.MODULE$.apply(this.onDelete((ActionContext)cxt, (Document)record)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }, (Functor)Task$.MODULE$.catsAsync());
                        }, (Monad)Task$.MODULE$.catsAsync());
                    }, (Monad)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return (Task)result.value();
    }

    public Task<Either<String, Document>> getRecord(RichMongoCollection cltn, Model.RecordId recordId) {
        Option<BsonValue> option = IDUtil$.MODULE$.bsonId(recordId);
        if (option instanceof Some) {
            BsonValue id = (BsonValue)((Some)option).value();
            return cltn.findO(Filters$.MODULE$.eq("_id", (Object)id)).firstOptionL().map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Document record = (Document)((Some)option).value();
                    return Right$.MODULE$.apply((Object)record);
                }
                if (None$.MODULE$.equals(option)) {
                    return Left$.MODULE$.apply((Object)("Unable to get record " + id));
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply(() -> this.getRecord$$anonfun$2(recordId));
        }
        throw new MatchError(option);
    }

    public Document buildRecycleRecord(String dbName, String cltnName, Document doc) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"database");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(dbName)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"collection");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(cltnName)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"expireAt");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.buildExpireAt((WebStore.Expires)WebStore.Expires$.Default$.MODULE$)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"record");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonDocument$.MODULE$.apply((Iterable)doc)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Task<Either<String, BoxedUnit>> deletePermanent(RichMongoCollection cltn, Model.RecordId recordId) {
        Option<BsonValue> option = IDUtil$.MODULE$.bsonId(recordId);
        if (option instanceof Some) {
            BsonValue id = (BsonValue)((Some)option).value();
            return this.deletePermanentByBsonId(cltn, id);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply(() -> this.deletePermanent$$anonfun$1(recordId));
        }
        throw new MatchError(option);
    }

    public Task<Either<String, BoxedUnit>> deletePermanentByBsonId(RichMongoCollection cltn, BsonValue id) {
        return cltn.deleteOneT(Filters$.MODULE$.eq("_id", (Object)id)).map((Function1 & Serializable)reply -> {
            if (reply.wasAcknowledged()) {
                return Right$.MODULE$.apply((Object)BoxedUnit.UNIT);
            }
            return Left$.MODULE$.apply((Object)"Unable to delete record");
        });
    }

    public BsonDateTime buildExpireAt(WebStore.Expires expires) {
        WebStore.Expires expires2 = expires;
        if (WebStore.Expires$.Default$.MODULE$.equals(expires2)) {
            return BsonDateTime$.MODULE$.apply(this.clock().now() + WebStoreAPI$.MODULE$.DefaultExpiryMS());
        }
        if (expires2 instanceof WebStore.Expires$.AfterMs) {
            long l;
            WebStore.Expires$.AfterMs afterMs = WebStore.Expires$.AfterMs$.MODULE$.unapply((WebStore.Expires$.AfterMs)expires2);
            long ms = l = afterMs._1();
            return BsonDateTime$.MODULE$.apply(this.clock().now() + ms);
        }
        if (expires2 instanceof WebStore.Expires$.AtMs) {
            long l;
            WebStore.Expires$.AtMs atMs = WebStore.Expires$.AtMs$.MODULE$.unapply((WebStore.Expires$.AtMs)expires2);
            long ms = l = atMs._1();
            return BsonDateTime$.MODULE$.apply(ms);
        }
        throw new MatchError((Object)expires2);
    }

    public Task<Either<String, BoxedUnit>> doRecycle(String dbName, String dataset, Document doc) {
        return REUtil$.MODULE$.recordBinCltn().insertOneT(this.buildRecycleRecord(dbName, dataset, doc)).map((Function1 & Serializable)_$1 -> Right$.MODULE$.apply((Object)BoxedUnit.UNIT));
    }

    public Task<Either<String, BoxedUnit>> validate(ActionContext cxt, Document doc) {
        Model.ETLIntegration etl = cxt.recordEditor().etlIntegration();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(etl.chainSetName().trim())) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(etl.validateDelete().trim()))) {
            this.log().info(() -> this.validate$$anonfun$1(etl), Line$.MODULE$.apply(89), FullName$.MODULE$.apply("ambience.recordeditor.editor.RecordDelete.validate"));
            return ETLUtil$.MODULE$.validate(cxt.user(), etl.chainSetName(), etl.validateDelete(), doc);
        }
        return Task$.MODULE$.now((Object)Right$.MODULE$.apply((Object)BoxedUnit.UNIT));
    }

    public Task<Either<String, BoxedUnit>> onDelete(ActionContext cxt, Document doc) {
        Model.ETLIntegration etl = cxt.recordEditor().etlIntegration();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(etl.chainSetName().trim())) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(etl.onDelete().trim()))) {
            this.log().info(() -> this.onDelete$$anonfun$1(etl), Line$.MODULE$.apply(98), FullName$.MODULE$.apply("ambience.recordeditor.editor.RecordDelete.onDelete"));
            return ETLUtil$.MODULE$.onEvent(cxt.user(), etl.chainSetName(), etl.onDelete(), doc);
        }
        return Task$.MODULE$.now((Object)Right$.MODULE$.apply((Object)BoxedUnit.UNIT));
    }

    private final Either $anonfun$1$$anonfun$1(ActionContext cxt$1) {
        if (cxt$1.recordEditor().canDelete()) {
            return Right$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }
        return Left$.MODULE$.apply((Object)"Delete disallowed");
    }

    private final Left getRecord$$anonfun$2(Model.RecordId recordId$1) {
        return Left$.MODULE$.apply((Object)("Id " + recordId$1 + " not found"));
    }

    private final Left deletePermanent$$anonfun$1(Model.RecordId recordId$2) {
        return Left$.MODULE$.apply((Object)("Id " + recordId$2 + " not found. No record deleted"));
    }

    private final Object validate$$anonfun$1(Model.ETLIntegration etl$1) {
        return "validateDelete " + etl$1.validateEdit();
    }

    private final Object onDelete$$anonfun$1(Model.ETLIntegration etl$2) {
        return "onDelete " + etl$2.onEdit();
    }
}

