/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.chore;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.chore.ChoreFileObject;
import ambience.etl.chore.ChoreJobLogging;
import ambience.etl.chore.ChoreRepository$;
import ambience.etl.chore.RunJobStep;
import ambience.etl.chore.RunJobStep$Info$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.module.CurrentUser$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.api.SchedulerAPI;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.job.IJobLog;
import com.elixirtech.arch.job.IJobLogging;
import com.elixirtech.arch.job.JobEntry;
import com.elixirtech.arch.job.JobLogStorage$;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.job.JobReference$;
import com.elixirtech.v2.jobengine.job.RunJob;
import com.elixirtech.v2.jobengine.job.RunJob$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class RunJobStep$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    private static final List LevelChoices;
    public static final RunJobStep$Info$ Info;
    public static final RunJobStep$ MODULE$;

    private RunJobStep$() {
    }

    static {
        MODULE$ = new RunJobStep$();
        stepType = ETLStepType$.MODULE$.apply("chore.RunJob");
        LevelChoices = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"debug", "info", "warn", "error"}))).map((Function1 & Serializable)s -> Panel.SelectChoice$.MODULE$.apply(s, Json$.MODULE$.fromString(s)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RunJobStep$.class);
    }

    public String stepType() {
        return stepType;
    }

    public List<Panel.SelectChoice> LevelChoices() {
        return LevelChoices;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "jobField";
        String string2 = "logLevel";
        int size = 2;
        RunJobStep.Info info = (RunJobStep.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), this::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$anonfun$3))))).toOption().getOrElse(this::$anonfun$4);
        Panel.Item field = PanelItem$.MODULE$.text("jobField", "Job Field", info.jobField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item level = PanelItem$.MODULE$.select("logLevel", "Log Level", Json$.MODULE$.fromString(info.logLevel()), this.LevelChoices(), PanelItem$.MODULE$.select$default$5());
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(field, level));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "jobField";
        String string2 = "logLevel";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), this::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> this.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> this.run(cxt, (RunJobStep.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, RunJobStep.Info info, Observable<Document> from) {
        LoggingHelper.Level logLevel = this.getLogLevel(info.logLevel());
        return from.mapEval((Function1 & Serializable)doc -> {
            Option option = BsonETL$.MODULE$.get(doc, info.jobField());
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    Map<String, String> parameters = this.buildParameters((Document)doc);
                    return cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Running job " + s.getValue() + " with parameters " + parameters)).map((Function1 & Serializable)_$1 -> this.run(cxt, s.getValue(), logLevel, parameters));
                }
                BsonValue x = bsonValue;
                return cxt.logRecord(doc, (LogMessage)LogMessage.Warn$.MODULE$.apply("No job field " + info.jobField() + " string expected, got " + x));
            }
            if (None$.MODULE$.equals(option)) {
                return cxt.logRecord(doc, (LogMessage)LogMessage.Warn$.MODULE$.apply("No job field " + info.jobField()));
            }
            throw new MatchError((Object)option);
        });
    }

    public LoggingHelper.Level getLogLevel(String name) {
        String string = name;
        switch (string == null ? 0 : string.hashCode()) {
            case 3237038: {
                if (!"info".equals(string)) break;
                return LoggingHelper.Info$.MODULE$;
            }
            case 3641990: {
                if (!"warn".equals(string)) break;
                return LoggingHelper.Warn$.MODULE$;
            }
            case 95458899: {
                if (!"debug".equals(string)) break;
                return LoggingHelper.Debug$.MODULE$;
            }
            case 96784904: {
                if (!"error".equals(string)) break;
                return LoggingHelper.Error$.MODULE$;
            }
        }
        return LoggingHelper.Info$.MODULE$;
    }

    public Map<String, String> buildParameters(Document record) {
        return record.toList().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BsonValue bsonValue = (BsonValue)tuple2._2();
                String k = (String)tuple2._1();
                if (bsonValue instanceof BsonString) {
                    BsonString v = (BsonString)bsonValue;
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v.getValue()));
                }
            }
            return None$.MODULE$;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Document run(Builder.Context cxt, String jobName, LoggingHelper.Level logLevel, Map<String, String> parameters) {
        return (Document)CurrentUser$.MODULE$.withUser(cxt.user(), () -> this.run$$anonfun$2(cxt, logLevel, jobName, parameters));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        Decoder decodeA;
        void var2_1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 $anonfun$2() {
        RunJobStep$Info$ runJobStep$Info$ = RunJobStep$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RunJobStep.Info)runJobStep$Info$.fromProduct((Product)p);
    }

    private final Product $anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)RunJobStep$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)RunJobStep$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    private final RunJobStep.Info $anonfun$4() {
        return RunJobStep$Info$.MODULE$.apply(RunJobStep$Info$.MODULE$.$lessinit$greater$default$1(), RunJobStep$Info$.MODULE$.$lessinit$greater$default$2());
    }

    private final Panel buildPanel$$anonfun$1(Panel.Item field$1, Panel.Item level$1) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{field$1, level$1})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var2_1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 savePanel$$anonfun$1$$anonfun$2() {
        RunJobStep$Info$ runJobStep$Info$ = RunJobStep$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RunJobStep.Info)runJobStep$Info$.fromProduct((Product)p);
    }

    private final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)RunJobStep$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)RunJobStep$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$5() {
        Encoder encodeA;
        void var2_1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "jobField";
        String string2 = "logLevel";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), this::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            RunJobStep.Info info2 = (RunJobStep.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "jobField";
            String string2 = "logLevel";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string3 = step$1.copy$default$1();
            String string4 = step$1.copy$default$2();
            String string5 = step$1.copy$default$3();
            String string6 = step$1.copy$default$4();
            String string7 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string3, string4, string5, string6, string7, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List build$$anonfun$1() {
        Decoder decodeA;
        void var2_1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 build$$anonfun$2() {
        RunJobStep$Info$ runJobStep$Info$ = RunJobStep$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RunJobStep.Info)runJobStep$Info$.fromProduct((Product)p);
    }

    private final Product build$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)RunJobStep$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)RunJobStep$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    private final RunJob $anonfun$6(String jobName$2, Map parameters$3) {
        JobLogging$.MODULE$.add((JobEntry)JobReference$.MODULE$.apply(jobName$2, JobReference$.MODULE$.$lessinit$greater$default$2()));
        Option<ChoreFileObject> option = ChoreRepository$.MODULE$.getFile(jobName$2);
        if (option instanceof Some) {
            ChoreFileObject fo = (ChoreFileObject)((Some)option).value();
            return RunJob$.MODULE$.apply(fo, (Map<String, String>)parameters$3);
        }
        if (None$.MODULE$.equals(option)) {
            throw JobLogging$.MODULE$.unableToComplete("Job file \"" + jobName$2 + "\" not found");
        }
        throw new MatchError(option);
    }

    private final Document run$$anonfun$2(Builder.Context cxt$5, LoggingHelper.Level logLevel$3, String jobName$1, Map parameters$2) {
        Tuple2 tuple2 = JobLogging$.MODULE$.run((IJobLogging)new ChoreJobLogging("ETL-RunJob", cxt$5.user(), logLevel$3), () -> this.$anonfun$6(jobName$1, parameters$2));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IJobLog jobLog = (IJobLog)tuple2._1();
        Option ret = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)jobLog, (Object)ret);
        IJobLog jobLog2 = (IJobLog)tuple22._1();
        Option ret2 = (Option)tuple22._2();
        Document base = JobLogStorage$.MODULE$.save(jobLog2);
        SchedulerAPI.TriggerStatus status = jobLog2.statusCode();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"status");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(status.name())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"statusCode");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(status.value())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt64$.MODULE$.apply(jobLog2.elapsedTime())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return (Document)base.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }
}

