/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chore.model;

import com.elixirtech.chore.model.ITaskHolder;
import com.elixirtech.chore.model.Job;
import com.elixirtech.chore.model.Task;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class CompositeTask
extends Task
implements IBean,
ITaskHolder {
    protected List<Task> m_Task = new ArrayList<Task>();

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "composite-task";
    }

    @Override
    public void loaded() {
        super.loaded();
        Iterator<Task> iterator = this.m_Task.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Task != null) {
            Iterator<Task> iterator = this.m_Task.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Task = null;
    }

    @Override
    public void copyAttrs(Element element) {
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        CompositeTask compositeTask = (CompositeTask)super.shallowCopy();
        return compositeTask;
    }

    public void addTask(Task task) {
        this.m_Task.add(task);
        task.setParent(this);
        Job.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            int n = this.m_Task.indexOf(task);
            myTreeModel.fireInsertedEvent(myTreeModel.getTreePath(this), new int[]{n}, new Object[]{task});
        }
    }

    public void addTask(int n, Task task) {
        this.m_Task.add(n, task);
        task.setParent(this);
        Job.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            int n2 = this.m_Task.indexOf(task);
            myTreeModel.fireInsertedEvent(myTreeModel.getTreePath(this), new int[]{n2}, new Object[]{task});
        }
    }

    public void addAllTasks(Collection<Task> collection) {
        this.m_Task.addAll(collection);
        for (Task task : collection) {
            task.setParent(this);
        }
        Job.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    public int indexOfTask(Task task) {
        return this.m_Task.indexOf(task);
    }

    public void removeTask(Task task) {
        int n = this.m_Task.indexOf(task);
        this.m_Task.remove(task);
        task.setParent(null);
        Job.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireRemovedEvent(myTreeModel.getTreePath(this), new int[]{n}, new Object[]{task});
        }
    }

    public void removeAllTasks(Collection collection) {
        Object object2;
        this.m_Task.removeAll(collection);
        for (Object object2 : collection) {
            ((Task)object2).setParent(null);
        }
        object2 = this.getTreeModel();
        if (object2 != null) {
            ((Job.MyTreeModel)object2).fireStructureChangedEvent(((Job.MyTreeModel)object2).getTreePath(this));
        }
    }

    public void removeAllTasks() {
        for (Task object2 : this.m_Task) {
            object2.setParent(null);
        }
        this.m_Task.clear();
        Job.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    @Override
    public Task getTask(int n) {
        return this.m_Task.get(n);
    }

    @Override
    public int getTaskCount() {
        return this.m_Task.size();
    }

    public Iterator<Task> getTaskIterator() {
        return this.m_Task.iterator();
    }

    public List<Task> getTaskList() {
        return this.m_Task;
    }

    public void setTaskList(List<Task> list) {
        this.m_Task = list;
        Job.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    @Override
    public abstract CompositeTask deepCopy();

    protected void copyInto(CompositeTask compositeTask) {
        super.copyInto(compositeTask);
        compositeTask.m_Task = new ArrayList<Task>();
        for (Task task : this.m_Task) {
            compositeTask.addTask(task.deepCopy());
        }
    }
}

