/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import ambience.etl.chore.ChoreFileObject;
import ambience.etl.chore.ChoreRepository;
import ambience.etl.chore.GenerateDataLogic;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.DataSource;
import com.elixirtech.chore.model.GenerateData;
import com.elixirtech.chore.model.Task;
import com.elixirtech.v2.jobengine.job.NonRecoverableException;
import com.elixirtech.v2.jobengine.job.RecoverableException;
import com.elixirtech.v2.jobengine.job.RunJob;
import com.elixirtech.v2.jobengine.job.TaskException;
import com.elixirtech.v2.jobengine.job.TaskRunnable;
import java.util.HashMap;

public class GenerateDataRunnable
implements TaskRunnable {
    public static final String TYPE = "GenerateData";
    private GenerateData m_GenerateData;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GenerateDataRunnable.class);

    @Override
    public void setTask(Task task) {
        this.m_GenerateData = (GenerateData)task;
    }

    @Override
    public Task getTask() {
        return this.m_GenerateData;
    }

    @Override
    public void run(JobContext jobContext) throws TaskException {
        jobContext.debug(TYPE, "begin");
        DataSource dataSource = this.m_GenerateData.getDataSource();
        String string = jobContext.substitute(dataSource.getName());
        ChoreFileObject choreFileObject = ChoreRepository.getFileJ(string);
        if (choreFileObject == null) {
            String string2 = "DataSource not available: " + string;
            jobContext.error(TYPE, string2);
            throw new NonRecoverableException(string2);
        }
        String string3 = jobContext.substitute(this.m_GenerateData.getDataStore());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(RunJob.getParamsJ(jobContext, dataSource));
        try {
            GenerateDataLogic.runJ(string, string3, hashMap);
        }
        catch (Exception exception) {
            String string4 = "Exception generating data: " + exception;
            jobContext.error(TYPE, string4);
            m_Log.error((Object)string4, (Throwable)exception);
            throw new RecoverableException(exception);
        }
        jobContext.debug(TYPE, "end");
    }
}

