/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.v2.jobengine.job.TimeUtil;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class WhenProcessor {
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(WhenProcessor.class);

    public static WhenProcessor get(String string) {
        if ("Equals".equals(string)) {
            return new EqualsProcessor();
        }
        if ("Not Equals".equals(string)) {
            return new NotProcessor(new EqualsProcessor());
        }
        if ("StartsWith".equals(string)) {
            return new StartsWithProcessor();
        }
        if ("EndsWith".equals(string)) {
            return new EndsWithProcessor();
        }
        if ("Matches".equals(string)) {
            return new MatchesProcessor();
        }
        if ("Not Matches".equals(string)) {
            return new NotProcessor(new MatchesProcessor());
        }
        if ("After".equals(string)) {
            return new AfterProcessor();
        }
        if ("Before".equals(string)) {
            return new BeforeProcessor();
        }
        return null;
    }

    protected static long calcTimeValue(String string) throws ParseException {
        if (string.startsWith("+")) {
            String string2 = string.substring(1).trim();
            long l = TimeUtil.parseInterval(string2);
            long l2 = System.currentTimeMillis();
            return l2 + l;
        }
        if (string.startsWith("-")) {
            String string3 = string.substring(1).trim();
            long l = TimeUtil.parseInterval(string3);
            long l3 = System.currentTimeMillis();
            return l3 - l;
        }
        try {
            return TimeUtil.JodaTimestampFormatter.parseMillis(string);
        }
        catch (Exception exception) {
            try {
                return TimeUtil.JodaDateFormatter.parseMillis(string);
            }
            catch (Exception exception2) {
                throw new ParseException(exception2.toString(), 0);
            }
        }
    }

    public abstract boolean matches(Object var1, String var2);

    static class EqualsProcessor
    extends WhenProcessor {
        EqualsProcessor() {
        }

        @Override
        public boolean matches(Object object, String string) {
            return String.valueOf(object).equals(string);
        }
    }

    static class NotProcessor
    extends WhenProcessor {
        private WhenProcessor m_Parent;

        public NotProcessor(WhenProcessor whenProcessor) {
            this.m_Parent = whenProcessor;
        }

        @Override
        public boolean matches(Object object, String string) {
            return !this.m_Parent.matches(object, string);
        }
    }

    static class StartsWithProcessor
    extends WhenProcessor {
        StartsWithProcessor() {
        }

        @Override
        public boolean matches(Object object, String string) {
            return String.valueOf(object).startsWith(string);
        }
    }

    static class EndsWithProcessor
    extends WhenProcessor {
        EndsWithProcessor() {
        }

        @Override
        public boolean matches(Object object, String string) {
            return String.valueOf(object).endsWith(string);
        }
    }

    static class MatchesProcessor
    extends WhenProcessor {
        MatchesProcessor() {
        }

        @Override
        public boolean matches(Object object, String string) {
            try {
                Pattern pattern = Pattern.compile(string);
                Matcher matcher = pattern.matcher(String.valueOf(object));
                return matcher.matches();
            }
            catch (Throwable throwable) {
                m_Log.warn((Object)("Error processing match pattern: " + throwable));
                return false;
            }
        }
    }

    static class AfterProcessor
    extends WhenProcessor {
        AfterProcessor() {
        }

        @Override
        public boolean matches(Object object, String string) {
            if (object instanceof String) {
                return ((String)object).compareTo(string) < 0;
            }
            long l = (Long)object;
            try {
                long l2 = AfterProcessor.calcTimeValue(string);
                return l > l2;
            }
            catch (ParseException parseException) {
                m_Log.warn((Object)("Can't parse value: " + string));
                return false;
            }
        }
    }

    static class BeforeProcessor
    extends WhenProcessor {
        BeforeProcessor() {
        }

        @Override
        public boolean matches(Object object, String string) {
            if (object instanceof String) {
                return ((String)object).compareTo(string) > 0;
            }
            long l = (Long)object;
            try {
                long l2 = BeforeProcessor.calcTimeValue(string);
                return l < l2;
            }
            catch (ParseException parseException) {
                m_Log.warn((Object)("Can't parse value: " + string));
                return false;
            }
        }
    }
}

