/*
 * Decompiled with CFR 0.152.
 */
package ambience.businessrules.runtime;

import ambience.api.ChainRunner;
import ambience.businessrules.model.BRule;
import ambience.businessrules.model.BRuleId;
import ambience.businessrules.model.BusinessRules;
import ambience.businessrules.model.ChoicePath;
import ambience.businessrules.model.Effect;
import ambience.businessrules.runtime.BsonLogicWrapper;
import ambience.businessrules.runtime.BsonLogicWrapper$;
import ambience.businessrules.runtime.LogicEngine;
import ambience.businessrules.runtime.LogicEngine$;
import ambience.etl.BuildError;
import ambience.etl.ETLChainSet;
import ambience.etl.ETLLogger;
import ambience.etl.ETLPosition;
import ambience.etl.job.ChainBuilder;
import ambience.etl.runtime.ChainRunnerImpl;
import ambience.module.UserDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.codex.CodexDB;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class RuntimeEngine {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(RuntimeEngine.class.getDeclaredField("chainSetT$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(RuntimeEngine.class.getDeclaredField("chainRunner$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RuntimeEngine.class.getDeclaredField("codexDB$lzy1"));
    private final UserDB.User user;
    private final BusinessRules rules;
    private final ETLLogger logger;
    private final ETLPosition position;
    private volatile Object codexDB$lzy1;
    private volatile Object chainRunner$lzy1;
    private volatile Object chainSetT$lzy1;

    public RuntimeEngine(UserDB.User user, BusinessRules rules, ETLLogger logger, ETLPosition position) {
        this.user = user;
        this.rules = rules;
        this.logger = logger;
        this.position = position;
    }

    public CodexDB codexDB() {
        Object object = this.codexDB$lzy1;
        if (object instanceof CodexDB) {
            return (CodexDB)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodexDB)this.codexDB$lzyINIT1();
    }

    private Object codexDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codexDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodexDB codexDB = null;
                    try {
                        codexDB = (CodexDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(CodexDB.class));
                        object2 = codexDB == null ? LazyVals.NullValue$.MODULE$ : codexDB;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codexDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return codexDB;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ChainRunnerImpl chainRunner() {
        Object object = this.chainRunner$lzy1;
        if (object instanceof ChainRunnerImpl) {
            return (ChainRunnerImpl)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ChainRunnerImpl)this.chainRunner$lzyINIT1();
    }

    private Object chainRunner$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.chainRunner$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ChainRunnerImpl chainRunnerImpl = null;
                    try {
                        chainRunnerImpl = new ChainRunnerImpl(this.codexDB());
                        object2 = chainRunnerImpl == null ? LazyVals.NullValue$.MODULE$ : chainRunnerImpl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.chainRunner$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return chainRunnerImpl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<ETLChainSet> chainSetT() {
        Object object = this.chainSetT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.chainSetT$lzyINIT1();
    }

    private Object chainSetT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.chainSetT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = this.chainRunner().loadChainSet(this.user, (ChainRunner.ChainSpec)ChainRunner.ChainNameSpec$.MODULE$.apply(this.rules.chainsetName(), "")).memoize();
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.chainSetT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Document> run(Document in) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.rules.startRuleId()))) {
            return this.runRule(in, this.rules.startRuleId());
        }
        return Task$.MODULE$.now((Object)in);
    }

    public Task<Document> runRule(Document in, String ruleId) {
        Option option = this.rules.rule(ruleId);
        if (option instanceof Some) {
            BRule rule = (BRule)((Some)option).value();
            return this.runRule(in, rule);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.raiseError((Throwable)new RuntimeException("Error locating ruleId " + ruleId));
        }
        throw new MatchError((Object)option);
    }

    public Task<Document> runRule(Document in, BRule rule) {
        return this.logger.logT(this.position, (LogMessage)LogMessage.Info$.MODULE$.apply("Running rule " + rule.label())).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ((Task)rule.onEntry().map((Function1 & Serializable)eff -> this.runChain((Effect)eff, in)).getOrElse(() -> RuntimeEngine.runRule$$anonfun$1$$anonfun$2(in))).flatMap((Function1 & Serializable)a -> Task$.MODULE$.apply(() -> RuntimeEngine.runRule$$anonfun$1$$anonfun$3$$anonfun$1(rule, a)).flatMap((Function1 & Serializable)bool -> this.runRule$$anonfun$1$$anonfun$3$$anonfun$2((Document)a, rule, BoxesRunTime.unboxToBoolean((Object)bool))));
        });
    }

    public Task<Document> applyResult(Document in, BRule rule, boolean bool) {
        ChoicePath next = bool ? rule.yesPath() : rule.noPath();
        return ((Task)next.effect().map((Function1 & Serializable)eff -> this.runChain((Effect)eff, in)).getOrElse(() -> RuntimeEngine.applyResult$$anonfun$2(in))).flatMap((Function1 & Serializable)b -> {
            Task<Document> task;
            Option option = next.target();
            if (option instanceof Some) {
                Object object = ((Some)option).value();
                String ruleId = object == null ? null : ((BRuleId)object).value();
                task = this.runRule((Document)b, ruleId);
            } else if (None$.MODULE$.equals(option)) {
                task = Task$.MODULE$.now(b);
            } else {
                throw new MatchError((Object)option);
            }
            return task.map((Function1 & Serializable)result -> result);
        });
    }

    public Task<Document> runChain(Effect eff, Document in) {
        return this.chainSetT().flatMap((Function1 & Serializable)chainSet -> this.runChain((ETLChainSet)chainSet, eff.chainName(), in).map((Function1 & Serializable)ret -> ret));
    }

    public Task<Document> runChain(ETLChainSet chainSet, String chainName, Document in) {
        ChainBuilder builder = new ChainBuilder(chainSet, this.logger, this.user);
        Either either = builder.buildChain((Option)None$.MODULE$, chainName, (Option)None$.MODULE$);
        if (either instanceof Right) {
            Function1 flow = (Function1)((Right)either).value();
            return ((Observable)flow.apply((Object)Observable$.MODULE$.now((Object)in))).firstOptionL().map((Function1 & Serializable)_$1 -> (Document)_$1.getOrElse(() -> RuntimeEngine.runChain$$anonfun$2$$anonfun$1(in)));
        }
        if (either instanceof Left) {
            BuildError err = (BuildError)((Left)either).value();
            return Task$.MODULE$.raiseError((Throwable)new RuntimeException("Error building chain: " + err.msg()));
        }
        throw new MatchError((Object)either);
    }

    private static final Task runRule$$anonfun$1$$anonfun$2(Document in$3) {
        return Task$.MODULE$.now((Object)in$3);
    }

    private static final boolean runRule$$anonfun$1$$anonfun$3$$anonfun$1(BRule rule$3, Document a$1) {
        BsonLogicWrapper bsonLogicWrapper = BsonLogicWrapper$.MODULE$.apply(a$1);
        return rule$3.logic().exists((Function1 & Serializable)logic -> LogicEngine$.MODULE$.run((LogicEngine.LogicWrapper)bsonLogicWrapper, logic));
    }

    private final /* synthetic */ Task runRule$$anonfun$1$$anonfun$3$$anonfun$2(Document a$2, BRule rule$4, boolean bool) {
        return this.applyResult(a$2, rule$4, bool).map((Function1 & Serializable)result -> result);
    }

    private static final Task applyResult$$anonfun$2(Document in$5) {
        return Task$.MODULE$.now((Object)in$5);
    }

    private static final Document runChain$$anonfun$2$$anonfun$1(Document in$8) {
        return in$8;
    }
}

