/*
 * Decompiled with CFR 0.152.
 */
package ambience.layout.etl;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.layout.Band;
import ambience.layout.Cell;
import ambience.layout.CellType;
import ambience.layout.CellType$;
import ambience.layout.CellUtil$;
import ambience.layout.HeaderItem;
import ambience.layout.Layout;
import ambience.layout.Length;
import ambience.layout.etl.RenderHTML$;
import ambience.layout.etl.TDous;
import ambience.layout.etl.TDous$Empty$;
import ambience.layout.etl.TDous$Hidden$;
import ambience.layout.etl.TDous$TopLeft$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.DecodingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.reactive.Observable;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public class RenderHTML
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RenderHTML.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Layout layout;
    private final StringBuilder htmlString;
    private final int totalWidth;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenderHTML$.class.getDeclaredField("log$lzy2"));

    public static String Suffix() {
        return RenderHTML$.MODULE$.Suffix();
    }

    public static Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context context, ETLStep eTLStep) {
        return RenderHTML$.MODULE$.build(context, eTLStep);
    }

    public static Task<Document> buildDocument(Builder.Context context, Document document) {
        return RenderHTML$.MODULE$.buildDocument(context, document);
    }

    public static Document buildDocument(Builder.Context context, Document document, Layout layout) {
        return RenderHTML$.MODULE$.buildDocument(context, document, layout);
    }

    public static BuildError error(ETLStep eTLStep, DecodingFailure decodingFailure) {
        return RenderHTML$.MODULE$.error(eTLStep, decodingFailure);
    }

    public static Task<Option<String>> explain(ETLStep eTLStep) {
        return RenderHTML$.MODULE$.explain(eTLStep);
    }

    public static String prefix(String string) {
        return RenderHTML$.MODULE$.prefix(string);
    }

    public static Observable<Document> run(Builder.Context context, Observable<Document> observable) {
        return RenderHTML$.MODULE$.run(context, observable);
    }

    public static String stepType() {
        return RenderHTML$.MODULE$.stepType();
    }

    public RenderHTML(Layout layout) {
        this.layout = layout;
        this.htmlString = new StringBuilder();
        this.htmlString().append(RenderHTML$.MODULE$.prefix(layout.direction()));
        this.totalWidth = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)layout.colLengths().map((Function1 & Serializable)_$1 -> _$1 == null ? BoxesRunTime.unboxToInt(null) : ((Length)_$1).value())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        layout.colHeader().items().foreach((Function1)(JProcedure1 & Serializable)hi -> this.addHeaderSizing((HeaderItem)hi));
        layout.bands().foreach((Function1)(JProcedure1 & Serializable)band -> this.renderBand(layout, (Band)band));
        this.htmlString().append(RenderHTML$.MODULE$.Suffix());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public StringBuilder htmlString() {
        return this.htmlString;
    }

    public int totalWidth() {
        return this.totalWidth;
    }

    public void addHeaderSizing(HeaderItem hi) {
        this.htmlString().append("<col width='" + 100.0 * (double)hi.length() / (double)this.totalWidth() + "%'/>\n");
    }

    public void renderBand(Layout layout, Band band) {
        TDous tdous = new TDous(layout.colLengths().size(), band.rowLengths().size());
        band.cells().foreach((Function1)(JProcedure1 & Serializable)cell -> {
            int xFrom = layout.colHeader().indexOf(cell.xFrom());
            int xTo = layout.colHeader().indexOf(cell.xTo());
            int yFrom = band.rowHeader().indexOf(cell.yFrom());
            int yTo = band.rowHeader().indexOf(cell.yTo());
            tdous.addCell(xFrom, yFrom, xTo - xFrom + 1, yTo - yFrom + 1, (Cell)cell);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), band.rowLengths().size()).foreach((Function1 & Serializable)rowIdx -> this.renderBand$$anonfun$2(band, tdous, BoxesRunTime.unboxToInt((Object)rowIdx)));
    }

    public String charCode(TDous.TDCell tdCell) {
        TDous.TDCell tDCell = tdCell;
        if (TDous$Empty$.MODULE$.equals(tDCell)) {
            return "E";
        }
        if (TDous$Hidden$.MODULE$.equals(tDCell)) {
            return "H";
        }
        if (tDCell instanceof TDous.TopLeft) {
            TDous.TopLeft c = (TDous.TopLeft)tDCell;
            return "C";
        }
        throw new MatchError((Object)tDCell);
    }

    private static final int $anonfun$2() {
        return 0;
    }

    private static final String $anonfun$4() {
        return "unknown";
    }

    private final /* synthetic */ StringBuilder renderBand$$anonfun$2(Band band$2, TDous tdous$2, int rowIdx) {
        double height = band$2.heightMultiplier() * (double)BoxesRunTime.unboxToInt((Object)((Option)band$2.rowLengths().lift().apply((Object)BoxesRunTime.boxToInteger((int)rowIdx))).map((Function1 & Serializable)_$2 -> _$2 == null ? BoxesRunTime.unboxToInt(null) : ((Length)_$2).value()).getOrElse(RenderHTML::$anonfun$2));
        this.htmlString().append("<tr>\n");
        List<TDous.TDCell> cells = tdous$2.getRow(rowIdx);
        cells.foreach((Function1 & Serializable)x$1 -> {
            TDous.TDCell tDCell = x$1;
            if (tDCell instanceof TDous.TopLeft) {
                StringBuilder stringBuilder;
                TDous.TopLeft topLeft = TDous$TopLeft$.MODULE$.unapply((TDous.TopLeft)tDCell);
                int n = topLeft._1();
                int n2 = topLeft._2();
                int n3 = topLeft._3();
                int n4 = topLeft._4();
                Cell cell = topLeft._5();
                int colSpan = n3;
                int rowSpan = n4;
                Cell cell2 = cell;
                String parentStyle = CellUtil$.MODULE$.getCellParentStyle(cell2) + " position: relative;";
                this.htmlString().append("<td style='" + parentStyle + "'");
                if (colSpan > 1) {
                    this.htmlString().append(" colspan='" + colSpan + "'");
                }
                if (rowSpan > 1) {
                    this.htmlString().append(" rowspan='" + rowSpan + "'");
                }
                this.htmlString().append(">");
                Option<String> cellType = CellUtil$.MODULE$.getCellType(cell2);
                String cellTypeString = (String)cellType.map((Function1 & Serializable)_$3 -> _$3 == null ? null : ((CellType)_$3).value()).getOrElse(RenderHTML::$anonfun$4);
                String style = CellUtil$.MODULE$.getCellStyle(cell2) + ("min-height: " + height + "px; position:relative; display:flex; left:0; top:0; right:0; bottom: 0;");
                this.htmlString().append("<div style='" + style + "' data-cell-type='" + cellTypeString + "' class='layout-" + cellTypeString.replace('.', '-') + "'>");
                Option<String> option = cellType;
                if (option instanceof Some) {
                    Object object = ((Some)option).value();
                    String string = CellType$.MODULE$.unapply(object == null ? null : ((CellType)object).value());
                    String string2 = CellType$.MODULE$._1$extension(string);
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case -1898969286: {
                            if (!"basic.field".equals(string2)) break;
                            this.htmlString().append("<div style='overflow:hidden' dir='auto'>");
                            this.htmlString().append("[" + CellUtil$.MODULE$.safeText(CellUtil$.MODULE$.getFieldName(cell2)) + "]");
                            stringBuilder = this.htmlString().append("</div>");
                            return this.htmlString().append("</div></td>\n");
                        }
                        case -1896083557: {
                            if (!"basic.image".equals(string2)) break;
                            String alt = CellUtil$.MODULE$.getImageAlt(cell2);
                            String altText = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(alt)) ? "alt='" + CellUtil$.MODULE$.safeAttr(alt) + "' " : "";
                            String img = "<img " + altText + " style='max-width: 100%;' src='" + CellUtil$.MODULE$.safeAttr(CellUtil$.MODULE$.getImageURL(cell2)) + "'/>";
                            stringBuilder = this.htmlString().append(img);
                            return this.htmlString().append("</div></td>\n");
                        }
                        case -1893669580: {
                            if (!"basic.label".equals(string2)) break;
                            this.htmlString().append("<div style='overflow:hidden' dir='auto'>");
                            this.htmlString().append(CellUtil$.MODULE$.safeText(CellUtil$.MODULE$.getLabelText(cell2)));
                            stringBuilder = this.htmlString().append("</div>");
                            return this.htmlString().append("</div></td>\n");
                        }
                        case -1169278308: {
                            if (!"basic.rich".equals(string2)) break;
                            this.htmlString().append("<div style='overflow:hidden' dir='auto'>");
                            this.htmlString().append(CellUtil$.MODULE$.safeHtml(CellUtil$.MODULE$.getRichText(cell2)));
                            stringBuilder = this.htmlString().append("</div>");
                            return this.htmlString().append("</div></td>\n");
                        }
                    }
                    if ("basic.blank".equals(string2)) {
                        stringBuilder = BoxedUnit.UNIT;
                        return this.htmlString().append("</div></td>\n");
                    }
                }
                Option<String> x = option;
                this.htmlString().append("<div style='overflow:hidden'>");
                this.htmlString().append(x);
                stringBuilder = this.htmlString().append("</div>");
                return this.htmlString().append("</div></td>\n");
            }
            if (TDous$Empty$.MODULE$.equals(tDCell)) {
                this.htmlString().append("<td>");
                this.htmlString().append("<div style='min-height: " + height + "px'>");
                return this.htmlString().append("</div></td>\n");
            }
            if (!TDous$Hidden$.MODULE$.equals(tDCell)) throw new MatchError((Object)tDCell);
            return BoxedUnit.UNIT;
        });
        return this.htmlString().append("</tr>\n");
    }
}

