/*
 * Decompiled with CFR 0.152.
 */
package ambience.layout.etl;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.layout.Band;
import ambience.layout.Cell;
import ambience.layout.CellType;
import ambience.layout.CellType$;
import ambience.layout.CellUtil$;
import ambience.layout.Layout;
import ambience.layout.Length;
import ambience.layout.etl.RenderXLSX$;
import ambience.layout.etl.RenderXLSX$StyleInfo$;
import ambience.layout.etl.RichTextToXlsx$;
import ambience.layout.etl.TDous;
import ambience.layout.etl.TDous$Empty$;
import ambience.layout.etl.TDous$Hidden$;
import ambience.layout.etl.TDous$TopLeft$;
import ambience.layout.xlsx.ImageLoader$;
import ambience.layout.xlsx.RenderUtil$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.DecodingFailure;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import monix.eval.Task;
import monix.reactive.Observable;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class RenderXLSX
implements LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(RenderXLSX.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RenderXLSX.class.getDeclaredField("drawing$lzy1"));
    private volatile Object log$lzy1;
    private final Builder.Context cxt;
    private final Layout layout;
    private final XSSFWorkbook wb;
    private final String sheetName;
    private final XSSFSheet sheet;
    private volatile Object drawing$lzy1;
    private final int totalWidth;
    private final double factor;
    private final HashMap cellStyles;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenderXLSX$.class.getDeclaredField("log$lzy2"));

    public static int OverallHeightMultiplier() {
        return RenderXLSX$.MODULE$.OverallHeightMultiplier();
    }

    public static double PageWidth() {
        return RenderXLSX$.MODULE$.PageWidth();
    }

    public static Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context context, ETLStep eTLStep) {
        return RenderXLSX$.MODULE$.build(context, eTLStep);
    }

    public static Task<Document> buildDocument(Builder.Context context, Document document) {
        return RenderXLSX$.MODULE$.buildDocument(context, document);
    }

    public static Task<Document> buildDocument(Builder.Context context, Document document, Layout layout) {
        return RenderXLSX$.MODULE$.buildDocument(context, document, layout);
    }

    public static BuildError error(ETLStep eTLStep, DecodingFailure decodingFailure) {
        return RenderXLSX$.MODULE$.error(eTLStep, decodingFailure);
    }

    public static Task<Option<String>> explain(ETLStep eTLStep) {
        return RenderXLSX$.MODULE$.explain(eTLStep);
    }

    public static String stepType() {
        return RenderXLSX$.MODULE$.stepType();
    }

    public RenderXLSX(Builder.Context cxt, Layout layout) {
        this.cxt = cxt;
        this.layout = layout;
        this.wb = new XSSFWorkbook();
        this.sheetName = "Sheet 1";
        this.sheet = this.wb().createSheet(this.sheetName());
        String string = layout.direction();
        String string2 = "rtl";
        this.sheet().setRightToLeft(!(string != null ? !string.equals(string2) : string2 != null));
        this.totalWidth = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)layout.colLengths().map((Function1 & Serializable)_$1 -> _$1 == null ? BoxesRunTime.unboxToInt(null) : ((Length)_$1).value())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.factor = RenderXLSX$.MODULE$.PageWidth() / (double)this.totalWidth();
        this.cellStyles = new HashMap();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public XSSFWorkbook wb() {
        return this.wb;
    }

    public String sheetName() {
        return this.sheetName;
    }

    public XSSFSheet sheet() {
        return this.sheet;
    }

    public XSSFDrawing drawing() {
        Object object = this.drawing$lzy1;
        if (object instanceof XSSFDrawing) {
            return (XSSFDrawing)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (XSSFDrawing)this.drawing$lzyINIT1();
    }

    private Object drawing$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.drawing$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    XSSFDrawing xSSFDrawing = null;
                    try {
                        xSSFDrawing = this.sheet().createDrawingPatriarch();
                        object2 = xSSFDrawing == null ? LazyVals.NullValue$.MODULE$ : xSSFDrawing;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.drawing$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return xSSFDrawing;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int totalWidth() {
        return this.totalWidth;
    }

    public double factor() {
        return this.factor;
    }

    public HashMap<StyleInfo, XSSFCellStyle> cellStyles() {
        return this.cellStyles;
    }

    public Task<byte[]> run() {
        return this.cxt.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Rendering " + this.layout.colLengths().size() + " columns by " + this.layout.bands().size() + " bands")).map((Function1 & Serializable)_$2 -> {
            ((Vector)this.layout.colLengths().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int w = tuple2._1() == null ? BoxesRunTime.unboxToInt(null) : ((Length)tuple2._1()).value();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    this.sheet().setColumnWidth(i, (int)((double)w * this.factor()));
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            this.layout.bands().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> this.run$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToInt((Object)x$1), (Band)x$2));
            this.log().info(this::run$$anonfun$1$$anonfun$3, Line$.MODULE$.apply(73), FullName$.MODULE$.apply("ambience.layout.etl.RenderXLSX.run"));
            return this.getBytes();
        });
    }

    public int renderBand(Layout layout, int offsetY, Band band) {
        TDous tdous = new TDous(layout.colLengths().size(), band.rowLengths().size());
        band.cells().foreach((Function1)(JProcedure1 & Serializable)cell -> {
            int xFrom = layout.colHeader().indexOf(cell.xFrom());
            int xTo = layout.colHeader().indexOf(cell.xTo());
            int yFrom = band.rowHeader().indexOf(cell.yFrom());
            int yTo = band.rowHeader().indexOf(cell.yTo());
            tdous.addCell(xFrom, yFrom, xTo - xFrom + 1, yTo - yFrom + 1, (Cell)cell);
        });
        ((Vector)band.rowLengths().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                int rowLen = tuple2._1() == null ? BoxesRunTime.unboxToInt(null) : ((Length)tuple2._1()).value();
                int bandRowIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                int rowIdx = offsetY + bandRowIdx;
                double height = band.heightMultiplier() * (double)rowLen;
                this.getRow(rowIdx).setHeight((short)(height * (double)RenderXLSX$.MODULE$.OverallHeightMultiplier()));
                List<TDous.TDCell> cells = tdous.getRow(bandRowIdx);
                cells.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    TDous.TDCell tDCell = x$1;
                    if (tDCell instanceof TDous.TopLeft) {
                        Option<String> cellType;
                        Option<String> option;
                        TDous.TopLeft topLeft = TDous$TopLeft$.MODULE$.unapply((TDous.TopLeft)tDCell);
                        int n = topLeft._1();
                        int n2 = topLeft._2();
                        int n3 = topLeft._3();
                        int n4 = topLeft._4();
                        Cell cell = topLeft._5();
                        int x = n;
                        int y = n2;
                        int colSpan = n3;
                        int rowSpan = n4;
                        Cell cell2 = cell;
                        XSSFRow row = this.getRow(rowIdx);
                        XSSFCell poiCell = row.createCell(x);
                        if (rowSpan > 1 || colSpan > 1) {
                            this.sheet().addMergedRegion(new CellRangeAddress(rowIdx, rowIdx + rowSpan - 1, x, x + colSpan - 1));
                        }
                        if ((option = (cellType = CellUtil$.MODULE$.getCellType(cell2))) instanceof Some) {
                            Object object = ((Some)option).value();
                            String string = CellType$.MODULE$.unapply(object == null ? null : ((CellType)object).value());
                            String string2 = CellType$.MODULE$._1$extension(string);
                            switch (string2 == null ? 0 : string2.hashCode()) {
                                case -1898969286: {
                                    if (!"basic.field".equals(string2)) break;
                                    poiCell.setCellValue("[" + CellUtil$.MODULE$.getFieldName(cell2) + "]");
                                    this.setCellStyle(poiCell, cell2);
                                    return;
                                }
                                case -1896083557: {
                                    if (!"basic.image".equals(string2)) break;
                                    ImageLoader$.MODULE$.loadImage(CellUtil$.MODULE$.getImageURL(cell2)).foreach((Function1)(JProcedure1 & Serializable)img -> this.renderImage((BufferedImage)img, x, offsetY + y, rowSpan, colSpan));
                                    return;
                                }
                                case -1893669580: {
                                    if (!"basic.label".equals(string2)) break;
                                    poiCell.setCellValue(CellUtil$.MODULE$.getLabelText(cell2));
                                    this.setCellStyle(poiCell, cell2);
                                    return;
                                }
                                case -1169278308: {
                                    if (!"basic.rich".equals(string2)) break;
                                    String richText = CellUtil$.MODULE$.getRichText(cell2);
                                    XSSFRichTextString richTextString = RichTextToXlsx$.MODULE$.fromHtml(this.wb(), richText);
                                    poiCell.setCellValue((RichTextString)richTextString);
                                    this.setCellStyle(poiCell, cell2);
                                    return;
                                }
                            }
                            if ("basic.blank".equals(string2)) {
                                return;
                            }
                        }
                        Option<String> x2 = option;
                        this.log().info(() -> RenderXLSX.renderBand$$anonfun$2$$anonfun$1$$anonfun$2(x2), Line$.MODULE$.apply(119), FullName$.MODULE$.apply("ambience.layout.etl.RenderXLSX.renderBand"));
                        return;
                    }
                    if (TDous$Empty$.MODULE$.equals(tDCell)) {
                        return;
                    }
                    if (TDous$Hidden$.MODULE$.equals(tDCell)) {
                        return;
                    }
                    throw new MatchError((Object)tDCell);
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return offsetY + band.rowLengths().size();
    }

    public void setCellStyle(XSSFCell poiCell, Cell cell) {
        JsonObject style = (JsonObject)CellUtil$.MODULE$.CellStyleLens().getOption((Object)cell.content().json()).getOrElse(RenderXLSX::$anonfun$1);
        String alignment = this.fixDirection((String)style.apply("justify-content").flatMap((Function1 & Serializable)_$3 -> _$3.asString()).getOrElse(RenderXLSX::$anonfun$3));
        String valignment = (String)style.apply("align-items").flatMap((Function1 & Serializable)_$4 -> _$4.asString()).getOrElse(RenderXLSX::$anonfun$5);
        String bgColor = (String)style.apply("background-color").flatMap((Function1 & Serializable)_$5 -> _$5.asString()).getOrElse(RenderXLSX::$anonfun$7);
        String fgColor = (String)style.apply("color").flatMap((Function1 & Serializable)_$6 -> _$6.asString()).getOrElse(RenderXLSX::$anonfun$9);
        StyleInfo styleInfo = RenderXLSX$StyleInfo$.MODULE$.apply(alignment, valignment, bgColor, fgColor);
        this.log().info(() -> this.setCellStyle$$anonfun$1(styleInfo), Line$.MODULE$.apply(135), FullName$.MODULE$.apply("ambience.layout.etl.RenderXLSX.setCellStyle"));
        XSSFCellStyle cellStyle = (XSSFCellStyle)this.cellStyles().getOrElseUpdate((Object)styleInfo, () -> this.$anonfun$10(styleInfo));
        poiCell.setCellStyle((CellStyle)cellStyle);
    }

    public String fixDirection(String alignment) {
        String string = this.layout.direction();
        String string2 = "rtl";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = alignment;
            if ("flex-start".equals(string3)) {
                return "flex-end";
            }
            if ("flex-end".equals(string3)) {
                return "flex-start";
            }
            String x = string3;
            return x;
        }
        return alignment;
    }

    public void renderImage(BufferedImage img, int left, int top, int width, int height) {
        this.log().info(() -> RenderXLSX.renderImage$$anonfun$1(left, top, width, height), Line$.MODULE$.apply(158), FullName$.MODULE$.apply("ambience.layout.etl.RenderXLSX.renderImage"));
        int colNo1 = left;
        int rowNo1 = top;
        int colNo2 = left + width;
        int rowNo2 = top + height;
        XSSFCreationHelper createHelper = this.wb().getCreationHelper();
        XSSFClientAnchor anchor = createHelper.createClientAnchor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "PNG", baos);
        int picIdx = this.wb().addPicture(baos.toByteArray(), 6);
        anchor.setDx1(0);
        anchor.setDy1(0);
        anchor.setDx2(0);
        anchor.setDy2(0);
        anchor.setCol1(colNo1);
        anchor.setRow1(rowNo1);
        anchor.setCol2(colNo2);
        anchor.setRow2(rowNo2);
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        XSSFPicture pic = this.drawing().createPicture(anchor, picIdx);
        pic.resize(1.0, 1.0);
    }

    public XSSFRow getRow(int rowIdx) {
        return (XSSFRow)Option$.MODULE$.apply((Object)this.sheet().getRow(rowIdx)).getOrElse(() -> this.getRow$$anonfun$1(rowIdx));
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.wb().write((OutputStream)baos);
        this.wb().close();
        return baos.toByteArray();
    }

    private final /* synthetic */ int run$$anonfun$1$$anonfun$2(int x$1, Band x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int offsetY = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Band band = (Band)tuple2._2();
            return this.renderBand(this.layout, offsetY, band);
        }
        throw new MatchError((Object)tuple2);
    }

    private final Object run$$anonfun$1$$anonfun$3() {
        return this.cellStyles().size() + " cell styles created";
    }

    private static final Object renderBand$$anonfun$2$$anonfun$1$$anonfun$2(Option x$2) {
        return "No handler for " + x$2;
    }

    private static final JsonObject $anonfun$1() {
        return JsonObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final String $anonfun$3() {
        return "flex-start";
    }

    private static final String $anonfun$5() {
        return "flex-start";
    }

    private static final String $anonfun$7() {
        return "#ffffff";
    }

    private static final String $anonfun$9() {
        return "#000000";
    }

    private final Object setCellStyle$$anonfun$1(StyleInfo styleInfo$1) {
        return styleInfo$1 + " " + this.cellStyles().contains((Object)styleInfo$1);
    }

    private final XSSFCellStyle $anonfun$10(StyleInfo styleInfo$2) {
        return RenderUtil$.MODULE$.buildStyle(this.wb(), styleInfo$2);
    }

    private static final Object renderImage$$anonfun$1(int left$1, int top$1, int width$1, int height$1) {
        return "renderImage " + left$1 + " " + top$1 + " " + width$1 + " " + height$1;
    }

    private final XSSFRow getRow$$anonfun$1(int rowIdx$2) {
        return this.sheet().createRow(rowIdx$2);
    }

    public static final class StyleInfo
    implements Product,
    Serializable {
        private final String alignment;
        private final String valignment;
        private final String bgColor;
        private final String fgColor;

        public static StyleInfo apply(String string, String string2, String string3, String string4) {
            return RenderXLSX$StyleInfo$.MODULE$.apply(string, string2, string3, string4);
        }

        public static StyleInfo fromProduct(Product product) {
            return RenderXLSX$StyleInfo$.MODULE$.fromProduct(product);
        }

        public static StyleInfo unapply(StyleInfo styleInfo) {
            return RenderXLSX$StyleInfo$.MODULE$.unapply(styleInfo);
        }

        public StyleInfo(String alignment, String valignment, String bgColor, String fgColor) {
            this.alignment = alignment;
            this.valignment = valignment;
            this.bgColor = bgColor;
            this.fgColor = fgColor;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StyleInfo)) return false;
            StyleInfo styleInfo = (StyleInfo)object;
            String string = this.alignment();
            String string2 = styleInfo.alignment();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.valignment();
            String string4 = styleInfo.valignment();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.bgColor();
            String string6 = styleInfo.bgColor();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.fgColor();
            String string8 = styleInfo.fgColor();
            if (string7 == null) {
                if (string8 == null) return true;
                return false;
            } else {
                if (!string7.equals(string8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StyleInfo;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "StyleInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "alignment";
                }
                case 1: {
                    return "valignment";
                }
                case 2: {
                    return "bgColor";
                }
                case 3: {
                    return "fgColor";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String alignment() {
            return this.alignment;
        }

        public String valignment() {
            return this.valignment;
        }

        public String bgColor() {
            return this.bgColor;
        }

        public String fgColor() {
            return this.fgColor;
        }

        public StyleInfo copy(String alignment, String valignment, String bgColor, String fgColor) {
            return new StyleInfo(alignment, valignment, bgColor, fgColor);
        }

        public String copy$default$1() {
            return this.alignment();
        }

        public String copy$default$2() {
            return this.valignment();
        }

        public String copy$default$3() {
            return this.bgColor();
        }

        public String copy$default$4() {
            return this.fgColor();
        }

        public String _1() {
            return this.alignment();
        }

        public String _2() {
            return this.valignment();
        }

        public String _3() {
            return this.bgColor();
        }

        public String _4() {
            return this.fgColor();
        }
    }
}

