/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v3.stub;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Main {
    private static final String ELIXIR_HOME = "ELIXIR_HOME";
    private static final String ELX_STUB_DEBUG = "elx.stub.debug";
    private static final String ELX_STUB_EXIT_WATCHER = "elx.stub.exit.watcher";
    private static HashSet<String> excludes = new HashSet();

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2 = Main.getElxHome();
        String string3 = System.getProperty("user.home");
        if (stringArray.length == 0) {
            System.err.println("Usage: Main <main-class> ...");
            System.exit(-1);
        }
        if ((string = System.getProperty("elx.stub.out")) != null) {
            try {
                PrintStream printStream = new PrintStream(new FileOutputStream(string));
                System.setOut(printStream);
                System.setErr(printStream);
            }
            catch (IOException iOException) {
                System.err.println("Can't redirect output: " + iOException);
            }
        }
        boolean bl = System.getProperty(ELX_STUB_DEBUG) != null;
        boolean bl2 = System.getProperty(ELX_STUB_EXIT_WATCHER) != null;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        File file = new File(System.getProperty("user.dir")).getCanonicalFile();
        File file2 = new File(file, "etc");
        if (file2.exists() && file2.isDirectory()) {
            try {
                arrayList.add(file2.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Malformed url for: " + file2.getAbsolutePath());
            }
        }
        Main.buildJars(new File(file, "ext"), arrayList);
        Main.buildJars(new File(file, "lib"), arrayList);
        URL[] uRLArray = arrayList.toArray(new URL[0]);
        if (bl) {
            System.out.println("Classpath");
            for (URL uRL : uRLArray) {
                System.out.println(uRL.getPath());
            }
        }
        if (bl) {
            Runtime.getRuntime().addShutdownHook(new StubShutdownHook());
        }
        if (bl2) {
            try {
                System.setSecurityManager(new StubExitSecurityManager());
            }
            catch (Throwable throwable) {
                System.out.println("Unable to set StubExitSecurityManager: " + throwable);
            }
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(uRLClassLoader);
        try {
            Class<?> exception = Class.forName(stringArray[0], true, uRLClassLoader);
            Method method = exception.getMethod("main", String[].class);
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray[i + 1].replace("${elx.home}", string2);
                stringArray2[i] = stringArray2[i].replace("${user.home}", string3);
            }
            method.invoke(null, new Object[]{stringArray2});
            if (bl) {
                System.out.println("Main completed, program terminating");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.out.print("-- Diagnostics --");
            System.out.println("Args: ");
            for (String string4 : stringArray) {
                System.out.print("\"" + string4 + "\" ");
            }
            System.out.println();
            System.out.println("Classpath");
            for (URL uRL : uRLArray) {
                System.out.println(uRL.getPath());
            }
            System.exit(-4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-3);
        }
    }

    private static void buildJars(File file, List<URL> list) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isFile() || !file2.getName().endsWith(".jar") || excludes.contains(file2.getName())) continue;
                try {
                    list.add(file2.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Malformed url for: " + file2.getAbsolutePath());
                }
            }
        }
    }

    private static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.contains("win");
    }

    private static String getElxHome() {
        String string = System.getProperty("elixir.home");
        if (string != null) {
            return string.replace("\\", "/");
        }
        if (Main.isWindows()) {
            String string2 = System.getenv(ELIXIR_HOME);
            return string2 == null ? "" : string2;
        }
        return "";
    }

    public static class StubExitSecurityManager
    extends SecurityManager {
        @Override
        public void checkPermission(Permission permission) {
        }

        @Override
        public void checkPermission(Permission permission, Object object) {
        }

        @Override
        public void checkExit(int n) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            System.out.println("System.exit requested by:");
            int n2 = Math.min(10, stackTraceElementArray.length);
            for (int i = 0; i < n2; ++i) {
                System.out.println(stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber());
            }
            super.checkExit(n);
        }
    }

    public static class StubShutdownHook
    extends Thread {
        public StubShutdownHook() {
            super("StubShutdownHook");
        }

        @Override
        public void run() {
            System.out.println("ShutdownHook invoked...");
        }
    }
}

