/*
 * Decompiled with CFR 0.152.
 */
package ambience.ud.store;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$;
import ambience.arch.EitherTELM;
import ambience.arch.EitherTELM$;
import ambience.format.HumanReadableBytes$;
import ambience.module.UserDB;
import ambience.ud.UDManager;
import ambience.ud.UploadModule;
import ambience.ud.store.BinUploadAPI;
import ambience.ud.store.BinUploadAPI$Access$;
import ambience.ud.store.BinUploadAPI$FileUpload$;
import ambience.ud.store.Store;
import ambience.ud.store.Store$FileInfo$;
import ambience.ud.store.StoreUtil$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.syntax.package;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class BinStore
implements Store,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BinStore.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String locationId;

    public BinStore(String locationId) {
        this.locationId = locationId;
    }

    @Override
    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<Either<LogMessage, Json>> write(UserDB.User user, UDManager manager, UploadModule.UploadInfo info) {
        Json metadata = this.toMetadata(info);
        EitherTELM task = EitherTELM$.MODULE$.apply(this.logInfo((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$1(user, metadata)))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherTELM$.MODULE$.apply(((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(this.locationId).map((Function1 & Serializable)_$1 -> _$1.toRight(this::$anonfun$2$$anonfun$1$$anonfun$1))).flatMap((Function1 & Serializable)location -> EitherTELM$.MODULE$.apply(this.doWrite((BinaryStore.Location)location, metadata, (DataBytes)info.bytes())).flatMap((Function1 & Serializable)uuid -> EitherTELM$.MODULE$.apply(this.logInfo((Function0<String>)((Function0 & Serializable)() -> BinStore.$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(location, uuid)))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return uuid;
            })));
        });
        return task.value().flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                String uuid = (String)((Right)either).value();
                BinUploadAPI.FileUpload fileUpload = (BinUploadAPI.FileUpload)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this.toFileUpload(info, this.locationId, uuid));
                return manager.save(user, package.EncoderOps$.MODULE$.asJson$extension((Object)fileUpload, BinUploadAPI$FileUpload$.MODULE$.encode()));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return Task$.MODULE$.apply(() -> BinStore.write$$anonfun$1$$anonfun$1(msg));
            }
            throw new MatchError((Object)either);
        }).onErrorRecover((PartialFunction)new Serializable(this){
            private final /* synthetic */ BinStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    return true;
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    return package$.MODULE$.Left().apply((Object)this.$outer.buildMaxsizeError(ex));
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Binary Store upload " + ex.getMessage(), ex));
                }
                return function1.apply((Object)x);
            }
        });
    }

    public LogMessage buildMaxsizeError(BinaryStore.MaxSizeException ex) {
        Object[] split = ex.getMessage().split(" ");
        Object object = Predef$.MODULE$.refArrayOps(split);
        String maxSize = this.toReadable$1(ArrayOps$.MODULE$.lastOption$extension(object));
        Object object2 = Predef$.MODULE$.refArrayOps(split);
        String actual = this.toReadable$1(ArrayOps$.MODULE$.headOption$extension(object2));
        return LogMessage.Error$.MODULE$.apply("<p>Binary Store upload limit " + maxSize + " exceeded. Actual (" + actual + ")</p>");
    }

    public Task<Either<LogMessage, BoxedUnit>> logInfo(Function0<String> msg) {
        this.log().info(msg, Line$.MODULE$.apply(50), FullName$.MODULE$.apply("ambience.ud.store.BinStore.logInfo"));
        return Task$.MODULE$.right((Object)BoxedUnit.UNIT);
    }

    private Task<Either<LogMessage, String>> doWrite(BinaryStore.Location location, Json metadata, DataBytes dataBytes) {
        return location.add(BinaryStore.Content$.MODULE$.apply(dataBytes, metadata)).map((Function1 & Serializable)cid -> BinStore.doWrite$$anonfun$1(cid == null ? null : ((BinaryStore.ContentId)cid).value())).onErrorRecover((PartialFunction)new Serializable(location, this){
            private final BinaryStore.Location location$3;
            private final /* synthetic */ BinStore $outer;
            {
                this.location$3 = location$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> this.applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.ud.store.BinStore.doWrite"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Error writing to store " + ex.getMessage(), ex));
            }

            private final Object applyOrElse$$anonfun$1(Throwable ex$1) {
                return "Save bytes failed " + this.location$3.id() + ": " + ex$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private Json toMetadata(UploadModule.UploadInfo info) {
        Object[] objectArray = new Tuple2[6];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(info.name()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"description");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(info.description()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"category");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(info.category()));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(info.filename()));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.fromLong(info.length()));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentType");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json$.MODULE$.fromString((String)info.optContentType().getOrElse(BinStore::toMetadata$$anonfun$1)));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    @Override
    public Task<DataBytes> read(UserDB.User user, Json json) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return BinaryStore$.MODULE$.get(bId).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                    return content.bytes();
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().warn(() -> BinStore.read$$anonfun$1$$anonfun$1(bId), Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.ud.store.BinStore.read"));
                    return DataBytes$.MODULE$.empty();
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(BinStore::read$$anonfun$2, Line$.MODULE$.apply(80), FullName$.MODULE$.apply("ambience.ud.store.BinStore.read"));
            return Task$.MODULE$.now((Object)DataBytes$.MODULE$.empty());
        }
        throw new MatchError(option);
    }

    @Override
    public Task<BoxedUnit> readToOutputStream(Json json, OutputStream os) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return BinaryStore$.MODULE$.get(bId).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                    return content.bytes().observable().map((Function1)(JProcedure1 & Serializable)bytes -> os.write((byte[])bytes)).completedL();
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().warn(() -> BinStore.readToOutputStream$$anonfun$1$$anonfun$2(bId), Line$.MODULE$.apply(94), FullName$.MODULE$.apply("ambience.ud.store.BinStore.readToOutputStream"));
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }).void();
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(BinStore::readToOutputStream$$anonfun$2, Line$.MODULE$.apply(98), FullName$.MODULE$.apply("ambience.ud.store.BinStore.readToOutputStream"));
            return Task$.MODULE$.unit();
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Store.FileInfo> getFileInfo(Json json) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return StoreUtil$.MODULE$.getFileName(json).flatMap((Function1 & Serializable)name -> StoreUtil$.MODULE$.getContentType(json).map((Function1 & Serializable)contentType -> Store$FileInfo$.MODULE$.apply((String)name, (String)contentType, StoreUtil$.MODULE$.getDigest(bId.locationId() + "|" + bId.contentId()))));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<BinaryStore.Id> getBinaryStoreId(Json json) {
        return this.getStore(json).flatMap((Function1 & Serializable)store -> this.getContentId(json).map((Function1 & Serializable)contentId -> BinaryStore.Id$.MODULE$.apply(BinaryStore.LocationId$.MODULE$.apply(store), BinaryStore.ContentId$.MODULE$.apply(contentId))));
    }

    private BinUploadAPI.FileUpload toFileUpload(UploadModule.UploadInfo info, String locationId, String contentId) {
        return BinUploadAPI$FileUpload$.MODULE$.apply(info.name(), info.description(), info.category(), (String)info.optContentType().getOrElse(BinStore::toFileUpload$$anonfun$1), BinUploadAPI$Access$.MODULE$.apply(info.roles()), locationId, contentId, (int)info.length());
    }

    private Option<String> getStore(Json json) {
        return json.hcursor().downField("store").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    private Option<String> getContentId(Json json) {
        return json.hcursor().downField("contentId").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    public String humanReadableBytesSpan(long bytes) {
        String tip = HumanReadableBytes$.MODULE$.tip(bytes);
        return "<span class=\"hr-bytes\" title=\"" + tip + "\">" + HumanReadableBytes$.MODULE$.apply(bytes) + "</span>";
    }

    private final String $anonfun$1(UserDB.User user$1, Json metadata$1) {
        return "Storing Upload user=" + user$1.name() + " store=" + this.locationId + " metadata=" + metadata$1;
    }

    private final LogMessage.Error $anonfun$2$$anonfun$1$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("Can't load location " + new BinaryStore.LocationId(this.locationId));
    }

    private static final String $anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(BinaryStore.Location location$2, String uuid$1) {
        return "New Upload Added store=" + location$2.id() + " uuid=" + uuid$1;
    }

    private static final Left write$$anonfun$1$$anonfun$1(LogMessage msg$1) {
        return package$.MODULE$.Left().apply((Object)msg$1);
    }

    private static final String toReadable$1$$anonfun$2() {
        return "";
    }

    private static final long toReadable$1$$anonfun$3() {
        return 0L;
    }

    private final String toReadable$1(Option strOpt) {
        return this.humanReadableBytesSpan(BoxesRunTime.unboxToLong((Object)StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString((String)strOpt.map((Function1 & Serializable)_$2 -> _$2.trim()).getOrElse(BinStore::toReadable$1$$anonfun$2))).getOrElse(BinStore::toReadable$1$$anonfun$3)));
    }

    private static final /* synthetic */ Right doWrite$$anonfun$1(String cid) {
        return package$.MODULE$.Right().apply((Object)cid);
    }

    private static final String toMetadata$$anonfun$1() {
        return "application/octet-stream";
    }

    private static final Object read$$anonfun$1$$anonfun$1(BinaryStore.Id bId$2) {
        return "No content found in binary store=" + bId$2.locationId() + " for contentId " + bId$2.contentId();
    }

    private static final Object read$$anonfun$2() {
        return "BinaryStoreId not found";
    }

    private static final Object readToOutputStream$$anonfun$1$$anonfun$2(BinaryStore.Id bId$4) {
        return "No content found in binary store=" + bId$4.locationId() + " for contentId " + bId$4.contentId();
    }

    private static final Object readToOutputStream$$anonfun$2() {
        return "BinaryStoreId not found";
    }

    private static final String toFileUpload$$anonfun$1() {
        return "application/octet-stream";
    }
}

