/*
 * Decompiled with CFR 0.152.
 */
package ambience.ud.store;

import ambience.chunk.ChunkAPI;
import ambience.chunk.ChunkDB;
import ambience.module.UserDB;
import ambience.ud.UDManager;
import ambience.ud.UploadModule;
import ambience.ud.store.Store;
import ambience.ud.store.Store$FileInfo$;
import ambience.ud.store.StoreUtil$;
import ambience.ud.store.UDUploadAPI;
import ambience.ud.store.UDUploadAPI$Access$;
import ambience.ud.store.UDUploadAPI$FileUpload$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.OutputStream;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UDStore
implements Store,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UDStore.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final ChunkDB chunkDB;

    public UDStore(ChunkDB chunkDB) {
        this.chunkDB = chunkDB;
    }

    @Override
    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<Either<LogMessage, Json>> write(UserDB.User user, UDManager manager, UploadModule.UploadInfo info) {
        return this.chunkDB.write(info.bytes().observable()).flatMap((Function1 & Serializable)chunks -> {
            UDUploadAPI.FileUpload fileUpload = (UDUploadAPI.FileUpload)package$.MODULE$.EncoderOps((Object)this.toFileUpload(info, (List<String>)chunks));
            return manager.save(user, package.EncoderOps$.MODULE$.asJson$extension((Object)fileUpload, UDUploadAPI$FileUpload$.MODULE$.encode())).map((Function1 & Serializable)res -> res);
        });
    }

    @Override
    public Task<DataBytes> read(UserDB.User user, Json json) {
        Option<List<String>> option = this.getChunkIds(json);
        if (option instanceof Some) {
            List ids = (List)((Some)option).value();
            return Task$.MODULE$.apply(() -> this.read$$anonfun$1(ids));
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(UDStore::read$$anonfun$2, Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.ud.store.UDStore.read"));
            return Task$.MODULE$.now((Object)DataBytes$.MODULE$.empty());
        }
        throw new MatchError(option);
    }

    @Override
    public Task<BoxedUnit> readToOutputStream(Json json, OutputStream os) {
        Option<List<String>> option = this.getChunkIds(json);
        if (option instanceof Some) {
            List ids = (List)((Some)option).value();
            return this.chunkDB.readToOutputStream(ids, os);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(UDStore::readToOutputStream$$anonfun$1, Line$.MODULE$.apply(37), FullName$.MODULE$.apply("ambience.ud.store.UDStore.readToOutputStream"));
            return Task$.MODULE$.unit();
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Store.FileInfo> getFileInfo(Json json) {
        Option<List<String>> option = this.getChunkIds(json);
        if (option instanceof Some) {
            List ids = (List)((Some)option).value();
            return StoreUtil$.MODULE$.getFileName(json).flatMap((Function1 & Serializable)name -> StoreUtil$.MODULE$.getContentType(json).map((Function1 & Serializable)contentType -> Store$FileInfo$.MODULE$.apply((String)name, (String)contentType, StoreUtil$.MODULE$.getDigest(ids.map((Function1 & Serializable)_$1 -> _$1 == null ? null : ((ChunkAPI.ChunkId)_$1).value()).mkString("|")))));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private UDUploadAPI.FileUpload toFileUpload(UploadModule.UploadInfo info, List<String> chunkIds) {
        return UDUploadAPI$FileUpload$.MODULE$.apply(info.name(), info.description(), info.category(), (String)info.optContentType().getOrElse(UDStore::toFileUpload$$anonfun$1), UDUploadAPI$Access$.MODULE$.apply(info.roles()), (List<String>)chunkIds.map((Function1 & Serializable)_$2 -> _$2 == null ? null : ((ChunkAPI.ChunkId)_$2).value()), (int)info.length());
    }

    private Option<List<String>> getChunkIds(Json json) {
        return json.hcursor().downField("chunkIds").values().map((Function1 & Serializable)_$3 -> (Iterable)_$3.flatMap((Function1 & Serializable)_$4 -> _$4.asString())).map((Function1 & Serializable)_$5 -> ((IterableOnceOps)_$5.map((Function1 & Serializable)_$6 -> new ChunkAPI.ChunkId(ChunkAPI.ChunkId$.MODULE$.apply(_$6)))).toList());
    }

    private final DataBytes read$$anonfun$1(List ids$1) {
        return DataBytes$.MODULE$.apply(this.chunkDB.read(ids$1).map((Function1 & Serializable)ch -> ch.bytes()));
    }

    private static final Object read$$anonfun$2() {
        return "ChunkIds not found";
    }

    private static final Object readToOutputStream$$anonfun$1() {
        return "ChunkIds not found";
    }

    private static final String toFileUpload$$anonfun$1() {
        return "application/octet-stream";
    }
}

