/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.pivot;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.JsonToString$;
import com.elixirtech.pivot.ConstraintTreeNode;
import com.elixirtech.pivot.CubeTable;
import com.elixirtech.pivot.CubeTable$Cell$;
import com.elixirtech.pivot.CubeTable$Spans$;
import com.elixirtech.pivot.Measure;
import com.elixirtech.pivot.Util$;
import com.elixirtech.vdom.mutable.VElement;
import com.elixirtech.vdom.mutable.VElement$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class CubeTableStructure
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CubeTableStructure.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final CubeTable ct;
    private final Map<String, String> substitutionMap;
    private final int hMeasureSize;
    private final int vMeasureSize;
    private final int hMeasureCount;
    private final int vMeasureCount;
    private final List rowNodes;
    private final List colNodes;
    private final int colTreeDepth;
    private final int dataTop;
    private final int rowTreeDepth;
    private final int dataLeft;
    private final int width;
    private final int height;
    private final IndexedSeq trs;

    public CubeTableStructure(CubeTable ct, Map<String, String> substitutionMap) {
        this.ct = ct;
        this.substitutionMap = substitutionMap;
        if (ct.options().expandTree()) {
            ct.colTree().expandAll(ct.colTree().root());
            ct.rowTree().expandAll(ct.rowTree().root());
        }
        if (ct.options().collapseSingleLeafTotals()) {
            ct.rowTree().root().visit((Function1<ConstraintTreeNode, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> _$1.hideTotalsForSingleLeaves());
            ct.colTree().root().visit((Function1<ConstraintTreeNode, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.hideTotalsForSingleLeaves());
        }
        this.hMeasureSize = !ct.options().measuresVertical() && ct.options().showMeasureLabels() ? 1 : 0;
        this.vMeasureSize = ct.options().measuresVertical() && ct.options().showMeasureLabels() ? 1 : 0;
        this.hMeasureCount = !ct.options().measuresVertical() ? ct.measures().length() : 1;
        this.vMeasureCount = ct.options().measuresVertical() ? ct.measures().length() : 1;
        this.rowNodes = ct.rowTree().root().flatten(ct.options().rows().showRowTotalsBefore());
        this.colNodes = ct.colTree().root().flatten(ct.options().columns().showColumnTotalsBefore());
        this.colTreeDepth = ct.colTree().root().getDescendantDepth();
        this.dataTop = this.colTreeDepth() + (ct.options().columns().showColumnRoot() ? 1 : 0) + this.hMeasureSize();
        this.rowTreeDepth = ct.rowTree().root().getDescendantDepth();
        this.dataLeft = this.rowTreeDepth() + (ct.options().rows().showRowRoot() ? 1 : 0) + this.vMeasureSize();
        this.width = this.dataLeft() + this.colNodes().length() * this.hMeasureCount();
        this.height = this.dataTop() + this.rowNodes().length() * this.vMeasureCount();
        this.trs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).map((Function1 & Serializable)i -> VElement$.MODULE$.apply("tr"));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hMeasureSize() {
        return this.hMeasureSize;
    }

    public int vMeasureSize() {
        return this.vMeasureSize;
    }

    public int hMeasureCount() {
        return this.hMeasureCount;
    }

    public int vMeasureCount() {
        return this.vMeasureCount;
    }

    public List<ConstraintTreeNode> rowNodes() {
        return this.rowNodes;
    }

    public List<ConstraintTreeNode> colNodes() {
        return this.colNodes;
    }

    public int colTreeDepth() {
        return this.colTreeDepth;
    }

    public int dataTop() {
        return this.dataTop;
    }

    public int rowTreeDepth() {
        return this.rowTreeDepth;
    }

    public int dataLeft() {
        return this.dataLeft;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public IndexedSeq<VElement> trs() {
        return this.trs;
    }

    public VElement buildTable() {
        VElement table = VElement$.MODULE$.apply("table");
        table.addClass(this.ct.options().cubeStyle());
        this.trs().foreach((Function1 & Serializable)_$3 -> _$3.appendTo(table));
        this.buildTopLeft();
        this.buildColumnHeaders();
        this.buildHMeasures();
        this.buildRowHeaders();
        this.buildVMeasures();
        List<CubeTable.Cell> cells = this.buildDataCells();
        this.ct.fillData(cells);
        return table;
    }

    public void buildTopLeft() {
        IntRef rowSpan = IntRef.create((int)this.dataTop());
        if (this.ct.options().rows().showRowLabels()) {
            int n;
            rowSpan.elem = n = rowSpan.elem - 1;
        }
        CubeTable.Spans spans = CubeTable$Spans$.MODULE$.apply(rowSpan.elem, this.dataLeft());
        VElement$.MODULE$.apply("th").addClass("elx-cube-tl").attr("rowspan", BoxesRunTime.boxToInteger((int)spans.rowSpan()).toString()).attr("colspan", BoxesRunTime.boxToInteger((int)spans.colSpan()).toString()).appendTo((VElement)this.trs().apply(0));
        if (this.ct.options().rows().showRowLabels()) {
            int depth = this.ct.rowTree().root().getDescendantDepth();
            Nil$ nil$ = !this.ct.options().rows().showRowRoot() ? package$.MODULE$.Nil() : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}));
            List names = this.ct.rows().map((Function1 & Serializable)d -> d.name()).slice(0, depth).$colon$colon$colon((List)nil$);
            names.map((Function1 & Serializable)name -> {
                String alias = (String)this.ct.options().rows().rowAliasMap().getOrElse(name, () -> CubeTableStructure.$anonfun$2(name));
                String n = Util$.MODULE$.substitute(alias, this.substitutionMap);
                VElement th = VElement$.MODULE$.apply("th").addClass("elx-cube-row-label").addClass("elx-cube-ch").addClass(this.ct.options().cellStyle()).attr("dir", "auto");
                VElement$.MODULE$.apply("span").text(n).appendTo(th);
                return th.appendTo((VElement)this.trs().apply(rowSpan$1.elem));
            });
            if (this.ct.options().measuresVertical() && this.ct.options().showMeasureLabels()) {
                VElement th = VElement$.MODULE$.apply("th").addClass("elx-cube-row-label").addClass("elx-cube-ch").addClass(this.ct.options().cellStyle()).attr("dir", "auto");
                VElement$.MODULE$.apply("span").appendTo(th);
                th.appendTo((VElement)this.trs().apply(rowSpan.elem));
            }
        }
    }

    public VElement buildTH(ConstraintTreeNode tn, String cls, CubeTable.Spans spans) {
        VElement th = VElement$.MODULE$.apply("th").attr("dir", "auto").attr("rowspan", BoxesRunTime.boxToInteger((int)spans.rowSpan()).toString()).attr("colspan", BoxesRunTime.boxToInteger((int)spans.colSpan()).toString()).addClass(cls);
        String label = Util$.MODULE$.substitute(this.asString(tn.constraint().value(), "-"), this.substitutionMap);
        VElement$.MODULE$.apply("span").text(label).appendTo(th);
        if (tn.children().nonEmpty()) {
            VElement vElement = tn.isExpanded() ? VElement$.MODULE$.apply("div").addClass("runtime-collapser-button is-expanded") : VElement$.MODULE$.apply("div").addClass("runtime-collapser-button").appendTo(th);
        }
        return th;
    }

    public void buildColumnHeaders() {
        this.layer$1(this.ct.colTree().root(), 0);
    }

    public void buildHMeasures() {
        if (this.hMeasureSize() == 1) {
            int measureRow = this.dataTop() - 1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.ct.colTree().root().getSpan()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)_$4 -> this.ct.measures().foreach((Function1 & Serializable)measure -> {
                String label = Util$.MODULE$.substitute(measure.label(), this.substitutionMap);
                ((VElement)this.trs().apply(measureRow)).addClass("elx-cube-mr");
                VElement th = VElement$.MODULE$.apply("th").addClass("elx-cube-measure-label").addClass("elx-cube-ch").addClass(this.ct.options().cellStyle()).attr("dir", "auto");
                VElement$.MODULE$.apply("span").text(label).appendTo(th);
                return th.appendTo((VElement)this.trs().apply(measureRow));
            }));
            return;
        }
    }

    public void buildVMeasures() {
        if (this.vMeasureSize() == 1) {
            ((IterableOnceOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.ct.rowTree().root().getSpan()).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    int idx = tuple2._2$mcI$sp();
                    ((List)this.ct.measures().zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Measure measure = (Measure)tuple2._1();
                            int mIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            String label = Util$.MODULE$.substitute(measure.label(), this.substitutionMap);
                            VElement th = VElement$.MODULE$.apply("th").addClass("elx-cube-measure-label").addClass("elx-cube-ch").addClass("ct.options.cellStyle").attr("dir", "auto");
                            VElement$.MODULE$.apply("span").text(label).appendTo(th);
                            return th.appendTo((VElement)this.trs().apply(this.dataTop() + idx * this.vMeasureCount() + mIdx));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    public void buildRowHeaders() {
        this.layer$2(this.ct.rowTree().root(), 0, this.dataTop());
    }

    public void setPaddingLeft(int offset, VElement el) {
        if (this.ct.options().rows().indentUnderRowTotals()) {
            int pad = offset * 4;
            el.css("padding-inline-start", pad + "px");
            return;
        }
    }

    public List<CubeTable.Cell> buildDataCells() {
        if (this.ct.options().measuresVertical()) {
            return this.buildVDataCells();
        }
        return this.buildHDataCells();
    }

    public List<CubeTable.Cell> buildHDataCells() {
        return ((List)this.rowNodes().zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ConstraintTreeNode rowNode = (ConstraintTreeNode)tuple2._1();
                int y = BoxesRunTime.unboxToInt((Object)tuple2._2());
                VElement tr = (VElement)this.trs().apply(this.dataTop() + y);
                tr.addClass("elx-cube-dr");
                return this.colNodes().flatMap((Function1 & Serializable)colNode -> this.ct.measures().map((Function1 & Serializable)measure -> {
                    VElement td = VElement$.MODULE$.apply("td").addClass("cell").appendTo(tr);
                    return CubeTable$Cell$.MODULE$.apply(rowNode, (ConstraintTreeNode)colNode, (Measure)measure, td);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public List<CubeTable.Cell> buildVDataCells() {
        return ((List)this.rowNodes().zipWithIndex()).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                ConstraintTreeNode rowNode = (ConstraintTreeNode)tuple2._1();
                int y = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return ((List)this.ct.measures().zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Measure measure = (Measure)tuple2._1();
                        int ym = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        VElement tr = (VElement)this.trs().apply(this.dataTop() + y * this.vMeasureCount() + ym);
                        tr.addClass("elx-cube-dr");
                        return this.colNodes().map((Function1 & Serializable)colNode -> {
                            VElement td = VElement$.MODULE$.apply("td").addClass("cell").appendTo(tr);
                            return CubeTable$Cell$.MODULE$.apply(rowNode, (ConstraintTreeNode)colNode, measure, td);
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String asString(Json v, String string) {
        Json json = v;
        Json json2 = Json$.MODULE$.Null();
        if (!(json != null ? !json.equals(json2) : json2 != null)) {
            return string;
        }
        return (String)JsonToString$.MODULE$.apply(v).getOrElse(CubeTableStructure::asString$$anonfun$1);
    }

    private static final String $anonfun$2(String name$1) {
        return name$1;
    }

    private final String $anonfun$3(ConstraintTreeNode tn$2) {
        return this.asString(tn$2.constraint().value(), "Total");
    }

    private final void addTotal$1(int rIdx$1, IntRef rowspan$1, ConstraintTreeNode tn$1, String cls$1) {
        int n;
        int n2;
        rowspan$1.elem = n2 = this.dataTop() - rIdx$1 - this.hMeasureSize();
        rowspan$1.elem = n = Util$.MODULE$.safeSpan(rowspan$1.elem);
        CubeTable.Spans spans = CubeTable$Spans$.MODULE$.apply(rowspan$1.elem, this.hMeasureCount());
        VElement tr = (VElement)this.trs().apply(rIdx$1);
        String total = (String)this.ct.options().columns().columnTotalLabel().getOrElse(() -> this.$anonfun$3(tn$1));
        VElement$.MODULE$.apply("th").attr("dir", "auto").attr("rowspan", BoxesRunTime.boxToInteger((int)spans.rowSpan()).toString()).attr("colspan", BoxesRunTime.boxToInteger((int)spans.colSpan()).toString()).addClass(cls$1).text(Util$.MODULE$.substitute(total, this.substitutionMap)).appendTo(tr);
    }

    private final void layer$1(ConstraintTreeNode tn, int idx) {
        int rIdx;
        IntRef rowspan = IntRef.create((int)1);
        String cls = "elx-cube-ch " + this.ct.options().cellStyle();
        if (!tn.isRoot() || this.ct.options().columns().showColumnRoot()) {
            int n;
            if (!tn.isExpanded()) {
                int n2;
                rowspan.elem = n2 = this.dataTop() - idx - this.hMeasureSize();
            }
            rowspan.elem = n = Util$.MODULE$.safeSpan(rowspan.elem);
            CubeTable.Spans spans = CubeTable$Spans$.MODULE$.apply(rowspan.elem, tn.getSpan() * this.hMeasureCount());
            VElement th = this.buildTH(tn, cls, spans).appendTo((VElement)this.trs().apply(idx));
            if (tn.isRoot()) {
                th.text(Util$.MODULE$.substitute(this.ct.options().columns().columnRootLabel(), this.substitutionMap));
                v0 = ((VElement)this.trs().apply(idx)).addClass("elx-cube-title-r");
            } else {
                v0 = ((VElement)this.trs().apply(idx)).addClass("elx-cube-hr");
            }
        }
        int n = rIdx = !tn.isRoot() || this.ct.options().columns().showColumnRoot() ? idx + 1 : idx;
        if (tn.isExpanded()) {
            if (tn.showTotals() && this.ct.options().columns().showColumnTotalsBefore()) {
                this.addTotal$1(rIdx, rowspan, tn, cls);
            }
            tn.children().foreach((Function1)(JProcedure1 & Serializable)c -> this.layer$1((ConstraintTreeNode)c, rIdx));
            if (tn.showTotals() && !this.ct.options().columns().showColumnTotalsBefore()) {
                this.addTotal$1(rIdx, rowspan, tn, cls);
            }
            return;
        }
    }

    private final String $anonfun$4(ConstraintTreeNode tn$4) {
        return this.asString(tn$4.constraint().value(), "Total");
    }

    private final void addTotal$2(IntRef y$1, ConstraintTreeNode tn$3, String cls$2, int initialX$1) {
        int n;
        VElement tr = ((VElement)this.trs().apply(y$1.elem)).addClass("elx-cube-rt");
        String total = (String)this.ct.options().rows().rowTotalLabel().getOrElse(() -> this.$anonfun$4(tn$3));
        VElement th = VElement$.MODULE$.apply("th").attr("dir", "auto").attr("colspan", BoxesRunTime.boxToInteger((int)tn$3.getDescendantDepth()).toString()).attr("rowspan", BoxesRunTime.boxToInteger((int)this.vMeasureCount()).toString()).addClass(cls$2).text(Util$.MODULE$.substitute(total, this.substitutionMap)).appendTo(tr);
        this.setPaddingLeft(initialX$1, th);
        y$1.elem = n = y$1.elem + this.vMeasureCount();
    }

    private final void layer$2(ConstraintTreeNode tn, int initialX, int initialY) {
        IntRef y = IntRef.create((int)initialY);
        int colspan = 1;
        String cls = "elx-cube-rh " + this.ct.options().cellStyle();
        if (!tn.isRoot() || this.ct.options().rows().showRowRoot()) {
            if (!tn.isExpanded()) {
                colspan = this.rowTreeDepth() - initialX + 1;
            }
            VElement th = this.buildTH(tn, cls, CubeTable$Spans$.MODULE$.apply(tn.getSpan() * this.vMeasureCount(), colspan)).appendTo((VElement)this.trs().apply(y.elem));
            this.setPaddingLeft(initialX, th);
            if (tn.isRoot()) {
                th.text(Util$.MODULE$.substitute(this.ct.options().rows().rowRootLabel(), this.substitutionMap));
            }
        }
        if (tn.isExpanded()) {
            if (tn.showTotals() && this.ct.options().rows().showRowTotalsBefore()) {
                this.addTotal$2(y, tn, cls, initialX);
            }
            tn.children().foreach((Function1)(JProcedure1 & Serializable)c -> {
                int n;
                this.layer$2((ConstraintTreeNode)c, initialX + 1, y$2.elem);
                y$2.elem = n = y$2.elem + c.getSpan() * this.vMeasureCount();
            });
            if (tn.showTotals() && !this.ct.options().rows().showRowTotalsBefore()) {
                this.addTotal$2(y, tn, cls, initialX);
            }
            return;
        }
    }

    private static final String asString$$anonfun$1() {
        return "";
    }
}

