/*
 * Decompiled with CFR 0.152.
 */
package ambience.simplesso.identity;

import ambience.codex.DocumentManager$;
import ambience.simplesso.IdentityModel;
import ambience.simplesso.identity.IdentityDB$;
import ambience.simplesso.identity.IdentityDB$PasswordError$;
import ambience.simplesso.identity.SSOLoginHandler;
import ambience.simplesso.identity.UserId;
import ambience.simplesso.identity.UserId$;
import ambience.simplesso.identity.UserPassword;
import ambience.simplesso.identity.UserPassword$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.identity.UserManagement$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class IdentityDB
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(IdentityDB.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Scheduler exeCxt;
    private final FiniteDuration DefaultTimeout;
    private final boolean CreateInitialIdentity;
    private final Task usersT;

    public static Document insertableUserDoc(UserPassword userPassword) {
        return IdentityDB$.MODULE$.insertableUserDoc(userPassword);
    }

    public static IdentityModel.User toUser(Document document) {
        return IdentityDB$.MODULE$.toUser(document);
    }

    public static UserPassword toUserPassword(Document document) {
        return IdentityDB$.MODULE$.toUserPassword(document);
    }

    public IdentityDB(SSOLoginHandler identityModule, String userCollectionName) {
        this.exeCxt = identityModule.exeCxt();
        this.DefaultTimeout = FiniteDuration$.MODULE$.apply(30L, package$.MODULE$.SECONDS());
        this.CreateInitialIdentity = false;
        this.usersT = ((CodexDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(CodexDB.class))).getCodexCollection(userCollectionName);
        this.init().runToFuture(Scheduler$.MODULE$.global());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    public FiniteDuration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    public boolean CreateInitialIdentity() {
        return this.CreateInitialIdentity;
    }

    public Task<CodexCollection> usersT() {
        return this.usersT;
    }

    private Task<BoxedUnit> init() {
        return this.usersT().flatMap((Function1 & Serializable)users -> DocumentManager$.MODULE$.setupUniqueColumn(users, "name").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return users.countDocumentsT().flatMap((Function1 & Serializable)count -> this.init$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)count)));
        }));
    }

    private Task<BoxedUnit> createInitialIdentity(long count) {
        if (count == 0L && this.CreateInitialIdentity()) {
            BsonObjectId oid = new BsonObjectId();
            String newpass = UserManagement$.MODULE$.buildRandomPassword();
            String encrypted = UserManagement$.MODULE$.encrypt("admin", newpass);
            UserPassword u = UserPassword$.MODULE$.apply(oid, "admin", true, encrypted, UserPassword$.MODULE$.$lessinit$greater$default$5(), UserPassword$.MODULE$.$lessinit$greater$default$6(), UserPassword$.MODULE$.$lessinit$greater$default$7(), UserPassword$.MODULE$.$lessinit$greater$default$8(), UserPassword$.MODULE$.$lessinit$greater$default$9());
            return this.insert(u).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                LogMessage logMessage = x$1;
                if (LogMessage.None$.MODULE$.equals(logMessage)) {
                    this.log().info(IdentityDB::createInitialIdentity$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(93), FullName$.MODULE$.apply("ambience.simplesso.identity.IdentityDB.createInitialIdentity"));
                    this.log().info(() -> IdentityDB.createInitialIdentity$$anonfun$1$$anonfun$2(newpass), Line$.MODULE$.apply(94), FullName$.MODULE$.apply("ambience.simplesso.identity.IdentityDB.createInitialIdentity"));
                    this.log().info(IdentityDB::createInitialIdentity$$anonfun$1$$anonfun$3, Line$.MODULE$.apply(95), FullName$.MODULE$.apply("ambience.simplesso.identity.IdentityDB.createInitialIdentity"));
                    return;
                }
                LogMessage msg = logMessage;
                this.log().info(() -> IdentityDB.createInitialIdentity$$anonfun$1$$anonfun$4(msg), Line$.MODULE$.apply(97), FullName$.MODULE$.apply("ambience.simplesso.identity.IdentityDB.createInitialIdentity"));
            }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> this.log().error(() -> IdentityDB.createInitialIdentity$$anonfun$2$$anonfun$1(ex), Line$.MODULE$.apply(100), FullName$.MODULE$.apply("ambience.simplesso.identity.IdentityDB.createInitialIdentity")));
        }
        return Task$.MODULE$.unit();
    }

    public Task<LogMessage> insert(UserPassword u) {
        return this.usersT().flatMap((Function1 & Serializable)_$12 -> _$12.insertOneT(IdentityDB$.MODULE$.insertableUserDoc(u)).map((Function1 & Serializable)_$13 -> LogMessage.None$.MODULE$).onErrorHandle((Function1 & Serializable)ex -> {
            String msg = ex.getMessage();
            this.log().warn(() -> IdentityDB.insert$$anonfun$1$$anonfun$2$$anonfun$1(u, msg), Line$.MODULE$.apply(110), FullName$.MODULE$.apply("ambience.simplesso.identity.IdentityDB.insert"));
            if (msg.contains("E11000")) {
                return LogMessage.Error$.MODULE$.apply("Duplicate User Id");
            }
            return LogMessage.Error$.MODULE$.apply("Unable to add user");
        }));
    }

    public Task<Option<IdentityModel.User>> getByName(String name) {
        return this.usersT().flatMap((Function1 & Serializable)_$14 -> _$14.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name))).firstOptionL().map((Function1 & Serializable)_$15 -> _$15.map((Function1 & Serializable)doc -> IdentityDB$.MODULE$.toUser((Document)doc))));
    }

    public Task<Option<IdentityModel.User>> getById(BsonObjectId oid) {
        return this.usersT().flatMap((Function1 & Serializable)_$16 -> _$16.findO(this.whereId(oid)).firstOptionL().map((Function1 & Serializable)_$17 -> _$17.map((Function1 & Serializable)doc -> IdentityDB$.MODULE$.toUser((Document)doc))));
    }

    public void bumpFailedLogins(BsonObjectId oid) {
        this.usersT().flatMap((Function1 & Serializable)_$18 -> _$18.updateOneT(this.whereId(oid), (CodexUpdate)CodexUpdate.Inc$.MODULE$.apply("failedLogins", 1))).runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public void successfulLogin(BsonObjectId oid) {
        CodexUpdate.Combine updates = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("failedLogins", (BsonValue)new BsonInt32(0)), CodexUpdate.CurrentTimestamp$.MODULE$.apply("lastLogin")}));
        this.usersT().flatMap((Function1 & Serializable)_$19 -> _$19.updateOneT(this.whereId(oid), (CodexUpdate)updates)).runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public void resetFailedLogins(BsonObjectId oid) {
        this.usersT().flatMap((Function1 & Serializable)_$20 -> _$20.updateOneT(this.whereId(oid), (CodexUpdate)CodexUpdate.Set$.MODULE$.apply("failedLogins", (BsonValue)new BsonInt32(0)))).runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public Task<Either<PasswordError, UserPassword>> getUserPassword(BsonObjectId oid) {
        return this.usersT().flatMap((Function1 & Serializable)_$21 -> _$21.findO(this.whereId(oid)).firstOptionL().map((Function1 & Serializable)_$22 -> _$22.map((Function1 & Serializable)doc -> IdentityDB$.MODULE$.toUserPassword((Document)doc)))).map((Function1 & Serializable)_$23 -> _$23.toRight(IdentityDB::getUserPassword$$anonfun$2$$anonfun$1));
    }

    public Task<Either<PasswordError, UserPassword>> getUserPassword(String name) {
        return this.usersT().flatMap((Function1 & Serializable)_$24 -> _$24.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name))).firstOptionL().map((Function1 & Serializable)_$25 -> _$25.map((Function1 & Serializable)doc -> IdentityDB$.MODULE$.toUserPassword((Document)doc)))).map((Function1 & Serializable)_$26 -> _$26.toRight(IdentityDB::getUserPassword$$anonfun$4$$anonfun$1));
    }

    public Task<Set<String>> names() {
        return this.usersT().flatMap((Function1 & Serializable)_$27 -> _$27.findO(CodexFindOptions$.MODULE$.projections((CodexFindOptions.Projection)CodexFindOptions.Retain$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})))).toListL().map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)doc -> doc.apply("name", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue()).toSet()));
    }

    public Task<Map<UserId, String>> idMap() {
        return this.usersT().flatMap((Function1 & Serializable)_$28 -> _$28.findO(CodexFindOptions$.MODULE$.projections((CodexFindOptions.Projection)CodexFindOptions.Retain$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name"})))).toListL().map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)doc -> {
            UserId userId = (UserId)Predef$.MODULE$.ArrowAssoc((Object)UserId$.MODULE$.apply(doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asObjectId()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)userId, (Object)doc.apply("name", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public Task<List<IdentityModel.User>> all() {
        return this.usersT().flatMap((Function1 & Serializable)_$29 -> _$29.findO().map((Function1 & Serializable)doc -> IdentityDB$.MODULE$.toUser((Document)doc)).toListL());
    }

    public Task<LogMessage> delete(BsonObjectId oid) {
        return this.usersT().flatMap((Function1 & Serializable)_$30 -> _$30.deleteOneT(this.whereId(oid)).map((Function1 & Serializable)reply -> {
            if (reply.getDeletedCount() == 1L) {
                return LogMessage.None$.MODULE$;
            }
            return LogMessage.Error$.MODULE$.apply("Unable to delete user " + oid.getValue().toHexString());
        }).onErrorHandle((Function1 & Serializable)ex -> LogMessage.ErrorEx$.MODULE$.apply("Error in user delete: " + ex, ex)));
    }

    public CodexFilter whereId(BsonObjectId oid) {
        return CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)oid);
    }

    private final /* synthetic */ Task init$$anonfun$1$$anonfun$1$$anonfun$1(long count) {
        return this.createInitialIdentity(count).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private static final Object createInitialIdentity$$anonfun$1$$anonfun$1() {
        return "No users available, so one has been created";
    }

    private static final Object createInitialIdentity$$anonfun$1$$anonfun$2(String newpass$2) {
        return "Log in as admin with password " + newpass$2;
    }

    private static final Object createInitialIdentity$$anonfun$1$$anonfun$3() {
        return "You can then change the password and add more users";
    }

    private static final Object createInitialIdentity$$anonfun$1$$anonfun$4(LogMessage msg$1) {
        return "No users available: " + msg$1;
    }

    private static final Object createInitialIdentity$$anonfun$2$$anonfun$1(Throwable ex$1) {
        return "Unable to add an admin user: " + ex$1;
    }

    private static final Object insert$$anonfun$1$$anonfun$2$$anonfun$1(UserPassword u$3, String msg$2) {
        return "add(" + u$3 + ") " + msg$2;
    }

    private static final PasswordError getUserPassword$$anonfun$2$$anonfun$1() {
        return IdentityDB$PasswordError$.NoSuchUser;
    }

    private static final PasswordError getUserPassword$$anonfun$4$$anonfun$1() {
        return IdentityDB$PasswordError$.NoSuchUser;
    }

    public static abstract class PasswordError
    implements Product,
    Enum {
        public static PasswordError fromOrdinal(int n) {
            return IdentityDB$PasswordError$.MODULE$.fromOrdinal(n);
        }

        public static PasswordError valueOf(String string) {
            return IdentityDB$PasswordError$.MODULE$.valueOf(string);
        }

        public static PasswordError[] values() {
            return IdentityDB$PasswordError$.MODULE$.values();
        }
    }
}

