/*
 * Decompiled with CFR 0.152.
 */
package ambience.simplesso.server;

import ambience.api.Identity;
import ambience.simplesso.SimpleSSOModule;
import ambience.simplesso.server.EmailTemplates$;
import ambience.simplesso.server.ResetHandler$;
import ambience.simplesso.server.ResetHandler$Reply$;
import ambience.simplesso.server.SSOServerState;
import ambience.simplesso.server.ServerHandler;
import ambience.simplesso.server.ServerModel;
import ambience.simplesso.server.ServerModel$Code$;
import ambience.simplesso.server.ServerModel$CookieRnd$;
import ambience.simplesso.server.ServerModel$Email$;
import ambience.simplesso.server.ServerModel$ResetConfirmation$;
import ambience.simplesso.server.ServerModel$UserId$;
import ambience.simplesso.server.ServerModel$When$;
import ambience.simplesso.server.WebMessage$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.mail.MailAPI;
import com.elixirtech.mail.MailSender;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ResetHandler
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ResetHandler.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final SSOServerState serverState;
    private final ServerHandler serverHandler;
    private final Scheduler scheduler;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ResetHandler$.class.getDeclaredField("ResetLinkExpiryMs$lzy1"));

    public static <T> Either<Reply, T> CannotResetReply(int n, String string) {
        return ResetHandler$.MODULE$.CannotResetReply(n, string);
    }

    public static <T> Either<Reply, T> CookieMismatch(int n, String string) {
        return ResetHandler$.MODULE$.CookieMismatch(n, string);
    }

    public static long ResetLinkExpiryMs() {
        return ResetHandler$.MODULE$.ResetLinkExpiryMs();
    }

    public ResetHandler(SimpleSSOModule module, SSOServerState serverState, ServerHandler serverHandler) {
        this.serverState = serverState;
        this.serverHandler = serverHandler;
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Task<GravityResponse> handle(ServerModel.ResetRequest r) {
        ServerModel.CookieRnd key = ServerModel$CookieRnd$.MODULE$.apply(r.cookie(), r.rnd());
        EitherT ret = EitherT$.MODULE$.apply(this.getIdentityAPI(r)).flatMap((Function1 & Serializable)identity -> EitherT$.MODULE$.apply(this.validateCodeRequest(r.language(), key)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(this.deleteCodeRequest(key)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherT$.MODULE$.apply(this.buildResetConfirmation((Identity)identity, r)).flatMap((Function1 & Serializable)rc -> EitherT$.MODULE$.apply(this.storeResetConfirmation((ServerModel.ResetConfirmation)rc)).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(this.sendEmail(r.language(), (ServerModel.ResetConfirmation)rc)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, (Functor)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)ret.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                this.addResetToLogs(r, (Option<String>)None$.MODULE$);
                return WebMessage$.MODULE$.getResponse(2, r.language(), "PasswordResetRequestAccepted");
            }
            if (either instanceof Left) {
                Reply reply = (Reply)((Left)either).value();
                this.addResetToLogs(r, (Option<String>)Some$.MODULE$.apply((Object)reply.value()));
                return reply.response();
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<Reply, Identity>> getIdentityAPI(ServerModel.ResetRequest r) {
        return Task$.MODULE$.apply(() -> this.getIdentityAPI$$anonfun$1(r));
    }

    public Task<Either<Reply, BoxedUnit>> validateCodeRequest(String language, ServerModel.CookieRnd key) {
        return this.serverState.getCodeRequest(key).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            if (None$.MODULE$.equals(option)) {
                return ResetHandler$.MODULE$.CookieMismatch(2, language);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<Reply, BoxedUnit>> deleteCodeRequest(ServerModel.CookieRnd key) {
        return this.serverState.deleteCodeRequest(key).map((Function1 & Serializable)_$1 -> package$.MODULE$.Right().apply(_$1));
    }

    public Task<Either<Reply, ServerModel.ResetConfirmation>> buildResetConfirmation(Identity identity, ServerModel.ResetRequest request) {
        return identity.lookupUserInfo(Identity.Username$.MODULE$.apply(request.username())).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Identity.UserInfo userInfo = (Identity.UserInfo)((Some)option).value();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(userInfo.email().trim()))) {
                    long when = ServerModel$When$.MODULE$.apply(System.currentTimeMillis());
                    String code = ServerModel$Code$.MODULE$.apply(UUID.randomUUID().toString());
                    return package$.MODULE$.Right().apply((Object)ServerModel$ResetConfirmation$.MODULE$.apply(when, code, request.username(), ServerModel$UserId$.MODULE$.apply(userInfo.id()), ServerModel$Email$.MODULE$.apply(userInfo.email())));
                }
                this.log().info(() -> ResetHandler.buildResetConfirmation$$anonfun$1$$anonfun$1(request), Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.buildResetConfirmation"));
                return ResetHandler$.MODULE$.CannotResetReply(2, request.language());
            }
            if (None$.MODULE$.equals(option)) {
                this.log().info(() -> ResetHandler.buildResetConfirmation$$anonfun$1$$anonfun$2(request), Line$.MODULE$.apply(94), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.buildResetConfirmation"));
                return ResetHandler$.MODULE$.CannotResetReply(2, request.language());
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<Reply, BoxedUnit>> storeResetConfirmation(ServerModel.ResetConfirmation rc) {
        return this.serverState.setResetConfirmation(rc.code(), rc).map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply(_$2));
    }

    public Task<GravityResponse> confirm(String language, String rcId) {
        return this.serverState.getResetConfirmation(ServerModel$Code$.MODULE$.apply(rcId)).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ServerModel.ResetConfirmation rc = (ServerModel.ResetConfirmation)((Some)option).value();
                if (rc.when() + ResetHandler$.MODULE$.ResetLinkExpiryMs() > System.currentTimeMillis()) {
                    this.log().info(() -> ResetHandler.confirm$$anonfun$1$$anonfun$1(rc), Line$.MODULE$.apply(107), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.confirm"));
                    return this.serverState.deleteResetConfirmation(rc.code()).flatMap((Function1 & Serializable)_$3 -> {
                        Identity identity = (Identity)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Identity.class));
                        return identity.resetPassword(Identity.UserId$.MODULE$.apply(rc.userId())).map((Function1 & Serializable)x$1 -> {
                            Option option = x$1;
                            if (option instanceof Some) {
                                Object object = ((Some)option).value();
                                String error = object == null ? null : ((Identity.ErrorMessage)object).value();
                                this.log().info(() -> ResetHandler.confirm$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(rc, error), Line$.MODULE$.apply(112), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.confirm"));
                                return WebMessage$.MODULE$.getResponse(3, language, "RequestDenied");
                            }
                            if (None$.MODULE$.equals(option)) {
                                return WebMessage$.MODULE$.getResponse(3, language, "PasswordResetEmail");
                            }
                            throw new MatchError((Object)option);
                        });
                    });
                }
                this.log().info(() -> ResetHandler.confirm$$anonfun$1$$anonfun$3(rc), Line$.MODULE$.apply(120), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.confirm"));
                return this.serverState.deleteResetConfirmation(rc.code()).map((Function1 & Serializable)_$4 -> WebMessage$.MODULE$.getResponse(3, language, "RequestDenied"));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().info(() -> ResetHandler.confirm$$anonfun$1$$anonfun$5(rcId), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.confirm"));
                return Task$.MODULE$.now((Object)WebMessage$.MODULE$.getResponse(3, language, "InvalidConfirmationCode"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<Reply, BoxedUnit>> sendEmail(String language, ServerModel.ResetConfirmation rc) {
        return Task$.MODULE$.apply(() -> this.sendEmail$$anonfun$1(rc, language));
    }

    private void addResetToLogs(ServerModel.ResetRequest r, Option<String> error) {
        AuditAPI.Action result = error.isEmpty() ? AuditAPI.Success$.MODULE$.apply("sso", "Reset", (Option)None$.MODULE$, AuditAPI.Success$.MODULE$.apply$default$4()) : AuditAPI.Failure$.MODULE$.apply("sso", "Reset", error, AuditAPI.Failure$.MODULE$.apply$default$4());
        this.serverHandler.audit(r.username(), result);
    }

    private static final Identity getIdentityAPI$$anonfun$1$$anonfun$1() {
        return (Identity)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Identity.class));
    }

    private static final Object getIdentityAPI$$anonfun$1$$anonfun$2(Throwable err$1) {
        return "Cannot access IdentityAPI: " + err$1;
    }

    private final Either getIdentityAPI$$anonfun$1(ServerModel.ResetRequest r$7) {
        Try try_ = Try$.MODULE$.apply(ResetHandler::getIdentityAPI$$anonfun$1$$anonfun$1);
        if (try_ instanceof Success) {
            Identity identity = (Identity)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)identity);
        }
        if (try_ instanceof Failure) {
            Throwable err = ((Failure)try_).exception();
            this.log().debug(() -> ResetHandler.getIdentityAPI$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.getIdentityAPI"));
            return ResetHandler$.MODULE$.CannotResetReply(2, r$7.language());
        }
        throw new MatchError((Object)try_);
    }

    private static final Object buildResetConfirmation$$anonfun$1$$anonfun$1(ServerModel.ResetRequest request$2) {
        return "User " + request$2.username() + " has no email";
    }

    private static final Object buildResetConfirmation$$anonfun$1$$anonfun$2(ServerModel.ResetRequest request$3) {
        return "User not found: " + request$3.username();
    }

    private static final Object confirm$$anonfun$1$$anonfun$1(ServerModel.ResetConfirmation rc$2) {
        return "Got valid reset confirmation for " + rc$2;
    }

    private static final Object confirm$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ServerModel.ResetConfirmation rc$5, String error$1) {
        return "Reset request for " + rc$5 + " denied: " + new Identity.ErrorMessage(error$1);
    }

    private static final Object confirm$$anonfun$1$$anonfun$3(ServerModel.ResetConfirmation rc$6) {
        return "Reset confirmation expired for " + rc$6;
    }

    private static final Object confirm$$anonfun$1$$anonfun$5(String rcId$2) {
        return "Invalid confirmation code " + rcId$2;
    }

    private final Either sendEmail$$anonfun$1(ServerModel.ResetConfirmation rc$7, String language$6) {
        Config config = (Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class));
        String linkTemplate = config.getString("elixir.simple-identity.client-reset-page");
        String ClientIdentityResetPage = linkTemplate.replace("<code>", rc$7.code());
        String ClientIdentityTitle = config.getString("elixir.simple-identity.client-title");
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"clientTitle");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ClientIdentityTitle);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)rc$7.username());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"resetPage");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)ClientIdentityResetPage);
        Map lookup = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        String subject = EmailTemplates$.MODULE$.ChangePasswordTemplate().subjectTemplate().substitute(lookup.lift());
        String body = EmailTemplates$.MODULE$.ChangePasswordTemplate().bodyTemplate().substitute(lookup.lift());
        List list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{rc$7.email()}));
        List list2 = MailAPI.Mail$.MODULE$.$lessinit$greater$default$2();
        List list3 = MailAPI.Mail$.MODULE$.$lessinit$greater$default$3();
        List list4 = MailAPI.Mail$.MODULE$.$lessinit$greater$default$6();
        MailAPI.Mail mail = MailAPI.Mail$.MODULE$.apply(list, list2, list3, subject, body, list4);
        LogMessage logMessage = ((MailSender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MailSender.class))).send(mail);
        if (LogMessage.None$.MODULE$.equals(logMessage)) {
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        LogMessage msg = logMessage;
        this.log().apply(msg, Line$.MODULE$.apply(151), FullName$.MODULE$.apply("ambience.simplesso.server.ResetHandler.sendEmail"));
        return ResetHandler$.MODULE$.CannotResetReply(2, language$6);
    }

    public static final class Reply
    implements Product,
    Serializable {
        private final String value;
        private final GravityResponse response;

        public static Reply apply(String string, GravityResponse gravityResponse) {
            return ResetHandler$Reply$.MODULE$.apply(string, gravityResponse);
        }

        public static Reply fromProduct(Product product) {
            return ResetHandler$Reply$.MODULE$.fromProduct(product);
        }

        public static Reply unapply(Reply reply) {
            return ResetHandler$Reply$.MODULE$.unapply(reply);
        }

        public Reply(String value, GravityResponse response) {
            this.value = value;
            this.response = response;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Reply)) return false;
            Reply reply = (Reply)object;
            String string = this.value();
            String string2 = reply.value();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            GravityResponse gravityResponse = this.response();
            GravityResponse gravityResponse2 = reply.response();
            if (gravityResponse == null) {
                if (gravityResponse2 == null) return true;
                return false;
            } else {
                if (!gravityResponse.equals(gravityResponse2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Reply;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Reply";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "response";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        public GravityResponse response() {
            return this.response;
        }

        public Reply copy(String value, GravityResponse response) {
            return new Reply(value, response);
        }

        public String copy$default$1() {
            return this.value();
        }

        public GravityResponse copy$default$2() {
            return this.response();
        }

        public String _1() {
            return this.value();
        }

        public GravityResponse _2() {
            return this.response();
        }
    }
}

