/*
 * Decompiled with CFR 0.152.
 */
package ambience.simplesso.server;

import ambience.gravity.GravityHelper$;
import ambience.module.GetFromDirectoryImpl;
import ambience.module.ProjectConfig;
import ambience.simplesso.oidc.OIDC$;
import ambience.simplesso.server.Check2FA$;
import ambience.simplesso.server.ResetHandler;
import ambience.simplesso.server.SSOStandardRoute$;
import ambience.simplesso.server.ServerHandler;
import ambience.simplesso.server.ServerModel;
import ambience.simplesso.server.ServerModel$AccessToken$;
import ambience.simplesso.server.ServerModel$ClientId$;
import ambience.simplesso.server.ServerModel$ClientInfo$;
import ambience.simplesso.server.ServerModel$ClientSecret$;
import ambience.simplesso.server.ServerModel$Code$;
import ambience.simplesso.server.ServerModel$CodeRequest$;
import ambience.simplesso.server.ServerModel$Cookie$;
import ambience.simplesso.server.ServerModel$GrantType$;
import ambience.simplesso.server.ServerModel$LoginRequest$;
import ambience.simplesso.server.ServerModel$LogoutRequest$;
import ambience.simplesso.server.ServerModel$OIDCTokenRequest$;
import ambience.simplesso.server.ServerModel$Password$;
import ambience.simplesso.server.ServerModel$RedirectUri$;
import ambience.simplesso.server.ServerModel$ResetRequest$;
import ambience.simplesso.server.ServerModel$ResourceOwnerPasswordRequest$;
import ambience.simplesso.server.ServerModel$ResponseType$;
import ambience.simplesso.server.ServerModel$ReturnUri$;
import ambience.simplesso.server.ServerModel$Rnd$;
import ambience.simplesso.server.ServerModel$Scope$;
import ambience.simplesso.server.ServerModel$State$;
import ambience.simplesso.server.ServerModel$Token$;
import ambience.simplesso.server.ServerModel$TokenRequest$;
import ambience.simplesso.server.ServerModel$Totp$;
import ambience.simplesso.server.ServerModel$UserInfoRequest$;
import ambience.simplesso.server.ServerModel$Username$;
import ambience.simplesso.server.ServerModel$When$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityCookie;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.webserver.I18N$;
import java.io.File;
import java.io.Serializable;
import java.util.Base64;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class SSOStandardRoute {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SSOStandardRoute.class.getDeclaredField("getFromDirectory$lzy1"));
    private ProjectConfig projectConfig;
    private final String cookieName;
    private final ServerHandler serverHandler;
    private final ResetHandler resetHandler;
    private volatile Object getFromDirectory$lzy1;
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(SSOStandardRoute$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(SSOStandardRoute$.class.getDeclaredField("ForceLowerCaseUsernames$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SSOStandardRoute$.class.getDeclaredField("Allow2FACheck$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SSOStandardRoute$.class.getDeclaredField("ResourceOwnerPasswordEnabled$lzy1"));

    public static boolean Allow2FACheck() {
        return SSOStandardRoute$.MODULE$.Allow2FACheck();
    }

    public static boolean ForceLowerCaseUsernames() {
        return SSOStandardRoute$.MODULE$.ForceLowerCaseUsernames();
    }

    public static boolean ResourceOwnerPasswordEnabled() {
        return SSOStandardRoute$.MODULE$.ResourceOwnerPasswordEnabled();
    }

    public static String coerceCase(String string) {
        return SSOStandardRoute$.MODULE$.coerceCase(string);
    }

    public static LoggingInterface log() {
        return SSOStandardRoute$.MODULE$.log();
    }

    public static Scheduler scheduler() {
        return SSOStandardRoute$.MODULE$.scheduler();
    }

    public SSOStandardRoute(ProjectConfig projectConfig, String cookieName, ServerHandler serverHandler, ResetHandler resetHandler) {
        this.projectConfig = projectConfig;
        this.cookieName = cookieName;
        this.serverHandler = serverHandler;
        this.resetHandler = resetHandler;
    }

    public GetFromDirectoryImpl getFromDirectory() {
        Object object = this.getFromDirectory$lzy1;
        if (object instanceof GetFromDirectoryImpl) {
            return (GetFromDirectoryImpl)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (GetFromDirectoryImpl)this.getFromDirectory$lzyINIT1();
    }

    private Object getFromDirectory$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.getFromDirectory$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    GetFromDirectoryImpl getFromDirectoryImpl = null;
                    try {
                        getFromDirectoryImpl = new GetFromDirectoryImpl(new File(this.projectConfig.WebRootDir(), "simple-sso"));
                        object2 = getFromDirectoryImpl == null ? LazyVals.NullValue$.MODULE$ : getFromDirectoryImpl;
                        this.projectConfig = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.getFromDirectory$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return getFromDirectoryImpl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> apply() {
        return GravitySystem$.MODULE$.fromRoutes((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.GET(), "auth", this.authHandler()), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "token", this.tokenHandler()), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "idtoken", this.idTokenHandler()), GravityRoute$.MODULE$.path("jwks", this.jwksHandler()), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "resource", this.resourceHandler()), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "login", this.loginHandler()), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "check-2fa", (Function1 & Serializable)request -> Check2FA$.MODULE$.apply(this.serverHandler, (GravityRequest)request)), GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "reset-password", this.resetPasswordHandler()), GravityRoute$.MODULE$.path("reset-confirmation/*", this.resetConfirmationHandler()), GravityRoute$.MODULE$.path("userinfo", (Function1 & Serializable)request -> this.userInfoHandler((GravityRequest)request)), GravityRoute$.MODULE$.path("logout", (Function1 & Serializable)request -> this.logoutHandler((GravityRequest)request)), GravityRoute$.MODULE$.all((Function1)this.getFromDirectory())})), GravitySystem$.MODULE$.fromRoutes$default$2());
    }

    public Function1<GravityRequest, Task<GravityResponse>> authHandler() {
        return GravityHelper$.MODULE$.parameters("client_id", "response_type", "redirect_uri", "state", (Function4 & Serializable)(clientId, responseType, redirectUri, state) -> (Function1 & Serializable)request -> {
            Option optScope = request.parameters().get("scope");
            Option optCookie = request.cookies().get((Object)this.cookieName);
            long now = System.currentTimeMillis();
            String cookieValue = (String)optCookie.flatMap((Function1 & Serializable)c -> SSOStandardRoute$.MODULE$.ambience$simplesso$server$SSOStandardRoute$$$opt(c.value().trim())).getOrElse(SSOStandardRoute::$anonfun$2);
            ServerModel.Cookie cookie = ServerModel$Cookie$.MODULE$.apply(this.cookieName, cookieValue);
            String language = I18N$.MODULE$.getAcceptLanguage(request);
            ServerModel.CodeRequest codeRequest = ServerModel$CodeRequest$.MODULE$.apply(ServerModel$When$.MODULE$.apply(now), ServerModel$ClientId$.MODULE$.apply((String)clientId), ServerModel$ResponseType$.MODULE$.apply((String)responseType), ServerModel$RedirectUri$.MODULE$.apply((String)redirectUri), (Option<String>)optScope.map((Function1 & Serializable)value -> new ServerModel.Scope(ServerModel$Scope$.MODULE$.apply(value))), ServerModel$State$.MODULE$.apply((String)state), cookie, language);
            return this.serverHandler.handle(codeRequest);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> tokenHandler() {
        return GravityHelper$.MODULE$.formItems("client_id", "grant_type", "code", "redirect_uri", (Function4 & Serializable)(clientId, grantType, code, redirectUri) -> (Function1 & Serializable)request -> {
            Option optClientSecret = request.formItems().get("client_secret").collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Gravity.FormItem x) {
                    Gravity.FormItem formItem = x;
                    if (formItem instanceof Gravity.AttributeItem) {
                        Gravity.AttributeItem fi = (Gravity.AttributeItem)formItem;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Gravity.FormItem x, Function1 function1) {
                    Gravity.FormItem formItem = x;
                    if (formItem instanceof Gravity.AttributeItem) {
                        Gravity.AttributeItem fi = (Gravity.AttributeItem)formItem;
                        return fi.value();
                    }
                    return function1.apply((Object)x);
                }
            });
            ServerModel.TokenRequest tokenRequest = ServerModel$TokenRequest$.MODULE$.apply(ServerModel$ClientId$.MODULE$.apply((String)clientId), (Option<String>)optClientSecret.map((Function1 & Serializable)value -> new ServerModel.ClientSecret(ServerModel$ClientSecret$.MODULE$.apply(value))), ServerModel$GrantType$.MODULE$.apply((String)grantType), ServerModel$Code$.MODULE$.apply((String)code), ServerModel$RedirectUri$.MODULE$.apply((String)redirectUri));
            return this.serverHandler.handle(tokenRequest);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> idTokenHandler() {
        return GravityHelper$.MODULE$.formItems("grant_type", "code", "redirect_uri", (Function3 & Serializable)(grantType, code, redirectUri) -> (Function1 & Serializable)request -> {
            Option bearer = request.headers().get("Authorization").map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(_$1), "Basic ").trim());
            Tuple2 tuple2 = (Tuple2)bearer.map((Function1 & Serializable)b -> new String(Base64.getDecoder().decode((String)b), Gravity$.MODULE$.UTF_8())).map((Function1 & Serializable)s -> {
                int idx = s.indexOf(":");
                return Tuple2$.MODULE$.apply((Object)new ServerModel.ClientId(ServerModel$ClientId$.MODULE$.apply(s.substring(0, idx))), (Object)new ServerModel.ClientSecret(ServerModel$ClientSecret$.MODULE$.apply(s.substring(idx + 1))));
            }).getOrElse(SSOStandardRoute::$anonfun$8);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String clientId = tuple2._1() == null ? null : ((ServerModel.ClientId)tuple2._1()).value();
            String clientSecret = tuple2._2() == null ? null : ((ServerModel.ClientSecret)tuple2._2()).value();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)new ServerModel.ClientId(clientId), (Object)new ServerModel.ClientSecret(clientSecret));
            String clientId2 = tuple22._1() == null ? null : ((ServerModel.ClientId)tuple22._1()).value();
            String clientSecret2 = tuple22._2() == null ? null : ((ServerModel.ClientSecret)tuple22._2()).value();
            ServerModel.OIDCTokenRequest tokenRequest = ServerModel$OIDCTokenRequest$.MODULE$.apply(ServerModel$ClientInfo$.MODULE$.apply(clientId2, clientSecret2), ServerModel$GrantType$.MODULE$.apply((String)grantType), ServerModel$Code$.MODULE$.apply((String)code), ServerModel$RedirectUri$.MODULE$.apply((String)redirectUri));
            return this.serverHandler.handleOIDC(tokenRequest);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> jwksHandler() {
        return (Function1 & Serializable)_$2 -> Task$.MODULE$.apply(SSOStandardRoute::jwksHandler$$anonfun$1$$anonfun$1);
    }

    public Function1<GravityRequest, Task<GravityResponse>> resourceHandler() {
        return GravityHelper$.MODULE$.formItems("client_id", "grant_type", "username", "password", "totp", (Function5 & Serializable)(clientId, grantType, username, password, totp) -> (Function1 & Serializable)request -> {
            Option optClientSecret = request.formParameter("client_secret");
            if (SSOStandardRoute$.MODULE$.ResourceOwnerPasswordEnabled()) {
                ServerModel.ResourceOwnerPasswordRequest resourceOwnerPasswordRequest = ServerModel$ResourceOwnerPasswordRequest$.MODULE$.apply(ServerModel$ClientId$.MODULE$.apply((String)clientId), (Option<String>)optClientSecret.map((Function1 & Serializable)value -> new ServerModel.ClientSecret(ServerModel$ClientSecret$.MODULE$.apply(value))), ServerModel$GrantType$.MODULE$.apply((String)grantType), SSOStandardRoute$.MODULE$.coerceCase(ServerModel$Username$.MODULE$.apply((String)username)), ServerModel$Password$.MODULE$.apply((String)password), ServerModel$Totp$.MODULE$.apply((String)totp));
                return this.serverHandler.handle(resourceOwnerPasswordRequest);
            }
            SSOStandardRoute$.MODULE$.log().warn(() -> SSOStandardRoute.resourceHandler$$anonfun$1$$anonfun$1$$anonfun$1(username, request), Line$.MODULE$.apply(158), FullName$.MODULE$.apply("ambience.simplesso.server.SSOStandardRoute.resourceHandler"));
            return Gravity$.MODULE$.ForbiddenResponseT();
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> loginHandler() {
        return GravityHelper$.MODULE$.formItems("username", "password", "totp", "rnd", (Function4 & Serializable)(username, password, totp, rnd) -> (Function1 & Serializable)request -> {
            Option option = request.cookies().get((Object)this.cookieName);
            if (option instanceof Some) {
                GravityCookie cookie = (GravityCookie)((Some)option).value();
                ServerModel.LoginRequest loginRequest = ServerModel$LoginRequest$.MODULE$.apply(SSOStandardRoute$.MODULE$.coerceCase(ServerModel$Username$.MODULE$.apply((String)username)), ServerModel$Password$.MODULE$.apply((String)password), ServerModel$Totp$.MODULE$.apply((String)totp), ServerModel$Rnd$.MODULE$.apply((String)rnd), ServerModel$Cookie$.MODULE$.apply(this.cookieName, cookie.value()), I18N$.MODULE$.getAcceptLanguage(request));
                return this.serverHandler.handle(loginRequest);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Missing login request cookie");
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> resetPasswordHandler() {
        return GravityHelper$.MODULE$.formItems("username", "rnd", (Function2 & Serializable)(username, rnd) -> (Function1 & Serializable)request -> {
            Option option = request.cookies().get((Object)this.cookieName);
            if (option instanceof Some) {
                GravityCookie cookie = (GravityCookie)((Some)option).value();
                String language = I18N$.MODULE$.getAcceptLanguage(request);
                ServerModel.ResetRequest resetRequest = ServerModel$ResetRequest$.MODULE$.apply(SSOStandardRoute$.MODULE$.coerceCase(ServerModel$Username$.MODULE$.apply((String)username)), ServerModel$Rnd$.MODULE$.apply((String)rnd), ServerModel$Cookie$.MODULE$.apply(this.cookieName, cookie.value()), language);
                return this.resetHandler.handle(resetRequest);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Missing reset password cookie");
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> resetConfirmationHandler() {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)resetConfirmation -> (Function1 & Serializable)request -> this.resetHandler.confirm(I18N$.MODULE$.getAcceptLanguage(request), resetConfirmation.value()));
    }

    public Task<GravityResponse> logoutHandler(GravityRequest request) {
        Option optReturnUri = request.parameters().get("ret").map((Function1 & Serializable)value -> new ServerModel.ReturnUri(ServerModel$ReturnUri$.MODULE$.apply(value)));
        String language = I18N$.MODULE$.getAcceptLanguage(request);
        Option option = request.cookies().get((Object)this.cookieName);
        if (option instanceof Some) {
            GravityCookie cookie = (GravityCookie)((Some)option).value();
            ServerModel.LogoutRequest req = ServerModel$LogoutRequest$.MODULE$.apply(ServerModel$Cookie$.MODULE$.apply(this.cookieName, cookie.value()), (Option<String>)optReturnUri, language);
            return this.serverHandler.handle(req).map((Function1 & Serializable)response -> {
                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L));
                String string = cookie.copy$default$1();
                String string2 = cookie.copy$default$2();
                Option option = cookie.copy$default$4();
                boolean bl = cookie.copy$default$5();
                boolean bl2 = cookie.copy$default$6();
                Option option2 = cookie.copy$default$7();
                return response.withHeader(cookie.copy(string, string2, (Option)some, option, bl, bl2, option2).asSetCookieHeader());
            });
        }
        if (None$.MODULE$.equals(option)) {
            ServerModel.LogoutRequest req = ServerModel$LogoutRequest$.MODULE$.apply(ServerModel$Cookie$.MODULE$.apply(this.cookieName, "unknown"), (Option<String>)optReturnUri, language);
            return this.serverHandler.handle(req);
        }
        throw new MatchError((Object)option);
    }

    public Task<GravityResponse> userInfoHandler(GravityRequest request) {
        Option optBearer = request.headers().get("Authorization").map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(_$3), "Bearer ").trim());
        Option option = optBearer;
        if (option instanceof Some) {
            String tok = (String)((Some)option).value();
            ServerModel.AccessToken at = ServerModel$AccessToken$.MODULE$.apply(ServerModel$Token$.MODULE$.apply(tok));
            return this.serverHandler.isValidAccessToken(at).flatMap((Function1 & Serializable)valid -> this.userInfoHandler$$anonfun$1(at, BoxesRunTime.unboxToBoolean((Object)valid)));
        }
        if (None$.MODULE$.equals(option)) {
            return Gravity$.MODULE$.BadRequestResponseT("No access_token");
        }
        throw new MatchError((Object)option);
    }

    private static final String $anonfun$2() {
        return UUID.randomUUID().toString();
    }

    private static final Tuple2 $anonfun$8() {
        return Tuple2$.MODULE$.apply((Object)new ServerModel.ClientId(ServerModel$ClientId$.MODULE$.apply("")), (Object)new ServerModel.ClientSecret(ServerModel$ClientSecret$.MODULE$.apply("")));
    }

    private static final GravityResponse jwksHandler$$anonfun$1$$anonfun$1() {
        return GravityResponse$.MODULE$.json(OIDC$.MODULE$.JWKS());
    }

    private static final Object resourceHandler$$anonfun$1$$anonfun$1$$anonfun$1(String username$2, GravityRequest request$1) {
        return "ResourceOwnerPassword protocol is disabled (request by " + username$2 + " at " + new Gravity.Host(request$1.host()) + ")";
    }

    private final /* synthetic */ Task userInfoHandler$$anonfun$1(ServerModel.AccessToken at$1, boolean valid) {
        if (valid) {
            return this.serverHandler.handle(ServerModel$UserInfoRequest$.MODULE$.apply(at$1));
        }
        return Gravity$.MODULE$.BadRequestResponseT("Invalid access_token");
    }
}

