/*
 * Decompiled with CFR 0.152.
 */
package ambience.simplesso.server;

import ambience.module.UserDB;
import ambience.simplesso.SimpleSSOModule;
import ambience.simplesso.oidc.IdToken;
import ambience.simplesso.oidc.IdToken$;
import ambience.simplesso.oidc.OIDC$;
import ambience.simplesso.server.ClientDB;
import ambience.simplesso.server.LoginForm;
import ambience.simplesso.server.LogoutForm$;
import ambience.simplesso.server.SSOServerState;
import ambience.simplesso.server.ServerHandler$AccessTokenInfo$;
import ambience.simplesso.server.ServerHandler$ResourceOwnerInfo$;
import ambience.simplesso.server.ServerHandler$WebUserInfo$;
import ambience.simplesso.server.ServerModel;
import ambience.simplesso.server.ServerModel$AccessToken$;
import ambience.simplesso.server.ServerModel$Code$;
import ambience.simplesso.server.ServerModel$CookieRnd$;
import ambience.simplesso.server.ServerModel$Rnd$;
import ambience.simplesso.server.ServerModel$Token$;
import ambience.simplesso.server.ServerModel$UserInfo$;
import ambience.simplesso.server.ServerModel$When$;
import ambience.simplesso.server.UserDB;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.owasp.encoder.Encode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.deriving.Mirror;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ServerHandler
implements LoggingHelper2 {
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(ServerHandler.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(ServerHandler.class.getDeclaredField("SimpleServerLogoutRet$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ServerHandler.class.getDeclaredField("auditAppender$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ServerHandler.class.getDeclaredField("auditComponent$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ServerHandler.class.getDeclaredField("loginForm$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ServerHandler.class.getDeclaredField("GroupsEnabled$lzy1"));
    private volatile Object log$lzy1;
    private final SimpleSSOModule module;
    private final ServerModel.ServerConfig sconfig;
    private final UserDB userdb;
    private final ClientDB clientdb;
    private final SSOServerState serverState;
    private final Scheduler scheduler;
    private volatile Object GroupsEnabled$lzy1;
    private volatile Object loginForm$lzy1;
    private volatile Object auditComponent$lzy1;
    private volatile Object auditAppender$lzy1;
    private volatile Object SimpleServerLogoutRet$lzy1;

    public ServerHandler(SimpleSSOModule module, ServerModel.ServerConfig sconfig, UserDB userdb, ClientDB clientdb, SSOServerState serverState) {
        this.module = module;
        this.sconfig = sconfig;
        this.userdb = userdb;
        this.clientdb = clientdb;
        this.serverState = serverState;
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SSOServerState serverState() {
        return this.serverState;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public boolean GroupsEnabled() {
        Object object = this.GroupsEnabled$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.GroupsEnabled$lzyINIT1());
    }

    private Object GroupsEnabled$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.GroupsEnabled$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.module.config().getBoolean("ambience.simple-sso.groups.enabled"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.GroupsEnabled$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public LoginForm loginForm() {
        Object object = this.loginForm$lzy1;
        if (object instanceof LoginForm) {
            return (LoginForm)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoginForm)this.loginForm$lzyINIT1();
    }

    private Object loginForm$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.loginForm$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoginForm loginForm = null;
                    try {
                        loginForm = new LoginForm(this.module);
                        object2 = loginForm == null ? LazyVals.NullValue$.MODULE$ : loginForm;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.loginForm$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loginForm;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.Component auditComponent() {
        Object object = this.auditComponent$lzy1;
        if (object instanceof AuditAPI.Component) {
            return (AuditAPI.Component)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuditAPI.Component)this.auditComponent$lzyINIT1();
    }

    private Object auditComponent$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.auditComponent$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuditAPI.Component component = null;
                    try {
                        component = this.buildAuditComponent();
                        object2 = component == null ? LazyVals.NullValue$.MODULE$ : component;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.auditComponent$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return component;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Try<AuditAPI.AuditAppender> auditAppender() {
        Object object = this.auditAppender$lzy1;
        if (object instanceof Try) {
            return (Try)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Try)this.auditAppender$lzyINIT1();
    }

    private Object auditAppender$lzyINIT1() {
        Object object;
        block11: {
            while (true) {
                if ((object = this.auditAppender$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Success success = null;
                    try {
                        Success success2;
                        Try try_ = Try$.MODULE$.apply(ServerHandler::auditAppender$lzyINIT1$$anonfun$1);
                        if (try_ instanceof Success) {
                            AuditAPI.AuditAppender aa = (AuditAPI.AuditAppender)((Success)try_).value();
                            success2 = Success$.MODULE$.apply((Object)aa);
                        } else if (try_ instanceof Failure) {
                            Throwable ex = ((Failure)try_).exception();
                            this.log().warn(ServerHandler::auditAppender$lzyINIT1$$anonfun$2, Line$.MODULE$.apply(62), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.auditAppender"));
                            success2 = Failure$.MODULE$.apply(ex);
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        success = success2;
                        object2 = success == null ? LazyVals.NullValue$.MODULE$ : success;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.auditAppender$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.auditAppender$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return success;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block11;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<Regex> SimpleServerLogoutRet() {
        Object object = this.SimpleServerLogoutRet$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.SimpleServerLogoutRet$lzyINIT1();
    }

    private Object SimpleServerLogoutRet$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.SimpleServerLogoutRet$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = Try$.MODULE$.apply(this::SimpleServerLogoutRet$lzyINIT1$$anonfun$1).toOption().flatMap((Function1 & Serializable)s -> {
                            if (s.trim().isEmpty()) {
                                return None$.MODULE$;
                            }
                            Try try_ = Try$.MODULE$.apply(() -> ServerHandler.SimpleServerLogoutRet$lzyINIT1$$anonfun$2$$anonfun$1(s));
                            if (try_ instanceof Success) {
                                Regex r = (Regex)((Success)try_).value();
                                this.log().info(() -> ServerHandler.SimpleServerLogoutRet$lzyINIT1$$anonfun$2$$anonfun$2(s), Line$.MODULE$.apply(73), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.SimpleServerLogoutRet"));
                                return Some$.MODULE$.apply((Object)r);
                            }
                            if (try_ instanceof Failure) {
                                Throwable ex = ((Failure)try_).exception();
                                this.log().error(() -> ServerHandler.SimpleServerLogoutRet$lzyINIT1$$anonfun$2$$anonfun$3(s, ex), Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.SimpleServerLogoutRet"));
                                return None$.MODULE$;
                            }
                            throw new MatchError((Object)try_);
                        });
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.SimpleServerLogoutRet$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Object> isValidAccessToken(ServerModel.AccessToken tok) {
        return this.serverState().getUserInfo(tok).map((Function1 & Serializable)_$1 -> _$1.isDefined());
    }

    public Task<GravityResponse> handle(ServerModel.CodeRequest r) {
        return this.codeRequestToClient(r).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                ServerModel.ClientRecord client = (ServerModel.ClientRecord)((Right)either).value();
                return this.isValid(r.cookie()).flatMap((Function1 & Serializable)valid -> this.handle$$anonfun$1$$anonfun$1(r, client, BoxesRunTime.unboxToBoolean((Object)valid)));
            }
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return this.tBadRequest(r.language(), msg);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<GravityResponse> handle(ServerModel.LoginRequest r) {
        ServerModel.CookieRnd key = ServerModel$CookieRnd$.MODULE$.apply(r.cookie(), r.rnd());
        return this.serverState().getCodeRequest(key).flatMap((Function1 & Serializable)optCR -> {
            Task<GravityResponse> task;
            Option option = optCR;
            if (option instanceof Some) {
                ServerModel.CodeRequest cr = (ServerModel.CodeRequest)((Some)option).value();
                task = this.handle(r, key, cr);
            } else if (None$.MODULE$.equals(option)) {
                task = this.tBadRequest(r.language(), "Cookie mismatch, please retry");
            } else {
                throw new MatchError((Object)option);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        });
    }

    public Task<GravityResponse> handle(ServerModel.LoginRequest r, ServerModel.CookieRnd key, ServerModel.CodeRequest cr) {
        return this.serverState().deleteCodeRequest(key).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.loginRequestToUser(cr, r).flatMap((Function1 & Serializable)ou -> this.addLoginToLogs(r, cr, (Option<ServerModel.UserRecord>)ou).map((Function1 & Serializable)reply -> reply));
        });
    }

    private Task<GravityResponse> addLoginToLogs(ServerModel.LoginRequest r, ServerModel.CodeRequest cr, Option<ServerModel.UserRecord> ou) {
        Option<ServerModel.UserRecord> option = ou;
        if (option instanceof Some) {
            ServerModel.UserRecord user = (ServerModel.UserRecord)((Some)option).value();
            return this.serverState().setUserInfo(r.cookie(), ServerModel$UserInfo$.MODULE$.apply(user.sub(), user.username(), user.email(), user.changePassword(), ServerModel$When$.MODULE$.apply(System.currentTimeMillis()))).flatMap((Function1 & Serializable)_$2 -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"sub");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)user.sub());
                this.audit(user.username(), AuditAPI.Success$.MODULE$.apply("sso", "Login", (Option)Some$.MODULE$.apply((Object)(r.cookie().name() + "=" + r.cookie().value())), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                return this.sendCode(cr);
            });
        }
        if (None$.MODULE$.equals(option)) {
            this.audit(r.username(), AuditAPI.Failure$.MODULE$.apply("sso", "Login", (Option)Some$.MODULE$.apply((Object)"Invalid credentials"), AuditAPI.Failure$.MODULE$.apply$default$4()));
            return this.codeRequestToClient(cr).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Right) {
                    ServerModel.ClientRecord client = (ServerModel.ClientRecord)((Right)either).value();
                    return this.loginForm(cr, client, true);
                }
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return Task$.MODULE$.now((Object)this.badRequest(cr.language(), msg));
                }
                throw new MatchError((Object)either);
            });
        }
        throw new MatchError(option);
    }

    public Task<GravityResponse> handle(ServerModel.TokenRequest r) {
        return Task$.MODULE$.deferFuture(() -> this.handle$$anonfun$4(r)).flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                Task task;
                ServerModel.ClientRecord clientRecord = (ServerModel.ClientRecord)((Some)option).value();
                Option<String> option2 = clientRecord.clientSecret();
                Option<String> option3 = r.clientSecret();
                if (!(option2 != null ? !option2.equals(option3) : option3 != null)) {
                    Task tOptUserInfo = this.serverState().getCookie(r.code()).flatMap((Function1 & Serializable)optCookie -> ((Task)optCookie.map((Function1 & Serializable)c -> this.serverState().getUserInfo((ServerModel.Cookie)c)).getOrElse(ServerHandler::$anonfun$1$$anonfun$2)).map((Function1 & Serializable)userInfo -> userInfo));
                    task = tOptUserInfo.flatMap((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            ServerModel.UserInfo ui = (ServerModel.UserInfo)((Some)option).value();
                            return this.handleTokenRequest(r.code(), ui).flatMap((Function1 & Serializable)at -> {
                                AccessTokenInfo accessTokenInfo = (AccessTokenInfo)package$.MODULE$.EncoderOps(at);
                                ServerHandler$AccessTokenInfo$ mirror$proxy1 = ServerHandler$AccessTokenInfo$.MODULE$;
                                String string = "access_token";
                                String string2 = "sub";
                                String string3 = "name";
                                String string4 = "preferred_username";
                                return this.sendJson(Gravity.Status$.MODULE$.OK(), package.EncoderOps$.MODULE$.asJson$extension((Object)accessTokenInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(ServerHandler::$anonfun$2$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy1)))).noSpaces()).map((Function1 & Serializable)ret -> ret);
                            });
                        }
                        if (None$.MODULE$.equals(option)) {
                            return this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad code\"} ");
                        }
                        throw new MatchError((Object)option);
                    });
                } else {
                    task = this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad client\"} ");
                }
                Task tResponse = task;
                return tResponse;
            }
            if (None$.MODULE$.equals(option)) {
                return this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad client_id\"} ");
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<AccessTokenInfo> handleTokenRequest(String code, ServerModel.UserInfo ui) {
        return Task$.MODULE$.apply(this::handleTokenRequest$$anonfun$1).flatMap((Function1 & Serializable)tok -> this.serverState().setUserInfo((ServerModel.AccessToken)tok, ui).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.serverState().deleteCookie(code).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(() -> this.handleTokenRequest$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(tok, ui)).map((Function1 & Serializable)reply -> reply);
            });
        }));
    }

    public Task<GravityResponse> handleOIDC(ServerModel.OIDCTokenRequest r) {
        return Task$.MODULE$.deferFuture(() -> this.handleOIDC$$anonfun$1(r)).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Task task;
                ServerModel.ClientRecord clientRecord = (ServerModel.ClientRecord)((Some)option).value();
                if (clientRecord.clientSecret().contains((Object)new ServerModel.ClientSecret(r.clientInfo().secret()))) {
                    Task tOptUserInfo = this.serverState().getCookie(r.code()).flatMap((Function1 & Serializable)optCookie -> ((Task)optCookie.map((Function1 & Serializable)c -> this.serverState().getUserInfo((ServerModel.Cookie)c)).getOrElse(ServerHandler::$anonfun$3$$anonfun$2)).map((Function1 & Serializable)userInfo -> userInfo));
                    task = tOptUserInfo.flatMap((Function1 & Serializable)x$12 -> {
                        Option option = x$12;
                        if (option instanceof Some) {
                            ServerModel.UserInfo ui = (ServerModel.UserInfo)((Some)option).value();
                            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                                this.$anonfun$4$$anonfun$1(ui);
                                return BoxedUnit.UNIT;
                            }).flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return Task$.MODULE$.apply(this::$anonfun$4$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)tok -> this.serverState().setUserInfo((ServerModel.AccessToken)tok, ui).flatMap((Function1 & Serializable)x$12 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return this.serverState().deleteCookie(r.code()).flatMap((Function1 & Serializable)x$1 -> {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return this.getGroupsT(ui.username()).flatMap((Function1 & Serializable)groups -> this.sendJson(Gravity.Status$.MODULE$.OK(), this.buildIdTokenResponse(this.buildIdTokenInfo(r.clientInfo(), (ServerModel.AccessToken)tok, ui, (List<String>)groups))).map((Function1 & Serializable)reply -> reply));
                                    });
                                }));
                            });
                        }
                        if (None$.MODULE$.equals(option)) {
                            return this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad code\"} ");
                        }
                        throw new MatchError((Object)option);
                    });
                } else {
                    task = this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad client\"} ");
                }
                Task tResponse = task;
                return tResponse;
            }
            if (None$.MODULE$.equals(option)) {
                return this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad client_id\"} ");
            }
            throw new MatchError((Object)option);
        });
    }

    public String buildIdTokenResponse(IdToken token) {
        this.log().info(() -> ServerHandler.buildIdTokenResponse$$anonfun$1(token), Line$.MODULE$.apply(209), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.buildIdTokenResponse"));
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"access_token");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(token.access().token()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"expires_in");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromLong(OIDC$.MODULE$.ExpiresSecs()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id_token");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(token.toString()));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"scope");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString("openid"));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"token_type");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.fromString("Bearer"));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).noSpaces();
    }

    public Task<GravityResponse> handle(ServerModel.ResourceOwnerPasswordRequest r) {
        this.log().info(() -> ServerHandler.handle$$anonfun$6(r), Line$.MODULE$.apply(222), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.handle"));
        Task$.MODULE$.now((Object)BoxedUnit.UNIT);
        return Task$.MODULE$.deferFuture(() -> this.handle$$anonfun$7(r)).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ServerModel.ClientRecord clientRecord = (ServerModel.ClientRecord)((Some)option).value();
                Option<String> option2 = clientRecord.clientSecret();
                Option<String> option3 = r.clientSecret();
                Task tResponse = !(option2 != null ? !option2.equals(option3) : option3 != null) ? this.userdb.matches(r.username(), r.password(), r.totp()).flatMap((Function1 & Serializable)x$13 -> {
                    Option option = x$13;
                    if (option instanceof Some) {
                        ServerModel.UserRecord user = (ServerModel.UserRecord)((Some)option).value();
                        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                            this.$anonfun$5$$anonfun$1(r);
                            return BoxedUnit.UNIT;
                        }).flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                                this.$anonfun$5$$anonfun$2$$anonfun$1(user);
                                return BoxedUnit.UNIT;
                            }).flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return Task$.MODULE$.apply(() -> ServerHandler.$anonfun$5$$anonfun$2$$anonfun$2$$anonfun$1(user)).flatMap((Function1 & Serializable)ui -> Task$.MODULE$.apply(this::$anonfun$5$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)tok -> this.serverState().setUserInfo((ServerModel.AccessToken)tok, (ServerModel.UserInfo)ui).flatMap((Function1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return this.buildResourceOwnerInfo((ServerModel.AccessToken)tok, (ServerModel.UserInfo)ui).flatMap((Function1 & Serializable)info -> {
                                        ResourceOwnerInfo resourceOwnerInfo = (ResourceOwnerInfo)package$.MODULE$.EncoderOps(info);
                                        ServerHandler$ResourceOwnerInfo$ mirror$proxy2 = ServerHandler$ResourceOwnerInfo$.MODULE$;
                                        String string = "access_token";
                                        String string2 = "sub";
                                        String string3 = "name";
                                        String string4 = "email";
                                        String string5 = "preferred_username";
                                        String string6 = "groups";
                                        return this.sendJson(Gravity.Status$.MODULE$.OK(), package.EncoderOps$.MODULE$.asJson$extension((Object)resourceOwnerInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(ServerHandler::$anonfun$5$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy2)))).noSpaces()).map((Function1 & Serializable)reply -> reply);
                                    });
                                })));
                            });
                        });
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                            this.$anonfun$5$$anonfun$3(r);
                            return BoxedUnit.UNIT;
                        }).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad user\"} ").map((Function1 & Serializable)reply -> reply);
                        });
                    }
                    throw new MatchError((Object)option);
                }) : this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad client\"} ");
                return tResponse;
            }
            if (None$.MODULE$.equals(option)) {
                return this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"Bad client_id\"} ");
            }
            throw new MatchError((Object)option);
        });
    }

    public AccessTokenInfo buildAccessTokenInfo(ServerModel.AccessToken tok, ServerModel.UserInfo ui) {
        return ServerHandler$AccessTokenInfo$.MODULE$.apply(tok.token(), ui.sub(), ui.username(), ui.username());
    }

    public IdToken buildIdTokenInfo(ServerModel.ClientInfo clientInfo, ServerModel.AccessToken tok, ServerModel.UserInfo ui, List<String> groups) {
        return IdToken$.MODULE$.build(clientInfo, tok, ui, groups);
    }

    public Task<ResourceOwnerInfo> buildResourceOwnerInfo(ServerModel.AccessToken tok, ServerModel.UserInfo ui) {
        return this.getGroupsT(ui.username()).map((Function1 & Serializable)gs -> ServerHandler$ResourceOwnerInfo$.MODULE$.apply(tok.token(), ui.sub(), ui.username(), ui.email(), ui.username(), (List<String>)gs));
    }

    public Task<Option<ServerModel.UserInfo>> getUserInfo(ServerModel.AccessToken at) {
        return this.serverState().getUserInfo(at);
    }

    public Task<GravityResponse> handle(ServerModel.UserInfoRequest r) {
        return this.getUserInfo(r.at()).flatMap((Function1 & Serializable)optUserInfo -> this.handle(r, (Option<ServerModel.UserInfo>)optUserInfo).map((Function1 & Serializable)reply -> reply));
    }

    private Task<GravityResponse> handle(ServerModel.UserInfoRequest r, Option<ServerModel.UserInfo> optUserInfo) {
        Option<ServerModel.UserInfo> option = optUserInfo;
        if (option instanceof Some) {
            ServerModel.UserInfo ui = (ServerModel.UserInfo)((Some)option).value();
            return this.buildWebUserInfo(ui).map((Function1 & Serializable)_$3 -> {
                WebUserInfo webUserInfo = (WebUserInfo)package$.MODULE$.EncoderOps(_$3);
                ServerHandler$WebUserInfo$ mirror$proxy3 = ServerHandler$WebUserInfo$.MODULE$;
                String string = "sub";
                String string2 = "name";
                String string3 = "email";
                String string4 = "preferred_username";
                String string5 = "elxsso_changePassword";
                String string6 = "groups";
                return package.EncoderOps$.MODULE$.asJson$extension((Object)webUserInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(ServerHandler::handle$$anonfun$10$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy3)))).noSpaces();
            }).flatMap((Function1 & Serializable)json -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.handle$$anonfun$11$$anonfun$1((String)json);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.sendJson(Gravity.Status$.MODULE$.OK(), (String)json).map((Function1 & Serializable)ret -> ret);
            }));
        }
        if (None$.MODULE$.equals(option)) {
            return this.sendJson(Gravity.Status$.MODULE$.BadRequest(), "{\"error\": \"User not found\"} ");
        }
        throw new MatchError(option);
    }

    public String limitLength(String str) {
        if (str.length() > 200) {
            return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(str), 197) + "...";
        }
        return str;
    }

    public Task<WebUserInfo> buildWebUserInfo(ServerModel.UserInfo ui) {
        return this.getGroupsT(ui.username()).map((Function1 & Serializable)gs -> ServerHandler$WebUserInfo$.MODULE$.apply(ui.sub(), ui.username(), ui.email(), ui.username(), ui.changePassword(), (List<String>)gs));
    }

    public Task<List<String>> getGroupsT(String name) {
        if (this.GroupsEnabled()) {
            return ((ambience.module.UserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ambience.module.UserDB.class))).getUserByName(name).map((Function1 & Serializable)_$4 -> _$4.toList().flatMap((Function1 & Serializable)user -> this.extractGroups((UserDB.User)user)));
        }
        return Task$.MODULE$.now((Object)scala.package$.MODULE$.Nil());
    }

    public List<String> extractGroups(UserDB.User user) {
        return ((IterableOnceOps)((IterableOps)user.roles().filter((Function1 & Serializable)_$5 -> _$5.enabled())).map((Function1 & Serializable)_$6 -> _$6.name())).toList();
    }

    public Task<GravityResponse> handle(ServerModel.LogoutRequest r) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.handle$$anonfun$12(r);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.serverState().getUserInfo(r.cookie()).flatMap((Function1 & Serializable)optUserInfo -> this.serverState().deleteUserInfo(r.cookie()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.addLogoutToLogs(r, (Option<ServerModel.UserInfo>)optUserInfo).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.buildLogoutReply(r).map((Function1 & Serializable)reply -> reply);
                });
            }));
        });
    }

    private Task<BoxedUnit> addLogoutToLogs(ServerModel.LogoutRequest r, Option<ServerModel.UserInfo> optUserInfo) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.addLogoutToLogs$$anonfun$1(optUserInfo, r);
            return BoxedUnit.UNIT;
        });
    }

    private Task<GravityResponse> buildLogoutReply(ServerModel.LogoutRequest r) {
        return Task$.MODULE$.apply(() -> this.buildLogoutReply$$anonfun$1(r));
    }

    public void audit(String user, AuditAPI.Action action) {
        this.auditAppender().foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.append(AuditAPI.AuditMessage$.MODULE$.apply(user, this.auditComponent(), action)));
    }

    public AuditAPI.Component buildAuditComponent() {
        return AuditAPI.Component$.MODULE$.apply("sso-server", "main");
    }

    private Option<Gravity.Header> toLocation(String s) {
        return Try$.MODULE$.apply(() -> ServerHandler.toLocation$$anonfun$1(s)).toOption();
    }

    private Option<String> ensureValidReturnUri(String uri) {
        return (Option)this.SimpleServerLogoutRet().map((Function1 & Serializable)pattern -> {
            if (pattern.matches((CharSequence)uri)) {
                return Some$.MODULE$.apply((Object)new ServerModel.ReturnUri(uri));
            }
            this.log().warn(() -> ServerHandler.ensureValidReturnUri$$anonfun$1$$anonfun$1(uri), Line$.MODULE$.apply(357), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.ensureValidReturnUri"));
            return None$.MODULE$;
        }).getOrElse(() -> ServerHandler.ensureValidReturnUri$$anonfun$2(uri));
    }

    private Task<Either<String, ServerModel.ClientRecord>> codeRequestToClient(ServerModel.CodeRequest cr) {
        return Task$.MODULE$.deferFuture(() -> this.codeRequestToClient$$anonfun$1(cr)).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ServerModel.ClientRecord client = (ServerModel.ClientRecord)((Some)option).value();
                String string = cr.redirectUri();
                String string2 = client.redirectUri();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return Right$.MODULE$.apply((Object)client);
                }
                this.log().warn(() -> ServerHandler.codeRequestToClient$$anonfun$2$$anonfun$1(cr, client), Line$.MODULE$.apply(369), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.codeRequestToClient"));
                return Left$.MODULE$.apply((Object)"Invalid client redirect_uri");
            }
            this.log().warn(() -> ServerHandler.codeRequestToClient$$anonfun$2$$anonfun$2(cr), Line$.MODULE$.apply(373), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.codeRequestToClient"));
            return Left$.MODULE$.apply((Object)"Invalid client_id");
        });
    }

    private Task<Option<ServerModel.UserRecord>> loginRequestToUser(ServerModel.CodeRequest cr, ServerModel.LoginRequest r) {
        if (cr.when() + this.sconfig.maxLoginDelay() >= System.currentTimeMillis()) {
            return this.userdb.matches(r.username(), r.password(), r.totp());
        }
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    private Task<GravityResponse> loginForm(ServerModel.CodeRequest r, ServerModel.ClientRecord client, boolean alreadyFailed) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> new ServerModel.Rnd(this.loginForm$$anonfun$1())).flatMap((Function1 & Serializable)rnd -> this.loginForm$$anonfun$2(r, client, alreadyFailed, rnd == null ? null : ((ServerModel.Rnd)rnd).value()));
    }

    private GravityResponse logoutForm(String language) {
        return LogoutForm$.MODULE$.buildForm(language);
    }

    private Gravity.Header buildCookie(String value) {
        if (this.sconfig.isHttps()) {
            return Gravity.Header$.MODULE$.apply("Set-Cookie", this.sconfig.cookieName() + "=" + value + "; Secure; HttpOnly; SameSite=Strict");
        }
        return Gravity.Header$.MODULE$.apply("Set-Cookie", this.sconfig.cookieName() + "=" + value + "; HttpOnly; SameSite=Strict");
    }

    public GravityResponse badRequest(String language, String txt) {
        return this.loginForm().buildError(language, txt);
    }

    public Task<GravityResponse> tBadRequest(String language, String txt) {
        return Task$.MODULE$.now((Object)this.badRequest(language, txt));
    }

    public String genRnd() {
        return ServerModel$Rnd$.MODULE$.apply(UUID.randomUUID().toString());
    }

    public Task<Object> isValid(ServerModel.Cookie c) {
        return this.serverState().getUserInfo(c).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ServerModel.UserInfo ui = (ServerModel.UserInfo)((Some)option).value();
                if (ui.when() + this.sconfig.sessionLength() >= System.currentTimeMillis()) {
                    return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                return this.serverState().deleteUserInfo(c).map((Function1 & Serializable)_$9 -> false);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<GravityResponse> sendCode(ServerModel.CodeRequest r) {
        String code = ServerModel$Code$.MODULE$.apply(this.genRnd());
        return this.serverState().setCookie(code, r.cookie()).map((Function1 & Serializable)_$10 -> {
            Gravity.Header redirect = Gravity.Header$.MODULE$.Location(r.redirectUri() + "?code=" + code + "&state=" + Encode.forUriComponent((String)r.state()));
            return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.Found(), Gravity.Headers$.MODULE$.apply((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{redirect}))), GravityResponse$.MODULE$.$lessinit$greater$default$3());
        });
    }

    public Task<GravityResponse> sendJson(int status, String s) {
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Json(), Gravity.Header$.MODULE$.apply("Cache-Control", "no-store")})));
        return Task$.MODULE$.now((Object)GravityResponse$.MODULE$.apply(status, headers, DataBytes$.MODULE$.apply(s)));
    }

    public Task<GravityResponse> sendJwt(int status, IdToken idt) {
        this.log().info(() -> ServerHandler.sendJwt$$anonfun$1(idt), Line$.MODULE$.apply(439), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.sendJwt"));
        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{Gravity.Header$.MODULE$.ContentType("application/jwt"), Gravity.Header$.MODULE$.apply("Cache-Control", "no-store")})));
        return Task$.MODULE$.now((Object)GravityResponse$.MODULE$.apply(status, headers, DataBytes$.MODULE$.apply(idt.toString())));
    }

    private static final AuditAPI.AuditAppender auditAppender$lzyINIT1$$anonfun$1() {
        return (AuditAPI.AuditAppender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(AuditAPI.AuditAppender.class));
    }

    private static final Object auditAppender$lzyINIT1$$anonfun$2() {
        return "No Audit appender available";
    }

    private final String SimpleServerLogoutRet$lzyINIT1$$anonfun$1() {
        return this.module.config().getString("simple-server.logout-return-regex");
    }

    private static final Regex SimpleServerLogoutRet$lzyINIT1$$anonfun$2$$anonfun$1(String s$1) {
        return new Regex(s$1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    private static final Object SimpleServerLogoutRet$lzyINIT1$$anonfun$2$$anonfun$2(String s$2) {
        return "Using logout-return-regex: " + s$2;
    }

    private static final Object SimpleServerLogoutRet$lzyINIT1$$anonfun$2$$anonfun$3(String s$3, Throwable ex$1) {
        return "Cannot parse logout-return-regex " + s$3 + ": " + ex$1;
    }

    private final /* synthetic */ Task handle$$anonfun$1$$anonfun$1(ServerModel.CodeRequest r$2, ServerModel.ClientRecord client$1, boolean valid) {
        if (valid) {
            return this.sendCode(r$2);
        }
        return this.loginForm(r$2, client$1, false);
    }

    private final Future handle$$anonfun$4(ServerModel.TokenRequest r$7) {
        return this.clientdb.get(r$7.clientId());
    }

    private static final Task $anonfun$1$$anonfun$2() {
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private final ServerModel.AccessToken handleTokenRequest$$anonfun$1() {
        return ServerModel$AccessToken$.MODULE$.apply(ServerModel$Token$.MODULE$.apply(this.genRnd()));
    }

    private final AccessTokenInfo handleTokenRequest$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(ServerModel.AccessToken tok$3, ServerModel.UserInfo ui$4) {
        return this.buildAccessTokenInfo(tok$3, ui$4);
    }

    private final Future handleOIDC$$anonfun$1(ServerModel.OIDCTokenRequest r$10) {
        return this.clientdb.get(r$10.clientInfo().id());
    }

    private static final Task $anonfun$3$$anonfun$2() {
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    private static final Object $anonfun$4$$anonfun$1$$anonfun$1(ServerModel.UserInfo ui$6) {
        return "handleOIDC for " + ui$6;
    }

    private final void $anonfun$4$$anonfun$1(ServerModel.UserInfo ui$5) {
        this.log().info(() -> ServerHandler.$anonfun$4$$anonfun$1$$anonfun$1(ui$5), Line$.MODULE$.apply(186), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.tResponse"));
    }

    private final ServerModel.AccessToken $anonfun$4$$anonfun$2$$anonfun$1() {
        return ServerModel$AccessToken$.MODULE$.apply(ServerModel$Token$.MODULE$.apply(this.genRnd()));
    }

    private static final Object buildIdTokenResponse$$anonfun$1(IdToken token$1) {
        return "idtoken=" + token$1.toString();
    }

    private static final Object handle$$anonfun$6(ServerModel.ResourceOwnerPasswordRequest r$18) {
        return "ResourceOwnerPasswordRequest for " + new ServerModel.Username(r$18.username()) + " from client " + new ServerModel.ClientId(r$18.clientId());
    }

    private final Future handle$$anonfun$7(ServerModel.ResourceOwnerPasswordRequest r$19) {
        return this.clientdb.get(r$19.clientId());
    }

    private static final Object $anonfun$5$$anonfun$1$$anonfun$1(ServerModel.ResourceOwnerPasswordRequest r$23) {
        return "ResourceOwnerPasswordRequest for " + new ServerModel.Username(r$23.username()) + " approved";
    }

    private final void $anonfun$5$$anonfun$1(ServerModel.ResourceOwnerPasswordRequest r$22) {
        this.log().info(() -> ServerHandler.$anonfun$5$$anonfun$1$$anonfun$1(r$22), Line$.MODULE$.apply(229), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.tResponse"));
    }

    private final void $anonfun$5$$anonfun$2$$anonfun$1(ServerModel.UserRecord user$3) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"sub");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)user$3.sub());
        this.audit(user$3.username(), AuditAPI.Success$.MODULE$.apply("sso", "Login", (Option)Some$.MODULE$.apply((Object)"ResourceOwnerPassword"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    private static final ServerModel.UserInfo $anonfun$5$$anonfun$2$$anonfun$2$$anonfun$1(ServerModel.UserRecord user$5) {
        return ServerModel$UserInfo$.MODULE$.apply(user$5.sub(), user$5.username(), user$5.email(), user$5.changePassword(), ServerModel$When$.MODULE$.apply(System.currentTimeMillis()));
    }

    private final ServerModel.AccessToken $anonfun$5$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1() {
        return ServerModel$AccessToken$.MODULE$.apply(ServerModel$Token$.MODULE$.apply(this.genRnd()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1() {
        Encoder.AsArray encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder.AsArray asArray = encodeA = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asArray).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private final void $anonfun$5$$anonfun$3(ServerModel.ResourceOwnerPasswordRequest r$24) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"user");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)r$24.username());
        this.audit(r$24.username(), AuditAPI.Failure$.MODULE$.apply("sso", "Login", (Option)Some$.MODULE$.apply((Object)"ResourceOwnerPassword"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List handle$$anonfun$10$$anonfun$1() {
        Encoder.AsArray encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeBoolean();
        Encoder.AsArray asArray = encodeA = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)asArray).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private final Object handle$$anonfun$11$$anonfun$1$$anonfun$1(String json$2) {
        return "handleUserInfoRequest returns " + this.limitLength(json$2);
    }

    private final void handle$$anonfun$11$$anonfun$1(String json$1) {
        this.log().info(() -> this.handle$$anonfun$11$$anonfun$1$$anonfun$1(json$1), Line$.MODULE$.apply(282), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.handle"));
    }

    private static final Object handle$$anonfun$12$$anonfun$1(ServerModel.LogoutRequest r$27) {
        return "SSO Logout: " + r$27;
    }

    private final void handle$$anonfun$12(ServerModel.LogoutRequest r$26) {
        this.log().info(() -> ServerHandler.handle$$anonfun$12$$anonfun$1(r$26), Line$.MODULE$.apply(314), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.handle"));
    }

    private static final Object addLogoutToLogs$$anonfun$1$$anonfun$1(ServerModel.LogoutRequest r$33, ServerModel.UserInfo userInfo$1) {
        return "SSO Logout: " + r$33 + " " + userInfo$1.username();
    }

    private static final Object addLogoutToLogs$$anonfun$1$$anonfun$2(ServerModel.LogoutRequest r$34) {
        return "SSO Logout: " + r$34 + " (cookie not found)";
    }

    private final void addLogoutToLogs$$anonfun$1(Option optUserInfo$2, ServerModel.LogoutRequest r$32) {
        Option option = optUserInfo$2;
        if (option instanceof Some) {
            ServerModel.UserInfo userInfo = (ServerModel.UserInfo)((Some)option).value();
            this.log().info(() -> ServerHandler.addLogoutToLogs$$anonfun$1$$anonfun$1(r$32, userInfo), Line$.MODULE$.apply(326), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.addLogoutToLogs"));
            this.audit(userInfo.username(), AuditAPI.Success$.MODULE$.apply("sso", "Logout", (Option)Some$.MODULE$.apply((Object)(r$32.cookie().name() + "=" + r$32.cookie().value())), AuditAPI.Success$.MODULE$.apply$default$4()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(() -> ServerHandler.addLogoutToLogs$$anonfun$1$$anonfun$2(r$32), Line$.MODULE$.apply(329), FullName$.MODULE$.apply("ambience.simplesso.server.ServerHandler.addLogoutToLogs"));
            return;
        }
        throw new MatchError((Object)option);
    }

    private final /* synthetic */ Option $anonfun$6(String uri) {
        return this.ensureValidReturnUri(uri);
    }

    private final /* synthetic */ Option $anonfun$7(String r) {
        return this.toLocation(r);
    }

    private final GravityResponse buildLogoutReply$$anonfun$1(ServerModel.LogoutRequest r$35) {
        List redirect = r$35.ret().flatMap((Function1 & Serializable)uri -> this.$anonfun$6(uri == null ? null : ((ServerModel.ReturnUri)uri).value())).flatMap((Function1 & Serializable)r -> this.$anonfun$7(r == null ? null : ((ServerModel.ReturnUri)r).value())).toList();
        if (redirect.nonEmpty()) {
            return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.TemporaryRedirect(), Gravity.Headers$.MODULE$.apply(redirect), GravityResponse$.MODULE$.$lessinit$greater$default$3());
        }
        return this.logoutForm(r$35.language());
    }

    private static final Gravity.Header toLocation$$anonfun$1(String s$4) {
        return Gravity.Header$.MODULE$.Location(s$4);
    }

    private static final Object ensureValidReturnUri$$anonfun$1$$anonfun$1(String uri$2) {
        return "Invalid return URL: " + uri$2;
    }

    private static final Option ensureValidReturnUri$$anonfun$2(String uri$3) {
        return Some$.MODULE$.apply((Object)new ServerModel.ReturnUri(uri$3));
    }

    private final Future codeRequestToClient$$anonfun$1(ServerModel.CodeRequest cr$5) {
        return this.clientdb.get(cr$5.clientId());
    }

    private static final Object codeRequestToClient$$anonfun$2$$anonfun$1(ServerModel.CodeRequest cr$7, ServerModel.ClientRecord client$2) {
        return "Invalid client redirect_uri: " + new ServerModel.RedirectUri(cr$7.redirectUri()) + " expected: " + new ServerModel.RedirectUri(client$2.redirectUri());
    }

    private static final Object codeRequestToClient$$anonfun$2$$anonfun$2(ServerModel.CodeRequest cr$8) {
        return "Invalid client_id " + new ServerModel.ClientId(cr$8.clientId());
    }

    private final String loginForm$$anonfun$1() {
        return this.genRnd();
    }

    private final Gravity.Header loginForm$$anonfun$2$$anonfun$1$$anonfun$1(ServerModel.CodeRequest r$38) {
        return this.buildCookie(r$38.cookie().value());
    }

    private final /* synthetic */ Task loginForm$$anonfun$2(ServerModel.CodeRequest r$36, ServerModel.ClientRecord client$3, boolean alreadyFailed$1, String rnd) {
        return this.serverState().setCodeRequest(ServerModel$CookieRnd$.MODULE$.apply(r$36.cookie(), rnd), r$36).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(() -> this.loginForm$$anonfun$2$$anonfun$1$$anonfun$1(r$36)).flatMap((Function1 & Serializable)cookie -> this.loginForm().buildForm(r$36.language(), client$3, rnd, alreadyFailed$1).map((Function1 & Serializable)_$8 -> _$8.withHeader(cookie)).map((Function1 & Serializable)reply -> reply));
        });
    }

    private static final Object sendJwt$$anonfun$1(IdToken idt$1) {
        return "Sending JWT: " + idt$1.toString();
    }

    public static final class AccessTokenInfo
    implements Product,
    Serializable {
        private final String access_token;
        private final String sub;
        private final String name;
        private final String preferred_username;

        public static AccessTokenInfo apply(String string, String string2, String string3, String string4) {
            return ServerHandler$AccessTokenInfo$.MODULE$.apply(string, string2, string3, string4);
        }

        public static AccessTokenInfo fromProduct(Product product) {
            return ServerHandler$AccessTokenInfo$.MODULE$.fromProduct(product);
        }

        public static AccessTokenInfo unapply(AccessTokenInfo accessTokenInfo) {
            return ServerHandler$AccessTokenInfo$.MODULE$.unapply(accessTokenInfo);
        }

        public AccessTokenInfo(String access_token, String sub, String name, String preferred_username) {
            this.access_token = access_token;
            this.sub = sub;
            this.name = name;
            this.preferred_username = preferred_username;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AccessTokenInfo)) return false;
            AccessTokenInfo accessTokenInfo = (AccessTokenInfo)object;
            String string = this.access_token();
            String string2 = accessTokenInfo.access_token();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.sub();
            String string4 = accessTokenInfo.sub();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.name();
            String string6 = accessTokenInfo.name();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.preferred_username();
            String string8 = accessTokenInfo.preferred_username();
            if (string7 == null) {
                if (string8 == null) return true;
                return false;
            } else {
                if (!string7.equals(string8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AccessTokenInfo;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "AccessTokenInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "access_token";
                }
                case 1: {
                    return "sub";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "preferred_username";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String access_token() {
            return this.access_token;
        }

        public String sub() {
            return this.sub;
        }

        public String name() {
            return this.name;
        }

        public String preferred_username() {
            return this.preferred_username;
        }

        public AccessTokenInfo copy(String access_token, String sub, String name, String preferred_username) {
            return new AccessTokenInfo(access_token, sub, name, preferred_username);
        }

        public String copy$default$1() {
            return this.access_token();
        }

        public String copy$default$2() {
            return this.sub();
        }

        public String copy$default$3() {
            return this.name();
        }

        public String copy$default$4() {
            return this.preferred_username();
        }

        public String _1() {
            return this.access_token();
        }

        public String _2() {
            return this.sub();
        }

        public String _3() {
            return this.name();
        }

        public String _4() {
            return this.preferred_username();
        }
    }

    public static final class ResourceOwnerInfo
    implements Product,
    Serializable {
        private final String access_token;
        private final String sub;
        private final String name;
        private final String email;
        private final String preferred_username;
        private final List groups;

        public static ResourceOwnerInfo apply(String string, String string2, String string3, String string4, String string5, List<String> list) {
            return ServerHandler$ResourceOwnerInfo$.MODULE$.apply(string, string2, string3, string4, string5, list);
        }

        public static ResourceOwnerInfo fromProduct(Product product) {
            return ServerHandler$ResourceOwnerInfo$.MODULE$.fromProduct(product);
        }

        public static ResourceOwnerInfo unapply(ResourceOwnerInfo resourceOwnerInfo) {
            return ServerHandler$ResourceOwnerInfo$.MODULE$.unapply(resourceOwnerInfo);
        }

        public ResourceOwnerInfo(String access_token, String sub, String name, String email, String preferred_username, List<String> groups) {
            this.access_token = access_token;
            this.sub = sub;
            this.name = name;
            this.email = email;
            this.preferred_username = preferred_username;
            this.groups = groups;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResourceOwnerInfo)) return false;
            ResourceOwnerInfo resourceOwnerInfo = (ResourceOwnerInfo)object;
            String string = this.access_token();
            String string2 = resourceOwnerInfo.access_token();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.sub();
            String string4 = resourceOwnerInfo.sub();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.name();
            String string6 = resourceOwnerInfo.name();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.email();
            String string8 = resourceOwnerInfo.email();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.preferred_username();
            String string10 = resourceOwnerInfo.preferred_username();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            List<String> list = this.groups();
            List<String> list2 = resourceOwnerInfo.groups();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResourceOwnerInfo;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "ResourceOwnerInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "access_token";
                }
                case 1: {
                    return "sub";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "email";
                }
                case 4: {
                    return "preferred_username";
                }
                case 5: {
                    return "groups";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String access_token() {
            return this.access_token;
        }

        public String sub() {
            return this.sub;
        }

        public String name() {
            return this.name;
        }

        public String email() {
            return this.email;
        }

        public String preferred_username() {
            return this.preferred_username;
        }

        public List<String> groups() {
            return this.groups;
        }

        public ResourceOwnerInfo copy(String access_token, String sub, String name, String email, String preferred_username, List<String> groups) {
            return new ResourceOwnerInfo(access_token, sub, name, email, preferred_username, groups);
        }

        public String copy$default$1() {
            return this.access_token();
        }

        public String copy$default$2() {
            return this.sub();
        }

        public String copy$default$3() {
            return this.name();
        }

        public String copy$default$4() {
            return this.email();
        }

        public String copy$default$5() {
            return this.preferred_username();
        }

        public List<String> copy$default$6() {
            return this.groups();
        }

        public String _1() {
            return this.access_token();
        }

        public String _2() {
            return this.sub();
        }

        public String _3() {
            return this.name();
        }

        public String _4() {
            return this.email();
        }

        public String _5() {
            return this.preferred_username();
        }

        public List<String> _6() {
            return this.groups();
        }
    }

    public static final class WebUserInfo
    implements Product,
    Serializable {
        private final String sub;
        private final String name;
        private final String email;
        private final String preferred_username;
        private final boolean elxsso_changePassword;
        private final List groups;

        public static WebUserInfo apply(String string, String string2, String string3, String string4, boolean bl, List<String> list) {
            return ServerHandler$WebUserInfo$.MODULE$.apply(string, string2, string3, string4, bl, list);
        }

        public static WebUserInfo fromProduct(Product product) {
            return ServerHandler$WebUserInfo$.MODULE$.fromProduct(product);
        }

        public static WebUserInfo unapply(WebUserInfo webUserInfo) {
            return ServerHandler$WebUserInfo$.MODULE$.unapply(webUserInfo);
        }

        public WebUserInfo(String sub, String name, String email, String preferred_username, boolean elxsso_changePassword, List<String> groups) {
            this.sub = sub;
            this.name = name;
            this.email = email;
            this.preferred_username = preferred_username;
            this.elxsso_changePassword = elxsso_changePassword;
            this.groups = groups;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sub()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.email()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.preferred_username()));
            n = Statics.mix((int)n, (int)(this.elxsso_changePassword() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.groups()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WebUserInfo)) return false;
            WebUserInfo webUserInfo = (WebUserInfo)object;
            if (this.elxsso_changePassword() != webUserInfo.elxsso_changePassword()) return false;
            String string = this.sub();
            String string2 = webUserInfo.sub();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = webUserInfo.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.email();
            String string6 = webUserInfo.email();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.preferred_username();
            String string8 = webUserInfo.preferred_username();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            List<String> list = this.groups();
            List<String> list2 = webUserInfo.groups();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WebUserInfo;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "WebUserInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "sub";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "email";
                }
                case 3: {
                    return "preferred_username";
                }
                case 4: {
                    return "elxsso_changePassword";
                }
                case 5: {
                    return "groups";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String sub() {
            return this.sub;
        }

        public String name() {
            return this.name;
        }

        public String email() {
            return this.email;
        }

        public String preferred_username() {
            return this.preferred_username;
        }

        public boolean elxsso_changePassword() {
            return this.elxsso_changePassword;
        }

        public List<String> groups() {
            return this.groups;
        }

        public WebUserInfo copy(String sub, String name, String email, String preferred_username, boolean elxsso_changePassword, List<String> groups) {
            return new WebUserInfo(sub, name, email, preferred_username, elxsso_changePassword, groups);
        }

        public String copy$default$1() {
            return this.sub();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String copy$default$3() {
            return this.email();
        }

        public String copy$default$4() {
            return this.preferred_username();
        }

        public boolean copy$default$5() {
            return this.elxsso_changePassword();
        }

        public List<String> copy$default$6() {
            return this.groups();
        }

        public String _1() {
            return this.sub();
        }

        public String _2() {
            return this.name();
        }

        public String _3() {
            return this.email();
        }

        public String _4() {
            return this.preferred_username();
        }

        public boolean _5() {
            return this.elxsso_changePassword();
        }

        public List<String> _6() {
            return this.groups();
        }
    }
}

