/*
 * Decompiled with CFR 0.152.
 */
package ambience.task.manager;

import ambience.api.BinaryStore;
import ambience.api.Messages;
import ambience.module.Module;
import ambience.module.ProjectConfig;
import ambience.module.UserDB;
import ambience.task.Add;
import ambience.task.Attachment;
import ambience.task.Attachment$;
import ambience.task.Blocker;
import ambience.task.Collections$;
import ambience.task.DependencySorter$;
import ambience.task.DependentLinkedTask;
import ambience.task.DependentLinkedTaskBuilder$;
import ambience.task.History;
import ambience.task.History$;
import ambience.task.Label;
import ambience.task.Label$;
import ambience.task.LinkedTask;
import ambience.task.LinkedTaskBuilder$;
import ambience.task.Part;
import ambience.task.Part$;
import ambience.task.PartIdName;
import ambience.task.PartTree;
import ambience.task.Status;
import ambience.task.TaskView;
import ambience.task.TaskView$;
import ambience.task.Update;
import ambience.task.UpdateUtil$;
import ambience.task.WatcherSupport$;
import ambience.task.manager.CommentsManager$;
import ambience.task.manager.ContainerManager$;
import ambience.task.manager.PartBuilder$;
import ambience.task.manager.PartIdNameBuilder$;
import ambience.task.manager.TaskManagerModule$;
import ambience.task.manager.TreeBuilder$;
import ambience.task.manager.Updater$;
import ambience.task.view.LogsManager$;
import cats.Alternative;
import cats.Bifoldable;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.EitherIdOps$;
import cats.syntax.SeparateOps;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.mongodb.client.result.InsertOneResult;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Updates$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ContentsManager$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(ContentsManager$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ContentsManager$.class.getDeclaredField("OptStoreT$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ContentsManager$.class.getDeclaredField("WebURL$lzy1"));
    private volatile Object log$lzy1;
    private static final Either RightLogMessageNone;
    private volatile Object WebURL$lzy1;
    private volatile Object OptStoreT$lzy1;
    public static final ContentsManager$ MODULE$;

    private ContentsManager$() {
    }

    static {
        MODULE$ = new ContentsManager$();
        RightLogMessageNone = scala.package$.MODULE$.Right().apply((Object)LogMessage.None$.MODULE$);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ContentsManager$.class);
    }

    public Either<LogMessage, LogMessage> RightLogMessageNone() {
        return RightLogMessageNone;
    }

    public String WebURL() {
        Object object = this.WebURL$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.WebURL$lzyINIT1();
    }

    private Object WebURL$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.WebURL$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ((ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class))).WebURL();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.WebURL$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Bson buildFilter(Update.PartInfo partInfo) {
        return Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("_id", (Object)partInfo.partId()), Filters$.MODULE$.eq("containerId", (Object)partInfo.containerId())}));
    }

    public Task<Either<LogMessage, BinaryStore.Location>> OptStoreT() {
        Object object = this.OptStoreT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.OptStoreT$lzyINIT1();
    }

    private Object OptStoreT$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.OptStoreT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        ProjectConfig projectConfig = (ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class));
                        String locId = projectConfig.config().getString("ambience.modules.task-manager.binary-store");
                        Task optStore = ((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(BinaryStore.LocationId$.MODULE$.apply(locId));
                        task = optStore.map((Function1 & Serializable)x$1 -> {
                            Option option = x$1;
                            if (option instanceof Some) {
                                BinaryStore.Location store = (BinaryStore.Location)((Some)option).value();
                                this.log().info(() -> this.OptStoreT$lzyINIT1$$anonfun$1$$anonfun$1(locId), Line$.MODULE$.apply(57), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.OptStoreT"));
                                return scala.package$.MODULE$.Right().apply((Object)store);
                            }
                            if (None$.MODULE$.equals(option)) {
                                this.log().error(() -> this.OptStoreT$lzyINIT1$$anonfun$1$$anonfun$2(locId), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.OptStoreT"));
                                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("No binary store available"));
                            }
                            throw new MatchError((Object)option);
                        }).memoize();
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.OptStoreT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.OptStoreT$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<LogMessage, PartTree>> getPartTree(UserDB.User user, String containerId) {
        return ContainerManager$.MODULE$.getContainerO(user, containerId).firstOptionL().flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                this.log().debug(() -> this.getPartTree$$anonfun$1$$anonfun$1(containerId), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.getPartTree"));
                Task docs = Collections$.MODULE$.contentsCltn().findO(Filters$.MODULE$.eq("containerId", (Object)containerId)).toListL();
                return docs.map((Function1 & Serializable)list -> {
                    Tuple2 tuple2 = new SeparateOps(implicits$.MODULE$.catsSyntaxAlternativeSeparate((Object)list.map((Function1 & Serializable)_$1 -> PartBuilder$.MODULE$.apply((Document)_$1, false)))).separate((FlatMap)implicits$.MODULE$.catsStdInstancesForList(), (Alternative)implicits$.MODULE$.catsStdInstancesForList(), (Bifoldable)implicits$.MODULE$.catsStdBitraverseForEither());
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    List left = (List)tuple2._1();
                    List right = (List)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)left, (Object)right);
                    List left2 = (List)tuple22._1();
                    List right2 = (List)tuple22._2();
                    this.log().debug(() -> this.getPartTree$$anonfun$1$$anonfun$2$$anonfun$1(list, left2, right2), Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.getPartTree"));
                    if (left2.nonEmpty()) {
                        scala.package$.MODULE$.Left().apply((Object)LogMessage.LogMessageList$.MODULE$.apply(left2));
                    }
                    return TreeBuilder$.MODULE$.build(containerId, (Vector<Part>)right2.toVector());
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Container " + containerId + " not available")));
            }
            throw new MatchError((Object)option);
        });
    }

    public Observable<Part> getParts(UserDB.User user, String containerId, String parentId) {
        return ContainerManager$.MODULE$.getContainerO(user, containerId).flatMap((Function1 & Serializable)x$12 -> {
            Json json = x$12;
            BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
            this.log().debug(() -> this.getParts$$anonfun$1$$anonfun$1(containerId, parentId), Line$.MODULE$.apply(83), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.getParts"));
            boxedUnitArray[0] = BoxedUnit.UNIT;
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Collections$.MODULE$.contentsCltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("containerId", (Object)containerId), Filters$.MODULE$.eq("parentId", (Object)parentId)}))).flatMap((Function1 & Serializable)doc -> {
                    Observable observable;
                    Either<LogMessage, Part> either = PartBuilder$.MODULE$.apply((Document)doc, false);
                    if (either instanceof Right) {
                        Part part2 = (Part)((Right)either).value();
                        observable = Observable$.MODULE$.now((Object)part2);
                    } else if (either instanceof Left) {
                        LogMessage err = (LogMessage)((Left)either).value();
                        this.log().error(() -> this.getParts$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(user, containerId, parentId, err), Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.getParts"));
                        observable = Observable$.MODULE$.empty();
                    } else {
                        throw new MatchError(either);
                    }
                    return observable.map((Function1 & Serializable)part -> part);
                });
            });
        });
    }

    public Observable<PartIdName> getPartIdNames(UserDB.User user, String containerId, String parentId) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("containerId", (Object)containerId), Filters$.MODULE$.eq("parentId", (Object)parentId)}));
        return ContainerManager$.MODULE$.getContainerO(user, containerId).flatMap((Function1 & Serializable)x$12 -> {
            Json json = x$12;
            BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
            this.log().debug(() -> this.getPartIdNames$$anonfun$1$$anonfun$1(containerId, parentId), Line$.MODULE$.apply(98), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.getPartIdNames"));
            boxedUnitArray[0] = BoxedUnit.UNIT;
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Collections$.MODULE$.contentsCltn().findO(filter, FindOptions$.MODULE$.projections(PartIdNameBuilder$.MODULE$.projection())).flatMap((Function1 & Serializable)doc -> {
                    Observable observable;
                    Either<LogMessage, PartIdName> either = PartIdNameBuilder$.MODULE$.apply((Document)doc);
                    if (either instanceof Right) {
                        PartIdName part2 = (PartIdName)((Right)either).value();
                        observable = Observable$.MODULE$.now((Object)part2);
                    } else if (either instanceof Left) {
                        LogMessage err = (LogMessage)((Left)either).value();
                        this.log().error(() -> this.getPartIdNames$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(user, containerId, parentId, err), Line$.MODULE$.apply(103), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.getPartIdNames"));
                        observable = Observable$.MODULE$.empty();
                    } else {
                        throw new MatchError(either);
                    }
                    return observable.map((Function1 & Serializable)part -> part);
                });
            });
        });
    }

    public Observable<Update.PartInfo> getPartInfosByName(UserDB.User user, String containerId, String parentId, String partName) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("containerId", (Object)containerId), Filters$.MODULE$.eq("parentId", (Object)parentId), Filters$.MODULE$.eq("name", (Object)partName)}));
        return ContainerManager$.MODULE$.getContainerO(user, containerId).flatMap((Function1 & Serializable)x$12 -> {
            Json json = x$12;
            BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
            this.log().debug(() -> this.getPartInfosByName$$anonfun$1$$anonfun$1(containerId, partName), Line$.MODULE$.apply(117), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.getPartInfosByName"));
            boxedUnitArray[0] = BoxedUnit.UNIT;
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Collections$.MODULE$.contentsCltn().findO(filter).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)bs -> Update.PartInfo$.MODULE$.apply(containerId, bs.getValue())))).map((Function1 & Serializable)part -> part));
            });
        });
    }

    public Task<Option<TaskView>> getTaskView(UserDB.User user, String partId) {
        BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
        this.log().info(() -> this.$anonfun$2(partId), Line$.MODULE$.apply(125), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.ret"));
        boxedUnitArray[0] = BoxedUnit.UNIT;
        Observable ret = Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Collections$.MODULE$.contentsCltn().findO(Filters$.MODULE$.eq("_id", (Object)partId)).flatMap((Function1 & Serializable)doc -> {
                Observable observable;
                Either<LogMessage, Part> either = PartBuilder$.MODULE$.apply((Document)doc, true);
                if (either instanceof Right) {
                    Part part2 = (Part)((Right)either).value();
                    observable = Observable$.MODULE$.now((Object)part2);
                } else if (either instanceof Left) {
                    LogMessage err = (LogMessage)((Left)either).value();
                    this.log().error(() -> this.$anonfun$3$$anonfun$1$$anonfun$1(user, partId, err), Line$.MODULE$.apply(130), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.ret"));
                    observable = Observable$.MODULE$.empty();
                } else {
                    throw new MatchError(either);
                }
                return observable.flatMap((Function1 & Serializable)part -> ContainerManager$.MODULE$.getContainerO(user, part.containerId()).flatMap((Function1 & Serializable)tcJson -> this.getParentView((Part)part).flatMap((Function1 & Serializable)parentTask -> this.getBlockerView((Part)part).flatMap((Function1 & Serializable)blockerTask -> Observable$.MODULE$.fromTask(Collections$.MODULE$.contentsCltn().findO(Filters$.MODULE$.eq("parentId", (Object)partId)).toListL().map((Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)_$3 -> DependentLinkedTaskBuilder$.MODULE$.apply((Document)_$3)))).flatMap((Function1 & Serializable)subTasks -> Observable$.MODULE$.fromTask(Collections$.MODULE$.contentsCltn().findO(Filters$.MODULE$.eq("blockers", (Object)partId)).toListL().map((Function1 & Serializable)_$4 -> _$4.flatMap((Function1 & Serializable)_$5 -> LinkedTaskBuilder$.MODULE$.apply((Document)_$5)))).flatMap((Function1 & Serializable)blockedTasks -> Observable$.MODULE$.fromTask(CommentsManager$.MODULE$.loadCommentsT(partId)).map((Function1 & Serializable)comments -> TaskView$.MODULE$.apply((String)tcJson.hcursor().downField("name").as(Decoder$.MODULE$.decodeString()).getOrElse(this::$anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1), part, parentTask, blockerTask, this.sort((List<DependentLinkedTask>)subTasks), blockedTasks, comments))))))));
            });
        });
        return ret.firstOptionL();
    }

    public List<LinkedTask> sort(List<DependentLinkedTask> tasks) {
        Either either = DependencySorter$.MODULE$.sort(tasks.toVector());
        if (either instanceof Right) {
            Vector v = (Vector)((Right)either).value();
            return ((IterableOnceOps)v.map((Function1 & Serializable)_$6 -> _$6.asLinkedTask())).toList();
        }
        if (either instanceof Left) {
            String err = (String)((Left)either).value();
            this.log().error(() -> this.sort$$anonfun$2(err), Line$.MODULE$.apply(164), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.sort"));
            return tasks.map((Function1 & Serializable)_$7 -> _$7.asLinkedTask());
        }
        throw new MatchError((Object)either);
    }

    public Observable<Option<LinkedTask>> getParentView(Part part) {
        String string = part.parentId();
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return Observable$.MODULE$.fromTask(this.getLinkedTask(part.parentId()));
        }
        return Observable$.MODULE$.now((Object)None$.MODULE$);
    }

    public Observable<Option<LinkedTask>> getBlockerView(Part part) {
        Option option = part.blockers().headOption();
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            String blocker = object == null ? null : ((Blocker)object).id();
            return Observable$.MODULE$.fromTask(Collections$.MODULE$.contentsCltn().findO(Filters$.MODULE$.eq("_id", (Object)blocker)).firstOptionL().map((Function1 & Serializable)_$8 -> _$8.flatMap((Function1 & Serializable)_$9 -> LinkedTaskBuilder$.MODULE$.apply((Document)_$9))));
        }
        if (None$.MODULE$.equals(option)) {
            return Observable$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Task<Option<LinkedTask>> getLinkedTask(String partId) {
        return Collections$.MODULE$.contentsCltn().findO(Filters$.MODULE$.eq("_id", (Object)partId)).firstOptionL().map((Function1 & Serializable)_$10 -> _$10.flatMap((Function1 & Serializable)_$11 -> LinkedTaskBuilder$.MODULE$.apply((Document)_$11)));
    }

    public Task<LogMessage> add(UserDB.User user, Add addInfo) {
        EitherT ret = this.logET((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$4(addInfo))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(ContainerManager$.MODULE$.getContainerT(user, addInfo.containerId())).flatMap((Function1 & Serializable)x$1 -> {
                Json json = x$1;
                return EitherT$.MODULE$.apply(this.isValidPartT(addInfo.containerId(), addInfo.parentId())).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(this.isValidPartT(addInfo.containerId(), addInfo.dependsOnId())).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return EitherT$.MODULE$.apply(this.doAdd(user, addInfo)).flatMap((Function1 & Serializable)partId -> {
                            BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT);
                            return EitherT$.MODULE$.apply((Object)WatcherSupport$.MODULE$.setWatchers((String)partId, addInfo.description()).as((Object)EitherIdOps$.MODULE$.asRight$extension((Object)boxedUnit))).map((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return LogMessage.None$.MODULE$;
                            }, (Functor)Task$.MODULE$.catsAsync());
                        }, (Monad)Task$.MODULE$.catsAsync());
                    }, (Monad)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync());
        return ((Task)ret.value()).map((Function1 & Serializable)_$12 -> {
            Either either = Either$.MODULE$.MergeableEither(_$12);
            return (LogMessage)Either.MergeableEither$.MODULE$.merge$extension(either);
        });
    }

    public Task<LogMessage> applyUpdate(UserDB.User user, Update.UpdateYMD updateYmd) {
        Update update = updateYmd.update();
        EitherT ret = this.logET((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$6(update))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(ContainerManager$.MODULE$.getContainerT(user, update.part().containerId())).flatMap((Function1 & Serializable)x$1 -> {
                Json json = x$1;
                return EitherT$.MODULE$.apply(this.doApplyUpdate(user, update)).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(this.doUpdateUserLogs(user, updateYmd)).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return LogMessage.None$.MODULE$;
                    }, (Functor)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync());
        return ((Task)ret.value()).map((Function1 & Serializable)_$13 -> {
            Either either = Either$.MODULE$.MergeableEither(_$13);
            return (LogMessage)Either.MergeableEither$.MODULE$.merge$extension(either);
        });
    }

    public Task<LogMessage> addAttachment(UserDB.User user, String containerId, String partId, Gravity.FileUploadItem file) {
        Object[] objectArray = new Option[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"user");
        objectArray[0] = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)user.name()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
        objectArray[1] = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)file.filename()));
        objectArray[2] = file.optContentType().map((Function1 & Serializable)mt -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, mt);
        });
        List md = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Json metadata = Json$.MODULE$.fromFields((Iterable)((List)md.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)pair -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(pair._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString((String)pair._2()));
        }));
        EitherT ret = this.logET((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$10(containerId, partId, file))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(this.OptStoreT()).flatMap((Function1 & Serializable)store -> EitherT$.MODULE$.apply(ContainerManager$.MODULE$.getContainerT(user, containerId)).flatMap((Function1 & Serializable)x$12 -> {
                Json json = x$12;
                return EitherT$.MODULE$.apply(this.isRequiredValidPartT(containerId, partId, "attachment")).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)scala.package$.MODULE$.Right().apply((Object)metadata))).flatMap((Function1 & Serializable)metadata -> EitherT$.MODULE$.apply(this.createAttachment((BinaryStore.Location)store, file, (Json)metadata)).flatMap((Function1 & Serializable)attachment -> EitherT$.MODULE$.apply(this.doApplyUpdate(user, (Update)Update.AddAttachment$.MODULE$.apply(Update.PartInfo$.MODULE$.apply(containerId, partId), attachment))).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return LogMessage.None$.MODULE$;
                    }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync());
        return ((Task)ret.value()).map((Function1 & Serializable)_$14 -> {
            Either either = Either$.MODULE$.MergeableEither(_$14);
            return (LogMessage)Either.MergeableEither$.MODULE$.merge$extension(either);
        });
    }

    public Task<LogMessage> deleteAttachment(UserDB.User user, String containerId, String partId, Attachment a) {
        EitherT ret = EitherT$.MODULE$.apply(this.loadStore(a.store())).flatMap((Function1 & Serializable)store -> this.logET((Function0<String>)((Function0 & Serializable)() -> this.$anonfun$12$$anonfun$1(containerId, partId, a))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply((Object)store.remove(BinaryStore.ContentId$.MODULE$.apply(a.contentId())).as(this.RightLogMessageNone())).flatMap((Function1 & Serializable)x$12 -> {
                LogMessage logMessage = x$12;
                return EitherT$.MODULE$.apply(this.doApplyUpdate(user, (Update)Update.RemoveAttachment$.MODULE$.apply(Update.PartInfo$.MODULE$.apply(containerId, partId), a))).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return LogMessage.None$.MODULE$;
                }, (Functor)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)ret.value()).map((Function1 & Serializable)_$15 -> {
            Either either = Either$.MODULE$.MergeableEither(_$15);
            return (LogMessage)Either.MergeableEither$.MODULE$.merge$extension(either);
        });
    }

    public Task<Either<LogMessage, String>> doAdd(UserDB.User user, Add add) {
        return Task$.MODULE$.apply(this::doAdd$$anonfun$1).flatMap((Function1 & Serializable)uuid -> Task$.MODULE$.apply(() -> this.doAdd$$anonfun$2$$anonfun$1(user, uuid, add)).flatMap((Function1 & Serializable)doc -> this.updateDependsOnId(add.containerId(), add.dependsOnId(), (String)uuid).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Collections$.MODULE$.contentsCltn().insertOneT(doc).map((Function1 & Serializable)x$1 -> {
                InsertOneResult insertOneResult = x$1;
                return scala.package$.MODULE$.Right().apply(uuid);
            });
        })));
    }

    public Task<Either<LogMessage, BoxedUnit>> doApplyUpdate(UserDB.User user, Update update) {
        return Updater$.MODULE$.apply(user, update);
    }

    public Task<Either<LogMessage, BoxedUnit>> doUpdateUserLogs(UserDB.User user, Update.UpdateYMD update) {
        Update update2 = update.update();
        if (update2 instanceof Update.SetStatus) {
            Update.SetStatus ss = (Update.SetStatus)update2;
            this.log().info(() -> this.doUpdateUserLogs$$anonfun$1(ss), Line$.MODULE$.apply(251), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.doUpdateUserLogs"));
            Status status = ss.value();
            if (Status.InProgress$.MODULE$.equals(status)) {
                return LogsManager$.MODULE$.logActivity(update).map((Function1 & Serializable)_$16 -> scala.package$.MODULE$.Right().apply(_$16));
            }
            if (Status.Completed$.MODULE$.equals(status)) {
                return LogsManager$.MODULE$.logCompletion(update).map((Function1 & Serializable)_$17 -> scala.package$.MODULE$.Right().apply(_$17));
            }
            return Task$.MODULE$.apply(this::doUpdateUserLogs$$anonfun$4);
        }
        return Task$.MODULE$.apply(this::doUpdateUserLogs$$anonfun$5);
    }

    public Task<BoxedUnit> updateDependsOnId(String containerId, String was, String now) {
        String string = was;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Task$.MODULE$.unit();
        }
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("containerId", (Object)containerId), Filters$.MODULE$.eq("dependsOnId", (Object)was)}));
        Bson updateDoc = Updates$.MODULE$.set("dependsOnId", (Object)now);
        return Collections$.MODULE$.contentsCltn().updateOneT(filter, updateDoc).void();
    }

    public Document buildAddDoc(String username, String uuid, Add add) {
        Set set = (Set)add.labels().map((Function1 & Serializable)_$18 -> new Label(this.$anonfun$13((String)_$18)));
        Vector vector = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new History[]{History$.MODULE$.apply(username, System.currentTimeMillis(), "Added", (Option)Some$.MODULE$.apply((Object)Status.NotStarted$.MODULE$.id()))}));
        Vector vector2 = Part$.MODULE$.$lessinit$greater$default$9();
        Vector vector3 = Part$.MODULE$.$lessinit$greater$default$10();
        Vector vector4 = Part$.MODULE$.$lessinit$greater$default$16();
        Status status = Part$.MODULE$.$lessinit$greater$default$17();
        Set set2 = Part$.MODULE$.$lessinit$greater$default$18();
        Part part = Part$.MODULE$.apply(uuid, add.containerId(), add.parentId(), add.dependsOnId(), add.name(), set, add.description(), add.priority(), vector2, vector3, vector, username, add.estimatedTimeUnits(), add.actualTimeUnits(), add.dueDate(), vector4, status, set2);
        Part part2 = (Part)package$.MODULE$.EncoderOps((Object)part);
        return Document$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)part2, Part$.MODULE$.encoder()).noSpaces());
    }

    public Task<Either<LogMessage, Attachment>> createAttachment(BinaryStore.Location store, Gravity.FileUploadItem item, Json metadata) {
        return store.add(BinaryStore.Content$.MODULE$.apply((DataBytes)item.data(), metadata)).map((Function1 & Serializable)contentId -> this.createAttachment$$anonfun$1(item, store, contentId == null ? null : ((BinaryStore.ContentId)contentId).value()));
    }

    public Task<Either<LogMessage, BoxedUnit>> addHistory(UserDB.User user, String partId, String what) {
        Bson filter = Filters$.MODULE$.eq("_id", (Object)partId);
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"who");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(user.name())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"when");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"what");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)what), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        Document doc = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Bson update = Updates$.MODULE$.push("history", (Object)doc);
        return Collections$.MODULE$.contentsCltn().updateOneT(filter, update).map((Function1 & Serializable)reply -> {
            if (reply.getModifiedCount() == 1L) {
                return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Cannot update part history"));
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> notifyWatchers(UserDB.User user, String partId, String what) {
        EitherT result = EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.$anonfun$14(user, partId, what))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply((Object)WatcherSupport$.MODULE$.getUserNameToIdMap().map((Function1 & Serializable)_$19 -> {
                Map map = (Map)implicits$.MODULE$.catsSyntaxEitherId(_$19);
                return EitherIdOps$.MODULE$.asRight$extension((Object)map);
            })).flatMap((Function1 & Serializable)userMap -> EitherT$.MODULE$.apply(this.buildMessage(user, partId, what, (Map<String, String>)userMap)).flatMap((Function1 & Serializable)message -> EitherT$.MODULE$.apply(this.sendMessage((Messages.Message)message)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync());
        return (Task)result.value();
    }

    public Task<Either<LogMessage, Messages.Message>> buildMessage(UserDB.User user, String partId, String what, Map<String, String> userNameToIdMap) {
        Bson filter = Filters$.MODULE$.eq("_id", (Object)partId);
        return Collections$.MODULE$.contentsCltn().findO(filter).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                List<String> watchers = WatcherSupport$.MODULE$.getWatchers(doc);
                this.log().info(() -> this.buildMessage$$anonfun$1$$anonfun$1(watchers, what, user), Line$.MODULE$.apply(327), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.buildMessage"));
                String name = (String)doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$20 -> _$20.getValue()).getOrElse(this::$anonfun$17);
                String subject = "Ambience Task: " + name;
                String link = this.WebURL() + "/task-view/" + partId + "/index.html";
                String body = "<div><div>Change: " + what + "</div><div>Link: <a href='" + link + "'>" + UpdateUtil$.MODULE$.escape(name) + "</a></div></div>";
                Set userIds = (Set)watchers.toSet().$minus((Object)user.name()).flatMap((Function1 & Serializable)key -> userNameToIdMap.get(key));
                return scala.package$.MODULE$.Right().apply((Object)Messages.Message$.MODULE$.apply(userIds, Messages.Message$.MODULE$.$lessinit$greater$default$2(), Messages.Message$.MODULE$.$lessinit$greater$default$3(), subject, body, Messages.Message$.MODULE$.$lessinit$greater$default$6()));
            }
            if (None$.MODULE$.equals(option)) {
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Part " + partId + " not found"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> sendMessage(Messages.Message msg) {
        if (msg.to().isEmpty()) {
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }
        BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT);
        return ((Messages)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Messages.class))).send((Module)TaskManagerModule$.MODULE$.instance(), msg).as((Object)EitherIdOps$.MODULE$.asRight$extension((Object)boxedUnit));
    }

    public Task<Either<LogMessage, BoxedUnit>> addWatchersFromComment(UserDB.User user, String partId, String comment) {
        return WatcherSupport$.MODULE$.setWatchers(partId, comment).as((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Task<Either<LogMessage, BoxedUnit>> isRequiredValidPartT(String containerId, String partId, String component) {
        if (partId.isEmpty()) {
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Empty partId not allowed for " + component)));
        }
        return this.isValidPartT(containerId, partId);
    }

    public Task<Either<LogMessage, BoxedUnit>> isValidPartT(String containerId, String partId) {
        if (partId.isEmpty()) {
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }
        Bson filter = this.buildFilter(Update.PartInfo$.MODULE$.apply(containerId, partId));
        FindOptions options = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id"})));
        return Collections$.MODULE$.contentsCltn().findO(filter, options).firstOptionL().map((Function1 & Serializable)list -> {
            if (list.isEmpty()) {
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Part " + partId + " not found"));
            }
            return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
    }

    public EitherT<Task, LogMessage, BoxedUnit> logET(Function0<String> msg) {
        return EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.logET$$anonfun$1(msg)));
    }

    public Task<Either<LogMessage, BinaryStore.Location>> loadStore(String locId) {
        return ((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(BinaryStore.LocationId$.MODULE$.apply(locId)).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Location store = (BinaryStore.Location)((Some)option).value();
                return scala.package$.MODULE$.Right().apply((Object)store);
            }
            if (None$.MODULE$.equals(option)) {
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Binary store " + locId + " not found"));
            }
            throw new MatchError((Object)option);
        });
    }

    private final Object OptStoreT$lzyINIT1$$anonfun$1$$anonfun$1(String locId$2) {
        return "Using binary store " + locId$2;
    }

    private final Object OptStoreT$lzyINIT1$$anonfun$1$$anonfun$2(String locId$3) {
        return "Binary store " + locId$3 + " not found";
    }

    private final Object getPartTree$$anonfun$1$$anonfun$1(String containerId$2) {
        return "getPartTree loading " + containerId$2;
    }

    private final Object getPartTree$$anonfun$1$$anonfun$2$$anonfun$1(List list$1, List left$1, List right$1) {
        return "getPartTree loaded " + list$1.length() + " parts (" + left$1.length() + "/" + right$1.length() + ")";
    }

    private final Object getParts$$anonfun$1$$anonfun$1(String containerId$5, String parentId$2) {
        return "getParts loading " + containerId$5 + " with parentId=" + parentId$2;
    }

    private final Object getParts$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(UserDB.User user$4, String containerId$8, String parentId$5, LogMessage err$1) {
        return "getParts(" + user$4.name() + "," + containerId$8 + "," + parentId$5 + "): " + err$1;
    }

    private final Object getPartIdNames$$anonfun$1$$anonfun$1(String containerId$10, String parentId$7) {
        return "getPartIdNames loading " + containerId$10 + " with parentId=" + parentId$7;
    }

    private final Object getPartIdNames$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(UserDB.User user$8, String containerId$13, String parentId$10, LogMessage err$2) {
        return "getPartIdNames(" + user$8.name() + "," + containerId$13 + "," + parentId$10 + "): " + err$2;
    }

    private final Object getPartInfosByName$$anonfun$1$$anonfun$1(String containerId$15, String partName$2) {
        return "getParts loading " + containerId$15 + " with part name=" + partName$2;
    }

    private final Object $anonfun$2(String partId$1) {
        return "getTaskView loading " + partId$1;
    }

    private final Object $anonfun$3$$anonfun$1$$anonfun$1(UserDB.User user$11, String partId$4, LogMessage err$3) {
        return "getPart(" + user$11.name() + "," + partId$4 + "): " + err$3;
    }

    private final String $anonfun$3$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "";
    }

    private final Object sort$$anonfun$2(String err$4) {
        return "Can't sort tasks: " + err$4;
    }

    private final String $anonfun$4(Add addInfo$1) {
        return "Adding child of " + addInfo$1.containerId() + ":" + addInfo$1.parentId() + " " + addInfo$1.name();
    }

    private final String $anonfun$6(Update update$1) {
        return "Updating " + update$1.part().containerId() + ":" + update$1.part().partId() + " " + update$1.typeId();
    }

    private final String $anonfun$10(String containerId$19, String partId$11, Gravity.FileUploadItem file$1) {
        return "Adding attachment to " + containerId$19 + ":" + partId$11 + " " + file$1.name() + " (" + file$1.length() + " bytes)";
    }

    private final String $anonfun$12$$anonfun$1(String containerId$27, String partId$19, Attachment a$2) {
        return "Removing attachment from " + containerId$27 + ":" + partId$19 + " " + a$2.filename() + " (" + a$2.length() + " bytes)";
    }

    private final String doAdd$$anonfun$1() {
        return UUID.randomUUID().toString();
    }

    private final Document doAdd$$anonfun$2$$anonfun$1(UserDB.User user$30, String uuid$1, Add add$2) {
        return this.buildAddDoc(user$30.name(), uuid$1, add$2);
    }

    private final Object doUpdateUserLogs$$anonfun$1(Update.SetStatus ss$1) {
        return "Updating user logs with " + ss$1.value();
    }

    private final Right doUpdateUserLogs$$anonfun$4() {
        return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final Right doUpdateUserLogs$$anonfun$5() {
        return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final /* synthetic */ String $anonfun$13(String _$18) {
        return Label$.MODULE$.apply(_$18);
    }

    private final /* synthetic */ Right createAttachment$$anonfun$1(Gravity.FileUploadItem item$1, BinaryStore.Location store$5, String contentId) {
        return scala.package$.MODULE$.Right().apply((Object)Attachment$.MODULE$.apply(item$1.filename(), item$1.length(), store$5.id(), contentId));
    }

    private final Object $anonfun$14$$anonfun$1(UserDB.User user$32, String partId$23, String what$2) {
        return "notifyWatchers(" + user$32.name() + ", " + partId$23 + ", " + what$2 + ")";
    }

    private final Either $anonfun$14(UserDB.User user$31, String partId$22, String what$1) {
        this.log().info(() -> this.$anonfun$14$$anonfun$1(user$31, partId$22, what$1), Line$.MODULE$.apply(309), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.result"));
        BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT);
        return EitherIdOps$.MODULE$.asRight$extension((Object)boxedUnit);
    }

    private final Object buildMessage$$anonfun$1$$anonfun$1(List watchers$2, String what$5, UserDB.User user$35) {
        return "Notifying watchers: " + ((IterableOnceOps)watchers$2.sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).mkString(",") + ": of action " + what$5 + " by " + user$35.name();
    }

    private final String $anonfun$17() {
        return "<unknown>";
    }

    private final Either logET$$anonfun$1(Function0 msg$1) {
        Right$ right$ = scala.package$.MODULE$.Right();
        this.log().info(msg$1, Line$.MODULE$.apply(365), FullName$.MODULE$.apply("ambience.task.manager.ContentsManager.logET"));
        return right$.apply((Object)BoxedUnit.UNIT);
    }
}

