/*
 * Decompiled with CFR 0.152.
 */
package ambience.task.manager;

import ambience.module.UserDB;
import ambience.task.Collections$;
import ambience.task.PartTree;
import ambience.task.PartTreeItem;
import ambience.task.Status;
import ambience.task.Update;
import ambience.task.manager.ContentsManager$;
import ambience.task.manager.DefaultUpdater$;
import ambience.task.manager.PartTreeUtils$;
import ambience.task.manager.UpdateBuilder$;
import ambience.task.manager.Updater;
import ambience.task.manager.Updater$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT$;
import com.elixirtech.arch.LogMessage;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class StatusUpdater$
implements Updater,
Serializable {
    public static final StatusUpdater$ MODULE$ = new StatusUpdater$();

    private StatusUpdater$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StatusUpdater$.class);
    }

    @Override
    public Task<Either<LogMessage, BoxedUnit>> doUpdate(UserDB.User user, Update update) {
        Update update2 = update;
        if (update2 instanceof Update.SetStatus) {
            Update.SetStatus ss = (Update.SetStatus)update2;
            return this.doUpdateSetStatus(user, ss);
        }
        return Task$.MODULE$.apply(this::doUpdate$$anonfun$1);
    }

    public Task<Either<LogMessage, BoxedUnit>> doUpdateSetStatus(UserDB.User user, Update.SetStatus ss) {
        Status status = ss.value();
        if (Status.NotStarted$.MODULE$.equals(status)) {
            return Task$.MODULE$.apply(this::doUpdateSetStatus$$anonfun$1);
        }
        if (Status.Completed$.MODULE$.equals(status)) {
            return this.checkAssignment(user, (Update)ss).flatMap((Function1 & Serializable)x$12 -> {
                Either either = x$12;
                return this.checkSubTasksCompletedOrCancelled(user, (Update)ss).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    return this.doDefaultUpdate(user, ss).flatMap((Function1 & Serializable)ret -> this.markParentsPausedIfNotStarted(user, ss).flatMap((Function1 & Serializable)x$1 -> {
                        Either either = x$1;
                        return this.removeAnyBlockStatuses(user, ss).flatMap((Function1 & Serializable)x$12 -> {
                            Either either = x$12;
                            return this.removeAnyBlockers(user, ss).map((Function1 & Serializable)x$1 -> {
                                Either either = x$1;
                                return ret;
                            });
                        });
                    }));
                });
            });
        }
        if (Status.InProgress$.MODULE$.equals(status)) {
            return this.checkAssignment(user, (Update)ss).flatMap((Function1 & Serializable)x$12 -> {
                Either either = x$12;
                return this.pauseAnyActiveTasks(user, (Update)ss).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    return this.doDefaultUpdate(user, ss).flatMap((Function1 & Serializable)ret -> this.markParentsPausedIfNotStarted(user, ss).flatMap((Function1 & Serializable)x$12 -> {
                        Either either = x$12;
                        return this.removeAnyBlockers(user, ss).map((Function1 & Serializable)x$1 -> {
                            Either either = x$1;
                            return ret;
                        });
                    }));
                });
            });
        }
        if (Status.Cancelled$.MODULE$.equals(status)) {
            return this.doDefaultUpdate(user, ss).flatMap((Function1 & Serializable)ret -> this.markSubTasksCancelled(user, ss.part()).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                return this.removeAnyBlockStatuses(user, ss).flatMap((Function1 & Serializable)x$12 -> {
                    Either either = x$12;
                    return this.removeAnyBlockers(user, ss).map((Function1 & Serializable)x$1 -> {
                        Either either = x$1;
                        return ret;
                    });
                });
            }));
        }
        if (Status.Paused$.MODULE$.equals(status)) {
            return this.doDefaultUpdate(user, ss).flatMap((Function1 & Serializable)ret -> this.removeAnyBlockers(user, ss).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                return ret;
            }));
        }
        if (Status.Blocked$.MODULE$.equals(status)) {
            return this.doDefaultUpdate(user, ss).map((Function1 & Serializable)ret -> ret);
        }
        throw new MatchError((Object)status);
    }

    public Task<Either<LogMessage, BoxedUnit>> removeAnyBlockStatuses(UserDB.User user, Update.SetStatus ss) {
        Bson update1 = Updates$.MODULE$.pull("blockers", (Object)BsonString$.MODULE$.apply(ss.part().partId()));
        Bson update2 = Updates$.MODULE$.set("status", (Object)BsonString$.MODULE$.apply(Status.Paused$.MODULE$.id()));
        Bson update = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{update1, update2}));
        return Collections$.MODULE$.contentsCltn().updateManyT(Filters$.MODULE$.eq("blockers", (Object)BsonString$.MODULE$.apply(ss.part().partId())), update).map((Function1 & Serializable)_$1 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Task<Either<LogMessage, BoxedUnit>> removeAnyBlockers(UserDB.User user, Update.SetStatus ss) {
        Bson update = Updates$.MODULE$.unset("blockers");
        return Collections$.MODULE$.contentsCltn().updateOneT(ContentsManager$.MODULE$.buildFilter(ss.part()), update).map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Task<Either<LogMessage, BoxedUnit>> doDefaultUpdate(UserDB.User user, Update.SetStatus ss) {
        return DefaultUpdater$.MODULE$.doUpdate(user, (Update)ss);
    }

    public Task<Either<LogMessage, BoxedUnit>> checkAssignment(UserDB.User user, Update update) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{ContentsManager$.MODULE$.buildFilter(update.part()), Filters$.MODULE$.eq("assignedTo", (Object)user.name())}));
        return Collections$.MODULE$.contentsCltn().findO(filter).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Cannot SetStatus InProgress for someone else's assignment"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> checkSubTasksCompletedOrCancelled(UserDB.User user, Update update) {
        return ContentsManager$.MODULE$.getPartTree(user, update.part().containerId()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                PartTree partTree = (PartTree)((Right)either).value();
                Option<PartTreeItem> option = PartTreeUtils$.MODULE$.findPartTreeItem(partTree, update.part().partId());
                if (option instanceof Some) {
                    PartTreeItem pti2 = (PartTreeItem)((Some)option).value();
                    LazyList failed = PartTreeUtils$.MODULE$.lazyList(pti2).filterNot((Function1 & Serializable)pti -> this.isCompletedOrCancelled((PartTreeItem)pti));
                    if (failed.isEmpty()) {
                        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                    String names = failed.map((Function1 & Serializable)_$3 -> _$3.part().name()).toList().mkString(", ");
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Subtasks " + names + " are not Completed or Cancelled"));
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't find " + update.part().partId() + " in PartTree"));
                }
                throw new MatchError(option);
            }
            if (either instanceof Left) {
                LogMessage value = (LogMessage)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)value);
            }
            throw new MatchError((Object)either);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCompletedOrCancelled(PartTreeItem pti) {
        Status status = pti.part().status();
        Status.Completed$ completed$ = Status.Completed$.MODULE$;
        if (status == null) {
            if (completed$ == null) return true;
        } else if (status.equals(completed$)) return true;
        Status status2 = pti.part().status();
        Status.Cancelled$ cancelled$ = Status.Cancelled$.MODULE$;
        if (status2 != null) {
            if (!status2.equals(cancelled$)) return false;
            return true;
        }
        if (cancelled$ == null) return true;
        return false;
    }

    public Task<Either<LogMessage, BoxedUnit>> pauseAnyActiveTasks(UserDB.User user, Update update) {
        Bson filter = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("assignedTo", (Object)user.name()), Filters$.MODULE$.eq("status", (Object)"InProgress")}));
        Bson history = UpdateBuilder$.MODULE$.addToHistory(user, (Update)Update.SetStatus$.MODULE$.apply(update.part(), (Status)Status.Paused$.MODULE$));
        Bson updateDoc = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.set("status", (Object)"Paused"), history}));
        return Updater$.MODULE$.run(filter, updateDoc).as((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Task<Either<LogMessage, BoxedUnit>> markSubTasksCancelled(UserDB.User user, Update.PartInfo info) {
        return ContentsManager$.MODULE$.getPartTree(user, info.containerId()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                PartTree partTree = (PartTree)((Right)either).value();
                Option<PartTreeItem> option = PartTreeUtils$.MODULE$.findPartTreeItem(partTree, info.partId());
                if (option instanceof Some) {
                    PartTreeItem pti2 = (PartTreeItem)((Some)option).value();
                    List toChange = PartTreeUtils$.MODULE$.lazyList(pti2).filterNot((Function1 & Serializable)pti -> this.isCompletedOrCancelled((PartTreeItem)pti)).toList();
                    return this.markTasksCancelled(user, (List<PartTreeItem>)toChange);
                }
                if (None$.MODULE$.equals(option)) {
                    return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't find " + info.partId() + " in PartTree")));
                }
                throw new MatchError(option);
            }
            if (either instanceof Left) {
                LogMessage value = (LogMessage)((Left)either).value();
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)value));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> markTasksCancelled(UserDB.User user, List<PartTreeItem> value) {
        List<PartTreeItem> list = value;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<PartTreeItem> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            PartTreeItem head = (PartTreeItem)colon2.head();
            List tail = list3;
            return this.markTaskCancelled(user, head).flatMap((Function1 & Serializable)_$4 -> this.markTasksCancelled(user, (List<PartTreeItem>)tail));
        }
        throw new MatchError(list);
    }

    public Task<Either<LogMessage, BoxedUnit>> markTaskCancelled(UserDB.User user, PartTreeItem value) {
        Update.SetStatus ss = Update.SetStatus$.MODULE$.apply(value.part().partInfo(), (Status)Status.Cancelled$.MODULE$);
        return this.removeAnyBlockers(user, ss).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            return DefaultUpdater$.MODULE$.doUpdate(user, (Update)ss).map((Function1 & Serializable)ret -> ret);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> markParentsPausedIfNotStarted(UserDB.User user, Update.SetStatus status) {
        return ContentsManager$.MODULE$.getPartTree(user, status.part().containerId()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                PartTree partTree = (PartTree)((Right)either).value();
                Option<PartTreeItem> option = PartTreeUtils$.MODULE$.findPartTreeItem(partTree, status.part().partId());
                if (option instanceof Some) {
                    PartTreeItem pti = (PartTreeItem)((Some)option).value();
                    return this.markParentsPausedIfNotStarted(user, partTree, pti);
                }
                if (None$.MODULE$.equals(option)) {
                    return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't find " + status.part().partId() + " in PartTree")));
                }
                throw new MatchError(option);
            }
            if (either instanceof Left) {
                LogMessage value = (LogMessage)((Left)either).value();
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)value));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> markParentsPausedIfNotStarted(UserDB.User user, PartTree partTree, PartTreeItem pti) {
        Option<PartTreeItem> option = PartTreeUtils$.MODULE$.findPartTreeItem(partTree, pti.part().parentId());
        if (option instanceof Some) {
            PartTreeItem parent = (PartTreeItem)((Some)option).value();
            Status status = parent.part().status();
            Status.NotStarted$ notStarted$ = Status.NotStarted$.MODULE$;
            if (!(status != null ? !status.equals(notStarted$) : notStarted$ != null)) {
                return (Task)EitherT$.MODULE$.apply(this.markTaskPaused(user, parent)).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(this.markParentsPausedIfNotStarted(user, partTree, parent)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, (Functor)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync()).value();
            }
            return Task$.MODULE$.apply(this::markParentsPausedIfNotStarted$$anonfun$3);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply(this::markParentsPausedIfNotStarted$$anonfun$4);
        }
        throw new MatchError(option);
    }

    public Task<Either<LogMessage, BoxedUnit>> markTaskPaused(UserDB.User user, PartTreeItem item) {
        Update.SetStatus ss = Update.SetStatus$.MODULE$.apply(item.part().partInfo(), (Status)Status.Paused$.MODULE$);
        return DefaultUpdater$.MODULE$.doUpdate(user, (Update)ss);
    }

    private final Left doUpdate$$anonfun$1() {
        return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Not a SetStatus update"));
    }

    private final Left doUpdateSetStatus$$anonfun$1() {
        return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Cannot SetStatus to NotStarted"));
    }

    private final Right markParentsPausedIfNotStarted$$anonfun$3() {
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final Right markParentsPausedIfNotStarted$$anonfun$4() {
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }
}

