/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx;

import com.monitorjbl.xlsx.exceptions.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.poi.ooxml.util.DocumentHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Document document(InputStream inputStream) {
        try {
            return DocumentHelper.readDocument((InputStream)inputStream);
        }
        catch (IOException | SAXException exception) {
            throw new ParseException(exception);
        }
    }

    public static NodeList searchForNodeList(Document document, String string) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
            namespaceContextImpl.addNamespace("ss", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            xPath.setNamespaceContext(namespaceContextImpl);
            return (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ParseException(xPathExpressionException);
        }
    }

    private static class NamespaceContextImpl
    implements NamespaceContext {
        private Map<String, String> urisByPrefix = new HashMap<String, String>();
        private Map<String, Set<String>> prefixesByURI = new HashMap<String, Set<String>>();

        public NamespaceContextImpl() {
            this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
            this.addNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
        }

        public void addNamespace(String string, String string2) {
            this.urisByPrefix.put(string, string2);
            if (this.prefixesByURI.containsKey(string2)) {
                this.prefixesByURI.get(string2).add(string);
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(string);
                this.prefixesByURI.put(string2, hashSet);
            }
        }

        @Override
        public String getNamespaceURI(String string) {
            if (string == null) {
                throw new IllegalArgumentException("prefix cannot be null");
            }
            if (this.urisByPrefix.containsKey(string)) {
                return this.urisByPrefix.get(string);
            }
            return "";
        }

        @Override
        public String getPrefix(String string) {
            return this.getPrefixes(string).next();
        }

        @Override
        public Iterator<String> getPrefixes(String string) {
            if (string == null) {
                throw new IllegalArgumentException("namespaceURI cannot be null");
            }
            if (this.prefixesByURI.containsKey(string)) {
                return this.prefixesByURI.get(string).iterator();
            }
            return Collections.emptyIterator();
        }
    }
}

