/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.NotSupportedException;
import com.monitorjbl.xlsx.impl.Supplier;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class StreamingCell
implements Cell {
    private static final Supplier NULL_SUPPLIER = () -> null;
    private static final String FALSE_AS_STRING = "0";
    private static final String TRUE_AS_STRING = "1";
    private final Sheet sheet;
    private int columnIndex;
    private int rowIndex;
    private final boolean use1904Dates;
    private Supplier contentsSupplier = NULL_SUPPLIER;
    private Object rawContents;
    private String formula;
    private String numericFormat;
    private Short numericFormatIndex;
    private String type;
    private CellStyle cellStyle;
    private Row row;
    private boolean formulaType;

    public StreamingCell(Sheet sheet, int n, int n2, boolean bl) {
        this.sheet = sheet;
        this.columnIndex = n;
        this.rowIndex = n2;
        this.use1904Dates = bl;
    }

    public void setContentSupplier(Supplier supplier) {
        this.contentsSupplier = supplier;
    }

    public void setRawContents(Object object) {
        this.rawContents = object;
    }

    public String getNumericFormat() {
        return this.numericFormat;
    }

    public void setNumericFormat(String string) {
        this.numericFormat = string;
    }

    public Short getNumericFormatIndex() {
        return this.numericFormatIndex;
    }

    public void setNumericFormatIndex(Short s) {
        this.numericFormatIndex = s;
    }

    public void setFormula(String string) {
        this.formula = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isFormulaType() {
        return this.formulaType;
    }

    public void setFormulaType(boolean bl) {
        this.formulaType = bl;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public CellType getCellType() {
        if (this.formulaType) {
            return CellType.FORMULA;
        }
        if (this.contentsSupplier.getContent() == null || this.type == null) {
            return CellType.BLANK;
        }
        if ("n".equals(this.type)) {
            return CellType.NUMERIC;
        }
        if ("s".equals(this.type) || "inlineStr".equals(this.type) || "str".equals(this.type)) {
            return CellType.STRING;
        }
        if ("str".equals(this.type)) {
            return CellType.FORMULA;
        }
        if ("b".equals(this.type)) {
            return CellType.BOOLEAN;
        }
        if ("e".equals(this.type)) {
            return CellType.ERROR;
        }
        throw new UnsupportedOperationException("Unsupported cell type '" + this.type + "'");
    }

    public String getStringCellValue() {
        Object object = this.contentsSupplier.getContent();
        return object == null ? "" : object.toString();
    }

    public double getNumericCellValue() {
        return this.rawContents == null ? 0.0 : Double.parseDouble((String)this.rawContents);
    }

    public Date getDateCellValue() {
        if (this.getCellType() == CellType.STRING) {
            throw new IllegalStateException("Cell type cannot be CELL_TYPE_STRING");
        }
        return this.rawContents == null ? null : DateUtil.getJavaDate((double)this.getNumericCellValue(), (boolean)this.use1904Dates);
    }

    public LocalDateTime getLocalDateTimeCellValue() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.getDateCellValue().getTime()), ZoneOffset.systemDefault());
    }

    public boolean getBooleanCellValue() {
        CellType cellType = this.getCellType();
        switch (cellType) {
            case BLANK: {
                return false;
            }
            case BOOLEAN: {
                return this.rawContents != null && TRUE_AS_STRING.equals(this.rawContents);
            }
            case FORMULA: {
                throw new NotSupportedException();
            }
        }
        throw StreamingCell.typeMismatch(CellType.BOOLEAN, cellType, false);
    }

    public XSSFRichTextString getRichStringCellValue() {
        CellType cellType = this.getCellType();
        return switch (cellType) {
            case CellType.BLANK -> new XSSFRichTextString("");
            case CellType.STRING -> new XSSFRichTextString(this.getStringCellValue());
            default -> throw new NotSupportedException();
        };
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    private static RuntimeException typeMismatch(CellType cellType, CellType cellType2, boolean bl) {
        String string = "Cannot get a " + StreamingCell.getCellTypeName(cellType) + " value from a " + StreamingCell.getCellTypeName(cellType2) + " " + (bl ? "formula " : "") + "cell";
        return new IllegalStateException(string);
    }

    private static String getCellTypeName(CellType cellType) {
        switch (cellType) {
            case BLANK: {
                return "blank";
            }
            case STRING: {
                return "text";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case ERROR: {
                return "error";
            }
            case NUMERIC: {
                return "numeric";
            }
            case FORMULA: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellType + ")#";
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public String getCellFormula() {
        if (!this.formulaType) {
            throw new IllegalStateException("This cell does not have a formula");
        }
        return this.formula;
    }

    public CellType getCachedFormulaResultType() {
        if (this.formulaType) {
            if (this.contentsSupplier.getContent() == null || this.type == null) {
                return CellType.BLANK;
            }
            if ("n".equals(this.type)) {
                return CellType.NUMERIC;
            }
            if ("s".equals(this.type) || "inlineStr".equals(this.type) || "str".equals(this.type)) {
                return CellType.STRING;
            }
            if ("b".equals(this.type)) {
                return CellType.BOOLEAN;
            }
            if ("e".equals(this.type)) {
                return CellType.ERROR;
            }
            throw new UnsupportedOperationException("Unsupported cell type '" + this.type + "'");
        }
        throw new IllegalStateException("Only formula cells have cached results");
    }

    @Deprecated
    public void setCellType(CellType cellType) {
        throw new NotSupportedException();
    }

    public void setCellValue(double d) {
        throw new NotSupportedException();
    }

    public void setCellValue(Date date) {
        throw new NotSupportedException();
    }

    public void setCellValue(LocalDateTime localDateTime) {
        throw new NotSupportedException();
    }

    public void setCellValue(Calendar calendar) {
        throw new NotSupportedException();
    }

    public void setCellValue(RichTextString richTextString) {
        throw new NotSupportedException();
    }

    public void setCellValue(String string) {
        throw new NotSupportedException();
    }

    public void setCellFormula(String string) throws FormulaParseException {
        throw new NotSupportedException();
    }

    public void setCellValue(boolean bl) {
        throw new NotSupportedException();
    }

    public void setCellErrorValue(byte by) {
        throw new NotSupportedException();
    }

    public byte getErrorCellValue() {
        throw new NotSupportedException();
    }

    public void setAsActiveCell() {
        throw new NotSupportedException();
    }

    public CellAddress getAddress() {
        throw new NotSupportedException();
    }

    public void setCellComment(Comment comment) {
        throw new NotSupportedException();
    }

    public Comment getCellComment() {
        throw new NotSupportedException();
    }

    public void removeCellComment() {
        throw new NotSupportedException();
    }

    public Hyperlink getHyperlink() {
        throw new NotSupportedException();
    }

    public void setHyperlink(Hyperlink hyperlink) {
        throw new NotSupportedException();
    }

    public void removeHyperlink() {
        throw new NotSupportedException();
    }

    public CellRangeAddress getArrayFormulaRange() {
        throw new NotSupportedException();
    }

    public boolean isPartOfArrayFormulaGroup() {
        throw new NotSupportedException();
    }

    public void setBlank() {
        throw new NotSupportedException();
    }

    public void removeFormula() throws IllegalStateException {
        throw new NotSupportedException();
    }
}

