/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.NotSupportedException;
import com.monitorjbl.xlsx.impl.StreamingCell;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class StreamingRow
implements Row {
    private final Sheet sheet;
    private int rowIndex;
    private boolean isHidden;
    private TreeMap<Integer, Cell> cellMap = new TreeMap();

    public StreamingRow(Sheet sheet, int n, boolean bl) {
        this.sheet = sheet;
        this.rowIndex = n;
        this.isHidden = bl;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Map<Integer, Cell> getCellMap() {
        return this.cellMap;
    }

    public void setCellMap(TreeMap<Integer, Cell> treeMap) {
        this.cellMap = treeMap;
    }

    public int getRowNum() {
        return this.rowIndex;
    }

    public Iterator<Cell> cellIterator() {
        return this.cellMap.values().iterator();
    }

    public Iterator<Cell> iterator() {
        return this.cellMap.values().iterator();
    }

    public Cell getCell(int n) {
        return this.cellMap.get(n);
    }

    public short getLastCellNum() {
        return (short)(this.cellMap.size() == 0 ? -1 : this.cellMap.lastEntry().getValue().getColumnIndex() + 1);
    }

    public boolean getZeroHeight() {
        return this.isHidden;
    }

    public int getPhysicalNumberOfCells() {
        return this.cellMap.size();
    }

    public short getFirstCellNum() {
        if (this.cellMap.size() == 0) {
            return -1;
        }
        return this.cellMap.firstKey().shortValue();
    }

    public Cell getCell(int n, Row.MissingCellPolicy missingCellPolicy) {
        StreamingCell streamingCell = (StreamingCell)this.cellMap.get(n);
        if (missingCellPolicy == Row.MissingCellPolicy.CREATE_NULL_AS_BLANK) {
            if (streamingCell == null) {
                return new StreamingCell(this.sheet, n, this.rowIndex, false);
            }
        } else if (missingCellPolicy == Row.MissingCellPolicy.RETURN_BLANK_AS_NULL && (streamingCell == null || streamingCell.getCellType() == CellType.BLANK)) {
            return null;
        }
        return streamingCell;
    }

    public Cell createCell(int n) {
        throw new NotSupportedException();
    }

    public Cell createCell(int n, CellType cellType) {
        throw new NotSupportedException();
    }

    public void removeCell(Cell cell) {
        throw new NotSupportedException();
    }

    public void setRowNum(int n) {
        throw new NotSupportedException();
    }

    public void setHeight(short s) {
        throw new NotSupportedException();
    }

    public void setZeroHeight(boolean bl) {
        throw new NotSupportedException();
    }

    public void setHeightInPoints(float f) {
        throw new NotSupportedException();
    }

    public short getHeight() {
        throw new NotSupportedException();
    }

    public float getHeightInPoints() {
        throw new NotSupportedException();
    }

    public boolean isFormatted() {
        throw new NotSupportedException();
    }

    public CellStyle getRowStyle() {
        throw new NotSupportedException();
    }

    public void setRowStyle(CellStyle cellStyle) {
        throw new NotSupportedException();
    }

    public int getOutlineLevel() {
        throw new NotSupportedException();
    }

    public void shiftCellsRight(int n, int n2, int n3) {
        throw new NotSupportedException();
    }

    public void shiftCellsLeft(int n, int n2, int n3) {
        throw new NotSupportedException();
    }
}

