/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.sst;

import com.monitorjbl.xlsx.sst.FileBackedList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class BufferedStringsTable
extends SharedStringsTable
implements AutoCloseable {
    private final FileBackedList list;

    public static BufferedStringsTable getSharedStringsTable(File file, int n, OPCPackage oPCPackage) throws IOException {
        ArrayList arrayList = oPCPackage.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        return arrayList.size() == 0 ? null : new BufferedStringsTable((PackagePart)arrayList.get(0), file, n);
    }

    private BufferedStringsTable(PackagePart packagePart, File file, int n) throws IOException {
        this.list = new FileBackedList(file, n);
        this.readFrom(packagePart.getInputStream());
    }

    public void readFrom(InputStream inputStream) throws IOException {
        try {
            XMLEventReader xMLEventReader = XMLHelper.newXMLInputFactory().createXMLEventReader(inputStream);
            while (xMLEventReader.hasNext()) {
                XMLEvent xMLEvent = xMLEventReader.nextEvent();
                if (!xMLEvent.isStartElement() || !xMLEvent.asStartElement().getName().getLocalPart().equals("si")) continue;
                this.list.add(this.parseCT_Rst(xMLEventReader));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException);
        }
    }

    private String parseCT_Rst(XMLEventReader xMLEventReader) throws XMLStreamException {
        XMLEvent xMLEvent;
        StringBuilder stringBuilder = new StringBuilder();
        block11: while ((xMLEvent = xMLEventReader.nextTag()).isStartElement()) {
            switch (xMLEvent.asStartElement().getName().getLocalPart()) {
                case "t": {
                    stringBuilder.append(xMLEventReader.getElementText());
                    continue block11;
                }
                case "r": {
                    this.parseCT_RElt(xMLEventReader, stringBuilder);
                    continue block11;
                }
                case "rPh": 
                case "phoneticPr": {
                    this.skipElement(xMLEventReader);
                    continue block11;
                }
            }
            throw new IllegalArgumentException(xMLEvent.asStartElement().getName().getLocalPart());
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private void parseCT_RElt(XMLEventReader xMLEventReader, StringBuilder stringBuilder) throws XMLStreamException {
        XMLEvent xMLEvent;
        block8: while ((xMLEvent = xMLEventReader.nextTag()).isStartElement()) {
            switch (xMLEvent.asStartElement().getName().getLocalPart()) {
                case "t": {
                    stringBuilder.append(xMLEventReader.getElementText());
                    continue block8;
                }
                case "rPr": {
                    this.skipElement(xMLEventReader);
                    continue block8;
                }
            }
            throw new IllegalArgumentException(xMLEvent.asStartElement().getName().getLocalPart());
        }
    }

    private void skipElement(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.nextTag().isStartElement()) {
            this.skipElement(xMLEventReader);
        }
    }

    public RichTextString getItemAt(int n) {
        return new XSSFRichTextString(this.list.getAt(n));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.list.close();
    }
}

