/*
 * Decompiled with CFR 0.152.
 */
package importdata;

import ambience.ie.FileUploadUtil$;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.FileDataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.FullDataBytes;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.NoDataBytes$;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.gravity.Gravity;
import importdata.GzipHelper$;
import importdata.ImportTypeDetector;
import importdata.ImportTypeDetector$BSON$;
import importdata.ImportTypeDetector$CSV$;
import importdata.ImportTypeDetector$ImportTypeInfo$;
import importdata.ImportTypeDetector$InvalidImportTypeTests$;
import importdata.ImportTypeDetector$JSON$;
import importdata.ImportTypeDetector$Unknown$;
import importdata.ImportTypeDetector$XLSX$;
import importdata.ImportTypeDetector$XLSXCantDecrypt$;
import importdata.Util$;
import importdata.store.BSONStore$;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.ss.usermodel.Workbook;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ImportTypeDetector$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ImportTypeDetector$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final ImportTypeDetector$ImportTypeInfo$ ImportTypeInfo;
    public static final ImportTypeDetector$BSON$ BSON;
    public static final ImportTypeDetector$JSON$ JSON;
    public static final ImportTypeDetector$CSV$ CSV;
    public static final ImportTypeDetector$XLSX$ XLSX;
    public static final ImportTypeDetector$XLSXCantDecrypt$ XLSXCantDecrypt;
    public static final ImportTypeDetector$Unknown$ Unknown;
    public static final ImportTypeDetector$InvalidImportTypeTests$ InvalidImportTypeTests;
    public static final ImportTypeDetector$ MODULE$;

    private ImportTypeDetector$() {
    }

    static {
        MODULE$ = new ImportTypeDetector$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ImportTypeDetector$.class);
    }

    public ImportTypeDetector.ImportTypeInfo detect(Gravity.FileUploadItem file, Option<String> password) {
        if (this.testImportTypeInvalid(file)) {
            return ImportTypeDetector$ImportTypeInfo$.MODULE$.apply(ImportTypeDetector$Unknown$.MODULE$);
        }
        Option<Path> option = GzipHelper$.MODULE$.unzipIfNecessary(file);
        if (option instanceof Some) {
            ImportTypeDetector.ImportTypeInfo importTypeInfo;
            block8: {
                Path gunzipPath = (Path)((Some)option).value();
                try {
                    FileDataBytes fileDataBytes = FileDataBytes$.MODULE$.apply(gunzipPath.toFile());
                    String string = file.copy$default$1();
                    String string2 = file.copy$default$2();
                    long l = file.copy$default$3();
                    Option option2 = file.copy$default$5();
                    Gravity.FileUploadItem newFile = file.copy(string, string2, l, (SyncDataBytes)fileDataBytes, option2);
                    Option<ImportTypeDetector.ImportType> option3 = this.run(newFile, password);
                    if (option3 instanceof Some) {
                        ImportTypeDetector.ImportType it = (ImportTypeDetector.ImportType)((Some)option3).value();
                        importTypeInfo = ImportTypeDetector$ImportTypeInfo$.MODULE$.apply(it);
                        break block8;
                    }
                    if (None$.MODULE$.equals(option3)) {
                        importTypeInfo = ImportTypeDetector$ImportTypeInfo$.MODULE$.apply((ImportTypeDetector.ImportType)this.testBSON(newFile).getOrElse(this::detect$$anonfun$1));
                        break block8;
                    }
                    throw new MatchError(option3);
                }
                finally {
                    this.log().info(() -> this.detect$$anonfun$2(gunzipPath), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("importdata.ImportTypeDetector.detect"));
                    gunzipPath.toFile().delete();
                }
            }
            return importTypeInfo;
        }
        if (None$.MODULE$.equals(option)) {
            return ImportTypeDetector$ImportTypeInfo$.MODULE$.apply((ImportTypeDetector.ImportType)this.run(file, password).getOrElse(this::detect$$anonfun$3));
        }
        throw new MatchError(option);
    }

    public Option<ImportTypeDetector.ImportType> run(Gravity.FileUploadItem file, Option<String> password) {
        if (file.filename().endsWith(".bson")) {
            return this.testBSON(file).orElse(() -> this.run$$anonfun$1(file)).orElse(() -> this.run$$anonfun$2(file)).orElse(() -> this.run$$anonfun$3(file, password));
        }
        if (file.filename().endsWith(".xlsx")) {
            return this.testXLSX(file, password).orElse(() -> this.run$$anonfun$4(file)).orElse(() -> this.run$$anonfun$5(file)).orElse(() -> this.run$$anonfun$6(file));
        }
        return this.testJSON(file).orElse(() -> this.run$$anonfun$7(file)).orElse(() -> this.run$$anonfun$8(file, password)).orElse(() -> this.run$$anonfun$9(file));
    }

    public boolean testImportTypeInvalid(Gravity.FileUploadItem file) {
        boolean bl;
        this.log().info(this::testImportTypeInvalid$$anonfun$1, Line$.MODULE$.apply(89), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testImportTypeInvalid"));
        try {
            Object object = Predef$.MODULE$.byteArrayOps(file.data().bytes());
            String head = new String((byte[])ArrayOps$.MODULE$.take$extension(object, 100), "UTF-8").trim();
            bl = ImportTypeDetector$InvalidImportTypeTests$.MODULE$.testList().exists((Function1 & Serializable)_$1 -> _$1.startsWith(head));
        }
        catch (MalformedInputException malformedInputException) {
            bl = false;
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
            bl = false;
        }
        catch (Exception e) {
            this.log().info(() -> this.testImportTypeInvalid$$anonfun$3(e), Line$.MODULE$.apply(98), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testImportTypeInvalid"));
            bl = true;
        }
        return bl;
    }

    public Option<ImportTypeDetector.ImportType> testCSV(Gravity.FileUploadItem file) {
        None$ none$;
        block7: {
            this.log().info(this::testCSV$$anonfun$1, Line$.MODULE$.apply(104), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testCSV"));
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getHeadBytes(file, 102400));
            BOMInputStream bis = ((BOMInputStream.Builder)new BOMInputStream.Builder().setInputStream((InputStream)bais)).get();
            try (InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream((InputStream)bis), "UTF-8");){
                try {
                    CSVFormat csvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.RFC4180).setHeader(new String[0]).setSkipHeaderRecord(true).setIgnoreSurroundingSpaces(true).build();
                    CSVParser parser = csvFormat.parse((Reader)in);
                    List headers = CollectionConverters$.MODULE$.MapHasAsScala(parser.getHeaderMap()).asScala().keys().toList();
                    if (headers.isEmpty()) {
                        this.log().info(this::testCSV$$anonfun$2, Line$.MODULE$.apply(117), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testCSV"));
                        none$ = None$.MODULE$;
                        break block7;
                    }
                    if (headers.exists((Function1 & Serializable)s -> this.badCSVChars((String)s))) {
                        this.log().info(this::testCSV$$anonfun$4, Line$.MODULE$.apply(121), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testCSV"));
                        none$ = None$.MODULE$;
                        break block7;
                    }
                    none$ = Some$.MODULE$.apply((Object)ImportTypeDetector$CSV$.MODULE$);
                }
                catch (Exception e) {
                    this.log().info(() -> this.testCSV$$anonfun$5(e), Line$.MODULE$.apply(128), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testCSV"));
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    public boolean badCSVChars(String s) {
        return StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$2 -> this.badCSVChars$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2)))), (Function1 & Serializable)c -> this.badCSVChars$$anonfun$2(BoxesRunTime.unboxToChar((Object)c)));
    }

    public Option<ImportTypeDetector.ImportType> testJSON(Gravity.FileUploadItem file) {
        this.log().info(this::testJSON$$anonfun$1, Line$.MODULE$.apply(141), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testJSON"));
        String head = new String(this.getHeadBytes(file, 100), "UTF-8");
        if (this.testJsonStart(head)) {
            return Some$.MODULE$.apply((Object)ImportTypeDetector$JSON$.MODULE$);
        }
        return None$.MODULE$;
    }

    public boolean testJsonStart(String head) {
        boolean bl;
        block3: {
            block2: {
                while (!head.startsWith("{")) {
                    if (head.startsWith("[")) {
                        head = head.substring(1);
                        continue;
                    }
                    break block2;
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public Option<ImportTypeDetector.ImportType> testXLSX(Gravity.FileUploadItem file, Option<String> password) {
        this.log().info(this::testXLSX$$anonfun$1, Line$.MODULE$.apply(152), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testXLSX"));
        return (Option)FileUploadUtil$.MODULE$.withFile(file, (Function1 & Serializable)xlsx -> {
            Some some;
            try {
                Workbook wb = Util$.MODULE$.openXSLXWorkbook((File)xlsx, password);
                int num = wb.getNumberOfSheets();
                if (num < 1) {
                    throw new IllegalArgumentException("No XLSX sheets found");
                }
                wb.getSheetAt(0);
                wb.close();
                some = Some$.MODULE$.apply((Object)ImportTypeDetector$XLSX$.MODULE$);
            }
            catch (OLE2NotOfficeXmlFileException oLE2NotOfficeXmlFileException) {
                some = Some$.MODULE$.apply((Object)ImportTypeDetector$XLSXCantDecrypt$.MODULE$);
            }
            catch (NullPointerException nullPointerException) {
                some = Some$.MODULE$.apply((Object)ImportTypeDetector$XLSXCantDecrypt$.MODULE$);
            }
            catch (IllegalArgumentException ex) {
                this.log().info(() -> this.testXLSX$$anonfun$2$$anonfun$1(ex), Line$.MODULE$.apply(166), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testXLSX"));
                some = None$.MODULE$;
            }
            catch (Exception ex) {
                this.log().error(() -> this.testXLSX$$anonfun$2$$anonfun$2(ex), (Throwable)ex, Line$.MODULE$.apply(169), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testXLSX"));
                some = None$.MODULE$;
            }
            return some;
        });
    }

    public String safeMsg(Exception e) {
        return (String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse(this::safeMsg$$anonfun$1);
    }

    public Option<ImportTypeDetector.ImportType> testBSON(Gravity.FileUploadItem file) {
        None$ none$;
        this.log().info(this::testBSON$$anonfun$1, Line$.MODULE$.apply(180), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testBSON"));
        try {
            byte[] bytes = file.data().bytes();
            BSONStore$.MODULE$.recordsInDocument(bytes).orElse(() -> this.testBSON$$anonfun$2(bytes)).getOrElse(this::testBSON$$anonfun$3);
            none$ = Some$.MODULE$.apply((Object)ImportTypeDetector$BSON$.MODULE$);
        }
        catch (Exception e) {
            this.log().info(() -> this.testBSON$$anonfun$4(e), Line$.MODULE$.apply(188), FullName$.MODULE$.apply("importdata.ImportTypeDetector.testBSON"));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public byte[] getHeadBytes(Gravity.FileUploadItem file, int len) {
        SyncDataBytes syncDataBytes = file.data();
        if (NoDataBytes$.MODULE$.equals(syncDataBytes)) {
            return NoDataBytes$.MODULE$.bytes();
        }
        if (syncDataBytes instanceof FullDataBytes) {
            byte[] byArray;
            FullDataBytes fullDataBytes = FullDataBytes$.MODULE$.unapply((FullDataBytes)syncDataBytes);
            byte[] bytes = byArray = fullDataBytes._1();
            Object object = Predef$.MODULE$.byteArrayOps(bytes);
            return (byte[])ArrayOps$.MODULE$.take$extension(object, len);
        }
        if (syncDataBytes instanceof FileDataBytes) {
            File file2;
            FileDataBytes fileDataBytes = FileDataBytes$.MODULE$.unapply((FileDataBytes)syncDataBytes);
            File file3 = file2 = fileDataBytes._1();
            return (byte[])ARM$.MODULE$.run((Function1 & Serializable)arm -> {
                byte[] chunk = new byte[len];
                FileInputStream fis = (FileInputStream)arm.manage((Object)new FileInputStream(file3));
                int actual = fis.read(chunk);
                Object object = Predef$.MODULE$.byteArrayOps(chunk);
                return (byte[])ArrayOps$.MODULE$.take$extension(object, actual);
            });
        }
        throw new MatchError((Object)syncDataBytes);
    }

    private final ImportTypeDetector.ImportType detect$$anonfun$1() {
        return ImportTypeDetector$Unknown$.MODULE$;
    }

    private final Object detect$$anonfun$2(Path gunzipPath$1) {
        return "reclaiming " + gunzipPath$1;
    }

    private final ImportTypeDetector.ImportType detect$$anonfun$3() {
        return ImportTypeDetector$Unknown$.MODULE$;
    }

    private final Option run$$anonfun$1(Gravity.FileUploadItem file$1) {
        return this.testJSON(file$1);
    }

    private final Option run$$anonfun$2(Gravity.FileUploadItem file$2) {
        return this.testCSV(file$2);
    }

    private final Option run$$anonfun$3(Gravity.FileUploadItem file$3, Option password$1) {
        return this.testXLSX(file$3, (Option<String>)password$1);
    }

    private final Option run$$anonfun$4(Gravity.FileUploadItem file$4) {
        return this.testJSON(file$4);
    }

    private final Option run$$anonfun$5(Gravity.FileUploadItem file$5) {
        return this.testCSV(file$5);
    }

    private final Option run$$anonfun$6(Gravity.FileUploadItem file$6) {
        return this.testBSON(file$6);
    }

    private final Option run$$anonfun$7(Gravity.FileUploadItem file$7) {
        return this.testCSV(file$7);
    }

    private final Option run$$anonfun$8(Gravity.FileUploadItem file$8, Option password$2) {
        return this.testXLSX(file$8, (Option<String>)password$2);
    }

    private final Option run$$anonfun$9(Gravity.FileUploadItem file$9) {
        return this.testBSON(file$9);
    }

    private final Object testImportTypeInvalid$$anonfun$1() {
        return "Test for ImportType Invalid";
    }

    private final Object testImportTypeInvalid$$anonfun$3(Exception e$1) {
        return "Test for ImportType Invalid failed " + e$1.getMessage();
    }

    private final Object testCSV$$anonfun$1() {
        return "Test for CSV";
    }

    private final Object testCSV$$anonfun$2() {
        return "CSV header empty";
    }

    private final Object testCSV$$anonfun$4() {
        return "CSV header contains bad characters, probably not real CSV";
    }

    private final Object testCSV$$anonfun$5(Exception e$2) {
        return "Test for CSV failed " + e$2.getMessage();
    }

    private final /* synthetic */ boolean badCSVChars$$anonfun$1(char _$2) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(_$2));
    }

    private final /* synthetic */ boolean badCSVChars$$anonfun$2(char c) {
        return c < ' ';
    }

    private final Object testJSON$$anonfun$1() {
        return "Test for JSON";
    }

    private final Object testXLSX$$anonfun$1() {
        return "Test for XLSX";
    }

    private final Object testXLSX$$anonfun$2$$anonfun$1(IllegalArgumentException ex$1) {
        return "Test for XLSX failed " + this.safeMsg(ex$1);
    }

    private final Object testXLSX$$anonfun$2$$anonfun$2(Exception ex$2) {
        return "Test for XLSX failed " + this.safeMsg(ex$2);
    }

    private final String safeMsg$$anonfun$1() {
        return "";
    }

    private final Object testBSON$$anonfun$1() {
        return "Test for BSON";
    }

    private final Option testBSON$$anonfun$2(byte[] bytes$1) {
        return BSONStore$.MODULE$.recordsInArray(bytes$1);
    }

    private final List testBSON$$anonfun$3() {
        throw new RuntimeException("Can't infer bson structure");
    }

    private final Object testBSON$$anonfun$4(Exception e$3) {
        return "Test for BSON failed " + e$3.getMessage();
    }
}

