/*
 * Decompiled with CFR 0.152.
 */
package importdata.analysis;

import importdata.analysis.BSONAnalysis$;
import java.io.Serializable;
import java.time.temporal.TemporalAccessor;
import org.bson.BsonValue;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;

public final class StringUtils$
implements Serializable {
    public static final StringUtils$ MODULE$ = new StringUtils$();

    private StringUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringUtils$.class);
    }

    public boolean isBoolean(BsonValue bv) {
        return bv.isString() && StringOps$.MODULE$.toBooleanOption$extension(Predef$.MODULE$.augmentString(bv.asString().getValue().trim())).nonEmpty();
    }

    public boolean isInt32(BsonValue bv) {
        return bv.isString() && StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(bv.asString().getValue().trim())).nonEmpty();
    }

    public boolean isInt64(BsonValue bv) {
        return bv.isString() && StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(bv.asString().getValue().trim())).nonEmpty();
    }

    public boolean isDouble(BsonValue bv) {
        return bv.isString() && StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(bv.asString().getValue().trim())).nonEmpty();
    }

    public boolean isDecimal(BsonValue bv) {
        if (bv.isString()) {
            String str = bv.asString().getValue().trim();
            return str.length() <= 34 && Try$.MODULE$.apply(() -> this.isDecimal$$anonfun$1(str)).isSuccess();
        }
        return false;
    }

    public boolean isNumber(BsonValue bv) {
        if (bv.isString()) {
            return this.isInt32(bv) || this.isInt64(bv) || this.isDouble(bv) || this.isDecimal(bv);
        }
        return bv.isNumber();
    }

    public boolean isTimestamp(BsonValue data) {
        return data.isString() && Try$.MODULE$.apply(() -> this.isTimestamp$$anonfun$1(data)).isSuccess();
    }

    public boolean isTime(BsonValue data) {
        return data.isString() && Try$.MODULE$.apply(() -> this.isTime$$anonfun$1(data)).isSuccess();
    }

    public boolean isDate(BsonValue data) {
        return data.isString() && Try$.MODULE$.apply(() -> this.isDate$$anonfun$1(data)).isSuccess();
    }

    private final BigDecimal isDecimal$$anonfun$1(String str$1) {
        return package$.MODULE$.BigDecimal().apply(str$1);
    }

    private final TemporalAccessor isTimestamp$$anonfun$1(BsonValue data$1) {
        return BSONAnalysis$.MODULE$.ISO_OFFSET_DATE_TIME().parse(data$1.asString().getValue().trim());
    }

    private final TemporalAccessor isTime$$anonfun$1(BsonValue data$2) {
        return BSONAnalysis$.MODULE$.ISO_LOCAL_TIME().parse(data$2.asString().getValue().trim());
    }

    private final TemporalAccessor isDate$$anonfun$1(BsonValue data$3) {
        return BSONAnalysis$.MODULE$.ISO_LOCAL_DATE().parse(data$3.asString().getValue().trim());
    }
}

