define("Core/defined",[],(function(){"use strict";return function(e){return null!=e}})),define("Core/DeveloperError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t})),define("Core/Check",["./defined","./DeveloperError"],(function(e,t){"use strict";var r={};function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}return r.typeOf={},r.defined=function(r,n){if(!e(n))throw new t(function(e){return e+" is required, actual value was undefined"}(r))},r.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},r.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},r.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},r.typeOf.number.lessThan=function(e,n,i){if(r.typeOf.number(e,n),n>=i)throw new t("Expected "+e+" to be less than "+i+", actual value was "+n)},r.typeOf.number.lessThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n>i)throw new t("Expected "+e+" to be less than or equal to "+i+", actual value was "+n)},r.typeOf.number.greaterThan=function(e,n,i){if(r.typeOf.number(e,n),n<=i)throw new t("Expected "+e+" to be greater than "+i+", actual value was "+n)},r.typeOf.number.greaterThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n<i)throw new t("Expected "+e+" to be greater than or equal to"+i+", actual value was "+n)},r.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},r.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},r.typeOf.number.equals=function(e,n,i,o){if(r.typeOf.number(e,i),r.typeOf.number(n,o),i!==o)throw new t(e+" must be equal to "+n+", the actual values are "+i+" and "+o)},r})),define("Core/freezeObject",["./defined"],(function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t})),define("Core/defaultValue",["./freezeObject"],(function(e){"use strict";function t(e,t){return null!=e?e:t}return t.EMPTY_OBJECT=e({}),t})),define("Core/arrayFill",["./Check","./defaultValue","./defined"],(function(e,t,r){"use strict";return function(n,i,o,a){if(e.defined("array",n),e.defined("value",i),r(o)&&e.typeOf.number("start",o),r(a)&&e.typeOf.number("end",a),"function"==typeof n.fill)return n.fill(i,o,a);for(var u=n.length>>>0,s=t(o,0),c=s<0?Math.max(u+s,0):Math.min(s,u),f=t(a,u),l=f<0?Math.max(u+f,0):Math.min(f,u);c<l;)n[c]=i,c++;return n}})),
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
define("ThirdParty/mersenne-twister",[],(function(){var e=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++)e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e})),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n,i){"use strict";var o={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536};o.sign=r(Math.sign,(function(e){return 0==(e=+e)||e!=e?e:e>0?1:-1})),o.signNotZero=function(e){return e<0?-1:1},o.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*o.clamp(e,-1,1)+.5)*t)},o.fromSNorm=function(e,t){return t=r(t,255),o.clamp(e,0,t)/t*2-1},o.sinh=r(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),o.cosh=r(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),o.lerp=function(e,t,r){return(1-r)*e+r*t},o.PI=Math.PI,o.ONE_OVER_PI=1/Math.PI,o.PI_OVER_TWO=Math.PI/2,o.PI_OVER_THREE=Math.PI/3,o.PI_OVER_FOUR=Math.PI/4,o.PI_OVER_SIX=Math.PI/6,o.THREE_PI_OVER_TWO=3*Math.PI/2,o.TWO_PI=2*Math.PI,o.ONE_OVER_TWO_PI=1/(2*Math.PI),o.RADIANS_PER_DEGREE=Math.PI/180,o.DEGREES_PER_RADIAN=180/Math.PI,o.RADIANS_PER_ARCSECOND=o.RADIANS_PER_DEGREE/3600,o.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*o.RADIANS_PER_DEGREE},o.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*o.DEGREES_PER_RADIAN},o.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=o.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},o.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return o.clamp(e,-1*o.PI_OVER_TWO,o.PI_OVER_TWO)},o.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return o.zeroToTwoPi(e+o.PI)-o.PI},o.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=o.mod(e,o.TWO_PI);return Math.abs(t)<o.EPSILON14&&Math.abs(e)>o.EPSILON14?o.TWO_PI:t},o.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},o.equalsEpsilon=function(e,t,o,a){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(o))throw new i("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-t);return u<=a||u<=o*Math.max(Math.abs(e),Math.abs(t))};var a=[1];o.factorial=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],n=t;n<=e;n++)a.push(r*n);return a[e]},o.incrementWrap=function(e,t,o){if(o=r(o,0),!n(e))throw new i("n is required.");if(t<=o)throw new i("maximumValue must be greater than minimumValue.");return++e>t&&(e=o),e},o.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0==(e&e-1)},o.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},o.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return e<t?t:e>r?r:e};var u=new e;return o.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},o.nextRandomNumber=function(){return u.random()},o.randomBetween=function(e,t){return o.nextRandomNumber()*(t-e)+e},o.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(o.clamp(e,-1,1))},o.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(o.clamp(e,-1,1))},o.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},o.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},o.cbrt=r(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),o.log2=r(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),o.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},o.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},o.fastApproximateAtan2=function(e,r){var n,a;t.typeOf.number("x",e),t.typeOf.number("y",r);var u=Math.abs(e);n=Math.abs(r),a=Math.max(u,n);var s=(n=Math.min(u,n))/a;if(isNaN(s))throw new i("either x or y must be nonzero");return u=o.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?o.PI_OVER_TWO-u:u,u=e<0?o.PI-u:u,u=r<0?-u:u},o})),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o){"use strict";function a(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}a.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new a);var o=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(o),i.y=c*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z)},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var o=0;o<i;++o)a.pack(t[o],n,3*o);return n},a.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!=0)throw new n("array length must be a multiple of 3.");var o=t.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;u<o;u+=3){var s=u/3;i[s]=a.unpack(t,u,i[s])}return i},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a,f=new a;a.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f);var n=a.dot(c,f),i=a.magnitude(a.cross(c,f,c));return Math.atan2(i,n)};var l=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Z,r):n.y<=n.z?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_Z,r)},a.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=a.dot(t,r)/a.dot(r,r);return a.multiplyByScalar(r,i,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)&&o.equalsEpsilon(e.z,t.z,n,i)},a.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=r.x,s=r.y,c=r.z,f=o*c-a*s,l=a*u-i*c,p=i*s-o*u;return n.x=f,n.y=l,n.z=p,n},a.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},a.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=o.toRadians(t),r=o.toRadians(r),a.fromRadians(t,r,n,i,u)};var p=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),o=t(o,0);var c=r(u)?u.radiiSquared:d,f=Math.cos(i);p.x=f*Math.cos(n),p.y=f*Math.sin(n),p.z=Math.sin(i),p=a.normalize(p,p),a.multiplyComponents(c,p,h);var l=Math.sqrt(a.dot(p,h));return h=a.divideByScalar(h,l,h),p=a.multiplyByScalar(p,o,p),r(s)||(s=new a),a.add(h,p,s)},a.fromDegreesArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(o)?o.length=u/2:o=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;o[l]=a.fromDegrees(c,f,0,i,o[l])}return o},a.fromRadiansArray=function(t,i,o){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(o)?o.length=u/2:o=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;o[l]=a.fromRadians(c,f,0,i,o[l])}return o},a.fromDegreesArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(o)?o.length=u/3:o=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;o[p]=a.fromDegrees(c,f,l,i,o[p])}return o},a.fromRadiansArrayHeights=function(t,i,o){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(o)?o.length=u/3:o=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;o[p]=a.fromRadians(c,f,l,i,o[p])}return o},a.ZERO=i(new a(0,0,0)),a.UNIT_X=i(new a(1,0,0)),a.UNIT_Y=i(new a(0,1,0)),a.UNIT_Z=i(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a})),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";var i=new e,o=new e;return function(a,u,s,c,f){if(!t(a))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=a.x,p=a.y,h=a.z,d=u.x,y=u.y,E=u.z,m=l*l*d*d,O=p*p*y*y,_=h*h*E*E,T=m+O+_,R=Math.sqrt(1/T),A=e.multiplyByScalar(a,R,i);if(T<c)return isFinite(R)?e.clone(A,f):void 0;var w=s.x,b=s.y,S=s.z,g=o;g.x=A.x*w*2,g.y=A.y*b*2,g.z=A.z*S*2;var N,I,v,M,x,C,P,U=(1-R)*e.magnitude(a)/(.5*e.magnitude(g)),D=0;do{D=(N=m*(x=(I=1/(1+(U-=D)*w))*I)+O*(C=(v=1/(1+U*b))*v)+_*(P=(M=1/(1+U*S))*M)-1)/(-2*(m*(x*I)*w+O*(C*v)*b+_*(P*M)*S))}while(Math.abs(N)>n.EPSILON12);return t(f)?(f.x=l*I,f.y=p*v,f.z=h*M,f):new e(l*I,p*v,h*M)}})),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,o,a){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,o,a){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),o=r(o,0),n(a)?(a.longitude=e,a.latitude=i,a.height=o,a):new u(e,i,o)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=o.toRadians(e),r=o.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=o.EPSILON1;return u.fromCartesian=function(t,r,i){var d=n(r)?r.oneOverRadii:l,y=n(r)?r.oneOverRadiiSquared:p,E=n(r)?r._centerToleranceSquared:h,m=a(t,d,y,E,c);if(n(m)){var O=e.multiplyComponents(m,y,s);O=e.normalize(O,O);var _=e.subtract(t,m,f),T=Math.atan2(O.y,O.x),R=Math.asin(O.z),A=o.sign(e.dot(_,t))*e.magnitude(_);return n(i)?(i.longitude=T,i.latitude=R,i.height=A,i):new u(T,R,A)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u})),define("Core/defineProperties",["./defined"],(function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r})),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,o,a,u,s,c){"use strict";function f(t,i,o,a){i=n(i,0),o=n(o,0),a=n(a,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",o,0),r.typeOf.number.greaterThanOrEquals("z",a,0),t._radii=new e(i,o,a),t._radiiSquared=new e(i*i,o*o,a*a),t._radiiToTheFourth=new e(i*i*i*i,o*o*o*o,a*a*a*a),t._oneOverRadii=new e(0===i?0:1/i,0===o?0:1/o,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===o?0:1/(o*o),0===a?0:1/(a*a)),t._minimumRadius=Math.min(i,o,a),t._maximumRadius=Math.max(i,o,a),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}o(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return i(t)||(t=new l),i(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,i,o){return r.typeOf.object("value",t),r.defined("array",i),o=n(o,0),e.pack(t._radii,i,o),i},l.unpack=function(t,i,o){r.defined("array",t),i=n(i,0);var a=e.unpack(t,i);return l.fromCartesian3(a,o)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var o=t.longitude,a=t.latitude,u=Math.cos(a),s=u*Math.cos(o),c=u*Math.sin(o),f=Math.sin(a);return i(n)||(n=new e),n.x=s,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var p=new e,h=new e;l.prototype.cartographicToCartesian=function(t,r){var n=p,o=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(o,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var o=0;o<n;o++)t[o]=this.cartographicToCartesian(e[o],t[o]);return t};var d=new e,y=new e,E=new e;return l.prototype.cartesianToCartographic=function(r,n){var o=this.scaleToGeodeticSurface(r,y);if(i(o)){var a=this.geodeticSurfaceNormal(o,d),u=e.subtract(r,o,E),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var o=0;o<n;++o)t[o]=this.cartesianToCartographic(e[o],t[o]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var o=t.x,a=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(o*o*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,o,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),o=n(o,0);var c=this._squaredXOverSquaredZ;if(i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),!(Math.abs(u.z)>=this._radii.z-o))return u},l})),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],(function(e,t,r,n,i,o,a){"use strict";function u(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,o=t.longitude*i,a=t.latitude*i,u=t.height;return n(r)?(r.x=o,r.y=a,r.z=u,r):new e(o,a,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=a,r.latitude=u,r.height=s,r):new t(a,u,s)},u})),define("Core/Intersect",["./freezeObject"],(function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})})),define("Core/Interval",["./defaultValue"],(function(e){"use strict";return function(t,r){this.start=e(t,0),this.stop=e(r,0)}})),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i,o,a,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,p=e.z*e.z,h=e.z*e.w,d=e.w*e.w,y=i-c-p+d,E=2*(o-h),m=2*(a+l),O=2*(o+h),_=-i+c-p+d,T=2*(f-u),R=2*(a-l),A=2*(f+u),w=-i-c+p+d;return n(r)?(r[0]=y,r[1]=O,r[2]=R,r[3]=E,r[4]=_,r[5]=A,r[6]=m,r[7]=T,r[8]=w,r):new s(y,E,m,O,_,T,R,A,w)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),o=Math.cos(-e.heading),a=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=i*o,p=-a*c+f*u*o,h=f*c+a*u*o,d=i*c,y=a*o+f*u*c,E=-f*o+a*u*c,m=-u,O=f*i,_=a*i;return n(r)?(r[0]=l,r[1]=d,r[2]=m,r[3]=p,r[4]=y,r[5]=O,r[6]=h,r[7]=E,r[8]=_,r):new s(l,p,h,d,y,E,m,O,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new s(1,0,0,0,i,-o,0,o,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new s(i,0,o,0,1,0,-o,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-o,0,o,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,o=e[i],a=e[i+1],u=e[i+2];return n.x=o,n.y=a,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var o=3*r;return(i=s.clone(e,i))[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],o=e[r+3],a=e[r+6];return n.x=i,n.y=o,n.z=a,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=s.clone(e,i))[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var c=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),n};var f=new e;s.getMaximumScale=function(t){return s.getScale(t,f),e.maximumComponent(f)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],a=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=p,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,o=r.y,a=r.z,u=e[0]*i+e[3]*o+e[6]*a,s=e[1]*i+e[4]*o+e[7]*a,c=e[2]*i+e[5]*o+e[8]*a;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=i,r[2]=o,r[3]=a,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var l=[1,0,0],p=[2,2,1];function h(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(p[r],l[r])];t+=2*n*n}return Math.sqrt(t)}function d(e,t){for(var r=u.EPSILON15,n=0,i=1,o=0;o<3;++o){var a=Math.abs(e[s.getElementIndex(p[o],l[o])]);a>n&&(i=o,n=a)}var c=1,f=0,h=l[i],d=p[i];if(Math.abs(e[s.getElementIndex(d,h)])>r){var y,E=(e[s.getElementIndex(d,d)]-e[s.getElementIndex(h,h)])/2/e[s.getElementIndex(d,h)];f=(y=E<0?-1/(-E+Math.sqrt(1+E*E)):1/(E+Math.sqrt(1+E*E)))*(c=1/Math.sqrt(1+y*y))}return(t=s.clone(s.IDENTITY,t))[s.getElementIndex(h,h)]=t[s.getElementIndex(d,d)]=c,t[s.getElementIndex(d,h)]=f,t[s.getElementIndex(h,d)]=-f,t}var y=new s,E=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,o=0,a=0;n(r)||(r={});for(var c=r.unitary=s.clone(s.IDENTITY,r.unitary),f=r.diagonal=s.clone(e,r.diagonal),l=i*function(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}(f);a<10&&h(f)>l;)d(f,y),s.transpose(y,E),s.multiply(f,y,f),s.multiply(E,f,f),s.multiply(c,y,c),++o>2&&(++a,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],o=e[1],a=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(a*f-c*u)+o*(c*i-n*f)+s*(n*u-a*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],a=e[2],c=e[3],f=e[4],l=e[5],p=e[6],h=e[7],d=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new o("matrix is not invertible");r[0]=f*d-h*l,r[1]=h*a-i*d,r[2]=i*l-f*a,r[3]=p*l-c*d,r[4]=n*d-p*a,r[5]=c*a-n*l,r[6]=c*h-p*f,r[7]=p*i-n*h,r[8]=n*f-c*i;var E=1/y;return s.multiplyByScalar(r,E,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=a(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=a(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s})),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o){"use strict";function a(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}a.fromElements=function(e,t,n,i,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=i,o):new a(e,t,n,i)},a.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new a(t.red,t.green,t.blue,t.alpha)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w)},a.packedLength=4,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i++],o.w=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var o=0;o<i;++o)a.pack(t[o],n,4*o);return n},a.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var o=0;o<i;o+=4){var u=o/4;n[u]=a.unpack(t,o,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a;a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,c);return a.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?a.clone(a.UNIT_X,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r):n.y<=n.z?n.y<=n.w?a.clone(a.UNIT_Y,r):a.clone(a.UNIT_W,r):n.z<=n.w?a.clone(a.UNIT_Z,r):a.clone(a.UNIT_W,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)&&o.equalsEpsilon(e.z,t.z,n,i)&&o.equalsEpsilon(e.w,t.w,n,i)},a.ZERO=i(new a(0,0,0,0)),a.UNIT_X=i(new a(1,0,0,0)),a.UNIT_Y=i(new a(0,1,0,0)),a.UNIT_Z=i(new a(0,0,1,0)),a.UNIT_W=i(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1);return a.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new a),f[0]=t,0===(t=f[0]))return a.clone(a.ZERO,n);var i,u=t<0?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(o.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=38);var s=256*t;return n.x=Math.floor(s),s=256*(s-n.x),n.y=Math.floor(s),s=256*(s-n.y),n.z=Math.floor(s),n.w=2*(i+38)+u,n},a.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(i=-(i=2*i-1),(n-=38)>=38)return i<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var o=i*t.x*(1/256);return o+=i*t.y*(1/65536),(o+=i*t.z*(1/16777216))*Math.pow(10,n)},a})),define("Core/RuntimeError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t})),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],(function(e,t,r,n,i,o,a,u,s,c){"use strict";function f(e,t,r,i,o,a,u,s,c,f,l,p,h,d,y,E){this[0]=n(e,0),this[1]=n(o,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(a,0),this[6]=n(f,0),this[7]=n(d,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(p,0),this[15]=n(E,0)}f.packedLength=16,f.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},f.unpack=function(e,t,o){return r.defined("array",e),t=n(t,0),i(o)||(o=new f),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o[9]=e[t++],o[10]=e[t++],o[11]=e[t++],o[12]=e[t++],o[13]=e[t++],o[14]=e[t++],o[15]=e[t],o},f.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,o,a){return r.typeOf.object("rotation",t),o=n(o,e.ZERO),i(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new f(t[0],t[3],t[6],o.x,t[1],t[4],t[7],o.y,t[2],t[5],t[8],o.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,o){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(o)||(o=new f);var a=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,p=t.x*t.z,h=t.x*t.w,d=t.y*t.y,y=t.y*t.z,E=t.y*t.w,m=t.z*t.z,O=t.z*t.w,_=t.w*t.w,T=c-d-m+_,R=2*(l-O),A=2*(p+E),w=2*(l+O),b=-c+d-m+_,S=2*(y-h),g=2*(p-E),N=2*(y+h),I=-c-d+m+_;return o[0]=T*a,o[1]=w*a,o[2]=g*a,o[3]=0,o[4]=R*u,o[5]=b*u,o[6]=N*u,o[7]=0,o[8]=A*s,o[9]=S*s,o[10]=I*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,p=new e,h=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var o=t.position,a=t.direction,u=t.up;r.typeOf.object("camera.position",o),r.typeOf.object("camera.direction",a),r.typeOf.object("camera.up",u),e.normalize(a,l),e.normalize(e.cross(l,u,p),p),e.normalize(e.cross(p,l,h),h);var s=p.x,c=p.y,d=p.z,y=l.x,E=l.y,m=l.z,O=h.x,_=h.y,T=h.z,R=o.x,A=o.y,w=o.z,b=s*-R+c*-A+d*-w,S=O*-R+_*-A+T*-w,g=y*R+E*A+m*w;return i(n)?(n[0]=s,n[1]=O,n[2]=-y,n[3]=0,n[4]=c,n[5]=_,n[6]=-E,n[7]=0,n[8]=d,n[9]=T,n[10]=-m,n[11]=0,n[12]=b,n[13]=S,n[14]=g,n[15]=1,n):new f(s,c,d,b,O,_,T,S,-y,-E,-m,g,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,i,o){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",o);var a=1/Math.tan(.5*e),u=a/t,s=(i+n)/(n-i),c=2*i*n/(n-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=a,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=s,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o},f.computeOrthographicOffCenter=function(e,t,n,i,o,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),f=1/(a-o),l=-(t+e)*s,p=-(i+n)*c,h=-(a+o)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=p,u[14]=h,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,i,o,a,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.number("far",a),r.typeOf.object("result",u);var s=2*o/(t-e),c=2*o/(i-n),f=(t+e)/(t-e),l=(i+n)/(i-n),p=-(a+o)/(a-o),h=-2*a*o/(a-o);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=p,u[11]=-1,u[12]=0,u[13]=0,u[14]=h,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,i,o,a){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",o),r.typeOf.object("result",a);var u=2*o/(t-e),s=2*o/(i-n),c=(t+e)/(t-e),f=(i+n)/(i-n),l=-2*o;return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=c,a[9]=f,a[10]=-1,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},f.computeViewportTransformation=function(e,t,i,o){r.typeOf.object("result",o),e=n(e,n.EMPTY_OBJECT);var a=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0);var f=.5*s,l=.5*c,p=.5*((i=n(i,1))-t),h=f,d=l,y=p,E=a+f,m=u+l,O=t+p;return o[0]=h,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=d,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=y,o[11]=0,o[12]=E,o[13]=m,o[14]=O,o[15]=1,o},f.computeView=function(t,n,i,o,a){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",o),r.typeOf.object("result",a),a[0]=o.x,a[1]=i.x,a[2]=-n.x,a[3]=0,a[4]=o.y,a[5]=i.y,a[6]=-n.y,a[7]=0,a[8]=o.z,a[9]=i.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(o,t),a[13]=-e.dot(i,t),a[14]=e.dot(n,t),a[15]=1,a},f.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,o=e[i],a=e[i+1],u=e[i+2],s=e[i+3];return n.x=o,n.y=a,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i);var o=4*t;return(i=f.clone(e,i))[o]=n.x,i[o+1]=n.y,i[o+2]=n.z,i[o+3]=n.w,i},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var d=new e;f.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var o=f.getScale(t,d),a=e.divideComponents(n,o,d);return f.multiplyByScale(t,a,i)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],o=e[t+4],a=e[t+8],u=e[t+12];return n.x=i,n.y=o,n.z=a,n.w=u,n},f.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),(i=f.clone(e,i))[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var y=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var E=new e;f.getMaximumScale=function(t){return f.getScale(t,E),e.maximumComponent(E)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],p=e[8],h=e[9],d=e[10],y=e[11],E=e[12],m=e[13],O=e[14],_=e[15],T=t[0],R=t[1],A=t[2],w=t[3],b=t[4],S=t[5],g=t[6],N=t[7],I=t[8],v=t[9],M=t[10],x=t[11],C=t[12],P=t[13],U=t[14],D=t[15],F=i*T+s*R+p*A+E*w,L=o*T+c*R+h*A+m*w,j=a*T+f*R+d*A+O*w,q=u*T+l*R+y*A+_*w,B=i*b+s*S+p*g+E*N,z=o*b+c*S+h*g+m*N,G=a*b+f*S+d*g+O*N,V=u*b+l*S+y*g+_*N,X=i*I+s*v+p*M+E*x,W=o*I+c*v+h*M+m*x,H=a*I+f*v+d*M+O*x,k=u*I+l*v+y*M+_*x,Y=i*C+s*P+p*U+E*D,K=o*C+c*P+h*U+m*D,Z=a*C+f*P+d*U+O*D,J=u*C+l*P+y*U+_*D;return n[0]=F,n[1]=L,n[2]=j,n[3]=q,n[4]=B,n[5]=z,n[6]=G,n[7]=V,n[8]=X,n[9]=W,n[10]=H,n[11]=k,n[12]=Y,n[13]=K,n[14]=Z,n[15]=J,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],h=e[12],d=e[13],y=e[14],E=t[0],m=t[1],O=t[2],_=t[4],T=t[5],R=t[6],A=t[8],w=t[9],b=t[10],S=t[12],g=t[13],N=t[14],I=i*E+u*m+f*O,v=o*E+s*m+l*O,M=a*E+c*m+p*O,x=i*_+u*T+f*R,C=o*_+s*T+l*R,P=a*_+c*T+p*R,U=i*A+u*w+f*b,D=o*A+s*w+l*b,F=a*A+c*w+p*b,L=i*S+u*g+f*N+h,j=o*S+s*g+l*N+d,q=a*S+c*g+p*N+y;return n[0]=I,n[1]=v,n[2]=M,n[3]=0,n[4]=x,n[5]=C,n[6]=P,n[7]=0,n[8]=U,n[9]=D,n[10]=F,n[11]=0,n[12]=L,n[13]=j,n[14]=q,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],h=t[0],d=t[1],y=t[2],E=t[3],m=t[4],O=t[5],_=t[6],T=t[7],R=t[8],A=i*h+u*d+f*y,w=o*h+s*d+l*y,b=a*h+c*d+p*y,S=i*E+u*m+f*O,g=o*E+s*m+l*O,N=a*E+c*m+p*O,I=i*_+u*T+f*R,v=o*_+s*T+l*R,M=a*_+c*T+p*R;return n[0]=A,n[1]=w,n[2]=b,n[3]=0,n[4]=S,n[5]=g,n[6]=N,n[7]=0,n[8]=I,n[9]=v,n[10]=M,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=i*e[0]+o*e[4]+a*e[8]+e[12],s=i*e[1]+o*e[5]+a*e[9]+e[13],c=i*e[2]+o*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var m=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),m.x=t,m.y=t,m.z=t,f.multiplyByScale(e,m,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z;return 1===i&&1===o&&1===a?f.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=o*e[4],n[5]=o*e[5],n[6]=o*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=t.w,s=e[0]*i+e[4]*o+e[8]*a+e[12]*u,c=e[1]*i+e[5]*o+e[9]*a+e[13]*u,f=e[2]*i+e[6]*o+e[10]*a+e[14]*u,l=e[3]*i+e[7]*o+e[11]*a+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=e[0]*i+e[4]*o+e[8]*a,s=e[1]*i+e[5]*o+e[9]*a,c=e[2]*i+e[6]*o+e[10]*a;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,o=t.y,a=t.z,u=e[0]*i+e[4]*o+e[8]*a+e[12],s=e[1]*i+e[5]*o+e[9]*a+e[13],c=e[2]*i+e[6]*o+e[10]*a+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],o=e[3],a=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=o,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,_=new s,T=new t,R=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],o=e[4],a=e[8],l=e[12],p=e[1],h=e[5],d=e[9],y=e[13],E=e[2],m=e[6],A=e[10],w=e[14],b=e[3],S=e[7],g=e[11],N=e[15],I=A*N,v=w*g,M=m*N,x=w*S,C=m*g,P=A*S,U=E*N,D=w*b,F=E*g,L=A*b,j=E*S,q=m*b,B=I*h+x*d+C*y-(v*h+M*d+P*y),z=v*p+U*d+L*y-(I*p+D*d+F*y),G=M*p+D*h+j*y-(x*p+U*h+q*y),V=P*p+F*h+q*d-(C*p+L*h+j*d),X=v*o+M*a+P*l-(I*o+x*a+C*l),W=I*i+D*a+F*l-(v*i+U*a+L*l),H=x*i+U*o+q*l-(M*i+D*o+j*l),k=C*i+L*o+j*a-(P*i+F*o+q*a),Y=(I=a*y)*S+(x=l*h)*g+(C=o*d)*N-((v=l*d)*S+(M=o*y)*g+(P=a*h)*N),K=v*b+(U=i*y)*g+(L=a*p)*N-(I*b+(D=l*p)*g+(F=i*d)*N),Z=M*b+D*S+(j=i*h)*N-(x*b+U*S+(q=o*p)*N),J=P*b+F*S+q*g-(C*b+L*S+j*g),Q=M*A+P*w+v*m-(C*w+I*m+x*A),$=F*w+I*E+D*A-(U*A+L*w+v*E),ee=U*m+q*w+x*E-(j*w+M*E+D*m),te=j*A+C*E+L*m-(F*m+q*A+P*E),re=i*B+o*z+a*G+l*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(f.getRotation(e,O),_,u.EPSILON7)&&t.equals(f.getRow(e,3,T),R))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=B*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=X*re,n[5]=W*re,n[6]=H*re,n[7]=k*re,n[8]=Y*re,n[9]=K*re,n[10]=Z*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],o=e[2],a=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],p=e[12],h=e[13],d=e[14],y=-n*p-i*h-o*d,E=-a*p-u*h-s*d,m=-c*p-f*h-l*d;return t[0]=n,t[1]=a,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=f,t[7]=0,t[8]=o,t[9]=s,t[10]=l,t[11]=0,t[12]=y,t[13]=E,t[14]=m,t[15]=1,t},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,o(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f})),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,o,a){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),o=u.toRadians(r(o,0)),n(a)?(a.west=e,a.south=t,a.east=i,a.north=o,a):new s(e,t,i,o)},s.fromRadians=function(e,t,i,o,a){return n(a)?(a.west=r(e,0),a.south=r(t,0),a.east=r(i,0),a.north=r(o,0),a):new s(e,t,i,o)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,p=0,h=e.length;p<h;p++){var d=e[p];i=Math.min(i,d.longitude),o=Math.max(o,d.longitude),f=Math.min(f,d.latitude),l=Math.max(l,d.latitude);var y=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;a=Math.min(a,y),c=Math.max(c,y)}return o-i>c-a&&(i=a,(o=c)>u.PI&&(o-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=f,r.east=o,r.north=l,r):new s(i,f,o,l)},s.fromCartesianArray=function(e,i,a){t.defined("cartesians",e),i=r(i,o.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,h=Number.MAX_VALUE,d=-Number.MAX_VALUE,y=0,E=e.length;y<E;y++){var m=i.cartesianToCartographic(e[y]);c=Math.min(c,m.longitude),f=Math.max(f,m.longitude),h=Math.min(h,m.latitude),d=Math.max(d,m.latitude);var O=m.longitude>=0?m.longitude:m.longitude+u.TWO_PI;l=Math.min(l,O),p=Math.max(p,O)}return f-c>p-l&&(c=l,(f=p)>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(a)?(a.west=c,a.south=h,a.east=f,a.north=d,a):new s(c,h,f,d)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var o=e.east;t.typeOf.number.greaterThanOrEquals("east",o,-Math.PI),t.typeOf.number.lessThanOrEquals("east",o,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var o=r.east,a=r.west;o<a&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var o=e.east,a=e.west,c=r.east,f=r.west;o<a&&c>0?o+=u.TWO_PI:c<f&&o>0&&(c+=u.TWO_PI),o<a&&f<0?f+=u.TWO_PI:c<f&&a<0&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,f)),p=u.negativePiToPi(Math.min(o,c));if(!((e.west<e.east||r.west<r.east)&&p<=l)){var h=Math.max(e.south,r.south),d=Math.min(e.north,r.north);if(!(h>=d))return n(i)?(i.west=l,i.south=h,i.east=p,i.north=d,i):new s(l,h,p,d)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(a>=c||o>=u))return n(i)?(i.west=o,i.south=a,i.east=u,i.north=c,i):new s(o,a,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var o=e.east,a=e.west,c=r.east,f=r.west;o<a&&c>0?o+=u.TWO_PI:c<f&&o>0&&(c+=u.TWO_PI),o<a&&f<0?f+=u.TWO_PI:c<f&&a<0&&(a+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(a,f)),p=u.convertLongitudeRange(Math.max(o,c));return i.west=l,i.south=Math.min(e.south,r.south),i.east=p,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,o=e.west,a=e.east;return a<o&&(a+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>o||u.equalsEpsilon(n,o,u.EPSILON14))&&(n<a||u.equalsEpsilon(n,a,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,a,f){t.typeOf.object("rectangle",e),i=r(i,o.WGS84),a=r(a,0),n(f)||(f=[]);var l=0,p=e.north,h=e.south,d=e.east,y=e.west,E=c;E.height=a,E.longitude=y,E.latitude=p,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=d,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.latitude=h,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=y,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.latitude=p<0?p:h>0?h:0;for(var m=1;m<8;++m)E.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,E)&&(f[l]=i.cartographicToCartesian(E,f[l]),l++);return 0===E.latitude&&(E.longitude=y,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=d,f[l]=i.cartographicToCartesian(E,f[l]),l++),f.length=l,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s})),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],(function(e,t,r,n,i,o,a,u,s,c,f,l,p){"use strict";function h(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var d=new e,y=new e,E=new e,m=new e,O=new e,_=new e,T=new e,R=new e,A=new e,w=new e,b=new e,S=new e,g=4/3*c.PI;h.fromPoints=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,o=e.clone(t[0],T),a=e.clone(o,d),u=e.clone(o,y),s=e.clone(o,E),c=e.clone(o,m),f=e.clone(o,O),l=e.clone(o,_),p=t.length;for(n=1;n<p;n++){e.clone(t[n],o);var g=o.x,N=o.y,I=o.z;g<a.x&&e.clone(o,a),g>c.x&&e.clone(o,c),N<u.y&&e.clone(o,u),N>f.y&&e.clone(o,f),I<s.z&&e.clone(o,s),I>l.z&&e.clone(o,l)}var v=e.magnitudeSquared(e.subtract(c,a,R)),M=e.magnitudeSquared(e.subtract(f,u,R)),x=e.magnitudeSquared(e.subtract(l,s,R)),C=a,P=c,U=v;M>U&&(U=M,C=u,P=f),x>U&&(U=x,C=s,P=l);var D=A;D.x=.5*(C.x+P.x),D.y=.5*(C.y+P.y),D.z=.5*(C.z+P.z);var F=e.magnitudeSquared(e.subtract(P,D,R)),L=Math.sqrt(F),j=w;j.x=a.x,j.y=u.y,j.z=s.z;var q=b;q.x=c.x,q.y=f.y,q.z=l.z;var B=e.midpoint(j,q,S),z=0;for(n=0;n<p;n++){e.clone(t[n],o);var G=e.magnitude(e.subtract(o,B,R));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(o,D,R));if(V>F){var X=Math.sqrt(V);F=(L=.5*(L+X))*L;var W=X-L;D.x=(L*D.x+W*o.x)/X,D.y=(L*D.y+W*o.y)/X,D.z=(L*D.z+W*o.z)/X}}return L<z?(e.clone(D,r.center),r.radius=L):(e.clone(B,r.center),r.radius=z),r};var N=new a,I=new e,v=new e,M=new t,x=new t;h.fromRectangle2D=function(e,t,r){return h.fromRectangleWithHeights2D(e,t,0,0,r)},h.fromRectangleWithHeights2D=function(t,r,o,a,u){if(i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,N),p.southwest(t,M),M.height=o,p.northeast(t,x),x.height=a;var s=r.project(M,I),c=r.project(x,v),f=c.x-s.x,l=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+d*d);var y=u.center;return y.x=s.x+.5*f,y.y=s.y+.5*l,y.z=s.z+.5*d,u};var C=[];h.fromRectangle3D=function(t,r,a,u){if(r=n(r,o.WGS84),a=n(a,0),i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=p.subsample(t,r,a,C);return h.fromPoints(s,u)},h.fromVertices=function(t,o,a,u){if(i(u)||(u=new h),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;o=n(o,e.ZERO),a=n(a,3),r.typeOf.number.greaterThanOrEquals("stride",a,3);var s=T;s.x=t[0]+o.x,s.y=t[1]+o.y,s.z=t[2]+o.z;var c,f=e.clone(s,d),l=e.clone(s,y),p=e.clone(s,E),g=e.clone(s,m),N=e.clone(s,O),I=e.clone(s,_),v=t.length;for(c=0;c<v;c+=a){var M=t[c]+o.x,x=t[c+1]+o.y,C=t[c+2]+o.z;s.x=M,s.y=x,s.z=C,M<f.x&&e.clone(s,f),M>g.x&&e.clone(s,g),x<l.y&&e.clone(s,l),x>N.y&&e.clone(s,N),C<p.z&&e.clone(s,p),C>I.z&&e.clone(s,I)}var P=e.magnitudeSquared(e.subtract(g,f,R)),U=e.magnitudeSquared(e.subtract(N,l,R)),D=e.magnitudeSquared(e.subtract(I,p,R)),F=f,L=g,j=P;U>j&&(j=U,F=l,L=N),D>j&&(j=D,F=p,L=I);var q=A;q.x=.5*(F.x+L.x),q.y=.5*(F.y+L.y),q.z=.5*(F.z+L.z);var B=e.magnitudeSquared(e.subtract(L,q,R)),z=Math.sqrt(B),G=w;G.x=f.x,G.y=l.y,G.z=p.z;var V=b;V.x=g.x,V.y=N.y,V.z=I.z;var X=e.midpoint(G,V,S),W=0;for(c=0;c<v;c+=a){s.x=t[c]+o.x,s.y=t[c+1]+o.y,s.z=t[c+2]+o.z;var H=e.magnitude(e.subtract(s,X,R));H>W&&(W=H);var k=e.magnitudeSquared(e.subtract(s,q,R));if(k>B){var Y=Math.sqrt(k);B=(z=.5*(z+Y))*z;var K=Y-z;q.x=(z*q.x+K*s.x)/Y,q.y=(z*q.y+K*s.y)/Y,q.z=(z*q.z+K*s.z)/Y}}return z<W?(e.clone(q,u.center),u.radius=z):(e.clone(X,u.center),u.radius=W),u},h.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new h),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var o=T;o.x=t[0]+r[0],o.y=t[1]+r[1],o.z=t[2]+r[2];var a,u=e.clone(o,d),s=e.clone(o,y),c=e.clone(o,E),f=e.clone(o,m),l=e.clone(o,O),p=e.clone(o,_),g=t.length;for(a=0;a<g;a+=3){var N=t[a]+r[a],I=t[a+1]+r[a+1],v=t[a+2]+r[a+2];o.x=N,o.y=I,o.z=v,N<u.x&&e.clone(o,u),N>f.x&&e.clone(o,f),I<s.y&&e.clone(o,s),I>l.y&&e.clone(o,l),v<c.z&&e.clone(o,c),v>p.z&&e.clone(o,p)}var M=e.magnitudeSquared(e.subtract(f,u,R)),x=e.magnitudeSquared(e.subtract(l,s,R)),C=e.magnitudeSquared(e.subtract(p,c,R)),P=u,U=f,D=M;x>D&&(D=x,P=s,U=l),C>D&&(D=C,P=c,U=p);var F=A;F.x=.5*(P.x+U.x),F.y=.5*(P.y+U.y),F.z=.5*(P.z+U.z);var L=e.magnitudeSquared(e.subtract(U,F,R)),j=Math.sqrt(L),q=w;q.x=u.x,q.y=s.y,q.z=c.z;var B=b;B.x=f.x,B.y=l.y,B.z=p.z;var z=e.midpoint(q,B,S),G=0;for(a=0;a<g;a+=3){o.x=t[a]+r[a],o.y=t[a+1]+r[a+1],o.z=t[a+2]+r[a+2];var V=e.magnitude(e.subtract(o,z,R));V>G&&(G=V);var X=e.magnitudeSquared(e.subtract(o,F,R));if(X>L){var W=Math.sqrt(X);L=(j=.5*(j+W))*j;var H=W-j;F.x=(j*F.x+H*o.x)/W,F.y=(j*F.y+H*o.y)/W,F.z=(j*F.z+H*o.z)/W}}return j<G?(e.clone(F,n.center),n.radius=j):(e.clone(z,n.center),n.radius=G),n},h.fromCornerPoints=function(t,n,o){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(o)||(o=new h);var a=e.midpoint(t,n,o.center);return o.radius=e.distance(a,n),o},h.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;h.fromBoundingSpheres=function(t,r){if(i(r)||(r=new h),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return h.clone(t[0],r);if(2===n)return h.union(t[0],t[1],r);var o,a=[];for(o=0;o<n;o++)a.push(t[o].center);var u=(r=h.fromPoints(a,r)).center,s=r.radius;for(o=0;o<n;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var U=new e,D=new e,F=new e;h.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new h);var o=t.halfAxes,a=f.getColumn(o,0,U),u=f.getColumn(o,1,D),s=f.getColumn(o,2,F);return e.add(a,u,a),e.add(a,s,a),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(a),n},h.clone=function(t,r){if(i(t))return i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new h(t.center,t.radius)},h.packedLength=4,h.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var o=e.center;return t[i++]=o.x,t[i++]=o.y,t[i++]=o.z,t[i]=e.radius,t},h.unpack=function(e,t,o){r.defined("array",e),t=n(t,0),i(o)||(o=new h);var a=o.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],o.radius=e[t],o};var L=new e,j=new e;h.union=function(t,n,o){r.typeOf.object("left",t),r.typeOf.object("right",n),i(o)||(o=new h);var a=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,a,L),l=e.magnitude(f);if(u>=l+c)return t.clone(o),o;if(c>=l+u)return n.clone(o),o;var p=.5*(u+l+c),d=e.multiplyByScalar(f,(-u+p)/l,j);return e.add(d,a,d),e.clone(d,o.center),o.radius=p,o};var q=new e;h.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=h.clone(t,i);var o=e.magnitude(e.subtract(n,i.center,q));return o>i.radius&&(i.radius=o),i},h.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,o=t.radius,a=n.normal,s=e.dot(a,i)+n.distance;return s<-o?u.OUTSIDE:s<o?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var B=new e;h.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,B);return e.magnitudeSquared(i)-t.radius*t.radius},h.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;h.computePlaneDistances=function(t,n,o,a){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",o),i(a)||(a=new s);var u=e.subtract(t.center,n,z),c=e.dot(o,u);return a.start=c-t.radius,a.stop=c+t.radius,a};for(var G=new e,V=new e,X=new e,W=new e,H=new e,k=new t,Y=new Array(8),K=0;K<8;++K)Y[K]=new e;var Z=new a;return h.projectTo2D=function(t,i,o){r.typeOf.object("sphere",t);var a=(i=n(i,Z)).ellipsoid,u=t.center,s=t.radius,c=a.geodeticSurfaceNormal(u,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,X);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var p=e.negate(l,H),d=e.negate(f,W),y=Y,E=y[0];e.add(c,l,E),e.add(E,f,E),E=y[1],e.add(c,l,E),e.add(E,d,E),E=y[2],e.add(c,p,E),e.add(E,d,E),E=y[3],e.add(c,p,E),e.add(E,f,E),e.negate(c,c),E=y[4],e.add(c,l,E),e.add(E,f,E),E=y[5],e.add(c,l,E),e.add(E,d,E),E=y[6],e.add(c,p,E),e.add(E,d,E),E=y[7],e.add(c,p,E),e.add(E,f,E);for(var m=y.length,O=0;O<m;++O){var _=y[O];e.add(u,_,_);var T=a.cartesianToCartographic(_,k);i.project(T,_)}var R=(u=(o=h.fromPoints(y,o)).center).x,A=u.y,w=u.z;return u.x=w,u.y=R,u.z=A,o},h.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},h.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,r){return h.computePlaneDistances(this,e,t,r)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h.prototype.volume=function(){var e=this.radius;return g*e*e*e},h})),define("Core/Fullscreen",["./defined","./defineProperties"],(function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;a<u;++a){var s=o[a];("function"==typeof t[i=s+"RequestFullscreen"]||"function"==typeof t[i=s+"RequestFullScreen"])&&(n.requestFullscreen=i,r=!0),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i})),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],(function(e,t,r){"use strict";var n,i,o,a,u,s,c,f,l,p,h,d,y,E,m,O,_;function T(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function R(){if(!t(i)&&(i=!1,!S())){var e=/ Chrome\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(i=!0,o=T(e[1]))}return i}function A(){if(!t(a)&&(a=!1,!R()&&!S()&&/ Safari\/[\.0-9]+/.test(n.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(a=!0,u=T(e[1]))}return a}function w(){if(!t(s)){s=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(n.userAgent);null!==e&&(s=!0,(c=T(e[1])).isNightly=!!e[2])}return s}function b(){var e;return t(f)||(f=!1,"Microsoft Internet Explorer"===n.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=T(e[1])):"Netscape"===n.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=T(e[1]))),f}function S(){if(!t(p)){p=!1;var e=/ Edge\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(p=!0,h=T(e[1]))}return p}function g(){if(!t(d)){d=!1;var e=/Firefox\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(d=!0,y=T(e[1]))}return d}function N(){if(!t(_)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;(_=t(r)&&""!==r)&&(O=r)}return _}n="undefined"!=typeof navigator?navigator:{};var I=[];"undefined"!=typeof ArrayBuffer&&(I.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&I.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&I.push(CanvasPixelArray));var v={isChrome:R,chromeVersion:function(){return R()&&o},isSafari:A,safariVersion:function(){return A()&&u},isWebkit:w,webkitVersion:function(){return w()&&c},isInternetExplorer:b,internetExplorerVersion:function(){return b()&&l},isEdge:S,edgeVersion:function(){return S()&&h},isFirefox:g,firefoxVersion:function(){return g()&&y},isWindows:function(){return t(E)||(E=/Windows/i.test(n.appVersion)),E},hardwareConcurrency:e(n.hardwareConcurrency,3),supportsPointerEvents:function(){return t(m)||(m=!g()&&"undefined"!=typeof PointerEvent&&(!t(n.pointerEnabled)||n.pointerEnabled)),m},supportsImageRenderingPixelated:N,imageRenderingValue:function(){return N()?O:void 0},typedArrayTypes:I,supportsFullscreen:function(){return r.supportsFullscreen()},supportsTypedArrays:function(){return"undefined"!=typeof ArrayBuffer},supportsWebWorkers:function(){return"undefined"!=typeof Worker},supportsWebAssembly:function(){return"undefined"!=typeof WebAssembly&&!v.isEdge()}};return v})),define("Core/WebGLConstants",["./freezeObject"],(function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})})),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],(function(e,t,r,n,i,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:o.BYTE,UNSIGNED_BYTE:o.UNSIGNED_BYTE,SHORT:o.SHORT,UNSIGNED_SHORT:o.UNSIGNED_SHORT,INT:o.INT,UNSIGNED_INT:o.UNSIGNED_INT,FLOAT:o.FLOAT,DOUBLE:o.DOUBLE,getSizeInBytes:function(e){if(!t(e))throw new r("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.INT:return Int32Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},fromTypedArray:function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Int32Array?a.INT:e instanceof Uint32Array?a.UNSIGNED_INT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},validate:function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.INT||e===a.UNSIGNED_INT||e===a.FLOAT||e===a.DOUBLE)},createTypedArray:function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(n);case a.UNSIGNED_BYTE:return new Uint8Array(n);case a.SHORT:return new Int16Array(n);case a.UNSIGNED_SHORT:return new Uint16Array(n);case a.INT:return new Int32Array(n);case a.UNSIGNED_INT:return new Uint32Array(n);case a.FLOAT:return new Float32Array(n);case a.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},createArrayBufferView:function(n,i,o,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(o=e(o,0),u=e(u,(i.byteLength-o)/a.getSizeInBytes(n)),n){case a.BYTE:return new Int8Array(i,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,u);case a.SHORT:return new Int16Array(i,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,u);case a.INT:return new Int32Array(i,o,u);case a.UNSIGNED_INT:return new Uint32Array(i,o,u);case a.FLOAT:return new Float32Array(i,o,u);case a.DOUBLE:return new Float64Array(i,o,u);default:throw new r("componentDatatype is not a valid value.")}},fromName:function(e){switch(e){case"BYTE":return a.BYTE;case"UNSIGNED_BYTE":return a.UNSIGNED_BYTE;case"SHORT":return a.SHORT;case"UNSIGNED_SHORT":return a.UNSIGNED_SHORT;case"INT":return a.INT;case"UNSIGNED_INT":return a.UNSIGNED_INT;case"FLOAT":return a.FLOAT;case"DOUBLE":return a.DOUBLE;default:throw new r("name is not a valid value.")}}};return i(a)})),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,o){"use strict";function a(e,r){this.x=t(e,0),this.y=t(r,0)}a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y)},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},a.unpack=function(n,i,o){return e.defined("array",n),i=t(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var o=0;o<i;++o)a.pack(t[o],n,2*o);return n},a.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var o=0;o<i;o+=2){var u=o/2;n[u]=a.unpack(t,o,n[u])}return n},a.fromArray=a.unpack,a.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},a.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},a.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},a.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},a.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var u=new a;a.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitude(u)},a.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.subtract(t,r,u),a.magnitudeSquared(u)},a.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=a.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},a.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},a.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},a.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},a.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},a.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},a.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},a.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},a.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},a.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new a;a.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),a.multiplyByScalar(r,n,s),i=a.multiplyByScalar(t,1-n,i),a.add(s,i,i)};var c=new a,f=new a;a.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),a.normalize(t,c),a.normalize(r,f),o.acosClamped(a.dot(c,f))};var l=new a;return a.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=a.normalize(t,l);return a.abs(n,n),r=n.x<=n.y?a.clone(a.UNIT_X,r):a.clone(a.UNIT_Y,r)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},a.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&o.equalsEpsilon(e.x,t.x,n,i)&&o.equalsEpsilon(e.y,t.y,n,i)},a.ZERO=i(new a(0,0)),a.UNIT_X=i(new a(1,0)),a.UNIT_Y=i(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a})),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],(function(e){"use strict";return e({NONE:0,TOP:1,ALL:2})})),define("Core/GeometryType",["./freezeObject"],(function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})})),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],(function(e,t,r,n,i,o){"use strict";function a(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}a.packedLength=4,a.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},a.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new a),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o},a.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new a(e[0],e[2],e[1],e[3])},a.fromArray=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new a),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o},a.fromColumnMajorArray=function(e,r){return t.defined("values",e),a.clone(e,r)},a.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new a(e[0],e[1],e[2],e[3])},a.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new a(e.x,0,0,e.y)},a.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new a(e,0,0,e)},a.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),o=Math.sin(e);return n(r)?(r[0]=i,r[1]=o,r[2]=-o,r[3]=i,r):new a(i,-o,o,i)},a.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},a.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},a.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,o=e[i],a=e[i+1];return n.x=o,n.y=a,n},a.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var o=2*r;return(i=a.clone(e,i))[o]=n.x,i[o+1]=n.y,i},a.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],o=e[r+2];return n.x=i,n.y=o,n},a.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=a.clone(e,i))[r]=n.x,i[r+2]=n.y,i};var u=new e;a.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return a.getMaximumScale=function(t){return a.getScale(t,s),e.maximumComponent(s)},a.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],o=e[0]*r[2]+e[2]*r[3],a=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n},a.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},a.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},a.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,o=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=o,n},a.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},a.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},a.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},a.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],o=e[1],a=e[3];return r[0]=n,r[1]=i,r[2]=o,r[3]=a,r},a.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},a.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},a.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},a.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},a.IDENTITY=o(new a(1,0,0,1)),a.ZERO=o(new a(0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,i(a.prototype,{length:{get:function(){return a.packedLength}}}),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,t){return a.equalsEpsilon(this,e,t)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},a})),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],(function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)})),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,o){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var a=i/2,u=Math.sin(a),f=(c=e.normalize(r,c)).x*u,l=c.y*u,p=c.z*u,h=Math.cos(a);return n(o)?(o.x=f,o.y=l,o.z=p,o.w=h,o):new s(f,l,p,h)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){var i,o,a,c,p;t.typeOf.object("matrix",e);var h=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],y=e[u.COLUMN2ROW2],E=h+d+y;if(E>0)p=.5*(i=Math.sqrt(E+1)),i=.5/i,o=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var m=0;d>h&&(m=1),y>h&&y>d&&(m=2);var O=f[m],_=f[O];i=Math.sqrt(e[u.getElementIndex(m,m)]-e[u.getElementIndex(O,O)]-e[u.getElementIndex(_,_)]+1);var T=l;T[m]=.5*i,i=.5/i,p=(e[u.getElementIndex(_,O)]-e[u.getElementIndex(O,_)])*i,T[O]=(e[u.getElementIndex(O,m)]+e[u.getElementIndex(m,O)])*i,T[_]=(e[u.getElementIndex(_,m)]+e[u.getElementIndex(m,_)])*i,o=-T[0],a=-T[1],c=-T[2]}return n(r)?(r.x=o,r.y=a,r.z=c,r.w=p,r):new s(o,a,c,p)};var p=new s,h=new s,d=new s,y=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=s.fromAxisAngle(e.UNIT_X,r.roll,p),d=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(d,y,d),h=s.fromAxisAngle(e.UNIT_Z,-r.heading,p),s.multiply(h,n,n)};var E=new e,m=new e,O=new s,_=new s,T=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,o){return t.defined("array",e),i=r(i,0),n(o)||(o=new s),o.x=e[i],o.y=e[i+1],o.z=e[i+2],o.w=e[i+3],o},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,T),s.conjugate(T,T);for(var i=0,o=r-t+1;i<o;i++){var a=3*i;s.unpack(e,4*(t+i),O),s.multiply(O,T,O),O.w<0&&s.negate(O,O),s.computeAxis(O,E);var u=s.computeAngle(O);n[a]=E.x*u,n[a+1]=E.y*u,n[a+2]=E.z*u}},s.unpackInterpolationResult=function(t,r,i,o,a){n(a)||(a=new s),e.fromArray(t,0,m);var u=e.magnitude(m);return s.unpack(r,4*o,_),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(m,u,O),s.multiply(O,_,a)},s.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w)},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,o=e.y*n,a=e.z*n,u=e.w*n;return r.x=i,r.y=o,r.z=a,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,o=e.y,a=e.z,u=e.w,s=r.x,c=r.y,f=r.z,l=r.w,p=u*s+i*l+o*f-a*c,h=u*c-i*f+o*l+a*s,d=u*f+i*c-o*s+a*l,y=u*l-i*s-o*c-a*f;return n.x=p,n.y=h,n.z=d,n.w=y,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var R=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),R=s.multiplyByScalar(r,n,R),i=s.multiplyByScalar(e,1-n,i),s.add(R,i,i)};var A=new s,w=new s,b=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var o=s.dot(e,r),u=r;if(o<0&&(o=-o,u=A=s.negate(r,A)),1-o<a.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(o);return w=s.multiplyByScalar(e,Math.sin((1-n)*c),w),b=s.multiplyByScalar(u,Math.sin(n*c),b),i=s.add(w,b,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=a.acosClamped(r.w),o=0;return 0!==i&&(o=i/Math.sin(i)),e.multiplyByScalar(r,o,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),o=0;return 0!==i&&(o=Math.sin(i)/i),n.x=r.x*o,n.y=r.y*o,n.z=r.z*o,n.w=Math.cos(i),n};var S=new e,g=new e,N=new s,I=new s;s.computeInnerQuadrangle=function(r,n,i,o){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",o);var a=s.conjugate(n,N);s.multiply(a,i,I);var u=s.log(I,S);s.multiply(a,r,I);var c=s.log(I,g);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,N),s.multiply(n,N,o)},s.squad=function(e,r,n,i,o,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",o),t.typeOf.object("result",a);var u=s.slerp(e,r,o,N),c=s.slerp(n,i,o,I);return s.slerp(u,c,2*o*(1-o),a)};for(var v=new s,M=1.9011074535173003,x=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],U=i.supportsTypedArrays()?new Float32Array(8):[],D=0;D<7;++D){var F=D+1,L=2*F+1;x[D]=1/(F*L),C[D]=F/L}return x[7]=M/136,C[7]=8*M/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var o,a=s.dot(e,r);a>=0?o=1:(o=-1,a=-a);for(var u=a-1,c=1-n,f=n*n,l=c*c,p=7;p>=0;--p)P[p]=(x[p]*f-C[p])*u,U[p]=(x[p]*l-C[p])*u;var h=o*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),d=c*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),y=s.multiplyByScalar(e,d,v);return s.multiplyByScalar(r,h,i),s.add(y,i,i)},s.fastSquad=function(e,r,n,i,o,a){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",o),t.typeOf.object("result",a);var u=s.fastSlerp(e,r,o,N),c=s.fastSlerp(n,i,o,I);return s.fastSlerp(u,c,2*o*(1-o),a)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=o(new s(0,0,0,0)),s.IDENTITY=o(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s})),
/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */
function(e){"use strict";e("ThirdParty/when",[],(function(){var e,t;function r(e,t,r,i){return n(e).then(t,r,i)}function n(e){var t,r,s;return e instanceof i?t=e:u(e)?(r=a(),e.then((function(e){r.resolve(e)}),(function(e){r.reject(e)}),(function(e){r.progress(e)})),t=r.promise):(s=e,t=new i((function(e){try{return n(e?e(s):s)}catch(e){return o(e)}}))),t}function i(e){this.then=e}function o(e){return new i((function(t,r){try{return r?n(r(e)):o(e)}catch(e){return o(e)}}))}function a(){var e,t,r,u,s,c;return e=new i(f),t=[],r=[],u=function(e,n,i){var o,u;return o=a(),u="function"==typeof i?function(e){try{o.progress(i(e))}catch(e){o.progress(e)}}:function(e){o.progress(e)},t.push((function(t){t.then(e,n).then(o.resolve,o.reject,u)})),r.push(u),o.promise},s=function(e){return l(r,e),e},c=function(e){return e=n(e),u=e.then,c=n,s=h,l(t,e),r=t=void 0,e},{then:f,resolve:p,reject:d,progress:y,promise:e,resolver:{resolve:p,reject:d,progress:y}};function f(e,t,r){return u(e,t,r)}function p(e){return c(e)}function d(e){return c(o(e))}function y(e){return s(e)}}function u(e){return e&&"function"==typeof e.then}function s(e,t,n,i,o){return p(2,arguments),r(e,(function(e){var u,s,c,f,l,p,d,y,E,m;if(E=e.length>>>0,u=Math.max(0,Math.min(t,E)),c=[],s=E-u+1,f=[],l=a(),u)for(y=l.progress,d=function(e){f.push(e),--s||(p=d=h,l.reject(f))},p=function(e){c.push(e),--u||(p=d=h,l.resolve(c))},m=0;m<E;++m)m in e&&r(e[m],_,O,y);else l.resolve(c);return l.then(n,i,o);function O(e){d(e)}function _(e){p(e)}}))}function c(e,t,r,n){return p(1,arguments),f(e,d).then(t,r,n)}function f(e,t){return r(e,(function(e){var n,i,o,u,s,c;if(o=i=e.length>>>0,n=[],c=a(),o)for(u=function(e,i){r(e,t).then((function(e){n[i]=e,--o||c.resolve(n)}),c.reject)},s=0;s<i;s++)s in e?u(e[s],s):--o;else c.resolve(n);return c.promise}))}function l(e,t){for(var r,n=0;r=e[n++];)r(t)}function p(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function h(){}function d(e){return e}return r.defer=a,r.resolve=n,r.reject=function(e){return r(e,o)},r.join=function(){return f(arguments,d)},r.all=c,r.map=f,r.reduce=function(n,i){var o=t.call(arguments,1);return r(n,(function(t){var n;return n=t.length,o[0]=function(e,t,o){return r(e,(function(e){return r(t,(function(t){return i(e,t,o,n)}))}))},e.apply(t,o)}))},r.any=function(e,t,r,n){return s(e,1,(function(e){return t?t(e[0]):e[0]}),r,n)},r.some=s,r.chain=function(e,t,n){var i=arguments.length>2;return r(e,(function(e){return e=i?n:e,t.resolve(e),e}),(function(e){return t.reject(e),o(e)}),t.progress)},r.isPromise=u,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(void 0,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return c(t,(function(t){return e.apply(void 0,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,r,n,i,o;if(o=0,i=(t=Object(this)).length>>>0,(r=arguments).length<=1)for(;;){if(o in t){n=t[o++];break}if(++o>=i)throw new TypeError}else n=r[1];for(;o<i;++o)o in t&&(n=e(n,t[o],o,t));return n},r}))}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],(function(e){"use strict";return function(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,o,a=0,u=t.length-1;a<=u;)if((o=n(t[i=~~((a+u)/2)],r))<0)a=i+1;else{if(!(o>0))return i;u=i-1}return~(u+1)}})),define("Core/EarthOrientationParametersSample",[],(function(){"use strict";return function(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}})),
/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/
define("ThirdParty/sprintf",[],(function(){return function(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},o=function(e,t,r,n,o,a){var u=n-e.length;return u>0&&(e=r||!o?i(e,n,a,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,n,a,u,s){var c=e>>>0;return e=(r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"")+i(c.toString(t),u||0,"0",!1),o(e,r,n,a,s)},u=function(e,t,r,n,i,a){return null!=n&&(e=e.slice(0,n)),o(e,"",t,r,i,a)},s=function(e,n,s,c,f,l,p){var h,d,y,E,m;if("%%"==e)return"%";for(var O=!1,_="",T=!1,R=!1,A=" ",w=s.length,b=0;s&&b<w;b++)switch(s.charAt(b)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":A=s.charAt(b+1);break;case"0":T=!0;break;case"#":R=!0}if((c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0)<0&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(p)>-1?6:"d"==p?0:void 0,m=n?t[n.slice(0,-1)]:t[r++],p){case"s":return u(String(m),O,c,l,T,A);case"c":return u(String.fromCharCode(+m),O,c,l,T);case"b":return a(m,2,R,O,c,l,T);case"o":return a(m,8,R,O,c,l,T);case"x":return a(m,16,R,O,c,l,T);case"X":return a(m,16,R,O,c,l,T).toUpperCase();case"u":return a(m,10,R,O,c,l,T);case"i":case"d":return h=+m||0,m=(d=(h=Math.round(h-h%1))<0?"-":_)+i(String(Math.abs(h)),l,"0",!1),o(m,d,O,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=(h=+m)<0?"-":_,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(p.toLowerCase())],E=["toString","toUpperCase"]["eEfFgG".indexOf(p)%2],m=d+Math.abs(h)[y](l),o(m,d,O,c,T)[E]();default:return e}};return n.replace(e,s)}})),define("Core/GregorianDate",[],(function(){"use strict";return function(e,t,r,n,i,o,a,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=o,this.millisecond=a,this.isLeapSecond=u}})),define("Core/isLeapYear",["./DeveloperError"],(function(e){"use strict";return function(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4==0&&t%100!=0||t%400==0}})),define("Core/LeapSecond",[],(function(){"use strict";return function(e,t){this.julianDate=e,this.offset=t}})),define("Core/TimeConstants",["./freezeObject"],(function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})})),define("Core/TimeStandard",["./freezeObject"],(function(e){"use strict";return e({UTC:0,TAI:1})})),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,o,a,u,s,c){"use strict";var f=new o,l=[31,28,31,30,31,30,31,31,30,31,30,31];function p(e,t){return I.compare(e.julianDate,t.julianDate)}var h=new u;function d(e){h.julianDate=e;var r=I.leapSeconds,n=t(r,h,p);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;n>0&&I.secondsDifference(r[n].julianDate,e)>i&&(i=r[--n].offset),I.addSeconds(e,i,e)}function y(e,r){h.julianDate=e;var n=I.leapSeconds,i=t(n,h,p);if(i<0&&(i=~i),0===i)return I.addSeconds(e,-n[0].offset,r);if(i>=n.length)return I.addSeconds(e,-n[i-1].offset,r);var o=I.secondsDifference(n[i].julianDate,e);return 0===o?I.addSeconds(e,-n[i].offset,r):o<=1?void 0:I.addSeconds(e,-n[--i].offset,r)}function E(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,(t-=s.SECONDS_PER_DAY*n)<0&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function m(e,t,r,n,i,o,a){var u=(t-14)/12|0,c=e+4800+u,f=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var l=o+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+a*s.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}var O=/^(\d{4})$/,_=/^(\d{4})-(\d{2})$/,T=/^(\d{4})-?(\d{3})$/,R=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,A=/^(\d{4})-?(\d{2})-?(\d{2})$/,w=/([Z+\-])?(\d{2})?:?(\d{2})?$/,b=/^(\d{2})(\.\d+)?/.source+w.source,S=/^(\d{2}):?(\d{2})(\.\d+)?/.source+w.source,g=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+w.source,N="Invalid ISO 8601 date.";function I(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;E(i,t+=(e-i)*s.SECONDS_PER_DAY,this),n===c.UTC&&d(this)}I.fromGregorianDate=function(e,t){if(!(e instanceof o))throw new i("date must be a valid GregorianDate.");var r=m(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(E(r[0],r[1],t),d(t),t):new I(r[0],r[1],c.UTC)},I.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=m(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(E(r[0],r[1],t),d(t),t):new I(r[0],r[1],c.UTC)},I.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(N);var r,o,u,s,f,p=(e=e.replace(",",".")).split("T"),h=1,y=1,w=0,v=0,M=0,x=0,C=p[0],P=p[1];if(!n(C))throw new i(N);if(null!==(p=C.match(A))){if((s=C.split("-").length-1)>0&&2!==s)throw new i(N);r=+p[1],h=+p[2],y=+p[3]}else if(null!==(p=C.match(_)))r=+p[1],h=+p[2];else if(null!==(p=C.match(O)))r=+p[1];else{var U;if(null!==(p=C.match(T))){if(r=+p[1],U=+p[2],u=a(r),U<1||u&&U>366||!u&&U>365)throw new i(N)}else{if(null===(p=C.match(R)))throw new i(N);r=+p[1];var D=+p[2],F=+p[3]||0;if((s=C.split("-").length-1)>0&&(!n(p[3])&&1!==s||n(p[3])&&2!==s))throw new i(N);U=7*D+F-new Date(Date.UTC(r,0,4)).getUTCDay()-3}(o=new Date(Date.UTC(r,0,1))).setUTCDate(U),h=o.getUTCMonth()+1,y=o.getUTCDate()}if(u=a(r),h<1||h>12||y<1||(2!==h||!u)&&y>l[h-1]||u&&2===h&&y>29)throw new i(N);if(n(P)){if(null!==(p=P.match(g))){if((s=P.split(":").length-1)>0&&2!==s&&3!==s)throw new i(N);w=+p[1],v=+p[2],M=+p[3],x=1e3*+(p[4]||0),f=5}else if(null!==(p=P.match(S))){if((s=P.split(":").length-1)>2)throw new i(N);w=+p[1],v=+p[2],M=60*+(p[3]||0),f=4}else{if(null===(p=P.match(b)))throw new i(N);w=+p[1],v=60*+(p[2]||0),f=3}if(v>=60||M>=61||w>24||24===w&&(v>0||M>0||x>0))throw new i(N);var L=p[f],j=+p[f+1],q=+(p[f+2]||0);switch(L){case"+":w-=j,v-=q;break;case"-":w+=j,v+=q;break;case"Z":break;default:v+=new Date(Date.UTC(r,h-1,y,w,v)).getTimezoneOffset()}}var B=60===M;for(B&&M--;v>=60;)v-=60,w++;for(;w>=24;)w-=24,y++;for(o=u&&2===h?29:l[h-1];y>o;)y-=o,++h>12&&(h-=12,r++),o=u&&2===h?29:l[h-1];for(;v<0;)v+=60,w--;for(;w<0;)w+=24,y--;for(;y<1;)--h<1&&(h+=12,r--),y+=o=u&&2===h?29:l[h-1];var z=m(r,h,y,w,v,M,x);return n(t)?(E(z[0],z[1],t),d(t)):t=new I(z[0],z[1],c.UTC),B&&I.addSeconds(t,1,t),t},I.now=function(e){return I.fromDate(new Date,e)};var v=new I(0,0,c.TAI);return I.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,a=y(e,v);n(a)||(I.addSeconds(e,-1,v),a=y(v,v),r=!0);var u=a.dayNumber,c=a.secondsOfDay;c>=43200&&(u+=1);var f=u+68569|0,l=4*f/146097|0,p=4e3*(1+(f=f-((146097*l+3)/4|0)|0))/1461001|0,h=80*(f=f-(1461*p/4|0)+31|0)/2447|0,d=f-(2447*h/80|0)|0,E=h+2-12*(f=h/11|0)|0,m=100*(l-49)+p+f|0,O=c/s.SECONDS_PER_HOUR|0,_=c-O*s.SECONDS_PER_HOUR,T=_/s.SECONDS_PER_MINUTE|0,R=0|(_-=T*s.SECONDS_PER_MINUTE),A=(_-R)/s.SECONDS_PER_MILLISECOND;return(O+=12)>23&&(O-=24),r&&(R+=1),n(t)?(t.year=m,t.month=E,t.day=d,t.hour=O,t.minute=T,t.second=R,t.millisecond=A,t.isLeapSecond=r,t):new o(m,E,d,O,T,R,A,r)},I.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=I.toGregorianDate(e,f),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},I.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var o,a=I.toGregorianDate(t,f),u=a.year,s=a.month,c=a.day,l=a.hour,p=a.minute,h=a.second,d=a.millisecond;return 1e4===u&&1===s&&1===c&&0===l&&0===p&&0===h&&0===d&&(u=9999,s=12,c=31,l=24),n(r)||0===d?n(r)&&0!==r?(o=(.01*d).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,l,p,h,o)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",u,s,c,l,p,h):(o=(.01*d).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,l,p,h,o))},I.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new I(e.dayNumber,e.secondsOfDay,c.TAI)},I.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},I.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},I.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(I.secondsDifference(e,t))<=r},I.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},I.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},I.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY},I.computeTaiMinusUtc=function(e){h.julianDate=e;var r=I.leapSeconds,n=t(r,h,p);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},I.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return E(e.dayNumber,e.secondsOfDay+t,r)},I.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var o=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return E(e.dayNumber,o,r)},I.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var o=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return E(e.dayNumber,o,r)},I.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");return E(e.dayNumber+t,e.secondsOfDay,r)},I.lessThan=function(e,t){return I.compare(e,t)<0},I.lessThanOrEquals=function(e,t){return I.compare(e,t)<=0},I.greaterThan=function(e,t){return I.compare(e,t)>0},I.greaterThanOrEquals=function(e,t){return I.compare(e,t)>=0},I.prototype.clone=function(e){return I.clone(this,e)},I.prototype.equals=function(e){return I.equals(this,e)},I.prototype.equalsEpsilon=function(e,t){return I.equalsEpsilon(this,e,t)},I.prototype.toString=function(){return I.toIso8601(this)},I.leapSeconds=[new u(new I(2441317,43210,c.TAI),10),new u(new I(2441499,43211,c.TAI),11),new u(new I(2441683,43212,c.TAI),12),new u(new I(2442048,43213,c.TAI),13),new u(new I(2442413,43214,c.TAI),14),new u(new I(2442778,43215,c.TAI),15),new u(new I(2443144,43216,c.TAI),16),new u(new I(2443509,43217,c.TAI),17),new u(new I(2443874,43218,c.TAI),18),new u(new I(2444239,43219,c.TAI),19),new u(new I(2444786,43220,c.TAI),20),new u(new I(2445151,43221,c.TAI),21),new u(new I(2445516,43222,c.TAI),22),new u(new I(2446247,43223,c.TAI),23),new u(new I(2447161,43224,c.TAI),24),new u(new I(2447892,43225,c.TAI),25),new u(new I(2448257,43226,c.TAI),26),new u(new I(2448804,43227,c.TAI),27),new u(new I(2449169,43228,c.TAI),28),new u(new I(2449534,43229,c.TAI),29),new u(new I(2450083,43230,c.TAI),30),new u(new I(2450630,43231,c.TAI),31),new u(new I(2451179,43232,c.TAI),32),new u(new I(2453736,43233,c.TAI),33),new u(new I(2454832,43234,c.TAI),34),new u(new I(2456109,43235,c.TAI),35),new u(new I(2457204,43236,c.TAI),36),new u(new I(2457754,43237,c.TAI),37)],I})),
/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
define("ThirdParty/Uri",[],(function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var n=t.exec(r);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var t=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(i,a).replace(r,o)),this.path&&(this.path=this.path.replace(r,o)),this.query&&(this.query=this.query.replace(r,o)),this.fragment&&(this.fragment=this.fragment.replace(r,o))};var r=/%[0-9a-z]{2}/gi,n=/[a-zA-Z0-9\-\._~]/,i=/(.*@)?([^@:]*)(:.*)?/;function o(e){var t=unescape(e);return n.test(t)?t:e.toUpperCase()}function a(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e})),define("Core/appendForwardSlash",[],(function(){"use strict";return function(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}})),define("Core/clone",["./defaultValue"],(function(e){"use strict";return function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var o in r)if(r.hasOwnProperty(o)){var a=r[o];n&&(a=t(a,n)),i[o]=a}return i}})),define("Core/combine",["./defaultValue","./defined"],(function(e,t){"use strict";return function r(n,i,o){o=e(o,!1);var a,u,s,c={},f=t(n),l=t(i);if(f)for(a in n)n.hasOwnProperty(a)&&(u=n[a],l&&o&&"object"==typeof u&&i.hasOwnProperty(a)?(s=i[a],c[a]="object"==typeof s?r(u,s,o):u):c[a]=u);if(l)for(a in i)i.hasOwnProperty(a)&&!c.hasOwnProperty(a)&&(s=i[a],c[a]=s);return c}})),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={};function i(i,o){if(!t(i))throw new r("identifier is required.");t(n[i])||(n[i]=!0,console.warn(e(o,i)))}return i.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",i.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",i.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",i.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",i})),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],(function(e,t,r){"use strict";return function(n,i){if(!e(n)||!e(i))throw new t("identifier and message are required.");r(n,i)}})),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,o,a){if(!r(i))throw new n("relative uri is required.");if(!r(o)){if(void 0===a)return i;o=t(a.baseURI,a.location.href)}var u=new e(o);return new e(i).resolve(u).toString()},i})),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n,i){if(!t(n))throw new r("uri is required.");var o="",a=n.lastIndexOf("/");return-1!==a&&(o=n.substring(0,a+1)),i?(n=new e(n),t(n.query)&&(o+="?"+n.query),t(n.fragment)&&(o+="#"+n.fragment),o):o}})),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var o=i.path,a=o.lastIndexOf("/");return-1!==a&&(o=o.substr(a+1)),a=o.lastIndexOf("."),o=-1===a?"":o.substr(a+1)}})),define("Core/isBlobUri",["./Check"],(function(e){"use strict";var t=/^blob:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/isCrossOriginUrl",["./defined"],(function(e){"use strict";var t;return function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var n=t.host,i=t.protocol;return t.href=r,t.href=t.href,i!==t.protocol||n!==t.host}})),define("Core/isDataUri",["./Check"],(function(e){"use strict";var t=/^data:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/loadAndExecuteScript",["../ThirdParty/when"],(function(e){"use strict";return function(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}})),define("Core/isArray",["./defined"],(function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t})),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("obj is required.");var i="";for(var o in n)if(n.hasOwnProperty(o)){var a=n[o],u=encodeURIComponent(o)+"=";if(r(a))for(var s=0,c=a.length;s<c;++s)i+=u+encodeURIComponent(a[s])+"&";else i+=u+encodeURIComponent(a)+"&"}return i=i.slice(0,-1)}})),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var o=n.replace(/\+/g,"%20").split(/[&;]/),a=0,u=o.length;a<u;++a){var s=o[a].split("="),c=decodeURIComponent(s[0]),f=s[1];f=e(f)?decodeURIComponent(f):"";var l=i[c];"string"==typeof l?i[c]=[l,f]:r(l)?l.push(f):i[c]=f}return i}})),define("Core/RequestState",["../Core/freezeObject"],(function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})})),define("Core/RequestType",["../Core/freezeObject"],(function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})})),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],(function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),o=i||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=o,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i})),define("Core/parseResponseHeaders",[],(function(){"use strict";return function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],o=i.indexOf(": ");if(o>0){var a=i.substring(0,o),u=i.substring(o+2);t[a]=u}}return t}})),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],(function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r})),define("Core/Event",["./Check","./defined","./defineProperties"],(function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,o=-1,a=0;a<n.length;a++)if(n[a]===t&&i[a]===r){o=a;break}return-1!==o&&(this._insideRaiseEvent?(this._toRemove.push(o),n[o]=void 0,i[o]=void 0):(n.splice(o,1),i.splice(o,1)),!0)},n.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var r=this._listeners,n=this._scopes,o=r.length;for(e=0;e<o;e++){var a=r[e];t(a)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if((o=u.length)>0){for(u.sort(i),e=0;e<o;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n})),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],(function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function o(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,a=-1,u=!0;u;){var s=2*(e+1),c=s-1;a=c<r&&n(i[c],i[e])<0?c:e,s<r&&n(i[s],i[a])<0&&(a=s),a!==e?(o(i,a,e),e=a):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n,i=this._array,a=this._comparator,u=this._maximumLength,s=this._length++;for(s<i.length?i[s]=t:i.push(t);0!==s;){var c=Math.floor((s-1)/2);if(!(a(i[s],i[c])<0))break;o(i,s,c),s=c}return r(u)&&this._length>u&&(n=i[u],this._length=u),n},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return o(n,r,--this._length),this.heapify(r),i}},i})),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],(function(e,t,r,n,i,o,a,u,s,c,f){"use strict";var l={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},p=20,h=new u({comparator:function(e,t){return e.priority-t.priority}});h.maximumLength=p,h.reserve(p);var d=[],y={},E="undefined"!=typeof document?new e(document.location.href):new e,m=new a;function O(){}function _(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function T(e){var t=n(O.requestsByServer[e],O.maximumRequestsPerServer);return y[e]<t}function R(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function A(e){var t=R(e);return e.state=f.ACTIVE,d.push(e),++l.numberOfActiveRequests,++l.numberOfActiveRequestsEver,++y[e.serverKey],e.requestFunction().then(function(e){return function(t){e.state!==f.CANCELLED&&(--l.numberOfActiveRequests,--y[e.serverKey],m.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}(e)).otherwise(function(e){return function(t){e.state!==f.CANCELLED&&(++l.numberOfFailedRequests,--l.numberOfActiveRequests,--y[e.serverKey],m.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}(e)),t}function w(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++l.numberOfCancelledRequests,e.deferred.reject(),t&&(--l.numberOfActiveRequests,--y[e.serverKey],++l.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}return O.maximumRequests=50,O.maximumRequestsPerServer=6,O.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},O.throttleRequests=!0,O.debugShowStatistics=!1,O.requestCompletedEvent=m,o(O,{statistics:{get:function(){return l}},priorityHeapLength:{get:function(){return p},set:function(e){if(e<p)for(;h.length>e;)w(h.pop());p=e,h.maximumLength=e,h.reserve(e)}}}),O.update=function(){var e,t,r=0,n=d.length;for(e=0;e<n;++e)(t=d[e]).cancelled&&w(t),t.state===f.ACTIVE?r>0&&(d[e-r]=t):++r;d.length-=r;var i=h.internalArray,o=h.length;for(e=0;e<o;++e)_(i[e]);h.resort();for(var a=Math.max(O.maximumRequests-d.length,0),u=0;u<a&&h.length>0;)(t=h.pop()).cancelled?w(t):!t.throttleByServer||T(t.serverKey)?(A(t),++u):w(t);O.debugShowStatistics&&(l.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+l.numberOfAttemptedRequests),l.numberOfActiveRequests>0&&console.log("Number of active requests: "+l.numberOfActiveRequests),l.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+l.numberOfCancelledRequests),l.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+l.numberOfCancelledActiveRequests),l.numberOfFailedRequests>0&&console.log("Number of failed requests: "+l.numberOfFailedRequests),l.numberOfAttemptedRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0)},O.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(E);n.normalize();var o=n.authority;/:/.test(o)||(o=o+":"+("https"===n.scheme?"443":"80"));var a=y[o];return i(a)||(y[o]=0),o},O.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return m.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++l.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=O.getServerKey(e.url)),!O.throttleRequests||!e.throttle)return A(e);if(!(d.length>=O.maximumRequests)&&(!e.throttleByServer||T(e.serverKey))){_(e);var t=h.insert(e);if(i(t)){if(t===e)return;w(t)}return R(e)}},O.clearForSpecs=function(){for(;h.length>0;)w(h.pop());for(var e=d.length,t=0;t<e;++t)w(d[t]);d.length=0,y={},l.numberOfAttemptedRequests=0,l.numberOfActiveRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0,l.numberOfFailedRequests=0,l.numberOfActiveRequestsEver=0},O.numberOfActiveRequestsByServer=function(e){return y[e]},O.requestHeap=h,O})),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={},i={};return n.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])||(i[o]=!0)},n.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var o=e.toLowerCase()+":"+n;t(i[o])&&delete i[o]},n.contains=function(n){if(!t(n))throw new r("url is required.");var o=function(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var o=i.split("@");i=o[1]}if(-1===i.indexOf(":")){var a=n.getScheme();if(t(a)||(a=(a=window.location.protocol).substring(0,a.length-1)),"http"===a)i+=":80";else{if("https"!==a)return;i+=":443"}}return i}}(n);return!(!t(o)||!t(i[o]))},n.clear=function(){i={}},n})),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],(function(e,t,r,n,i,o,a,u,s,c,f,l,p,h,d,y,E,m,O,_,T,R,A,w,b,S,g){"use strict";var N=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();function I(e,t,r,n){var i,o=e.query;if(!u(o)||0===o.length)return{};if(-1===o.indexOf("=")){var a={};a[o]=void 0,i=a}else i=T(o);t._queryParameters=r?x(i,t._queryParameters,n):i,e.query=void 0}function v(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function M(e){if(e.state===b.ISSUED||e.state===b.ACTIVE)throw new S("The Resource is already being fetched.");e.state=b.UNISSUED,e.deferred=void 0}function x(e,t,r){if(!r)return o(e,t);var n=i(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var s=n[a],c=t[a];u(s)?(Array.isArray(s)||(s=n[a]=[s]),n[a]=s.concat(c)):n[a]=Array.isArray(c)?c.slice():c}return n}function C(t){"string"==typeof(t=a(t,a.EMPTY_OBJECT))&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=v(t.templateValues,{}),this._queryParameters=v(t.queryParameters,{}),this.headers=v(t.headers,{}),this.request=a(t.request,new R),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=a(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);I(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function P(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var i=t.defer();return C._Implementations.createImage(r,n,i),i.promise};var n=w.request(r);if(u(n))return n.otherwise((function(n){return r.state!==b.FAILED?t.reject(n):e.retryOnError(n).then((function(i){return i?(r.state=b.UNISSUED,r.deferred=void 0,P(e)):t.reject(n)}))}))}C.createIfNeeded=function(e){return e instanceof C?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new C({url:e})},s(C,{isBlobSupported:{get:function(){return N}}}),s(C.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);I(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return d(this._url)}},isDataUri:{get:function(){return m(this._url)}},isBlobUri:{get:function(){return y(this._url)}},isCrossOriginUrl:{get:function(){return E(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),C.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&function(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=_(r):e.query=n[0]}(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),o=this._templateValues,a=Object.keys(o);if(a.length>0)for(var s=0;s<a.length;s++){var c=a[s],f=o[c];i=i.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(f))}return r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},C.prototype.setQueryParameters=function(e,t){this._queryParameters=t?x(this._queryParameters,e,!1):x(e,this._queryParameters,!1)},C.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},C.prototype.appendQueryParameters=function(e){this._queryParameters=x(e,this._queryParameters,!0)},C.prototype.setTemplateValues=function(e,t){this._templateValues=t?o(this._templateValues,e):o(e,this._templateValues)},C.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},C.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url);I(n,r,!0,a(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(p(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=o(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=o(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=o(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},C.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then((function(e){return++n._retryCount,e}))},C.prototype.clone=function(e){return u(e)||(e=new C({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},C.prototype.getBaseUri=function(e){return h(this.getUrlComponent(e),e)},C.prototype.appendForwardSlash=function(){this._url=r(this._url)},C.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},C.fetchArrayBuffer=function(e){return new C(e).fetchArrayBuffer()},C.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},C.fetchBlob=function(e){return new C(e).fetchBlob()},C.prototype.fetchImage=function(e){if(e=a(e,!1),M(this.request),!N||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return P(this);var r,n,i=this.fetchBlob();return u(i)?i.then((function(e){if(u(e)){n=e;var t=window.URL.createObjectURL(e);return P(r=new C({url:t}))}})).then((function(e){if(u(e))return window.URL.revokeObjectURL(r.url),e.blob=n,e})).otherwise((function(e){return u(r)&&window.URL.revokeObjectURL(r.url),t.reject(e)})):void 0},C.fetchImage=function(e){return new C(e).fetchImage(e.preferBlob)},C.prototype.fetchText=function(){return this.fetch({responseType:"text"})},C.fetchText=function(e){return new C(e).fetchText()},C.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then((function(e){if(u(e))return JSON.parse(e)}))},C.fetchJson=function(e){return new C(e).fetchJson()},C.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},C.fetchXML=function(e){return new C(e).fetchXML()},C.prototype.fetchJsonp=function(e){var r;e=a(e,"callback"),M(this.request);do{r="loadJsonp"+Math.random().toString().substring(2,8)}while(u(window[r]));return function e(r,n,i){var o={};o[n]=i,r.setQueryParameters(o);var a=r.request;a.url=r.url,a.requestFunction=function(){var e=t.defer();return window[i]=function(t){e.resolve(t);try{delete window[i]}catch(e){window[i]=void 0}},C._Implementations.loadAndExecuteScript(r.url,i,e),e.promise};var s=w.request(a);if(u(s))return s.otherwise((function(o){return a.state!==b.FAILED?t.reject(o):r.retryOnError(o).then((function(u){return u?(a.state=b.UNISSUED,a.deferred=void 0,e(r,n,i)):t.reject(o)}))}))}(this,e,r)},C.fetchJsonp=function(e){return new C(e).fetchJsonp(e.callbackParameterName)},C.prototype._makeRequest=function(e){var r=this;M(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var i=e.responseType,a=o(e.headers,r.headers),s=e.overrideMimeType,c=e.method,f=e.data,l=t.defer(),p=C._Implementations.loadWithXhr(r.url,i,c,f,a,l,s);return u(p)&&u(p.abort)&&(n.cancelFunction=function(){p.abort()}),l.promise};var i=w.request(n);if(u(i))return i.then((function(e){return e})).otherwise((function(i){return n.state!==b.FAILED?t.reject(i):r.retryOnError(i).then((function(o){return o?(n.state=b.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)}))}))};var U=/^data:(.*?)(;base64)?,(.*)$/;function D(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function F(e,t){for(var r=D(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),o=0;o<r.length;o++)i[o]=r.charCodeAt(o);return n}function L(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}C.prototype.fetch=function(e){return(e=v(e,{})).method="GET",this._makeRequest(e)},C.fetch=function(e){return new C(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.delete=function(e){return(e=v(e,{})).method="DELETE",this._makeRequest(e)},C.delete=function(e){return new C(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},C.prototype.head=function(e){return(e=v(e,{})).method="HEAD",this._makeRequest(e)},C.head=function(e){return new C(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.options=function(e){return(e=v(e,{})).method="OPTIONS",this._makeRequest(e)},C.options=function(e){return new C(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.post=function(e,t){return n.defined("data",e),(t=v(t,{})).method="POST",t.data=e,this._makeRequest(t)},C.post=function(e){return new C(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.put=function(e,t){return n.defined("data",e),(t=v(t,{})).method="PUT",t.data=e,this._makeRequest(t)},C.put=function(e){return new C(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.patch=function(e,t){return n.defined("data",e),(t=v(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},C.patch=function(e){return new C(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C._Implementations={},C._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(g.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e};var j="undefined"==typeof XMLHttpRequest;return C._Implementations.loadWithXhr=function(e,t,r,n,i,o,s){var c=U.exec(e);if(null===c){if(!j){var l=new XMLHttpRequest;if(g.contains(e)&&(l.withCredentials=!0),l.open(r,e,!0),u(s)&&u(l.overrideMimeType)&&l.overrideMimeType(s),u(i))for(var p in i)i.hasOwnProperty(p)&&l.setRequestHeader(p,i[p]);u(t)&&(l.responseType=t);var h=!1;return"string"==typeof e&&(h=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||l.status>=300)||h&&0===l.status){var e=l.response,n=l.responseType;if("HEAD"===r||"OPTIONS"===r){var i=l.getAllResponseHeaders().trim().split(/[\r\n]+/),a={};return i.forEach((function(e){var t=e.split(": "),r=t.shift();a[r]=t.join(": ")})),void o.resolve(a)}if(204===l.status)o.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{o.resolve(JSON.parse(e))}catch(e){o.reject(e)}else(""===n||"document"===n)&&u(l.responseXML)&&l.responseXML.hasChildNodes()?o.resolve(l.responseXML):""!==n&&"text"!==n||!u(l.responseText)?o.reject(new S("Invalid XMLHttpRequest response type.")):o.resolve(l.responseText);else o.resolve(e)}else o.reject(new A(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){o.reject(new A)},l.send(n),l}!function(e,t,r,n,i,o,a){var u=require("url").parse(e),s="https:"===u.protocol?require("https"):require("http"),c=require("zlib"),f={protocol:u.protocol,hostname:u.hostname,port:u.port,path:u.path,query:u.query,method:r,headers:i};s.request(f).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)o.reject(new A(e.statusCode,e,e.headers));else{var r=[];e.on("data",(function(e){r.push(e)})),e.on("end",(function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,(function(e,r){e?o.reject(new S("Error decompressing response.")):o.resolve(L(r,t))})):o.resolve(L(n,t))}))}})).on("error",(function(e){o.reject(new A)})).end()}(e,t,r,0,i,o)}else o.resolve(function(e,t){t=a(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return D(n,i);case"arraybuffer":return F(n,i);case"blob":var o=F(n,i);return new Blob([o],{type:r});case"document":return(new DOMParser).parseFromString(D(n,i),r);case"json":return JSON.parse(D(n,i));default:throw new f("Unhandled responseType: "+t)}}(c,t))},C._Implementations.loadAndExecuteScript=function(e,t,r){return O(e,t).otherwise(r.reject)},C._DefaultImplementations={},C._DefaultImplementations.createImage=C._Implementations.createImage,C._DefaultImplementations.loadWithXhr=C._Implementations.loadWithXhr,C._DefaultImplementations.loadAndExecuteScript=C._Implementations.loadAndExecuteScript,C.DEFAULT=l(new C({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),C})),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,o,a,u,s,c,f,l){"use strict";function p(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))d(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),o=this;this._downloadPromise=e(i.fetchJson(),(function(e){d(o,e)}),(function(){o._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."}))}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return a.compare(e.julianDate,t)}function d(e,r){if(n(r.columnNames))if(n(r.samples)){var i=r.columnNames.indexOf("modifiedJulianDateUtc"),o=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),p=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),d=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||o<0||s<0||c<0||p<0||d<0||y<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var E,m=e._samples=r.samples,O=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=p,e._yCelestialPoleOffsetRadiansColumn=d,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _=e._addNewLeapSeconds,T=0,R=m.length;T<R;T+=e._columnCount){var A=m[T+i],w=m[T+y],b=A+f.MODIFIED_JULIAN_DATE_DIFFERENCE,S=new a(b,w,l.TAI);if(O.push(S),_){if(w!==E&&n(E)){var g=a.leapSeconds,N=t(g,S,h);if(N<0){var I=new u(S,w);g.splice(~N,0,I)}}E=w}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function y(e,t,r,n,i){var o=r*n;i.xPoleWander=t[o+e._xPoleWanderRadiansColumn],i.yPoleWander=t[o+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function E(e,t,r){return t+e*(r-t)}function m(e,t,r,n,i,o,u){var s=e._columnCount;if(o>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],f=t[o];if(c.equals(f)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(f))return y(e,r,o,s,u),u;var l=a.secondsDifference(n,c)/a.secondsDifference(f,c),p=i*s,h=o*s,d=r[p+e._ut1MinusUtcSecondsColumn],m=r[h+e._ut1MinusUtcSecondsColumn],O=m-d;if(O>.5||O<-.5){var _=r[p+e._taiMinusUtcSecondsColumn],T=r[h+e._taiMinusUtcSecondsColumn];_!==T&&(f.equals(n)?d=m:m-=T-_)}return u.xPoleWander=E(l,r[p+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=E(l,r[p+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=E(l,r[p+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=E(l,r[p+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=E(l,d,m),u}return p.NONE=o({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var o=this._dates,u=this._lastIndex,s=0,f=0;if(n(u)){var l=o[u],p=o[u+1],h=a.lessThanOrEquals(l,e),d=!n(p),y=d||a.greaterThanOrEquals(p,e);if(h&&y)return s=u,!d&&p.equals(e)&&++s,f=s+1,m(this,o,this._samples,e,s,f,r),r}var E=t(o,e,a.compare,this._dateColumn);return E>=0?(E<o.length-1&&o[E+1].equals(e)&&++E,s=E,f=E):(s=(f=~E)-1)<0&&(s=0),this._lastIndex=s,m(this,o,this._samples,e,s,f,r),r}if(n(this._dataError))throw new c(this._dataError)},p})),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var o=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,a),n.pitch=-Math.asin(o),n},i.fromDegrees=function(e,o,a,u){if(!t(e))throw new r("heading is required");if(!t(o))throw new r("pitch is required");if(!t(a))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=o*n.RADIANS_PER_DEGREE,u.roll=a*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,o)&&n.equalsEpsilon(e.pitch,r.pitch,i,o)&&n.equalsEpsilon(e.roll,r.roll,i,o)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i})),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],(function(e,t,r,n,i){"use strict";var o,a,u,s=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;function c(t){return"undefined"==typeof document?t:(e(o)||(o=document.createElement("a")),o.href=t,o.href=o.href,o.href)}function f(){if(e(a))return a;var o;if(o="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",h("Core/buildModuleUrl.js")):function(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),i=s.exec(n);if(null!==i)return i[1]}}(),!e(o))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return(a=new n({url:c(o)})).appendForwardSlash(),a}function l(e){return c(i.toUrl("../"+e))}function p(e){return f().getDerivedResource({url:e}).url}function h(t){return e(u)||(u=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?l:p),u(t)}return h._cesiumScriptRegex=s,h._buildModuleUrlFromBaseUrl=p,h._clearBaseResource=function(){a=void 0},h.setBaseUrl=function(e){a=n.DEFAULT.getDerivedResource({url:e})},h.getCesiumBaseUrl=f,h})),define("Core/Iau2006XysSample",[],(function(){"use strict";return function(e,t,r){this.x=e,this.y=t,this.s=r}})),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],(function(e,t,r,n,i,o,a,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=a.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new o(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var f=0;f<=t;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}var c=new o(0,0,u.TAI);function f(e,t,r){var n=c;return n.dayNumber=t,n.secondsOfDay=r,o.daysDifference(n,e._sampleZeroDateTT)}function l(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var o,u=e.defer();r._chunkDownloadsInProgress[i]=u;var s=r._xysFileUrlTemplate;return o=n(s)?s.getDerivedResource({templateValues:{0:i}}):new a({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(o.fetchJson(),(function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,o=i*r._samplesPerXysFile*3,a=0,s=n.length;a<s;++a)t[o+a]=n[a];u.resolve()})),u.promise}return s.prototype.preload=function(t,r,n,i){var o=f(this,t,r),a=f(this,n,i),u=o/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var c=u/this._samplesPerXysFile|0,p=s/this._samplesPerXysFile|0,h=[],d=c;d<=p;++d)h.push(l(this,d));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var o=f(this,e,t);if(!(o<0)){var a=o/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var u=this._interpolationOrder,s=a-(u/2|0);s<0&&(s=0);var c=s+u;c>=this._totalSamples&&(s=(c=this._totalSamples-1)-u)<0&&(s=0);var p=!1,h=this._samples;if(n(h[3*s])||(l(this,s/this._samplesPerXysFile|0),p=!0),n(h[3*c])||(l(this,c/this._samplesPerXysFile|0),p=!0),!p){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var d,y,E=o-s*this._stepSizeDays,m=this._work,O=this._denominators,_=this._coef,T=this._xTable;for(d=0;d<=u;++d)m[d]=E-T[d];for(d=0;d<=u;++d){for(_[d]=1,y=0;y<=u;++y)y!==d&&(_[d]*=m[y]);_[d]*=O[d];var R=3*(s+d);r.x+=_[d]*h[R++],r.y+=_[d]*h[R++],r.s+=_[d]*h[R]}return r}}}},s})),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],(function(e,t,r,n,i,o,a,u,s,c,f,l,p,h,d,y,E,m,O,_,T){"use strict";var R={},A={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},w={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},b={},S={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},g=new r,N=new r,I=new r;R.localFrameToFixedFrameGenerator=function(e,t){if(!A.hasOwnProperty(e)||!A[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=A[e][t],o=e+t;return u(b[o])?n=b[o]:(n=function(n,o,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),E.equalsEpsilon(n.x,0,E.EPSILON14)&&E.equalsEpsilon(n.y,0,E.EPSILON14)){var f=E.sign(n.z);r.unpack(w[e],0,g),"east"!==e&&"west"!==e&&r.multiplyByScalar(g,f,g),r.unpack(w[t],0,N),"east"!==t&&"west"!==t&&r.multiplyByScalar(N,f,N),r.unpack(w[i],0,I),"east"!==i&&"west"!==i&&r.multiplyByScalar(I,f,I)}else{(o=a(o,l.WGS84)).geodeticSurfaceNormal(n,S.up);var p=S.up,h=S.east;h.x=-n.y,h.y=n.x,h.z=0,r.normalize(h,S.east),r.cross(p,h,S.north),r.multiplyByScalar(S.up,-1,S.down),r.multiplyByScalar(S.east,-1,S.west),r.multiplyByScalar(S.north,-1,S.south),g=S[e],N=S[t],I=S[i]}return c[0]=g.x,c[1]=g.y,c[2]=g.z,c[3]=0,c[4]=N.x,c[5]=N.y,c[6]=N.z,c[7]=0,c[8]=I.x,c[9]=I.y,c[10]=I.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},b[o]=n),n},R.eastNorthUpToFixedFrame=R.localFrameToFixedFrameGenerator("east","north"),R.northEastDownToFixedFrame=R.localFrameToFixedFrameGenerator("north","east"),R.northUpEastToFixedFrame=R.localFrameToFixedFrameGenerator("north","up"),R.northWestUpToFixedFrame=R.localFrameToFixedFrameGenerator("north","west");var v=new _,M=new r(1,1,1),x=new O;R.headingPitchRollToFixedFrame=function(e,t,n,i,u){o.typeOf.object("HeadingPitchRoll",t),i=a(i,R.eastNorthUpToFixedFrame);var s=_.fromHeadingPitchRoll(t,v),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,M,x);return u=i(e,n,u),O.multiply(u,c,u)};var C=new O,P=new m;R.headingPitchRollQuaternion=function(e,t,r,n,i){o.typeOf.object("HeadingPitchRoll",t);var a=R.headingPitchRollToFixedFrame(e,t,r,n,C),u=O.getRotation(a,P);return _.fromRotationMatrix(u,i)};var U=new r(1,1,1),D=new r,F=new O,L=new O,j=new m,q=new _;R.fixedFrameToHeadingPitchRoll=function(e,t,n,i){o.defined("transform",e),t=a(t,l.WGS84),n=a(n,R.eastNorthUpToFixedFrame),u(i)||(i=new p);var s=O.getTranslation(e,D);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=O.inverseTransformation(n(s,t,F),F),f=O.setScale(e,U,L);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var h=_.fromRotationMatrix(O.getRotation(c,j),q);return h=_.normalize(h,h),p.fromQuaternion(h,i)};var B=E.TWO_PI/86400,z=new y;R.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");var r,n=(z=y.addSeconds(e,-y.computeTaiMinusUtc(e),z)).dayNumber,i=z.secondsOfDay,o=n-2451545,a=(24110.54841+(r=i>=43200?(o+.5)/T.DAYS_PER_JULIAN_CENTURY:(o-.5)/T.DAYS_PER_JULIAN_CENTURY)*(8640184.812866+r*(.093104+-62e-7*r)))*B%E.TWO_PI+(72921158553e-15+11772758384668e-32*(n-2451545.5))*((i+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY),c=Math.cos(a),f=Math.sin(a);return u(t)?(t[0]=c,t[1]=-f,t[2]=0,t[3]=f,t[4]=c,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new m(c,f,0,-f,c,0,0,0,1)},R.iau2006XysData=new h,R.earthOrientationParameters=c.NONE,R.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,i=t.stop.dayNumber,o=t.stop.secondsOfDay+32.184,a=R.iau2006XysData.preload(r,n,i,o),u=R.earthOrientationParameters.getPromiseToLoad();return e.all([a,u])},R.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new m);var r=R.computeFixedToIcrfMatrix(e,t);if(u(r))return m.transpose(r,t)};var G=new d(0,0,0),V=new f(0,0,0,0,0,0),X=new m,W=new m;R.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new m);var r=R.earthOrientationParameters.compute(e,V);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+32.184,o=R.iau2006XysData.computeXysRadians(n,i,G);if(u(o)){var a=o.x+r.xPoleOffset,c=o.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-a*a-c*c)),l=X;l[0]=1-f*a*a,l[3]=-f*a*c,l[6]=a,l[1]=-f*a*c,l[4]=1-f*c*c,l[7]=c,l[2]=-a,l[5]=-c,l[8]=1-f*(a*a+c*c);var p=m.fromRotationZ(-o.s,W),h=m.multiply(l,p,X),d=e.dayNumber-2451545,O=(e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc)/T.SECONDS_PER_DAY,_=.779057273264+O+.00273781191135448*(d+O);_=_%1*E.TWO_PI;var A=m.fromRotationZ(_,W),w=m.multiply(h,A,X),b=Math.cos(r.xPoleWander),S=Math.cos(r.yPoleWander),g=Math.sin(r.xPoleWander),N=Math.sin(r.yPoleWander),I=n-2451545+i/T.SECONDS_PER_DAY,v=-47e-6*(I/=36525)*E.RADIANS_PER_DEGREE/3600,M=Math.cos(v),x=Math.sin(v),C=W;return C[0]=b*M,C[1]=b*x,C[2]=g,C[3]=-S*x+N*g*M,C[4]=S*M+N*g*x,C[5]=-N*b,C[6]=-N*x-S*g*M,C[7]=N*M-S*g*x,C[8]=S*b,m.multiply(w,C,t)}}};var H=new n;R.pointToWindowCoordinates=function(e,t,r,n){return(n=R.pointToGLWindowCoordinates(e,t,r,n)).y=2*t[5]-n.y,n},R.pointToGLWindowCoordinates=function(e,r,i,o){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(o)||(o=new t);var a=H;return O.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,a),a),n.multiplyByScalar(a,1/a.w,a),O.multiplyByVector(r,a,a),t.fromCartesian4(a,o)};var k=new r,Y=new r,K=new r;R.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var o=a(n,l.WGS84).geodeticSurfaceNormal(e,k),c=r.cross(t,o,Y);r.equalsEpsilon(c,r.ZERO,E.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,K);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new m),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=f.x,i[7]=f.y,i[8]=f.z,i};var Z=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),J=new i,Q=new r,$=new r,ee=new m,te=new O,re=new O;return R.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=O.getTranslation(t,$),o=e.ellipsoid,a=o.cartesianToCartographic(i,J),c=e.project(a,Q);r.fromElements(c.z,c.x,c.y,c);var f=R.eastNorthUpToFixedFrame(i,o,te),l=O.inverseTransformation(f,re),p=O.getRotation(t,ee),h=O.multiplyByMatrix3(l,p,n);return O.multiply(Z,h,n),O.setTranslation(n,c,n),n},R.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,o=R.eastNorthUpToFixedFrame(t,i,te),a=O.inverseTransformation(o,re),c=i.cartesianToCartographic(t,J),f=e.project(c,Q);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,te);return O.multiply(Z,a,n),O.multiply(l,n,n),n},R})),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],(function(e,t,r,n,i,o,a,u,s,c,f,l,p,h,d,y){"use strict";function E(e){e=i(e,i.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=i(e.primitiveType,p.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=i(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}E.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&o(e.attributes[r])&&o(e.attributes[r].values)){var i=e.attributes[r],u=i.values.length/i.componentsPerAttribute;if(t!==u&&-1!==t)throw new a("All attribute lists must have the same number of attributes.");t=u}return t};var m=new r,O=new t,_=new l,T=[new r,new r,new r],R=[new e,new e,new e],A=[new e,new e,new e],w=new t,b=new h,S=new l,g=new c;return E._textureCoordinateRotationPoints=function(n,i,o,a){var u,s=d.center(a,m),p=r.toCartesian(s,o,O),E=y.eastNorthUpToFixedFrame(p,o,_),N=l.inverse(E,_),I=R,v=T;v[0].longitude=a.west,v[0].latitude=a.south,v[1].longitude=a.west,v[1].latitude=a.north,v[2].longitude=a.east,v[2].latitude=a.south;var M=w;for(u=0;u<3;u++)r.toCartesian(v[u],o,M),M=l.multiplyByPointAsVector(N,M,M),I[u].x=M.x,I[u].y=M.y;var x=h.fromAxisAngle(t.UNIT_Z,-i,b),C=f.fromQuaternion(x,S),P=n.length,U=Number.POSITIVE_INFINITY,D=Number.POSITIVE_INFINITY,F=Number.NEGATIVE_INFINITY,L=Number.NEGATIVE_INFINITY;for(u=0;u<P;u++)M=l.multiplyByPointAsVector(N,n[u],M),M=f.multiplyByVector(C,M,M),U=Math.min(U,M.x),D=Math.min(D,M.y),F=Math.max(F,M.x),L=Math.max(L,M.y);var j=c.fromRotation(i,g),q=A;q[0].x=U,q[0].y=D,q[1].x=U,q[1].y=L,q[2].x=F,q[2].y=D;var B=I[0],z=I[2].x-B.x,G=I[1].y-B.y;for(u=0;u<3;u++){var V=q[u];c.multiplyByVector(j,V,V),V.x=(V.x-B.x)/z,V.y=(V.y-B.y)/G}var X=q[0],W=q[1],H=q[2],k=new Array(6);return e.pack(X,k),e.pack(W,k,2),e.pack(H,k,4),k},E})),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}})),define("Core/GeometryAttributes",["./defaultValue"],(function(e){"use strict";return function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}})),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],(function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,o){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");return o=e(o,0),i[o++]=n.position?1:0,i[o++]=n.normal?1:0,i[o++]=n.st?1:0,i[o++]=n.tangent?1:0,i[o++]=n.bitangent?1:0,i[o]=n.color?1:0,i},i.unpack=function(n,o,a){if(!t(n))throw new r("array is required");return o=e(o,0),t(a)||(a=new i),a.position=1===n[o++],a.normal=1===n[o++],a.st=1===n[o++],a.tangent=1===n[o++],a.bitangent=1===n[o++],a.color=1===n[o],a},i.clone=function(e,r){if(t(e))return t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},i})),define("Core/BoxGeometry",["./arrayFill","./BoundingSphere","./Cartesian3","./Check","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryOffsetAttribute","./PrimitiveType","./VertexFormat"],(function(e,t,r,n,i,o,a,u,s,c,f,l,p,h){"use strict";var d=new r;function y(e){var t=(e=o(e,o.EMPTY_OBJECT)).minimum,i=e.maximum;if(n.typeOf.object("min",t),n.typeOf.object("max",i),a(e.offsetAttribute)&&e.offsetAttribute===l.TOP)throw new u("GeometryOffsetAttribute.TOP is not a supported options.offsetAttribute for this geometry.");var s=o(e.vertexFormat,h.DEFAULT);this._minimum=r.clone(t),this._maximum=r.clone(i),this._vertexFormat=s,this._offsetAttribute=e.offsetAttribute,this._workerName="createBoxGeometry"}y.fromDimensions=function(e){var t=(e=o(e,o.EMPTY_OBJECT)).dimensions;n.typeOf.object("dimensions",t),n.typeOf.number.greaterThanOrEquals("dimensions.x",t.x,0),n.typeOf.number.greaterThanOrEquals("dimensions.y",t.y,0),n.typeOf.number.greaterThanOrEquals("dimensions.z",t.z,0);var i=r.multiplyByScalar(t,.5,new r);return new y({minimum:r.negate(i,new r),maximum:i,vertexFormat:e.vertexFormat,offsetAttribute:e.offsetAttribute})},y.fromAxisAlignedBoundingBox=function(e){return n.typeOf.object("boundingBox",e),new y({minimum:e.minimum,maximum:e.maximum})},y.packedLength=2*r.packedLength+h.packedLength+1,y.pack=function(e,t,i){return n.typeOf.object("value",e),n.defined("array",t),i=o(i,0),r.pack(e._minimum,t,i),r.pack(e._maximum,t,i+r.packedLength),h.pack(e._vertexFormat,t,i+2*r.packedLength),t[i+2*r.packedLength+h.packedLength]=o(e._offsetAttribute,-1),t};var E,m=new r,O=new r,_=new h,T={minimum:m,maximum:O,vertexFormat:_,offsetAttribute:void 0};return y.unpack=function(e,t,i){n.defined("array",e),t=o(t,0);var u=r.unpack(e,t,m),s=r.unpack(e,t+r.packedLength,O),c=h.unpack(e,t+2*r.packedLength,_),f=e[t+2*r.packedLength+h.packedLength];return a(i)?(i._minimum=r.clone(u,i._minimum),i._maximum=r.clone(s,i._maximum),i._vertexFormat=h.clone(c,i._vertexFormat),i._offsetAttribute=-1===f?void 0:f,i):(T.offsetAttribute=-1===f?void 0:f,new y(T))},y.createGeometry=function(n){var o=n._minimum,u=n._maximum,h=n._vertexFormat;if(!r.equals(o,u)){var y,E,m=new f;if(h.position&&(h.st||h.normal||h.tangent||h.bitangent)){if(h.position&&((E=new Float64Array(72))[0]=o.x,E[1]=o.y,E[2]=u.z,E[3]=u.x,E[4]=o.y,E[5]=u.z,E[6]=u.x,E[7]=u.y,E[8]=u.z,E[9]=o.x,E[10]=u.y,E[11]=u.z,E[12]=o.x,E[13]=o.y,E[14]=o.z,E[15]=u.x,E[16]=o.y,E[17]=o.z,E[18]=u.x,E[19]=u.y,E[20]=o.z,E[21]=o.x,E[22]=u.y,E[23]=o.z,E[24]=u.x,E[25]=o.y,E[26]=o.z,E[27]=u.x,E[28]=u.y,E[29]=o.z,E[30]=u.x,E[31]=u.y,E[32]=u.z,E[33]=u.x,E[34]=o.y,E[35]=u.z,E[36]=o.x,E[37]=o.y,E[38]=o.z,E[39]=o.x,E[40]=u.y,E[41]=o.z,E[42]=o.x,E[43]=u.y,E[44]=u.z,E[45]=o.x,E[46]=o.y,E[47]=u.z,E[48]=o.x,E[49]=u.y,E[50]=o.z,E[51]=u.x,E[52]=u.y,E[53]=o.z,E[54]=u.x,E[55]=u.y,E[56]=u.z,E[57]=o.x,E[58]=u.y,E[59]=u.z,E[60]=o.x,E[61]=o.y,E[62]=o.z,E[63]=u.x,E[64]=o.y,E[65]=o.z,E[66]=u.x,E[67]=o.y,E[68]=u.z,E[69]=o.x,E[70]=o.y,E[71]=u.z,m.position=new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:E})),h.normal){var O=new Float32Array(72);O[0]=0,O[1]=0,O[2]=1,O[3]=0,O[4]=0,O[5]=1,O[6]=0,O[7]=0,O[8]=1,O[9]=0,O[10]=0,O[11]=1,O[12]=0,O[13]=0,O[14]=-1,O[15]=0,O[16]=0,O[17]=-1,O[18]=0,O[19]=0,O[20]=-1,O[21]=0,O[22]=0,O[23]=-1,O[24]=1,O[25]=0,O[26]=0,O[27]=1,O[28]=0,O[29]=0,O[30]=1,O[31]=0,O[32]=0,O[33]=1,O[34]=0,O[35]=0,O[36]=-1,O[37]=0,O[38]=0,O[39]=-1,O[40]=0,O[41]=0,O[42]=-1,O[43]=0,O[44]=0,O[45]=-1,O[46]=0,O[47]=0,O[48]=0,O[49]=1,O[50]=0,O[51]=0,O[52]=1,O[53]=0,O[54]=0,O[55]=1,O[56]=0,O[57]=0,O[58]=1,O[59]=0,O[60]=0,O[61]=-1,O[62]=0,O[63]=0,O[64]=-1,O[65]=0,O[66]=0,O[67]=-1,O[68]=0,O[69]=0,O[70]=-1,O[71]=0,m.normal=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:O})}if(h.st){var _=new Float32Array(48);_[0]=0,_[1]=0,_[2]=1,_[3]=0,_[4]=1,_[5]=1,_[6]=0,_[7]=1,_[8]=1,_[9]=0,_[10]=0,_[11]=0,_[12]=0,_[13]=1,_[14]=1,_[15]=1,_[16]=0,_[17]=0,_[18]=1,_[19]=0,_[20]=1,_[21]=1,_[22]=0,_[23]=1,_[24]=1,_[25]=0,_[26]=0,_[27]=0,_[28]=0,_[29]=1,_[30]=1,_[31]=1,_[32]=1,_[33]=0,_[34]=0,_[35]=0,_[36]=0,_[37]=1,_[38]=1,_[39]=1,_[40]=0,_[41]=0,_[42]=1,_[43]=0,_[44]=1,_[45]=1,_[46]=0,_[47]=1,m.st=new c({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:_})}if(h.tangent){var T=new Float32Array(72);T[0]=1,T[1]=0,T[2]=0,T[3]=1,T[4]=0,T[5]=0,T[6]=1,T[7]=0,T[8]=0,T[9]=1,T[10]=0,T[11]=0,T[12]=-1,T[13]=0,T[14]=0,T[15]=-1,T[16]=0,T[17]=0,T[18]=-1,T[19]=0,T[20]=0,T[21]=-1,T[22]=0,T[23]=0,T[24]=0,T[25]=1,T[26]=0,T[27]=0,T[28]=1,T[29]=0,T[30]=0,T[31]=1,T[32]=0,T[33]=0,T[34]=1,T[35]=0,T[36]=0,T[37]=-1,T[38]=0,T[39]=0,T[40]=-1,T[41]=0,T[42]=0,T[43]=-1,T[44]=0,T[45]=0,T[46]=-1,T[47]=0,T[48]=-1,T[49]=0,T[50]=0,T[51]=-1,T[52]=0,T[53]=0,T[54]=-1,T[55]=0,T[56]=0,T[57]=-1,T[58]=0,T[59]=0,T[60]=1,T[61]=0,T[62]=0,T[63]=1,T[64]=0,T[65]=0,T[66]=1,T[67]=0,T[68]=0,T[69]=1,T[70]=0,T[71]=0,m.tangent=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:T})}if(h.bitangent){var R=new Float32Array(72);R[0]=0,R[1]=1,R[2]=0,R[3]=0,R[4]=1,R[5]=0,R[6]=0,R[7]=1,R[8]=0,R[9]=0,R[10]=1,R[11]=0,R[12]=0,R[13]=1,R[14]=0,R[15]=0,R[16]=1,R[17]=0,R[18]=0,R[19]=1,R[20]=0,R[21]=0,R[22]=1,R[23]=0,R[24]=0,R[25]=0,R[26]=1,R[27]=0,R[28]=0,R[29]=1,R[30]=0,R[31]=0,R[32]=1,R[33]=0,R[34]=0,R[35]=1,R[36]=0,R[37]=0,R[38]=1,R[39]=0,R[40]=0,R[41]=1,R[42]=0,R[43]=0,R[44]=1,R[45]=0,R[46]=0,R[47]=1,R[48]=0,R[49]=0,R[50]=1,R[51]=0,R[52]=0,R[53]=1,R[54]=0,R[55]=0,R[56]=1,R[57]=0,R[58]=0,R[59]=1,R[60]=0,R[61]=0,R[62]=1,R[63]=0,R[64]=0,R[65]=1,R[66]=0,R[67]=0,R[68]=1,R[69]=0,R[70]=0,R[71]=1,m.bitangent=new c({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R})}(y=new Uint16Array(36))[0]=0,y[1]=1,y[2]=2,y[3]=0,y[4]=2,y[5]=3,y[6]=6,y[7]=5,y[8]=4,y[9]=7,y[10]=6,y[11]=4,y[12]=8,y[13]=9,y[14]=10,y[15]=8,y[16]=10,y[17]=11,y[18]=14,y[19]=13,y[20]=12,y[21]=15,y[22]=14,y[23]=12,y[24]=18,y[25]=17,y[26]=16,y[27]=19,y[28]=18,y[29]=16,y[30]=20,y[31]=21,y[32]=22,y[33]=20,y[34]=22,y[35]=23}else(E=new Float64Array(24))[0]=o.x,E[1]=o.y,E[2]=o.z,E[3]=u.x,E[4]=o.y,E[5]=o.z,E[6]=u.x,E[7]=u.y,E[8]=o.z,E[9]=o.x,E[10]=u.y,E[11]=o.z,E[12]=o.x,E[13]=o.y,E[14]=u.z,E[15]=u.x,E[16]=o.y,E[17]=u.z,E[18]=u.x,E[19]=u.y,E[20]=u.z,E[21]=o.x,E[22]=u.y,E[23]=u.z,m.position=new c({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:E}),(y=new Uint16Array(36))[0]=4,y[1]=5,y[2]=6,y[3]=4,y[4]=6,y[5]=7,y[6]=1,y[7]=0,y[8]=3,y[9]=1,y[10]=3,y[11]=2,y[12]=1,y[13]=6,y[14]=5,y[15]=1,y[16]=2,y[17]=6,y[18]=2,y[19]=3,y[20]=7,y[21]=2,y[22]=7,y[23]=6,y[24]=3,y[25]=0,y[26]=4,y[27]=3,y[28]=4,y[29]=7,y[30]=0,y[31]=1,y[32]=5,y[33]=0,y[34]=5,y[35]=4;var A=r.subtract(u,o,d),w=.5*r.magnitude(A);if(a(n._offsetAttribute)){var b=E.length,S=new Uint8Array(b/3),g=n._offsetAttribute===l.NONE?0:1;e(S,g),m.applyOffset=new c({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:1,values:S})}return new s({attributes:m,indices:y,primitiveType:p.TRIANGLES,boundingSphere:new t(r.ZERO,w),offsetAttribute:n._offsetAttribute})}},y.getUnitBox=function(){return a(E)||(E=y.createGeometry(y.fromDimensions({dimensions:new r(1,1,1),vertexFormat:h.POSITION_ONLY}))),E},y})),define("Workers/createBoxGeometry",["../Core/BoxGeometry","../Core/defined"],(function(e,t){"use strict";return function(r,n){return t(n)&&(r=e.unpack(r,n)),e.createGeometry(r)}}));