define("Core/defined",[],(function(){"use strict";return function(e){return null!=e}})),define("Core/DeveloperError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t})),define("Core/Check",["./defined","./DeveloperError"],(function(e,t){"use strict";var r={};function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}return r.typeOf={},r.defined=function(r,n){if(!e(n))throw new t(function(e){return e+" is required, actual value was undefined"}(r))},r.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},r.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},r.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},r.typeOf.number.lessThan=function(e,n,i){if(r.typeOf.number(e,n),n>=i)throw new t("Expected "+e+" to be less than "+i+", actual value was "+n)},r.typeOf.number.lessThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n>i)throw new t("Expected "+e+" to be less than or equal to "+i+", actual value was "+n)},r.typeOf.number.greaterThan=function(e,n,i){if(r.typeOf.number(e,n),n<=i)throw new t("Expected "+e+" to be greater than "+i+", actual value was "+n)},r.typeOf.number.greaterThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n<i)throw new t("Expected "+e+" to be greater than or equal to"+i+", actual value was "+n)},r.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},r.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},r.typeOf.number.equals=function(e,n,i,a){if(r.typeOf.number(e,i),r.typeOf.number(n,a),i!==a)throw new t(e+" must be equal to "+n+", the actual values are "+i+" and "+a)},r})),define("Core/freezeObject",["./defined"],(function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t})),define("Core/defaultValue",["./freezeObject"],(function(e){"use strict";function t(e,t){return null!=e?e:t}return t.EMPTY_OBJECT=e({}),t})),
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
define("ThirdParty/mersenne-twister",[],(function(){var e=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++)e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e})),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n,i){"use strict";var a={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536};a.sign=r(Math.sign,(function(e){return 0==(e=+e)||e!=e?e:e>0?1:-1})),a.signNotZero=function(e){return e<0?-1:1},a.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*a.clamp(e,-1,1)+.5)*t)},a.fromSNorm=function(e,t){return t=r(t,255),a.clamp(e,0,t)/t*2-1},a.sinh=r(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),a.cosh=r(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},a.equalsEpsilon=function(e,t,a,o){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(a))throw new i("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-t);return u<=o||u<=a*Math.max(Math.abs(e),Math.abs(t))};var o=[1];a.factorial=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");var t=o.length;if(e>=t)for(var r=o[t-1],n=t;n<=e;n++)o.push(r*n);return o[e]},a.incrementWrap=function(e,t,a){if(a=r(a,0),!n(e))throw new i("n is required.");if(t<=a)throw new i("maximumValue must be greater than minimumValue.");return++e>t&&(e=a),e},a.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0==(e&e-1)},a.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},a.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return e<t?t:e>r?r:e};var u=new e;return a.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},a.nextRandomNumber=function(){return u.random()},a.randomBetween=function(e,t){return a.nextRandomNumber()*(t-e)+e},a.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},a.cbrt=r(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),a.log2=r(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),a.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},a.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},a.fastApproximateAtan2=function(e,r){var n,o;t.typeOf.number("x",e),t.typeOf.number("y",r);var u=Math.abs(e);n=Math.abs(r),o=Math.max(u,n);var s=(n=Math.min(u,n))/o;if(isNaN(s))throw new i("either x or y must be nonzero");return u=a.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?a.PI_OVER_TWO-u:u,u=e<0?a.PI-u:u,u=r<0?-u:u},a})),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;a<i;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!=0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;u<a;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f);var n=o.dot(c,f),i=o.magnitude(o.cross(c,f,c));return Math.atan2(i,n)};var l=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=o.dot(t,r)/o.dot(r,r);return o.multiplyByScalar(r,i,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,f=a*c-o*s,l=o*u-i*c,p=i*s-a*u;return n.x=f,n.y=l,n.z=p,n},o.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var p=new o,d=new o,h=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),a=t(a,0);var c=r(u)?u.radiiSquared:h,f=Math.cos(i);p.x=f*Math.cos(n),p.y=f*Math.sin(n),p.z=Math.sin(i),p=o.normalize(p,p),o.multiplyComponents(c,p,d);var l=Math.sqrt(o.dot(p,d));return d=o.divideByScalar(d,l,d),p=o.multiplyByScalar(p,a,p),r(s)||(s=new o),o.add(d,p,s)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromDegrees(c,f,0,i,a[l])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromRadians(c,f,0,i,a[l])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;a[p]=o.fromDegrees(c,f,l,i,a[p])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;a[p]=o.fromRadians(c,f,l,i,a[p])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o})),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";var i=new e,a=new e;return function(o,u,s,c,f){if(!t(o))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=o.x,p=o.y,d=o.z,h=u.x,y=u.y,m=u.z,E=l*l*h*h,O=p*p*y*y,w=d*d*m*m,v=E+O+w,T=Math.sqrt(1/v),_=e.multiplyByScalar(o,T,i);if(v<c)return isFinite(T)?e.clone(_,f):void 0;var b=s.x,g=s.y,R=s.z,A=a;A.x=_.x*b*2,A.y=_.y*g*2,A.z=_.z*R*2;var S,N,I,M,x,C,P,D=(1-T)*e.magnitude(o)/(.5*e.magnitude(A)),U=0;do{U=(S=E*(x=(N=1/(1+(D-=U)*b))*N)+O*(C=(I=1/(1+D*g))*I)+w*(P=(M=1/(1+D*R))*M)-1)/(-2*(E*(x*N)*b+O*(C*I)*g+w*(P*M)*R))}while(Math.abs(S)>n.EPSILON12);return t(f)?(f.x=l*N,f.y=p*I,f.z=d*M,f):new e(l*N,p*I,d*M)}})),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,a,o){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,a,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),a=r(a,0),n(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=a.toRadians(e),r=a.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=a.EPSILON1;return u.fromCartesian=function(t,r,i){var h=n(r)?r.oneOverRadii:l,y=n(r)?r.oneOverRadiiSquared:p,m=n(r)?r._centerToleranceSquared:d,E=o(t,h,y,m,c);if(n(E)){var O=e.multiplyComponents(E,y,s);O=e.normalize(O,O);var w=e.subtract(t,E,f),v=Math.atan2(O.y,O.x),T=Math.asin(O.z),_=a.sign(e.dot(w,t))*e.magnitude(w);return n(i)?(i.longitude=v,i.latitude=T,i.height=_,i):new u(v,T,_)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u})),define("Core/defineProperties",["./defined"],(function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r})),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(t,i,a,o){i=n(i,0),a=n(a,0),o=n(o,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",a,0),r.typeOf.number.greaterThanOrEquals("z",o,0),t._radii=new e(i,a,o),t._radiiSquared=new e(i*i,a*a,o*o),t._radiiToTheFourth=new e(i*i*i*i,a*a*a*a,o*o*o*o),t._oneOverRadii=new e(0===i?0:1/i,0===a?0:1/a,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===a?0:1/(a*a),0===o?0:1/(o*o)),t._minimumRadius=Math.min(i,a,o),t._maximumRadius=Math.max(i,a,o),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,f(this,e,t,r)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)}},l.fromCartesian3=function(e,t){return i(t)||(t=new l),i(e)?(f(t,e.x,e.y,e.z),t):t},l.WGS84=u(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=u(new l(1,1,1)),l.MOON=u(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,i,a){return r.typeOf.object("value",t),r.defined("array",i),a=n(a,0),e.pack(t._radii,i,a),i},l.unpack=function(t,i,a){r.defined("array",t),i=n(i,0);var o=e.unpack(t,i);return l.fromCartesian3(o,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var a=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(a),c=u*Math.sin(a),f=Math.sin(o);return i(n)||(n=new e),n.x=s,n.y=c,n.z=f,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var p=new e,d=new e;l.prototype.cartographicToCartesian=function(t,r){var n=p,a=d;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,a);var o=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(a,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;a<n;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var h=new e,y=new e,m=new e;return l.prototype.cartesianToCartographic=function(r,n){var a=this.scaleToGeodeticSurface(r,y);if(i(a)){var o=this.geodeticSurfaceNormal(a,h),u=e.subtract(r,a,m),c=Math.atan2(o.y,o.x),f=Math.asin(o.z),l=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=f,n.height=l,n):new t(c,f,l)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;a<n;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var a=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(a*a*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},l.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new o("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),a=n(a,0);var c=this._squaredXOverSquaredZ;if(i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),!(Math.abs(u.z)>=this._radii.z-a))return u},l})),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],(function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u})),define("Core/Intersect",["./freezeObject"],(function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})})),define("Core/Interval",["./defaultValue"],(function(e){"use strict";return function(t,r){this.start=e(t,0),this.stop=e(r,0)}})),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,p=e.z*e.z,d=e.z*e.w,h=e.w*e.w,y=i-c-p+h,m=2*(a-d),E=2*(o+l),O=2*(a+d),w=-i+c-p+h,v=2*(f-u),T=2*(o-l),_=2*(f+u),b=-i-c+p+h;return n(r)?(r[0]=y,r[1]=O,r[2]=T,r[3]=m,r[4]=w,r[5]=_,r[6]=E,r[7]=v,r[8]=b,r):new s(y,m,E,O,w,v,T,_,b)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=i*a,p=-o*c+f*u*a,d=f*c+o*u*a,h=i*c,y=o*a+f*u*c,m=-f*a+o*u*c,E=-u,O=f*i,w=o*i;return n(r)?(r[0]=l,r[1]=h,r[2]=E,r[3]=p,r[4]=y,r[5]=O,r[6]=d,r[7]=m,r[8]=w,r):new s(l,p,d,h,y,m,E,O,w)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var a=3*r;return(i=s.clone(e,i))[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=s.clone(e,i))[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var c=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),n};var f=new e;s.getMaximumScale=function(t){return s.getScale(t,f),e.maximumComponent(f)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=p,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var l=[1,0,0],p=[2,2,1];function d(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(p[r],l[r])];t+=2*n*n}return Math.sqrt(t)}function h(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;a<3;++a){var o=Math.abs(e[s.getElementIndex(p[a],l[a])]);o>n&&(i=a,n=o)}var c=1,f=0,d=l[i],h=p[i];if(Math.abs(e[s.getElementIndex(h,d)])>r){var y,m=(e[s.getElementIndex(h,h)]-e[s.getElementIndex(d,d)])/2/e[s.getElementIndex(h,d)];f=(y=m<0?-1/(-m+Math.sqrt(1+m*m)):1/(m+Math.sqrt(1+m*m)))*(c=1/Math.sqrt(1+y*y))}return(t=s.clone(s.IDENTITY,t))[s.getElementIndex(d,d)]=t[s.getElementIndex(h,h)]=c,t[s.getElementIndex(h,d)]=f,t[s.getElementIndex(d,h)]=-f,t}var y=new s,m=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=0,o=0;n(r)||(r={});for(var c=r.unitary=s.clone(s.IDENTITY,r.unitary),f=r.diagonal=s.clone(e,r.diagonal),l=i*function(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}(f);o<10&&d(f)>l;)h(f,y),s.transpose(y,m),s.multiply(f,y,f),s.multiply(m,f,f),s.multiply(c,y,c),++a>2&&(++o,a=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(o*f-c*u)+a*(c*i-n*f)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],f=e[4],l=e[5],p=e[6],d=e[7],h=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=f*h-d*l,r[1]=d*o-i*h,r[2]=i*l-f*o,r[3]=p*l-c*h,r[4]=n*h-p*o,r[5]=c*o-n*l,r[6]=c*d-p*f,r[7]=p*i-n*d,r[8]=n*f-c*i;var m=1/y;return s.multiplyByScalar(r,m,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s})),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;a<i;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;a<i;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var f=new Float32Array(1);return o.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new o),f[0]=t,0===(t=f[0]))return o.clone(o.ZERO,n);var i,u=t<0?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(a.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=38);var s=256*t;return n.x=Math.floor(s),s=256*(s-n.x),n.y=Math.floor(s),s=256*(s-n.y),n.z=Math.floor(s),n.w=2*(i+38)+u,n},o.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(i=-(i=2*i-1),(n-=38)>=38)return i<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=i*t.x*(1/256);return a+=i*t.y*(1/65536),(a+=i*t.z*(1/16777216))*Math.pow(10,n)},o})),define("Core/RuntimeError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t})),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],(function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(e,t,r,i,a,o,u,s,c,f,l,p,d,h,y,m){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(f,0),this[7]=n(h,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(p,0),this[15]=n(m,0)}f.packedLength=16,f.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},f.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new f),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},f.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new f(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new f);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,p=t.x*t.z,d=t.x*t.w,h=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,O=t.z*t.w,w=t.w*t.w,v=c-h-E+w,T=2*(l-O),_=2*(p+m),b=2*(l+O),g=-c+h-E+w,R=2*(y-d),A=2*(p-m),S=2*(y+d),N=-c-h+E+w;return a[0]=v*o,a[1]=b*o,a[2]=A*o,a[3]=0,a[4]=T*u,a[5]=g*u,a[6]=S*u,a[7]=0,a[8]=_*s,a[9]=R*s,a[10]=N*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,p=new e,d=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,l),e.normalize(e.cross(l,u,p),p),e.normalize(e.cross(p,l,d),d);var s=p.x,c=p.y,h=p.z,y=l.x,m=l.y,E=l.z,O=d.x,w=d.y,v=d.z,T=a.x,_=a.y,b=a.z,g=s*-T+c*-_+h*-b,R=O*-T+w*-_+v*-b,A=y*T+m*_+E*b;return i(n)?(n[0]=s,n[1]=O,n[2]=-y,n[3]=0,n[4]=c,n[5]=w,n[6]=-m,n[7]=0,n[8]=h,n[9]=v,n[10]=-E,n[11]=0,n[12]=g,n[13]=R,n[14]=A,n[15]=1,n):new f(s,c,h,g,O,w,v,R,-y,-m,-E,A,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=1/Math.tan(.5*e),u=o/t,s=(i+n)/(n-i),c=2*i*n/(n-i);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},f.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),f=1/(o-a),l=-(t+e)*s,p=-(i+n)*c,d=-(o+a)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=p,u[14]=d,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),f=(t+e)/(t-e),l=(i+n)/(i-n),p=-(o+a)/(o-a),d=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=p,u[11]=-1,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),f=(i+n)/(i-n),l=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=f,o[10]=-1,o[11]=-1,o[12]=0,o[13]=0,o[14]=l,o[15]=0,o},f.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0);var f=.5*s,l=.5*c,p=.5*((i=n(i,1))-t),d=f,h=l,y=p,m=o+f,E=u+l,O=t+p;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=m,a[13]=E,a[14]=O,a[15]=1,a},f.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},f.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i);var a=4*t;return(i=f.clone(e,i))[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var h=new e;f.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var a=f.getScale(t,h),o=e.divideComponents(n,a,h);return f.multiplyByScale(t,o,i)},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},f.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),(i=f.clone(e,i))[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var y=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var m=new e;f.getMaximumScale=function(t){return f.getScale(t,m),e.maximumComponent(m)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],p=e[8],d=e[9],h=e[10],y=e[11],m=e[12],E=e[13],O=e[14],w=e[15],v=t[0],T=t[1],_=t[2],b=t[3],g=t[4],R=t[5],A=t[6],S=t[7],N=t[8],I=t[9],M=t[10],x=t[11],C=t[12],P=t[13],D=t[14],U=t[15],L=i*v+s*T+p*_+m*b,q=a*v+c*T+d*_+E*b,F=o*v+f*T+h*_+O*b,j=u*v+l*T+y*_+w*b,B=i*g+s*R+p*A+m*S,z=a*g+c*R+d*A+E*S,G=o*g+f*R+h*A+O*S,V=u*g+l*R+y*A+w*S,W=i*N+s*I+p*M+m*x,X=a*N+c*I+d*M+E*x,k=o*N+f*I+h*M+O*x,H=u*N+l*I+y*M+w*x,Y=i*C+s*P+p*D+m*U,Z=a*C+c*P+d*D+E*U,K=o*C+f*P+h*D+O*U,J=u*C+l*P+y*D+w*U;return n[0]=L,n[1]=q,n[2]=F,n[3]=j,n[4]=B,n[5]=z,n[6]=G,n[7]=V,n[8]=W,n[9]=X,n[10]=k,n[11]=H,n[12]=Y,n[13]=Z,n[14]=K,n[15]=J,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],d=e[12],h=e[13],y=e[14],m=t[0],E=t[1],O=t[2],w=t[4],v=t[5],T=t[6],_=t[8],b=t[9],g=t[10],R=t[12],A=t[13],S=t[14],N=i*m+u*E+f*O,I=a*m+s*E+l*O,M=o*m+c*E+p*O,x=i*w+u*v+f*T,C=a*w+s*v+l*T,P=o*w+c*v+p*T,D=i*_+u*b+f*g,U=a*_+s*b+l*g,L=o*_+c*b+p*g,q=i*R+u*A+f*S+d,F=a*R+s*A+l*S+h,j=o*R+c*A+p*S+y;return n[0]=N,n[1]=I,n[2]=M,n[3]=0,n[4]=x,n[5]=C,n[6]=P,n[7]=0,n[8]=D,n[9]=U,n[10]=L,n[11]=0,n[12]=q,n[13]=F,n[14]=j,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],d=t[0],h=t[1],y=t[2],m=t[3],E=t[4],O=t[5],w=t[6],v=t[7],T=t[8],_=i*d+u*h+f*y,b=a*d+s*h+l*y,g=o*d+c*h+p*y,R=i*m+u*E+f*O,A=a*m+s*E+l*O,S=o*m+c*E+p*O,N=i*w+u*v+f*T,I=a*w+s*v+l*T,M=o*w+c*v+p*T;return n[0]=_,n[1]=b,n[2]=g,n[3]=0,n[4]=R,n[5]=A,n[6]=S,n[7]=0,n[8]=N,n[9]=I,n[10]=M,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?f.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,f=e[2]*i+e[6]*a+e[10]*o+e[14]*u,l=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,w=new s,v=new t,T=new t(0,0,0,1);return f.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],a=e[4],o=e[8],l=e[12],p=e[1],d=e[5],h=e[9],y=e[13],m=e[2],E=e[6],_=e[10],b=e[14],g=e[3],R=e[7],A=e[11],S=e[15],N=_*S,I=b*A,M=E*S,x=b*R,C=E*A,P=_*R,D=m*S,U=b*g,L=m*A,q=_*g,F=m*R,j=E*g,B=N*d+x*h+C*y-(I*d+M*h+P*y),z=I*p+D*h+q*y-(N*p+U*h+L*y),G=M*p+U*d+F*y-(x*p+D*d+j*y),V=P*p+L*d+j*h-(C*p+q*d+F*h),W=I*a+M*o+P*l-(N*a+x*o+C*l),X=N*i+U*o+L*l-(I*i+D*o+q*l),k=x*i+D*a+j*l-(M*i+U*a+F*l),H=C*i+q*a+F*o-(P*i+L*a+j*o),Y=(N=o*y)*R+(x=l*d)*A+(C=a*h)*S-((I=l*h)*R+(M=a*y)*A+(P=o*d)*S),Z=I*g+(D=i*y)*A+(q=o*p)*S-(N*g+(U=l*p)*A+(L=i*h)*S),K=M*g+U*R+(F=i*d)*S-(x*g+D*R+(j=a*p)*S),J=P*g+L*R+j*A-(C*g+q*R+F*A),Q=M*_+P*b+I*E-(C*b+N*E+x*_),$=L*b+N*m+U*_-(D*_+q*b+I*m),ee=D*E+j*b+x*m-(F*b+M*m+U*E),te=F*_+C*m+q*E-(L*E+j*_+P*m),re=i*B+a*z+o*G+l*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(f.getRotation(e,O),w,u.EPSILON7)&&t.equals(f.getRow(e,3,v),T))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=B*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=W*re,n[5]=X*re,n[6]=k*re,n[7]=H*re,n[8]=Y*re,n[9]=Z*re,n[10]=K*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],p=e[12],d=e[13],h=e[14],y=-n*p-i*d-a*h,m=-o*p-u*d-s*h,E=-c*p-f*d-l*h;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=f,t[7]=0,t[8]=a,t[9]=s,t[10]=l,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,a(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f})),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,p=0,d=e.length;p<d;p++){var h=e[p];i=Math.min(i,h.longitude),a=Math.max(a,h.longitude),f=Math.min(f,h.latitude),l=Math.max(l,h.latitude);var y=h.longitude>=0?h.longitude:h.longitude+u.TWO_PI;o=Math.min(o,y),c=Math.max(c,y)}return a-i>c-o&&(i=o,(a=c)>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=f,r.east=a,r.north=l,r):new s(i,f,a,l)},s.fromCartesianArray=function(e,i,o){t.defined("cartesians",e),i=r(i,a.WGS84);for(var c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,d=Number.MAX_VALUE,h=-Number.MAX_VALUE,y=0,m=e.length;y<m;y++){var E=i.cartesianToCartographic(e[y]);c=Math.min(c,E.longitude),f=Math.max(f,E.longitude),d=Math.min(d,E.latitude),h=Math.max(h,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;l=Math.min(l,O),p=Math.max(p,O)}return f-c>p-l&&(c=l,(f=p)>u.PI&&(f-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(o)?(o.west=c,o.south=d,o.east=f,o.north=h,o):new s(c,d,f,h)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;a<o&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,f=r.west;a<o&&c>0?a+=u.TWO_PI:c<f&&a>0&&(c+=u.TWO_PI),a<o&&f<0?f+=u.TWO_PI:c<f&&o<0&&(o+=u.TWO_PI);var l=u.negativePiToPi(Math.max(o,f)),p=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&p<=l)){var d=Math.max(e.south,r.south),h=Math.min(e.north,r.north);if(!(d>=h))return n(i)?(i.west=l,i.south=d,i.east=p,i.north=h,i):new s(l,d,p,h)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(o>=c||a>=u))return n(i)?(i.west=a,i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,f=r.west;a<o&&c>0?a+=u.TWO_PI:c<f&&a>0&&(c+=u.TWO_PI),a<o&&f<0?f+=u.TWO_PI:c<f&&o<0&&(o+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(o,f)),p=u.convertLongitudeRange(Math.max(a,c));return i.west=l,i.south=Math.min(e.south,r.south),i.east=p,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return o<a&&(o+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(n<o||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,f){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(f)||(f=[]);var l=0,p=e.north,d=e.south,h=e.east,y=e.west,m=c;m.height=o,m.longitude=y,m.latitude=p,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.longitude=h,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.latitude=d,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.longitude=y,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.latitude=p<0?p:d>0?d:0;for(var E=1;E<8;++E)m.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,m)&&(f[l]=i.cartographicToCartesian(m,f[l]),l++);return 0===m.latitude&&(m.longitude=y,f[l]=i.cartographicToCartesian(m,f[l]),l++,m.longitude=h,f[l]=i.cartographicToCartesian(m,f[l]),l++),f.length=l,f},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s})),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],(function(e,t,r,n,i,a,o,u,s,c,f,l,p){"use strict";function d(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var h=new e,y=new e,m=new e,E=new e,O=new e,w=new e,v=new e,T=new e,_=new e,b=new e,g=new e,R=new e,A=4/3*c.PI;d.fromPoints=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,a=e.clone(t[0],v),o=e.clone(a,h),u=e.clone(a,y),s=e.clone(a,m),c=e.clone(a,E),f=e.clone(a,O),l=e.clone(a,w),p=t.length;for(n=1;n<p;n++){e.clone(t[n],a);var A=a.x,S=a.y,N=a.z;A<o.x&&e.clone(a,o),A>c.x&&e.clone(a,c),S<u.y&&e.clone(a,u),S>f.y&&e.clone(a,f),N<s.z&&e.clone(a,s),N>l.z&&e.clone(a,l)}var I=e.magnitudeSquared(e.subtract(c,o,T)),M=e.magnitudeSquared(e.subtract(f,u,T)),x=e.magnitudeSquared(e.subtract(l,s,T)),C=o,P=c,D=I;M>D&&(D=M,C=u,P=f),x>D&&(D=x,C=s,P=l);var U=_;U.x=.5*(C.x+P.x),U.y=.5*(C.y+P.y),U.z=.5*(C.z+P.z);var L=e.magnitudeSquared(e.subtract(P,U,T)),q=Math.sqrt(L),F=b;F.x=o.x,F.y=u.y,F.z=s.z;var j=g;j.x=c.x,j.y=f.y,j.z=l.z;var B=e.midpoint(F,j,R),z=0;for(n=0;n<p;n++){e.clone(t[n],a);var G=e.magnitude(e.subtract(a,B,T));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(a,U,T));if(V>L){var W=Math.sqrt(V);L=(q=.5*(q+W))*q;var X=W-q;U.x=(q*U.x+X*a.x)/W,U.y=(q*U.y+X*a.y)/W,U.z=(q*U.z+X*a.z)/W}}return q<z?(e.clone(U,r.center),r.radius=q):(e.clone(B,r.center),r.radius=z),r};var S=new o,N=new e,I=new e,M=new t,x=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new d),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,S),p.southwest(t,M),M.height=a,p.northeast(t,x),x.height=o;var s=r.project(M,N),c=r.project(x,I),f=c.x-s.x,l=c.y-s.y,h=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+h*h);var y=u.center;return y.x=s.x+.5*f,y.y=s.y+.5*l,y.z=s.z+.5*h,u};var C=[];d.fromRectangle3D=function(t,r,o,u){if(r=n(r,a.WGS84),o=n(o,0),i(u)||(u=new d),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=p.subsample(t,r,o,C);return d.fromPoints(s,u)},d.fromVertices=function(t,a,o,u){if(i(u)||(u=new d),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=v;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;var c,f=e.clone(s,h),l=e.clone(s,y),p=e.clone(s,m),A=e.clone(s,E),S=e.clone(s,O),N=e.clone(s,w),I=t.length;for(c=0;c<I;c+=o){var M=t[c]+a.x,x=t[c+1]+a.y,C=t[c+2]+a.z;s.x=M,s.y=x,s.z=C,M<f.x&&e.clone(s,f),M>A.x&&e.clone(s,A),x<l.y&&e.clone(s,l),x>S.y&&e.clone(s,S),C<p.z&&e.clone(s,p),C>N.z&&e.clone(s,N)}var P=e.magnitudeSquared(e.subtract(A,f,T)),D=e.magnitudeSquared(e.subtract(S,l,T)),U=e.magnitudeSquared(e.subtract(N,p,T)),L=f,q=A,F=P;D>F&&(F=D,L=l,q=S),U>F&&(F=U,L=p,q=N);var j=_;j.x=.5*(L.x+q.x),j.y=.5*(L.y+q.y),j.z=.5*(L.z+q.z);var B=e.magnitudeSquared(e.subtract(q,j,T)),z=Math.sqrt(B),G=b;G.x=f.x,G.y=l.y,G.z=p.z;var V=g;V.x=A.x,V.y=S.y,V.z=N.z;var W=e.midpoint(G,V,R),X=0;for(c=0;c<I;c+=o){s.x=t[c]+a.x,s.y=t[c+1]+a.y,s.z=t[c+2]+a.z;var k=e.magnitude(e.subtract(s,W,T));k>X&&(X=k);var H=e.magnitudeSquared(e.subtract(s,j,T));if(H>B){var Y=Math.sqrt(H);B=(z=.5*(z+Y))*z;var Z=Y-z;j.x=(z*j.x+Z*s.x)/Y,j.y=(z*j.y+Z*s.y)/Y,j.z=(z*j.z+Z*s.z)/Y}}return z<X?(e.clone(j,u.center),u.radius=z):(e.clone(W,u.center),u.radius=X),u},d.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new d),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=v;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];var o,u=e.clone(a,h),s=e.clone(a,y),c=e.clone(a,m),f=e.clone(a,E),l=e.clone(a,O),p=e.clone(a,w),A=t.length;for(o=0;o<A;o+=3){var S=t[o]+r[o],N=t[o+1]+r[o+1],I=t[o+2]+r[o+2];a.x=S,a.y=N,a.z=I,S<u.x&&e.clone(a,u),S>f.x&&e.clone(a,f),N<s.y&&e.clone(a,s),N>l.y&&e.clone(a,l),I<c.z&&e.clone(a,c),I>p.z&&e.clone(a,p)}var M=e.magnitudeSquared(e.subtract(f,u,T)),x=e.magnitudeSquared(e.subtract(l,s,T)),C=e.magnitudeSquared(e.subtract(p,c,T)),P=u,D=f,U=M;x>U&&(U=x,P=s,D=l),C>U&&(U=C,P=c,D=p);var L=_;L.x=.5*(P.x+D.x),L.y=.5*(P.y+D.y),L.z=.5*(P.z+D.z);var q=e.magnitudeSquared(e.subtract(D,L,T)),F=Math.sqrt(q),j=b;j.x=u.x,j.y=s.y,j.z=c.z;var B=g;B.x=f.x,B.y=l.y,B.z=p.z;var z=e.midpoint(j,B,R),G=0;for(o=0;o<A;o+=3){a.x=t[o]+r[o],a.y=t[o+1]+r[o+1],a.z=t[o+2]+r[o+2];var V=e.magnitude(e.subtract(a,z,T));V>G&&(G=V);var W=e.magnitudeSquared(e.subtract(a,L,T));if(W>q){var X=Math.sqrt(W);q=(F=.5*(F+X))*F;var k=X-F;L.x=(F*L.x+k*a.x)/X,L.y=(F*L.y+k*a.y)/X,L.z=(F*L.z+k*a.z)/X}}return F<G?(e.clone(L,n.center),n.radius=F):(e.clone(z,n.center),n.radius=G),n},d.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new d);var o=e.midpoint(t,n,a.center);return a.radius=e.distance(o,n),a},d.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;d.fromBoundingSpheres=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return d.clone(t[0],r);if(2===n)return d.union(t[0],t[1],r);var a,o=[];for(a=0;a<n;a++)o.push(t[a].center);var u=(r=d.fromPoints(o,r)).center,s=r.radius;for(a=0;a<n;a++){var c=t[a];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var D=new e,U=new e,L=new e;d.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new d);var a=t.halfAxes,o=f.getColumn(a,0,D),u=f.getColumn(a,1,U),s=f.getColumn(a,2,L);return e.add(o,u,o),e.add(o,s,o),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(o),n},d.clone=function(t,r){if(i(t))return i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius)},d.packedLength=4,d.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},d.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new d);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var q=new e,F=new e;d.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new d);var o=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,o,q),l=e.magnitude(f);if(u>=l+c)return t.clone(a),a;if(c>=l+u)return n.clone(a),a;var p=.5*(u+l+c),h=e.multiplyByScalar(f,(-u+p)/l,F);return e.add(h,o,h),e.clone(h,a.center),a.radius=p,a};var j=new e;d.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=d.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,j));return a>i.radius&&(i.radius=a),i},d.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return s<-a?u.OUTSIDE:s<a?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var B=new e;d.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,B);return e.magnitudeSquared(i)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;d.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,z),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var G=new e,V=new e,W=new e,X=new e,k=new e,H=new t,Y=new Array(8),Z=0;Z<8;++Z)Y[Z]=new e;var K=new o;return d.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t);var o=(i=n(i,K)).ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,G),f=e.cross(e.UNIT_Z,c,V);e.normalize(f,f);var l=e.cross(c,f,W);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var p=e.negate(l,k),h=e.negate(f,X),y=Y,m=y[0];e.add(c,l,m),e.add(m,f,m),m=y[1],e.add(c,l,m),e.add(m,h,m),m=y[2],e.add(c,p,m),e.add(m,h,m),m=y[3],e.add(c,p,m),e.add(m,f,m),e.negate(c,c),m=y[4],e.add(c,l,m),e.add(m,f,m),m=y[5],e.add(c,l,m),e.add(m,h,m),m=y[6],e.add(c,p,m),e.add(m,h,m),m=y[7],e.add(c,p,m),e.add(m,f,m);for(var E=y.length,O=0;O<E;++O){var w=y[O];e.add(u,w,w);var v=o.cartesianToCartographic(w,H);i.project(v,w)}var T=(u=(a=d.fromPoints(y,a)).center).x,_=u.y,b=u.z;return u.x=b,u.y=T,u.z=_,a},d.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d.prototype.volume=function(){var e=this.radius;return A*e*e*e},d})),define("Core/Fullscreen",["./defined","./defineProperties"],(function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;o<u;++o){var s=a[o];("function"==typeof t[i=s+"RequestFullscreen"]||"function"==typeof t[i=s+"RequestFullScreen"])&&(n.requestFullscreen=i,r=!0),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i})),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],(function(e,t,r){"use strict";var n,i,a,o,u,s,c,f,l,p,d,h,y,m,E,O,w;function v(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function T(){if(!t(i)&&(i=!1,!R())){var e=/ Chrome\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(i=!0,a=v(e[1]))}return i}function _(){if(!t(o)&&(o=!1,!T()&&!R()&&/ Safari\/[\.0-9]+/.test(n.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(o=!0,u=v(e[1]))}return o}function b(){if(!t(s)){s=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(n.userAgent);null!==e&&(s=!0,(c=v(e[1])).isNightly=!!e[2])}return s}function g(){var e;return t(f)||(f=!1,"Microsoft Internet Explorer"===n.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=v(e[1])):"Netscape"===n.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(f=!0,l=v(e[1]))),f}function R(){if(!t(p)){p=!1;var e=/ Edge\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(p=!0,d=v(e[1]))}return p}function A(){if(!t(h)){h=!1;var e=/Firefox\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(h=!0,y=v(e[1]))}return h}function S(){if(!t(w)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;(w=t(r)&&""!==r)&&(O=r)}return w}n="undefined"!=typeof navigator?navigator:{};var N=[];"undefined"!=typeof ArrayBuffer&&(N.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&N.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&N.push(CanvasPixelArray));var I={isChrome:T,chromeVersion:function(){return T()&&a},isSafari:_,safariVersion:function(){return _()&&u},isWebkit:b,webkitVersion:function(){return b()&&c},isInternetExplorer:g,internetExplorerVersion:function(){return g()&&l},isEdge:R,edgeVersion:function(){return R()&&d},isFirefox:A,firefoxVersion:function(){return A()&&y},isWindows:function(){return t(m)||(m=/Windows/i.test(n.appVersion)),m},hardwareConcurrency:e(n.hardwareConcurrency,3),supportsPointerEvents:function(){return t(E)||(E=!A()&&"undefined"!=typeof PointerEvent&&(!t(n.pointerEnabled)||n.pointerEnabled)),E},supportsImageRenderingPixelated:S,imageRenderingValue:function(){return S()?O:void 0},typedArrayTypes:N,supportsFullscreen:function(){return r.supportsFullscreen()},supportsTypedArrays:function(){return"undefined"!=typeof ArrayBuffer},supportsWebWorkers:function(){return"undefined"!=typeof Worker},supportsWebAssembly:function(){return"undefined"!=typeof WebAssembly&&!I.isEdge()}};return I})),define("Core/WebGLConstants",["./freezeObject"],(function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})})),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],(function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE,getSizeInBytes:function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},fromTypedArray:function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},validate:function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},createTypedArray:function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},createArrayBufferView:function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},fromName:function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}}};return i(o)})),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;a<i;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;a<i;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f),a.acosClamped(o.dot(c,f))};var l=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o})),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],(function(e){"use strict";return e({NONE:0,TOP:1,ALL:2})})),define("Core/GeometryType",["./freezeObject"],(function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})})),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],(function(e,t,r,n,i,a){"use strict";function o(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}o.packedLength=4,o.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},o.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a},o.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3])},o.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a},o.fromColumnMajorArray=function(e,r){return t.defined("values",e),o.clone(e,r)},o.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new o(e,0,0,e)},o.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=-a,r[3]=i,r):new o(i,-a,a,i)},o.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},o.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,a=e[i],o=e[i+1];return n.x=a,n.y=o,n},o.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var a=2*r;return(i=o.clone(e,i))[a]=n.x,i[a+1]=n.y,i},o.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],a=e[r+2];return n.x=i,n.y=a,n},o.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=o.clone(e,i))[r]=n.x,i[r+2]=n.y,i};var u=new e;o.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],a=e[0]*r[2]+e[2]*r[3],o=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n},o.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},o.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},o.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,a=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=a,n},o.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},o.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},o.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},o.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],a=e[1],o=e[3];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r},o.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},o.IDENTITY=a(new o(1,0,0,1)),o.ZERO=a(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,i(o.prototype,{length:{get:function(){return o.packedLength}}}),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o})),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],(function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)})),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,a){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var o=i/2,u=Math.sin(o),f=(c=e.normalize(r,c)).x*u,l=c.y*u,p=c.z*u,d=Math.cos(o);return n(a)?(a.x=f,a.y=l,a.z=p,a.w=d,a):new s(f,l,p,d)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){var i,a,o,c,p;t.typeOf.object("matrix",e);var d=e[u.COLUMN0ROW0],h=e[u.COLUMN1ROW1],y=e[u.COLUMN2ROW2],m=d+h+y;if(m>0)p=.5*(i=Math.sqrt(m+1)),i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var E=0;h>d&&(E=1),y>d&&y>h&&(E=2);var O=f[E],w=f[O];i=Math.sqrt(e[u.getElementIndex(E,E)]-e[u.getElementIndex(O,O)]-e[u.getElementIndex(w,w)]+1);var v=l;v[E]=.5*i,i=.5/i,p=(e[u.getElementIndex(w,O)]-e[u.getElementIndex(O,w)])*i,v[O]=(e[u.getElementIndex(O,E)]+e[u.getElementIndex(E,O)])*i,v[w]=(e[u.getElementIndex(w,E)]+e[u.getElementIndex(E,w)])*i,a=-v[0],o=-v[1],c=-v[2]}return n(r)?(r.x=a,r.y=o,r.z=c,r.w=p,r):new s(a,o,c,p)};var p=new s,d=new s,h=new s,y=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=s.fromAxisAngle(e.UNIT_X,r.roll,p),h=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(h,y,h),d=s.fromAxisAngle(e.UNIT_Z,-r.heading,p),s.multiply(d,n,n)};var m=new e,E=new e,O=new s,w=new s,v=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,v),s.conjugate(v,v);for(var i=0,a=r-t+1;i<a;i++){var o=3*i;s.unpack(e,4*(t+i),O),s.multiply(O,v,O),O.w<0&&s.negate(O,O),s.computeAxis(O,m);var u=s.computeAngle(O);n[o]=m.x*u,n[o+1]=m.y*u,n[o+2]=m.z*u}},s.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*a,w),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(E,u,O),s.multiply(O,w,o)},s.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w)},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return r.x=i,r.y=a,r.z=o,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,a=e.y,o=e.z,u=e.w,s=r.x,c=r.y,f=r.z,l=r.w,p=u*s+i*l+a*f-o*c,d=u*c-i*f+a*l+o*s,h=u*f+i*c-a*s+o*l,y=u*l-i*s-a*c-o*f;return n.x=p,n.y=d,n.z=h,n.w=y,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var T=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),T=s.multiplyByScalar(r,n,T),i=s.multiplyByScalar(e,1-n,i),s.add(T,i,i)};var _=new s,b=new s,g=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a=s.dot(e,r),u=r;if(a<0&&(a=-a,u=_=s.negate(r,_)),1-a<o.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(a);return b=s.multiplyByScalar(e,Math.sin((1-n)*c),b),g=s.multiplyByScalar(u,Math.sin(n*c),g),i=s.add(b,g,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=o.acosClamped(r.w),a=0;return 0!==i&&(a=i/Math.sin(i)),e.multiplyByScalar(r,a,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),a=0;return 0!==i&&(a=Math.sin(i)/i),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(i),n};var R=new e,A=new e,S=new s,N=new s;s.computeInnerQuadrangle=function(r,n,i,a){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",a);var o=s.conjugate(n,S);s.multiply(o,i,N);var u=s.log(N,R);s.multiply(o,r,N);var c=s.log(N,A);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,S),s.multiply(n,S,a)},s.squad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.slerp(e,r,a,S),c=s.slerp(n,i,a,N);return s.slerp(u,c,2*a*(1-a),o)};for(var I=new s,M=1.9011074535173003,x=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],D=i.supportsTypedArrays()?new Float32Array(8):[],U=0;U<7;++U){var L=U+1,q=2*L+1;x[U]=1/(L*q),C[U]=L/q}return x[7]=M/136,C[7]=8*M/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a,o=s.dot(e,r);o>=0?a=1:(a=-1,o=-o);for(var u=o-1,c=1-n,f=n*n,l=c*c,p=7;p>=0;--p)P[p]=(x[p]*f-C[p])*u,D[p]=(x[p]*l-C[p])*u;var d=a*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),h=c*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),y=s.multiplyByScalar(e,h,I);return s.multiplyByScalar(r,d,i),s.add(y,i,i)},s.fastSquad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.fastSlerp(e,r,a,S),c=s.fastSlerp(n,i,a,N);return s.fastSlerp(u,c,2*a*(1-a),o)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s})),
/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */
function(e){"use strict";e("ThirdParty/when",[],(function(){var e,t;function r(e,t,r,i){return n(e).then(t,r,i)}function n(e){var t,r,s;return e instanceof i?t=e:u(e)?(r=o(),e.then((function(e){r.resolve(e)}),(function(e){r.reject(e)}),(function(e){r.progress(e)})),t=r.promise):(s=e,t=new i((function(e){try{return n(e?e(s):s)}catch(e){return a(e)}}))),t}function i(e){this.then=e}function a(e){return new i((function(t,r){try{return r?n(r(e)):a(e)}catch(e){return a(e)}}))}function o(){var e,t,r,u,s,c;return e=new i(f),t=[],r=[],u=function(e,n,i){var a,u;return a=o(),u="function"==typeof i?function(e){try{a.progress(i(e))}catch(e){a.progress(e)}}:function(e){a.progress(e)},t.push((function(t){t.then(e,n).then(a.resolve,a.reject,u)})),r.push(u),a.promise},s=function(e){return l(r,e),e},c=function(e){return e=n(e),u=e.then,c=n,s=d,l(t,e),r=t=void 0,e},{then:f,resolve:p,reject:h,progress:y,promise:e,resolver:{resolve:p,reject:h,progress:y}};function f(e,t,r){return u(e,t,r)}function p(e){return c(e)}function h(e){return c(a(e))}function y(e){return s(e)}}function u(e){return e&&"function"==typeof e.then}function s(e,t,n,i,a){return p(2,arguments),r(e,(function(e){var u,s,c,f,l,p,h,y,m,E;if(m=e.length>>>0,u=Math.max(0,Math.min(t,m)),c=[],s=m-u+1,f=[],l=o(),u)for(y=l.progress,h=function(e){f.push(e),--s||(p=h=d,l.reject(f))},p=function(e){c.push(e),--u||(p=h=d,l.resolve(c))},E=0;E<m;++E)E in e&&r(e[E],w,O,y);else l.resolve(c);return l.then(n,i,a);function O(e){h(e)}function w(e){p(e)}}))}function c(e,t,r,n){return p(1,arguments),f(e,h).then(t,r,n)}function f(e,t){return r(e,(function(e){var n,i,a,u,s,c;if(a=i=e.length>>>0,n=[],c=o(),a)for(u=function(e,i){r(e,t).then((function(e){n[i]=e,--a||c.resolve(n)}),c.reject)},s=0;s<i;s++)s in e?u(e[s],s):--a;else c.resolve(n);return c.promise}))}function l(e,t){for(var r,n=0;r=e[n++];)r(t)}function p(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function d(){}function h(e){return e}return r.defer=o,r.resolve=n,r.reject=function(e){return r(e,a)},r.join=function(){return f(arguments,h)},r.all=c,r.map=f,r.reduce=function(n,i){var a=t.call(arguments,1);return r(n,(function(t){var n;return n=t.length,a[0]=function(e,t,a){return r(e,(function(e){return r(t,(function(t){return i(e,t,a,n)}))}))},e.apply(t,a)}))},r.any=function(e,t,r,n){return s(e,1,(function(e){return t?t(e[0]):e[0]}),r,n)},r.some=s,r.chain=function(e,t,n){var i=arguments.length>2;return r(e,(function(e){return e=i?n:e,t.resolve(e),e}),(function(e){return t.reject(e),a(e)}),t.progress)},r.isPromise=u,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(void 0,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return c(t,(function(t){return e.apply(void 0,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,r,n,i,a;if(a=0,i=(t=Object(this)).length>>>0,(r=arguments).length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;a<i;++a)a in t&&(n=e(n,t[a],a,t));return n},r}))}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./Check"],(function(e){"use strict";return function(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,a,o=0,u=t.length-1;o<=u;)if((a=n(t[i=~~((o+u)/2)],r))<0)o=i+1;else{if(!(a>0))return i;u=i-1}return~(u+1)}})),define("Core/EarthOrientationParametersSample",[],(function(){"use strict";return function(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}})),
/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/
define("ThirdParty/sprintf",[],(function(){return function(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var u=n-e.length;return u>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return e=(r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"")+i(c.toString(t),u||0,"0",!1),a(e,r,n,o,s)},u=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},s=function(e,n,s,c,f,l,p){var d,h,y,m,E;if("%%"==e)return"%";for(var O=!1,w="",v=!1,T=!1,_=" ",b=s.length,g=0;s&&g<b;g++)switch(s.charAt(g)){case" ":w=" ";break;case"+":w="+";break;case"-":O=!0;break;case"'":_=s.charAt(g+1);break;case"0":v=!0;break;case"#":T=!0}if((c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0)<0&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:"fFeE".indexOf(p)>-1?6:"d"==p?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],p){case"s":return u(String(E),O,c,l,v,_);case"c":return u(String.fromCharCode(+E),O,c,l,v);case"b":return o(E,2,T,O,c,l,v);case"o":return o(E,8,T,O,c,l,v);case"x":return o(E,16,T,O,c,l,v);case"X":return o(E,16,T,O,c,l,v).toUpperCase();case"u":return o(E,10,T,O,c,l,v);case"i":case"d":return d=+E||0,E=(h=(d=Math.round(d-d%1))<0?"-":w)+i(String(Math.abs(d)),l,"0",!1),a(E,h,O,c,v);case"e":case"E":case"f":case"F":case"g":case"G":return h=(d=+E)<0?"-":w,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(p.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(p)%2],E=h+Math.abs(d)[y](l),a(E,h,O,c,v)[m]();default:return e}};return n.replace(e,s)}})),define("Core/GregorianDate",[],(function(){"use strict";return function(e,t,r,n,i,a,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u}})),define("Core/isLeapYear",["./DeveloperError"],(function(e){"use strict";return function(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4==0&&t%100!=0||t%400==0}})),define("Core/LeapSecond",[],(function(){"use strict";return function(e,t){this.julianDate=e,this.offset=t}})),define("Core/TimeConstants",["./freezeObject"],(function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})})),define("Core/TimeStandard",["./freezeObject"],(function(e){"use strict";return e({UTC:0,TAI:1})})),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,a,o,u,s,c){"use strict";var f=new a,l=[31,28,31,30,31,30,31,31,30,31,30,31];function p(e,t){return N.compare(e.julianDate,t.julianDate)}var d=new u;function h(e){d.julianDate=e;var r=N.leapSeconds,n=t(r,d,p);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;n>0&&N.secondsDifference(r[n].julianDate,e)>i&&(i=r[--n].offset),N.addSeconds(e,i,e)}function y(e,r){d.julianDate=e;var n=N.leapSeconds,i=t(n,d,p);if(i<0&&(i=~i),0===i)return N.addSeconds(e,-n[0].offset,r);if(i>=n.length)return N.addSeconds(e,-n[i-1].offset,r);var a=N.secondsDifference(n[i].julianDate,e);return 0===a?N.addSeconds(e,-n[i].offset,r):a<=1?void 0:N.addSeconds(e,-n[--i].offset,r)}function m(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,(t-=s.SECONDS_PER_DAY*n)<0&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,i,a,o){var u=(t-14)/12|0,c=e+4800+u,f=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var l=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return l>=43200&&(f-=1),[f,l]}var O=/^(\d{4})$/,w=/^(\d{4})-(\d{2})$/,v=/^(\d{4})-?(\d{3})$/,T=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,_=/^(\d{4})-?(\d{2})-?(\d{2})$/,b=/([Z+\-])?(\d{2})?:?(\d{2})?$/,g=/^(\d{2})(\.\d+)?/.source+b.source,R=/^(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,A=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,S="Invalid ISO 8601 date.";function N(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;m(i,t+=(e-i)*s.SECONDS_PER_DAY,this),n===c.UTC&&h(this)}N.fromGregorianDate=function(e,t){if(!(e instanceof a))throw new i("date must be a valid GregorianDate.");var r=E(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(m(r[0],r[1],t),h(t),t):new N(r[0],r[1],c.UTC)},N.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(m(r[0],r[1],t),h(t),t):new N(r[0],r[1],c.UTC)},N.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(S);var r,a,u,s,f,p=(e=e.replace(",",".")).split("T"),d=1,y=1,b=0,I=0,M=0,x=0,C=p[0],P=p[1];if(!n(C))throw new i(S);if(null!==(p=C.match(_))){if((s=C.split("-").length-1)>0&&2!==s)throw new i(S);r=+p[1],d=+p[2],y=+p[3]}else if(null!==(p=C.match(w)))r=+p[1],d=+p[2];else if(null!==(p=C.match(O)))r=+p[1];else{var D;if(null!==(p=C.match(v))){if(r=+p[1],D=+p[2],u=o(r),D<1||u&&D>366||!u&&D>365)throw new i(S)}else{if(null===(p=C.match(T)))throw new i(S);r=+p[1];var U=+p[2],L=+p[3]||0;if((s=C.split("-").length-1)>0&&(!n(p[3])&&1!==s||n(p[3])&&2!==s))throw new i(S);D=7*U+L-new Date(Date.UTC(r,0,4)).getUTCDay()-3}(a=new Date(Date.UTC(r,0,1))).setUTCDate(D),d=a.getUTCMonth()+1,y=a.getUTCDate()}if(u=o(r),d<1||d>12||y<1||(2!==d||!u)&&y>l[d-1]||u&&2===d&&y>29)throw new i(S);if(n(P)){if(null!==(p=P.match(A))){if((s=P.split(":").length-1)>0&&2!==s&&3!==s)throw new i(S);b=+p[1],I=+p[2],M=+p[3],x=1e3*+(p[4]||0),f=5}else if(null!==(p=P.match(R))){if((s=P.split(":").length-1)>2)throw new i(S);b=+p[1],I=+p[2],M=60*+(p[3]||0),f=4}else{if(null===(p=P.match(g)))throw new i(S);b=+p[1],I=60*+(p[2]||0),f=3}if(I>=60||M>=61||b>24||24===b&&(I>0||M>0||x>0))throw new i(S);var q=p[f],F=+p[f+1],j=+(p[f+2]||0);switch(q){case"+":b-=F,I-=j;break;case"-":b+=F,I+=j;break;case"Z":break;default:I+=new Date(Date.UTC(r,d-1,y,b,I)).getTimezoneOffset()}}var B=60===M;for(B&&M--;I>=60;)I-=60,b++;for(;b>=24;)b-=24,y++;for(a=u&&2===d?29:l[d-1];y>a;)y-=a,++d>12&&(d-=12,r++),a=u&&2===d?29:l[d-1];for(;I<0;)I+=60,b--;for(;b<0;)b+=24,y--;for(;y<1;)--d<1&&(d+=12,r--),y+=a=u&&2===d?29:l[d-1];var z=E(r,d,y,b,I,M,x);return n(t)?(m(z[0],z[1],t),h(t)):t=new N(z[0],z[1],c.UTC),B&&N.addSeconds(t,1,t),t},N.now=function(e){return N.fromDate(new Date,e)};var I=new N(0,0,c.TAI);return N.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,o=y(e,I);n(o)||(N.addSeconds(e,-1,I),o=y(I,I),r=!0);var u=o.dayNumber,c=o.secondsOfDay;c>=43200&&(u+=1);var f=u+68569|0,l=4*f/146097|0,p=4e3*(1+(f=f-((146097*l+3)/4|0)|0))/1461001|0,d=80*(f=f-(1461*p/4|0)+31|0)/2447|0,h=f-(2447*d/80|0)|0,m=d+2-12*(f=d/11|0)|0,E=100*(l-49)+p+f|0,O=c/s.SECONDS_PER_HOUR|0,w=c-O*s.SECONDS_PER_HOUR,v=w/s.SECONDS_PER_MINUTE|0,T=0|(w-=v*s.SECONDS_PER_MINUTE),_=(w-T)/s.SECONDS_PER_MILLISECOND;return(O+=12)>23&&(O-=24),r&&(T+=1),n(t)?(t.year=E,t.month=m,t.day=h,t.hour=O,t.minute=v,t.second=T,t.millisecond=_,t.isLeapSecond=r,t):new a(E,m,h,O,v,T,_,r)},N.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=N.toGregorianDate(e,f),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},N.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var a,o=N.toGregorianDate(t,f),u=o.year,s=o.month,c=o.day,l=o.hour,p=o.minute,d=o.second,h=o.millisecond;return 1e4===u&&1===s&&1===c&&0===l&&0===p&&0===d&&0===h&&(u=9999,s=12,c=31,l=24),n(r)||0===h?n(r)&&0!==r?(a=(.01*h).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,l,p,d,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",u,s,c,l,p,d):(a=(.01*h).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,l,p,d,a))},N.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new N(e.dayNumber,e.secondsOfDay,c.TAI)},N.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},N.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},N.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(N.secondsDifference(e,t))<=r},N.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},N.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},N.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY},N.computeTaiMinusUtc=function(e){d.julianDate=e;var r=N.leapSeconds,n=t(r,d,p);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},N.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return m(e.dayNumber,e.secondsOfDay+t,r)},N.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return m(e.dayNumber,a,r)},N.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return m(e.dayNumber,a,r)},N.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");return m(e.dayNumber+t,e.secondsOfDay,r)},N.lessThan=function(e,t){return N.compare(e,t)<0},N.lessThanOrEquals=function(e,t){return N.compare(e,t)<=0},N.greaterThan=function(e,t){return N.compare(e,t)>0},N.greaterThanOrEquals=function(e,t){return N.compare(e,t)>=0},N.prototype.clone=function(e){return N.clone(this,e)},N.prototype.equals=function(e){return N.equals(this,e)},N.prototype.equalsEpsilon=function(e,t){return N.equalsEpsilon(this,e,t)},N.prototype.toString=function(){return N.toIso8601(this)},N.leapSeconds=[new u(new N(2441317,43210,c.TAI),10),new u(new N(2441499,43211,c.TAI),11),new u(new N(2441683,43212,c.TAI),12),new u(new N(2442048,43213,c.TAI),13),new u(new N(2442413,43214,c.TAI),14),new u(new N(2442778,43215,c.TAI),15),new u(new N(2443144,43216,c.TAI),16),new u(new N(2443509,43217,c.TAI),17),new u(new N(2443874,43218,c.TAI),18),new u(new N(2444239,43219,c.TAI),19),new u(new N(2444786,43220,c.TAI),20),new u(new N(2445151,43221,c.TAI),21),new u(new N(2445516,43222,c.TAI),22),new u(new N(2446247,43223,c.TAI),23),new u(new N(2447161,43224,c.TAI),24),new u(new N(2447892,43225,c.TAI),25),new u(new N(2448257,43226,c.TAI),26),new u(new N(2448804,43227,c.TAI),27),new u(new N(2449169,43228,c.TAI),28),new u(new N(2449534,43229,c.TAI),29),new u(new N(2450083,43230,c.TAI),30),new u(new N(2450630,43231,c.TAI),31),new u(new N(2451179,43232,c.TAI),32),new u(new N(2453736,43233,c.TAI),33),new u(new N(2454832,43234,c.TAI),34),new u(new N(2456109,43235,c.TAI),35),new u(new N(2457204,43236,c.TAI),36),new u(new N(2457754,43237,c.TAI),37)],N})),
/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
define("ThirdParty/Uri",[],(function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var n=t.exec(r);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var t=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(i,o).replace(r,a)),this.path&&(this.path=this.path.replace(r,a)),this.query&&(this.query=this.query.replace(r,a)),this.fragment&&(this.fragment=this.fragment.replace(r,a))};var r=/%[0-9a-z]{2}/gi,n=/[a-zA-Z0-9\-\._~]/,i=/(.*@)?([^@:]*)(:.*)?/;function a(e){var t=unescape(e);return n.test(t)?t:e.toUpperCase()}function o(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e})),define("Core/appendForwardSlash",[],(function(){"use strict";return function(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}})),define("Core/clone",["./defaultValue"],(function(e){"use strict";return function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i}})),define("Core/combine",["./defaultValue","./defined"],(function(e,t){"use strict";return function r(n,i,a){a=e(a,!1);var o,u,s,c={},f=t(n),l=t(i);if(f)for(o in n)n.hasOwnProperty(o)&&(u=n[o],l&&a&&"object"==typeof u&&i.hasOwnProperty(o)?(s=i[o],c[o]="object"==typeof s?r(u,s,a):u):c[o]=u);if(l)for(o in i)i.hasOwnProperty(o)&&!c.hasOwnProperty(o)&&(s=i[o],c[o]=s);return c}})),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={};function i(i,a){if(!t(i))throw new r("identifier is required.");t(n[i])||(n[i]=!0,console.warn(e(a,i)))}return i.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",i.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",i.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",i.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",i})),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],(function(e,t,r){"use strict";return function(n,i){if(!e(n)||!e(i))throw new t("identifier and message are required.");r(n,i)}})),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,a,o){if(!r(i))throw new n("relative uri is required.");if(!r(a)){if(void 0===o)return i;a=t(o.baseURI,o.location.href)}var u=new e(a);return new e(i).resolve(u).toString()},i})),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n,i){if(!t(n))throw new r("uri is required.");var a="",o=n.lastIndexOf("/");return-1!==o&&(a=n.substring(0,o+1)),i?(n=new e(n),t(n.query)&&(a+="?"+n.query),t(n.fragment)&&(a+="#"+n.fragment),a):a}})),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var a=i.path,o=a.lastIndexOf("/");return-1!==o&&(a=a.substr(o+1)),o=a.lastIndexOf("."),a=-1===o?"":a.substr(o+1)}})),define("Core/isBlobUri",["./Check"],(function(e){"use strict";var t=/^blob:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/isCrossOriginUrl",["./defined"],(function(e){"use strict";var t;return function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var n=t.host,i=t.protocol;return t.href=r,t.href=t.href,i!==t.protocol||n!==t.host}})),define("Core/isDataUri",["./Check"],(function(e){"use strict";var t=/^data:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/loadAndExecuteScript",["../ThirdParty/when"],(function(e){"use strict";return function(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}})),define("Core/isArray",["./defined"],(function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t})),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("obj is required.");var i="";for(var a in n)if(n.hasOwnProperty(a)){var o=n[a],u=encodeURIComponent(a)+"=";if(r(o))for(var s=0,c=o.length;s<c;++s)i+=u+encodeURIComponent(o[s])+"&";else i+=u+encodeURIComponent(o)+"&"}return i=i.slice(0,-1)}})),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var a=n.replace(/\+/g,"%20").split(/[&;]/),o=0,u=a.length;o<u;++o){var s=a[o].split("="),c=decodeURIComponent(s[0]),f=s[1];f=e(f)?decodeURIComponent(f):"";var l=i[c];"string"==typeof l?i[c]=[l,f]:r(l)?l.push(f):i[c]=f}return i}})),define("Core/RequestState",["../Core/freezeObject"],(function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})})),define("Core/RequestType",["../Core/freezeObject"],(function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})})),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],(function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),a=i||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=a,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i})),define("Core/parseResponseHeaders",[],(function(){"use strict";return function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}})),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],(function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r})),define("Core/Event",["./Check","./defined","./defineProperties"],(function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,a=-1,o=0;o<n.length;o++)if(n[o]===t&&i[o]===r){a=o;break}return-1!==a&&(this._insideRaiseEvent?(this._toRemove.push(a),n[a]=void 0,i[a]=void 0):(n.splice(a,1),i.splice(a,1)),!0)},n.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var r=this._listeners,n=this._scopes,a=r.length;for(e=0;e<a;e++){var o=r[e];t(o)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if((a=u.length)>0){for(u.sort(i),e=0;e<a;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n})),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],(function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function a(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,o=-1,u=!0;u;){var s=2*(e+1),c=s-1;o=c<r&&n(i[c],i[e])<0?c:e,s<r&&n(i[s],i[o])<0&&(o=s),o!==e?(a(i,o,e),e=o):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n,i=this._array,o=this._comparator,u=this._maximumLength,s=this._length++;for(s<i.length?i[s]=t:i.push(t);0!==s;){var c=Math.floor((s-1)/2);if(!(o(i[s],i[c])<0))break;a(i,s,c),s=c}return r(u)&&this._length>u&&(n=i[u],this._length=u),n},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return a(n,r,--this._length),this.heapify(r),i}},i})),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],(function(e,t,r,n,i,a,o,u,s,c,f){"use strict";var l={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},p=20,d=new u({comparator:function(e,t){return e.priority-t.priority}});d.maximumLength=p,d.reserve(p);var h=[],y={},m="undefined"!=typeof document?new e(document.location.href):new e,E=new o;function O(){}function w(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function v(e){var t=n(O.requestsByServer[e],O.maximumRequestsPerServer);return y[e]<t}function T(e){return e.state===f.UNISSUED&&(e.state=f.ISSUED,e.deferred=t.defer()),e.deferred.promise}function _(e){var t=T(e);return e.state=f.ACTIVE,h.push(e),++l.numberOfActiveRequests,++l.numberOfActiveRequestsEver,++y[e.serverKey],e.requestFunction().then(function(e){return function(t){e.state!==f.CANCELLED&&(--l.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(),e.state=f.RECEIVED,e.deferred.resolve(t))}}(e)).otherwise(function(e){return function(t){e.state!==f.CANCELLED&&(++l.numberOfFailedRequests,--l.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(t),e.state=f.FAILED,e.deferred.reject(t))}}(e)),t}function b(e){var t=e.state===f.ACTIVE;e.state=f.CANCELLED,++l.numberOfCancelledRequests,e.deferred.reject(),t&&(--l.numberOfActiveRequests,--y[e.serverKey],++l.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}return O.maximumRequests=50,O.maximumRequestsPerServer=6,O.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},O.throttleRequests=!0,O.debugShowStatistics=!1,O.requestCompletedEvent=E,a(O,{statistics:{get:function(){return l}},priorityHeapLength:{get:function(){return p},set:function(e){if(e<p)for(;d.length>e;)b(d.pop());p=e,d.maximumLength=e,d.reserve(e)}}}),O.update=function(){var e,t,r=0,n=h.length;for(e=0;e<n;++e)(t=h[e]).cancelled&&b(t),t.state===f.ACTIVE?r>0&&(h[e-r]=t):++r;h.length-=r;var i=d.internalArray,a=d.length;for(e=0;e<a;++e)w(i[e]);d.resort();for(var o=Math.max(O.maximumRequests-h.length,0),u=0;u<o&&d.length>0;)(t=d.pop()).cancelled?b(t):!t.throttleByServer||v(t.serverKey)?(_(t),++u):b(t);O.debugShowStatistics&&(l.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+l.numberOfAttemptedRequests),l.numberOfActiveRequests>0&&console.log("Number of active requests: "+l.numberOfActiveRequests),l.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+l.numberOfCancelledRequests),l.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+l.numberOfCancelledActiveRequests),l.numberOfFailedRequests>0&&console.log("Number of failed requests: "+l.numberOfFailedRequests),l.numberOfAttemptedRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0)},O.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(m);n.normalize();var a=n.authority;/:/.test(a)||(a=a+":"+("https"===n.scheme?"443":"80"));var o=y[a];return i(o)||(y[a]=0),a},O.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return E.raiseEvent(),e.state=f.RECEIVED,e.requestFunction();if(++l.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=O.getServerKey(e.url)),!O.throttleRequests||!e.throttle)return _(e);if(!(h.length>=O.maximumRequests)&&(!e.throttleByServer||v(e.serverKey))){w(e);var t=d.insert(e);if(i(t)){if(t===e)return;b(t)}return T(e)}},O.clearForSpecs=function(){for(;d.length>0;)b(d.pop());for(var e=h.length,t=0;t<e;++t)b(h[t]);h.length=0,y={},l.numberOfAttemptedRequests=0,l.numberOfActiveRequests=0,l.numberOfCancelledRequests=0,l.numberOfCancelledActiveRequests=0,l.numberOfFailedRequests=0,l.numberOfActiveRequestsEver=0},O.numberOfActiveRequestsByServer=function(e){return y[e]},O.requestHeap=d,O})),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={},i={};return n.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var a=e.toLowerCase()+":"+n;t(i[a])||(i[a]=!0)},n.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var a=e.toLowerCase()+":"+n;t(i[a])&&delete i[a]},n.contains=function(n){if(!t(n))throw new r("url is required.");var a=function(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var a=i.split("@");i=a[1]}if(-1===i.indexOf(":")){var o=n.getScheme();if(t(o)||(o=(o=window.location.protocol).substring(0,o.length-1)),"http"===o)i+=":80";else{if("https"!==o)return;i+=":443"}}return i}}(n);return!(!t(a)||!t(i[a]))},n.clear=function(){i={}},n})),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],(function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y,m,E,O,w,v,T,_,b,g,R,A){"use strict";var S=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();function N(e,t,r,n){var i,a=e.query;if(!u(a)||0===a.length)return{};if(-1===a.indexOf("=")){var o={};o[a]=void 0,i=o}else i=v(a);t._queryParameters=r?x(i,t._queryParameters,n):i,e.query=void 0}function I(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function M(e){if(e.state===g.ISSUED||e.state===g.ACTIVE)throw new R("The Resource is already being fetched.");e.state=g.UNISSUED,e.deferred=void 0}function x(e,t,r){if(!r)return a(e,t);var n=i(e,!0);for(var o in t)if(t.hasOwnProperty(o)){var s=n[o],c=t[o];u(s)?(Array.isArray(s)||(s=n[o]=[s]),n[o]=s.concat(c)):n[o]=Array.isArray(c)?c.slice():c}return n}function C(t){"string"==typeof(t=o(t,o.EMPTY_OBJECT))&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=I(t.templateValues,{}),this._queryParameters=I(t.queryParameters,{}),this.headers=I(t.headers,{}),this.request=o(t.request,new T),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=o(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);N(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function P(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var i=t.defer();return C._Implementations.createImage(r,n,i),i.promise};var n=b.request(r);if(u(n))return n.otherwise((function(n){return r.state!==g.FAILED?t.reject(n):e.retryOnError(n).then((function(i){return i?(r.state=g.UNISSUED,r.deferred=void 0,P(e)):t.reject(n)}))}))}C.createIfNeeded=function(e){return e instanceof C?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new C({url:e})},s(C,{isBlobSupported:{get:function(){return S}}}),s(C.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);N(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return h(this._url)}},isDataUri:{get:function(){return E(this._url)}},isBlobUri:{get:function(){return y(this._url)}},isCrossOriginUrl:{get:function(){return m(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),C.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&function(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=w(r):e.query=n[0]}(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues,o=Object.keys(a);if(o.length>0)for(var s=0;s<o.length;s++){var c=o[s],f=a[c];i=i.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(f))}return r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},C.prototype.setQueryParameters=function(e,t){this._queryParameters=t?x(this._queryParameters,e,!1):x(e,this._queryParameters,!1)},C.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},C.prototype.appendQueryParameters=function(e){this._queryParameters=x(e,this._queryParameters,!0)},C.prototype.setTemplateValues=function(e,t){this._templateValues=t?a(this._templateValues,e):a(e,this._templateValues)},C.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},C.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url);N(n,r,!0,o(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(p(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=a(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=a(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=a(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},C.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then((function(e){return++n._retryCount,e}))},C.prototype.clone=function(e){return u(e)||(e=new C({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},C.prototype.getBaseUri=function(e){return d(this.getUrlComponent(e),e)},C.prototype.appendForwardSlash=function(){this._url=r(this._url)},C.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},C.fetchArrayBuffer=function(e){return new C(e).fetchArrayBuffer()},C.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},C.fetchBlob=function(e){return new C(e).fetchBlob()},C.prototype.fetchImage=function(e){if(e=o(e,!1),M(this.request),!S||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return P(this);var r,n,i=this.fetchBlob();return u(i)?i.then((function(e){if(u(e)){n=e;var t=window.URL.createObjectURL(e);return P(r=new C({url:t}))}})).then((function(e){if(u(e))return window.URL.revokeObjectURL(r.url),e.blob=n,e})).otherwise((function(e){return u(r)&&window.URL.revokeObjectURL(r.url),t.reject(e)})):void 0},C.fetchImage=function(e){return new C(e).fetchImage(e.preferBlob)},C.prototype.fetchText=function(){return this.fetch({responseType:"text"})},C.fetchText=function(e){return new C(e).fetchText()},C.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then((function(e){if(u(e))return JSON.parse(e)}))},C.fetchJson=function(e){return new C(e).fetchJson()},C.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},C.fetchXML=function(e){return new C(e).fetchXML()},C.prototype.fetchJsonp=function(e){var r;e=o(e,"callback"),M(this.request);do{r="loadJsonp"+Math.random().toString().substring(2,8)}while(u(window[r]));return function e(r,n,i){var a={};a[n]=i,r.setQueryParameters(a);var o=r.request;o.url=r.url,o.requestFunction=function(){var e=t.defer();return window[i]=function(t){e.resolve(t);try{delete window[i]}catch(e){window[i]=void 0}},C._Implementations.loadAndExecuteScript(r.url,i,e),e.promise};var s=b.request(o);if(u(s))return s.otherwise((function(a){return o.state!==g.FAILED?t.reject(a):r.retryOnError(a).then((function(u){return u?(o.state=g.UNISSUED,o.deferred=void 0,e(r,n,i)):t.reject(a)}))}))}(this,e,r)},C.fetchJsonp=function(e){return new C(e).fetchJsonp(e.callbackParameterName)},C.prototype._makeRequest=function(e){var r=this;M(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var i=e.responseType,o=a(e.headers,r.headers),s=e.overrideMimeType,c=e.method,f=e.data,l=t.defer(),p=C._Implementations.loadWithXhr(r.url,i,c,f,o,l,s);return u(p)&&u(p.abort)&&(n.cancelFunction=function(){p.abort()}),l.promise};var i=b.request(n);if(u(i))return i.then((function(e){return e})).otherwise((function(i){return n.state!==g.FAILED?t.reject(i):r.retryOnError(i).then((function(a){return a?(n.state=g.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)}))}))};var D=/^data:(.*?)(;base64)?,(.*)$/;function U(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function L(e,t){for(var r=U(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),a=0;a<r.length;a++)i[a]=r.charCodeAt(a);return n}function q(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}C.prototype.fetch=function(e){return(e=I(e,{})).method="GET",this._makeRequest(e)},C.fetch=function(e){return new C(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.delete=function(e){return(e=I(e,{})).method="DELETE",this._makeRequest(e)},C.delete=function(e){return new C(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},C.prototype.head=function(e){return(e=I(e,{})).method="HEAD",this._makeRequest(e)},C.head=function(e){return new C(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.options=function(e){return(e=I(e,{})).method="OPTIONS",this._makeRequest(e)},C.options=function(e){return new C(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.post=function(e,t){return n.defined("data",e),(t=I(t,{})).method="POST",t.data=e,this._makeRequest(t)},C.post=function(e){return new C(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.put=function(e,t){return n.defined("data",e),(t=I(t,{})).method="PUT",t.data=e,this._makeRequest(t)},C.put=function(e){return new C(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C.prototype.patch=function(e,t){return n.defined("data",e),(t=I(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},C.patch=function(e){return new C(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},C._Implementations={},C._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(A.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e};var F="undefined"==typeof XMLHttpRequest;return C._Implementations.loadWithXhr=function(e,t,r,n,i,a,s){var c=D.exec(e);if(null===c){if(!F){var l=new XMLHttpRequest;if(A.contains(e)&&(l.withCredentials=!0),l.open(r,e,!0),u(s)&&u(l.overrideMimeType)&&l.overrideMimeType(s),u(i))for(var p in i)i.hasOwnProperty(p)&&l.setRequestHeader(p,i[p]);u(t)&&(l.responseType=t);var d=!1;return"string"==typeof e&&(d=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),l.onload=function(){if(!(l.status<200||l.status>=300)||d&&0===l.status){var e=l.response,n=l.responseType;if("HEAD"===r||"OPTIONS"===r){var i=l.getAllResponseHeaders().trim().split(/[\r\n]+/),o={};return i.forEach((function(e){var t=e.split(": "),r=t.shift();o[r]=t.join(": ")})),void a.resolve(o)}if(204===l.status)a.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{a.resolve(JSON.parse(e))}catch(e){a.reject(e)}else(""===n||"document"===n)&&u(l.responseXML)&&l.responseXML.hasChildNodes()?a.resolve(l.responseXML):""!==n&&"text"!==n||!u(l.responseText)?a.reject(new R("Invalid XMLHttpRequest response type.")):a.resolve(l.responseText);else a.resolve(e)}else a.reject(new _(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){a.reject(new _)},l.send(n),l}!function(e,t,r,n,i,a,o){var u=require("url").parse(e),s="https:"===u.protocol?require("https"):require("http"),c=require("zlib"),f={protocol:u.protocol,hostname:u.hostname,port:u.port,path:u.path,query:u.query,method:r,headers:i};s.request(f).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)a.reject(new _(e.statusCode,e,e.headers));else{var r=[];e.on("data",(function(e){r.push(e)})),e.on("end",(function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,(function(e,r){e?a.reject(new R("Error decompressing response.")):a.resolve(q(r,t))})):a.resolve(q(n,t))}))}})).on("error",(function(e){a.reject(new _)})).end()}(e,t,r,0,i,a)}else a.resolve(function(e,t){t=o(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return U(n,i);case"arraybuffer":return L(n,i);case"blob":var a=L(n,i);return new Blob([a],{type:r});case"document":return(new DOMParser).parseFromString(U(n,i),r);case"json":return JSON.parse(U(n,i));default:throw new f("Unhandled responseType: "+t)}}(c,t))},C._Implementations.loadAndExecuteScript=function(e,t,r){return O(e,t).otherwise(r.reject)},C._DefaultImplementations={},C._DefaultImplementations.createImage=C._Implementations.createImage,C._DefaultImplementations.loadWithXhr=C._Implementations.loadWithXhr,C._DefaultImplementations.loadAndExecuteScript=C._Implementations.loadAndExecuteScript,C.DEFAULT=l(new C({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),C})),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,a,o,u,s,c,f,l){"use strict";function p(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))h(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),a=this;this._downloadPromise=e(i.fetchJson(),(function(e){h(a,e)}),(function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."}))}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function h(e,r){if(n(r.columnNames))if(n(r.samples)){var i=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),p=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),h=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||a<0||s<0||c<0||p<0||h<0||y<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var m,E=e._samples=r.samples,O=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=p,e._yCelestialPoleOffsetRadiansColumn=h,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var w=e._addNewLeapSeconds,v=0,T=E.length;v<T;v+=e._columnCount){var _=E[v+i],b=E[v+y],g=_+f.MODIFIED_JULIAN_DATE_DIFFERENCE,R=new o(g,b,l.TAI);if(O.push(R),w){if(b!==m&&n(m)){var A=o.leapSeconds,S=t(A,R,d);if(S<0){var N=new u(R,b);A.splice(~S,0,N)}}m=b}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function y(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],f=t[a];if(c.equals(f)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(f))return y(e,r,a,s,u),u;var l=o.secondsDifference(n,c)/o.secondsDifference(f,c),p=i*s,d=a*s,h=r[p+e._ut1MinusUtcSecondsColumn],E=r[d+e._ut1MinusUtcSecondsColumn],O=E-h;if(O>.5||O<-.5){var w=r[p+e._taiMinusUtcSecondsColumn],v=r[d+e._taiMinusUtcSecondsColumn];w!==v&&(f.equals(n)?h=E:E-=v-w)}return u.xPoleWander=m(l,r[p+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(l,r[p+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(l,r[p+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(l,r[p+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(l,h,E),u}return p.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,u=this._lastIndex,s=0,f=0;if(n(u)){var l=a[u],p=a[u+1],d=o.lessThanOrEquals(l,e),h=!n(p),y=h||o.greaterThanOrEquals(p,e);if(d&&y)return s=u,!h&&p.equals(e)&&++s,f=s+1,E(this,a,this._samples,e,s,f,r),r}var m=t(a,e,o.compare,this._dateColumn);return m>=0?(m<a.length-1&&a[m+1].equals(e)&&++m,s=m,f=m):(s=(f=~m)-1)<0&&(s=0),this._lastIndex=s,E(this,a,this._samples,e,s,f,r),r}if(n(this._dataError))throw new c(this._dataError)},p})),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var a=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,o),n.pitch=-Math.asin(a),n},i.fromDegrees=function(e,a,o,u){if(!t(e))throw new r("heading is required");if(!t(a))throw new r("pitch is required");if(!t(o))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=a*n.RADIANS_PER_DEGREE,u.roll=o*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,a){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,a)&&n.equalsEpsilon(e.pitch,r.pitch,i,a)&&n.equalsEpsilon(e.roll,r.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i})),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],(function(e,t,r,n,i){"use strict";var a,o,u,s=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;function c(t){return"undefined"==typeof document?t:(e(a)||(a=document.createElement("a")),a.href=t,a.href=a.href,a.href)}function f(){if(e(o))return o;var a;if(a="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",d("Core/buildModuleUrl.js")):function(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),i=s.exec(n);if(null!==i)return i[1]}}(),!e(a))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return(o=new n({url:c(a)})).appendForwardSlash(),o}function l(e){return c(i.toUrl("../"+e))}function p(e){return f().getDerivedResource({url:e}).url}function d(t){return e(u)||(u=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?l:p),u(t)}return d._cesiumScriptRegex=s,d._buildModuleUrlFromBaseUrl=p,d._clearBaseResource=function(){o=void 0},d.setBaseUrl=function(e){o=n.DEFAULT.getDerivedResource({url:e})},d.getCesiumBaseUrl=f,d})),define("Core/Iau2006XysSample",[],(function(){"use strict";return function(e,t,r){this.x=e,this.y=t,this.s=r}})),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=o.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var f=0;f<=t;++f)f!==c&&(n[c]*=c-f);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}var c=new a(0,0,u.TAI);function f(e,t,r){var n=c;return n.dayNumber=t,n.secondsOfDay=r,a.daysDifference(n,e._sampleZeroDateTT)}function l(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var a,u=e.defer();r._chunkDownloadsInProgress[i]=u;var s=r._xysFileUrlTemplate;return a=n(s)?s.getDerivedResource({templateValues:{0:i}}):new o({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(a.fetchJson(),(function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,a=i*r._samplesPerXysFile*3,o=0,s=n.length;o<s;++o)t[a+o]=n[o];u.resolve()})),u.promise}return s.prototype.preload=function(t,r,n,i){var a=f(this,t,r),o=f(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var c=u/this._samplesPerXysFile|0,p=s/this._samplesPerXysFile|0,d=[],h=c;h<=p;++h)d.push(l(this,h));return e.all(d)},s.prototype.computeXysRadians=function(e,t,r){var a=f(this,e,t);if(!(a<0)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);s<0&&(s=0);var c=s+u;c>=this._totalSamples&&(s=(c=this._totalSamples-1)-u)<0&&(s=0);var p=!1,d=this._samples;if(n(d[3*s])||(l(this,s/this._samplesPerXysFile|0),p=!0),n(d[3*c])||(l(this,c/this._samplesPerXysFile|0),p=!0),!p){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var h,y,m=a-s*this._stepSizeDays,E=this._work,O=this._denominators,w=this._coef,v=this._xTable;for(h=0;h<=u;++h)E[h]=m-v[h];for(h=0;h<=u;++h){for(w[h]=1,y=0;y<=u;++y)y!==h&&(w[h]*=E[y]);w[h]*=O[h];var T=3*(s+h);r.x+=w[h]*d[T++],r.y+=w[h]*d[T++],r.s+=w[h]*d[T]}return r}}}},s})),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],(function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y,m,E,O,w,v){"use strict";var T={},_={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},b={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},g={},R={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},A=new r,S=new r,N=new r;T.localFrameToFixedFrameGenerator=function(e,t){if(!_.hasOwnProperty(e)||!_[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=_[e][t],a=e+t;return u(g[a])?n=g[a]:(n=function(n,a,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var f=m.sign(n.z);r.unpack(b[e],0,A),"east"!==e&&"west"!==e&&r.multiplyByScalar(A,f,A),r.unpack(b[t],0,S),"east"!==t&&"west"!==t&&r.multiplyByScalar(S,f,S),r.unpack(b[i],0,N),"east"!==i&&"west"!==i&&r.multiplyByScalar(N,f,N)}else{(a=o(a,l.WGS84)).geodeticSurfaceNormal(n,R.up);var p=R.up,d=R.east;d.x=-n.y,d.y=n.x,d.z=0,r.normalize(d,R.east),r.cross(p,d,R.north),r.multiplyByScalar(R.up,-1,R.down),r.multiplyByScalar(R.east,-1,R.west),r.multiplyByScalar(R.north,-1,R.south),A=R[e],S=R[t],N=R[i]}return c[0]=A.x,c[1]=A.y,c[2]=A.z,c[3]=0,c[4]=S.x,c[5]=S.y,c[6]=S.z,c[7]=0,c[8]=N.x,c[9]=N.y,c[10]=N.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},g[a]=n),n},T.eastNorthUpToFixedFrame=T.localFrameToFixedFrameGenerator("east","north"),T.northEastDownToFixedFrame=T.localFrameToFixedFrameGenerator("north","east"),T.northUpEastToFixedFrame=T.localFrameToFixedFrameGenerator("north","up"),T.northWestUpToFixedFrame=T.localFrameToFixedFrameGenerator("north","west");var I=new w,M=new r(1,1,1),x=new O;T.headingPitchRollToFixedFrame=function(e,t,n,i,u){a.typeOf.object("HeadingPitchRoll",t),i=o(i,T.eastNorthUpToFixedFrame);var s=w.fromHeadingPitchRoll(t,I),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,M,x);return u=i(e,n,u),O.multiply(u,c,u)};var C=new O,P=new E;T.headingPitchRollQuaternion=function(e,t,r,n,i){a.typeOf.object("HeadingPitchRoll",t);var o=T.headingPitchRollToFixedFrame(e,t,r,n,C),u=O.getRotation(o,P);return w.fromRotationMatrix(u,i)};var D=new r(1,1,1),U=new r,L=new O,q=new O,F=new E,j=new w;T.fixedFrameToHeadingPitchRoll=function(e,t,n,i){a.defined("transform",e),t=o(t,l.WGS84),n=o(n,T.eastNorthUpToFixedFrame),u(i)||(i=new p);var s=O.getTranslation(e,U);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=O.inverseTransformation(n(s,t,L),L),f=O.setScale(e,D,q);f=O.setTranslation(f,r.ZERO,f),c=O.multiply(c,f,c);var d=w.fromRotationMatrix(O.getRotation(c,F),j);return d=w.normalize(d,d),p.fromQuaternion(d,i)};var B=m.TWO_PI/86400,z=new y;T.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");var r,n=(z=y.addSeconds(e,-y.computeTaiMinusUtc(e),z)).dayNumber,i=z.secondsOfDay,a=n-2451545,o=(24110.54841+(r=i>=43200?(a+.5)/v.DAYS_PER_JULIAN_CENTURY:(a-.5)/v.DAYS_PER_JULIAN_CENTURY)*(8640184.812866+r*(.093104+-62e-7*r)))*B%m.TWO_PI+(72921158553e-15+11772758384668e-32*(n-2451545.5))*((i+.5*v.SECONDS_PER_DAY)%v.SECONDS_PER_DAY),c=Math.cos(o),f=Math.sin(o);return u(t)?(t[0]=c,t[1]=-f,t[2]=0,t[3]=f,t[4]=c,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(c,f,0,-f,c,0,0,0,1)},T.iau2006XysData=new d,T.earthOrientationParameters=c.NONE,T.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,i=t.stop.dayNumber,a=t.stop.secondsOfDay+32.184,o=T.iau2006XysData.preload(r,n,i,a),u=T.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},T.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=T.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var G=new h(0,0,0),V=new f(0,0,0,0,0,0),W=new E,X=new E;T.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=T.earthOrientationParameters.compute(e,V);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+32.184,a=T.iau2006XysData.computeXysRadians(n,i,G);if(u(a)){var o=a.x+r.xPoleOffset,c=a.y+r.yPoleOffset,f=1/(1+Math.sqrt(1-o*o-c*c)),l=W;l[0]=1-f*o*o,l[3]=-f*o*c,l[6]=o,l[1]=-f*o*c,l[4]=1-f*c*c,l[7]=c,l[2]=-o,l[5]=-c,l[8]=1-f*(o*o+c*c);var p=E.fromRotationZ(-a.s,X),d=E.multiply(l,p,W),h=e.dayNumber-2451545,O=(e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc)/v.SECONDS_PER_DAY,w=.779057273264+O+.00273781191135448*(h+O);w=w%1*m.TWO_PI;var _=E.fromRotationZ(w,X),b=E.multiply(d,_,W),g=Math.cos(r.xPoleWander),R=Math.cos(r.yPoleWander),A=Math.sin(r.xPoleWander),S=Math.sin(r.yPoleWander),N=n-2451545+i/v.SECONDS_PER_DAY,I=-47e-6*(N/=36525)*m.RADIANS_PER_DEGREE/3600,M=Math.cos(I),x=Math.sin(I),C=X;return C[0]=g*M,C[1]=g*x,C[2]=A,C[3]=-R*x+S*A*M,C[4]=R*M+S*A*x,C[5]=-S*g,C[6]=-S*x-R*A*M,C[7]=S*M-R*A*x,C[8]=R*g,E.multiply(b,C,t)}}};var k=new n;T.pointToWindowCoordinates=function(e,t,r,n){return(n=T.pointToGLWindowCoordinates(e,t,r,n)).y=2*t[5]-n.y,n},T.pointToGLWindowCoordinates=function(e,r,i,a){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(a)||(a=new t);var o=k;return O.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,o),o),n.multiplyByScalar(o,1/o.w,o),O.multiplyByVector(r,o,o),t.fromCartesian4(o,a)};var H=new r,Y=new r,Z=new r;T.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var a=o(n,l.WGS84).geodeticSurfaceNormal(e,H),c=r.cross(t,a,Y);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var f=r.cross(c,t,Z);return r.normalize(f,f),r.cross(t,f,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new E),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=f.x,i[7]=f.y,i[8]=f.z,i};var K=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),J=new i,Q=new r,$=new r,ee=new E,te=new O,re=new O;return T.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=O.getTranslation(t,$),a=e.ellipsoid,o=a.cartesianToCartographic(i,J),c=e.project(o,Q);r.fromElements(c.z,c.x,c.y,c);var f=T.eastNorthUpToFixedFrame(i,a,te),l=O.inverseTransformation(f,re),p=O.getRotation(t,ee),d=O.multiplyByMatrix3(l,p,n);return O.multiply(K,d,n),O.setTranslation(n,c,n),n},T.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,a=T.eastNorthUpToFixedFrame(t,i,te),o=O.inverseTransformation(a,re),c=i.cartesianToCartographic(t,J),f=e.project(c,Q);r.fromElements(f.z,f.x,f.y,f);var l=O.fromTranslation(f,te);return O.multiply(K,o,n),O.multiply(l,n,n),n},T})),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],(function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y){"use strict";function m(e){e=i(e,i.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=i(e.primitiveType,p.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=i(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}m.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&a(e.attributes[r])&&a(e.attributes[r].values)){var i=e.attributes[r],u=i.values.length/i.componentsPerAttribute;if(t!==u&&-1!==t)throw new o("All attribute lists must have the same number of attributes.");t=u}return t};var E=new r,O=new t,w=new l,v=[new r,new r,new r],T=[new e,new e,new e],_=[new e,new e,new e],b=new t,g=new d,R=new l,A=new c;return m._textureCoordinateRotationPoints=function(n,i,a,o){var u,s=h.center(o,E),p=r.toCartesian(s,a,O),m=y.eastNorthUpToFixedFrame(p,a,w),S=l.inverse(m,w),N=T,I=v;I[0].longitude=o.west,I[0].latitude=o.south,I[1].longitude=o.west,I[1].latitude=o.north,I[2].longitude=o.east,I[2].latitude=o.south;var M=b;for(u=0;u<3;u++)r.toCartesian(I[u],a,M),M=l.multiplyByPointAsVector(S,M,M),N[u].x=M.x,N[u].y=M.y;var x=d.fromAxisAngle(t.UNIT_Z,-i,g),C=f.fromQuaternion(x,R),P=n.length,D=Number.POSITIVE_INFINITY,U=Number.POSITIVE_INFINITY,L=Number.NEGATIVE_INFINITY,q=Number.NEGATIVE_INFINITY;for(u=0;u<P;u++)M=l.multiplyByPointAsVector(S,n[u],M),M=f.multiplyByVector(C,M,M),D=Math.min(D,M.x),U=Math.min(U,M.y),L=Math.max(L,M.x),q=Math.max(q,M.y);var F=c.fromRotation(i,A),j=_;j[0].x=D,j[0].y=U,j[1].x=D,j[1].y=q,j[2].x=L,j[2].y=U;var B=N[0],z=N[2].x-B.x,G=N[1].y-B.y;for(u=0;u<3;u++){var V=j[u];c.multiplyByVector(F,V,V),V.x=(V.x-B.x)/z,V.y=(V.y-B.y)/G}var W=j[0],X=j[1],k=j[2],H=new Array(6);return e.pack(W,H),e.pack(X,H,2),e.pack(k,H,4),H},m})),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}})),define("Core/GeometryAttributes",["./defaultValue"],(function(e){"use strict";return function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}})),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./Check","./defined","./DeveloperError","./Math"],(function(e,t,r,n,i,a){"use strict";var o={octEncodeInRange:function(e,n,o){r.defined("vector",e),r.defined("result",o);var u=t.magnitudeSquared(e);if(Math.abs(u-1)>a.EPSILON6)throw new i("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,c=o.y;o.x=(1-Math.abs(c))*a.signNotZero(s),o.y=(1-Math.abs(s))*a.signNotZero(c)}return o.x=a.toSNorm(o.x,n),o.y=a.toSNorm(o.y,n),o},octEncode:function(e,t){return o.octEncodeInRange(e,255,t)}},u=new e,s=new Uint8Array(1);function c(e){return s[0]=e,s[0]}o.octEncodeToCartesian4=function(e,t){return o.octEncodeInRange(e,65535,u),t.x=c(u.x*(1/256)),t.y=c(u.x),t.z=c(u.y*(1/256)),t.w=c(u.y),t},o.octDecodeInRange=function(e,n,o,u){if(r.defined("result",u),e<0||e>o||n<0||n>o)throw new i("x and y must be unsigned normalized integers between 0 and "+o);if(u.x=a.fromSNorm(e,o),u.y=a.fromSNorm(n,o),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*a.signNotZero(s),u.y=(1-Math.abs(s))*a.signNotZero(u.y)}return t.normalize(u,u)},o.octDecode=function(e,t,r){return o.octDecodeInRange(e,t,255,r)},o.octDecodeFromCartesian4=function(e,t){r.typeOf.object("encoded",e),r.typeOf.object("result",t);var n=e.x,a=e.y,u=e.z,s=e.w;if(n<0||n>255||a<0||a>255||u<0||u>255||s<0||s>255)throw new i("x, y, z, and w must be unsigned normalized integers between 0 and 255");var c=256*n+a,f=256*u+s;return o.octDecodeInRange(c,f,65535,t)},o.octPackFloat=function(e){return r.defined("encoded",e),256*e.x+e.y};var f=new e;function l(e){return e>>1^-(1&e)}return o.octEncodeFloat=function(e){return o.octEncode(e,f),o.octPackFloat(f)},o.octDecodeFloat=function(e,t){r.defined("value",e);var n=e/256,i=Math.floor(n),a=256*(n-i);return o.octDecode(i,a,t)},o.octPack=function(e,t,n,i){r.defined("v1",e),r.defined("v2",t),r.defined("v3",n),r.defined("result",i);var a=o.octEncodeFloat(e),u=o.octEncodeFloat(t),s=o.octEncode(n,f);return i.x=65536*s.x+a,i.y=65536*s.y+u,i},o.octUnpack=function(e,t,n,i){r.defined("packed",e),r.defined("v1",t),r.defined("v2",n),r.defined("v3",i);var a=e.x/65536,u=Math.floor(a),s=65536*(a-u);a=e.y/65536;var c=Math.floor(a),f=65536*(a-c);o.octDecodeFloat(s,t),o.octDecodeFloat(f,n),o.octDecode(u,c,i)},o.compressTextureCoordinates=function(e){return r.defined("textureCoordinates",e),4096*(4095*e.x|0)+(4095*e.y|0)},o.decompressTextureCoordinates=function(e,t){r.defined("compressed",e),r.defined("result",t);var n=e/4096,i=Math.floor(n);return t.x=i/4095,t.y=(e-4096*i)/4095,t},o.zigZagDeltaDecode=function(e,t,i){r.defined("uBuffer",e),r.defined("vBuffer",t),r.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,t.length),n(i)&&r.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,i.length);for(var a=e.length,o=0,u=0,s=0,c=0;c<a;++c)o+=l(e[c]),u+=l(t[c]),e[c]=o,t[c]=u,n(i)&&(s+=l(i[c]),i[c]=s)},o})),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./Check","./defined","./Math"],(function(e,t,r,n,i){"use strict";var a=new t,o=new t,u=new t;return function(s,c,f,l,p){var d,h,y,m,E,O,w,v;if(r.defined("point",s),r.defined("p0",c),r.defined("p1",f),r.defined("p2",l),n(p)||(p=new t),n(c.z)){if(t.equalsEpsilon(s,c,i.EPSILON14))return t.clone(t.UNIT_X,p);if(t.equalsEpsilon(s,f,i.EPSILON14))return t.clone(t.UNIT_Y,p);if(t.equalsEpsilon(s,l,i.EPSILON14))return t.clone(t.UNIT_Z,p);d=t.subtract(f,c,a),h=t.subtract(l,c,o),y=t.subtract(s,c,u),m=t.dot(d,d),E=t.dot(d,h),O=t.dot(d,y),w=t.dot(h,h),v=t.dot(h,y)}else{if(e.equalsEpsilon(s,c,i.EPSILON14))return t.clone(t.UNIT_X,p);if(e.equalsEpsilon(s,f,i.EPSILON14))return t.clone(t.UNIT_Y,p);if(e.equalsEpsilon(s,l,i.EPSILON14))return t.clone(t.UNIT_Z,p);d=e.subtract(f,c,a),h=e.subtract(l,c,o),y=e.subtract(s,c,u),m=e.dot(d,d),E=e.dot(d,h),O=e.dot(d,y),w=e.dot(h,h),v=e.dot(h,y)}var T=1/(m*w-E*E);return p.y=(w*O-E*v)*T,p.z=(m*v-E*O)*T,p.x=1-p.y-p.z,p}})),define("Core/EncodedCartesian3",["./Cartesian3","./Check","./defined"],(function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,n){var i;return t.typeOf.number("value",e),r(n)||(n={high:0,low:0}),e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){t.typeOf.object("cartesian",e),r(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,r,i){t.defined("cartesianArray",r),t.typeOf.number("index",i),t.typeOf.number.greaterThanOrEquals("index",i,0),n.fromCartesian(e,a);var o=a.high,u=a.low;r[i]=o.x,r[i+1]=o.y,r[i+2]=o.z,r[i+3]=u.x,r[i+4]=u.y,r[i+5]=u.z},n})),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],(function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT,getSizeInBytes:function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},validate:function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},createTypedArray:function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},createTypedArrayFromArrayBuffer:function(r,i,a,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)}};return r(a)})),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],(function(e,t){"use strict";var r={};function n(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}return r.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");return r*r-4*t*n},r.computeRealRoots=function(r,i,a){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===r)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(r);if(u<s&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if((o=-a/r)<0)return[];var c=Math.sqrt(o);return[-c,c]}if(0===a)return(o=-i/r)<0?[o,0]:[0,o];var f=n(i*i,-4*r*a,t.EPSILON14);if(f<0)return[];var l=-.5*n(i,t.sign(i)*Math.sqrt(f),t.EPSILON14);return i>0?[l/r,a/l]:[a/l,l/r]},r})),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],(function(e,t){"use strict";var r={};function n(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,f=o*s,l=u*c,p=u*u,d=s*s,h=o*s-p,y=o*c-u*s,m=u*c-d,E=4*h*m-y*y;if(E<0){var O,w,v;p*l>=f*d?(O=o,w=h,v=-2*u*h+o*y):(O=c,w=m,v=-c*y+2*s*m);var T=-(v<0?-1:1)*Math.abs(O)*Math.sqrt(-E),_=(a=-v+T)/2,b=_<0?-Math.pow(-_,1/3):Math.pow(_,1/3),g=a===T?-b:-w/b;return i=w<=0?b+g:-v/(b*b+g*g+w),p*l>=f*d?[(i-u)/o]:[-c/(i+s)]}var R=h,A=-2*u*h+o*y,S=m,N=-c*y+2*s*m,I=Math.sqrt(E),M=Math.sqrt(3)/2,x=Math.abs(Math.atan2(o*I,-A)/3);i=2*Math.sqrt(-R);var C=Math.cos(x);a=i*C;var P=i*(-C/2-M*Math.sin(x)),D=a+P>2*u?a-u:P-u,U=o,L=D/U;x=Math.abs(Math.atan2(c*I,-N)/3);var q=-c,F=(a=(i=2*Math.sqrt(-S))*(C=Math.cos(x)))+(P=i*(-C/2-M*Math.sin(x)))<2*s?a+s:P+s,j=q/F,B=-D*F-U*q,z=(s*B-u*(D*q))/(-u*B+s*(U*F));return L<=z?L<=j?z<=j?[L,z,j]:[L,j,z]:[j,L,z]:L<=j?[z,L,j]:z<=j?[z,j,L]:[j,z,L]}return r.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=n*n;return 18*t*r*n*i+a*o-t*t*27*(i*i)-4*(t*o*n+a*r*i)},r.computeRealRoots=function(r,i,a,o){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===r)return t.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];var c=(s=-o/r)<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===o?0===(u=t.computeRealRoots(r,0,a)).Length?[0]:[u[0],0,u[1]]:n(r,0,a,o)}return 0===a?0===o?(s=-i/r)<0?[s,0,0]:[0,0,s]:n(r,i,0,o):0===o?0===(u=t.computeRealRoots(r,i,a)).length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]:n(r,i,a,o)},r})),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],(function(e,t,r,n){"use strict";var i={};function a(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,f=o-a*t/4+i*u/16-3*u*u/256,l=e.computeRealRoots(1,2*s,s*s-4*f,-c*c);if(l.length>0){var p=-t/4,d=l[l.length-1];if(Math.abs(d)<r.EPSILON14){var h=n.computeRealRoots(1,s,f);if(2===h.length){var y,m=h[0],E=h[1];if(m>=0&&E>=0){var O=Math.sqrt(m),w=Math.sqrt(E);return[p-w,p-O,p+O,p+w]}if(m>=0&&E<0)return[p-(y=Math.sqrt(m)),p+y];if(m<0&&E>=0)return[p-(y=Math.sqrt(E)),p+y]}return[]}if(d>0){var v=Math.sqrt(d),T=(s+d-c/v)/2,_=(s+d+c/v)/2,b=n.computeRealRoots(1,v,T),g=n.computeRealRoots(1,-v,_);return 0!==b.length?(b[0]+=p,b[1]+=p,0!==g.length?(g[0]+=p,g[1]+=p,b[1]<=g[0]?[b[0],b[1],g[0],g[1]]:g[1]<=b[0]?[g[0],g[1],b[0],b[1]]:b[0]>=g[0]&&b[1]<=g[1]?[g[0],b[0],b[1],g[1]]:g[0]>=b[0]&&g[1]<=b[1]?[b[0],g[0],g[1],b[1]]:b[0]>g[0]&&b[0]<g[1]?[g[0],b[0],g[1],b[1]]:[b[0],g[0],b[1],g[1]]):b):0!==g.length?(g[0]+=p,g[1]+=p,g):[]}}return[]}function o(t,i,a,o){var u=t*t,s=-2*i,c=a*t+i*i-4*o,f=u*o-a*i*t+a*a,l=e.computeRealRoots(1,s,c,f);if(l.length>0){var p,d,h,y,m,E,O=l[0],w=i-O,v=w*w,T=t/2,_=w/2,b=v-4*o,g=v+4*Math.abs(o),R=u-4*O,A=u+4*Math.abs(O);if(O<0||b*A<R*g){var S=Math.sqrt(R);p=S/2,d=0===S?0:(t*_-a)/S}else{var N=Math.sqrt(b);p=0===N?0:(t*_-a)/N,d=N/2}0===T&&0===p?(h=0,y=0):r.sign(T)===r.sign(p)?y=O/(h=T+p):h=O/(y=T-p),0===_&&0===d?(m=0,E=0):r.sign(_)===r.sign(d)?E=o/(m=_+d):m=o/(E=_-d);var I=n.computeRealRoots(1,h,m),M=n.computeRealRoots(1,y,E);if(0!==I.length)return 0!==M.length?I[1]<=M[0]?[I[0],I[1],M[0],M[1]]:M[1]<=I[0]?[M[0],M[1],I[0],I[1]]:I[0]>=M[0]&&I[1]<=M[1]?[M[0],I[0],I[1],M[1]]:M[0]>=I[0]&&M[1]<=I[1]?[I[0],M[0],M[1],I[1]]:I[0]>M[0]&&I[0]<M[1]?[M[0],I[0],M[1],I[1]]:[I[0],M[0],I[1],M[1]]:I;if(0!==M.length)return M}return[]}return i.computeDiscriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,u=r*r,s=u*r,c=n*n,f=c*n,l=i*i,p=l*i,d=a*a;return u*c*l-4*s*p-4*e*f*l+18*e*r*n*p-27*o*l*l+o*e*256*(d*a)+a*(18*s*n*i-4*u*f+16*e*c*c-80*e*r*c*i-6*e*u*l+144*o*n*l)+d*(144*e*u*n-27*u*u-128*o*c-192*o*r*i)},i.computeRealRoots=function(n,i,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof i)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(i,u,s,c);var f=i/n,l=u/n,p=s/n,d=c/n,h=f<0?1:0;switch(h+=l<0?h+1:h,h+=p<0?h+1:h,h+=d<0?h+1:h){case 0:return a(f,l,p,d);case 1:case 2:return o(f,l,p,d);case 3:case 4:return a(f,l,p,d);case 5:return o(f,l,p,d);case 6:case 7:return a(f,l,p,d);case 8:return o(f,l,p,d);case 9:case 10:return a(f,l,p,d);case 11:return o(f,l,p,d);case 12:case 13:case 14:case 15:return a(f,l,p,d);default:return}},i})),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],(function(e,t,r,n){"use strict";function i(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return i.clone=function(t,r){if(n(t))return n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new i(t.origin,t.direction)},i.getPoint=function(r,i,a){return t.typeOf.object("ray",r),t.typeOf.number("t",i),n(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i})),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],(function(e,t,r,n,i,a,o,u,s,c,f){"use strict";var l={rayPlane:function(t,r,a){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(a)||(a=new e);var u=t.origin,s=t.direction,c=r.normal,f=e.dot(c,s);if(!(Math.abs(f)<o.EPSILON15)){var l=(-r.distance-e.dot(c,u))/f;if(!(l<0))return a=e.multiplyByScalar(s,l,a),e.add(u,a,a)}}},p=new e,d=new e,h=new e,y=new e,m=new e;l.rayTriangleParametric=function(t,a,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var f,l,E,O,w,v=t.origin,T=t.direction,_=e.subtract(u,a,p),b=e.subtract(s,a,d),g=e.cross(T,b,h),R=e.dot(_,g);if(c){if(R<o.EPSILON6)return;if(f=e.subtract(v,a,y),(E=e.dot(f,g))<0||E>R)return;if(l=e.cross(f,_,m),(O=e.dot(T,l))<0||E+O>R)return;w=e.dot(b,l)/R}else{if(Math.abs(R)<o.EPSILON6)return;var A=1/R;if(f=e.subtract(v,a,y),(E=e.dot(f,g)*A)<0||E>1)return;if(l=e.cross(f,_,m),(O=e.dot(T,l)*A)<0||E+O>1)return;w=e.dot(b,l)*A}return w},l.rayTriangle=function(t,r,i,a,o,u){var s=l.rayTriangleParametric(t,r,i,a,o);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var E=new f;l.lineSegmentTriangle=function(t,r,a,o,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(a))throw new i("p0 is required.");if(!n(o))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var f=E;e.clone(t,f.origin),e.subtract(r,t,f.direction),e.normalize(f.direction,f.direction);var p=l.rayTriangleParametric(f,a,o,u,s);if(!(!n(p)||p<0||p>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(f.direction,p,c),e.add(f.origin,c,c)};var O={root0:0,root1:0};function w(t,r,i){n(i)||(i=new a);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,f=e.subtract(o,s,h),l=function(e,t,r,n){var i=t*t-4*e*r;if(!(i<0)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}(e.dot(u,u),2*e.dot(u,f),e.magnitudeSquared(f)-c,O);if(n(l))return i.start=l.root0,i.stop=l.root1,i}l.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");if(r=w(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var v=new f;l.lineSegmentSphere=function(t,r,a,o){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=v;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);if(e.normalize(s,s),o=w(u,a,o),!(!n(o)||o.stop<0||o.start>c))return o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,c),o};var T=new e,_=new e;function b(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}l.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o,u,s,c,f,l=r.oneOverRadii,p=e.multiplyComponents(l,t.origin,T),d=e.multiplyComponents(l,t.direction,_),h=e.magnitudeSquared(p),y=e.dot(p,d);if(h>1){if(y>=0)return;var m=y*y;if(o=h-1,m<(s=(u=e.magnitudeSquared(d))*o))return;if(m>s){c=y*y-s;var E=(f=-y+Math.sqrt(c))/u,O=o/f;return E<O?new a(E,O):{start:O,stop:E}}var w=Math.sqrt(o/u);return new a(w,w)}return h<1?(o=h-1,c=y*y-(s=(u=e.magnitudeSquared(d))*o),f=-y+Math.sqrt(c),new a(0,f/u)):y<0?(u=e.magnitudeSquared(d),new a(0,-y/u)):void 0};var g=new e,R=new e,A=new e,S=new e,N=new e,I=new u,M=new u,x=new u,C=new u,P=new u,D=new u,U=new u,L=new e,q=new e,F=new t;l.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a=t.origin,f=t.direction;if(!e.equals(a,e.ZERO)){var l=r.geodeticSurfaceNormal(a,g);if(e.dot(f,l)>=0)return a}var p=n(this.rayEllipsoid(t,r)),d=r.transformPositionToScaledSpace(f,g),h=e.normalize(d,d),y=e.mostOrthogonalAxis(d,S),m=e.normalize(e.cross(y,h,R),R),E=e.normalize(e.cross(h,m,A),A),O=I;O[0]=h.x,O[1]=h.y,O[2]=h.z,O[3]=m.x,O[4]=m.y,O[5]=m.z,O[6]=E.x,O[7]=E.y,O[8]=E.z;var w=u.transpose(O,M),v=u.fromScale(r.radii,x),T=u.fromScale(r.oneOverRadii,C),_=P;_[0]=0,_[1]=-f.z,_[2]=f.y,_[3]=f.z,_[4]=0,_[5]=-f.x,_[6]=-f.y,_[7]=f.x,_[8]=0;var j,B,z=u.multiply(u.multiply(w,T,D),_,D),G=u.multiply(u.multiply(z,v,U),O,U),V=u.multiplyByVector(z,a,N),W=function(t,r,n,i,a){var f,l=i*i,p=a*a,d=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*p,h=a*(i*b(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),y=t[u.COLUMN0ROW0]*l+t[u.COLUMN2ROW2]*p+i*r.x+n,m=p*b(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),E=a*(i*b(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),O=[];if(0===E&&0===m){if(0===(f=s.computeRealRoots(d,h,y)).length)return O;var w=f[0],v=Math.sqrt(Math.max(1-w*w,0));if(O.push(new e(i,a*w,a*-v)),O.push(new e(i,a*w,a*v)),2===f.length){var T=f[1],_=Math.sqrt(Math.max(1-T*T,0));O.push(new e(i,a*T,a*-_)),O.push(new e(i,a*T,a*_))}return O}var g=E*E,R=m*m,A=E*m,S=d*d+R,N=2*(h*d+A),I=2*y*d+h*h-R+g,M=2*(y*h-A),x=y*y-g;if(0===S&&0===N&&0===I&&0===M)return O;var C=(f=c.computeRealRoots(S,N,I,M,x)).length;if(0===C)return O;for(var P=0;P<C;++P){var D=f[P],U=D*D,L=Math.max(1-U,0),q=Math.sqrt(L),F=(o.sign(d)===o.sign(y)?b(d*U+y,h*D,o.EPSILON12):o.sign(y)===o.sign(h*D)?b(d*U,h*D+y,o.EPSILON12):b(d*U+h*D,y,o.EPSILON12))*b(m*D,E,o.EPSILON15);F<0?O.push(new e(i,a*D,a*q)):F>0?O.push(new e(i,a*D,a*-q)):0!==q?(O.push(new e(i,a*D,a*-q)),O.push(new e(i,a*D,a*q)),++P):O.push(new e(i,a*D,a*q))}return O}(G,e.negate(V,g),0,0,1),X=W.length;if(X>0){for(var k=e.clone(e.ZERO,q),H=Number.NEGATIVE_INFINITY,Y=0;Y<X;++Y){j=u.multiplyByVector(v,u.multiplyByVector(O,W[Y],L),L);var Z=e.normalize(e.subtract(j,a,S),S),K=e.dot(Z,f);K>H&&(H=K,k=e.clone(j,k))}var J=r.cartesianToCartographic(k,F);return H=o.clamp(H,0,1),B=e.magnitude(e.subtract(k,a,S))*Math.sqrt(1-H*H),B=p?-B:B,J.height=B,r.cartographicToCartesian(J,new e)}};var j=new e;return l.lineSegmentPlane=function(t,r,a,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,j),c=a.normal,f=e.dot(c,s);if(!(Math.abs(f)<o.EPSILON6)){var l=e.dot(c,t),p=-(a.distance+l)/f;if(!(p<0||p>1))return e.multiplyByScalar(s,p,u),e.add(t,u,u),u}},l.trianglePlaneIntersection=function(t,r,a,o){if(!(n(t)&&n(r)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u,s,c=o.normal,f=o.distance,p=e.dot(c,t)+f<0,d=e.dot(c,r)+f<0,h=e.dot(c,a)+f<0,y=0;if(y+=p?1:0,y+=d?1:0,1!==(y+=h?1:0)&&2!==y||(u=new e,s=new e),1===y){if(p)return l.lineSegmentPlane(t,r,o,u),l.lineSegmentPlane(t,a,o,s),{positions:[t,r,a,u,s],indices:[0,3,4,1,2,4,1,4,3]};if(d)return l.lineSegmentPlane(r,a,o,u),l.lineSegmentPlane(r,t,o,s),{positions:[t,r,a,u,s],indices:[1,3,4,2,0,4,2,4,3]};if(h)return l.lineSegmentPlane(a,t,o,u),l.lineSegmentPlane(a,r,o,s),{positions:[t,r,a,u,s],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===y){if(!p)return l.lineSegmentPlane(r,t,o,u),l.lineSegmentPlane(a,t,o,s),{positions:[t,r,a,u,s],indices:[1,2,4,1,4,3,0,3,4]};if(!d)return l.lineSegmentPlane(a,r,o,u),l.lineSegmentPlane(t,r,o,s),{positions:[t,r,a,u,s],indices:[2,0,4,2,4,3,1,3,4]};if(!h)return l.lineSegmentPlane(t,a,o,u),l.lineSegmentPlane(r,a,o,s),{positions:[t,r,a,u,s],indices:[0,1,4,0,4,3,2,3,4]}}},l})),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],(function(e,t,r,n,i,a,o){"use strict";function u(r,i){if(t.typeOf.object("normal",r),!a.equalsEpsilon(e.magnitude(r),1,a.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",i),this.normal=e.clone(r),this.distance=i}u.fromPointNormal=function(i,o,s){if(t.typeOf.object("point",i),t.typeOf.object("normal",o),!a.equalsEpsilon(e.magnitude(o),1,a.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(o,i);return r(s)?(e.clone(o,s.normal),s.distance=c,s):new u(o,c)};var s=new e;u.fromCartesian4=function(i,o){t.typeOf.object("coefficients",i);var c=e.fromCartesian4(i,s),f=i.w;if(!a.equalsEpsilon(e.magnitude(c),1,a.EPSILON6))throw new n("normal must be normalized.");return r(o)?(e.clone(c,o.normal),o.distance=f,o):new u(c,f)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,i,a){t.typeOf.object("plane",n),t.typeOf.object("point",i),r(a)||(a=new e);var o=u.getPointDistance(n,i),s=e.multiplyByScalar(n.normal,o,c);return e.subtract(i,s,a)};var f=new e;return u.transform=function(r,n,i){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),o.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,f),o.multiplyByPoint(n,f,f),u.fromPointNormal(f,s,i)},u.clone=function(n,i){return t.typeOf.object("plane",n),r(i)?(e.clone(n.normal,i.normal),i.distance=n.distance,i):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=i(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=i(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=i(new u(e.UNIT_Y,0)),u})),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={calculateACMR:function(n){var i=(n=e(n,e.EMPTY_OBJECT)).indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var u=i.length;if(u<3||u%3!=0)throw new r("indices length must be a multiple of three.");if(a<=0)throw new r("maximumIndex must be greater than zero.");if(o<3)throw new r("cacheSize must be greater than two.");if(!t(a)){a=0;for(var s=0,c=i[s];s<u;)c>a&&(a=c),c=i[++s]}for(var f=[],l=0;l<a+1;l++)f[l]=0;for(var p=o+1,d=0;d<u;++d)p-f[i[d]]>o&&(f[i[d]]=p,++p);return(p-o+1)/(u/3)},tipsify:function(n){var i,a=(n=e(n,e.EMPTY_OBJECT)).indices,o=n.maximumIndex,u=e(n.cacheSize,24);function s(e,t,r,n,a,o,u){for(var s,c=-1,f=-1,l=0;l<r.length;){var p=r[l];n[p].numLiveTriangles&&(s=0,a-n[p].timeStamp+2*n[p].numLiveTriangles<=t&&(s=a-n[p].timeStamp),(s>f||-1===f)&&(f=s,c=p)),++l}return-1===c?function(e,t,r,n){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;i<n;){if(e[i].numLiveTriangles>0)return++i-1;++i}return-1}(n,o,0,u):c}if(!t(a))throw new r("indices is required.");var c=a.length;if(c<3||c%3!=0)throw new r("indices length must be a multiple of three.");if(o<=0)throw new r("maximumIndex must be greater than zero.");if(u<3)throw new r("cacheSize must be greater than two.");var f=0,l=0,p=a[l],d=c;if(t(o))f=o+1;else{for(;l<d;)p>f&&(f=p),p=a[++l];if(-1===f)return 0;++f}var h,y=[];for(h=0;h<f;h++)y[h]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};l=0;for(var m=0;l<d;)y[a[l]].vertexTriangles.push(m),++y[a[l]].numLiveTriangles,y[a[l+1]].vertexTriangles.push(m),++y[a[l+1]].numLiveTriangles,y[a[l+2]].vertexTriangles.push(m),++y[a[l+2]].numLiveTriangles,++m,l+=3;var E=0,O=u+1;i=1;var w,v,T,_,b=[],g=[],R=0,A=[],S=c/3,N=[];for(h=0;h<S;h++)N[h]=!1;for(;-1!==E;){b=[],_=(v=y[E]).vertexTriangles.length;for(var I=0;I<_;++I)if(!N[m=v.vertexTriangles[I]]){N[m]=!0,l=m+m+m;for(var M=0;M<3;++M)T=a[l],b.push(T),g.push(T),A[R]=T,++R,--(w=y[T]).numLiveTriangles,O-w.timeStamp>u&&(w.timeStamp=O,++O),++l}E=s(0,u,b,y,O,g,f)}return A}};return n})),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],(function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y,m,E,O,w,v,T,_,b,g){"use strict";var R={};function A(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function S(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new h({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function N(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var i=t[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[r*i.componentsPerAttribute+a])}R.toWireframe=function(e){if(!c(e))throw new f("geometry is required.");var t=e.indices;if(c(t)){switch(e.primitiveType){case b.TRIANGLES:e.indices=function(e){for(var t=e.length,r=t/3*6,n=m.createTypedArray(t,r),i=0,a=0;a<t;a+=3,i+=6)A(n,i,e[a],e[a+1],e[a+2]);return n}(t);break;case b.TRIANGLE_STRIP:e.indices=function(e){var t=e.length;if(t>=3){var r=6*(t-2),n=m.createTypedArray(t,r);A(n,0,e[0],e[1],e[2]);for(var i=6,a=3;a<t;++a,i+=6)A(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}(t);break;case b.TRIANGLE_FAN:e.indices=function(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=m.createTypedArray(t,r),i=e[0],a=0,o=1;o<t;++o,a+=6)A(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}(t);break;default:throw new f("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=b.LINES}return e},R.createLineSegmentsForVectors=function(e,t,n){if(t=s(t,"normal"),!c(e))throw new f("geometry is required.");if(!c(e.attributes.position))throw new f("geometry.attributes.position is required.");if(!c(e.attributes[t]))throw new f("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=s(n,1e4);for(var i,a=e.attributes.position.values,o=e.attributes[t].values,l=a.length,p=new Float64Array(2*l),y=0,m=0;m<l;m+=3)p[y++]=a[m],p[y++]=a[m+1],p[y++]=a[m+2],p[y++]=a[m]+o[m]*n,p[y++]=a[m+1]+o[m+1]*n,p[y++]=a[m+2]+o[m+2]*n;var E=e.boundingSphere;return c(E)&&(i=new r(E.center,E.radius+n)),new d({attributes:{position:new h({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:p})},primitiveType:b.LINES,boundingSphere:i})},R.createAttributeLocations=function(e){if(!c(e))throw new f("geometry is required.");var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={},a=0,o=r.length;for(t=0;t<o;++t){var u=r[t];c(n[u])&&(i[u]=a++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=a++);return i},R.reorderForPreVertexCache=function(e){if(!c(e))throw new f("geometry is required.");var t=d.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),i=0;i<t;i++)n[i]=-1;for(var a,o=r,s=o.length,l=m.createTypedArray(t,s),p=0,h=0,y=0;p<s;)-1!==(a=n[o[p]])?l[h]=a:(n[a=o[p]]=y,l[h]=y,++y),++p,++h;e.indices=l;var E=e.attributes;for(var O in E)if(E.hasOwnProperty(O)&&c(E[O])&&c(E[O].values)){for(var w=E[O],v=w.values,T=0,_=w.componentsPerAttribute,b=u.createTypedArray(w.componentDatatype,y*_);T<t;){var g=n[T];if(-1!==g)for(var R=0;R<_;R++)b[_*g+R]=v[_*T+R];++T}w.values=b}}return e},R.reorderForPostVertexCache=function(e,t){if(!c(e))throw new f("geometry is required.");var r=e.indices;if(e.primitiveType===b.TRIANGLES&&c(r)){for(var n=r.length,i=0,a=0;a<n;a++)r[a]>i&&(i=r[a]);e.indices=g.tipsify({indices:r,maximumIndex:i,cacheSize:t})}return e},R.fitToUnsignedShortIndices=function(e){if(!c(e))throw new f("geometry is required.");if(c(e.indices)&&e.primitiveType!==b.TRIANGLES&&e.primitiveType!==b.LINES&&e.primitiveType!==b.POINTS)throw new f("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],r=d.computeNumberOfVertices(e);if(c(e.indices)&&r>=w.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=S(e.attributes),s=e.indices,l=s.length;e.primitiveType===b.TRIANGLES?n=3:e.primitiveType===b.LINES?n=2:e.primitiveType===b.POINTS&&(n=1);for(var p=0;p<l;p+=n){for(var h=0;h<n;++h){var y=s[p+h],m=i[y];c(m)||(m=o++,i[y]=m,N(u,e.attributes,y)),a.push(m)}o+n>=w.SIXTY_FOUR_KILOBYTES&&(t.push(new d({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=S(e.attributes))}0!==a.length&&t.push(new d({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var I=new i,M=new o;R.projectTo2D=function(e,t,r,n,a){if(!c(e))throw new f("geometry is required.");if(!c(t))throw new f("attributeName is required.");if(!c(r))throw new f("attributeName3D is required.");if(!c(n))throw new f("attributeName2D is required.");if(!c(e.attributes[t]))throw new f("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var o=e.attributes[t],s=(a=c(a)?a:new p).ellipsoid,l=o.values,d=new Float64Array(l.length),y=0,m=0;m<l.length;m+=3){var E=i.fromArray(l,m,I),O=s.cartesianToCartographic(E,M);if(!c(O))throw new f("Could not project point ("+E.x+", "+E.y+", "+E.z+") to 2D.");var w=a.project(O,I);d[y++]=w.x,d[y++]=w.y,d[y++]=w.z}return e.attributes[r]=o,e.attributes[n]=new h({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[t],e};var x={high:0,low:0};R.encodeAttribute=function(e,t,r,n){if(!c(e))throw new f("geometry is required.");if(!c(t))throw new f("attributeName is required.");if(!c(r))throw new f("attributeHighName is required.");if(!c(n))throw new f("attributeLowName is required.");if(!c(e.attributes[t]))throw new f("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[t],a=i.values,o=a.length,s=new Float32Array(o),p=new Float32Array(o),d=0;d<o;++d)l.encode(a[d],x),s[d]=x.high,p[d]=x.low;var y=i.componentsPerAttribute;return e.attributes[r]=new h({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:s}),e.attributes[n]=new h({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:p}),delete e.attributes[t],e};var C=new i;function P(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,C),T.multiplyByPoint(e,C,C),i.pack(C,r,a)}function D(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,C),v.multiplyByVector(e,C,C),C=i.normalize(C,C),i.pack(C,r,a)}var U=new T,L=new v;R.transformToWorldCoordinates=function(e){if(!c(e))throw new f("instance is required.");var t=e.modelMatrix;if(T.equals(t,T.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(c(n.normal)||c(n.tangent)||c(n.bitangent))&&(T.inverse(t,U),T.transpose(U,U),T.getRotation(U,L),D(L,n.normal),D(L,n.tangent),D(L,n.bitangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=T.clone(T.IDENTITY),e};var q=new i;function F(e,t){var n,a,o,s,l=e.length,p=e[0].modelMatrix,y=c(e[0][t].indices),E=e[0][t].primitiveType;for(a=1;a<l;++a){if(!T.equals(e[a].modelMatrix,p))throw new f("All instances must have the same modelMatrix.");if(c(e[a][t].indices)!==y)throw new f("All instance geometries must have an indices or not have one.");if(e[a][t].primitiveType!==E)throw new f("All instance geometries must have the same primitiveType.")}var O,w,v,_,g=function(e,t){var r,n=e.length,i={},a=e[0][t].attributes;for(r in a)if(a.hasOwnProperty(r)&&c(a[r])&&c(a[r].values)){for(var o=a[r],s=o.values.length,f=!0,l=1;l<n;++l){var p=e[l][t].attributes[r];if(!c(p)||o.componentDatatype!==p.componentDatatype||o.componentsPerAttribute!==p.componentsPerAttribute||o.normalize!==p.normalize){f=!1;break}s+=p.values.length}f&&(i[r]=new h({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}(e,t);for(n in g)if(g.hasOwnProperty(n))for(O=g[n].values,s=0,a=0;a<l;++a)for(v=(w=e[a][t].attributes[n].values).length,o=0;o<v;++o)O[s++]=w[o];if(y){var R=0;for(a=0;a<l;++a)R+=e[a][t].indices.length;var A=d.computeNumberOfVertices(new d({attributes:g,primitiveType:b.POINTS})),S=m.createTypedArray(A,R),N=0,I=0;for(a=0;a<l;++a){var M=e[a][t].indices,x=M.length;for(s=0;s<x;++s)S[N++]=I+M[s];I+=d.computeNumberOfVertices(e[a][t])}_=S}var C,P=new i,D=0;for(a=0;a<l;++a){if(C=e[a][t].boundingSphere,!c(C)){P=void 0;break}i.add(C.center,P,P)}if(c(P))for(i.divideByScalar(P,l,P),a=0;a<l;++a){C=e[a][t].boundingSphere;var U=i.magnitude(i.subtract(C.center,P,q))+C.radius;U>D&&(D=U)}return new d({attributes:g,indices:_,primitiveType:E,boundingSphere:c(P)?new r(P,D):void 0})}R.combineInstances=function(e){if(!c(e)||e.length<1)throw new f("instances is required and must have length greater than zero.");for(var t=[],r=[],n=e.length,i=0;i<n;++i){var a=e[i];c(a.geometry)?t.push(a):c(a.westHemisphereGeometry)&&c(a.eastHemisphereGeometry)&&r.push(a)}var o=[];return t.length>0&&o.push(F(t,"geometry")),r.length>0&&(o.push(F(r,"westHemisphereGeometry")),o.push(F(r,"eastHemisphereGeometry"))),o};var j=new i,B=new i,z=new i,G=new i;R.computeNormal=function(e){if(!c(e))throw new f("geometry is required.");if(!c(e.attributes.position)||!c(e.attributes.position.values))throw new f("geometry.attributes.position.values is required.");if(!c(e.indices))throw new f("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!=0)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var t,r=e.indices,n=e.attributes,a=n.position.values,o=n.position.values.length/3,s=r.length,l=new Array(o),p=new Array(s/3),d=new Array(s);for(t=0;t<o;t++)l[t]={indexOffset:0,count:0,currentCount:0};var y=0;for(t=0;t<s;t+=3){var m=r[t],E=r[t+1],O=r[t+2],v=3*m,T=3*E,_=3*O;B.x=a[v],B.y=a[v+1],B.z=a[v+2],z.x=a[T],z.y=a[T+1],z.z=a[T+2],G.x=a[_],G.y=a[_+1],G.z=a[_+2],l[m].count++,l[E].count++,l[O].count++,i.subtract(z,B,z),i.subtract(G,B,G),p[y]=i.cross(z,G,new i),y++}var g,R=0;for(t=0;t<o;t++)l[t].indexOffset+=R,R+=l[t].count;for(y=0,t=0;t<s;t+=3){var A=(g=l[r[t]]).indexOffset+g.currentCount;d[A]=y,g.currentCount++,d[A=(g=l[r[t+1]]).indexOffset+g.currentCount]=y,g.currentCount++,d[A=(g=l[r[t+2]]).indexOffset+g.currentCount]=y,g.currentCount++,y++}var S=new Float32Array(3*o);for(t=0;t<o;t++){var N=3*t;if(g=l[t],i.clone(i.ZERO,j),g.count>0){for(y=0;y<g.count;y++)i.add(j,p[d[g.indexOffset+y]],j);i.equalsEpsilon(i.ZERO,j,w.EPSILON10)&&i.clone(p[d[g.indexOffset]],j)}i.equalsEpsilon(i.ZERO,j,w.EPSILON10)&&(j.z=1),i.normalize(j,j),S[N]=j.x,S[N+1]=j.y,S[N+2]=j.z}return e.attributes.normal=new h({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var V=new i,W=new i,X=new i;R.computeTangentAndBitangent=function(e){if(!c(e))throw new f("geometry is required.");var t=e.attributes,r=e.indices;if(!c(t.position)||!c(t.position.values))throw new f("geometry.attributes.position.values is required.");if(!c(t.normal)||!c(t.normal.values))throw new f("geometry.attributes.normal.values is required.");if(!c(t.st)||!c(t.st.values))throw new f("geometry.attributes.st.values is required.");if(!c(r))throw new f("geometry.indices is required.");if(r.length<2||r.length%3!=0)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var n,a,o,s,l=e.attributes.position.values,p=e.attributes.normal.values,d=e.attributes.st.values,y=e.attributes.position.values.length/3,m=r.length,E=new Array(3*y);for(n=0;n<E.length;n++)E[n]=0;for(n=0;n<m;n+=3){var O=r[n],w=r[n+1],v=r[n+2];o=3*w,s=3*v;var T=2*O,_=2*w,g=2*v,R=l[a=3*O],A=l[a+1],S=l[a+2],N=d[T],I=d[T+1],M=d[_+1]-I,x=d[g+1]-I,C=1/((d[_]-N)*x-(d[g]-N)*M),P=(x*(l[o]-R)-M*(l[s]-R))*C,D=(x*(l[o+1]-A)-M*(l[s+1]-A))*C,U=(x*(l[o+2]-S)-M*(l[s+2]-S))*C;E[a]+=P,E[a+1]+=D,E[a+2]+=U,E[o]+=P,E[o+1]+=D,E[o+2]+=U,E[s]+=P,E[s+1]+=D,E[s+2]+=U}var L=new Float32Array(3*y),q=new Float32Array(3*y);for(n=0;n<y;n++){o=1+(a=3*n),s=a+2;var F=i.fromArray(p,a,V),j=i.fromArray(E,a,X),B=i.dot(F,j);i.multiplyByScalar(F,B,W),i.normalize(i.subtract(j,W,j),j),L[a]=j.x,L[o]=j.y,L[s]=j.z,i.normalize(i.cross(F,j,j),j),q[a]=j.x,q[o]=j.y,q[s]=j.z}return e.attributes.tangent=new h({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e.attributes.bitangent=new h({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:q}),e};var k=new n,H=new i,Y=new i,Z=new i,K=new n;function J(e){switch(e.primitiveType){case b.TRIANGLE_FAN:return function(e){var t=d.computeNumberOfVertices(e);if(t<3)throw new f("The number of vertices must be at least three.");var r=m.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,i=3;i<t;++i)r[n++]=i-1,r[n++]=0,r[n++]=i;return e.indices=r,e.primitiveType=b.TRIANGLES,e}(e);case b.TRIANGLE_STRIP:return function(e){var t=d.computeNumberOfVertices(e);if(t<3)throw new f("The number of vertices must be at least 3.");var r=m.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,i=3;i<t-1;i+=2)r[n++]=i,r[n++]=i-1,r[n++]=i+1,i+2<t&&(r[n++]=i,r[n++]=i+1,r[n++]=i+2);return e.indices=r,e.primitiveType=b.TRIANGLES,e}(e);case b.TRIANGLES:return function(e){if(c(e.indices))return e;var t=d.computeNumberOfVertices(e);if(t<3)throw new f("The number of vertices must be at least three.");if(t%3!=0)throw new f("The number of vertices must be a multiple of three.");for(var r=m.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}(e);case b.LINE_STRIP:return function(e){var t=d.computeNumberOfVertices(e);if(t<2)throw new f("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return e.indices=r,e.primitiveType=b.LINES,e}(e);case b.LINE_LOOP:return function(e){var t=d.computeNumberOfVertices(e);if(t<2)throw new f("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=b.LINES,e}(e);case b.LINES:return function(e){if(c(e.indices))return e;var t=d.computeNumberOfVertices(e);if(t<2)throw new f("The number of vertices must be at least two.");if(t%2!=0)throw new f("The number of vertices must be a multiple of 2.");for(var r=m.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}(e)}return e}function Q(e,t){Math.abs(e.y)<w.EPSILON6&&(e.y=t?-w.EPSILON6:w.EPSILON6)}R.compressVertices=function(t){if(!c(t))throw new f("geometry is required.");var r,a,o=t.attributes.extrudeDirection;if(c(o)){var s=o.values;a=s.length/3;var l=new Float32Array(2*a),p=0;for(r=0;r<a;++r)i.fromArray(s,3*r,H),i.equals(H,i.ZERO)?p+=2:(K=e.octEncodeInRange(H,65535,K),l[p++]=K.x,l[p++]=K.y);return t.attributes.compressedAttributes=new h({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:l}),delete t.attributes.extrudeDirection,t}var d=t.attributes.normal,y=t.attributes.st,m=c(d),E=c(y);if(!m&&!E)return t;var O,w,v,T,_=t.attributes.tangent,b=t.attributes.bitangent,g=c(_),R=c(b);m&&(O=d.values),E&&(w=y.values),g&&(v=_.values),R&&(T=b.values);var A=a=(m?O.length:w.length)/(m?3:2),S=E&&m?2:1;S+=g||R?1:0;var N=new Float32Array(A*=S),I=0;for(r=0;r<a;++r){E&&(n.fromArray(w,2*r,k),N[I++]=e.compressTextureCoordinates(k));var M=3*r;m&&c(v)&&c(T)?(i.fromArray(O,M,H),i.fromArray(v,M,Y),i.fromArray(T,M,Z),e.octPack(H,Y,Z,k),N[I++]=k.x,N[I++]=k.y):(m&&(i.fromArray(O,M,H),N[I++]=e.octEncodeFloat(H)),g&&(i.fromArray(v,M,H),N[I++]=e.octEncodeFloat(H)),R&&(i.fromArray(T,M,H),N[I++]=e.octEncodeFloat(H)))}return t.attributes.compressedAttributes=new h({componentDatatype:u.FLOAT,componentsPerAttribute:S,values:N}),m&&delete t.attributes.normal,E&&delete t.attributes.st,R&&delete t.attributes.bitangent,g&&delete t.attributes.tangent,t};var $=new i;function ee(e,t,r,n){i.add(e,i.multiplyByScalar(i.subtract(t,e,$),e.y/(e.y-t.y),$),r),i.clone(r,n),Q(r,!0),Q(n,!1)}var te=new i,re=new i,ne=new i,ie=new i,ae={positions:new Array(7),indices:new Array(9)};function oe(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){!function(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return Q(e,e.y<0),Q(t,t.y<0),void Q(r,r.y<0);var n=Math.abs(e.y),i=Math.abs(t.y),a=Math.abs(r.y),o=(n>i?n>a?w.sign(e.y):w.sign(r.y):i>a?w.sign(t.y):w.sign(r.y))<0;Q(e,o),Q(t,o),Q(r,o)}(e,t,r);var n=e.y<0,i=t.y<0,a=r.y<0,o=0;o+=n?1:0,o+=i?1:0;var u=ae.indices;1===(o+=a?1:0)?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(ee(e,t,te,ne),ee(e,r,re,ie),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(ee(t,r,te,ne),ee(t,e,re,ie),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(ee(r,e,te,ne),ee(r,t,re,ie),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(ee(r,e,te,ne),ee(r,t,re,ie),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(ee(t,r,te,ne),ee(t,e,re,ie),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(ee(e,t,te,ne),ee(e,r,re,ie),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=ae.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,1!==o&&2!==o||(s[3]=te,s[4]=re,s[5]=ne,s[6]=ie,s.length=7),ae}}function ue(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var a=n[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=d.computeNumberOfVertices(e);return e.indices=m.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function se(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var i=t[n];r[n]=new h({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new d({attributes:r,indices:[],primitiveType:e.primitiveType})}function ce(e,t,r){var n=c(e.geometry.boundingSphere);t=ue(t,n),r=ue(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function fe(e,t){var r=new e,n=new e,i=new e;return function(a,o,u,s,c,f,l,p){var d=e.fromArray(c,a*t,r),h=e.fromArray(c,o*t,n),y=e.fromArray(c,u*t,i);e.multiplyByScalar(d,s.x,d),e.multiplyByScalar(h,s.y,h),e.multiplyByScalar(y,s.z,y);var m=e.add(d,h,d);e.add(m,y,m),p&&e.normalize(m,m),e.pack(m,f,l*t)}}var le=fe(a,4),pe=fe(i,3),de=fe(n,2),he=new i,ye=new i,me=new i,Ee=new i;function Oe(e,r,n,a,o,u,s,f,l,p,d,h,y,m,E,O){if(c(u)||c(s)||c(f)||c(l)||c(p)||0!==m){var v=i.fromArray(o,3*e,he),T=i.fromArray(o,3*r,ye),_=i.fromArray(o,3*n,me),b=t(a,v,T,_,Ee);if(c(u)&&pe(e,r,n,b,u,h.normal.values,O,!0),c(p)){var g,R=i.fromArray(p,3*e,he),A=i.fromArray(p,3*r,ye),S=i.fromArray(p,3*n,me);i.multiplyByScalar(R,b.x,R),i.multiplyByScalar(A,b.y,A),i.multiplyByScalar(S,b.z,S),i.equals(R,i.ZERO)&&i.equals(A,i.ZERO)&&i.equals(S,i.ZERO)?((g=he).x=0,g.y=0,g.z=0):(g=i.add(R,A,R),i.add(g,S,g),i.normalize(g,g)),i.pack(g,h.extrudeDirection.values,3*O)}if(c(d)&&function(e,t,r,n,i,a,o){var u=i[e]*n.x,s=i[t]*n.y,c=i[r]*n.z;a[o]=u+s+c>w.EPSILON6?1:0}(e,r,n,b,d,h.applyOffset.values,O),c(s)&&pe(e,r,n,b,s,h.tangent.values,O,!0),c(f)&&pe(e,r,n,b,f,h.bitangent.values,O,!0),c(l)&&de(e,r,n,b,l,h.st.values,O),m>0)for(var N=0;N<m;N++){var I=y[N];we(e,r,n,b,O,E[I],h[I])}}}function we(e,t,r,n,i,a,o){var u=a.componentsPerAttribute,s=a.values,c=o.values;switch(u){case 4:le(e,t,r,n,s,c,i,!1);break;case 3:pe(e,t,r,n,s,c,i,!1);break;case 2:de(e,t,r,n,s,c,i,!1);break;default:c[i]=s[e]*n.x+s[t]*n.y+s[r]*n.z}}function ve(e,t,r,n,i,a){var o=e.position.values.length/3;if(-1!==i){var u=n[i],s=r[u];return-1===s?(r[u]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}var Te={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};function _e(e){var t=e.geometry,r=t.attributes,n=r.position.values,a=c(r.normal)?r.normal.values:void 0,o=c(r.bitangent)?r.bitangent.values:void 0,u=c(r.tangent)?r.tangent.values:void 0,s=c(r.st)?r.st.values:void 0,f=c(r.extrudeDirection)?r.extrudeDirection.values:void 0,l=c(r.applyOffset)?r.applyOffset.values:void 0,p=t.indices,d=[];for(var h in r)r.hasOwnProperty(h)&&!Te[h]&&c(r[h])&&d.push(h);var y,m,E,O,w=d.length,v=se(t),T=se(t),_=[];_.length=n.length/3;var b=[];for(b.length=n.length/3,O=0;O<_.length;++O)_[O]=-1,b[O]=-1;var g=p.length;for(O=0;O<g;O+=3){var R=p[O],A=p[O+1],S=p[O+2],N=i.fromArray(n,3*R),I=i.fromArray(n,3*A),M=i.fromArray(n,3*S),x=oe(N,I,M);if(c(x)&&x.positions.length>3)for(var C=x.positions,P=x.indices,D=P.length,U=0;U<D;++U){var L=P[U],q=C[L];q.y<0?(y=T.attributes,m=T.indices,E=_):(y=v.attributes,m=v.indices,E=b),Oe(R,A,S,q,n,a,u,o,s,f,l,y,d,w,r,ve(y,m,E,p,L<3?O+L:-1,q))}else c(x)&&(N=x.positions[0],I=x.positions[1],M=x.positions[2]),N.y<0?(y=T.attributes,m=T.indices,E=_):(y=v.attributes,m=v.indices,E=b),Oe(R,A,S,N,n,a,u,o,s,f,l,y,d,w,r,ve(y,m,E,p,O,N)),Oe(R,A,S,I,n,a,u,o,s,f,l,y,d,w,r,ve(y,m,E,p,O+1,I)),Oe(R,A,S,M,n,a,u,o,s,f,l,y,d,w,r,ve(y,m,E,p,O+2,M))}ce(e,T,v)}var be=_.fromPointNormal(i.ZERO,i.UNIT_Y),ge=new i,Re=new i;function Ae(e,t,r,n,a,o,u){if(c(u)){var s=i.fromArray(n,3*e,he);i.equalsEpsilon(s,r,w.EPSILON10)?o.applyOffset.values[a]=u[e]:o.applyOffset.values[a]=u[t]}}function Se(e){var t,r=e.geometry,n=r.attributes,a=n.position.values,o=c(n.applyOffset)?n.applyOffset.values:void 0,u=r.indices,s=se(r),f=se(r),l=u.length,p=[];p.length=a.length/3;var d=[];for(d.length=a.length/3,t=0;t<p.length;++t)p[t]=-1,d[t]=-1;for(t=0;t<l;t+=2){var h=u[t],y=u[t+1],m=i.fromArray(a,3*h,he),E=i.fromArray(a,3*y,ye);Math.abs(m.y)<w.EPSILON6&&(m.y<0?m.y=-w.EPSILON6:m.y=w.EPSILON6),Math.abs(E.y)<w.EPSILON6&&(E.y<0?E.y=-w.EPSILON6:E.y=w.EPSILON6);var v=s.attributes,T=s.indices,_=d,b=f.attributes,g=f.indices,R=p,A=O.lineSegmentPlane(m,E,be,me);if(c(A)){var S=i.multiplyByScalar(i.UNIT_Y,5*w.EPSILON9,ge);m.y<0&&(i.negate(S,S),v=f.attributes,T=f.indices,_=p,b=s.attributes,g=s.indices,R=d);var N=i.add(A,S,Re);Ae(h,y,m,a,ve(v,T,_,u,t,m),v,o),Ae(h,y,N,a,ve(v,T,_,u,-1,N),v,o),i.negate(S,S),i.add(A,S,N),Ae(h,y,N,a,ve(b,g,R,u,-1,N),b,o),Ae(h,y,E,a,ve(b,g,R,u,t+1,E),b,o)}else{var I,M,x;m.y<0?(I=f.attributes,M=f.indices,x=p):(I=s.attributes,M=s.indices,x=d),Ae(h,y,m,a,ve(I,M,x,u,t,m),I,o),Ae(h,y,E,a,ve(I,M,x,u,t+1,E),I,o)}}ce(e,f,s)}var Ne=new n,Ie=new n,Me=new i,xe=new i,Ce=new i,Pe=new i,De=new i,Ue=new i,Le=new a;function qe(e){for(var t=e.attributes,r=t.position.values,n=t.prevPosition.values,a=t.nextPosition.values,o=r.length,u=0;u<o;u+=3){var s=i.unpack(r,u,Me);if(!(s.x>0)){var c=i.unpack(n,u,xe);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(n[u]=r[u-3],n[u+1]=r[u-2],n[u+2]=r[u-1]):i.pack(s,n,u));var f=i.unpack(a,u,Ce);(s.y<0&&f.y>0||s.y>0&&f.y<0)&&(u+3<o?(a[u]=r[u+3],a[u+1]=r[u+4],a[u+2]=r[u+5]):i.pack(s,a,u))}}}var Fe=5*w.EPSILON9,je=w.EPSILON6;return R.splitLongitude=function(e){if(!c(e))throw new f("instance is required.");var t=e.geometry,o=t.boundingSphere;if(c(o)&&(o.center.x-o.radius>0||r.intersectPlane(o,_.ORIGIN_ZX_PLANE)!==E.INTERSECTING))return e;if(t.geometryType!==y.NONE)switch(t.geometryType){case y.POLYLINES:!function(e){var t,r,o,u=e.geometry,s=u.attributes,f=s.position.values,l=s.prevPosition.values,p=s.nextPosition.values,d=s.expandAndWidth.values,h=c(s.st)?s.st.values:void 0,y=c(s.color)?s.color.values:void 0,m=se(u),E=se(u),v=!1,T=f.length/3;for(t=0;t<T;t+=4){var _=t,b=t+2,g=i.fromArray(f,3*_,Me),R=i.fromArray(f,3*b,xe);if(Math.abs(g.y)<je)for(g.y=je*(R.y<0?-1:1),f[3*t+1]=g.y,f[3*(t+1)+1]=g.y,r=3*_;r<3*_+12;r+=3)l[r]=f[3*t],l[r+1]=f[3*t+1],l[r+2]=f[3*t+2];if(Math.abs(R.y)<je)for(R.y=je*(g.y<0?-1:1),f[3*(t+2)+1]=R.y,f[3*(t+3)+1]=R.y,r=3*_;r<3*_+12;r+=3)p[r]=f[3*(t+2)],p[r+1]=f[3*(t+2)+1],p[r+2]=f[3*(t+2)+2];var A=m.attributes,S=m.indices,N=E.attributes,I=E.indices,M=O.lineSegmentPlane(g,R,be,Pe);if(c(M)){v=!0;var x=i.multiplyByScalar(i.UNIT_Y,Fe,De);g.y<0&&(i.negate(x,x),A=E.attributes,S=E.indices,N=m.attributes,I=m.indices);var C=i.add(M,x,Ue);A.position.values.push(g.x,g.y,g.z,g.x,g.y,g.z),A.position.values.push(C.x,C.y,C.z),A.position.values.push(C.x,C.y,C.z),A.prevPosition.values.push(l[3*_],l[3*_+1],l[3*_+2]),A.prevPosition.values.push(l[3*_+3],l[3*_+4],l[3*_+5]),A.prevPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),i.negate(x,x),i.add(M,x,C),N.position.values.push(C.x,C.y,C.z),N.position.values.push(C.x,C.y,C.z),N.position.values.push(R.x,R.y,R.z,R.x,R.y,R.z),N.prevPosition.values.push(C.x,C.y,C.z),N.prevPosition.values.push(C.x,C.y,C.z),N.prevPosition.values.push(C.x,C.y,C.z),N.prevPosition.values.push(C.x,C.y,C.z),N.nextPosition.values.push(R.x,R.y,R.z,R.x,R.y,R.z),N.nextPosition.values.push(p[3*b],p[3*b+1],p[3*b+2]),N.nextPosition.values.push(p[3*b+3],p[3*b+4],p[3*b+5]);var P=n.fromArray(d,2*_,Ne),D=Math.abs(P.y);A.expandAndWidth.values.push(-1,D,1,D),A.expandAndWidth.values.push(-1,-D,1,-D),N.expandAndWidth.values.push(-1,D,1,D),N.expandAndWidth.values.push(-1,-D,1,-D);var U=i.magnitudeSquared(i.subtract(M,g,Ce));if(U/=i.magnitudeSquared(i.subtract(R,g,Ce)),c(y)){var L=a.fromArray(y,4*_,Le),q=a.fromArray(y,4*b,Le),F=w.lerp(L.x,q.x,U),j=w.lerp(L.y,q.y,U),B=w.lerp(L.z,q.z,U),z=w.lerp(L.w,q.w,U);for(r=4*_;r<4*_+8;++r)A.color.values.push(y[r]);for(A.color.values.push(F,j,B,z),A.color.values.push(F,j,B,z),N.color.values.push(F,j,B,z),N.color.values.push(F,j,B,z),r=4*b;r<4*b+8;++r)N.color.values.push(y[r])}if(c(h)){var G=n.fromArray(h,2*_,Ne),V=n.fromArray(h,2*(t+3),Ie),W=w.lerp(G.x,V.x,U);for(r=2*_;r<2*_+4;++r)A.st.values.push(h[r]);for(A.st.values.push(W,G.y),A.st.values.push(W,V.y),N.st.values.push(W,G.y),N.st.values.push(W,V.y),r=2*b;r<2*b+4;++r)N.st.values.push(h[r])}o=A.position.values.length/3-4,S.push(o,o+2,o+1),S.push(o+1,o+2,o+3),o=N.position.values.length/3-4,I.push(o,o+2,o+1),I.push(o+1,o+2,o+3)}else{var X,k;for(g.y<0?(X=E.attributes,k=E.indices):(X=m.attributes,k=m.indices),X.position.values.push(g.x,g.y,g.z),X.position.values.push(g.x,g.y,g.z),X.position.values.push(R.x,R.y,R.z),X.position.values.push(R.x,R.y,R.z),r=3*t;r<3*t+12;++r)X.prevPosition.values.push(l[r]),X.nextPosition.values.push(p[r]);for(r=2*t;r<2*t+8;++r)X.expandAndWidth.values.push(d[r]),c(h)&&X.st.values.push(h[r]);if(c(y))for(r=4*t;r<4*t+16;++r)X.color.values.push(y[r]);o=X.position.values.length/3-4,k.push(o,o+2,o+1),k.push(o+1,o+2,o+3)}}v&&(qe(E),qe(m)),ce(e,E,m)}(e);break;case y.TRIANGLES:_e(e);break;case y.LINES:Se(e)}else J(t),t.primitiveType===b.TRIANGLES?_e(e):t.primitiveType===b.LINES&&Se(e);return e},R})),define("Core/OffsetGeometryInstanceAttribute",["./Check","./ComponentDatatype","./defaultValue","./defined","./defineProperties"],(function(e,t,r,n,i){"use strict";function a(e,t,n){e=r(e,0),t=r(t,0),n=r(n,0),this.value=new Float32Array([e,t,n])}return i(a.prototype,{componentDatatype:{get:function(){return t.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}}),a.fromCartesian3=function(t){return e.defined("offset",t),new a(t.x,t.y,t.z)},a.toValue=function(t,r){return e.defined("offset",t),n(r)||(r=new Float32Array([t.x,t.y,t.z])),r[0]=t.x,r[1]=t.y,r[2]=t.z,r},a})),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.mercatorAngleToGeodeticLatitude=function(e){return u.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},s.geodeticLatitudeToMercatorAngle=function(e){e>s.MaximumLatitude?e=s.MaximumLatitude:e<-s.MaximumLatitude&&(e=-s.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},s.MaximumLatitude=s.mercatorAngleToGeodeticLatitude(Math.PI),s.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=s.geodeticLatitudeToMercatorAngle(t.latitude)*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},s.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=s.mercatorAngleToGeodeticLatitude(e.y*i),c=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=c,r):new t(o,u,c)},s})),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/OffsetGeometryInstanceAttribute","../Core/WebMercatorProjection"],(function(e,t,r,n,i,a,o,u,s,c,f,l,p,d,h,y){"use strict";if(!o.supportsTypedArrays())return{};function m(e,r){var n=e.attributes,i=n.position,a=i.values.length/i.componentsPerAttribute;n.batchId=new c({componentDatatype:t.FLOAT,componentsPerAttribute:1,values:new Float32Array(a)});for(var o=n.batchId.values,u=0;u<a;++u)o[u]=r}function E(r){var a,o,u,s=r.instances,c=r.projection,f=r.elementIndexUintSupported,p=r.scene3DOnly,h=r.vertexCacheOptimize,y=r.compressVertices,E=r.modelMatrix,O=s.length;for(a=0;a<O;++a)if(n(s[a].geometry)){u=s[a].geometry.primitiveType;break}for(a=1;a<O;++a)if(n(s[a].geometry)&&s[a].geometry.primitiveType!==u)throw new i("All instance geometries must have the same primitiveType.");if(function(e,t,r){var i,a=!r,o=e.length;if(!a&&o>1){var u=e[0].modelMatrix;for(i=1;i<o;++i)if(!d.equals(u,e[i].modelMatrix)){a=!0;break}}if(a)for(i=0;i<o;++i)n(e[i].geometry)&&l.transformToWorldCoordinates(e[i]);else d.multiplyTransformation(t,e[0].modelMatrix,t)}(s,E,p),!p)for(a=0;a<O;++a)n(s[a].geometry)&&l.splitLongitude(s[a]);if(function(e){for(var t=e.length,r=0;r<t;++r){var i=e[r];n(i.geometry)?m(i.geometry,r):n(i.westHemisphereGeometry)&&n(i.eastHemisphereGeometry)&&(m(i.westHemisphereGeometry,r),m(i.eastHemisphereGeometry,r))}}(s),h)for(a=0;a<O;++a){var w=s[a];n(w.geometry)?(l.reorderForPostVertexCache(w.geometry),l.reorderForPreVertexCache(w.geometry)):n(w.westHemisphereGeometry)&&n(w.eastHemisphereGeometry)&&(l.reorderForPostVertexCache(w.westHemisphereGeometry),l.reorderForPreVertexCache(w.westHemisphereGeometry),l.reorderForPostVertexCache(w.eastHemisphereGeometry),l.reorderForPreVertexCache(w.eastHemisphereGeometry))}var v=l.combineInstances(s);for(O=v.length,a=0;a<O;++a){var T,_=(o=v[a]).attributes;if(p)for(T in _)_.hasOwnProperty(T)&&_[T].componentDatatype===t.DOUBLE&&l.encodeAttribute(o,T,T+"3DHigh",T+"3DLow");else for(T in _)if(_.hasOwnProperty(T)&&_[T].componentDatatype===t.DOUBLE){var b=T+"3D",g=T+"2D";l.projectTo2D(o,T,b,g,c),n(o.boundingSphere)&&"position"===T&&(o.boundingSphereCV=e.fromVertices(o.attributes.position2D.values)),l.encodeAttribute(o,b,b+"High",b+"Low"),l.encodeAttribute(o,g,g+"High",g+"Low")}y&&l.compressVertices(o)}if(!f){var R=[];for(O=v.length,a=0;a<O;++a)o=v[a],R=R.concat(l.fitToUnsignedShortIndices(o));v=R}return v}function O(e,t,r,i){var a,o,u,s=i.length-1;if(s>=0){var c=i[s];a=c.offset+c.count,o=r[u=c.index].indices.length}else a=0,o=r[u=0].indices.length;for(var f=e.length,l=0;l<f;++l){var p=e[l][t];if(n(p)){var d=p.indices.length;a+d>o&&(a=0,o=r[++u].indices.length),i.push({index:u,offset:a,count:d}),a+=d}}}var w={};function v(e,t){var r=e.attributes;for(var i in r)if(r.hasOwnProperty(i)){var a=r[i];n(a)&&n(a.values)&&t.push(a.values.buffer)}n(e.indices)&&t.push(e.indices.buffer)}function T(e,t){var r=e.length,i=new Float64Array(1+19*r),a=0;i[a++]=r;for(var o=0;o<r;o++){var u=e[o];if(d.pack(u.modelMatrix,i,a),a+=d.packedLength,n(u.attributes)&&n(u.attributes.offset)){var s=u.attributes.offset.value;i[a]=s[0],i[a+1]=s[1],i[a+2]=s[2]}a+=3}return t.push(i.buffer),i}function _(t){var r=t.length,i=1+(e.packedLength+1)*r,a=new Float32Array(i),o=0;a[o++]=r;for(var u=0;u<r;++u){var s=t[u];n(s)?(a[o++]=1,e.pack(t[u],a,o)):a[o++]=0,o+=e.packedLength}return a}function b(t){for(var r=new Array(t[0]),n=0,i=1;i<t.length;)1===t[i++]&&(r[n]=e.unpack(t,i)),++n,i+=e.packedLength;return r}return w.combineGeometry=function(t){var r,i,a,o,u=t.instances,s=u.length,c=!1;s>0&&((r=E(t)).length>0&&(i=l.createAttributeLocations(r[0]),t.createPickOffsets&&(a=function(e,t){var r=[];return O(e,"geometry",t,r),O(e,"westHemisphereGeometry",t,r),O(e,"eastHemisphereGeometry",t,r),r}(u,r))),n(u[0].attributes)&&n(u[0].attributes.offset)&&(o=new Array(s),c=!0));for(var f=new Array(s),p=new Array(s),d=0;d<s;++d){var h=u[d],y=h.geometry;n(y)&&(f[d]=y.boundingSphere,p[d]=y.boundingSphereCV,c&&(o[d]=h.geometry.offsetAttribute));var m=h.eastHemisphereGeometry,w=h.westHemisphereGeometry;n(m)&&n(w)&&(n(m.boundingSphere)&&n(w.boundingSphere)&&(f[d]=e.union(m.boundingSphere,w.boundingSphere)),n(m.boundingSphereCV)&&n(w.boundingSphereCV)&&(p[d]=e.union(m.boundingSphereCV,w.boundingSphereCV)))}return{geometries:r,modelMatrix:t.modelMatrix,attributeLocations:i,pickOffsets:a,offsetInstanceExtend:o,boundingSpheres:f,boundingSpheresCV:p}},w.packCreateGeometryResults=function(t,i){var a=new Float64Array(function(t){for(var r=1,i=t.length,a=0;a<i;a++){var o=t[a];if(++r,n(o)){var u=o.attributes;for(var s in r+=7+2*e.packedLength+(n(o.indices)?o.indices.length:0),u)u.hasOwnProperty(s)&&n(u[s])&&(r+=5+u[s].values.length)}}return r}(t)),o=[],u={},s=t.length,c=0;a[c++]=s;for(var f=0;f<s;f++){var l=t[f],p=n(l);if(a[c++]=p?1:0,p){a[c++]=l.primitiveType,a[c++]=l.geometryType,a[c++]=r(l.offsetAttribute,-1);var d=n(l.boundingSphere)?1:0;a[c++]=d,d&&e.pack(l.boundingSphere,a,c),c+=e.packedLength;var h=n(l.boundingSphereCV)?1:0;a[c++]=h,h&&e.pack(l.boundingSphereCV,a,c),c+=e.packedLength;var y=l.attributes,m=[];for(var E in y)y.hasOwnProperty(E)&&n(y[E])&&(m.push(E),n(u[E])||(u[E]=o.length,o.push(E)));a[c++]=m.length;for(var O=0;O<m.length;O++){var w=m[O],v=y[w];a[c++]=u[w],a[c++]=v.componentDatatype,a[c++]=v.componentsPerAttribute,a[c++]=v.normalize?1:0,a[c++]=v.values.length,a.set(v.values,c),c+=v.values.length}var T=n(l.indices)?l.indices.length:0;a[c++]=T,T>0&&(a.set(l.indices,c),c+=T)}}return i.push(a.buffer),{stringTable:o,packedData:a}},w.unpackCreateGeometryResults=function(r){for(var n,i=r.stringTable,a=r.packedData,o=new Array(a[0]),u=0,l=1;l<a.length;)if(1===a[l++]){var d,h,y,m,E,O=a[l++],w=a[l++],v=a[l++];-1===v&&(v=void 0),1===a[l++]&&(d=e.unpack(a,l)),l+=e.packedLength,1===a[l++]&&(h=e.unpack(a,l)),l+=e.packedLength;var T,_=new f,b=a[l++];for(n=0;n<b;n++){var g=i[a[l++]],R=a[l++];E=a[l++];var A=0!==a[l++];y=a[l++],m=t.createTypedArray(R,y);for(var S=0;S<y;S++)m[S]=a[l++];_[g]=new c({componentDatatype:R,componentsPerAttribute:E,normalize:A,values:m})}if((y=a[l++])>0){var N=m.length/E;for(T=p.createTypedArray(N,y),n=0;n<y;n++)T[n]=a[l++]}o[u++]=new s({primitiveType:O,geometryType:w,boundingSphere:d,boundingSphereCV:h,indices:T,attributes:_,offsetAttribute:v})}else o[u++]=void 0;return o},w.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,n=r.length,i=0;i<n;i++)t.push(r[i].packedData.buffer);return{createGeometryResults:e.createGeometryResults,packedInstances:T(e.instances,t),ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof u,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix,createPickOffsets:e.createPickOffsets}},w.unpackCombineGeometryParameters=function(e){for(var t=function(e){for(var t=e,r=new Array(t[0]),i=0,a=1;a<t.length;){var o,u=d.unpack(t,a);a+=d.packedLength,n(t[a])&&(o={offset:new h(t[a],t[a+1],t[a+2])}),a+=3,r[i++]={modelMatrix:u,attributes:o}}return r}(e.packedInstances),r=e.createGeometryResults,i=r.length,o=0,s=0;s<i;s++)for(var c=w.unpackCreateGeometryResults(r[s]),f=c.length,l=0;l<f;l++){var p=c[l];t[o].geometry=p,++o}var m=a.clone(e.ellipsoid);return{instances:t,ellipsoid:m,projection:e.isGeographic?new u(m):new y(m),elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:d.clone(e.modelMatrix),createPickOffsets:e.createPickOffsets}},w.packCombineGeometryResults=function(e,t){n(e.geometries)&&function(e,t){for(var r=e.length,n=0;n<r;++n)v(e[n],t)}(e.geometries,t);var r=_(e.boundingSpheres),i=_(e.boundingSpheresCV);return t.push(r.buffer,i.buffer),{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,offsetInstanceExtend:e.offsetInstanceExtend,boundingSpheres:r,boundingSpheresCV:i}},w.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,offsetInstanceExtend:e.offsetInstanceExtend,boundingSpheres:b(e.boundingSpheres),boundingSpheresCV:b(e.boundingSpheresCV)}},w})),define("Core/formatError",["./defined"],(function(e){"use strict";return function(t){var r,n=t.name,i=t.message;r=e(n)&&e(i)?n+": "+i:t.toString();var a=t.stack;return e(a)&&(r+="\n"+a),r}})),define("Workers/createTaskProcessorWorker",["../ThirdParty/when","../Core/defaultValue","../Core/defined","../Core/formatError"],(function(e,t,r,n){"use strict";return function(i){var a;return function(o){var u=o.data,s=[],c={id:u.id,result:void 0,error:void 0};return e(function(t,r,n){try{return t(r,n)}catch(t){return e.reject(t)}}(i,u.parameters,s)).then((function(e){c.result=e})).otherwise((function(e){e instanceof Error?c.error={name:e.name,message:e.message,stack:e.stack}:c.error=e})).always((function(){r(a)||(a=t(self.webkitPostMessage,self.postMessage)),u.canTransferArrayBuffer||(s.length=0);try{a(c,s)}catch(e){c.result=void 0,c.error="postMessage failed with error: "+n(e)+"\n  with responseMessage: "+JSON.stringify(c),a(c)}}))}}})),define("Workers/createGeometry",["../Core/defined","../Scene/PrimitivePipeline","../ThirdParty/when","./createTaskProcessorWorker","require"],(function(e,t,r,n,i){"use strict";var a={};function o(t){var r=a[t];return e(r)||("object"==typeof exports?a[r]=r=i("Workers/"+t):i(["./"+t],(function(e){a[r=e]=e}))),r}return n((function(n,i){for(var a=n.subTasks,u=a.length,s=new Array(u),c=0;c<u;c++){var f=a[c],l=f.geometry,p=f.moduleName;if(e(p)){var d=o(p);s[c]=d(l,f.offset)}else s[c]=l}return r.all(s,(function(e){return t.packCreateGeometryResults(e,i)}))}))}));