define("Core/defined",[],(function(){"use strict";return function(e){return null!=e}})),define("Core/DeveloperError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="DeveloperError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t})),
/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
define("ThirdParty/Uri",[],(function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var n=t.exec(r);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var t=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(i,o).replace(r,a)),this.path&&(this.path=this.path.replace(r,a)),this.query&&(this.query=this.query.replace(r,a)),this.fragment&&(this.fragment=this.fragment.replace(r,a))};var r=/%[0-9a-z]{2}/gi,n=/[a-zA-Z0-9\-\._~]/,i=/(.*@)?([^@:]*)(:.*)?/;function a(e){var t=unescape(e);return n.test(t)?t:e.toUpperCase()}function o(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];for(n&&t.shift(),""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e})),define("Core/freezeObject",["./defined"],(function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t})),define("Core/defaultValue",["./freezeObject"],(function(e){"use strict";function t(e,t){return null!=e?e:t}return t.EMPTY_OBJECT=e({}),t})),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n){"use strict";function i(e,t){var r;return"undefined"!=typeof document&&(r=document),i._implementation(e,t,r)}return i._implementation=function(i,a,o){if(!r(i))throw new n("relative uri is required.");if(!r(a)){if(void 0===o)return i;a=t(o.baseURI,o.location.href)}var u=new e(a);return new e(i).resolve(u).toString()},i})),
/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */
function(e){"use strict";e("ThirdParty/when",[],(function(){var e,t;function r(e,t,r,i){return n(e).then(t,r,i)}function n(e){var t,r,s;return e instanceof i?t=e:u(e)?(r=o(),e.then((function(e){r.resolve(e)}),(function(e){r.reject(e)}),(function(e){r.progress(e)})),t=r.promise):(s=e,t=new i((function(e){try{return n(e?e(s):s)}catch(e){return a(e)}}))),t}function i(e){this.then=e}function a(e){return new i((function(t,r){try{return r?n(r(e)):a(e)}catch(e){return a(e)}}))}function o(){var e,t,r,u,s,c;return e=new i(l),t=[],r=[],u=function(e,n,i){var a,u;return a=o(),u="function"==typeof i?function(e){try{a.progress(i(e))}catch(e){a.progress(e)}}:function(e){a.progress(e)},t.push((function(t){t.then(e,n).then(a.resolve,a.reject,u)})),r.push(u),a.promise},s=function(e){return f(r,e),e},c=function(e){return e=n(e),u=e.then,c=n,s=d,f(t,e),r=t=void 0,e},{then:l,resolve:h,reject:p,progress:y,promise:e,resolver:{resolve:h,reject:p,progress:y}};function l(e,t,r){return u(e,t,r)}function h(e){return c(e)}function p(e){return c(a(e))}function y(e){return s(e)}}function u(e){return e&&"function"==typeof e.then}function s(e,t,n,i,a){return h(2,arguments),r(e,(function(e){var u,s,c,l,f,h,p,y,m,E;if(m=e.length>>>0,u=Math.max(0,Math.min(t,m)),c=[],s=m-u+1,l=[],f=o(),u)for(y=f.progress,p=function(e){l.push(e),--s||(h=p=d,f.reject(l))},h=function(e){c.push(e),--u||(h=p=d,f.resolve(c))},E=0;E<m;++E)E in e&&r(e[E],_,O,y);else f.resolve(c);return f.then(n,i,a);function O(e){p(e)}function _(e){h(e)}}))}function c(e,t,r,n){return h(1,arguments),l(e,p).then(t,r,n)}function l(e,t){return r(e,(function(e){var n,i,a,u,s,c;if(a=i=e.length>>>0,n=[],c=o(),a)for(u=function(e,i){r(e,t).then((function(e){n[i]=e,--a||c.resolve(n)}),c.reject)},s=0;s<i;s++)s in e?u(e[s],s):--a;else c.resolve(n);return c.promise}))}function f(e,t){for(var r,n=0;r=e[n++];)r(t)}function h(e,t){for(var r,n=t.length;n>e;)if(null!=(r=t[--n])&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function d(){}function p(e){return e}return r.defer=o,r.resolve=n,r.reject=function(e){return r(e,a)},r.join=function(){return l(arguments,p)},r.all=c,r.map=l,r.reduce=function(n,i){var a=t.call(arguments,1);return r(n,(function(t){var n;return n=t.length,a[0]=function(e,t,a){return r(e,(function(e){return r(t,(function(t){return i(e,t,a,n)}))}))},e.apply(t,a)}))},r.any=function(e,t,r,n){return s(e,1,(function(e){return t?t(e[0]):e[0]}),r,n)},r.some=s,r.chain=function(e,t,n){var i=arguments.length>2;return r(e,(function(e){return e=i?n:e,t.resolve(e),e}),(function(e){return t.reject(e),a(e)}),t.progress)},r.isPromise=u,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(void 0,e)},yield:function(e){return this.then((function(){return e}))},spread:function(e){return this.then((function(t){return c(t,(function(t){return e.apply(void 0,t)}))}))}},t=[].slice,e=[].reduce||function(e){var t,r,n,i,a;if(a=0,i=(t=Object(this)).length>>>0,(r=arguments).length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;a<i;++a)a in t&&(n=e(n,t[a],a,t));return n},r}))}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/appendForwardSlash",[],(function(){"use strict";return function(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}})),define("Core/Check",["./defined","./DeveloperError"],(function(e,t){"use strict";var r={};function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}return r.typeOf={},r.defined=function(r,n){if(!e(n))throw new t(function(e){return e+" is required, actual value was undefined"}(r))},r.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},r.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},r.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},r.typeOf.number.lessThan=function(e,n,i){if(r.typeOf.number(e,n),n>=i)throw new t("Expected "+e+" to be less than "+i+", actual value was "+n)},r.typeOf.number.lessThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n>i)throw new t("Expected "+e+" to be less than or equal to "+i+", actual value was "+n)},r.typeOf.number.greaterThan=function(e,n,i){if(r.typeOf.number(e,n),n<=i)throw new t("Expected "+e+" to be greater than "+i+", actual value was "+n)},r.typeOf.number.greaterThanOrEquals=function(e,n,i){if(r.typeOf.number(e,n),n<i)throw new t("Expected "+e+" to be greater than or equal to"+i+", actual value was "+n)},r.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},r.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},r.typeOf.number.equals=function(e,n,i,a){if(r.typeOf.number(e,i),r.typeOf.number(n,a),i!==a)throw new t(e+" must be equal to "+n+", the actual values are "+i+" and "+a)},r})),define("Core/clone",["./defaultValue"],(function(e){"use strict";return function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i}})),define("Core/combine",["./defaultValue","./defined"],(function(e,t){"use strict";return function r(n,i,a){a=e(a,!1);var o,u,s,c={},l=t(n),f=t(i);if(l)for(o in n)n.hasOwnProperty(o)&&(u=n[o],f&&a&&"object"==typeof u&&i.hasOwnProperty(o)?(s=i[o],c[o]="object"==typeof s?r(u,s,a):u):c[o]=u);if(f)for(o in i)i.hasOwnProperty(o)&&!c.hasOwnProperty(o)&&(s=i[o],c[o]=s);return c}})),define("Core/defineProperties",["./defined"],(function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r})),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={};function i(i,a){if(!t(i))throw new r("identifier is required.");t(n[i])||(n[i]=!0,console.warn(e(a,i)))}return i.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",i.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",i.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",i.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",i})),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],(function(e,t,r){"use strict";return function(n,i){if(!e(n)||!e(i))throw new t("identifier and message are required.");r(n,i)}})),define("Core/getBaseUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n,i){if(!t(n))throw new r("uri is required.");var a="",o=n.lastIndexOf("/");return-1!==o&&(a=n.substring(0,o+1)),i?(n=new e(n),t(n.query)&&(a+="?"+n.query),t(n.fragment)&&(a+="#"+n.fragment),a):a}})),define("Core/getExtensionFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(!t(n))throw new r("uri is required.");var i=new e(n);i.normalize();var a=i.path,o=a.lastIndexOf("/");return-1!==o&&(a=a.substr(o+1)),o=a.lastIndexOf("."),a=-1===o?"":a.substr(o+1)}})),define("Core/isBlobUri",["./Check"],(function(e){"use strict";var t=/^blob:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/isCrossOriginUrl",["./defined"],(function(e){"use strict";var t;return function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var n=t.host,i=t.protocol;return t.href=r,t.href=t.href,i!==t.protocol||n!==t.host}})),define("Core/isDataUri",["./Check"],(function(e){"use strict";var t=/^data:/i;return function(r){return e.typeOf.string("uri",r),t.test(r)}})),define("Core/loadAndExecuteScript",["../ThirdParty/when"],(function(e){"use strict";return function(t){var r=e.defer(),n=document.createElement("script");n.async=!0,n.src=t;var i=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,i.removeChild(n),r.resolve()},n.onerror=function(e){r.reject(e)},i.appendChild(n),r.promise}})),define("Core/isArray",["./defined"],(function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t})),define("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("obj is required.");var i="";for(var a in n)if(n.hasOwnProperty(a)){var o=n[a],u=encodeURIComponent(a)+"=";if(r(o))for(var s=0,c=o.length;s<c;++s)i+=u+encodeURIComponent(o[s])+"&";else i+=u+encodeURIComponent(o)+"&"}return i=i.slice(0,-1)}})),define("Core/queryToObject",["./defined","./DeveloperError","./isArray"],(function(e,t,r){"use strict";return function(n){if(!e(n))throw new t("queryString is required.");var i={};if(""===n)return i;for(var a=n.replace(/\+/g,"%20").split(/[&;]/),o=0,u=a.length;o<u;++o){var s=a[o].split("="),c=decodeURIComponent(s[0]),l=s[1];l=e(l)?decodeURIComponent(l):"";var f=i[c];"string"==typeof f?i[c]=[f,l]:r(f)?f.push(l):i[c]=l}return i}})),define("Core/RequestState",["../Core/freezeObject"],(function(e){"use strict";return e({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5})})),define("Core/RequestType",["../Core/freezeObject"],(function(e){"use strict";return e({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3})})),define("Core/Request",["./defaultValue","./defined","./RequestState","./RequestType"],(function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT);var i=e(t.throttleByServer,!1),a=i||e(t.throttle,!1);this.url=t.url,this.requestFunction=t.requestFunction,this.cancelFunction=t.cancelFunction,this.priorityFunction=t.priorityFunction,this.priority=e(t.priority,0),this.throttle=a,this.throttleByServer=i,this.type=e(t.type,n.OTHER),this.serverKey=void 0,this.state=r.UNISSUED,this.deferred=void 0,this.cancelled=!1}return i.prototype.cancel=function(){this.cancelled=!0},i.prototype.clone=function(e){return t(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new i(this)},i})),define("Core/parseResponseHeaders",[],(function(){"use strict";return function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}})),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],(function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r})),define("Core/Event",["./Check","./defined","./defineProperties"],(function(e,t,r){"use strict";function n(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function i(e,t){return t-e}return r(n.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),n.prototype.addEventListener=function(t,r){e.typeOf.func("listener",t),this._listeners.push(t),this._scopes.push(r);var n=this;return function(){n.removeEventListener(t,r)}},n.prototype.removeEventListener=function(t,r){e.typeOf.func("listener",t);for(var n=this._listeners,i=this._scopes,a=-1,o=0;o<n.length;o++)if(n[o]===t&&i[o]===r){a=o;break}return-1!==a&&(this._insideRaiseEvent?(this._toRemove.push(a),n[a]=void 0,i[a]=void 0):(n.splice(a,1),i.splice(a,1)),!0)},n.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var r=this._listeners,n=this._scopes,a=r.length;for(e=0;e<a;e++){var o=r[e];t(o)&&r[e].apply(n[e],arguments)}var u=this._toRemove;if((a=u.length)>0){for(u.sort(i),e=0;e<a;e++){var s=u[e];r.splice(s,1),n.splice(s,1)}u.length=0}this._insideRaiseEvent=!1},n})),define("Core/Heap",["./Check","./defaultValue","./defined","./defineProperties"],(function(e,t,r,n){"use strict";function i(t){e.typeOf.object("options",t),e.defined("options.comparator",t.comparator),this._comparator=t.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function a(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}return n(i.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),i.prototype.reserve=function(e){e=t(e,this._length),this._array.length=e},i.prototype.heapify=function(e){e=t(e,0);for(var r=this._length,n=this._comparator,i=this._array,o=-1,u=!0;u;){var s=2*(e+1),c=s-1;o=c<r&&n(i[c],i[e])<0?c:e,s<r&&n(i[s],i[o])<0&&(o=s),o!==e?(a(i,o,e),e=o):u=!1}},i.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);t>=0;--t)this.heapify(t)},i.prototype.insert=function(t){e.defined("element",t);var n,i=this._array,o=this._comparator,u=this._maximumLength,s=this._length++;for(s<i.length?i[s]=t:i.push(t);0!==s;){var c=Math.floor((s-1)/2);if(!(o(i[s],i[c])<0))break;a(i,s,c),s=c}return r(u)&&this._length>u&&(n=i[u],this._length=u),n},i.prototype.pop=function(r){if(r=t(r,0),0!==this._length){e.typeOf.number.lessThan("index",r,this._length);var n=this._array,i=n[r];return a(n,r,--this._length),this.heapify(r),i}},i})),define("Core/RequestScheduler",["../ThirdParty/Uri","../ThirdParty/when","./Check","./defaultValue","./defined","./defineProperties","./Event","./Heap","./isBlobUri","./isDataUri","./RequestState"],(function(e,t,r,n,i,a,o,u,s,c,l){"use strict";var f={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0},h=20,d=new u({comparator:function(e,t){return e.priority-t.priority}});d.maximumLength=h,d.reserve(h);var p=[],y={},m="undefined"!=typeof document?new e(document.location.href):new e,E=new o;function O(){}function _(e){i(e.priorityFunction)&&(e.priority=e.priorityFunction())}function T(e){var t=n(O.requestsByServer[e],O.maximumRequestsPerServer);return y[e]<t}function w(e){return e.state===l.UNISSUED&&(e.state=l.ISSUED,e.deferred=t.defer()),e.deferred.promise}function R(e){var t=w(e);return e.state=l.ACTIVE,p.push(e),++f.numberOfActiveRequests,++f.numberOfActiveRequestsEver,++y[e.serverKey],e.requestFunction().then(function(e){return function(t){e.state!==l.CANCELLED&&(--f.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(),e.state=l.RECEIVED,e.deferred.resolve(t))}}(e)).otherwise(function(e){return function(t){e.state!==l.CANCELLED&&(++f.numberOfFailedRequests,--f.numberOfActiveRequests,--y[e.serverKey],E.raiseEvent(t),e.state=l.FAILED,e.deferred.reject(t))}}(e)),t}function g(e){var t=e.state===l.ACTIVE;e.state=l.CANCELLED,++f.numberOfCancelledRequests,e.deferred.reject(),t&&(--f.numberOfActiveRequests,--y[e.serverKey],++f.numberOfCancelledActiveRequests),i(e.cancelFunction)&&e.cancelFunction()}return O.maximumRequests=50,O.maximumRequestsPerServer=6,O.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},O.throttleRequests=!0,O.debugShowStatistics=!1,O.requestCompletedEvent=E,a(O,{statistics:{get:function(){return f}},priorityHeapLength:{get:function(){return h},set:function(e){if(e<h)for(;d.length>e;)g(d.pop());h=e,d.maximumLength=e,d.reserve(e)}}}),O.update=function(){var e,t,r=0,n=p.length;for(e=0;e<n;++e)(t=p[e]).cancelled&&g(t),t.state===l.ACTIVE?r>0&&(p[e-r]=t):++r;p.length-=r;var i=d.internalArray,a=d.length;for(e=0;e<a;++e)_(i[e]);d.resort();for(var o=Math.max(O.maximumRequests-p.length,0),u=0;u<o&&d.length>0;)(t=d.pop()).cancelled?g(t):!t.throttleByServer||T(t.serverKey)?(R(t),++u):g(t);O.debugShowStatistics&&(f.numberOfAttemptedRequests>0&&console.log("Number of attempted requests: "+f.numberOfAttemptedRequests),f.numberOfActiveRequests>0&&console.log("Number of active requests: "+f.numberOfActiveRequests),f.numberOfCancelledRequests>0&&console.log("Number of cancelled requests: "+f.numberOfCancelledRequests),f.numberOfCancelledActiveRequests>0&&console.log("Number of cancelled active requests: "+f.numberOfCancelledActiveRequests),f.numberOfFailedRequests>0&&console.log("Number of failed requests: "+f.numberOfFailedRequests),f.numberOfAttemptedRequests=0,f.numberOfCancelledRequests=0,f.numberOfCancelledActiveRequests=0)},O.getServerKey=function(t){r.typeOf.string("url",t);var n=new e(t).resolve(m);n.normalize();var a=n.authority;/:/.test(a)||(a=a+":"+("https"===n.scheme?"443":"80"));var o=y[a];return i(o)||(y[a]=0),a},O.request=function(e){if(r.typeOf.object("request",e),r.typeOf.string("request.url",e.url),r.typeOf.func("request.requestFunction",e.requestFunction),c(e.url)||s(e.url))return E.raiseEvent(),e.state=l.RECEIVED,e.requestFunction();if(++f.numberOfAttemptedRequests,i(e.serverKey)||(e.serverKey=O.getServerKey(e.url)),!O.throttleRequests||!e.throttle)return R(e);if(!(p.length>=O.maximumRequests)&&(!e.throttleByServer||T(e.serverKey))){_(e);var t=d.insert(e);if(i(t)){if(t===e)return;g(t)}return w(e)}},O.clearForSpecs=function(){for(;d.length>0;)g(d.pop());for(var e=p.length,t=0;t<e;++t)g(p[t]);p.length=0,y={},f.numberOfAttemptedRequests=0,f.numberOfActiveRequests=0,f.numberOfCancelledRequests=0,f.numberOfCancelledActiveRequests=0,f.numberOfFailedRequests=0,f.numberOfActiveRequestsEver=0},O.numberOfActiveRequestsByServer=function(e){return y[e]},O.requestHeap=d,O})),define("Core/RuntimeError",["./defined"],(function(e){"use strict";function t(e){var t;this.name="RuntimeError",this.message=e;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t})),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],(function(e,t,r){"use strict";var n={},i={};return n.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var a=e.toLowerCase()+":"+n;t(i[a])||(i[a]=!0)},n.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var a=e.toLowerCase()+":"+n;t(i[a])&&delete i[a]},n.contains=function(n){if(!t(n))throw new r("url is required.");var a=function(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(-1!==i.indexOf("@")){var a=i.split("@");i=a[1]}if(-1===i.indexOf(":")){var o=n.getScheme();if(t(o)||(o=(o=window.location.protocol).substring(0,o.length-1)),"http"===o)i+=":80";else{if("https"!==o)return;i+=":443"}}return i}}(n);return!(!t(a)||!t(i[a]))},n.clear=function(){i={}},n})),define("Core/Resource",["../ThirdParty/Uri","../ThirdParty/when","./appendForwardSlash","./Check","./clone","./combine","./defaultValue","./defined","./defineProperties","./deprecationWarning","./DeveloperError","./freezeObject","./getAbsoluteUri","./getBaseUri","./getExtensionFromUri","./isBlobUri","./isCrossOriginUrl","./isDataUri","./loadAndExecuteScript","./objectToQuery","./queryToObject","./Request","./RequestErrorEvent","./RequestScheduler","./RequestState","./RuntimeError","./TrustedServers"],(function(e,t,r,n,i,a,o,u,s,c,l,f,h,d,p,y,m,E,O,_,T,w,R,g,b,v,A){"use strict";var S=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(e){return!1}}();function N(e,t,r,n){var i,a=e.query;if(!u(a)||0===a.length)return{};if(-1===a.indexOf("=")){var o={};o[a]=void 0,i=o}else i=T(a);t._queryParameters=r?C(i,t._queryParameters,n):i,e.query=void 0}function I(e,t){return u(e)?u(e.clone)?e.clone():i(e):t}function M(e){if(e.state===b.ISSUED||e.state===b.ACTIVE)throw new v("The Resource is already being fetched.");e.state=b.UNISSUED,e.deferred=void 0}function C(e,t,r){if(!r)return a(e,t);var n=i(e,!0);for(var o in t)if(t.hasOwnProperty(o)){var s=n[o],c=t[o];u(s)?(Array.isArray(s)||(s=n[o]=[s]),n[o]=s.concat(c)):n[o]=Array.isArray(c)?c.slice():c}return n}function x(t){"string"==typeof(t=o(t,o.EMPTY_OBJECT))&&(t={url:t}),n.typeOf.string("options.url",t.url),this._url=void 0,this._templateValues=I(t.templateValues,{}),this._queryParameters=I(t.queryParameters,{}),this.headers=I(t.headers,{}),this.request=o(t.request,new w),this.proxy=t.proxy,this.retryCallback=t.retryCallback,this.retryAttempts=o(t.retryAttempts,0),this._retryCount=0;var r=new e(t.url);N(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function P(e){var r=e.request;r.url=e.url,r.requestFunction=function(){var r=e.url,n=!1;e.isDataUri||e.isBlobUri||(n=e.isCrossOriginUrl);var i=t.defer();return x._Implementations.createImage(r,n,i),i.promise};var n=g.request(r);if(u(n))return n.otherwise((function(n){return r.state!==b.FAILED?t.reject(n):e.retryOnError(n).then((function(i){return i?(r.state=b.UNISSUED,r.deferred=void 0,P(e)):t.reject(n)}))}))}x.createIfNeeded=function(e){return e instanceof x?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new x({url:e})},s(x,{isBlobSupported:{get:function(){return S}}}),s(x.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(t){var r=new e(t);N(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return p(this._url)}},isDataUri:{get:function(){return E(this._url)}},isBlobUri:{get:function(){return y(this._url)}},isCrossOriginUrl:{get:function(){return m(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}}),x.prototype.getUrlComponent=function(t,r){if(this.isDataUri)return this._url;var n=new e(this._url);t&&function(e,t){var r=t._queryParameters,n=Object.keys(r);1!==n.length||u(r[n[0]])?e.query=_(r):e.query=n[0]}(n,this);var i=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues,o=Object.keys(a);if(o.length>0)for(var s=0;s<o.length;s++){var c=o[s],l=a[c];i=i.replace(new RegExp("{"+c+"}","g"),encodeURIComponent(l))}return r&&u(this.proxy)&&(i=this.proxy.getURL(i)),i},x.prototype.setQueryParameters=function(e,t){this._queryParameters=t?C(this._queryParameters,e,!1):C(e,this._queryParameters,!1)},x.prototype.addQueryParameters=function(e,t){return c("Resource.addQueryParameters","addQueryParameters has been deprecated and will be removed 1.45. Use setQueryParameters or appendQueryParameters instead."),this.setQueryParameters(e,t)},x.prototype.appendQueryParameters=function(e){this._queryParameters=C(e,this._queryParameters,!0)},x.prototype.setTemplateValues=function(e,t){this._templateValues=t?a(this._templateValues,e):a(e,this._templateValues)},x.prototype.addTemplateValues=function(e,t){return c("Resource.addTemplateValues","addTemplateValues has been deprecated and will be removed 1.45. Use setTemplateValues."),this.setTemplateValues(e,t)},x.prototype.getDerivedResource=function(t){var r=this.clone();if(r._retryCount=0,u(t.url)){var n=new e(t.url);N(n,r,!0,o(t.preserveQueryParameters,!1)),n.fragment=void 0,r._url=n.resolve(new e(h(this._url))).toString()}return u(t.queryParameters)&&(r._queryParameters=a(t.queryParameters,r._queryParameters)),u(t.templateValues)&&(r._templateValues=a(t.templateValues,r.templateValues)),u(t.headers)&&(r.headers=a(t.headers,r.headers)),u(t.proxy)&&(r.proxy=t.proxy),u(t.request)&&(r.request=t.request),u(t.retryCallback)&&(r.retryCallback=t.retryCallback),u(t.retryAttempts)&&(r.retryAttempts=t.retryAttempts),r},x.prototype.retryOnError=function(e){var r=this.retryCallback;if("function"!=typeof r||this._retryCount>=this.retryAttempts)return t(!1);var n=this;return t(r(this,e)).then((function(e){return++n._retryCount,e}))},x.prototype.clone=function(e){return u(e)||(e=new x({url:this._url})),e._url=this._url,e._queryParameters=i(this._queryParameters),e._templateValues=i(this._templateValues),e.headers=i(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},x.prototype.getBaseUri=function(e){return d(this.getUrlComponent(e),e)},x.prototype.appendForwardSlash=function(){this._url=r(this._url)},x.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},x.fetchArrayBuffer=function(e){return new x(e).fetchArrayBuffer()},x.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},x.fetchBlob=function(e){return new x(e).fetchBlob()},x.prototype.fetchImage=function(e){if(e=o(e,!1),M(this.request),!S||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!e)return P(this);var r,n,i=this.fetchBlob();return u(i)?i.then((function(e){if(u(e)){n=e;var t=window.URL.createObjectURL(e);return P(r=new x({url:t}))}})).then((function(e){if(u(e))return window.URL.revokeObjectURL(r.url),e.blob=n,e})).otherwise((function(e){return u(r)&&window.URL.revokeObjectURL(r.url),t.reject(e)})):void 0},x.fetchImage=function(e){return new x(e).fetchImage(e.preferBlob)},x.prototype.fetchText=function(){return this.fetch({responseType:"text"})},x.fetchText=function(e){return new x(e).fetchText()},x.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(u(e))return e.then((function(e){if(u(e))return JSON.parse(e)}))},x.fetchJson=function(e){return new x(e).fetchJson()},x.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},x.fetchXML=function(e){return new x(e).fetchXML()},x.prototype.fetchJsonp=function(e){var r;e=o(e,"callback"),M(this.request);do{r="loadJsonp"+Math.random().toString().substring(2,8)}while(u(window[r]));return function e(r,n,i){var a={};a[n]=i,r.setQueryParameters(a);var o=r.request;o.url=r.url,o.requestFunction=function(){var e=t.defer();return window[i]=function(t){e.resolve(t);try{delete window[i]}catch(e){window[i]=void 0}},x._Implementations.loadAndExecuteScript(r.url,i,e),e.promise};var s=g.request(o);if(u(s))return s.otherwise((function(a){return o.state!==b.FAILED?t.reject(a):r.retryOnError(a).then((function(u){return u?(o.state=b.UNISSUED,o.deferred=void 0,e(r,n,i)):t.reject(a)}))}))}(this,e,r)},x.fetchJsonp=function(e){return new x(e).fetchJsonp(e.callbackParameterName)},x.prototype._makeRequest=function(e){var r=this;M(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(){var i=e.responseType,o=a(e.headers,r.headers),s=e.overrideMimeType,c=e.method,l=e.data,f=t.defer(),h=x._Implementations.loadWithXhr(r.url,i,c,l,o,f,s);return u(h)&&u(h.abort)&&(n.cancelFunction=function(){h.abort()}),f.promise};var i=g.request(n);if(u(i))return i.then((function(e){return e})).otherwise((function(i){return n.state!==b.FAILED?t.reject(i):r.retryOnError(i).then((function(a){return a?(n.state=b.UNISSUED,n.deferred=void 0,r.fetch(e)):t.reject(i)}))}))};var U=/^data:(.*?)(;base64)?,(.*)$/;function D(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function q(e,t){for(var r=D(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),a=0;a<r.length;a++)i[a]=r.charCodeAt(a);return n}function L(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}x.prototype.fetch=function(e){return(e=I(e,{})).method="GET",this._makeRequest(e)},x.fetch=function(e){return new x(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.delete=function(e){return(e=I(e,{})).method="DELETE",this._makeRequest(e)},x.delete=function(e){return new x(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},x.prototype.head=function(e){return(e=I(e,{})).method="HEAD",this._makeRequest(e)},x.head=function(e){return new x(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.options=function(e){return(e=I(e,{})).method="OPTIONS",this._makeRequest(e)},x.options=function(e){return new x(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.post=function(e,t){return n.defined("data",e),(t=I(t,{})).method="POST",t.data=e,this._makeRequest(t)},x.post=function(e){return new x(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.put=function(e,t){return n.defined("data",e),(t=I(t,{})).method="PUT",t.data=e,this._makeRequest(t)},x.put=function(e){return new x(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x.prototype.patch=function(e,t){return n.defined("data",e),(t=I(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},x.patch=function(e){return new x(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},x._Implementations={},x._Implementations.createImage=function(e,t,r){var n=new Image;n.onload=function(){r.resolve(n)},n.onerror=function(e){r.reject(e)},t&&(A.contains(e)?n.crossOrigin="use-credentials":n.crossOrigin=""),n.src=e};var j="undefined"==typeof XMLHttpRequest;return x._Implementations.loadWithXhr=function(e,t,r,n,i,a,s){var c=U.exec(e);if(null===c){if(!j){var f=new XMLHttpRequest;if(A.contains(e)&&(f.withCredentials=!0),f.open(r,e,!0),u(s)&&u(f.overrideMimeType)&&f.overrideMimeType(s),u(i))for(var h in i)i.hasOwnProperty(h)&&f.setRequestHeader(h,i[h]);u(t)&&(f.responseType=t);var d=!1;return"string"==typeof e&&(d=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),f.onload=function(){if(!(f.status<200||f.status>=300)||d&&0===f.status){var e=f.response,n=f.responseType;if("HEAD"===r||"OPTIONS"===r){var i=f.getAllResponseHeaders().trim().split(/[\r\n]+/),o={};return i.forEach((function(e){var t=e.split(": "),r=t.shift();o[r]=t.join(": ")})),void a.resolve(o)}if(204===f.status)a.resolve();else if(!u(e)||u(t)&&n!==t)if("json"===t&&"string"==typeof e)try{a.resolve(JSON.parse(e))}catch(e){a.reject(e)}else(""===n||"document"===n)&&u(f.responseXML)&&f.responseXML.hasChildNodes()?a.resolve(f.responseXML):""!==n&&"text"!==n||!u(f.responseText)?a.reject(new v("Invalid XMLHttpRequest response type.")):a.resolve(f.responseText);else a.resolve(e)}else a.reject(new R(f.status,f.response,f.getAllResponseHeaders()))},f.onerror=function(e){a.reject(new R)},f.send(n),f}!function(e,t,r,n,i,a,o){var u=require("url").parse(e),s="https:"===u.protocol?require("https"):require("http"),c=require("zlib"),l={protocol:u.protocol,hostname:u.hostname,port:u.port,path:u.path,query:u.query,method:r,headers:i};s.request(l).on("response",(function(e){if(e.statusCode<200||e.statusCode>=300)a.reject(new R(e.statusCode,e,e.headers));else{var r=[];e.on("data",(function(e){r.push(e)})),e.on("end",(function(){var n=Buffer.concat(r);"gzip"===e.headers["content-encoding"]?c.gunzip(n,(function(e,r){e?a.reject(new v("Error decompressing response.")):a.resolve(L(r,t))})):a.resolve(L(n,t))}))}})).on("error",(function(e){a.reject(new R)})).end()}(e,t,r,0,i,a)}else a.resolve(function(e,t){t=o(t,"");var r=e[1],n=!!e[2],i=e[3];switch(t){case"":case"text":return D(n,i);case"arraybuffer":return q(n,i);case"blob":var a=q(n,i);return new Blob([a],{type:r});case"document":return(new DOMParser).parseFromString(D(n,i),r);case"json":return JSON.parse(D(n,i));default:throw new l("Unhandled responseType: "+t)}}(c,t))},x._Implementations.loadAndExecuteScript=function(e,t,r){return O(e,t).otherwise(r.reject)},x._DefaultImplementations={},x._DefaultImplementations.createImage=x._Implementations.createImage,x._DefaultImplementations.loadWithXhr=x._Implementations.loadWithXhr,x._DefaultImplementations.loadAndExecuteScript=x._Implementations.loadAndExecuteScript,x.DEFAULT=f(new x({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),x})),define("Core/buildModuleUrl",["./defined","./DeveloperError","./getAbsoluteUri","./Resource","require"],(function(e,t,r,n,i){"use strict";var a,o,u,s=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;function c(t){return"undefined"==typeof document?t:(e(a)||(a=document.createElement("a")),a.href=t,a.href=a.href,a.href)}function l(){if(e(o))return o;var a;if(a="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?r("..",d("Core/buildModuleUrl.js")):function(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),i=s.exec(n);if(null!==i)return i[1]}}(),!e(a))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return(o=new n({url:c(a)})).appendForwardSlash(),o}function f(e){return c(i.toUrl("../"+e))}function h(e){return l().getDerivedResource({url:e}).url}function d(t){return e(u)||(u=e(define.amd)&&!define.amd.toUrlUndefined&&e(i.toUrl)?f:h),u(t)}return d._cesiumScriptRegex=s,d._buildModuleUrlFromBaseUrl=h,d._clearBaseResource=function(){o=void 0},d.setBaseUrl=function(e){o=n.DEFAULT.getDerivedResource({url:e})},d.getCesiumBaseUrl=l,d})),
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
define("ThirdParty/mersenne-twister",[],(function(){var e=function(e){null==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++)e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30,this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,(e^=e>>>18)>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e})),define("Core/Math",["../ThirdParty/mersenne-twister","./Check","./defaultValue","./defined","./DeveloperError"],(function(e,t,r,n,i){"use strict";var a={EPSILON1:.1,EPSILON2:.01,EPSILON3:.001,EPSILON4:1e-4,EPSILON5:1e-5,EPSILON6:1e-6,EPSILON7:1e-7,EPSILON8:1e-8,EPSILON9:1e-9,EPSILON10:1e-10,EPSILON11:1e-11,EPSILON12:1e-12,EPSILON13:1e-13,EPSILON14:1e-14,EPSILON15:1e-15,EPSILON16:1e-16,EPSILON17:1e-17,EPSILON18:1e-18,EPSILON19:1e-19,EPSILON20:1e-20,EPSILON21:1e-21,GRAVITATIONALPARAMETER:3986004418e5,SOLAR_RADIUS:6955e5,LUNAR_RADIUS:1737400,SIXTY_FOUR_KILOBYTES:65536};a.sign=r(Math.sign,(function(e){return 0==(e=+e)||e!=e?e:e>0?1:-1})),a.signNotZero=function(e){return e<0?-1:1},a.toSNorm=function(e,t){return t=r(t,255),Math.round((.5*a.clamp(e,-1,1)+.5)*t)},a.fromSNorm=function(e,t){return t=r(t,255),a.clamp(e,0,t)/t*2-1},a.sinh=r(Math.sinh,(function(e){return(Math.exp(e)-Math.exp(-e))/2})),a.cosh=r(Math.cosh,(function(e){return(Math.exp(e)+Math.exp(-e))/2})),a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=Math.PI/2,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI/2,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){if(!n(e))throw new i("degrees is required.");return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){if(!n(e))throw new i("radians is required.");return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){if(!n(e))throw new i("angle is required.");var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.clampToLatitudeRange=function(e){if(!n(e))throw new i("angle is required.");return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){if(!n(e))throw new i("angle is required.");return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){if(!n(e))throw new i("angle is required.");var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){if(!n(e))throw new i("m is required.");if(!n(t))throw new i("n is required.");return(e%t+t)%t},a.equalsEpsilon=function(e,t,a,o){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");if(!n(a))throw new i("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-t);return u<=o||u<=a*Math.max(Math.abs(e),Math.abs(t))};var o=[1];a.factorial=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");var t=o.length;if(e>=t)for(var r=o[t-1],n=t;n<=e;n++)o.push(r*n);return o[e]},a.incrementWrap=function(e,t,a){if(a=r(a,0),!n(e))throw new i("n is required.");if(t<=a)throw new i("maximumValue must be greater than minimumValue.");return++e>t&&(e=a),e},a.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0==(e&e-1)},a.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e},a.clamp=function(e,t,r){if(!n(e))throw new i("value is required");if(!n(t))throw new i("min is required.");if(!n(r))throw new i("max is required.");return e<t?t:e>r?r:e};var u=new e;return a.setRandomNumberSeed=function(t){if(!n(t))throw new i("seed is required.");u=new e(t)},a.nextRandomNumber=function(){return u.random()},a.randomBetween=function(e,t){return a.nextRandomNumber()*(t-e)+e},a.acosClamped=function(e){if(!n(e))throw new i("value is required.");return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){if(!n(e))throw new i("value is required.");return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){if(!n(e))throw new i("angle is required.");if(!n(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){if(!n(e))throw new i("number is required.");if(!n(t))throw new i("base is required.");return Math.log(e)/Math.log(t)},a.cbrt=r(Math.cbrt,(function(e){var t=Math.pow(Math.abs(e),1/3);return e<0?-t:t})),a.log2=r(Math.log2,(function(e){return Math.log(e)*Math.LOG2E})),a.fog=function(e,t){var r=e*t;return 1-Math.exp(-r*r)},a.fastApproximateAtan=function(e){return t.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)},a.fastApproximateAtan2=function(e,r){var n,o;t.typeOf.number("x",e),t.typeOf.number("y",r);var u=Math.abs(e);n=Math.abs(r),o=Math.max(u,n);var s=(n=Math.min(u,n))/o;if(isNaN(s))throw new i("either x or y must be nonzero");return u=a.fastApproximateAtan(s),u=Math.abs(r)>Math.abs(e)?a.PI_OVER_TWO-u:u,u=e<0?a.PI-u:u,u=r<0?-u:u},a})),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;a<i;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!=0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;u<a;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l);var n=o.dot(c,l),i=o.magnitude(o.cross(c,l,c));return Math.atan2(i,n)};var f=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.projectVector=function(t,r,n){e.defined("a",t),e.defined("b",r),e.defined("result",n);var i=o.dot(t,r)/o.dot(r,r);return o.multiplyByScalar(r,i,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,l=a*c-o*s,f=o*u-i*c,h=i*s-a*u;return n.x=l,n.y=f,n.z=h,n},o.midpoint=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=.5*(t.x+r.x),n.y=.5*(t.y+r.y),n.z=.5*(t.z+r.z),n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var h=new o,d=new o,p=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),a=t(a,0);var c=r(u)?u.radiiSquared:p,l=Math.cos(i);h.x=l*Math.cos(n),h.y=l*Math.sin(n),h.z=Math.sin(i),h=o.normalize(h,h),o.multiplyComponents(c,h,d);var f=Math.sqrt(o.dot(h,d));return d=o.divideByScalar(d,f,d),h=o.multiplyByScalar(h,a,h),r(s)||(s=new o),o.add(d,h,s)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromDegrees(c,l,0,i,a[f])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!=0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromRadians(c,l,0,i,a[f])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],h=s/3;a[h]=o.fromDegrees(c,l,f,i,a[h])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!=0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],h=s/3;a[h]=o.fromRadians(c,l,f,i,a[h])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o})),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";var i=new e,a=new e;return function(o,u,s,c,l){if(!t(o))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var f=o.x,h=o.y,d=o.z,p=u.x,y=u.y,m=u.z,E=f*f*p*p,O=h*h*y*y,_=d*d*m*m,T=E+O+_,w=Math.sqrt(1/T),R=e.multiplyByScalar(o,w,i);if(T<c)return isFinite(w)?e.clone(R,l):void 0;var g=s.x,b=s.y,v=s.z,A=a;A.x=R.x*g*2,A.y=R.y*b*2,A.z=R.z*v*2;var S,N,I,M,C,x,P,U=(1-w)*e.magnitude(o)/(.5*e.magnitude(A)),D=0;do{D=(S=E*(C=(N=1/(1+(U-=D)*g))*N)+O*(x=(I=1/(1+U*b))*I)+_*(P=(M=1/(1+U*v))*M)-1)/(-2*(E*(C*N)*g+O*(x*I)*b+_*(P*M)*v))}while(Math.abs(S)>n.EPSILON12);return t(l)?(l.x=f*N,l.y=h*I,l.z=d*M,l):new e(f*N,h*I,d*M)}})),define("Core/Cartographic",["./Cartesian3","./Check","./defaultValue","./defined","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,a,o){"use strict";function u(e,t,n){this.longitude=r(e,0),this.latitude=r(t,0),this.height=r(n,0)}u.fromRadians=function(e,i,a,o){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",i),a=r(a,0),n(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,r,n,i){return t.typeOf.number("longitude",e),t.typeOf.number("latitude",r),e=a.toRadians(e),r=a.toRadians(r),u.fromRadians(e,r,n,i)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=a.EPSILON1;return u.fromCartesian=function(t,r,i){var p=n(r)?r.oneOverRadii:f,y=n(r)?r.oneOverRadiiSquared:h,m=n(r)?r._centerToleranceSquared:d,E=o(t,p,y,m,c);if(n(E)){var O=e.multiplyComponents(E,y,s);O=e.normalize(O,O);var _=e.subtract(t,E,l),T=Math.atan2(O.y,O.x),w=Math.asin(O.z),R=a.sign(e.dot(_,t))*e.magnitude(_);return n(i)?(i.longitude=T,i.latitude=w,i.height=R,i):new u(T,w,R)}},u.toCartesian=function(r,n,i){return t.defined("cartographic",r),e.fromRadians(r.longitude,r.latitude,r.height,n,i)},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.longitude-r.longitude)<=i&&Math.abs(e.latitude-r.latitude)<=i&&Math.abs(e.height-r.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u})),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],(function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(t,i,a,o){i=n(i,0),a=n(a,0),o=n(o,0),r.typeOf.number.greaterThanOrEquals("x",i,0),r.typeOf.number.greaterThanOrEquals("y",a,0),r.typeOf.number.greaterThanOrEquals("z",o,0),t._radii=new e(i,a,o),t._radiiSquared=new e(i*i,a*a,o*o),t._radiiToTheFourth=new e(i*i*i*i,a*a*a*a,o*o*o*o),t._oneOverRadii=new e(0===i?0:1/i,0===a?0:1/a,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===a?0:1/(a*a),0===o?0:1/(o*o)),t._minimumRadius=Math.min(i,a,o),t._maximumRadius=Math.max(i,a,o),t._centerToleranceSquared=s.EPSILON1,0!==t._radiiSquared.z&&(t._squaredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function f(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,l(this,e,t,r)}a(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(t,r){if(i(t)){var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new f(n.x,n.y,n.z)}},f.fromCartesian3=function(e,t){return i(t)||(t=new f),i(e)?(l(t,e.x,e.y,e.z),t):t},f.WGS84=u(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=u(new f(1,1,1)),f.MOON=u(new f(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(t,i,a){return r.typeOf.object("value",t),r.defined("array",i),a=n(a,0),e.pack(t._radii,i,a),i},f.unpack=function(t,i,a){r.defined("array",t),i=n(i,0);var o=e.unpack(t,i);return f.fromCartesian3(o,a)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(t,n){r.typeOf.object("cartographic",t);var a=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(a),c=u*Math.sin(a),l=Math.sin(o);return i(n)||(n=new e),n.x=s,n.y=c,n.z=l,e.normalize(n,n)},f.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var h=new e,d=new e;f.prototype.cartographicToCartesian=function(t,r){var n=h,a=d;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,a);var o=Math.sqrt(e.dot(n,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(a,n,r)},f.prototype.cartographicArrayToCartesianArray=function(e,t){r.defined("cartographics",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;a<n;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var p=new e,y=new e,m=new e;return f.prototype.cartesianToCartographic=function(r,n){var a=this.scaleToGeodeticSurface(r,y);if(i(a)){var o=this.geodeticSurfaceNormal(a,p),u=e.subtract(r,a,m),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=c,n.latitude=l,n.height=f,n):new t(c,l,f)}},f.prototype.cartesianArrayToCartographicArray=function(e,t){r.defined("cartesians",e);var n=e.length;i(t)?t.length=n:t=new Array(n);for(var a=0;a<n;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},f.prototype.scaleToGeodeticSurface=function(e,t){return c(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},f.prototype.scaleToGeocentricSurface=function(t,n){r.typeOf.object("cartesian",t),i(n)||(n=new e);var a=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(a*a*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,n)},f.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},f.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},f.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},f.prototype.toString=function(){return this._radii.toString()},f.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,u){if(r.typeOf.object("position",t),!s.equalsEpsilon(this._radii.x,this._radii.y,s.EPSILON15))throw new o("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),a=n(a,0);var c=this._squaredXOverSquaredZ;if(i(u)||(u=new e),u.x=0,u.y=0,u.z=t.z*(1-c),!(Math.abs(u.z)>=this._radii.z-a))return u},f})),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],(function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u})),define("Core/Intersect",["./freezeObject"],(function(e){"use strict";return e({OUTSIDE:-1,INTERSECTING:0,INSIDE:1})})),define("Core/Interval",["./defaultValue"],(function(e){"use strict";return function(t,r){this.start=e(t,0),this.stop=e(r,0)}})),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,l=e.y*e.z,f=e.y*e.w,h=e.z*e.z,d=e.z*e.w,p=e.w*e.w,y=i-c-h+p,m=2*(a-d),E=2*(o+f),O=2*(a+d),_=-i+c-h+p,T=2*(l-u),w=2*(o-f),R=2*(l+u),g=-i-c+h+p;return n(r)?(r[0]=y,r[1]=O,r[2]=w,r[3]=m,r[4]=_,r[5]=R,r[6]=E,r[7]=T,r[8]=g,r):new s(y,m,E,O,_,T,w,R,g)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),l=Math.sin(e.roll),f=i*a,h=-o*c+l*u*a,d=l*c+o*u*a,p=i*c,y=o*a+l*u*c,m=-l*a+o*u*c,E=-u,O=l*i,_=o*i;return n(r)?(r[0]=f,r[1]=p,r[2]=E,r[3]=h,r[4]=y,r[5]=O,r[6]=d,r[7]=m,r[8]=_,r):new s(f,h,d,p,y,m,E,O,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var a=3*r;return(i=s.clone(e,i))[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=s.clone(e,i))[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var c=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),n};var l=new e;s.getMaximumScale=function(t){return s.getScale(t,l),e.maximumComponent(l)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],f=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],h=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=l,n[7]=f,n[8]=h,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],l=e[5],f=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r};var f=[1,0,0],h=[2,2,1];function d(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(h[r],f[r])];t+=2*n*n}return Math.sqrt(t)}function p(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;a<3;++a){var o=Math.abs(e[s.getElementIndex(h[a],f[a])]);o>n&&(i=a,n=o)}var c=1,l=0,d=f[i],p=h[i];if(Math.abs(e[s.getElementIndex(p,d)])>r){var y,m=(e[s.getElementIndex(p,p)]-e[s.getElementIndex(d,d)])/2/e[s.getElementIndex(p,d)];l=(y=m<0?-1/(-m+Math.sqrt(1+m*m)):1/(m+Math.sqrt(1+m*m)))*(c=1/Math.sqrt(1+y*y))}return(t=s.clone(s.IDENTITY,t))[s.getElementIndex(d,d)]=t[s.getElementIndex(p,p)]=c,t[s.getElementIndex(p,d)]=l,t[s.getElementIndex(d,p)]=-l,t}var y=new s,m=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=0,o=0;n(r)||(r={});for(var c=r.unitary=s.clone(s.IDENTITY,r.unitary),l=r.diagonal=s.clone(e,r.diagonal),f=i*function(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}(l);o<10&&d(l)>f;)p(l,y),s.transpose(y,m),s.multiply(l,y,l),s.multiply(m,l,l),s.multiply(c,y,c),++a>2&&(++o,a=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return r*(o*l-c*u)+a*(c*i-n*l)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],l=e[4],f=e[5],h=e[6],d=e[7],p=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=l*p-d*f,r[1]=d*o-i*p,r[2]=i*f-l*o,r[3]=h*f-c*p,r[4]=n*p-h*o,r[5]=c*o-n*f,r[6]=c*d-h*l,r[7]=h*i-n*d,r[8]=n*l-c*i;var m=1/y;return s.multiplyByScalar(r,m,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s})),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;a<i;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;a<i;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var l=new Float32Array(1);return o.packFloat=function(t,n){if(e.typeOf.number("value",t),r(n)||(n=new o),l[0]=t,0===(t=l[0]))return o.clone(o.ZERO,n);var i,u=t<0?1:0;isFinite(t)?(t=Math.abs(t),i=Math.floor(a.logBase(t,10))+1,t/=Math.pow(10,i)):(t=.1,i=38);var s=256*t;return n.x=Math.floor(s),s=256*(s-n.x),n.y=Math.floor(s),s=256*(s-n.y),n.z=Math.floor(s),n.w=2*(i+38)+u,n},o.unpackFloat=function(t){e.typeOf.object("packedFloat",t);var r=t.w/2,n=Math.floor(r),i=2*(r-n);if(i=-(i=2*i-1),(n-=38)>=38)return i<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=i*t.x*(1/256);return a+=i*t.y*(1/65536),(a+=i*t.z*(1/16777216))*Math.pow(10,n)},o})),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],(function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t,r,i,a,o,u,s,c,l,f,h,d,p,y,m){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(d,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(p,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(h,0),this[15]=n(m,0)}l.packedLength=16,l.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},l.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new l),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},l.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return r.defined("values",e),l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new l(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new l);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,f=t.x*t.y,h=t.x*t.z,d=t.x*t.w,p=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,O=t.z*t.w,_=t.w*t.w,T=c-p-E+_,w=2*(f-O),R=2*(h+m),g=2*(f+O),b=-c+p-E+_,v=2*(y-d),A=2*(h-m),S=2*(y+d),N=-c-p+E+_;return a[0]=T*o,a[1]=g*o,a[2]=A*o,a[3]=0,a[4]=w*u,a[5]=b*u,a[6]=S*u,a[7]=0,a[8]=R*s,a[9]=v*s,a[10]=N*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},l.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return r.typeOf.object("translation",e),l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,h=new e,d=new e;l.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,f),e.normalize(e.cross(f,u,h),h),e.normalize(e.cross(h,f,d),d);var s=h.x,c=h.y,p=h.z,y=f.x,m=f.y,E=f.z,O=d.x,_=d.y,T=d.z,w=a.x,R=a.y,g=a.z,b=s*-w+c*-R+p*-g,v=O*-w+_*-R+T*-g,A=y*w+m*R+E*g;return i(n)?(n[0]=s,n[1]=O,n[2]=-y,n[3]=0,n[4]=c,n[5]=_,n[6]=-m,n[7]=0,n[8]=p,n[9]=T,n[10]=-E,n[11]=0,n[12]=b,n[13]=v,n[14]=A,n[15]=1,n):new l(s,c,p,b,O,_,T,v,-y,-m,-E,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=1/Math.tan(.5*e),u=o/t,s=(i+n)/(n-i),c=2*i*n/(n-i);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},l.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),l=1/(o-a),f=-(t+e)*s,h=-(i+n)*c,d=-(o+a)*l;return s*=2,c*=2,l*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=f,u[13]=h,u[14]=d,u[15]=1,u},l.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),l=(t+e)/(t-e),f=(i+n)/(i-n),h=-(o+a)/(o-a),d=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=f,u[10]=h,u[11]=-1,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},l.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),l=(i+n)/(i-n),f=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=-1,o[11]=-1,o[12]=0,o[13]=0,o[14]=f,o[15]=0,o},l.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0);var l=.5*s,f=.5*c,h=.5*((i=n(i,1))-t),d=l,p=f,y=h,m=o+l,E=u+f,O=t+h;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=p,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=m,a[13]=E,a[14]=O,a[15]=1,a},l.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},l.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},l.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},l.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i);var a=4*t;return(i=l.clone(e,i))[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},l.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var p=new e;l.setScale=function(t,n,i){r.typeOf.object("matrix",t),r.typeOf.object("scale",n),r.typeOf.object("result",i);var a=l.getScale(t,p),o=e.divideComponents(n,a,p);return l.multiplyByScale(t,o,i)},l.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},l.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),(i=l.clone(e,i))[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var y=new e;l.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var m=new e;l.getMaximumScale=function(t){return l.getScale(t,m),e.maximumComponent(m)},l.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],l=e[6],f=e[7],h=e[8],d=e[9],p=e[10],y=e[11],m=e[12],E=e[13],O=e[14],_=e[15],T=t[0],w=t[1],R=t[2],g=t[3],b=t[4],v=t[5],A=t[6],S=t[7],N=t[8],I=t[9],M=t[10],C=t[11],x=t[12],P=t[13],U=t[14],D=t[15],q=i*T+s*w+h*R+m*g,L=a*T+c*w+d*R+E*g,j=o*T+l*w+p*R+O*g,F=u*T+f*w+y*R+_*g,B=i*b+s*v+h*A+m*S,z=a*b+c*v+d*A+E*S,G=o*b+l*v+p*A+O*S,V=u*b+f*v+y*A+_*S,X=i*N+s*I+h*M+m*C,W=a*N+c*I+d*M+E*C,H=o*N+l*I+p*M+O*C,k=u*N+f*I+y*M+_*C,Y=i*x+s*P+h*U+m*D,Z=a*x+c*P+d*U+E*D,K=o*x+l*P+p*U+O*D,J=u*x+f*P+y*U+_*D;return n[0]=q,n[1]=L,n[2]=j,n[3]=F,n[4]=B,n[5]=z,n[6]=G,n[7]=V,n[8]=X,n[9]=W,n[10]=H,n[11]=k,n[12]=Y,n[13]=Z,n[14]=K,n[15]=J,n},l.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},l.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},l.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],h=e[10],d=e[12],p=e[13],y=e[14],m=t[0],E=t[1],O=t[2],_=t[4],T=t[5],w=t[6],R=t[8],g=t[9],b=t[10],v=t[12],A=t[13],S=t[14],N=i*m+u*E+l*O,I=a*m+s*E+f*O,M=o*m+c*E+h*O,C=i*_+u*T+l*w,x=a*_+s*T+f*w,P=o*_+c*T+h*w,U=i*R+u*g+l*b,D=a*R+s*g+f*b,q=o*R+c*g+h*b,L=i*v+u*A+l*S+d,j=a*v+s*A+f*S+p,F=o*v+c*A+h*S+y;return n[0]=N,n[1]=I,n[2]=M,n[3]=0,n[4]=C,n[5]=x,n[6]=P,n[7]=0,n[8]=U,n[9]=D,n[10]=q,n[11]=0,n[12]=L,n[13]=j,n[14]=F,n[15]=1,n},l.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],h=e[10],d=t[0],p=t[1],y=t[2],m=t[3],E=t[4],O=t[5],_=t[6],T=t[7],w=t[8],R=i*d+u*p+l*y,g=a*d+s*p+f*y,b=o*d+c*p+h*y,v=i*m+u*E+l*O,A=a*m+s*E+f*O,S=o*m+c*E+h*O,N=i*_+u*T+l*w,I=a*_+s*T+f*w,M=o*_+c*T+h*w;return n[0]=R,n[1]=g,n[2]=b,n[3]=0,n[4]=v,n[5]=A,n[6]=S,n[7]=0,n[8]=N,n[9]=I,n[10]=M,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},l.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;l.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,l.multiplyByScale(e,E,n)},l.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?l.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},l.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,l=e[2]*i+e[6]*a+e[10]*o+e[14]*u,f=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=l,n.w=f,n},l.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},l.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},l.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},l.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},l.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},l.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var O=new s,_=new s,T=new t,w=new t(0,0,0,1);return l.inverse=function(e,n){r.typeOf.object("matrix",e),r.typeOf.object("result",n);var i=e[0],a=e[4],o=e[8],f=e[12],h=e[1],d=e[5],p=e[9],y=e[13],m=e[2],E=e[6],R=e[10],g=e[14],b=e[3],v=e[7],A=e[11],S=e[15],N=R*S,I=g*A,M=E*S,C=g*v,x=E*A,P=R*v,U=m*S,D=g*b,q=m*A,L=R*b,j=m*v,F=E*b,B=N*d+C*p+x*y-(I*d+M*p+P*y),z=I*h+U*p+L*y-(N*h+D*p+q*y),G=M*h+D*d+j*y-(C*h+U*d+F*y),V=P*h+q*d+F*p-(x*h+L*d+j*p),X=I*a+M*o+P*f-(N*a+C*o+x*f),W=N*i+D*o+q*f-(I*i+U*o+L*f),H=C*i+U*a+F*f-(M*i+D*a+j*f),k=x*i+L*a+j*o-(P*i+q*a+F*o),Y=(N=o*y)*v+(C=f*d)*A+(x=a*p)*S-((I=f*p)*v+(M=a*y)*A+(P=o*d)*S),Z=I*b+(U=i*y)*A+(L=o*h)*S-(N*b+(D=f*h)*A+(q=i*p)*S),K=M*b+D*v+(j=i*d)*S-(C*b+U*v+(F=a*h)*S),J=P*b+q*v+F*A-(x*b+L*v+j*A),Q=M*R+P*g+I*E-(x*g+N*E+C*R),$=q*g+N*m+D*R-(U*R+L*g+I*m),ee=U*E+F*g+C*m-(j*g+M*m+D*E),te=j*R+x*m+L*E-(q*E+F*R+P*m),re=i*B+a*z+o*G+f*V;if(Math.abs(re)<u.EPSILON21){if(s.equalsEpsilon(l.getRotation(e,O),_,u.EPSILON7)&&t.equals(l.getRow(e,3,T),w))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;throw new c("matrix is not invertible because its determinate is zero.")}return re=1/re,n[0]=B*re,n[1]=z*re,n[2]=G*re,n[3]=V*re,n[4]=X*re,n[5]=W*re,n[6]=H*re,n[7]=k*re,n[8]=Y*re,n[9]=Z*re,n[10]=K*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},l.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],d=e[13],p=e[14],y=-n*h-i*d-a*p,m=-o*h-u*d-s*p,E=-c*h-l*d-f*p;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=l,t[7]=0,t[8]=a,t[9]=s,t[10]=f,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,a(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l})),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,h=0,d=e.length;h<d;h++){var p=e[h];i=Math.min(i,p.longitude),a=Math.max(a,p.longitude),l=Math.min(l,p.latitude),f=Math.max(f,p.latitude);var y=p.longitude>=0?p.longitude:p.longitude+u.TWO_PI;o=Math.min(o,y),c=Math.max(c,y)}return a-i>c-o&&(i=o,(a=c)>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=l,r.east=a,r.north=f,r):new s(i,l,a,f)},s.fromCartesianArray=function(e,i,o){t.defined("cartesians",e),i=r(i,a.WGS84);for(var c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=Number.MAX_VALUE,h=-Number.MAX_VALUE,d=Number.MAX_VALUE,p=-Number.MAX_VALUE,y=0,m=e.length;y<m;y++){var E=i.cartesianToCartographic(e[y]);c=Math.min(c,E.longitude),l=Math.max(l,E.longitude),d=Math.min(d,E.latitude),p=Math.max(p,E.latitude);var O=E.longitude>=0?E.longitude:E.longitude+u.TWO_PI;f=Math.min(f,O),h=Math.max(h,O)}return l-c>h-f&&(c=f,(l=h)>u.PI&&(l-=u.TWO_PI),c>u.PI&&(c-=u.TWO_PI)),n(o)?(o.west=c,o.south=d,o.east=l,o.north=p,o):new s(c,d,l,p)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("absoluteEpsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.west-r.west)<=i&&Math.abs(e.south-r.south)<=i&&Math.abs(e.east-r.east)<=i&&Math.abs(e.north-r.north)<=i},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),s.equalsEpsilon(this,e,r)},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;a<o&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,l=r.west;a<o&&c>0?a+=u.TWO_PI:c<l&&a>0&&(c+=u.TWO_PI),a<o&&l<0?l+=u.TWO_PI:c<l&&o<0&&(o+=u.TWO_PI);var f=u.negativePiToPi(Math.max(o,l)),h=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&h<=f)){var d=Math.max(e.south,r.south),p=Math.min(e.north,r.north);if(!(d>=p))return n(i)?(i.west=f,i.south=d,i.east=h,i.north=p,i):new s(f,d,h,p)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(o>=c||a>=u))return n(i)?(i.west=a,i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,l=r.west;a<o&&c>0?a+=u.TWO_PI:c<l&&a>0&&(c+=u.TWO_PI),a<o&&l<0?l+=u.TWO_PI:c<l&&o<0&&(o+=u.TWO_PI);var f=u.convertLongitudeRange(Math.min(o,l)),h=u.convertLongitudeRange(Math.max(a,c));return i.west=f,i.south=Math.min(e.south,r.south),i.east=h,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return o<a&&(o+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(n<o||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,l){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(l)||(l=[]);var f=0,h=e.north,d=e.south,p=e.east,y=e.west,m=c;m.height=o,m.longitude=y,m.latitude=h,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=p,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.latitude=d,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.latitude=h<0?h:d>0?d:0;for(var E=1;E<8;++E)m.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,m)&&(l[f]=i.cartographicToCartesian(m,l[f]),f++);return 0===m.latitude&&(m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=p,l[f]=i.cartographicToCartesian(m,l[f]),f++),l.length=f,l},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s})),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Math","./Matrix3","./Matrix4","./Rectangle"],(function(e,t,r,n,i,a,o,u,s,c,l,f,h){"use strict";function d(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var p=new e,y=new e,m=new e,E=new e,O=new e,_=new e,T=new e,w=new e,R=new e,g=new e,b=new e,v=new e,A=4/3*c.PI;d.fromPoints=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n,a=e.clone(t[0],T),o=e.clone(a,p),u=e.clone(a,y),s=e.clone(a,m),c=e.clone(a,E),l=e.clone(a,O),f=e.clone(a,_),h=t.length;for(n=1;n<h;n++){e.clone(t[n],a);var A=a.x,S=a.y,N=a.z;A<o.x&&e.clone(a,o),A>c.x&&e.clone(a,c),S<u.y&&e.clone(a,u),S>l.y&&e.clone(a,l),N<s.z&&e.clone(a,s),N>f.z&&e.clone(a,f)}var I=e.magnitudeSquared(e.subtract(c,o,w)),M=e.magnitudeSquared(e.subtract(l,u,w)),C=e.magnitudeSquared(e.subtract(f,s,w)),x=o,P=c,U=I;M>U&&(U=M,x=u,P=l),C>U&&(U=C,x=s,P=f);var D=R;D.x=.5*(x.x+P.x),D.y=.5*(x.y+P.y),D.z=.5*(x.z+P.z);var q=e.magnitudeSquared(e.subtract(P,D,w)),L=Math.sqrt(q),j=g;j.x=o.x,j.y=u.y,j.z=s.z;var F=b;F.x=c.x,F.y=l.y,F.z=f.z;var B=e.midpoint(j,F,v),z=0;for(n=0;n<h;n++){e.clone(t[n],a);var G=e.magnitude(e.subtract(a,B,w));G>z&&(z=G);var V=e.magnitudeSquared(e.subtract(a,D,w));if(V>q){var X=Math.sqrt(V);q=(L=.5*(L+X))*L;var W=X-L;D.x=(L*D.x+W*a.x)/X,D.y=(L*D.y+W*a.y)/X,D.z=(L*D.z+W*a.z)/X}}return L<z?(e.clone(D,r.center),r.radius=L):(e.clone(B,r.center),r.radius=z),r};var S=new o,N=new e,I=new e,M=new t,C=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new d),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,S),h.southwest(t,M),M.height=a,h.northeast(t,C),C.height=o;var s=r.project(M,N),c=r.project(C,I),l=c.x-s.x,f=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(l*l+f*f+p*p);var y=u.center;return y.x=s.x+.5*l,y.y=s.y+.5*f,y.z=s.z+.5*p,u};var x=[];d.fromRectangle3D=function(t,r,o,u){if(r=n(r,a.WGS84),o=n(o,0),i(u)||(u=new d),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;var s=h.subsample(t,r,o,x);return d.fromPoints(s,u)},d.fromVertices=function(t,a,o,u){if(i(u)||(u=new d),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=T;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;var c,l=e.clone(s,p),f=e.clone(s,y),h=e.clone(s,m),A=e.clone(s,E),S=e.clone(s,O),N=e.clone(s,_),I=t.length;for(c=0;c<I;c+=o){var M=t[c]+a.x,C=t[c+1]+a.y,x=t[c+2]+a.z;s.x=M,s.y=C,s.z=x,M<l.x&&e.clone(s,l),M>A.x&&e.clone(s,A),C<f.y&&e.clone(s,f),C>S.y&&e.clone(s,S),x<h.z&&e.clone(s,h),x>N.z&&e.clone(s,N)}var P=e.magnitudeSquared(e.subtract(A,l,w)),U=e.magnitudeSquared(e.subtract(S,f,w)),D=e.magnitudeSquared(e.subtract(N,h,w)),q=l,L=A,j=P;U>j&&(j=U,q=f,L=S),D>j&&(j=D,q=h,L=N);var F=R;F.x=.5*(q.x+L.x),F.y=.5*(q.y+L.y),F.z=.5*(q.z+L.z);var B=e.magnitudeSquared(e.subtract(L,F,w)),z=Math.sqrt(B),G=g;G.x=l.x,G.y=f.y,G.z=h.z;var V=b;V.x=A.x,V.y=S.y,V.z=N.z;var X=e.midpoint(G,V,v),W=0;for(c=0;c<I;c+=o){s.x=t[c]+a.x,s.y=t[c+1]+a.y,s.z=t[c+2]+a.z;var H=e.magnitude(e.subtract(s,X,w));H>W&&(W=H);var k=e.magnitudeSquared(e.subtract(s,F,w));if(k>B){var Y=Math.sqrt(k);B=(z=.5*(z+Y))*z;var Z=Y-z;F.x=(z*F.x+Z*s.x)/Y,F.y=(z*F.y+Z*s.y)/Y,F.z=(z*F.z+Z*s.z)/Y}}return z<W?(e.clone(F,u.center),u.radius=z):(e.clone(X,u.center),u.radius=W),u},d.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new d),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=T;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];var o,u=e.clone(a,p),s=e.clone(a,y),c=e.clone(a,m),l=e.clone(a,E),f=e.clone(a,O),h=e.clone(a,_),A=t.length;for(o=0;o<A;o+=3){var S=t[o]+r[o],N=t[o+1]+r[o+1],I=t[o+2]+r[o+2];a.x=S,a.y=N,a.z=I,S<u.x&&e.clone(a,u),S>l.x&&e.clone(a,l),N<s.y&&e.clone(a,s),N>f.y&&e.clone(a,f),I<c.z&&e.clone(a,c),I>h.z&&e.clone(a,h)}var M=e.magnitudeSquared(e.subtract(l,u,w)),C=e.magnitudeSquared(e.subtract(f,s,w)),x=e.magnitudeSquared(e.subtract(h,c,w)),P=u,U=l,D=M;C>D&&(D=C,P=s,U=f),x>D&&(D=x,P=c,U=h);var q=R;q.x=.5*(P.x+U.x),q.y=.5*(P.y+U.y),q.z=.5*(P.z+U.z);var L=e.magnitudeSquared(e.subtract(U,q,w)),j=Math.sqrt(L),F=g;F.x=u.x,F.y=s.y,F.z=c.z;var B=b;B.x=l.x,B.y=f.y,B.z=h.z;var z=e.midpoint(F,B,v),G=0;for(o=0;o<A;o+=3){a.x=t[o]+r[o],a.y=t[o+1]+r[o+1],a.z=t[o+2]+r[o+2];var V=e.magnitude(e.subtract(a,z,w));V>G&&(G=V);var X=e.magnitudeSquared(e.subtract(a,q,w));if(X>L){var W=Math.sqrt(X);L=(j=.5*(j+W))*j;var H=W-j;q.x=(j*q.x+H*a.x)/W,q.y=(j*q.y+H*a.y)/W,q.z=(j*q.z+H*a.z)/W}}return j<G?(e.clone(q,n.center),n.radius=j):(e.clone(z,n.center),n.radius=G),n},d.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new d);var o=e.midpoint(t,n,a.center);return a.radius=e.distance(o,n),a},d.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var P=new e;d.fromBoundingSpheres=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return d.clone(t[0],r);if(2===n)return d.union(t[0],t[1],r);var a,o=[];for(a=0;a<n;a++)o.push(t[a].center);var u=(r=d.fromPoints(o,r)).center,s=r.radius;for(a=0;a<n;a++){var c=t[a];s=Math.max(s,e.distance(u,c.center,P)+c.radius)}return r.radius=s,r};var U=new e,D=new e,q=new e;d.fromOrientedBoundingBox=function(t,n){r.defined("orientedBoundingBox",t),i(n)||(n=new d);var a=t.halfAxes,o=l.getColumn(a,0,U),u=l.getColumn(a,1,D),s=l.getColumn(a,2,q);return e.add(o,u,o),e.add(o,s,o),n.center=e.clone(t.center,n.center),n.radius=e.magnitude(o),n},d.clone=function(t,r){if(i(t))return i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius)},d.packedLength=4,d.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},d.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new d);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var L=new e,j=new e;d.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new d);var o=t.center,u=t.radius,s=n.center,c=n.radius,l=e.subtract(s,o,L),f=e.magnitude(l);if(u>=f+c)return t.clone(a),a;if(c>=f+u)return n.clone(a),a;var h=.5*(u+f+c),p=e.multiplyByScalar(l,(-u+h)/f,j);return e.add(p,o,p),e.clone(p,a.center),a.radius=h,a};var F=new e;d.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=d.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,F));return a>i.radius&&(i.radius=a),i},d.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return s<-a?u.OUTSIDE:s<a?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=f.getMaximumScale(t)*e.radius,n};var B=new e;d.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,B);return e.magnitudeSquared(i)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;d.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,z),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var G=new e,V=new e,X=new e,W=new e,H=new e,k=new t,Y=new Array(8),Z=0;Z<8;++Z)Y[Z]=new e;var K=new o;return d.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t);var o=(i=n(i,K)).ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,G),l=e.cross(e.UNIT_Z,c,V);e.normalize(l,l);var f=e.cross(c,l,X);e.normalize(f,f),e.multiplyByScalar(c,s,c),e.multiplyByScalar(f,s,f),e.multiplyByScalar(l,s,l);var h=e.negate(f,H),p=e.negate(l,W),y=Y,m=y[0];e.add(c,f,m),e.add(m,l,m),m=y[1],e.add(c,f,m),e.add(m,p,m),m=y[2],e.add(c,h,m),e.add(m,p,m),m=y[3],e.add(c,h,m),e.add(m,l,m),e.negate(c,c),m=y[4],e.add(c,f,m),e.add(m,l,m),m=y[5],e.add(c,f,m),e.add(m,p,m),m=y[6],e.add(c,h,m),e.add(m,p,m),m=y[7],e.add(c,h,m),e.add(m,l,m);for(var E=y.length,O=0;O<E;++O){var _=y[O];e.add(u,_,_);var T=o.cartesianToCartographic(_,k);i.project(T,_)}var w=(u=(a=d.fromPoints(y,a)).center).x,R=u.y,g=u.z;return u.x=g,u.y=w,u.z=R,a},d.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d.prototype.volume=function(){var e=this.radius;return A*e*e*e},d})),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],(function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;a<i;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;a<i;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l),a.acosClamped(o.dot(c,l))};var f=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o})),define("Core/GeographicTilingScheme",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./GeographicProjection","./Math","./Rectangle"],(function(e,t,r,n,i,a,o,u,s){"use strict";function c(e){e=r(e,{}),this._ellipsoid=r(e.ellipsoid,a.WGS84),this._rectangle=r(e.rectangle,s.MAX_VALUE),this._projection=new o(this._ellipsoid),this._numberOfLevelZeroTilesX=r(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=r(e.numberOfLevelZeroTilesY,1)}return i(c.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),c.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},c.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},c.prototype.rectangleToNativeRectangle=function(e,r){t.defined("rectangle",e);var i=u.toDegrees(e.west),a=u.toDegrees(e.south),o=u.toDegrees(e.east),c=u.toDegrees(e.north);return n(r)?(r.west=i,r.south=a,r.east=o,r.north=c,r):new s(i,a,o,c)},c.prototype.tileXYToNativeRectangle=function(e,t,r,n){var i=this.tileXYToRectangle(e,t,r,n);return i.west=u.toDegrees(i.west),i.south=u.toDegrees(i.south),i.east=u.toDegrees(i.east),i.north=u.toDegrees(i.north),i},c.prototype.tileXYToRectangle=function(e,t,r,i){var a=this._rectangle,o=this.getNumberOfXTilesAtLevel(r),u=this.getNumberOfYTilesAtLevel(r),c=a.width/o,l=e*c+a.west,f=(e+1)*c+a.west,h=a.height/u,d=a.north-t*h,p=a.north-(t+1)*h;return n(i)||(i=new s(l,p,f,d)),i.west=l,i.south=p,i.east=f,i.north=d,i},c.prototype.positionToTileXY=function(t,r,i){var a=this._rectangle;if(s.contains(a,t)){var o=this.getNumberOfXTilesAtLevel(r),c=this.getNumberOfYTilesAtLevel(r),l=a.width/o,f=a.height/c,h=t.longitude;a.east<a.west&&(h+=u.TWO_PI);var d=(h-a.west)/l|0;d>=o&&(d=o-1);var p=(a.north-t.latitude)/f|0;return p>=c&&(p=c-1),n(i)?(i.x=d,i.y=p,i):new e(d,p)}},c})),define("Core/ApproximateTerrainHeights",["./buildModuleUrl","./defaultValue","./defined","./defineProperties","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./Check","./DeveloperError","./Ellipsoid","./GeographicTilingScheme","./Rectangle","./Resource"],(function(e,t,r,n,i,a,o,u,s,c,l,f,h,d){"use strict";var p=new o,y=new o,m=new u,E=new o,O=new o,_=new i,T=new f,w=[new u,new u,new u,new u],R=new a,g={};function b(e){u.fromRadians(e.east,e.north,0,w[0]),u.fromRadians(e.west,e.north,0,w[1]),u.fromRadians(e.east,e.south,0,w[2]),u.fromRadians(e.west,e.south,0,w[3]);var t,r=0,n=0,i=0,a=0,o=g._terrainHeightsMaxLevel;for(t=0;t<=o;++t){for(var s=!1,c=0;c<4;++c){var l=w[c];if(T.positionToTileXY(l,t,R),0===c)i=R.x,a=R.y;else if(i!==R.x||a!==R.y){s=!0;break}}if(s)break;r=i,n=a}if(0!==t)return{x:r,y:n,level:t>o?o:t-1}}return g.initialize=function(){var t=g._initPromise;return r(t)||(t=d.fetchJson(e("Assets/approximateTerrainHeights.json")).then((function(e){g._terrainHeights=e})),g._initPromise=t),t},g.getMinimumMaximumHeights=function(e,n){if(s.defined("rectangle",e),!r(g._terrainHeights))throw new c("You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function");n=t(n,l.WGS84);var i=b(e),a=g._defaultMinTerrainHeight,u=g._defaultMaxTerrainHeight;if(r(i)){var f=i.level+"-"+i.x+"-"+i.y,d=g._terrainHeights[f];r(d)&&(a=d[0],u=d[1]),n.cartographicToCartesian(h.northeast(e,m),p),n.cartographicToCartesian(h.southwest(e,m),y),o.midpoint(y,p,E);var _=n.scaleToGeodeticSurface(E,O);if(r(_)){var T=o.distance(E,_);a=Math.min(a,-T)}else a=g._defaultMinTerrainHeight}return{minimumTerrainHeight:a=Math.max(g._defaultMinTerrainHeight,a),maximumTerrainHeight:u}},g.getBoundingSphere=function(e,n){if(s.defined("rectangle",e),!r(g._terrainHeights))throw new c("You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function");n=t(n,l.WGS84);var a=b(e),o=g._defaultMaxTerrainHeight;if(r(a)){var u=a.level+"-"+a.x+"-"+a.y,f=g._terrainHeights[u];r(f)&&(o=f[1])}var h=i.fromRectangle3D(e,n,0);return i.fromRectangle3D(e,n,o,_),i.union(h,_,h)},g._terrainHeightsMaxLevel=6,g._defaultMaxTerrainHeight=9e3,g._defaultMinTerrainHeight=-1e5,g._terrainHeights=void 0,g._initPromise=void 0,n(g,{initialized:{get:function(){return r(g._terrainHeights)}}}),g})),define("Core/arrayRemoveDuplicates",["./Check","./defaultValue","./defined","./Math"],(function(e,t,r,n){"use strict";var i=n.EPSILON10;return function(n,a,o){if(e.defined("equalsEpsilon",a),r(n)){o=t(o,!1);var u,s,c,l=n.length;if(l<2)return n;for(u=1;u<l&&!a(s=n[u-1],c=n[u],i);++u);if(u===l)return o&&a(n[0],n[n.length-1],i)?n.slice(1):n;for(var f=n.slice(0,u);u<l;++u)a(s,c=n[u],i)||(f.push(c),s=c);return o&&f.length>1&&a(f[0],f[f.length-1],i)&&f.shift(),f}}})),define("Core/Fullscreen",["./defined","./defineProperties"],(function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;o<u;++o){var s=a[o];("function"==typeof t[i=s+"RequestFullscreen"]||"function"==typeof t[i=s+"RequestFullScreen"])&&(n.requestFullscreen=i,r=!0),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i})),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],(function(e,t,r){"use strict";var n,i,a,o,u,s,c,l,f,h,d,p,y,m,E,O,_;function T(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function w(){if(!t(i)&&(i=!1,!v())){var e=/ Chrome\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(i=!0,a=T(e[1]))}return i}function R(){if(!t(o)&&(o=!1,!w()&&!v()&&/ Safari\/[\.0-9]+/.test(n.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(o=!0,u=T(e[1]))}return o}function g(){if(!t(s)){s=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(n.userAgent);null!==e&&(s=!0,(c=T(e[1])).isNightly=!!e[2])}return s}function b(){var e;return t(l)||(l=!1,"Microsoft Internet Explorer"===n.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(l=!0,f=T(e[1])):"Netscape"===n.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(n.userAgent))&&(l=!0,f=T(e[1]))),l}function v(){if(!t(h)){h=!1;var e=/ Edge\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(h=!0,d=T(e[1]))}return h}function A(){if(!t(p)){p=!1;var e=/Firefox\/([\.0-9]+)/.exec(n.userAgent);null!==e&&(p=!0,y=T(e[1]))}return p}function S(){if(!t(_)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;(_=t(r)&&""!==r)&&(O=r)}return _}n="undefined"!=typeof navigator?navigator:{};var N=[];"undefined"!=typeof ArrayBuffer&&(N.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&N.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&N.push(CanvasPixelArray));var I={isChrome:w,chromeVersion:function(){return w()&&a},isSafari:R,safariVersion:function(){return R()&&u},isWebkit:g,webkitVersion:function(){return g()&&c},isInternetExplorer:b,internetExplorerVersion:function(){return b()&&f},isEdge:v,edgeVersion:function(){return v()&&d},isFirefox:A,firefoxVersion:function(){return A()&&y},isWindows:function(){return t(m)||(m=/Windows/i.test(n.appVersion)),m},hardwareConcurrency:e(n.hardwareConcurrency,3),supportsPointerEvents:function(){return t(E)||(E=!A()&&"undefined"!=typeof PointerEvent&&(!t(n.pointerEnabled)||n.pointerEnabled)),E},supportsImageRenderingPixelated:S,imageRenderingValue:function(){return S()?O:void 0},typedArrayTypes:N,supportsFullscreen:function(){return r.supportsFullscreen()},supportsTypedArrays:function(){return"undefined"!=typeof ArrayBuffer},supportsWebWorkers:function(){return"undefined"!=typeof Worker},supportsWebAssembly:function(){return"undefined"!=typeof WebAssembly&&!I.isEdge()}};return I})),define("Core/WebGLConstants",["./freezeObject"],(function(e){"use strict";return e({DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047})})),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],(function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE,getSizeInBytes:function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},fromTypedArray:function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},validate:function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},createTypedArray:function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},createArrayBufferView:function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},fromName:function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}}};return i(o)})),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Math"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,r,n,i,a,o){var u=function(e,t){return e*t*(4+e*(4-3*t))/16}(e,r);return(1-u)*e*t*(n+u*i*(o+u*a*(2*o*o-1)))}var c=new e,l=new e;function f(n,i,a,o){var f=e.normalize(o.cartographicToCartesian(i,l),c),h=e.normalize(o.cartographicToCartesian(a,l),l);r.typeOf.number.greaterThanOrEquals("value",Math.abs(Math.abs(e.angleBetween(f,h))-Math.PI),.0125),function(e,t,r,n,i,a,o){var c,l,f,h,d,p=(t-r)/t,y=a-n,m=Math.atan((1-p)*Math.tan(i)),E=Math.atan((1-p)*Math.tan(o)),O=Math.cos(m),_=Math.sin(m),T=Math.cos(E),w=Math.sin(E),R=O*T,g=O*w,b=_*w,v=_*T,A=y,S=u.TWO_PI,N=Math.cos(A),I=Math.sin(A);do{N=Math.cos(A),I=Math.sin(A);var M,C=g-v*N;f=Math.sqrt(T*T*I*I+C*C),l=b+R*N,c=Math.atan2(f,l),0===f?(M=0,h=1):h=1-(M=R*I/f)*M,S=A,d=l-2*b/h,isNaN(d)&&(d=0),A=y+s(p,M,h,c,f,l,d)}while(Math.abs(A-S)>u.EPSILON12);var x=h*(t*t-r*r)/(r*r),P=x*(256+x*(x*(74-47*x)-128))/1024,U=d*d,D=r*(1+x*(4096+x*(x*(320-175*x)-768))/16384)*(c-P*f*(d+P*(l*(2*U-1)-P*d*(4*f*f-3)*(4*U-3)/6)/4)),q=Math.atan2(T*I,g-v*N),L=Math.atan2(O*I,g*N-v);e._distance=D,e._startHeading=q,e._endHeading=L,e._uSquared=x}(n,o.maximumRadius,o.minimumRadius,i.longitude,i.latitude,a.longitude,a.latitude),n._start=t.clone(i,n._start),n._end=t.clone(a,n._end),n._start.height=0,n._end.height=0,function(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(r-n)/r,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-i)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),c=s*u,l=Math.atan2(u,a),f=s*o,h=f*f,d=1-h,p=Math.sqrt(d),y=t/4,m=y*y,E=m*y,O=m*m,_=1+y-3*m/4+5*E/4-175*O/64,T=1-y+15*m/8-35*E/8,w=1-3*y+35*m/4,R=1-5*y,g=_*l-T*Math.sin(2*l)*y/2-w*Math.sin(4*l)*m/16-R*Math.sin(6*l)*E/48-5*Math.sin(8*l)*O/512,b=e._constants;b.a=r,b.b=n,b.f=i,b.cosineHeading=a,b.sineHeading=o,b.tanU=u,b.cosineU=s,b.sineU=c,b.sigma=l,b.sineAlpha=f,b.sineSquaredAlpha=h,b.cosineSquaredAlpha=d,b.cosineAlpha=p,b.u2Over4=y,b.u4Over16=m,b.u6Over64=E,b.u8Over256=O,b.a0=_,b.a1=T,b.a2=w,b.a3=R,b.distanceRatio=g}(n)}function h(e,r,a){var u=n(a,o.WGS84);this._ellipsoid=u,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,i(e)&&i(r)&&f(this,e,r,u)}return a(h.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return r.defined("distance",this._distance),this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return r.defined("distance",this._distance),this._startHeading}},endHeading:{get:function(){return r.defined("distance",this._distance),this._endHeading}}}),h.prototype.setEndPoints=function(e,t){r.defined("start",e),r.defined("end",t),f(this,e,t,this._ellipsoid)},h.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},h.prototype.interpolateUsingSurfaceDistance=function(e,n){r.defined("distance",this._distance);var a=this._constants,o=a.distanceRatio+e/a.b,u=Math.cos(2*o),c=Math.cos(4*o),l=Math.cos(6*o),f=Math.sin(2*o),h=Math.sin(4*o),d=Math.sin(6*o),p=Math.sin(8*o),y=o*o,m=o*y,E=a.u8Over256,O=a.u2Over4,_=a.u6Over64,T=a.u4Over16,w=2*m*E*u/3+o*(1-O+7*T/4-15*_/4+579*E/64-(T-15*_/4+187*E/16)*u-(5*_/4-115*E/16)*c-29*E*l/16)+(O/2-T+71*_/32-85*E/16)*f+(5*T/16-5*_/4+383*E/96)*h-y*((_-11*E/2)*f+5*E*h/2)+(29*_/96-29*E/16)*d+539*E*p/1536,R=Math.asin(Math.sin(w)*a.cosineAlpha),g=Math.atan(a.a/a.b*Math.tan(R));w-=a.sigma;var b=Math.cos(2*a.sigma+w),v=Math.sin(w),A=Math.cos(w),S=a.cosineU*A,N=a.sineU*v,I=Math.atan2(v*a.sineHeading,S-N*a.cosineHeading)-s(a.f,a.sineAlpha,a.cosineSquaredAlpha,w,v,A,b);return i(n)?(n.longitude=this._start.longitude+I,n.latitude=g,n.height=0,n):new t(this._start.longitude+I,g,0)},h})),define("Core/EncodedCartesian3",["./Cartesian3","./Check","./defined"],(function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,n){var i;return t.typeOf.number("value",e),r(n)||(n={high:0,low:0}),e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){t.typeOf.object("cartesian",e),r(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,r,i){t.defined("cartesianArray",r),t.typeOf.number("index",i),t.typeOf.number.greaterThanOrEquals("index",i,0),n.fromCartesian(e,a);var o=a.high,u=a.low;r[i]=o.x,r[i+1]=o.y,r[i+2]=o.z,r[i+3]=u.x,r[i+4]=u.y,r[i+5]=u.z},n})),define("Core/GeometryOffsetAttribute",["../Core/freezeObject"],(function(e){"use strict";return e({NONE:0,TOP:1,ALL:2})})),define("Core/GeometryType",["./freezeObject"],(function(e){"use strict";return e({NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3})})),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],(function(e,t,r,n,i,a){"use strict";function o(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}o.packedLength=4,o.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},o.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a},o.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3])},o.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a},o.fromColumnMajorArray=function(e,r){return t.defined("values",e),o.clone(e,r)},o.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new o(e,0,0,e)},o.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=-a,r[3]=i,r):new o(i,-a,a,i)},o.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},o.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,a=e[i],o=e[i+1];return n.x=a,n.y=o,n},o.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i);var a=2*r;return(i=o.clone(e,i))[a]=n.x,i[a+1]=n.y,i},o.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],a=e[r+2];return n.x=i,n.y=a,n},o.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),(i=o.clone(e,i))[r]=n.x,i[r+2]=n.y,i};var u=new e;o.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],a=e[0]*r[2]+e[2]*r[3],o=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n},o.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},o.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},o.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,a=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=a,n},o.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},o.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},o.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},o.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],a=e[1],o=e[3];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r},o.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},o.IDENTITY=a(new o(1,0,0,1)),o.ZERO=a(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,i(o.prototype,{length:{get:function(){return o.packedLength}}}),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o})),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],(function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)})),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./FeatureDetection","./freezeObject","./Math","./Matrix3"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var c=new e;s.fromAxisAngle=function(r,i,a){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var o=i/2,u=Math.sin(o),l=(c=e.normalize(r,c)).x*u,f=c.y*u,h=c.z*u,d=Math.cos(o);return n(a)?(a.x=l,a.y=f,a.z=h,a.w=d,a):new s(l,f,h,d)};var l=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,r){var i,a,o,c,h;t.typeOf.object("matrix",e);var d=e[u.COLUMN0ROW0],p=e[u.COLUMN1ROW1],y=e[u.COLUMN2ROW2],m=d+p+y;if(m>0)h=.5*(i=Math.sqrt(m+1)),i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var E=0;p>d&&(E=1),y>d&&y>p&&(E=2);var O=l[E],_=l[O];i=Math.sqrt(e[u.getElementIndex(E,E)]-e[u.getElementIndex(O,O)]-e[u.getElementIndex(_,_)]+1);var T=f;T[E]=.5*i,i=.5/i,h=(e[u.getElementIndex(_,O)]-e[u.getElementIndex(O,_)])*i,T[O]=(e[u.getElementIndex(O,E)]+e[u.getElementIndex(E,O)])*i,T[_]=(e[u.getElementIndex(_,E)]+e[u.getElementIndex(E,_)])*i,a=-T[0],o=-T[1],c=-T[2]}return n(r)?(r.x=a,r.y=o,r.z=c,r.w=h,r):new s(a,o,c,h)};var h=new s,d=new s,p=new s,y=new s;s.fromHeadingPitchRoll=function(r,n){return t.typeOf.object("headingPitchRoll",r),y=s.fromAxisAngle(e.UNIT_X,r.roll,h),p=s.fromAxisAngle(e.UNIT_Y,-r.pitch,n),n=s.multiply(p,y,p),d=s.fromAxisAngle(e.UNIT_Z,-r.heading,h),s.multiply(d,n,n)};var m=new e,E=new e,O=new s,_=new s,T=new s;s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,t,r,n){s.unpack(e,4*r,T),s.conjugate(T,T);for(var i=0,a=r-t+1;i<a;i++){var o=3*i;s.unpack(e,4*(t+i),O),s.multiply(O,T,O),O.w<0&&s.negate(O,O),s.computeAxis(O,m);var u=s.computeAngle(O);n[o]=m.x*u,n[o+1]=m.y*u,n[o+2]=m.z*u}},s.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new s),e.fromArray(t,0,E);var u=e.magnitude(E);return s.unpack(r,4*a,_),0===u?s.clone(s.IDENTITY,O):s.fromAxisAngle(E,u,O),s.multiply(O,_,o)},s.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new s(e.x,e.y,e.z,e.w)},s.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){t.typeOf.object("result",r);var n=1/s.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return r.x=i,r.y=a,r.z=o,r.w=u,r},s.inverse=function(e,r){t.typeOf.object("result",r);var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,a=e.y,o=e.z,u=e.w,s=r.x,c=r.y,l=r.z,f=r.w,h=u*s+i*f+a*l-o*c,d=u*c-i*l+a*f+o*s,p=u*l+i*c-a*s+o*f,y=u*f-i*s-a*c-o*l;return n.x=h,n.y=d,n.z=p,n.w=y,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},s.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var w=new s;s.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),w=s.multiplyByScalar(r,n,w),i=s.multiplyByScalar(e,1-n,i),s.add(w,i,i)};var R=new s,g=new s,b=new s;s.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a=s.dot(e,r),u=r;if(a<0&&(a=-a,u=R=s.negate(r,R)),1-a<o.EPSILON6)return s.lerp(e,u,n,i);var c=Math.acos(a);return g=s.multiplyByScalar(e,Math.sin((1-n)*c),g),b=s.multiplyByScalar(u,Math.sin(n*c),b),i=s.add(g,b,i),s.multiplyByScalar(i,1/Math.sin(c),i)},s.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=o.acosClamped(r.w),a=0;return 0!==i&&(a=i/Math.sin(i)),e.multiplyByScalar(r,a,n)},s.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),a=0;return 0!==i&&(a=Math.sin(i)/i),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(i),n};var v=new e,A=new e,S=new s,N=new s;s.computeInnerQuadrangle=function(r,n,i,a){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",a);var o=s.conjugate(n,S);s.multiply(o,i,N);var u=s.log(N,v);s.multiply(o,r,N);var c=s.log(N,A);return e.add(u,c,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),s.exp(u,S),s.multiply(n,S,a)},s.squad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.slerp(e,r,a,S),c=s.slerp(n,i,a,N);return s.slerp(u,c,2*a*(1-a),o)};for(var I=new s,M=1.9011074535173003,C=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],P=i.supportsTypedArrays()?new Float32Array(8):[],U=i.supportsTypedArrays()?new Float32Array(8):[],D=0;D<7;++D){var q=D+1,L=2*q+1;C[D]=1/(q*L),x[D]=q/L}return C[7]=M/136,x[7]=8*M/17,s.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a,o=s.dot(e,r);o>=0?a=1:(a=-1,o=-o);for(var u=o-1,c=1-n,l=n*n,f=c*c,h=7;h>=0;--h)P[h]=(C[h]*l-x[h])*u,U[h]=(C[h]*f-x[h])*u;var d=a*n*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),p=c*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),y=s.multiplyByScalar(e,p,I);return s.multiplyByScalar(r,d,i),s.add(y,i,i)},s.fastSquad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=s.fastSlerp(e,r,a,S),c=s.fastSlerp(n,i,a,N);return s.fastSlerp(u,c,2*a*(1-a),o)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s})),define("Core/binarySearch",["./Check"],(function(e){"use strict";return function(t,r,n){e.defined("array",t),e.defined("itemToFind",r),e.defined("comparator",n);for(var i,a,o=0,u=t.length-1;o<=u;)if((a=n(t[i=~~((o+u)/2)],r))<0)o=i+1;else{if(!(a>0))return i;u=i-1}return~(u+1)}})),define("Core/EarthOrientationParametersSample",[],(function(){"use strict";return function(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}})),
/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/
define("ThirdParty/sprintf",[],(function(){return function(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var u=n-e.length;return u>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return e=(r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"")+i(c.toString(t),u||0,"0",!1),a(e,r,n,o,s)},u=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},s=function(e,n,s,c,l,f,h){var d,p,y,m,E;if("%%"==e)return"%";for(var O=!1,_="",T=!1,w=!1,R=" ",g=s.length,b=0;s&&b<g;b++)switch(s.charAt(b)){case" ":_=" ";break;case"+":_="+";break;case"-":O=!0;break;case"'":R=s.charAt(b+1);break;case"0":T=!0;break;case"#":w=!0}if((c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0)<0&&(c=-c,O=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],h){case"s":return u(String(E),O,c,f,T,R);case"c":return u(String.fromCharCode(+E),O,c,f,T);case"b":return o(E,2,w,O,c,f,T);case"o":return o(E,8,w,O,c,f,T);case"x":return o(E,16,w,O,c,f,T);case"X":return o(E,16,w,O,c,f,T).toUpperCase();case"u":return o(E,10,w,O,c,f,T);case"i":case"d":return d=+E||0,E=(p=(d=Math.round(d-d%1))<0?"-":_)+i(String(Math.abs(d)),f,"0",!1),a(E,p,O,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return p=(d=+E)<0?"-":_,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],E=p+Math.abs(d)[y](f),a(E,p,O,c,T)[m]();default:return e}};return n.replace(e,s)}})),define("Core/GregorianDate",[],(function(){"use strict";return function(e,t,r,n,i,a,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u}})),define("Core/isLeapYear",["./DeveloperError"],(function(e){"use strict";return function(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4==0&&t%100!=0||t%400==0}})),define("Core/LeapSecond",[],(function(){"use strict";return function(e,t){this.julianDate=e,this.offset=t}})),define("Core/TimeConstants",["./freezeObject"],(function(e){"use strict";return e({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5})})),define("Core/TimeStandard",["./freezeObject"],(function(e){"use strict";return e({UTC:0,TAI:1})})),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,a,o,u,s,c){"use strict";var l=new a,f=[31,28,31,30,31,30,31,31,30,31,30,31];function h(e,t){return N.compare(e.julianDate,t.julianDate)}var d=new u;function p(e){d.julianDate=e;var r=N.leapSeconds,n=t(r,d,h);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;n>0&&N.secondsDifference(r[n].julianDate,e)>i&&(i=r[--n].offset),N.addSeconds(e,i,e)}function y(e,r){d.julianDate=e;var n=N.leapSeconds,i=t(n,d,h);if(i<0&&(i=~i),0===i)return N.addSeconds(e,-n[0].offset,r);if(i>=n.length)return N.addSeconds(e,-n[i-1].offset,r);var a=N.secondsDifference(n[i].julianDate,e);return 0===a?N.addSeconds(e,-n[i].offset,r):a<=1?void 0:N.addSeconds(e,-n[--i].offset,r)}function m(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,(t-=s.SECONDS_PER_DAY*n)<0&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function E(e,t,r,n,i,a,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;(n-=12)<0&&(n+=24);var f=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}var O=/^(\d{4})$/,_=/^(\d{4})-(\d{2})$/,T=/^(\d{4})-?(\d{3})$/,w=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,R=/^(\d{4})-?(\d{2})-?(\d{2})$/,g=/([Z+\-])?(\d{2})?:?(\d{2})?$/,b=/^(\d{2})(\.\d+)?/.source+g.source,v=/^(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,A=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,S="Invalid ISO 8601 date.";function N(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;m(i,t+=(e-i)*s.SECONDS_PER_DAY,this),n===c.UTC&&p(this)}N.fromGregorianDate=function(e,t){if(!(e instanceof a))throw new i("date must be a valid GregorianDate.");var r=E(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return n(t)?(m(r[0],r[1],t),p(t),t):new N(r[0],r[1],c.UTC)},N.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=E(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(m(r[0],r[1],t),p(t),t):new N(r[0],r[1],c.UTC)},N.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(S);var r,a,u,s,l,h=(e=e.replace(",",".")).split("T"),d=1,y=1,g=0,I=0,M=0,C=0,x=h[0],P=h[1];if(!n(x))throw new i(S);if(null!==(h=x.match(R))){if((s=x.split("-").length-1)>0&&2!==s)throw new i(S);r=+h[1],d=+h[2],y=+h[3]}else if(null!==(h=x.match(_)))r=+h[1],d=+h[2];else if(null!==(h=x.match(O)))r=+h[1];else{var U;if(null!==(h=x.match(T))){if(r=+h[1],U=+h[2],u=o(r),U<1||u&&U>366||!u&&U>365)throw new i(S)}else{if(null===(h=x.match(w)))throw new i(S);r=+h[1];var D=+h[2],q=+h[3]||0;if((s=x.split("-").length-1)>0&&(!n(h[3])&&1!==s||n(h[3])&&2!==s))throw new i(S);U=7*D+q-new Date(Date.UTC(r,0,4)).getUTCDay()-3}(a=new Date(Date.UTC(r,0,1))).setUTCDate(U),d=a.getUTCMonth()+1,y=a.getUTCDate()}if(u=o(r),d<1||d>12||y<1||(2!==d||!u)&&y>f[d-1]||u&&2===d&&y>29)throw new i(S);if(n(P)){if(null!==(h=P.match(A))){if((s=P.split(":").length-1)>0&&2!==s&&3!==s)throw new i(S);g=+h[1],I=+h[2],M=+h[3],C=1e3*+(h[4]||0),l=5}else if(null!==(h=P.match(v))){if((s=P.split(":").length-1)>2)throw new i(S);g=+h[1],I=+h[2],M=60*+(h[3]||0),l=4}else{if(null===(h=P.match(b)))throw new i(S);g=+h[1],I=60*+(h[2]||0),l=3}if(I>=60||M>=61||g>24||24===g&&(I>0||M>0||C>0))throw new i(S);var L=h[l],j=+h[l+1],F=+(h[l+2]||0);switch(L){case"+":g-=j,I-=F;break;case"-":g+=j,I+=F;break;case"Z":break;default:I+=new Date(Date.UTC(r,d-1,y,g,I)).getTimezoneOffset()}}var B=60===M;for(B&&M--;I>=60;)I-=60,g++;for(;g>=24;)g-=24,y++;for(a=u&&2===d?29:f[d-1];y>a;)y-=a,++d>12&&(d-=12,r++),a=u&&2===d?29:f[d-1];for(;I<0;)I+=60,g--;for(;g<0;)g+=24,y--;for(;y<1;)--d<1&&(d+=12,r--),y+=a=u&&2===d?29:f[d-1];var z=E(r,d,y,g,I,M,C);return n(t)?(m(z[0],z[1],t),p(t)):t=new N(z[0],z[1],c.UTC),B&&N.addSeconds(t,1,t),t},N.now=function(e){return N.fromDate(new Date,e)};var I=new N(0,0,c.TAI);return N.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,o=y(e,I);n(o)||(N.addSeconds(e,-1,I),o=y(I,I),r=!0);var u=o.dayNumber,c=o.secondsOfDay;c>=43200&&(u+=1);var l=u+68569|0,f=4*l/146097|0,h=4e3*(1+(l=l-((146097*f+3)/4|0)|0))/1461001|0,d=80*(l=l-(1461*h/4|0)+31|0)/2447|0,p=l-(2447*d/80|0)|0,m=d+2-12*(l=d/11|0)|0,E=100*(f-49)+h+l|0,O=c/s.SECONDS_PER_HOUR|0,_=c-O*s.SECONDS_PER_HOUR,T=_/s.SECONDS_PER_MINUTE|0,w=0|(_-=T*s.SECONDS_PER_MINUTE),R=(_-w)/s.SECONDS_PER_MILLISECOND;return(O+=12)>23&&(O-=24),r&&(w+=1),n(t)?(t.year=E,t.month=m,t.day=p,t.hour=O,t.minute=T,t.second=w,t.millisecond=R,t.isLeapSecond=r,t):new a(E,m,p,O,T,w,R,r)},N.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=N.toGregorianDate(e,l),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},N.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var a,o=N.toGregorianDate(t,l),u=o.year,s=o.month,c=o.day,f=o.hour,h=o.minute,d=o.second,p=o.millisecond;return 1e4===u&&1===s&&1===c&&0===f&&0===h&&0===d&&0===p&&(u=9999,s=12,c=31,f=24),n(r)||0===p?n(r)&&0!==r?(a=(.01*p).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,f,h,d,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",u,s,c,f,h,d):(a=(.01*p).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",u,s,c,f,h,d,a))},N.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new N(e.dayNumber,e.secondsOfDay,c.TAI)},N.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},N.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},N.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(N.secondsDifference(e,t))<=r},N.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},N.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},N.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY},N.computeTaiMinusUtc=function(e){d.julianDate=e;var r=N.leapSeconds,n=t(r,d,h);return n<0&&(n=~n,--n<0&&(n=0)),r[n].offset},N.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return m(e.dayNumber,e.secondsOfDay+t,r)},N.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return m(e.dayNumber,a,r)},N.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return m(e.dayNumber,a,r)},N.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");return m(e.dayNumber+t,e.secondsOfDay,r)},N.lessThan=function(e,t){return N.compare(e,t)<0},N.lessThanOrEquals=function(e,t){return N.compare(e,t)<=0},N.greaterThan=function(e,t){return N.compare(e,t)>0},N.greaterThanOrEquals=function(e,t){return N.compare(e,t)>=0},N.prototype.clone=function(e){return N.clone(this,e)},N.prototype.equals=function(e){return N.equals(this,e)},N.prototype.equalsEpsilon=function(e,t){return N.equalsEpsilon(this,e,t)},N.prototype.toString=function(){return N.toIso8601(this)},N.leapSeconds=[new u(new N(2441317,43210,c.TAI),10),new u(new N(2441499,43211,c.TAI),11),new u(new N(2441683,43212,c.TAI),12),new u(new N(2442048,43213,c.TAI),13),new u(new N(2442413,43214,c.TAI),14),new u(new N(2442778,43215,c.TAI),15),new u(new N(2443144,43216,c.TAI),16),new u(new N(2443509,43217,c.TAI),17),new u(new N(2443874,43218,c.TAI),18),new u(new N(2444239,43219,c.TAI),19),new u(new N(2444786,43220,c.TAI),20),new u(new N(2445151,43221,c.TAI),21),new u(new N(2445516,43222,c.TAI),22),new u(new N(2446247,43223,c.TAI),23),new u(new N(2447161,43224,c.TAI),24),new u(new N(2447892,43225,c.TAI),25),new u(new N(2448257,43226,c.TAI),26),new u(new N(2448804,43227,c.TAI),27),new u(new N(2449169,43228,c.TAI),28),new u(new N(2449534,43229,c.TAI),29),new u(new N(2450083,43230,c.TAI),30),new u(new N(2450630,43231,c.TAI),31),new u(new N(2451179,43232,c.TAI),32),new u(new N(2453736,43233,c.TAI),33),new u(new N(2454832,43234,c.TAI),34),new u(new N(2456109,43235,c.TAI),35),new u(new N(2457204,43236,c.TAI),36),new u(new N(2457754,43237,c.TAI),37)],N})),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./Resource","./RuntimeError","./TimeConstants","./TimeStandard"],(function(e,t,r,n,i,a,o,u,s,c,l,f){"use strict";function h(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))p(this,t.data);else if(n(t.url)){var i=s.createIfNeeded(t.url),a=this;this._downloadPromise=e(i.fetchJson(),(function(e){p(a,e)}),(function(){a._dataError="An error occurred while retrieving the EOP data from the URL "+i.url+"."}))}else p(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function p(e,r){if(n(r.columnNames))if(n(r.samples)){var i=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),h=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||a<0||s<0||c<0||h<0||p<0||y<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var m,E=e._samples=r.samples,O=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _=e._addNewLeapSeconds,T=0,w=E.length;T<w;T+=e._columnCount){var R=E[T+i],g=E[T+y],b=R+l.MODIFIED_JULIAN_DATE_DIFFERENCE,v=new o(b,g,f.TAI);if(O.push(v),_){if(g!==m&&n(m)){var A=o.leapSeconds,S=t(A,v,d);if(S<0){var N=new u(v,g);A.splice(~S,0,N)}}m=g}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function y(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],l=t[a];if(c.equals(l)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(l))return y(e,r,a,s,u),u;var f=o.secondsDifference(n,c)/o.secondsDifference(l,c),h=i*s,d=a*s,p=r[h+e._ut1MinusUtcSecondsColumn],E=r[d+e._ut1MinusUtcSecondsColumn],O=E-p;if(O>.5||O<-.5){var _=r[h+e._taiMinusUtcSecondsColumn],T=r[d+e._taiMinusUtcSecondsColumn];_!==T&&(l.equals(n)?p=E:E-=T-_)}return u.xPoleWander=m(f,r[h+e._xPoleWanderRadiansColumn],r[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,r[h+e._yPoleWanderRadiansColumn],r[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,r[h+e._xCelestialPoleOffsetRadiansColumn],r[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,r[h+e._yCelestialPoleOffsetRadiansColumn],r[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,p,E),u}return h.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),h.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},h.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=a[u],h=a[u+1],d=o.lessThanOrEquals(f,e),p=!n(h),y=p||o.greaterThanOrEquals(h,e);if(d&&y)return s=u,!p&&h.equals(e)&&++s,l=s+1,E(this,a,this._samples,e,s,l,r),r}var m=t(a,e,o.compare,this._dateColumn);return m>=0?(m<a.length-1&&a[m+1].equals(e)&&++m,s=m,l=m):(s=(l=~m)-1)<0&&(s=0),this._lastIndex=s,E(this,a,this._samples,e,s,l,r),r}if(n(this._dataError))throw new c(this._dataError)},h})),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],(function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var a=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,o),n.pitch=-Math.asin(a),n},i.fromDegrees=function(e,a,o,u){if(!t(e))throw new r("heading is required");if(!t(a))throw new r("pitch is required");if(!t(o))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=a*n.RADIANS_PER_DEGREE,u.roll=o*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,a){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,a)&&n.equalsEpsilon(e.pitch,r.pitch,i,a)&&n.equalsEpsilon(e.roll,r.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i})),define("Core/Iau2006XysSample",[],(function(){"use strict";return function(e,t,r){this.x=e,this.y=t,this.s=r}})),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./Resource","./TimeStandard"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=o.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),s=Math.pow(this._stepSizeDays,t),c=0;c<=t;++c){n[c]=s,i[c]=c*this._stepSizeDays;for(var l=0;l<=t;++l)l!==c&&(n[c]*=c-l);n[c]=1/n[c]}this._work=new Array(t+1),this._coef=new Array(t+1)}var c=new a(0,0,u.TAI);function l(e,t,r){var n=c;return n.dayNumber=t,n.secondsOfDay=r,a.daysDifference(n,e._sampleZeroDateTT)}function f(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var a,u=e.defer();r._chunkDownloadsInProgress[i]=u;var s=r._xysFileUrlTemplate;return a=n(s)?s.getDerivedResource({templateValues:{0:i}}):new o({url:t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json")}),e(a.fetchJson(),(function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,a=i*r._samplesPerXysFile*3,o=0,s=n.length;o<s;++o)t[a+o]=n[o];u.resolve()})),u.promise}return s.prototype.preload=function(t,r,n,i){var a=l(this,t,r),o=l(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var c=u/this._samplesPerXysFile|0,h=s/this._samplesPerXysFile|0,d=[],p=c;p<=h;++p)d.push(f(this,p));return e.all(d)},s.prototype.computeXysRadians=function(e,t,r){var a=l(this,e,t);if(!(a<0)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);s<0&&(s=0);var c=s+u;c>=this._totalSamples&&(s=(c=this._totalSamples-1)-u)<0&&(s=0);var h=!1,d=this._samples;if(n(d[3*s])||(f(this,s/this._samplesPerXysFile|0),h=!0),n(d[3*c])||(f(this,c/this._samplesPerXysFile|0),h=!0),!h){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var p,y,m=a-s*this._stepSizeDays,E=this._work,O=this._denominators,_=this._coef,T=this._xTable;for(p=0;p<=u;++p)E[p]=m-T[p];for(p=0;p<=u;++p){for(_[p]=1,y=0;y<=u;++y)y!==p&&(_[p]*=E[y]);_[p]*=O[p];var w=3*(s+p);r.x+=_[p]*d[w++],r.y+=_[p]*d[w++],r.s+=_[p]*d[w]}return r}}}},s})),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],(function(e,t,r,n,i,a,o,u,s,c,l,f,h,d,p,y,m,E,O,_,T){"use strict";var w={},R={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},g={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},b={},v={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},A=new r,S=new r,N=new r;w.localFrameToFixedFrameGenerator=function(e,t){if(!R.hasOwnProperty(e)||!R[e].hasOwnProperty(t))throw new s("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=R[e][t],a=e+t;return u(b[a])?n=b[a]:(n=function(n,a,c){if(!u(n))throw new s("origin is required.");if(u(c)||(c=new O),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var l=m.sign(n.z);r.unpack(g[e],0,A),"east"!==e&&"west"!==e&&r.multiplyByScalar(A,l,A),r.unpack(g[t],0,S),"east"!==t&&"west"!==t&&r.multiplyByScalar(S,l,S),r.unpack(g[i],0,N),"east"!==i&&"west"!==i&&r.multiplyByScalar(N,l,N)}else{(a=o(a,f.WGS84)).geodeticSurfaceNormal(n,v.up);var h=v.up,d=v.east;d.x=-n.y,d.y=n.x,d.z=0,r.normalize(d,v.east),r.cross(h,d,v.north),r.multiplyByScalar(v.up,-1,v.down),r.multiplyByScalar(v.east,-1,v.west),r.multiplyByScalar(v.north,-1,v.south),A=v[e],S=v[t],N=v[i]}return c[0]=A.x,c[1]=A.y,c[2]=A.z,c[3]=0,c[4]=S.x,c[5]=S.y,c[6]=S.z,c[7]=0,c[8]=N.x,c[9]=N.y,c[10]=N.z,c[11]=0,c[12]=n.x,c[13]=n.y,c[14]=n.z,c[15]=1,c},b[a]=n),n},w.eastNorthUpToFixedFrame=w.localFrameToFixedFrameGenerator("east","north"),w.northEastDownToFixedFrame=w.localFrameToFixedFrameGenerator("north","east"),w.northUpEastToFixedFrame=w.localFrameToFixedFrameGenerator("north","up"),w.northWestUpToFixedFrame=w.localFrameToFixedFrameGenerator("north","west");var I=new _,M=new r(1,1,1),C=new O;w.headingPitchRollToFixedFrame=function(e,t,n,i,u){a.typeOf.object("HeadingPitchRoll",t),i=o(i,w.eastNorthUpToFixedFrame);var s=_.fromHeadingPitchRoll(t,I),c=O.fromTranslationQuaternionRotationScale(r.ZERO,s,M,C);return u=i(e,n,u),O.multiply(u,c,u)};var x=new O,P=new E;w.headingPitchRollQuaternion=function(e,t,r,n,i){a.typeOf.object("HeadingPitchRoll",t);var o=w.headingPitchRollToFixedFrame(e,t,r,n,x),u=O.getRotation(o,P);return _.fromRotationMatrix(u,i)};var U=new r(1,1,1),D=new r,q=new O,L=new O,j=new E,F=new _;w.fixedFrameToHeadingPitchRoll=function(e,t,n,i){a.defined("transform",e),t=o(t,f.WGS84),n=o(n,w.eastNorthUpToFixedFrame),u(i)||(i=new h);var s=O.getTranslation(e,D);if(r.equals(s,r.ZERO))return i.heading=0,i.pitch=0,i.roll=0,i;var c=O.inverseTransformation(n(s,t,q),q),l=O.setScale(e,U,L);l=O.setTranslation(l,r.ZERO,l),c=O.multiply(c,l,c);var d=_.fromRotationMatrix(O.getRotation(c,j),F);return d=_.normalize(d,d),h.fromQuaternion(d,i)};var B=m.TWO_PI/86400,z=new y;w.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");var r,n=(z=y.addSeconds(e,-y.computeTaiMinusUtc(e),z)).dayNumber,i=z.secondsOfDay,a=n-2451545,o=(24110.54841+(r=i>=43200?(a+.5)/T.DAYS_PER_JULIAN_CENTURY:(a-.5)/T.DAYS_PER_JULIAN_CENTURY)*(8640184.812866+r*(.093104+-62e-7*r)))*B%m.TWO_PI+(72921158553e-15+11772758384668e-32*(n-2451545.5))*((i+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY),c=Math.cos(o),l=Math.sin(o);return u(t)?(t[0]=c,t[1]=-l,t[2]=0,t[3]=l,t[4]=c,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(c,l,0,-l,c,0,0,0,1)},w.iau2006XysData=new d,w.earthOrientationParameters=c.NONE,w.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+32.184,i=t.stop.dayNumber,a=t.stop.secondsOfDay+32.184,o=w.iau2006XysData.preload(r,n,i,a),u=w.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},w.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=w.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var G=new p(0,0,0),V=new l(0,0,0,0,0,0),X=new E,W=new E;w.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new s("date is required.");u(t)||(t=new E);var r=w.earthOrientationParameters.compute(e,V);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+32.184,a=w.iau2006XysData.computeXysRadians(n,i,G);if(u(a)){var o=a.x+r.xPoleOffset,c=a.y+r.yPoleOffset,l=1/(1+Math.sqrt(1-o*o-c*c)),f=X;f[0]=1-l*o*o,f[3]=-l*o*c,f[6]=o,f[1]=-l*o*c,f[4]=1-l*c*c,f[7]=c,f[2]=-o,f[5]=-c,f[8]=1-l*(o*o+c*c);var h=E.fromRotationZ(-a.s,W),d=E.multiply(f,h,X),p=e.dayNumber-2451545,O=(e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc)/T.SECONDS_PER_DAY,_=.779057273264+O+.00273781191135448*(p+O);_=_%1*m.TWO_PI;var R=E.fromRotationZ(_,W),g=E.multiply(d,R,X),b=Math.cos(r.xPoleWander),v=Math.cos(r.yPoleWander),A=Math.sin(r.xPoleWander),S=Math.sin(r.yPoleWander),N=n-2451545+i/T.SECONDS_PER_DAY,I=-47e-6*(N/=36525)*m.RADIANS_PER_DEGREE/3600,M=Math.cos(I),C=Math.sin(I),x=W;return x[0]=b*M,x[1]=b*C,x[2]=A,x[3]=-v*C+S*A*M,x[4]=v*M+S*A*C,x[5]=-S*b,x[6]=-S*C-v*A*M,x[7]=S*M-v*A*C,x[8]=v*b,E.multiply(g,x,t)}}};var H=new n;w.pointToWindowCoordinates=function(e,t,r,n){return(n=w.pointToGLWindowCoordinates(e,t,r,n)).y=2*t[5]-n.y,n},w.pointToGLWindowCoordinates=function(e,r,i,a){if(!u(e))throw new s("modelViewProjectionMatrix is required.");if(!u(r))throw new s("viewportTransformation is required.");if(!u(i))throw new s("point is required.");u(a)||(a=new t);var o=H;return O.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,o),o),n.multiplyByScalar(o,1/o.w,o),O.multiplyByVector(r,o,o),t.fromCartesian4(o,a)};var k=new r,Y=new r,Z=new r;w.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new s("position is required.");if(!u(t))throw new s("velocity is required.");var a=o(n,f.WGS84).geodeticSurfaceNormal(e,k),c=r.cross(t,a,Y);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var l=r.cross(c,t,Z);return r.normalize(l,l),r.cross(t,l,c),r.negate(c,c),r.normalize(c,c),u(i)||(i=new E),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=c.x,i[4]=c.y,i[5]=c.z,i[6]=l.x,i[7]=l.y,i[8]=l.z,i};var K=new O(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),J=new i,Q=new r,$=new r,ee=new E,te=new O,re=new O;return w.basisTo2D=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("matrix is required.");if(!u(n))throw new s("result is required.");var i=O.getTranslation(t,$),a=e.ellipsoid,o=a.cartesianToCartographic(i,J),c=e.project(o,Q);r.fromElements(c.z,c.x,c.y,c);var l=w.eastNorthUpToFixedFrame(i,a,te),f=O.inverseTransformation(l,re),h=O.getRotation(t,ee),d=O.multiplyByMatrix3(f,h,n);return O.multiply(K,d,n),O.setTranslation(n,c,n),n},w.wgs84To2DModelMatrix=function(e,t,n){if(!u(e))throw new s("projection is required.");if(!u(t))throw new s("center is required.");if(!u(n))throw new s("result is required.");var i=e.ellipsoid,a=w.eastNorthUpToFixedFrame(t,i,te),o=O.inverseTransformation(a,re),c=i.cartesianToCartographic(t,J),l=e.project(c,Q);r.fromElements(l.z,l.x,l.y,l);var f=O.fromTranslation(l,te);return O.multiply(K,o,n),O.multiply(f,n,n),n},w})),define("Core/Geometry",["./Cartesian2","./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./GeometryOffsetAttribute","./GeometryType","./Matrix2","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms"],(function(e,t,r,n,i,a,o,u,s,c,l,f,h,d,p,y){"use strict";function m(e){e=i(e,i.EMPTY_OBJECT),n.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=i(e.primitiveType,h.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=i(e.geometryType,s.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}m.computeNumberOfVertices=function(e){n.typeOf.object("geometry",e);var t=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&a(e.attributes[r])&&a(e.attributes[r].values)){var i=e.attributes[r],u=i.values.length/i.componentsPerAttribute;if(t!==u&&-1!==t)throw new o("All attribute lists must have the same number of attributes.");t=u}return t};var E=new r,O=new t,_=new f,T=[new r,new r,new r],w=[new e,new e,new e],R=[new e,new e,new e],g=new t,b=new d,v=new f,A=new c;return m._textureCoordinateRotationPoints=function(n,i,a,o){var u,s=p.center(o,E),h=r.toCartesian(s,a,O),m=y.eastNorthUpToFixedFrame(h,a,_),S=f.inverse(m,_),N=w,I=T;I[0].longitude=o.west,I[0].latitude=o.south,I[1].longitude=o.west,I[1].latitude=o.north,I[2].longitude=o.east,I[2].latitude=o.south;var M=g;for(u=0;u<3;u++)r.toCartesian(I[u],a,M),M=f.multiplyByPointAsVector(S,M,M),N[u].x=M.x,N[u].y=M.y;var C=d.fromAxisAngle(t.UNIT_Z,-i,b),x=l.fromQuaternion(C,v),P=n.length,U=Number.POSITIVE_INFINITY,D=Number.POSITIVE_INFINITY,q=Number.NEGATIVE_INFINITY,L=Number.NEGATIVE_INFINITY;for(u=0;u<P;u++)M=f.multiplyByPointAsVector(S,n[u],M),M=l.multiplyByVector(x,M,M),U=Math.min(U,M.x),D=Math.min(D,M.y),q=Math.max(q,M.x),L=Math.max(L,M.y);var j=c.fromRotation(i,A),F=R;F[0].x=U,F[0].y=D,F[1].x=U,F[1].y=L,F[2].x=q,F[2].y=D;var B=N[0],z=N[2].x-B.x,G=N[1].y-B.y;for(u=0;u<3;u++){var V=F[u];c.multiplyByVector(j,V,V),V.x=(V.x-B.x)/z,V.y=(V.y-B.y)/G}var X=F[0],W=F[1],H=F[2],k=new Array(6);return e.pack(X,k),e.pack(W,k,2),e.pack(H,k,4),k},m})),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],(function(e,t,r){"use strict";return function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}})),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],(function(e,t){"use strict";var r={};function n(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}return r.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");return r*r-4*t*n},r.computeRealRoots=function(r,i,a){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===r)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(r);if(u<s&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if((o=-a/r)<0)return[];var c=Math.sqrt(o);return[-c,c]}if(0===a)return(o=-i/r)<0?[o,0]:[0,o];var l=n(i*i,-4*r*a,t.EPSILON14);if(l<0)return[];var f=-.5*n(i,t.sign(i)*Math.sqrt(l),t.EPSILON14);return i>0?[f/r,a/f]:[a/f,f/r]},r})),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],(function(e,t){"use strict";var r={};function n(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,h=u*u,d=s*s,p=o*s-h,y=o*c-u*s,m=u*c-d,E=4*p*m-y*y;if(E<0){var O,_,T;h*f>=l*d?(O=o,_=p,T=-2*u*p+o*y):(O=c,_=m,T=-c*y+2*s*m);var w=-(T<0?-1:1)*Math.abs(O)*Math.sqrt(-E),R=(a=-T+w)/2,g=R<0?-Math.pow(-R,1/3):Math.pow(R,1/3),b=a===w?-g:-_/g;return i=_<=0?g+b:-T/(g*g+b*b+_),h*f>=l*d?[(i-u)/o]:[-c/(i+s)]}var v=p,A=-2*u*p+o*y,S=m,N=-c*y+2*s*m,I=Math.sqrt(E),M=Math.sqrt(3)/2,C=Math.abs(Math.atan2(o*I,-A)/3);i=2*Math.sqrt(-v);var x=Math.cos(C);a=i*x;var P=i*(-x/2-M*Math.sin(C)),U=a+P>2*u?a-u:P-u,D=o,q=U/D;C=Math.abs(Math.atan2(c*I,-N)/3);var L=-c,j=(a=(i=2*Math.sqrt(-S))*(x=Math.cos(C)))+(P=i*(-x/2-M*Math.sin(C)))<2*s?a+s:P+s,F=L/j,B=-U*j-D*L,z=(s*B-u*(U*L))/(-u*B+s*(D*j));return q<=z?q<=F?z<=F?[q,z,F]:[q,F,z]:[F,q,z]:q<=F?[z,q,F]:z<=F?[z,F,q]:[F,z,q]}return r.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=n*n;return 18*t*r*n*i+a*o-t*t*27*(i*i)-4*(t*o*n+a*r*i)},r.computeRealRoots=function(r,i,a,o){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===r)return t.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];var c=(s=-o/r)<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===o?0===(u=t.computeRealRoots(r,0,a)).Length?[0]:[u[0],0,u[1]]:n(r,0,a,o)}return 0===a?0===o?(s=-i/r)<0?[s,0,0]:[0,0,s]:n(r,i,0,o):0===o?0===(u=t.computeRealRoots(r,i,a)).length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]:n(r,i,a,o)},r})),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],(function(e,t,r,n){"use strict";var i={};function a(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,l=o-a*t/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,d=f[f.length-1];if(Math.abs(d)<r.EPSILON14){var p=n.computeRealRoots(1,s,l);if(2===p.length){var y,m=p[0],E=p[1];if(m>=0&&E>=0){var O=Math.sqrt(m),_=Math.sqrt(E);return[h-_,h-O,h+O,h+_]}if(m>=0&&E<0)return[h-(y=Math.sqrt(m)),h+y];if(m<0&&E>=0)return[h-(y=Math.sqrt(E)),h+y]}return[]}if(d>0){var T=Math.sqrt(d),w=(s+d-c/T)/2,R=(s+d+c/T)/2,g=n.computeRealRoots(1,T,w),b=n.computeRealRoots(1,-T,R);return 0!==g.length?(g[0]+=h,g[1]+=h,0!==b.length?(b[0]+=h,b[1]+=h,g[1]<=b[0]?[g[0],g[1],b[0],b[1]]:b[1]<=g[0]?[b[0],b[1],g[0],g[1]]:g[0]>=b[0]&&g[1]<=b[1]?[b[0],g[0],g[1],b[1]]:b[0]>=g[0]&&b[1]<=g[1]?[g[0],b[0],b[1],g[1]]:g[0]>b[0]&&g[0]<b[1]?[b[0],g[0],b[1],g[1]]:[g[0],b[0],g[1],b[1]]):g):0!==b.length?(b[0]+=h,b[1]+=h,b):[]}}return[]}function o(t,i,a,o){var u=t*t,s=-2*i,c=a*t+i*i-4*o,l=u*o-a*i*t+a*a,f=e.computeRealRoots(1,s,c,l);if(f.length>0){var h,d,p,y,m,E,O=f[0],_=i-O,T=_*_,w=t/2,R=_/2,g=T-4*o,b=T+4*Math.abs(o),v=u-4*O,A=u+4*Math.abs(O);if(O<0||g*A<v*b){var S=Math.sqrt(v);h=S/2,d=0===S?0:(t*R-a)/S}else{var N=Math.sqrt(g);h=0===N?0:(t*R-a)/N,d=N/2}0===w&&0===h?(p=0,y=0):r.sign(w)===r.sign(h)?y=O/(p=w+h):p=O/(y=w-h),0===R&&0===d?(m=0,E=0):r.sign(R)===r.sign(d)?E=o/(m=R+d):m=o/(E=R-d);var I=n.computeRealRoots(1,p,m),M=n.computeRealRoots(1,y,E);if(0!==I.length)return 0!==M.length?I[1]<=M[0]?[I[0],I[1],M[0],M[1]]:M[1]<=I[0]?[M[0],M[1],I[0],I[1]]:I[0]>=M[0]&&I[1]<=M[1]?[M[0],I[0],I[1],M[1]]:M[0]>=I[0]&&M[1]<=I[1]?[I[0],M[0],M[1],I[1]]:I[0]>M[0]&&I[0]<M[1]?[M[0],I[0],M[1],I[1]]:[I[0],M[0],I[1],M[1]]:I;if(0!==M.length)return M}return[]}return i.computeDiscriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,u=r*r,s=u*r,c=n*n,l=c*n,f=i*i,h=f*i,d=a*a;return u*c*f-4*s*h-4*e*l*f+18*e*r*n*h-27*o*f*f+o*e*256*(d*a)+a*(18*s*n*i-4*u*l+16*e*c*c-80*e*r*c*i-6*e*u*f+144*o*n*f)+d*(144*e*u*n-27*u*u-128*o*c-192*o*r*i)},i.computeRealRoots=function(n,i,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof i)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(i,u,s,c);var l=i/n,f=u/n,h=s/n,d=c/n,p=l<0?1:0;switch(p+=f<0?p+1:p,p+=h<0?p+1:p,p+=d<0?p+1:p){case 0:return a(l,f,h,d);case 1:case 2:return o(l,f,h,d);case 3:case 4:return a(l,f,h,d);case 5:return o(l,f,h,d);case 6:case 7:return a(l,f,h,d);case 8:return o(l,f,h,d);case 9:case 10:return a(l,f,h,d);case 11:return o(l,f,h,d);case 12:case 13:case 14:case 15:return a(l,f,h,d);default:return}},i})),define("Core/Ray",["./Cartesian3","./Check","./defaultValue","./defined"],(function(e,t,r,n){"use strict";function i(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n}return i.clone=function(t,r){if(n(t))return n(r)?(r.origin=e.clone(t.origin),r.direction=e.clone(t.direction),r):new i(t.origin,t.direction)},i.getPoint=function(r,i,a){return t.typeOf.object("ray",r),t.typeOf.number("t",i),n(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i})),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],(function(e,t,r,n,i,a,o,u,s,c,l){"use strict";var f={rayPlane:function(t,r,a){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(a)||(a=new e);var u=t.origin,s=t.direction,c=r.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON15)){var f=(-r.distance-e.dot(c,u))/l;if(!(f<0))return a=e.multiplyByScalar(s,f,a),e.add(u,a,a)}}},h=new e,d=new e,p=new e,y=new e,m=new e;f.rayTriangleParametric=function(t,a,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var l,f,E,O,_,T=t.origin,w=t.direction,R=e.subtract(u,a,h),g=e.subtract(s,a,d),b=e.cross(w,g,p),v=e.dot(R,b);if(c){if(v<o.EPSILON6)return;if(l=e.subtract(T,a,y),(E=e.dot(l,b))<0||E>v)return;if(f=e.cross(l,R,m),(O=e.dot(w,f))<0||E+O>v)return;_=e.dot(g,f)/v}else{if(Math.abs(v)<o.EPSILON6)return;var A=1/v;if(l=e.subtract(T,a,y),(E=e.dot(l,b)*A)<0||E>1)return;if(f=e.cross(l,R,m),(O=e.dot(w,f)*A)<0||E+O>1)return;_=e.dot(g,f)*A}return _},f.rayTriangle=function(t,r,i,a,o,u){var s=f.rayTriangleParametric(t,r,i,a,o);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var E=new l;f.lineSegmentTriangle=function(t,r,a,o,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(a))throw new i("p0 is required.");if(!n(o))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var l=E;e.clone(t,l.origin),e.subtract(r,t,l.direction),e.normalize(l.direction,l.direction);var h=f.rayTriangleParametric(l,a,o,u,s);if(!(!n(h)||h<0||h>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(l.direction,h,c),e.add(l.origin,c,c)};var O={root0:0,root1:0};function _(t,r,i){n(i)||(i=new a);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,l=e.subtract(o,s,p),f=function(e,t,r,n){var i=t*t-4*e*r;if(!(i<0)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}(e.dot(u,u),2*e.dot(u,l),e.magnitudeSquared(l)-c,O);if(n(f))return i.start=f.root0,i.stop=f.root1,i}f.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");if(r=_(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var T=new l;f.lineSegmentSphere=function(t,r,a,o){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=T;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);if(e.normalize(s,s),o=_(u,a,o),!(!n(o)||o.stop<0||o.start>c))return o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,c),o};var w=new e,R=new e;function g(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}f.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o,u,s,c,l,f=r.oneOverRadii,h=e.multiplyComponents(f,t.origin,w),d=e.multiplyComponents(f,t.direction,R),p=e.magnitudeSquared(h),y=e.dot(h,d);if(p>1){if(y>=0)return;var m=y*y;if(o=p-1,m<(s=(u=e.magnitudeSquared(d))*o))return;if(m>s){c=y*y-s;var E=(l=-y+Math.sqrt(c))/u,O=o/l;return E<O?new a(E,O):{start:O,stop:E}}var _=Math.sqrt(o/u);return new a(_,_)}return p<1?(o=p-1,c=y*y-(s=(u=e.magnitudeSquared(d))*o),l=-y+Math.sqrt(c),new a(0,l/u)):y<0?(u=e.magnitudeSquared(d),new a(0,-y/u)):void 0};var b=new e,v=new e,A=new e,S=new e,N=new e,I=new u,M=new u,C=new u,x=new u,P=new u,U=new u,D=new u,q=new e,L=new e,j=new t;f.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a=t.origin,l=t.direction;if(!e.equals(a,e.ZERO)){var f=r.geodeticSurfaceNormal(a,b);if(e.dot(l,f)>=0)return a}var h=n(this.rayEllipsoid(t,r)),d=r.transformPositionToScaledSpace(l,b),p=e.normalize(d,d),y=e.mostOrthogonalAxis(d,S),m=e.normalize(e.cross(y,p,v),v),E=e.normalize(e.cross(p,m,A),A),O=I;O[0]=p.x,O[1]=p.y,O[2]=p.z,O[3]=m.x,O[4]=m.y,O[5]=m.z,O[6]=E.x,O[7]=E.y,O[8]=E.z;var _=u.transpose(O,M),T=u.fromScale(r.radii,C),w=u.fromScale(r.oneOverRadii,x),R=P;R[0]=0,R[1]=-l.z,R[2]=l.y,R[3]=l.z,R[4]=0,R[5]=-l.x,R[6]=-l.y,R[7]=l.x,R[8]=0;var F,B,z=u.multiply(u.multiply(_,w,U),R,U),G=u.multiply(u.multiply(z,T,D),O,D),V=u.multiplyByVector(z,a,N),X=function(t,r,n,i,a){var l,f=i*i,h=a*a,d=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*h,p=a*(i*g(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),y=t[u.COLUMN0ROW0]*f+t[u.COLUMN2ROW2]*h+i*r.x+n,m=h*g(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),E=a*(i*g(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),O=[];if(0===E&&0===m){if(0===(l=s.computeRealRoots(d,p,y)).length)return O;var _=l[0],T=Math.sqrt(Math.max(1-_*_,0));if(O.push(new e(i,a*_,a*-T)),O.push(new e(i,a*_,a*T)),2===l.length){var w=l[1],R=Math.sqrt(Math.max(1-w*w,0));O.push(new e(i,a*w,a*-R)),O.push(new e(i,a*w,a*R))}return O}var b=E*E,v=m*m,A=E*m,S=d*d+v,N=2*(p*d+A),I=2*y*d+p*p-v+b,M=2*(y*p-A),C=y*y-b;if(0===S&&0===N&&0===I&&0===M)return O;var x=(l=c.computeRealRoots(S,N,I,M,C)).length;if(0===x)return O;for(var P=0;P<x;++P){var U=l[P],D=U*U,q=Math.max(1-D,0),L=Math.sqrt(q),j=(o.sign(d)===o.sign(y)?g(d*D+y,p*U,o.EPSILON12):o.sign(y)===o.sign(p*U)?g(d*D,p*U+y,o.EPSILON12):g(d*D+p*U,y,o.EPSILON12))*g(m*U,E,o.EPSILON15);j<0?O.push(new e(i,a*U,a*L)):j>0?O.push(new e(i,a*U,a*-L)):0!==L?(O.push(new e(i,a*U,a*-L)),O.push(new e(i,a*U,a*L)),++P):O.push(new e(i,a*U,a*L))}return O}(G,e.negate(V,b),0,0,1),W=X.length;if(W>0){for(var H=e.clone(e.ZERO,L),k=Number.NEGATIVE_INFINITY,Y=0;Y<W;++Y){F=u.multiplyByVector(T,u.multiplyByVector(O,X[Y],q),q);var Z=e.normalize(e.subtract(F,a,S),S),K=e.dot(Z,l);K>k&&(k=K,H=e.clone(F,H))}var J=r.cartesianToCartographic(H,j);return k=o.clamp(k,0,1),B=e.magnitude(e.subtract(H,a,S))*Math.sqrt(1-k*k),B=h?-B:B,J.height=B,r.cartographicToCartesian(J,new e)}};var F=new e;return f.lineSegmentPlane=function(t,r,a,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,F),c=a.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON6)){var f=e.dot(c,t),h=-(a.distance+f)/l;if(!(h<0||h>1))return e.multiplyByScalar(s,h,u),e.add(t,u,u),u}},f.trianglePlaneIntersection=function(t,r,a,o){if(!(n(t)&&n(r)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u,s,c=o.normal,l=o.distance,h=e.dot(c,t)+l<0,d=e.dot(c,r)+l<0,p=e.dot(c,a)+l<0,y=0;if(y+=h?1:0,y+=d?1:0,1!==(y+=p?1:0)&&2!==y||(u=new e,s=new e),1===y){if(h)return f.lineSegmentPlane(t,r,o,u),f.lineSegmentPlane(t,a,o,s),{positions:[t,r,a,u,s],indices:[0,3,4,1,2,4,1,4,3]};if(d)return f.lineSegmentPlane(r,a,o,u),f.lineSegmentPlane(r,t,o,s),{positions:[t,r,a,u,s],indices:[1,3,4,2,0,4,2,4,3]};if(p)return f.lineSegmentPlane(a,t,o,u),f.lineSegmentPlane(a,r,o,s),{positions:[t,r,a,u,s],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===y){if(!h)return f.lineSegmentPlane(r,t,o,u),f.lineSegmentPlane(a,t,o,s),{positions:[t,r,a,u,s],indices:[1,2,4,1,4,3,0,3,4]};if(!d)return f.lineSegmentPlane(a,r,o,u),f.lineSegmentPlane(t,r,o,s),{positions:[t,r,a,u,s],indices:[2,0,4,2,4,3,1,3,4]};if(!p)return f.lineSegmentPlane(t,a,o,u),f.lineSegmentPlane(r,a,o,s),{positions:[t,r,a,u,s],indices:[0,1,4,0,4,3,2,3,4]}}},f})),define("Core/Plane",["./Cartesian3","./Check","./defined","./DeveloperError","./freezeObject","./Math","./Matrix4"],(function(e,t,r,n,i,a,o){"use strict";function u(r,i){if(t.typeOf.object("normal",r),!a.equalsEpsilon(e.magnitude(r),1,a.EPSILON6))throw new n("normal must be normalized.");t.typeOf.number("distance",i),this.normal=e.clone(r),this.distance=i}u.fromPointNormal=function(i,o,s){if(t.typeOf.object("point",i),t.typeOf.object("normal",o),!a.equalsEpsilon(e.magnitude(o),1,a.EPSILON6))throw new n("normal must be normalized.");var c=-e.dot(o,i);return r(s)?(e.clone(o,s.normal),s.distance=c,s):new u(o,c)};var s=new e;u.fromCartesian4=function(i,o){t.typeOf.object("coefficients",i);var c=e.fromCartesian4(i,s),l=i.w;if(!a.equalsEpsilon(e.magnitude(c),1,a.EPSILON6))throw new n("normal must be normalized.");return r(o)?(e.clone(c,o.normal),o.distance=l,o):new u(c,l)},u.getPointDistance=function(r,n){return t.typeOf.object("plane",r),t.typeOf.object("point",n),e.dot(r.normal,n)+r.distance};var c=new e;u.projectPointOntoPlane=function(n,i,a){t.typeOf.object("plane",n),t.typeOf.object("point",i),r(a)||(a=new e);var o=u.getPointDistance(n,i),s=e.multiplyByScalar(n.normal,o,c);return e.subtract(i,s,a)};var l=new e;return u.transform=function(r,n,i){return t.typeOf.object("plane",r),t.typeOf.object("transform",n),o.multiplyByPointAsVector(n,r.normal,s),e.normalize(s,s),e.multiplyByScalar(r.normal,-r.distance,l),o.multiplyByPoint(n,l,l),u.fromPointNormal(l,s,i)},u.clone=function(n,i){return t.typeOf.object("plane",n),r(i)?(e.clone(n.normal,i.normal),i.distance=n.distance,i):new u(n.normal,n.distance)},u.equals=function(r,n){return t.typeOf.object("left",r),t.typeOf.object("right",n),r.distance===n.distance&&e.equals(r.normal,n.normal)},u.ORIGIN_XY_PLANE=i(new u(e.UNIT_Z,0)),u.ORIGIN_YZ_PLANE=i(new u(e.UNIT_X,0)),u.ORIGIN_ZX_PLANE=i(new u(e.UNIT_Y,0)),u})),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],(function(e,t,r,n,i,a,o,u){"use strict";function s(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.mercatorAngleToGeodeticLatitude=function(e){return u.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},s.geodeticLatitudeToMercatorAngle=function(e){e>s.MaximumLatitude?e=s.MaximumLatitude:e<-s.MaximumLatitude&&(e=-s.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},s.MaximumLatitude=s.mercatorAngleToGeodeticLatitude(Math.PI),s.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=s.geodeticLatitudeToMercatorAngle(t.latitude)*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},s.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=s.mercatorAngleToGeodeticLatitude(e.y*i),c=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=c,r):new t(o,u,c)},s})),define("Core/GroundPolylineGeometry",["./ApproximateTerrainHeights","./arrayRemoveDuplicates","./BoundingSphere","./Cartesian3","./Cartographic","./Check","./ComponentDatatype","./DeveloperError","./Math","./defaultValue","./defined","./defineProperties","./Ellipsoid","./EllipsoidGeodesic","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./IntersectionTests","./Matrix3","./Plane","./Quaternion","./Rectangle","./WebMercatorProjection"],(function(e,t,r,n,i,a,o,u,s,c,l,f,h,d,p,y,m,E,O,_,T,w,R,g){"use strict";var b=[y,g],v=b.length,A=Math.cos(s.toRadians(30)),S=Math.cos(s.toRadians(150));function N(e){var t=(e=c(e,c.EMPTY_OBJECT)).positions;if(!l(t)||t.length<2)throw new u("At least two positions are required.");this.width=c(e.width,1),this._positions=t,this.granularity=c(e.granularity,9999),this.loop=c(e.loop,!1),this._ellipsoid=h.WGS84,this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}f(N.prototype,{packedLength:{get:function(){return 1+3*this._positions.length+1+1+h.packedLength+1+1}}}),N.setProjectionAndEllipsoid=function(e,t){for(var r=0,n=0;n<v;n++)if(t instanceof b[n]){r=n;break}e._projectionIndex=r,e._ellipsoid=t.ellipsoid};var I=new n,M=new n,C=new n;function x(e,t,r,i,a){var o=F(i,e,0,I),u=F(i,e,r,M),s=F(i,t,0,C),c=B(u,o,M),l=B(s,o,C);return n.cross(l,c,a),n.normalize(a,a)}var P=new i,U=new n,D=new n,q=new n;function L(e,t,r,i,a,o,u,s,c,l){if(0!==a){var f=new d(e,t,o),h=f.surfaceDistance;if(!(h<a))for(var p=x(e,t,i,o,q),y=Math.ceil(h/a),m=h/y,E=m,O=y-1,_=u.length,T=0;T<O;T++){var w=f.interpolateUsingSurfaceDistance(E,P),R=F(o,w,r,U),g=F(o,w,i,D);n.pack(p,u,_),n.pack(R,s,_),n.pack(g,c,_),l.push(w.latitude),l.push(w.longitude),_+=3,E+=m}}}var j=new i;function F(e,t,r,n){return i.clone(t,j),j.height=r,i.toCartesian(j,e,n)}function B(e,t,r){return n.subtract(e,t,r),n.normalize(r,r),r}N.pack=function(e,t,r){a.typeOf.object("value",e),a.defined("array",t);var i=c(r,0),o=e._positions,u=o.length;t[i++]=u;for(var s=0;s<u;++s){var l=o[s];n.pack(l,t,i),i+=3}return t[i++]=e.granularity,t[i++]=e.loop?1:0,h.pack(e._ellipsoid,t,i),i+=h.packedLength,t[i++]=e._projectionIndex,t[i++]=e._scene3DOnly?1:0,t},N.unpack=function(e,t,r){a.defined("array",e);for(var i=c(t,0),o=e[i++],u=new Array(o),s=0;s<o;s++)u[s]=n.unpack(e,i),i+=3;var f=e[i++],d=1===e[i++],p=h.unpack(e,i);i+=h.packedLength;var y=e[i++],m=1===e[i++];if(!l(r)){var E=new N({positions:u,granularity:f,loop:d,ellipsoid:p});return E._projectionIndex=y,E._scene3DOnly=m,E}return r._positions=u,r.granularity=f,r.loop=d,r._ellipsoid=p,r._projectionIndex=y,r._scene3DOnly=m,r};var z=new n,G=new n,V=new n,X=new n,W=new T(n.UNIT_X,0),H=new n;function k(e,t,r,i,a){var o=B(r,t,H),u=B(e,t,z),c=B(i,t,G),l=n.cross(o,u,X);l=n.normalize(l,l);var f=T.fromPointNormal(t,l,W),h=T.getPointDistance(f,i);if(s.equalsEpsilon(h,0,s.EPSILON7))return n.clone(l,a),a;a=n.add(c,u,a),a=n.normalize(a,a);var d=n.cross(o,a,V);return n.normalize(d,d),n.cross(d,o,a),n.normalize(a,a),n.dot(c,d)<0&&(a=n.negate(a,a)),a}var Y=T.fromPointNormal(n.ZERO,n.UNIT_Y),Z=new n,K=new n,J=new n,Q=new n,$=new n,ee=new n;N.createGeometry=function(a){var u,c,f,h,d,y=!a._scene3DOnly,_=a.loop,T=a._ellipsoid,w=a.granularity,g=new b[a._projectionIndex](T),v=a._positions,S=v.length;2===S&&(_=!1);var N=[v[0]];for(c=0;c<S-1;c++)f=v[c],h=v[c+1],d=O.lineSegmentPlane(f,h,Y,ee),!l(d)||n.equalsEpsilon(d,f,s.EPSILON7)||n.equalsEpsilon(d,h,s.EPSILON7)||N.push(n.clone(d)),N.push(h);_&&(f=v[S-1],h=v[0],d=O.lineSegmentPlane(f,h,Y,ee),!l(d)||n.equalsEpsilon(d,f,s.EPSILON7)||n.equalsEpsilon(d,h,s.EPSILON7)||N.push(n.clone(d)));var I=N.length,M=new Array(I);for(c=0;c<I;c++){var C=i.fromCartesian(N[c],T);C.height=0,M[c]=C}if(!((I=(M=t(M,i.equalsEpsilon)).length)<2)){var P=[],U=[],D=[],q=[],j=Z,z=K,G=J,V=Q,X=$,W=M[0],H=M[1];for(j=F(T,M[I-1],0,j),V=F(T,H,0,V),z=F(T,W,0,z),G=F(T,W,1e3,G),X=_?k(j,z,G,V,X):x(W,H,1e3,T,X),n.pack(X,U,0),n.pack(z,D,0),n.pack(G,q,0),P.push(W.latitude),P.push(W.longitude),L(W,H,0,1e3,w,T,U,D,q,P),c=1;c<I-1;++c){j=n.clone(z,j),z=n.clone(V,z);var te=M[c];F(T,te,1e3,G),F(T,M[c+1],0,V),k(j,z,G,V,X),u=U.length,n.pack(X,U,u),n.pack(z,D,u),n.pack(G,q,u),P.push(te.latitude),P.push(te.longitude),L(M[c],M[c+1],0,1e3,w,T,U,D,q,P)}var re=M[I-1],ne=M[I-2];if(z=F(T,re,0,z),G=F(T,re,1e3,G),_){var ae=M[0];X=k(j=F(T,ne,0,j),z,G,V=F(T,ae,0,V),X)}else X=x(ne,re,1e3,T,X);if(u=U.length,n.pack(X,U,u),n.pack(z,D,u),n.pack(G,q,u),P.push(re.latitude),P.push(re.longitude),_){for(L(re,W,0,1e3,w,T,U,D,q,P),u=U.length,c=0;c<3;++c)U[u+c]=U[c],D[u+c]=D[c],q[u+c]=q[c];P.push(W.latitude),P.push(W.longitude)}return function(t,i,a,u,c,l,f){var h,d,y,O,_,T,w=i._ellipsoid,g=a.length/3-1,b=8*g,v=4*b,S=36*g,N=b>65535?new Uint32Array(S):new Uint16Array(S),I=new Float64Array(3*b),M=new Float32Array(v),C=new Float32Array(v),x=new Float32Array(v),P=new Float32Array(v),U=new Float32Array(v);f&&(y=new Float32Array(v),O=new Float32Array(v),_=new Float32Array(v),T=new Float32Array(2*b));var D=l.length/2,q=0,L=ye;L.height=0;var j=me;j.height=0;var F=Ee,z=Oe;if(f)for(d=0,h=1;h<D;h++)L.latitude=l[d],L.longitude=l[d+1],j.latitude=l[d+2],j.longitude=l[d+3],F=i.project(L,F),z=i.project(j,z),q+=n.distance(F,z),d+=2;var G=u.length/3;z=n.unpack(u,0,z);var V,X=0;for(d=3,h=1;h<G;h++)F=n.clone(z,F),z=n.unpack(u,d,z),X+=n.distance(F,z),d+=3;d=3;var W=0,H=0,k=0,Y=0,Z=!1,K=n.unpack(a,0,Te),J=n.unpack(u,0,Oe),Q=n.unpack(c,0,Re);if(t){var $=n.unpack(a,a.length-6,_e);ie(Q,$,K,J)&&(Q=n.negate(Q,Q))}var ee=0,te=0,re=0;for(h=0;h<g;h++){var ne,ae,oe,ue,ce=n.clone(K,_e),le=n.clone(J,Ee),he=n.clone(Q,we);if(Z&&(he=n.negate(he,he)),K=n.unpack(a,d,Te),J=n.unpack(u,d,Oe),Q=n.unpack(c,d,Re),Z=ie(Q,ce,K,J),L.latitude=l[W],L.longitude=l[W+1],j.latitude=l[W+2],j.longitude=l[W+3],f){var Ye=pe(L,j);ne=i.project(L,Ie);var Ze=B(ae=i.project(j,Me),ne,ze);Ze.y=Math.abs(Ze.y),oe=Ce,ue=xe,0===Ye||n.dot(Ze,n.UNIT_Y)>A?(oe=se(i,L,he,ne,Ce),ue=se(i,j,Q,ae,xe)):1===Ye?(ue=se(i,j,Q,ae,xe),oe.x=0,oe.y=s.sign(L.longitude-Math.abs(j.longitude)),oe.z=0):(oe=se(i,L,he,ne,Ce),ue.x=0,ue.y=s.sign(L.longitude-j.longitude),ue.z=0)}var Ke=n.distance(le,J),Je=p.fromCartesian(ce,Fe),Qe=n.subtract(K,ce,Pe),$e=n.normalize(Qe,qe),et=n.subtract(le,ce,Ue);et=n.normalize(et,et);var tt=n.cross($e,et,qe);tt=n.normalize(tt,tt);var rt=n.cross(et,he,Le);rt=n.normalize(rt,rt);var nt=n.subtract(J,K,De);nt=n.normalize(nt,nt);var it=n.cross(Q,nt,je);it=n.normalize(it,it);var at,ot,ut,st=Ke/X,ct=ee/X,lt=0,ft=0,ht=0;if(f){lt=n.distance(ne,ae),at=p.fromCartesian(ne,Be),ot=n.subtract(ae,ne,ze);var dt=(ut=n.normalize(ot,Ge)).x;ut.x=ut.y,ut.y=-dt,ft=lt/q,ht=te/q}for(V=0;V<8;V++){var pt=Y+4*V,yt=H+2*V,mt=pt+3,Et=V<4?1:-1,Ot=2===V||3===V||6===V||7===V?1:-1;n.pack(Je.high,M,pt),M[mt]=Qe.x,n.pack(Je.low,C,pt),C[mt]=Qe.y,n.pack(rt,x,pt),x[mt]=Qe.z,n.pack(it,P,pt),P[mt]=st*Et,n.pack(tt,U,pt);var _t=ct*Ot;0===_t&&Ot<0&&(_t=Number.POSITIVE_INFINITY),U[mt]=_t,f&&(y[pt]=at.high.x,y[pt+1]=at.high.y,y[pt+2]=at.low.x,y[pt+3]=at.low.y,_[pt]=-oe.y,_[pt+1]=oe.x,_[pt+2]=ue.y,_[pt+3]=-ue.x,O[pt]=ot.x,O[pt+1]=ot.y,O[pt+2]=ut.x,O[pt+3]=ut.y,T[yt]=ft*Et,0==(_t=ht*Ot)&&Ot<0&&(_t=Number.POSITIVE_INFINITY),T[yt+1]=_t)}var Tt=Se,wt=Ne,Rt=ve,gt=Ae,bt=R.fromCartographicArray(ge,be),vt=e.getMinimumMaximumHeights(bt,w),At=vt.minimumTerrainHeight,St=vt.maximumTerrainHeight;re+=At,re+=St,fe(ce,le,At,St,Tt,Rt),fe(K,J,At,St,wt,gt);var Nt=n.multiplyByScalar(tt,s.EPSILON5,Ve);n.add(Tt,Nt,Tt),n.add(wt,Nt,wt),n.add(Rt,Nt,Rt),n.add(gt,Nt,gt),de(Tt,wt),de(Rt,gt),n.pack(Tt,I,k),n.pack(wt,I,k+3),n.pack(gt,I,k+6),n.pack(Rt,I,k+9),Nt=n.multiplyByScalar(tt,-2*s.EPSILON5,Ve),n.add(Tt,Nt,Tt),n.add(wt,Nt,wt),n.add(Rt,Nt,Rt),n.add(gt,Nt,gt),de(Tt,wt),de(Rt,gt),n.pack(Tt,I,k+12),n.pack(wt,I,k+15),n.pack(gt,I,k+18),n.pack(Rt,I,k+21),W+=2,d+=3,H+=16,k+=24,Y+=32,ee+=Ke,te+=lt}d=0;var It=0;for(h=0;h<g;h++){for(V=0;V<He;V++)N[d+V]=We[V]+It;It+=8,d+=He}var Mt=Xe;r.fromVertices(a,n.ZERO,3,Mt[0]),r.fromVertices(u,n.ZERO,3,Mt[1]);var Ct=r.fromBoundingSpheres(Mt);Ct.radius+=re/(2*g);var xt={position:new E({componentDatatype:o.DOUBLE,componentsPerAttribute:3,normalize:!1,values:I}),startHiAndForwardOffsetX:ke(M),startLoAndForwardOffsetY:ke(C),startNormalAndForwardOffsetZ:ke(x),endNormalAndTextureCoordinateNormalizationX:ke(P),rightNormalAndTextureCoordinateNormalizationY:ke(U)};return f&&(xt.startHiLo2D=ke(y),xt.offsetAndRight2D=ke(O),xt.startEndNormals2D=ke(_),xt.texcoordNormalization2D=new E({componentDatatype:o.FLOAT,componentsPerAttribute:2,normalize:!1,values:T})),new m({attributes:xt,indices:N,boundingSphere:Ct})}(_,g,D,q,U,P,y)}};var te=new n,re=new _,ne=new w;function ie(e,t,r,i){var a=B(r,t,te),o=n.dot(a,e);if(o>A||o<S){var u=B(i,r,H),c=o<S?s.PI_OVER_TWO:-s.PI_OVER_TWO,l=w.fromAxisAngle(u,c,ne),f=_.fromQuaternion(l,re);return _.multiplyByVector(f,e,e),!0}return!1}var ae=new i,oe=new n,ue=new n;function se(e,t,r,a,o){var u=i.toCartesian(t,e._ellipsoid,oe),c=n.add(u,r,ue),l=!1,f=e._ellipsoid,h=f.cartesianToCartographic(c,ae);Math.abs(t.longitude-h.longitude)>s.PI_OVER_TWO&&(l=!0,c=n.subtract(u,r,ue),h=f.cartesianToCartographic(c,ae)),h.height=0;var d=e.project(h,o);return(o=n.subtract(d,a,o)).z=0,o=n.normalize(o,o),l&&n.negate(o,o),o}var ce=new n,le=new n;function fe(e,t,r,i,a,o){var u=n.subtract(t,e,ce);n.normalize(u,u);var s=r-0,c=n.multiplyByScalar(u,s,le);n.add(e,c,a);var l=i-1e3;c=n.multiplyByScalar(u,l,le),n.add(t,c,o)}var he=new n;function de(e,t){var r=T.getPointDistance(Y,e),i=T.getPointDistance(Y,t),a=he;s.equalsEpsilon(r,0,s.EPSILON2)?(a=B(t,e,a),n.multiplyByScalar(a,s.EPSILON2,a),n.add(e,a,e)):s.equalsEpsilon(i,0,s.EPSILON2)&&(a=B(e,t,a),n.multiplyByScalar(a,s.EPSILON2,a),n.add(t,a,t))}function pe(e,t){var r=Math.abs(e.longitude),n=Math.abs(t.longitude);if(s.equalsEpsilon(r,s.PI,s.EPSILON11)){var i=s.sign(t.longitude);return e.longitude=i*(r-s.EPSILON11),1}if(s.equalsEpsilon(n,s.PI,s.EPSILON11)){var a=s.sign(e.longitude);return t.longitude=a*(n-s.EPSILON11),2}return 0}var ye=new i,me=new i,Ee=new n,Oe=new n,_e=new n,Te=new n,we=new n,Re=new n,ge=[ye,me],be=new R,ve=new n,Ae=new n,Se=new n,Ne=new n,Ie=new n,Me=new n,Ce=new n,xe=new n,Pe=new n,Ue=new n,De=new n,qe=new n,Le=new n,je=new n,Fe=new p,Be=new p,ze=new n,Ge=new n,Ve=new n,Xe=[new r,new r],We=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],He=We.length;function ke(e){return new E({componentDatatype:o.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}return N._projectNormal=se,N})),define("Workers/createGroundPolylineGeometry",["../Core/ApproximateTerrainHeights","../Core/defined","../Core/GroundPolylineGeometry"],(function(e,t,r){"use strict";return function(n,i){return e.initialize().then((function(){return t(i)&&(n=r.unpack(n,i)),r.createGeometry(n)}))}}));